/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.activation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.layer.activation.AbstractActivationLayer;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Where3;
import org.tensorflow.op.math.Greater;
import org.tensorflow.op.math.Mul;
import org.tensorflow.op.nn.Elu;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/activation/ELU;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/activation/AbstractActivationLayer;", "alpha", "", "name", "", "(FLjava/lang/String;)V", "getAlpha", "()F", "forward", "Lorg/tensorflow/Operand;", "tf", "Lorg/tensorflow/op/Ops;", "input", "toString", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nELU.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ELU.kt\norg/jetbrains/kotlinx/dl/api/core/layer/activation/ELU\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class ELU
extends AbstractActivationLayer {
    private final float alpha;

    public ELU(float alpha, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.alpha = alpha;
        if (!(this.alpha > 0.0f)) {
            boolean bl = false;
            String string = "Alpha " + this.alpha + " should be > 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ELU(float f, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            string = "";
        }
        this(f, string);
    }

    public final float getAlpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public Operand<Float> forward(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Operand operand;
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (this.alpha == 1.0f) {
            Elu elu = tf.nn.elu(input);
            Intrinsics.checkNotNullExpressionValue((Object)elu, (String)"tf.nn.elu(input)");
            operand = (Operand)elu;
        } else {
            Greater greaterThanZero = tf.math.greater(input, (Operand)tf.constant(0.0f));
            Mul scaledActivation = tf.math.mul((Operand)tf.constant(this.alpha), (Operand)tf.nn.elu(input));
            Where3 where3 = tf.where3((Operand)greaterThanZero, input, (Operand)scaledActivation);
            Intrinsics.checkNotNullExpressionValue((Object)where3, (String)"{\n            val greate\u2026aledActivation)\n        }");
            operand = (Operand)where3;
        }
        return operand;
    }

    @NotNull
    public String toString() {
        return "ELU(name = " + this.getName() + ", alpha=" + this.alpha + ')';
    }

    public ELU() {
        this(0.0f, null, 3, null);
    }
}

