/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.activation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.tensorflow.Operand;
import org.tensorflow.op.MathOps;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Where3;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.math.Greater;
import org.tensorflow.op.math.Minimum;
import org.tensorflow.op.math.Mul;
import org.tensorflow.op.math.Sub;
import org.tensorflow.op.nn.Relu;
import org.tensorflow.op.nn.Relu6;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aI\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00022\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"commonRelu", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "alpha", "maxValue", "threshold", "(Lorg/tensorflow/op/Ops;Lorg/tensorflow/Operand;FLjava/lang/Float;F)Lorg/tensorflow/Operand;", "tensorflow"})
public final class ActivationUtilsKt {
    @NotNull
    public static final Operand<Float> commonRelu(@NotNull Ops tf, @NotNull Operand<Float> input, float alpha, @Nullable Float maxValue, float threshold) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Operand input2 = input;
        Relu relu = tf.nn.relu(input2);
        Intrinsics.checkNotNullExpressionValue((Object)relu, (String)"tf.nn.relu(input2)");
        Operand negativePart = (Operand)relu;
        if (!(alpha == 0.0f)) {
            Operand operand;
            if (maxValue == null && threshold == 0.0f) {
                Greater greaterThanZero = tf.math.greater(input2, (Operand)tf.constant(0.0f));
                Mul negativeActivation = tf.math.mul((Operand)tf.constant(alpha), input2);
                Where3 where3 = tf.where3((Operand)greaterThanZero, input2, (Operand)negativeActivation);
                Intrinsics.checkNotNullExpressionValue((Object)where3, (String)"tf.where3(greaterThanZer\u2026put2, negativeActivation)");
                return (Operand)where3;
            }
            if (!(threshold == 0.0f)) {
                Relu relu2 = tf.nn.relu((Operand)tf.math.add((Operand)tf.math.mul(input2, (Operand)tf.constant(-1.0f)), (Operand)tf.constant(threshold)));
                Intrinsics.checkNotNullExpressionValue((Object)relu2, (String)"tf.nn.relu(tf.math.add(t\u2026 tf.constant(threshold)))");
                operand = (Operand)relu2;
            } else {
                Relu relu3 = tf.nn.relu((Operand)tf.math.mul(input2, (Operand)tf.constant(-1.0f)));
                Intrinsics.checkNotNullExpressionValue((Object)relu3, (String)"tf.nn.relu(tf.math.mul(i\u2026ut2, tf.constant(-1.0f)))");
                operand = (Operand)relu3;
            }
            negativePart = operand;
        }
        boolean clipMax = false;
        if (maxValue != null) {
            clipMax = true;
        }
        if (!(threshold == 0.0f)) {
            Mul mul = tf.math.mul(input2, (Operand)tf.dtypes.cast((Operand)tf.math.greater(input, (Operand)tf.constant(threshold)), DtypeConversionUtilKt.getDType(), new Cast.Options[0]));
            Intrinsics.checkNotNullExpressionValue((Object)mul, (String)"tf.math.mul(input2, tf.d\u2026threshold)), getDType()))");
            input2 = (Operand)mul;
        } else if (Intrinsics.areEqual((Float)maxValue, (float)6.0f)) {
            Relu6 relu6 = tf.nn.relu6(input2);
            Intrinsics.checkNotNullExpressionValue((Object)relu6, (String)"tf.nn.relu6(input2)");
            input2 = (Operand)relu6;
            clipMax = false;
        } else {
            Relu relu4 = tf.nn.relu(input2);
            Intrinsics.checkNotNullExpressionValue((Object)relu4, (String)"tf.nn.relu(input2)");
            input2 = (Operand)relu4;
        }
        if (clipMax) {
            MathOps mathOps = tf.math;
            Float f = maxValue;
            Intrinsics.checkNotNull((Object)f);
            Constant constant = tf.constant(f.floatValue());
            Intrinsics.checkNotNull((Object)constant, (String)"null cannot be cast to non-null type org.tensorflow.Operand<kotlin.Float>");
            Minimum minimum = mathOps.minimum((Operand)constant, (Operand)tf.math.maximum(input2, (Operand)tf.constant(0.0f)));
            Intrinsics.checkNotNullExpressionValue((Object)minimum, (String)"tf.math.minimum(tf.const\u2026put2, tf.constant(0.0f)))");
            input2 = (Operand)minimum;
        }
        if (!(alpha == 0.0f)) {
            Sub sub = tf.math.sub(input2, (Operand)tf.math.mul((Operand)tf.constant(alpha), negativePart));
            Intrinsics.checkNotNullExpressionValue((Object)sub, (String)"tf.math.sub(input2, tf.m\u2026nt(alpha), negativePart))");
            input2 = (Operand)sub;
        }
        return input2;
    }

    public static /* synthetic */ Operand commonRelu$default(Ops ops, Operand operand, float f, Float f2, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            f = 0.0f;
        }
        if ((n & 8) != 0) {
            f2 = null;
        }
        if ((n & 0x10) != 0) {
            f3 = 0.0f;
        }
        return ActivationUtilsKt.commonRelu(ops, (Operand<Float>)operand, f, f2, f3);
    }
}

