/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.GraphTrainableModel;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JH\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"H\u0016JB\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"H&J\"\u0010*\u001a\u00020\u00002\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000,\"\u00020\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010-R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0004R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "", "name", "", "(Ljava/lang/String;)V", "hasActivation", "", "getHasActivation", "()Z", "inboundLayers", "", "getInboundLayers", "()Ljava/util/List;", "setInboundLayers", "(Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "setName", "outboundLayers", "getOutboundLayers", "setOutboundLayers", "outputShape", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getOutputShape", "()Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "setOutputShape", "(Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;)V", "parentModel", "Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "getParentModel", "()Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "setParentModel", "(Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;)V", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "", "isTraining", "numberOfLosses", "invoke", "layers", "", "([Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;)Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "tensorflow"})
public abstract class Layer {
    @NotNull
    private String name;
    public TensorShape outputShape;
    @Nullable
    private GraphTrainableModel parentModel;
    @NotNull
    private List<Layer> inboundLayers;
    @NotNull
    private List<Layer> outboundLayers;

    public Layer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.inboundLayers = new ArrayList();
        this.outboundLayers = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final TensorShape getOutputShape() {
        TensorShape tensorShape = this.outputShape;
        if (tensorShape != null) {
            return tensorShape;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputShape");
        return null;
    }

    public final void setOutputShape(@NotNull TensorShape tensorShape) {
        Intrinsics.checkNotNullParameter((Object)tensorShape, (String)"<set-?>");
        this.outputShape = tensorShape;
    }

    @Nullable
    public final GraphTrainableModel getParentModel() {
        return this.parentModel;
    }

    public final void setParentModel(@Nullable GraphTrainableModel graphTrainableModel) {
        this.parentModel = graphTrainableModel;
    }

    @NotNull
    public final List<Layer> getInboundLayers() {
        return this.inboundLayers;
    }

    public final void setInboundLayers(@NotNull List<Layer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.inboundLayers = list;
    }

    @NotNull
    public final List<Layer> getOutboundLayers() {
        return this.outboundLayers;
    }

    public final void setOutboundLayers(@NotNull List<Layer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.outboundLayers = list;
    }

    @NotNull
    public abstract Operand<Float> build(@NotNull Ops var1, @NotNull Operand<Float> var2, @NotNull Operand<Boolean> var3, @Nullable Operand<Float> var4);

    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull List<? extends Operand<Float>> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
        return this.build(tf, (Operand<Float>)((Operand)CollectionsKt.first(input)), isTraining, numberOfLosses);
    }

    @NotNull
    public final Layer invoke(Layer ... layers) {
        Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
        this.inboundLayers = ArraysKt.toMutableList((Object[])layers);
        return this;
    }

    public abstract boolean getHasActivation();
}

