/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.initializer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.initializer.Initializer;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Identity;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.math.Add;
import org.tensorflow.op.math.Mul;
import org.tensorflow.op.random.StatelessRandomUniform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J<\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/initializer/RandomUniform;", "Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "maxVal", "", "minVal", "seed", "", "(FFJ)V", "getMaxVal", "()F", "getMinVal", "getSeed", "()J", "initialize", "Lorg/tensorflow/Operand;", "fanIn", "", "fanOut", "tf", "Lorg/tensorflow/op/Ops;", "shape", "name", "", "toString", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nRandomUniform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomUniform.kt\norg/jetbrains/kotlinx/dl/api/core/initializer/RandomUniform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class RandomUniform
extends Initializer {
    private final float maxVal;
    private final float minVal;
    private final long seed;

    public RandomUniform(float maxVal, float minVal, long seed) {
        this.maxVal = maxVal;
        this.minVal = minVal;
        this.seed = seed;
    }

    public /* synthetic */ RandomUniform(float f, float f2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            l = 12L;
        }
        this(f, f2, l);
    }

    public final float getMaxVal() {
        return this.maxVal;
    }

    public final float getMinVal() {
        return this.minVal;
    }

    public final long getSeed() {
        return this.seed;
    }

    @Override
    @NotNull
    public Operand<Float> initialize(int fanIn, int fanOut, @NotNull Ops tf, @NotNull Operand<Integer> shape, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(this.minVal <= this.maxVal)) {
            boolean $i$a$-require-RandomUniform$initialize$22 = false;
            String $i$a$-require-RandomUniform$initialize$22 = "The minVal parameter value must be less or equal than maxVal parameter value.";
            throw new IllegalArgumentException($i$a$-require-RandomUniform$initialize$22.toString());
        }
        long[] $i$a$-require-RandomUniform$initialize$22 = new long[]{this.seed, 0L};
        long[] seeds = $i$a$-require-RandomUniform$initialize$22;
        StatelessRandomUniform statelessRandomUniform = tf.random.statelessRandomUniform(shape, (Operand)tf.constant(seeds), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)statelessRandomUniform, (String)"tf.random.statelessRando\u2026stant(seeds), getDType())");
        Operand distOp = (Operand)statelessRandomUniform;
        if (this.minVal == 0.0f) {
            if (!(this.maxVal == 1.0f)) {
                Mul mul = tf.math.mul(distOp, (Operand)tf.constant(this.maxVal));
                Intrinsics.checkNotNullExpressionValue((Object)mul, (String)"tf.math.mul(distOp, tf.constant(maxVal))");
                distOp = (Operand)mul;
            }
        } else {
            Mul mul = tf.math.mul(distOp, (Operand)tf.dtypes.cast((Operand)tf.constant(this.maxVal - this.minVal), DtypeConversionUtilKt.getDType(), new Cast.Options[0]));
            Intrinsics.checkNotNullExpressionValue((Object)mul, (String)"tf.math.mul(distOp, tf.d\u2026l - minVal), getDType()))");
            distOp = (Operand)mul;
            Add add = tf.math.add(distOp, (Operand)tf.dtypes.cast((Operand)tf.constant(this.minVal), DtypeConversionUtilKt.getDType(), new Cast.Options[0]));
            Intrinsics.checkNotNullExpressionValue((Object)add, (String)"tf.math.add(distOp, tf.d\u2026ant(minVal), getDType()))");
            distOp = (Operand)add;
        }
        Identity identity = tf.withName(name).identity(distOp);
        Intrinsics.checkNotNullExpressionValue((Object)identity, (String)"tf.withName(name).identity(distOp)");
        return (Operand)identity;
    }

    @NotNull
    public String toString() {
        return "RandomUniform(maxVal=" + this.maxVal + ", minVal=" + this.minVal + ", seed=" + this.seed + ')';
    }

    public RandomUniform() {
        this(0.0f, 0.0f, 0L, 7, null);
    }
}

