/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.initializer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.initializer.Initializer;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.math.Add;
import org.tensorflow.op.math.Mul;
import org.tensorflow.op.random.StatelessRandomNormal;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J<\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/initializer/RandomNormal;", "Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "mean", "", "stdev", "seed", "", "(FFJ)V", "getMean", "()F", "getSeed", "()J", "getStdev", "initialize", "Lorg/tensorflow/Operand;", "fanIn", "", "fanOut", "tf", "Lorg/tensorflow/op/Ops;", "shape", "name", "", "toString", "tensorflow"})
public final class RandomNormal
extends Initializer {
    private final float mean;
    private final float stdev;
    private final long seed;

    public RandomNormal(float mean, float stdev, long seed) {
        this.mean = mean;
        this.stdev = stdev;
        this.seed = seed;
    }

    public /* synthetic */ RandomNormal(float f, float f2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        if ((n & 4) != 0) {
            l = 12L;
        }
        this(f, f2, l);
    }

    public final float getMean() {
        return this.mean;
    }

    public final float getStdev() {
        return this.stdev;
    }

    public final long getSeed() {
        return this.seed;
    }

    @Override
    @NotNull
    public Operand<Float> initialize(int fanIn, int fanOut, @NotNull Ops tf, @NotNull Operand<Integer> shape, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long[] lArray = new long[]{this.seed, 0L};
        long[] seeds = lArray;
        StatelessRandomNormal statelessRandomNormal = tf.random.statelessRandomNormal(shape, (Operand)tf.constant(seeds));
        Intrinsics.checkNotNullExpressionValue((Object)statelessRandomNormal, (String)"tf.random.statelessRando\u2026hape, tf.constant(seeds))");
        Operand distOp = (Operand)statelessRandomNormal;
        Mul mul = tf.math.mul(distOp, (Operand)tf.constant(this.stdev));
        Intrinsics.checkNotNullExpressionValue((Object)mul, (String)"tf.math.mul(distOp, tf.constant(stdev))");
        Operand op = (Operand)mul;
        Add add = tf.withName((String)name).math.add(op, (Operand)tf.constant(this.mean));
        Intrinsics.checkNotNullExpressionValue((Object)add, (String)"tf.withName(name).math.add(op, tf.constant(mean))");
        return (Operand)add;
    }

    @NotNull
    public String toString() {
        return "RandomNormal(mean=" + this.mean + ", stdev=" + this.stdev + ", seed=" + this.seed + ')';
    }

    public RandomNormal() {
        this(0.0f, 0.0f, 0L, 7, null);
    }
}

