/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.history.BatchTrainingEvent;
import org.jetbrains.kotlinx.dl.api.core.history.EpochTrainingEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\nH\u0002J,\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\fJ\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0005JC\u0010 \u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\f2\b\u0010!\u001a\u0004\u0018\u00010\u001d2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\f\u00a2\u0006\u0002\u0010#J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0007J\u001c\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\u0005J\u0006\u0010'\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR(\u0010\u0011\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/history/TrainingHistory;", "", "()V", "_batchHistory", "", "Lorg/jetbrains/kotlinx/dl/api/core/history/BatchTrainingEvent;", "_epochHistory", "Lorg/jetbrains/kotlinx/dl/api/core/history/EpochTrainingEvent;", "_historyByEpoch", "Ljava/util/TreeMap;", "", "batchHistory", "", "getBatchHistory", "()Ljava/util/List;", "epochHistory", "getEpochHistory", "historyByEpochAndBatch", "addNewBatchEvent", "", "newEventBatch", "epoch", "batch", "addNewEpochEvent", "newEventEpoch", "appendBatch", "epochIndex", "batchIndex", "lossValue", "", "metricValues", "batchTrainingEvent", "appendEpoch", "valLossValue", "valMetricValues", "(IDLjava/util/List;Ljava/lang/Double;Ljava/util/List;)V", "epochTrainingEvent", "eventsByEpoch", "lastBatchEvent", "lastEpochEvent", "tensorflow"})
public final class TrainingHistory {
    @NotNull
    private final List<BatchTrainingEvent> _batchHistory = new ArrayList();
    @NotNull
    private final TreeMap<Integer, TreeMap<Integer, BatchTrainingEvent>> historyByEpochAndBatch = new TreeMap();
    @NotNull
    private final List<EpochTrainingEvent> _epochHistory = new ArrayList();
    @NotNull
    private final TreeMap<Integer, EpochTrainingEvent> _historyByEpoch = new TreeMap();

    @NotNull
    public final List<BatchTrainingEvent> getBatchHistory() {
        List<BatchTrainingEvent> list = Collections.unmodifiableList(this._batchHistory);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(_batchHistory)");
        return list;
    }

    @NotNull
    public final List<EpochTrainingEvent> getEpochHistory() {
        List<EpochTrainingEvent> list = Collections.unmodifiableList(this._epochHistory);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(_epochHistory)");
        return list;
    }

    public final void appendBatch(int epochIndex, int batchIndex, double lossValue, @NotNull List<Double> metricValues) {
        Intrinsics.checkNotNullParameter(metricValues, (String)"metricValues");
        BatchTrainingEvent newEvent = new BatchTrainingEvent(epochIndex, batchIndex, lossValue, metricValues);
        this.addNewBatchEvent(newEvent, epochIndex, batchIndex);
    }

    public final void appendBatch(@NotNull BatchTrainingEvent batchTrainingEvent) {
        Intrinsics.checkNotNullParameter((Object)batchTrainingEvent, (String)"batchTrainingEvent");
        this.addNewBatchEvent(batchTrainingEvent, batchTrainingEvent.getEpochIndex(), batchTrainingEvent.getBatchIndex());
    }

    public final void appendEpoch(int epochIndex, double lossValue, @NotNull List<Double> metricValues, @Nullable Double valLossValue, @Nullable List<Double> valMetricValues) {
        Intrinsics.checkNotNullParameter(metricValues, (String)"metricValues");
        EpochTrainingEvent newEvent = new EpochTrainingEvent(epochIndex, lossValue, metricValues, valLossValue, valMetricValues);
        this.addNewEpochEvent(newEvent, epochIndex);
    }

    public final void appendEpoch(@NotNull EpochTrainingEvent epochTrainingEvent) {
        Intrinsics.checkNotNullParameter((Object)epochTrainingEvent, (String)"epochTrainingEvent");
        this.addNewEpochEvent(epochTrainingEvent, epochTrainingEvent.getEpochIndex());
    }

    private final void addNewBatchEvent(BatchTrainingEvent newEventBatch, int epoch, int batch) {
        this._batchHistory.add(newEventBatch);
        if (this.historyByEpochAndBatch.containsKey(epoch)) {
            TreeMap<Integer, BatchTrainingEvent> historyByEpoch = this.historyByEpochAndBatch.get(epoch);
            Integer n = batch;
            TreeMap<Integer, BatchTrainingEvent> treeMap = historyByEpoch;
            Intrinsics.checkNotNull(treeMap);
            ((Map)treeMap).put(n, newEventBatch);
        } else {
            TreeMap historyByEpoch = new TreeMap();
            Integer n = batch;
            ((Map)historyByEpoch).put(n, newEventBatch);
            n = epoch;
            ((Map)this.historyByEpochAndBatch).put(n, historyByEpoch);
        }
    }

    private final void addNewEpochEvent(EpochTrainingEvent newEventEpoch, int epoch) {
        this._epochHistory.add(newEventEpoch);
        Integer n = epoch;
        ((Map)this._historyByEpoch).put(n, newEventEpoch);
    }

    @NotNull
    public final BatchTrainingEvent lastBatchEvent() {
        TreeMap<Integer, BatchTrainingEvent> treeMap = this.historyByEpochAndBatch.lastEntry().getValue();
        Intrinsics.checkNotNull(treeMap);
        BatchTrainingEvent batchTrainingEvent = treeMap.lastEntry().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)batchTrainingEvent, (String)"historyByEpochAndBatch.l\u2026value!!.lastEntry().value");
        return batchTrainingEvent;
    }

    @NotNull
    public final EpochTrainingEvent lastEpochEvent() {
        EpochTrainingEvent epochTrainingEvent = this._historyByEpoch.lastEntry().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)epochTrainingEvent, (String)"_historyByEpoch.lastEntry().value");
        return epochTrainingEvent;
    }

    @Nullable
    public final TreeMap<Integer, BatchTrainingEvent> eventsByEpoch(int epochIndex) {
        return this.historyByEpochAndBatch.get(epochIndex);
    }
}

