/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.history.BatchEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\u0002J$\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/history/History;", "", "()V", "history", "", "Lorg/jetbrains/kotlinx/dl/api/core/history/BatchEvent;", "historyByBatch", "Ljava/util/TreeMap;", "", "addNewBatchEvent", "", "batchEvent", "batchIndex", "appendBatch", "batch", "lossValue", "", "metricValues", "", "lastBatchEvent", "tensorflow"})
public final class History {
    @NotNull
    private final List<BatchEvent> history = new ArrayList();
    @NotNull
    private final TreeMap<Integer, BatchEvent> historyByBatch = new TreeMap();

    public final void appendBatch(int batch, double lossValue, @NotNull List<Double> metricValues) {
        Intrinsics.checkNotNullParameter(metricValues, (String)"metricValues");
        BatchEvent newEvent = new BatchEvent(batch, lossValue, metricValues);
        this.addNewBatchEvent(newEvent, batch);
    }

    public final void appendBatch(@NotNull BatchEvent batchEvent) {
        Intrinsics.checkNotNullParameter((Object)batchEvent, (String)"batchEvent");
        this.addNewBatchEvent(batchEvent, batchEvent.getBatchIndex());
    }

    private final void addNewBatchEvent(BatchEvent batchEvent, int batchIndex) {
        this.history.add(batchEvent);
        Integer n = batchIndex;
        ((Map)this.historyByBatch).put(n, batchEvent);
    }

    @NotNull
    public final BatchEvent lastBatchEvent() {
        BatchEvent batchEvent = this.historyByBatch.lastEntry().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)batchEvent, (String)"historyByBatch.lastEntry().value");
        return batchEvent;
    }
}

