/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.callback;

import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.callback.Callback;
import org.jetbrains.kotlinx.dl.api.core.callback.EarlyStopping;
import org.jetbrains.kotlinx.dl.api.core.callback.EarlyStoppingMode;
import org.jetbrains.kotlinx.dl.api.core.history.EpochTrainingEvent;
import org.jetbrains.kotlinx.dl.api.core.history.TrainingHistory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BY\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00042\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u001dH\u0016R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/callback/EarlyStopping;", "Lorg/jetbrains/kotlinx/dl/api/core/callback/Callback;", "monitor", "Lkotlin/reflect/KProperty1;", "Lorg/jetbrains/kotlinx/dl/api/core/history/EpochTrainingEvent;", "", "minDelta", "patience", "", "verbose", "", "mode", "Lorg/jetbrains/kotlinx/dl/api/core/callback/EarlyStoppingMode;", "baseline", "restoreBestWeights", "(Lkotlin/reflect/KProperty1;DIZLorg/jetbrains/kotlinx/dl/api/core/callback/EarlyStoppingMode;DZ)V", "best", "monitorGreater", "monitorOp", "Ljava/util/function/BiFunction;", "", "stoppedEpoch", "wait", "getMonitorValue", "logs", "onEpochEnd", "", "epoch", "event", "Lorg/jetbrains/kotlinx/dl/api/core/history/TrainingHistory;", "onTrainBegin", "onTrainEnd", "tensorflow"})
public final class EarlyStopping
extends Callback {
    @NotNull
    private KProperty1<EpochTrainingEvent, Double> monitor;
    private double minDelta;
    private int patience;
    private boolean verbose;
    @NotNull
    private EarlyStoppingMode mode;
    private double baseline;
    private final boolean restoreBestWeights;
    private int wait;
    private int stoppedEpoch;
    private double best;
    private boolean monitorGreater;
    @Nullable
    private BiFunction<Number, Number, Boolean> monitorOp;

    public EarlyStopping(@NotNull KProperty1<EpochTrainingEvent, Double> monitor, double minDelta, int patience, boolean verbose, @NotNull EarlyStoppingMode mode, double baseline, boolean restoreBestWeights) {
        Intrinsics.checkNotNullParameter(monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.monitor = monitor;
        this.minDelta = minDelta;
        this.patience = patience;
        this.verbose = verbose;
        this.mode = mode;
        this.baseline = baseline;
        this.restoreBestWeights = restoreBestWeights;
        if (!(this.minDelta >= 0.0 && this.baseline >= 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                this.monitorOp = EarlyStopping::_init_$lambda$0;
                this.minDelta *= -1.0;
                this.best = Double.MAX_VALUE;
                break;
            }
            case 2: {
                this.monitorOp = EarlyStopping::_init_$lambda$1;
                this.monitorGreater = true;
                this.best = Double.MIN_VALUE;
                break;
            }
            default: {
                if (Intrinsics.areEqual(this.monitor, (Object)((Object)4.INSTANCE)) || Intrinsics.areEqual(this.monitor, (Object)((Object)5.INSTANCE))) {
                    this.monitorOp = EarlyStopping::_init_$lambda$2;
                    this.monitorGreater = true;
                    this.best = Double.MAX_VALUE;
                    break;
                }
                this.monitorOp = EarlyStopping::_init_$lambda$3;
                this.minDelta *= -1.0;
                this.best = Double.MIN_VALUE;
            }
        }
    }

    public /* synthetic */ EarlyStopping(KProperty1 kProperty1, double d, int n, boolean bl, EarlyStoppingMode earlyStoppingMode, double d2, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            kProperty1 = (KProperty1)1.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            d = 0.0;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            earlyStoppingMode = EarlyStoppingMode.AUTO;
        }
        if ((n2 & 0x20) != 0) {
            d2 = 0.001;
        }
        if ((n2 & 0x40) != 0) {
            bl2 = false;
        }
        this((KProperty1<EpochTrainingEvent, Double>)kProperty1, d, n, bl, earlyStoppingMode, d2, bl2);
    }

    @Override
    public void onTrainBegin() {
        this.wait = 0;
        this.stoppedEpoch = 0;
        this.best = this.baseline;
    }

    @Override
    public void onEpochEnd(int epoch, @NotNull EpochTrainingEvent event, @NotNull TrainingHistory logs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)logs, (String)"logs");
        Number number = this.getMonitorValue(event, this.monitor);
        if (number == null) {
            return;
        }
        Number current = number;
        BiFunction<Number, Number, Boolean> biFunction = this.monitorOp;
        if (biFunction == null) {
            return;
        }
        Boolean bl = biFunction.apply(current.doubleValue() - this.minDelta, this.best);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"monitorOp ?: return).app\u2026ouble() - minDelta, best)");
        if (bl.booleanValue()) {
            this.best = current.doubleValue();
            this.wait = 0;
        } else {
            int n = this.wait;
            this.wait = n + 1;
            if (this.wait > this.patience) {
                this.stoppedEpoch = epoch;
                this.getModel$tensorflow().setStopTraining(true);
                if (this.restoreBestWeights && this.verbose) {
                    this.getModel$tensorflow().getLogger().info((Function0)onEpochEnd.1.INSTANCE);
                }
            }
        }
    }

    @Override
    public void onTrainEnd(@NotNull TrainingHistory logs) {
        Intrinsics.checkNotNullParameter((Object)logs, (String)"logs");
        if (this.stoppedEpoch > 0 && this.verbose) {
            this.getModel$tensorflow().getLogger().info((Function0)new Function0<Object>(this){
                final /* synthetic */ EarlyStopping this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Epoch " + (EarlyStopping.access$getStoppedEpoch$p(this.this$0) + 1) + ": early stopping event! ";
                }
            });
        }
    }

    private final Number getMonitorValue(EpochTrainingEvent logs, KProperty1<EpochTrainingEvent, Double> monitor) {
        Double monitorValue = (Double)monitor.get((Object)logs);
        if (monitorValue == null) {
            this.getModel$tensorflow().getLogger().warn((Function0)new Function0<Object>(monitor, logs){
                final /* synthetic */ KProperty1<EpochTrainingEvent, Double> $monitor;
                final /* synthetic */ EpochTrainingEvent $logs;
                {
                    this.$monitor = $monitor;
                    this.$logs = $logs;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Early stopping conditioned on metric " + this.$monitor + " which is not available. Available metrics are: " + this.$logs;
                }
            });
        }
        return monitorValue;
    }

    private static final Boolean _init_$lambda$0(Number a, Number b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.doubleValue() < b.doubleValue();
    }

    private static final Boolean _init_$lambda$1(Number a, Number b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.doubleValue() > b.doubleValue();
    }

    private static final Boolean _init_$lambda$2(Number a, Number b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.doubleValue() > b.doubleValue();
    }

    private static final Boolean _init_$lambda$3(Number a, Number b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.doubleValue() < b.doubleValue();
    }

    public EarlyStopping() {
        this(null, 0.0, 0, false, null, 0.0, false, 127, null);
    }

    public static final /* synthetic */ int access$getStoppedEpoch$p(EarlyStopping $this) {
        return $this.stoppedEpoch;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EarlyStoppingMode.values().length];
            try {
                nArray[EarlyStoppingMode.MIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EarlyStoppingMode.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

