/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.activation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.activation.Activation;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Where3;
import org.tensorflow.op.math.Add;
import org.tensorflow.op.math.Mul;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/activation/SoftShrinkActivation;", "Lorg/jetbrains/kotlinx/dl/api/core/activation/Activation;", "lower", "", "upper", "(FF)V", "getLower", "()F", "getUpper", "apply", "Lorg/tensorflow/Operand;", "tf", "Lorg/tensorflow/op/Ops;", "features", "tensorflow"})
public final class SoftShrinkActivation
implements Activation {
    private final float lower;
    private final float upper;

    public SoftShrinkActivation(float lower, float upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public /* synthetic */ SoftShrinkActivation(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = -0.5f;
        }
        if ((n & 2) != 0) {
            f2 = 0.5f;
        }
        this(f, f2);
    }

    public final float getLower() {
        return this.lower;
    }

    public final float getUpper() {
        return this.upper;
    }

    @Override
    @NotNull
    public Operand<Float> apply(@NotNull Ops tf, @NotNull Operand<Float> features) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        if (!(this.lower < this.upper && this.lower < 0.0f && this.upper > 0.0f)) {
            boolean $i$a$-require-SoftShrinkActivation$apply$22 = false;
            String $i$a$-require-SoftShrinkActivation$apply$22 = "The boundary values have to be non zero and the lower bound has to be lower as the upper";
            throw new IllegalArgumentException($i$a$-require-SoftShrinkActivation$apply$22.toString());
        }
        Mul zeros = tf.math.mul(features, (Operand)tf.constant(0.0f));
        Where3 valuesBelowLower = tf.where3((Operand)tf.math.less(features, (Operand)tf.constant(this.lower)), (Operand)tf.math.sub(features, (Operand)tf.constant(this.lower)), (Operand)zeros);
        Where3 valuesAboveUpper = tf.where3((Operand)tf.math.less((Operand)tf.constant(this.upper), features), (Operand)tf.math.sub(features, (Operand)tf.constant(this.upper)), (Operand)zeros);
        Add add = tf.math.add((Operand)valuesBelowLower, (Operand)valuesAboveUpper);
        Intrinsics.checkNotNullExpressionValue((Object)add, (String)"tf.math.add(valuesBelowLower, valuesAboveUpper)");
        return (Operand)add;
    }

    @Override
    @NotNull
    public Operand<Float> apply(@NotNull Ops tf, @NotNull Operand<Float> features, @NotNull String name) {
        return Activation.DefaultImpls.apply(this, tf, features, name);
    }

    public SoftShrinkActivation() {
        this(0.0f, 0.0f, 3, null);
    }
}

