/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.GraphTrainableModel;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.LayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.WeightsKt;
import org.jetbrains.kotlinx.dl.api.core.layer.core.Input;
import org.jetbrains.kotlinx.dl.api.inference.keras.ModelLoaderKt;
import org.jetbrains.kotlinx.dl.api.inference.keras.ModelSaverKt;
import org.jetbrains.kotlinx.dl.api.inference.keras.config.KerasModel;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.core.Placeholder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J<\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\nH\u0014J\u001a\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/Sequential;", "Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "layers", "", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "([Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;)V", "buildLayers", "Lkotlin/Pair;", "Lorg/tensorflow/op/core/Placeholder;", "", "Lorg/tensorflow/Operand;", "training", "", "numberOfLosses", "copy", "saveOptimizerState", "copyWeights", "Companion", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nSequential.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sequential.kt\norg/jetbrains/kotlinx/dl/api/core/Sequential\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n766#2:186\n857#2,2:187\n1855#2,2:189\n1855#2,2:191\n*S KotlinDebug\n*F\n+ 1 Sequential.kt\norg/jetbrains/kotlinx/dl/api/core/Sequential\n*L\n153#1:186\n153#1:187,2\n153#1:189,2\n175#1:191,2\n*E\n"})
public final class Sequential
extends GraphTrainableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public Sequential(Layer ... layers) {
        Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
        super(Arrays.copyOf(layers, layers.length));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Pair<Placeholder<Float>, Operand<Float>> buildLayers(@NotNull Operand<Boolean> training, @NotNull Operand<Float> numberOfLosses) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(training, (String)"training");
        Intrinsics.checkNotNullParameter(numberOfLosses, (String)"numberOfLosses");
        Placeholder<Float> input = this.getInputLayer().build(this.getTf());
        Layer layer = this.getInputLayer();
        Shape shape = input.asOutput().shape();
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"input.asOutput().shape()");
        LayerKt.setOutputShape(layer, shape);
        Placeholder<Float> output = null;
        output = input;
        Iterable $this$filter$iv = this.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Layer it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof Input))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Layer layer2 = (Layer)element$iv;
            boolean bl = false;
            output = layer2.build(this.getTf(), (Operand<Float>)((Operand)output), training, this.getNumberOfLossesOp());
            Shape shape2 = output.asOutput().shape();
            Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"output.asOutput().shape()");
            LayerKt.setOutputShape(layer2, shape2);
        }
        return TuplesKt.to(input, output);
    }

    @NotNull
    public final Sequential copy(boolean saveOptimizerState, boolean copyWeights) {
        KerasModel serializedModel = ModelSaverKt.serializeModel(this, true);
        Sequential deserializedModel = ModelLoaderKt.deserializeSequentialModel$default(serializedModel, null, 2, null);
        if (!copyWeights) {
            return deserializedModel;
        }
        deserializedModel.compile(this.getOptimizer(), this.getLoss(), this.getMetrics());
        Iterable $this$forEach$iv = deserializedModel.getLayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Layer it = (Layer)element$iv;
            boolean bl = false;
            WeightsKt.setWeights(it, WeightsKt.getWeights(this.getLayer(it.getName())));
        }
        deserializedModel.setModelInitialized$tensorflow(true);
        return deserializedModel;
    }

    public static /* synthetic */ Sequential copy$default(Sequential sequential2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return sequential2.copy(bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final Sequential of(@NotNull Layer[] layers, boolean noInput) {
        return Companion.of(layers, noInput);
    }

    @JvmStatic
    @NotNull
    public static final Sequential of(@NotNull List<? extends Layer> layers, boolean noInput) {
        return Companion.of(layers, noInput);
    }

    @JvmStatic
    @NotNull
    public static final Sequential loadModelConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
        return Companion.loadModelConfiguration(configuration, inputShape);
    }

    @JvmStatic
    @NotNull
    public static final Pair<Input, List<Layer>> loadModelLayersFromConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
        return Companion.loadModelLayersFromConfiguration(configuration, inputShape);
    }

    @JvmStatic
    @NotNull
    public static final Sequential loadDefaultModelConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
        return Companion.loadDefaultModelConfiguration(modelDirectory, inputShape);
    }

    @JvmStatic
    @NotNull
    public static final Pair<Input, List<Layer>> loadModelLayersFromDefaultConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
        return Companion.loadModelLayersFromDefaultConfiguration(modelDirectory, inputShape);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u001c\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J.\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J.\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J+\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0013\"\u00020\u000f2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J \u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/Sequential$Companion;", "", "()V", "loadDefaultModelConfiguration", "Lorg/jetbrains/kotlinx/dl/api/core/Sequential;", "modelDirectory", "Ljava/io/File;", "inputShape", "", "loadModelConfiguration", "configuration", "loadModelLayersFromConfiguration", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/core/Input;", "", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "loadModelLayersFromDefaultConfiguration", "of", "layers", "", "noInput", "", "([Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;Z)Lorg/jetbrains/kotlinx/dl/api/core/Sequential;", "tensorflow"})
    @SourceDebugExtension(value={"SMAP\nSequential.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sequential.kt\norg/jetbrains/kotlinx/dl/api/core/Sequential$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n37#2,2:186\n37#2,2:188\n1#3:190\n*S KotlinDebug\n*F\n+ 1 Sequential.kt\norg/jetbrains/kotlinx/dl/api/core/Sequential$Companion\n*L\n64#1:186,2\n65#1:188,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Sequential of(@NotNull Layer[] layers, boolean noInput) {
            Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
            if (!noInput) {
                GraphTrainableModel.Companion.layerValidation$tensorflow(ArraysKt.toList((Object[])layers));
            }
            GraphTrainableModel.Companion.preProcessLayerNames$tensorflow(layers);
            return new Sequential(Arrays.copyOf(layers, layers.length));
        }

        public static /* synthetic */ Sequential of$default(Companion companion, Layer[] layerArray, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.of(layerArray, bl);
        }

        @JvmStatic
        @NotNull
        public final Sequential of(@NotNull List<? extends Layer> layers, boolean noInput) {
            Intrinsics.checkNotNullParameter(layers, (String)"layers");
            if (!noInput) {
                GraphTrainableModel.Companion.layerValidation$tensorflow(CollectionsKt.toList((Iterable)layers));
            }
            Collection $this$toTypedArray$iv = layers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            GraphTrainableModel.Companion.preProcessLayerNames$tensorflow(thisCollection$iv.toArray(new Layer[0]));
            Collection $this$toTypedArray$iv2 = layers;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            Layer[] layerArray = thisCollection$iv2.toArray(new Layer[0]);
            return new Sequential(Arrays.copyOf(layerArray, layerArray.length));
        }

        public static /* synthetic */ Sequential of$default(Companion companion, List list, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.of(list, bl);
        }

        @JvmStatic
        @NotNull
        public final Sequential loadModelConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (!configuration.isFile()) {
                boolean bl = false;
                String string = configuration.getAbsolutePath() + " is not a file. Should be a .json file with configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            return ModelLoaderKt.loadSequentialModelConfiguration(configuration, inputShape);
        }

        public static /* synthetic */ Sequential loadModelConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadModelConfiguration(file, nArray);
        }

        @JvmStatic
        @NotNull
        public final Pair<Input, List<Layer>> loadModelLayersFromConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (!configuration.isFile()) {
                boolean bl = false;
                String string = configuration.getAbsolutePath() + " is not a file. Should be a .json file with configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            KerasModel config = ModelLoaderKt.loadSerializedModel(configuration);
            return ModelLoaderKt.loadSequentialModelLayers(config, inputShape);
        }

        public static /* synthetic */ Pair loadModelLayersFromConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadModelLayersFromConfiguration(file, nArray);
        }

        @JvmStatic
        @NotNull
        public final Sequential loadDefaultModelConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
            if (!modelDirectory.isDirectory()) {
                boolean bl = false;
                String string = modelDirectory.getAbsolutePath() + " is not a directory. Should be a directory with a 'modelConfig.json' file with configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            File configuration = new File(modelDirectory.getAbsolutePath() + "/modelConfig.json");
            if (!configuration.exists()) {
                throw new FileNotFoundException("File 'modelConfig.json' is not found. This file must be in the model directory. It is generated during Sequential model saving with SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.");
            }
            return ModelLoaderKt.loadSequentialModelConfiguration(configuration, inputShape);
        }

        public static /* synthetic */ Sequential loadDefaultModelConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadDefaultModelConfiguration(file, nArray);
        }

        @JvmStatic
        @NotNull
        public final Pair<Input, List<Layer>> loadModelLayersFromDefaultConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
            if (!modelDirectory.isDirectory()) {
                boolean $i$a$-require-Sequential$Companion$loadModelLayersFromDefaultConfiguration$22 = false;
                String $i$a$-require-Sequential$Companion$loadModelLayersFromDefaultConfiguration$22 = modelDirectory.getAbsolutePath() + " is not a directory. Should be a directory with a 'modelConfig.json' file with configuration.";
                throw new IllegalArgumentException($i$a$-require-Sequential$Companion$loadModelLayersFromDefaultConfiguration$22.toString());
            }
            File configuration = new File(modelDirectory.getAbsolutePath() + "/modelConfig.json");
            if (!configuration.exists()) {
                throw new FileNotFoundException("File 'modelConfig.json' is not found. This file must be in the model directory. It is generated during Sequential model saving with SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.");
            }
            KerasModel config = ModelLoaderKt.loadSerializedModel(configuration);
            return ModelLoaderKt.loadSequentialModelLayers(config, inputShape);
        }

        public static /* synthetic */ Pair loadModelLayersFromDefaultConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadModelLayersFromDefaultConfiguration(file, nArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

