/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Session;
import org.tensorflow.op.core.Assign;
import org.tensorflow.op.core.AssignAdd;
import org.tensorflow.op.core.Variable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0014\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fJ\u0012\u0010 \u001a\u00020\u001c2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0011J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u0006H\u0002J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&J\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130'J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020\u0006H\u0016J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060'R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "Ljava/lang/AutoCloseable;", "graphDef", "", "([B)V", "prefix", "", "([BLjava/lang/String;)V", "isClosed", "", "()Z", "setClosed", "(Z)V", "optimizerAssignAddInitializers", "", "Lorg/tensorflow/op/core/AssignAdd;", "optimizerInitializers", "Lorg/tensorflow/op/core/Assign;", "optimizerVariables", "Lorg/tensorflow/op/core/Variable;", "", "tfGraph", "Lorg/tensorflow/Graph;", "getTfGraph$tensorflow", "()Lorg/tensorflow/Graph;", "setTfGraph$tensorflow", "(Lorg/tensorflow/Graph;)V", "addOptimizerVariable", "", "variable", "addOptimizerVariableAssignAddInitializer", "initializer", "addOptimizerVariableInitializer", "close", "convertGraphDefToString", "copy", "initializeOptimizerVariables", "session", "Lorg/tensorflow/Session;", "", "runAssignAddOpsForOptimizers", "toString", "variableNames", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nKGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KGraph.kt\norg/jetbrains/kotlinx/dl/api/core/KGraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1#2:156\n1855#3,2:157\n1855#3,2:159\n*S KotlinDebug\n*F\n+ 1 KGraph.kt\norg/jetbrains/kotlinx/dl/api/core/KGraph\n*L\n134#1:157,2\n148#1:159,2\n*E\n"})
public final class KGraph
implements AutoCloseable {
    @NotNull
    private Graph tfGraph;
    private boolean isClosed;
    @NotNull
    private final List<Assign<?>> optimizerInitializers;
    @NotNull
    private final List<AssignAdd<?>> optimizerAssignAddInitializers;
    @NotNull
    private final List<Variable<Float>> optimizerVariables;

    public KGraph(@NotNull byte[] graphDef, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)graphDef, (String)"graphDef");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.tfGraph = new Graph();
        this.optimizerInitializers = new ArrayList();
        this.optimizerAssignAddInitializers = new ArrayList();
        this.optimizerVariables = new ArrayList();
        if (((CharSequence)prefix).length() == 0) {
            this.tfGraph.importGraphDef(graphDef);
        } else {
            this.tfGraph.importGraphDef(graphDef, prefix);
        }
    }

    public KGraph(@NotNull byte[] graphDef) {
        Intrinsics.checkNotNullParameter((Object)graphDef, (String)"graphDef");
        this(graphDef, "");
    }

    @NotNull
    public final Graph getTfGraph$tensorflow() {
        return this.tfGraph;
    }

    public final void setTfGraph$tensorflow(@NotNull Graph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"<set-?>");
        this.tfGraph = graph;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.tfGraph.close();
    }

    @NotNull
    public String toString() {
        return this.convertGraphDefToString();
    }

    private final String convertGraphDefToString() {
        Iterator operations = this.tfGraph.operations();
        String s = "";
        while (operations.hasNext()) {
            Object e = operations.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.tensorflow.GraphOperation");
            GraphOperation operation = (GraphOperation)e;
            s = s + "Name: " + operation.name() + "; Type: " + operation.type() + "; Out #tensors:  " + operation.numOutputs() + '\n';
        }
        return s;
    }

    @NotNull
    public final List<String> variableNames() {
        Iterator operations = this.tfGraph.operations();
        List variableNames = new ArrayList();
        while (operations.hasNext()) {
            Object e = operations.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.tensorflow.GraphOperation");
            GraphOperation operation = (GraphOperation)e;
            if (!operation.type().equals("VariableV2")) continue;
            String string = operation.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"operation.name()");
            variableNames.add(string);
        }
        return CollectionsKt.toList((Iterable)variableNames);
    }

    @NotNull
    public final KGraph copy() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "The copied graph and model are closed and could not be reused!";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] byArray = this.tfGraph.toGraphDef();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"tfGraph.toGraphDef()");
        return new KGraph(byArray);
    }

    public final void addOptimizerVariable(@NotNull Variable<Float> variable) {
        Intrinsics.checkNotNullParameter(variable, (String)"variable");
        if (!(!this.optimizerVariables.contains(variable))) {
            boolean bl = false;
            String string = variable + " is added to graph already. Analyze and fix the static graph building process.";
            throw new IllegalStateException(string.toString());
        }
        this.optimizerVariables.add(variable);
    }

    public final void addOptimizerVariableInitializer(@NotNull Assign<?> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        ((Collection)this.optimizerInitializers).add(initializer);
    }

    public final void addOptimizerVariableAssignAddInitializer(@NotNull AssignAdd<Float> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        ((Collection)this.optimizerAssignAddInitializers).add(initializer);
    }

    @NotNull
    public final List<Variable<Float>> optimizerVariables() {
        return CollectionsKt.toList((Iterable)this.optimizerVariables);
    }

    public final void initializeOptimizerVariables(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!((Collection)this.optimizerInitializers).isEmpty()) {
            Iterable $this$forEach$iv = this.optimizerInitializers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Assign it = (Assign)element$iv;
                boolean bl = false;
                Session.Runner runner = session.runner();
                runner.addTarget((Operand)it);
                runner.run();
            }
        }
        this.runAssignAddOpsForOptimizers(session);
    }

    private final void runAssignAddOpsForOptimizers(Session session) {
        if (!((Collection)this.optimizerAssignAddInitializers).isEmpty()) {
            Session.Runner runner = session.runner();
            Iterable $this$forEach$iv = this.optimizerAssignAddInitializers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AssignAdd it = (AssignAdd)element$iv;
                boolean bl = false;
                runner.addTarget((Operand)it);
            }
            runner.run();
        }
    }
}

