/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.FloatBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.GraphTrainableModel;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.SavingFormat;
import org.jetbrains.kotlinx.dl.api.core.TrainableModel;
import org.jetbrains.kotlinx.dl.api.core.WritingMode;
import org.jetbrains.kotlinx.dl.api.core.callback.Callback;
import org.jetbrains.kotlinx.dl.api.core.exception.RepeatableLayerNameException;
import org.jetbrains.kotlinx.dl.api.core.history.BatchEvent;
import org.jetbrains.kotlinx.dl.api.core.history.BatchTrainingEvent;
import org.jetbrains.kotlinx.dl.api.core.history.EpochTrainingEvent;
import org.jetbrains.kotlinx.dl.api.core.history.History;
import org.jetbrains.kotlinx.dl.api.core.history.TrainingHistory;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariable;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.ParametrizedLayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.TrainableLayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.core.ActivationLayer;
import org.jetbrains.kotlinx.dl.api.core.layer.core.Dense;
import org.jetbrains.kotlinx.dl.api.core.layer.core.Input;
import org.jetbrains.kotlinx.dl.api.core.loss.LossFunction;
import org.jetbrains.kotlinx.dl.api.core.loss.Losses;
import org.jetbrains.kotlinx.dl.api.core.loss.SoftmaxCrossEntropyWithLogits;
import org.jetbrains.kotlinx.dl.api.core.metric.EvaluationResult;
import org.jetbrains.kotlinx.dl.api.core.metric.Metric;
import org.jetbrains.kotlinx.dl.api.core.metric.Metrics;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.regularizer.Regularizer;
import org.jetbrains.kotlinx.dl.api.core.shape.ShapeFunctionsKt;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.core.summary.LayerSummary;
import org.jetbrains.kotlinx.dl.api.core.summary.TfModelSummary;
import org.jetbrains.kotlinx.dl.api.core.util.ConvertersKt;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.jetbrains.kotlinx.dl.api.extension.TensorExtensionFunctionsKt;
import org.jetbrains.kotlinx.dl.api.inference.InferenceModel;
import org.jetbrains.kotlinx.dl.api.inference.keras.ModelSaverKt;
import org.jetbrains.kotlinx.dl.dataset.DataBatch;
import org.jetbrains.kotlinx.dl.dataset.Dataset;
import org.jetbrains.kotlinx.dl.impl.util.AutoClosableExtensionsKt;
import org.jetbrains.kotlinx.dl.impl.util.FloatArrayExtensionFunctionsKt;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Session;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;
import org.tensorflow.TensorFlowException;
import org.tensorflow.op.NnOps;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Identity;
import org.tensorflow.op.core.Placeholder;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.math.Add;
import org.tensorflow.op.nn.Softmax;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u009e\u00012\u00020\u0001:\u0002\u009e\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0002J<\u0010:\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0<\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0;2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u001f2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020 0\u001fH$J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020CH\u0002J\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070;2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010E\u001a\u00020\u00072\u0006\u0010B\u001a\u00020CH\u0002J&\u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u00020@2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u000eH\u0016J \u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u00020@2\u0006\u0010K\u001a\u00020JH\u0016J \u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u00020@2\u0006\u0010K\u001a\u00020LH\u0016J \u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u00020M2\u0006\u0010K\u001a\u00020JH\u0016J \u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u00020M2\u0006\u0010K\u001a\u00020LH\u0016J&\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010B\u001a\u00020C2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000eH\u0016J\u001d\u0010T\u001a\u0002052\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0000\u00a2\u0006\u0002\bYJ.\u0010Z\u001a\u00020[2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\\\u001a\u00020C2\u0006\u0010B\u001a\u00020C2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000eH\u0016J>\u0010Z\u001a\u00020[2\u0006\u0010]\u001a\u00020Q2\u0006\u0010^\u001a\u00020Q2\u0006\u0010\\\u001a\u00020C2\u0006\u0010_\u001a\u00020C2\u0006\u0010`\u001a\u00020C2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000eH\u0016J0\u0010a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0\u000e2\u0006\u0010c\u001a\u00020\u00152\f\u0010d\u001a\b\u0012\u0004\u0012\u00020 0b2\u0006\u0010e\u001a\u00020.H\u0002J\u000e\u0010f\u001a\b\u0012\u0004\u0012\u00020V0\u000eH\u0002J\u0011\u0010g\u001a\u00020\u00042\u0006\u0010h\u001a\u00020\u0015H\u0086\u0004J,\u0010i\u001a\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0j\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0;0\u000e2\u0006\u0010k\u001a\u00020.H\u0002J\u0006\u0010l\u001a\u000205J\u0015\u0010l\u001a\u0002052\u0006\u0010U\u001a\u00020VH\u0000\u00a2\u0006\u0002\bmJO\u0010n\u001a\u00020[2\u0006\u0010_\u001a\u00020C2\u0006\u0010\\\u001a\u00020C2\u0006\u0010]\u001a\u00020Q2\u0006\u0010o\u001a\u00020.2\b\u0010^\u001a\u0004\u0018\u00010Q2\b\u0010`\u001a\u0004\u0018\u00010C2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020S0\u000eH\u0002\u00a2\u0006\u0002\u0010qJ0\u0010r\u001a\u0012\u0012\u0004\u0012\u00020s\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0;2\u0006\u0010t\u001a\u00020s2\u0006\u0010e\u001a\u00020.2\u0006\u0010c\u001a\u00020\u0015H\u0002J\u0010\u0010u\u001a\u00020.2\u0006\u0010v\u001a\u00020\u0015H\u0002J\u0006\u0010w\u001a\u00020xJ\u000e\u0010y\u001a\b\u0012\u0004\u0012\u00020V0\u000eH\u0002J0\u0010z\u001a\u0002052\f\u0010{\u001a\b\u0012\u0004\u0012\u00020\u00150|2\u0018\u0010}\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u007f\u0012\u0004\u0012\u00020X0~H\u0014J\u001c\u0010\u0080\u0001\u001a\u0002052\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020.H\u0016J\u0011\u0010\u0084\u0001\u001a\u00020C2\u0006\u0010t\u001a\u00020sH\u0016J\u0019\u0010\u0084\u0001\u001a\u00020C2\u0006\u0010t\u001a\u00020s2\u0006\u0010c\u001a\u00020\u0015H\u0016J(\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010P\u001a\u00020Q2\u0006\u0010B\u001a\u00020C2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000eH\u0016J)\u0010\u0086\u0001\u001a\u0012\u0012\u0004\u0012\u00020C\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0;2\u0006\u0010t\u001a\u00020s2\u0006\u0010c\u001a\u00020\u0015H\u0016J\u0019\u0010\u0087\u0001\u001a\u00020s2\u0006\u0010t\u001a\u00020s2\u0006\u0010c\u001a\u00020\u0015H\u0016J3\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020s0\u00032\u0006\u0010P\u001a\u00020Q2\u0006\u0010B\u001a\u00020C2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000eH\u0016\u00a2\u0006\u0003\u0010\u0088\u0001J)\u0010\u0089\u0001\u001a\u0012\u0012\u0004\u0012\u00020s\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0;2\u0006\u0010t\u001a\u00020s2\u0006\u0010c\u001a\u00020\u0015H\u0014J\u0007\u0010\u008a\u0001\u001a\u000205J/\u0010\u008b\u0001\u001a\u0002052\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010k\u001a\u00020.2\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0016J\u0012\u0010\u0090\u0001\u001a\u0002052\u0007\u0010\u0091\u0001\u001a\u00020\u0015H\u0002J\u001a\u0010\u0092\u0001\u001a\u0002052\u0007\u0010\u0091\u0001\u001a\u00020\u00152\u0006\u0010k\u001a\u00020.H\u0002J\u0012\u0010\u0093\u0001\u001a\u0002052\u0007\u0010\u0091\u0001\u001a\u00020\u0015H\u0002J\u001a\u0010\u0094\u0001\u001a\u0002052\u0007\u0010\u0091\u0001\u001a\u00020\u00152\u0006\u0010k\u001a\u00020.H\u0002J\u0012\u0010\u0095\u0001\u001a\u0002052\u0007\u0010\u0091\u0001\u001a\u00020\u0015H\u0002J\u001a\u0010\u0096\u0001\u001a\u0002052\u0007\u0010\u0091\u0001\u001a\u00020\u00152\u0006\u0010k\u001a\u00020.H\u0004J\n\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0016J\t\u0010\u0099\u0001\u001a\u00020\u0015H\u0016J~\u0010\u009a\u0001\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000e0;2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u000e2\r\u0010\u009b\u0001\u001a\b\u0012\u0004\u0012\u00020 0b2\r\u0010\u009c\u0001\u001a\b\u0012\u0004\u0012\u00020 0b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020 0b2\r\u0010\u009d\u0001\u001a\b\u0012\u0004\u0012\u00020 0b2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u000eH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00040\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010&\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\"\"\u0004\b(\u0010$R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u000eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0010\"\u0004\b,\u0010\u0012R \u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u001fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\"\"\u0004\b0\u0010$R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009f\u0001"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "Lorg/jetbrains/kotlinx/dl/api/core/TrainableModel;", "layers", "", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "([Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;)V", "inputDimensions", "", "getInputDimensions", "()[J", "inputLayer", "Lorg/jetbrains/kotlinx/dl/api/core/layer/core/Input;", "getInputLayer", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/core/Input;", "", "getLayers", "()Ljava/util/List;", "setLayers", "(Ljava/util/List;)V", "layersByName", "", "", "getLayersByName", "()Ljava/util/Map;", "setLayersByName", "(Ljava/util/Map;)V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "lossOp", "Lorg/tensorflow/Operand;", "", "getLossOp", "()Lorg/tensorflow/Operand;", "setLossOp", "(Lorg/tensorflow/Operand;)V", "metricOps", "numberOfLossesOp", "getNumberOfLossesOp", "setNumberOfLossesOp", "predictionOp", "targets", "getTargets", "setTargets", "training", "", "getTraining", "setTraining", "xOp", "yPredOp", "yTrueOp", "batchValidation", "", "batch", "Lorg/jetbrains/kotlinx/dl/dataset/DataBatch;", "xBatchShape", "yBatchShape", "buildLayers", "Lkotlin/Pair;", "Lorg/tensorflow/op/core/Placeholder;", "numberOfLosses", "buildLossFunction", "loss", "Lorg/jetbrains/kotlinx/dl/api/core/loss/LossFunction;", "calculateXShape", "batchSize", "", "calculateXYShapes", "calculateYShape", "compile", "optimizer", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Optimizer;", "metrics", "Lorg/jetbrains/kotlinx/dl/api/core/metric/Metric;", "metric", "Lorg/jetbrains/kotlinx/dl/api/core/metric/Metrics;", "Lorg/jetbrains/kotlinx/dl/api/core/loss/Losses;", "evaluate", "Lorg/jetbrains/kotlinx/dl/api/core/metric/EvaluationResult;", "dataset", "Lorg/jetbrains/kotlinx/dl/dataset/Dataset;", "callbacks", "Lorg/jetbrains/kotlinx/dl/api/core/callback/Callback;", "fill", "variable", "Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "data", "", "fill$tensorflow", "fit", "Lorg/jetbrains/kotlinx/dl/api/core/history/TrainingHistory;", "epochs", "trainingDataset", "validationDataset", "trainBatchSize", "validationBatchSize", "formPredictionAndActivationsTensors", "Lorg/tensorflow/Tensor;", "predictionTensorName", "testImages", "visualizationIsEnabled", "frozenLayerVariables", "getLayer", "layerName", "getVariablesAndTensors", "Lorg/tensorflow/op/core/Variable;", "saveOptimizerState", "init", "init$tensorflow", "internalFit", "validationIsEnabled", "fitCallbacks", "(IILorg/jetbrains/kotlinx/dl/dataset/Dataset;ZLorg/jetbrains/kotlinx/dl/dataset/Dataset;Ljava/lang/Integer;Ljava/util/List;)Lorg/jetbrains/kotlinx/dl/api/core/history/TrainingHistory;", "internalPredict", "", "inputData", "isVariableRelatedToFrozenLayer", "variableName", "kGraph", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "layerVariables", "loadVariables", "variableNames", "", "getData", "Lkotlin/Function2;", "Lorg/tensorflow/Shape;", "loadWeights", "modelDirectory", "Ljava/io/File;", "loadOptimizerState", "predict", "", "predictAndGetActivations", "predictSoftly", "(Lorg/jetbrains/kotlinx/dl/dataset/Dataset;ILjava/util/List;)[[F", "predictSoftlyAndGetActivations", "reset", "save", "savingFormat", "Lorg/jetbrains/kotlinx/dl/api/core/SavingFormat;", "writingMode", "Lorg/jetbrains/kotlinx/dl/api/core/WritingMode;", "saveGraphDef", "pathToModelDirectory", "saveInKerasFormat", "saveInSavedModelFormat", "saveInSimpleFormat", "saveModel", "saveVariables", "summary", "Lorg/jetbrains/kotlinx/dl/api/core/summary/TfModelSummary;", "toString", "trainOnBatch", "batchImages", "batchLabels", "isTraining", "Companion", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nGraphTrainableModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphTrainableModel.kt\norg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1015:1\n1#2:1016\n1549#3:1017\n1620#3,3:1018\n1549#3:1021\n1620#3,3:1022\n1855#3,2:1025\n1855#3,2:1027\n1855#3,2:1029\n1855#3,2:1031\n1855#3,2:1033\n1864#3,3:1035\n1855#3,2:1042\n1549#3:1051\n1620#3,3:1052\n1855#3,2:1055\n1855#3,2:1057\n1855#3,2:1059\n1855#3,2:1061\n1855#3,2:1063\n1855#3,2:1065\n1855#3,2:1067\n1855#3,2:1069\n1864#3,3:1071\n1855#3,2:1078\n1855#3,2:1083\n1864#3,3:1085\n1855#3,2:1088\n1855#3,2:1090\n1855#3,2:1092\n1855#3,2:1094\n1855#3,2:1096\n1855#3,2:1098\n1855#3,2:1100\n1855#3,2:1102\n1549#3:1104\n1620#3,3:1105\n1855#3,2:1108\n1549#3:1110\n1620#3,3:1111\n1747#3,3:1114\n1194#3,2:1117\n1222#3,4:1119\n3190#3,10:1123\n1549#3:1133\n1620#3,2:1134\n1549#3:1136\n1620#3,3:1137\n1622#3:1140\n11385#4:1038\n11720#4,3:1039\n13694#4,3:1044\n11385#4:1047\n11720#4,3:1048\n11385#4:1074\n11720#4,3:1075\n13694#4,3:1080\n*S KotlinDebug\n*F\n+ 1 GraphTrainableModel.kt\norg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel\n*L\n183#1:1017\n183#1:1018,3\n190#1:1021\n190#1:1022,3\n199#1:1025,2\n315#1:1027,2\n316#1:1029,2\n320#1:1031,2\n330#1:1033,2\n357#1:1035,3\n373#1:1042,2\n411#1:1051\n411#1:1052,3\n421#1:1055,2\n424#1:1057,2\n442#1:1059,2\n455#1:1061,2\n483#1:1063,2\n484#1:1065,2\n495#1:1067,2\n509#1:1069,2\n534#1:1071,3\n542#1:1078,2\n559#1:1083,2\n561#1:1085,3\n573#1:1088,2\n574#1:1090,2\n587#1:1092,2\n616#1:1094,2\n640#1:1096,2\n641#1:1098,2\n654#1:1100,2\n675#1:1102,2\n910#1:1104\n910#1:1105,3\n916#1:1108,2\n937#1:1110\n937#1:1111,3\n937#1:1114,3\n946#1:1117,2\n946#1:1119,4\n988#1:1123,10\n993#1:1133\n993#1:1134,2\n999#1:1136\n999#1:1137,3\n993#1:1140\n366#1:1038\n366#1:1039,3\n389#1:1044,3\n403#1:1047\n403#1:1048,3\n539#1:1074\n539#1:1075,3\n555#1:1080,3\n*E\n"})
public abstract class GraphTrainableModel
extends TrainableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger;
    @NotNull
    private List<? extends Layer> layers;
    @NotNull
    private Map<String, ? extends Layer> layersByName;
    private Operand<Float> yPredOp;
    protected Operand<Float> lossOp;
    private Operand<Float> predictionOp;
    private List<? extends Operand<Float>> metricOps;
    protected List<? extends Operand<Float>> targets;
    private Operand<Float> xOp;
    private Operand<Float> yTrueOp;
    protected Operand<Float> numberOfLossesOp;
    protected Operand<Boolean> training;

    public GraphTrainableModel(Layer ... layers) {
        Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.layers = CollectionsKt.listOf((Object[])Arrays.copyOf(layers, layers.length));
        this.layersByName = MapsKt.emptyMap();
        for (final Layer layer : layers) {
            if (this.layersByName.containsKey(layer.getName())) {
                throw new RepeatableLayerNameException(layer.getName());
            }
            this.layersByName = MapsKt.plus(this.layersByName, (Pair)TuplesKt.to((Object)layer.getName(), (Object)layer));
            if (layer.getParentModel() != null) {
                this.logger.warn((Function0)new Function0<Object>(){

                    @Nullable
                    public final Object invoke() {
                        return "Layer " + layer.getName() + " is a part of model " + layer.getParentModel();
                    }
                });
            }
            layer.setParentModel(this);
        }
        byte[] byArray = new Graph().toGraphDef();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Graph().toGraphDef()");
        this.setKGraph(new KGraph(byArray));
        Ops ops = Ops.create((ExecutionEnvironment)((ExecutionEnvironment)this.getKGraph().getTfGraph$tensorflow()));
        Intrinsics.checkNotNullExpressionValue((Object)ops, (String)"create(kGraph.tfGraph)");
        this.setTf(ops);
        this.setSession$tensorflow(new Session(this.getKGraph().getTfGraph$tensorflow()));
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final List<Layer> getLayers() {
        return this.layers;
    }

    public final void setLayers(@NotNull List<? extends Layer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.layers = list;
    }

    @NotNull
    public final Input getInputLayer() {
        Layer layer = this.layers.get(0);
        Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dl.api.core.layer.core.Input");
        return (Input)layer;
    }

    @Override
    @NotNull
    public long[] getInputDimensions() {
        Layer layer = this.layers.get(0);
        Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dl.api.core.layer.core.Input");
        return ((Input)layer).getPackedDims();
    }

    @NotNull
    protected final Map<String, Layer> getLayersByName() {
        return this.layersByName;
    }

    protected final void setLayersByName(@NotNull Map<String, ? extends Layer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.layersByName = map;
    }

    @NotNull
    protected final Operand<Float> getLossOp() {
        Operand<Float> operand = this.lossOp;
        if (operand != null) {
            return operand;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lossOp");
        return null;
    }

    protected final void setLossOp(@NotNull Operand<Float> operand) {
        Intrinsics.checkNotNullParameter(operand, (String)"<set-?>");
        this.lossOp = operand;
    }

    @NotNull
    protected final List<Operand<Float>> getTargets() {
        List<? extends Operand<Float>> list = this.targets;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"targets");
        return null;
    }

    protected final void setTargets(@NotNull List<? extends Operand<Float>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.targets = list;
    }

    @NotNull
    protected final Operand<Float> getNumberOfLossesOp() {
        Operand<Float> operand = this.numberOfLossesOp;
        if (operand != null) {
            return operand;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"numberOfLossesOp");
        return null;
    }

    protected final void setNumberOfLossesOp(@NotNull Operand<Float> operand) {
        Intrinsics.checkNotNullParameter(operand, (String)"<set-?>");
        this.numberOfLossesOp = operand;
    }

    @NotNull
    protected final Operand<Boolean> getTraining() {
        Operand<Boolean> operand = this.training;
        if (operand != null) {
            return operand;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"training");
        return null;
    }

    protected final void setTraining(@NotNull Operand<Boolean> operand) {
        Intrinsics.checkNotNullParameter(operand, (String)"<set-?>");
        this.training = operand;
    }

    private final List<KVariable> layerVariables() {
        return ParametrizedLayerKt.variables(this.layers);
    }

    private final List<KVariable> frozenLayerVariables() {
        return ParametrizedLayerKt.frozenVariables(this.layers);
    }

    @Override
    public void compile(@NotNull Optimizer optimizer, @NotNull Losses loss, @NotNull Metrics metric) {
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)((Object)loss), (String)"loss");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.compile(optimizer, Losses.Companion.convert(loss), Metric.Companion.convert(metric));
    }

    @Override
    public void compile(@NotNull Optimizer optimizer, @NotNull LossFunction loss, @NotNull Metric metric) {
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)loss, (String)"loss");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.compile(optimizer, loss, CollectionsKt.listOf((Object)metric));
    }

    @Override
    public void compile(@NotNull Optimizer optimizer, @NotNull LossFunction loss, @NotNull List<? extends Metric> metrics) {
        Operand operand;
        Metric it;
        Collection<Variable<Float>> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)loss, (String)"loss");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        if (!(!this.isModelCompiled())) {
            boolean $i$a$-check-GraphTrainableModel$compile$22 = false;
            String $i$a$-check-GraphTrainableModel$compile$22 = "The model is compiled already. Graph is created. Create new model and compile it.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$compile$22.toString());
        }
        this.setLoss(loss);
        this.setMetrics(metrics);
        this.setOptimizer(optimizer);
        Placeholder.Options[] $i$a$-check-GraphTrainableModel$compile$22 = new Placeholder.Options[]{Placeholder.shape((Shape)Shape.scalar())};
        Placeholder placeholder = this.getTf().withName("training").placeholder(Boolean.class, $i$a$-check-GraphTrainableModel$compile$22);
        Intrinsics.checkNotNullExpressionValue((Object)placeholder, (String)"tf.withName(\"training\").\u2026Shape.scalar())\n        )");
        this.setTraining((Operand<Boolean>)((Operand)placeholder));
        $i$a$-check-GraphTrainableModel$compile$22 = new Placeholder.Options[]{Placeholder.shape((Shape)Shape.scalar())};
        Placeholder placeholder2 = this.getTf().withName("numberOfLosses").placeholder(DtypeConversionUtilKt.getDType(), $i$a$-check-GraphTrainableModel$compile$22);
        Intrinsics.checkNotNullExpressionValue((Object)placeholder2, (String)"tf.withName(\"numberOfLos\u2026Shape.scalar())\n        )");
        this.setNumberOfLossesOp((Operand<Float>)((Operand)placeholder2));
        Pair<Placeholder<Float>, Operand<Float>> pair = this.buildLayers(this.getTraining(), this.getNumberOfLossesOp());
        Placeholder input = (Placeholder)pair.component1();
        Operand output = (Operand)pair.component2();
        this.xOp = (Operand)input;
        this.yPredOp = output;
        Object lastLayer = (Layer)CollectionsKt.last(this.layers);
        this.setNumberOfClasses(lastLayer instanceof Dense ? (long)((Dense)lastLayer).getOutputSize() : (lastLayer instanceof ActivationLayer ? ArraysKt.last((long[])((Layer)lastLayer).getOutputShape().tail()) : 1L));
        Placeholder placeholder3 = this.getTf().placeholder(DtypeConversionUtilKt.getDType(), new Placeholder.Options[0]);
        Intrinsics.checkNotNull((Object)placeholder3, (String)"null cannot be cast to non-null type org.tensorflow.Operand<kotlin.Float>");
        this.yTrueOp = (Operand)placeholder3;
        this.setLossOp(this.buildLossFunction(loss));
        lastLayer = ParametrizedLayerKt.trainableVariables(this.layers);
        KGraph kGraph = this.getKGraph();
        Object object = optimizer;
        GraphTrainableModel graphTrainableModel = this;
        boolean $i$f$map = false;
        void var9_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KVariable kVariable = (KVariable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((KVariable)((Object)it)).getVariable());
        }
        collection = (List)destination$iv$iv;
        graphTrainableModel.setTargets(((Optimizer)object).prepareTargets$tensorflow(kGraph, (List<Variable<Float>>)collection, this.getTf(), this.getLossOp()));
        if (loss instanceof SoftmaxCrossEntropyWithLogits) {
            NnOps nnOps = this.getTf().withName((String)"default_output").nn;
            Operand<Float> operand2 = this.yPredOp;
            if (operand2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"yPredOp");
                operand2 = null;
            }
            Softmax softmax = nnOps.softmax(operand2);
            Intrinsics.checkNotNullExpressionValue((Object)softmax, (String)"tf.withName(OUTPUT_NAME).nn.softmax(yPredOp)");
            operand = (Operand)softmax;
        } else {
            Ops ops = this.getTf().withName("default_output");
            Operand<Float> operand3 = this.yPredOp;
            if (operand3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"yPredOp");
                operand3 = null;
            }
            Identity identity = ops.identity(operand3);
            Intrinsics.checkNotNullExpressionValue((Object)identity, (String)"tf.withName(OUTPUT_NAME).identity(yPredOp)");
            operand = (Operand)identity;
        }
        this.predictionOp = operand;
        $this$map$iv = metrics;
        graphTrainableModel = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Operand<Float> operand4;
            it = (Metric)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Ops ops = this.getTf();
            Operand<Float> operand5 = this.predictionOp;
            if (operand5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"predictionOp");
                operand5 = null;
            }
            if ((operand4 = this.yTrueOp) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"yTrueOp");
                operand4 = null;
            }
            object.add(it.apply(ops, operand5, operand4, this.getNumberOfLossesOp()));
        }
        graphTrainableModel.metricOps = (List)destination$iv$iv;
        this.setModelCompiled$tensorflow(true);
    }

    private final Operand<Float> buildLossFunction(LossFunction loss) {
        Operand<Float> operand;
        Ops ops = this.getTf();
        Operand<Float> operand2 = this.yPredOp;
        if (operand2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yPredOp");
            operand2 = null;
        }
        if ((operand = this.yTrueOp) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yTrueOp");
            operand = null;
        }
        Add basicLoss = loss.apply(ops, operand2, operand, this.getNumberOfLossesOp());
        Add totalLoss = null;
        totalLoss = basicLoss;
        Iterable $this$forEach$iv = ParametrizedLayerKt.trainableVariables(this.layers);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Regularizer regularizer;
            KVariable variable = (KVariable)element$iv;
            boolean bl = false;
            if (variable.getRegularizer() == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.getTf().math.add(totalLoss, regularizer.apply(this.getTf(), (Operand<Float>)((Operand)variable.getVariable()))), (String)"tf.math.add(totalLoss, r\u2026y(tf, variable.variable))");
        }
        Identity identity = this.getTf().withName("default_training_loss").identity(totalLoss);
        Intrinsics.checkNotNullExpressionValue((Object)identity, (String)"tf.withName(TRAINING_LOSS).identity(totalLoss)");
        return (Operand)identity;
    }

    @Override
    public void compile(@NotNull Optimizer optimizer, @NotNull Losses loss, @NotNull Metric metric) {
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)((Object)loss), (String)"loss");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.compile(optimizer, Losses.Companion.convert(loss), metric);
    }

    @Override
    public void compile(@NotNull Optimizer optimizer, @NotNull LossFunction loss, @NotNull Metrics metric) {
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)loss, (String)"loss");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.compile(optimizer, loss, Metric.Companion.convert(metric));
    }

    @NotNull
    protected abstract Pair<Placeholder<Float>, Operand<Float>> buildLayers(@NotNull Operand<Boolean> var1, @NotNull Operand<Float> var2);

    @Override
    @NotNull
    public TrainingHistory fit(@NotNull Dataset trainingDataset, @NotNull Dataset validationDataset, int epochs, int trainBatchSize, int validationBatchSize, @NotNull List<? extends Callback> callbacks) {
        Intrinsics.checkNotNullParameter((Object)trainingDataset, (String)"trainingDataset");
        Intrinsics.checkNotNullParameter((Object)validationDataset, (String)"validationDataset");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        return this.internalFit(trainBatchSize, epochs, trainingDataset, true, validationDataset, validationBatchSize, callbacks);
    }

    @Override
    @NotNull
    public TrainingHistory fit(@NotNull Dataset dataset, int epochs, int batchSize, @NotNull List<? extends Callback> callbacks) {
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        return this.internalFit(batchSize, epochs, dataset, false, null, null, callbacks);
    }

    public final void init() {
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$init$42 = false;
            String $i$a$-check-GraphTrainableModel$init$42 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$init$42.toString());
        }
        if (!(!this.isModelInitialized())) {
            boolean $i$a$-check-GraphTrainableModel$init$52 = false;
            String $i$a$-check-GraphTrainableModel$init$52 = "Model is initialized already!";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$init$52.toString());
        }
        if (!(!this.isOptimizerVariableInitialized())) {
            boolean bl = false;
            String string = "Optimizer variables are initialized already!";
            throw new IllegalStateException(string.toString());
        }
        this.logger.debug((Function0)init.4.INSTANCE);
        ParametrizedLayerKt.initializeVariables(this.layers, this.getSession$tensorflow());
        this.setModelInitialized$tensorflow(true);
    }

    public final void reset() {
        if (!this.isModelCompiled()) {
            boolean bl = false;
            String string = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException(string.toString());
        }
        this.logger.debug((Function0)reset.2.INSTANCE);
        ParametrizedLayerKt.initializeVariables(this.layers, this.getSession$tensorflow());
        this.setModelInitialized$tensorflow(true);
        this.setOptimizerVariableInitialized$tensorflow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final TrainingHistory internalFit(int trainBatchSize, int epochs, Dataset trainingDataset, boolean validationIsEnabled, Dataset validationDataset, Integer validationBatchSize, List<? extends Callback> fitCallbacks) {
        Callback it;
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$internalFit$22 = false;
            String $i$a$-check-GraphTrainableModel$internalFit$22 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$internalFit$22.toString());
        }
        if (!this.isModelInitialized()) {
            this.logger.debug((Function0)internalFit.2.INSTANCE);
            ParametrizedLayerKt.initializeVariables(this.layers, this.getSession$tensorflow());
            this.setModelInitialized$tensorflow(true);
        }
        TrainingHistory trainingHistory = new TrainingHistory();
        if (!this.isOptimizerVariableInitialized()) {
            this.logger.debug((Function0)internalFit.3.INSTANCE);
            this.getKGraph().initializeOptimizerVariables(this.getSession$tensorflow());
            this.setOptimizerVariableInitialized$tensorflow(true);
        }
        Iterable $this$forEach$iv = fitCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Callback)element$iv;
            boolean bl = false;
            it.setModel$tensorflow(this);
        }
        $this$forEach$iv = fitCallbacks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Callback)element$iv;
            boolean bl = false;
            it.onTrainBegin();
        }
        int i = 1;
        if (i <= epochs) {
            while (true) {
                if (!this.getStopTraining()) {
                    Collection<Double> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    int $i$f$forEach22;
                    int n;
                    Iterable $this$forEach$iv2 = fitCallbacks;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Callback it2 = (Callback)element$iv;
                        n = 0;
                        it2.onEpochBegin(i, trainingHistory);
                    }
                    Dataset.BatchIterator batchIter = trainingDataset.batchIterator(trainBatchSize);
                    int batchCounter = 0;
                    float averageTrainingLossAccum = 0.0f;
                    int it2 = 0;
                    n = this.getMetrics().size();
                    Object object = new float[n];
                    while (it2 < n) {
                        int n2 = it2++;
                        object[n2] = 0.0f;
                    }
                    float[] averageTrainingMetricAccum = object;
                    while (batchIter.hasNext() && !this.getStopTraining()) {
                        Object it322;
                        Iterable $this$forEach$iv3 = fitCallbacks;
                        $i$f$forEach22 = 0;
                        object = $this$forEach$iv3.iterator();
                        while (object.hasNext()) {
                            Object element$iv = object.next();
                            it322 = (Callback)element$iv;
                            boolean bl = false;
                            ((Callback)it322).onTrainBatchBegin(batchCounter, trainBatchSize, trainingHistory);
                        }
                        DataBatch batch = batchIter.next();
                        Pair<long[], long[]> $i$f$forEach22 = this.calculateXYShapes(batch);
                        long[] xBatchShape = (long[])$i$f$forEach22.component1();
                        long[] yBatchShape = (long[])$i$f$forEach22.component2();
                        it322 = (AutoCloseable)Tensor.create((long[])xBatchShape, (FloatBuffer)ConvertersKt.serializeToBuffer(batch.getX()));
                        Throwable bl = null;
                        try {
                            Tensor batchImagesTensor = (Tensor)it322;
                            boolean bl2 = false;
                            AutoCloseable autoCloseable = (AutoCloseable)Tensor.create((long[])yBatchShape, (FloatBuffer)ConvertersKt.serializeLabelsToBuffer(batch.getY(), this.getNumberOfClasses()));
                            Throwable throwable = null;
                            try {
                                Tensor batchLabelsTensor = (Tensor)autoCloseable;
                                boolean bl3 = false;
                                AutoCloseable autoCloseable2 = (AutoCloseable)Tensor.create((Object)Float.valueOf(new TensorShape(yBatchShape).numElements()));
                                Throwable throwable2 = null;
                                try {
                                    Tensor numberOfLossesTensor = (Tensor)autoCloseable2;
                                    boolean bl4 = false;
                                    AutoCloseable autoCloseable3 = (AutoCloseable)Tensor.create((Object)true);
                                    Throwable throwable3 = null;
                                    try {
                                        Collection<Double> collection2;
                                        void $this$mapTo$iv$iv2;
                                        void $this$map$iv2;
                                        Tensor isTraining = (Tensor)autoCloseable3;
                                        boolean bl5 = false;
                                        List<Operand<Float>> list = this.getTargets();
                                        Intrinsics.checkNotNullExpressionValue((Object)batchImagesTensor, (String)"batchImagesTensor");
                                        Intrinsics.checkNotNullExpressionValue((Object)batchLabelsTensor, (String)"batchLabelsTensor");
                                        Intrinsics.checkNotNull((Object)numberOfLossesTensor, (String)"null cannot be cast to non-null type org.tensorflow.Tensor<kotlin.Float>");
                                        Intrinsics.checkNotNull((Object)isTraining, (String)"null cannot be cast to non-null type org.tensorflow.Tensor<kotlin.Float>");
                                        List<? extends Operand<Float>> list2 = this.metricOps;
                                        if (list2 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"metricOps");
                                            list2 = null;
                                        }
                                        Pair<Float, List<Float>> pair = this.trainOnBatch(list, (Tensor<Float>)batchImagesTensor, (Tensor<Float>)batchLabelsTensor, (Tensor<Float>)numberOfLossesTensor, (Tensor<Float>)isTraining, list2);
                                        float lossValue = ((Number)pair.component1()).floatValue();
                                        List metricValues = (List)pair.component2();
                                        if (Float.isNaN(lossValue) || lossValue == Float.POSITIVE_INFINITY || lossValue == Float.NEGATIVE_INFINITY) {
                                            this.logger.debug((Function0)internalFit.8.1.1.1.1.INSTANCE);
                                        }
                                        averageTrainingLossAccum += lossValue;
                                        Iterable $this$forEachIndexed$iv = this.getMetrics();
                                        boolean $i$f$forEachIndexed22 = false;
                                        int index$iv = 0;
                                        for (Object item$iv : $this$forEachIndexed$iv) {
                                            int n3;
                                            if ((n3 = index$iv++) < 0) {
                                                CollectionsKt.throwIndexOverflow();
                                            }
                                            Metric cfr_ignored_0 = (Metric)item$iv;
                                            int i2 = n3;
                                            boolean bl6 = false;
                                            averageTrainingMetricAccum[i2] = averageTrainingMetricAccum[i2] + ((Number)metricValues.get(i2)).floatValue();
                                        }
                                        float[] $i$f$forEachIndexed22 = averageTrainingMetricAccum;
                                        double d = lossValue;
                                        int n4 = batchCounter;
                                        int n5 = i;
                                        boolean $i$f$map = false;
                                        Iterator iterator = $this$map$iv2;
                                        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
                                        boolean $i$f$mapTo = false;
                                        int n6 = ((void)$this$mapTo$iv$iv2).length;
                                        for (int j = 0; j < n6; ++j) {
                                            void it4;
                                            void item$iv$iv;
                                            void var50_117 = item$iv$iv = $this$mapTo$iv$iv2[j];
                                            collection2 = destination$iv$iv;
                                            boolean bl7 = false;
                                            collection2.add((double)it4);
                                        }
                                        Collection<Double> collection3 = collection2 = (List)destination$iv$iv;
                                        double d2 = d;
                                        int n7 = n4;
                                        int n8 = n5;
                                        BatchTrainingEvent batchTrainingEvent = new BatchTrainingEvent(n8, n7, d2, (List<Double>)collection3);
                                        trainingHistory.appendBatch(batchTrainingEvent);
                                        this.logger.debug((Function0)new Function0<Object>(lossValue, (List<Float>)metricValues){
                                            final /* synthetic */ float $lossValue;
                                            final /* synthetic */ List<Float> $metricValues;
                                            {
                                                this.$lossValue = $lossValue;
                                                this.$metricValues = $metricValues;
                                                super(0);
                                            }

                                            @Nullable
                                            public final Object invoke() {
                                                return "Batch stat: { lossValue: " + this.$lossValue + " metricValues: " + this.$metricValues + " }";
                                            }
                                        });
                                        Iterable $this$forEach$iv4 = fitCallbacks;
                                        boolean $i$f$forEach4 = false;
                                        for (Object element$iv : $this$forEach$iv4) {
                                            Callback it5 = (Callback)element$iv;
                                            boolean bl8 = false;
                                            it5.onTrainBatchEnd(batchCounter, trainBatchSize, batchTrainingEvent, trainingHistory);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                                    }
                                    numberOfLossesTensor = Unit.INSTANCE;
                                }
                                catch (Throwable numberOfLossesTensor) {
                                    throwable2 = numberOfLossesTensor;
                                    throw numberOfLossesTensor;
                                }
                                finally {
                                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                                }
                                batchLabelsTensor = Unit.INSTANCE;
                            }
                            catch (Throwable batchLabelsTensor) {
                                throwable = batchLabelsTensor;
                                throw batchLabelsTensor;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                            }
                            batchImagesTensor = Unit.INSTANCE;
                        }
                        catch (Throwable batchImagesTensor) {
                            bl = batchImagesTensor;
                            throw batchImagesTensor;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)it322, (Throwable)bl);
                        }
                        int it322 = batchCounter;
                        batchCounter = it322 + 1;
                    }
                    $i$f$forEach22 = 0;
                    int xBatchShape = this.getMetrics().size();
                    float[] yBatchShape = new float[xBatchShape];
                    while ($i$f$forEach22 < xBatchShape) {
                        int it322 = $i$f$forEach22++;
                        yBatchShape[it322] = 0.0f;
                    }
                    float[] avgTrainingMetricValue = yBatchShape;
                    float[] $this$forEachIndexed$iv = averageTrainingMetricAccum;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (float item$iv : $this$forEachIndexed$iv) {
                        void metricValue;
                        int n9 = index$iv++;
                        float bl2 = item$iv;
                        int index = n9;
                        boolean bl = false;
                        avgTrainingMetricValue[index] = metricValue / (float)batchCounter;
                    }
                    float avgLossValue = averageTrainingLossAccum / (float)batchCounter;
                    List nanList = new ArrayList();
                    int j = 1;
                    int it322 = this.getMetrics().size();
                    if (j <= it322) {
                        while (true) {
                            nanList.add(Double.NaN);
                            if (j == it322) break;
                            ++j;
                        }
                    }
                    float[] it322 = avgTrainingMetricValue;
                    double d = avgLossValue;
                    int n10 = i;
                    boolean $i$f$map = false;
                    void item$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo2 = false;
                    int batchLabelsTensor = ((void)$this$mapTo$iv$iv).length;
                    for (int bl = 0; bl < batchLabelsTensor; ++bl) {
                        void it6;
                        void item$iv$iv;
                        void var26_83 = item$iv$iv = $this$mapTo$iv$iv[bl];
                        collection = destination$iv$iv;
                        boolean bl9 = false;
                        collection.add((double)it6);
                    }
                    collection = (List)destination$iv$iv;
                    List list = nanList;
                    Double d3 = Double.NaN;
                    List list3 = CollectionsKt.toMutableList((Collection)collection);
                    double d4 = d;
                    int n11 = n10;
                    EpochTrainingEvent epochTrainingEvent = new EpochTrainingEvent(n11, d4, list3, d3, list);
                    if (validationIsEnabled) {
                        void $this$mapTo$iv$iv3;
                        Dataset dataset = validationDataset;
                        Intrinsics.checkNotNull((Object)dataset);
                        Integer n12 = validationBatchSize;
                        Intrinsics.checkNotNull((Object)n12);
                        EvaluationResult evaluationResult = this.evaluate(dataset, (int)n12, CollectionsKt.emptyList());
                        Iterable $this$map$iv3 = this.getMetrics();
                        boolean $i$f$map2 = false;
                        Iterable $i$f$mapTo2 = $this$map$iv3;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                        boolean $i$f$mapTo3 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                            void it7;
                            Metric bl9 = (Metric)item$iv$iv;
                            Collection collection4 = destination$iv$iv2;
                            boolean bl = false;
                            collection4.add(evaluationResult.getMetrics().get(Metric.Companion.convertBack((Metric)it7)));
                        }
                        List validationMetricValues = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
                        double validationLossValue = evaluationResult.getLossValue();
                        epochTrainingEvent.setValLossValue(validationLossValue);
                        epochTrainingEvent.setValMetricValues(validationMetricValues);
                        this.logger.info((Function0)new Function0<Object>(i, avgLossValue, avgTrainingMetricValue, validationLossValue, (List<Double>)validationMetricValues){
                            final /* synthetic */ int $i;
                            final /* synthetic */ float $avgLossValue;
                            final /* synthetic */ float[] $avgTrainingMetricValue;
                            final /* synthetic */ double $validationLossValue;
                            final /* synthetic */ List<Double> $validationMetricValues;
                            {
                                this.$i = $i;
                                this.$avgLossValue = $avgLossValue;
                                this.$avgTrainingMetricValue = $avgTrainingMetricValue;
                                this.$validationLossValue = $validationLossValue;
                                this.$validationMetricValues = $validationMetricValues;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                StringBuilder stringBuilder = new StringBuilder().append("epochs: ").append(this.$i).append(" loss: ").append(this.$avgLossValue).append(" metric: ");
                                String string = Arrays.toString(this.$avgTrainingMetricValue);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                                return stringBuilder.append(string).append(" val loss: ").append(this.$validationLossValue).append(" val metrics: ").append(this.$validationMetricValues).toString();
                            }
                        });
                    } else {
                        this.logger.info((Function0)new Function0<Object>(i, avgLossValue, avgTrainingMetricValue){
                            final /* synthetic */ int $i;
                            final /* synthetic */ float $avgLossValue;
                            final /* synthetic */ float[] $avgTrainingMetricValue;
                            {
                                this.$i = $i;
                                this.$avgLossValue = $avgLossValue;
                                this.$avgTrainingMetricValue = $avgTrainingMetricValue;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                StringBuilder stringBuilder = new StringBuilder().append("epochs: ").append(this.$i).append(" loss: ").append(this.$avgLossValue).append(" metric: ");
                                String string = Arrays.toString(this.$avgTrainingMetricValue);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                                return stringBuilder.append(string).toString();
                            }
                        });
                    }
                    trainingHistory.appendEpoch(epochTrainingEvent);
                    Iterable $this$forEach$iv5 = fitCallbacks;
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv : $this$forEach$iv5) {
                        Callback it8 = (Callback)element$iv;
                        boolean bl = false;
                        it8.onEpochEnd(i, epochTrainingEvent, trainingHistory);
                    }
                }
                if (i == epochs) break;
                ++i;
            }
        }
        $this$forEach$iv = fitCallbacks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Callback)element$iv;
            boolean bl = false;
            it.onTrainEnd(trainingHistory);
        }
        return trainingHistory;
    }

    private final Pair<Float, List<Float>> trainOnBatch(List<? extends Operand<Float>> targets, Tensor<Float> batchImages, Tensor<Float> batchLabels, Tensor<Float> numberOfLosses, Tensor<Float> isTraining, List<? extends Operand<Float>> metricOps) {
        Operand it;
        Session.Runner runner = this.getSession$tensorflow().runner();
        Iterable $this$forEach$iv = targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Operand)element$iv;
            boolean bl = false;
            runner.addTarget(it);
        }
        Operand<Float> operand = this.xOp;
        if (operand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xOp");
            operand = null;
        }
        Session.Runner runner2 = runner.feed((Operand)operand.asOutput(), batchImages);
        Operand<Float> operand2 = this.yTrueOp;
        if (operand2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yTrueOp");
            operand2 = null;
        }
        runner2.feed((Operand)operand2.asOutput(), batchLabels).feed((Operand)this.getNumberOfLossesOp().asOutput(), numberOfLosses).feed((Operand)this.getTraining().asOutput(), isTraining);
        runner.fetch("default_training_loss");
        $this$forEach$iv = metricOps;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Operand)element$iv;
            boolean bl = false;
            runner.fetch(it);
        }
        try {
            List list = runner.run();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runner.run()");
            return (Pair)AutoClosableExtensionsKt.use((List)list, (Function1)new Function1<List<? extends Tensor<?>>, Pair<? extends Float, ? extends List<Float>>>(metricOps){
                final /* synthetic */ List<Operand<Float>> $metricOps;
                {
                    this.$metricOps = $metricOps;
                    super(1);
                }

                @NotNull
                public final Pair<Float, List<Float>> invoke(@NotNull List<? extends Tensor<?>> tensorList) {
                    Intrinsics.checkNotNullParameter(tensorList, (String)"tensorList");
                    float lossValue = tensorList.get(0).floatValue();
                    List metricValues = new ArrayList<E>();
                    boolean bl = tensorList.size() == this.$metricOps.size() + 1;
                    List<Operand<Float>> list = this.$metricOps;
                    if (!bl) {
                        boolean bl2 = false;
                        String string = list.size() + " metrics are monitored, but " + (tensorList.size() - 1) + " metrics are returned!";
                        throw new IllegalStateException(string.toString());
                    }
                    int i = 1;
                    int n = this.$metricOps.size();
                    if (i <= n) {
                        while (true) {
                            metricValues.add(Float.valueOf(tensorList.get(i).floatValue()));
                            if (i == n) break;
                            ++i;
                        }
                    }
                    return TuplesKt.to((Object)Float.valueOf(lossValue), (Object)metricValues);
                }
            });
        }
        catch (TensorFlowException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EvaluationResult evaluate(@NotNull Dataset dataset, int batchSize, @NotNull List<? extends Callback> callbacks) {
        int it22;
        Object testLabelsTensor2;
        Object[] labelShape;
        int $i$f$forEach22;
        int n;
        Object it;
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$evaluate$32 = false;
            String $i$a$-check-GraphTrainableModel$evaluate$32 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$evaluate$32.toString());
        }
        if (!this.isModelInitialized()) {
            boolean $i$a$-check-GraphTrainableModel$evaluate$42 = false;
            String $i$a$-check-GraphTrainableModel$evaluate$42 = "The model is not initialized yet. Initialize the model weights with init() method or load weights to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$evaluate$42.toString());
        }
        History evaluationHistory = new History();
        Iterable $this$forEach$iv = callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Callback)element$iv;
            boolean bl = false;
            ((Callback)it).setModel$tensorflow(this);
        }
        $this$forEach$iv = callbacks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Callback)element$iv;
            n = 0;
            ((Callback)it).onTestBegin();
        }
        Dataset.BatchIterator batchIter = dataset.batchIterator(batchSize);
        int n2 = 0;
        int element$iv = this.getMetrics().size();
        it = new float[element$iv];
        while (n2 < element$iv) {
            n = n2++;
            it[n] = 0.0f;
        }
        Object averageMetricAccum = it;
        float averageLossAccum = 0.0f;
        int batchCounter = 0;
        while (batchIter.hasNext()) {
            Object it22;
            Iterable $this$forEach$iv2 = callbacks;
            $i$f$forEach22 = 0;
            for (Object element$iv2 : $this$forEach$iv2) {
                it22 = (Callback)element$iv2;
                boolean bl = false;
                ((Callback)it22).onTestBatchBegin(batchCounter, batchSize, evaluationHistory);
            }
            DataBatch batch = batchIter.next();
            Pair<long[], long[]> $i$f$forEach22 = this.calculateXYShapes(batch);
            long[] imageShape = (long[])$i$f$forEach22.component1();
            labelShape = (long[])$i$f$forEach22.component2();
            it22 = (AutoCloseable)Tensor.create((long[])imageShape, (FloatBuffer)ConvertersKt.serializeToBuffer(batch.getX()));
            Throwable bl = null;
            try {
                Tensor testImagesTensor = (Tensor)it22;
                boolean bl2 = false;
                AutoCloseable autoCloseable = (AutoCloseable)Tensor.create((long[])labelShape, (FloatBuffer)ConvertersKt.serializeLabelsToBuffer(batch.getY(), this.getNumberOfClasses()));
                Throwable throwable = null;
                try {
                    testLabelsTensor2 = (Tensor)autoCloseable;
                    boolean bl3 = false;
                    AutoCloseable autoCloseable2 = (AutoCloseable)Tensor.create((Object)Float.valueOf(new TensorShape((long[])labelShape).numElements()));
                    Throwable throwable2 = null;
                    try {
                        Tensor numberOfLossesTensor = (Tensor)autoCloseable2;
                        boolean bl4 = false;
                        AutoCloseable autoCloseable3 = (AutoCloseable)Tensor.create((Object)false);
                        Throwable throwable3 = null;
                        try {
                            Collection<Double> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Tensor isTraining = (Tensor)autoCloseable3;
                            boolean bl5 = false;
                            Session.Runner runner = this.getSession$tensorflow().runner().fetch("default_training_loss");
                            List<? extends Operand<Float>> list = this.metricOps;
                            if (list == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"metricOps");
                                list = null;
                            }
                            Iterable $this$forEach$iv3 = list;
                            boolean $i$f$forEach3 = false;
                            for (Object element$iv3 : $this$forEach$iv3) {
                                Operand it3 = (Operand)element$iv3;
                                boolean bl6 = false;
                                runner.fetch(it3);
                            }
                            Operand<Float> operand = this.xOp;
                            if (operand == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"xOp");
                                operand = null;
                            }
                            Session.Runner runner2 = runner.feed((Operand)operand.asOutput(), testImagesTensor);
                            Operand<Float> operand2 = this.yTrueOp;
                            if (operand2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"yTrueOp");
                                operand2 = null;
                            }
                            List list2 = runner2.feed((Operand)operand2.asOutput(), testLabelsTensor2).feed((Operand)this.getTraining().asOutput(), isTraining).feed((Operand)this.getNumberOfLossesOp().asOutput(), numberOfLossesTensor).run();
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"runner\n                 \u2026                   .run()");
                            Pair pair = (Pair)AutoClosableExtensionsKt.use((List)list2, (Function1)new Function1<List<? extends Tensor<?>>, Pair<? extends Float, ? extends List<Float>>>(this){
                                final /* synthetic */ GraphTrainableModel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                @NotNull
                                public final Pair<Float, List<Float>> invoke(@NotNull List<? extends Tensor<?>> lossAndMetricsTensors) {
                                    int n;
                                    Intrinsics.checkNotNullParameter(lossAndMetricsTensors, (String)"lossAndMetricsTensors");
                                    float lossValue = lossAndMetricsTensors.get(0).floatValue();
                                    List metricValues = new ArrayList<E>();
                                    int n2 = lossAndMetricsTensors.size();
                                    List list = GraphTrainableModel.access$getMetricOps$p(this.this$0);
                                    if (list == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"metricOps");
                                        list = null;
                                    }
                                    boolean bl = n2 == list.size() + 1;
                                    GraphTrainableModel graphTrainableModel = this.this$0;
                                    if (!bl) {
                                        boolean bl2 = false;
                                        StringBuilder stringBuilder = new StringBuilder();
                                        List list2 = GraphTrainableModel.access$getMetricOps$p(graphTrainableModel);
                                        if (list2 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"metricOps");
                                            list2 = null;
                                        }
                                        String string = stringBuilder.append(list2.size()).append(" metrics are monitored, but ").append(lossAndMetricsTensors.size() - 1).append(" metrics are returned!").toString();
                                        throw new IllegalStateException(string.toString());
                                    }
                                    int i = 1;
                                    List list3 = GraphTrainableModel.access$getMetricOps$p(this.this$0);
                                    if (list3 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"metricOps");
                                        list3 = null;
                                    }
                                    if (i <= (n = list3.size())) {
                                        while (true) {
                                            metricValues.add(Float.valueOf(lossAndMetricsTensors.get(i).floatValue()));
                                            if (i == n) break;
                                            ++i;
                                        }
                                    }
                                    return TuplesKt.to((Object)Float.valueOf(lossValue), (Object)metricValues);
                                }
                            });
                            float lossValue = ((Number)pair.component1()).floatValue();
                            List metricValues = (List)pair.component2();
                            averageLossAccum += lossValue;
                            Iterable $this$forEachIndexed$iv = this.getMetrics();
                            boolean $i$f$forEachIndexed22 = false;
                            int index$iv = 0;
                            for (Object item$iv : $this$forEachIndexed$iv) {
                                int n3;
                                if ((n3 = index$iv++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                Metric cfr_ignored_0 = (Metric)item$iv;
                                int i = n3;
                                boolean bl7 = false;
                                averageMetricAccum[i] = averageMetricAccum[i] + ((Number)metricValues.get(i)).floatValue();
                            }
                            Object $i$f$forEachIndexed22 = averageMetricAccum;
                            double d = lossValue;
                            int n4 = batchCounter;
                            boolean $i$f$map = false;
                            Iterator iterator = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                            boolean $i$f$mapTo = false;
                            int n5 = ((void)$this$mapTo$iv$iv).length;
                            for (int i = 0; i < n5; ++i) {
                                void it4;
                                void item$iv$iv;
                                void var45_89 = item$iv$iv = $this$mapTo$iv$iv[i];
                                collection = destination$iv$iv;
                                boolean bl8 = false;
                                collection.add((double)it4);
                            }
                            collection = (List)destination$iv$iv;
                            List list3 = collection;
                            double d2 = d;
                            int n6 = n4;
                            BatchEvent batchEvent = new BatchEvent(n6, d2, list3);
                            evaluationHistory.appendBatch(batchEvent);
                            Iterable $this$forEach$iv4 = callbacks;
                            boolean $i$f$forEach4 = false;
                            for (Object element$iv4 : $this$forEach$iv4) {
                                Callback it5 = (Callback)element$iv4;
                                boolean bl9 = false;
                                it5.onTestBatchEnd(batchCounter, batchSize, batchEvent, evaluationHistory);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                    }
                    testLabelsTensor2 = Unit.INSTANCE;
                }
                catch (Throwable testLabelsTensor2) {
                    throwable = testLabelsTensor2;
                    throw testLabelsTensor2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                testImagesTensor = Unit.INSTANCE;
            }
            catch (Throwable testImagesTensor) {
                bl = testImagesTensor;
                throw testImagesTensor;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)it22, (Throwable)bl);
            }
            it22 = batchCounter;
            batchCounter = it22 + 1;
        }
        $i$f$forEach22 = 0;
        int imageShape = this.getMetrics().size();
        labelShape = new float[imageShape];
        while ($i$f$forEach22 < imageShape) {
            it22 = $i$f$forEach22++;
            labelShape[it22] = 0.0f;
        }
        float[] avgMetricValue = labelShape;
        Object $this$forEachIndexed$iv = averageMetricAccum;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void metricValue;
            int n7 = index$iv++;
            Object bl2 = item$iv;
            int index = n7;
            boolean bl = false;
            avgMetricValue[index] = metricValue / (float)batchCounter;
        }
        double avgLossValue = averageLossAccum / (float)batchCounter;
        Iterable $this$forEach$iv5 = callbacks;
        boolean $i$f$forEach5 = false;
        for (Object element$iv5 : $this$forEach$iv5) {
            Callback it6 = (Callback)element$iv5;
            boolean bl = false;
            it6.onTestEnd(evaluationHistory);
        }
        Map metricValues = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv2 = this.getMetrics();
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void metric;
            int n8;
            if ((n8 = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            testLabelsTensor2 = (Metric)item$iv;
            int index = n8;
            boolean bl = false;
            metricValues.put(Metric.Companion.convertBack((Metric)metric), Double.valueOf(avgMetricValue[index]));
        }
        return new EvaluationResult(avgLossValue, metricValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public int[] predict(@NotNull Dataset dataset, int batchSize, @NotNull List<? extends Callback> callbacks) {
        boolean $i$f$forEach22;
        Iterable $this$forEach$iv;
        int n;
        Object it;
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        if (!(dataset.xSize() % batchSize == 0)) {
            boolean $i$a$-require-GraphTrainableModel$predict$22 = false;
            String $i$a$-require-GraphTrainableModel$predict$22 = "The amount of images must be a multiple of batch size.";
            throw new IllegalArgumentException($i$a$-require-GraphTrainableModel$predict$22.toString());
        }
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$predict$42 = false;
            String $i$a$-check-GraphTrainableModel$predict$42 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$predict$42.toString());
        }
        if (!this.isModelInitialized()) {
            boolean $i$a$-check-GraphTrainableModel$predict$52 = false;
            String $i$a$-check-GraphTrainableModel$predict$52 = "The model is not initialized yet. Initialize the model weights with init() method or load weights to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$predict$52.toString());
        }
        Iterable $this$forEach$iv2 = callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (Callback)element$iv;
            boolean bl = false;
            ((Callback)it).setModel$tensorflow(this);
        }
        $this$forEach$iv2 = callbacks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (Callback)element$iv;
            n = 0;
            ((Callback)it).onPredictBegin();
        }
        long[] imageShape = this.calculateXShape(batchSize);
        int n2 = 0;
        int element$iv = dataset.xSize();
        it = new int[element$iv];
        while (n2 < element$iv) {
            n = n2++;
            it[n] = Integer.MIN_VALUE;
        }
        Object predictions = it;
        Dataset.BatchIterator batchIter = dataset.batchIterator(batchSize);
        Ref.IntRef batchCounter = new Ref.IntRef();
        while (batchIter.hasNext()) {
            $this$forEach$iv = callbacks;
            $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Callback it2 = (Callback)element$iv2;
                boolean bl2 = false;
                it2.onPredictBatchBegin(batchCounter.element, batchSize);
            }
            DataBatch batch = batchIter.next();
            AutoCloseable $i$f$forEach22 = (AutoCloseable)Tensor.create((long[])imageShape, (FloatBuffer)ConvertersKt.serializeToBuffer(batch.getX()));
            Object object = null;
            try {
                int[] nArray;
                Object testImages2 = (Tensor)$i$f$forEach22;
                boolean bl = false;
                AutoCloseable bl2 = (AutoCloseable)Tensor.create((Object)false);
                Throwable throwable = null;
                try {
                    Tensor isTraining = (Tensor)bl2;
                    boolean bl3 = false;
                    Session.Runner runner = this.getSession$tensorflow().runner();
                    Operand<Float> operand = this.predictionOp;
                    if (operand == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"predictionOp");
                        operand = null;
                    }
                    Session.Runner runner2 = runner.fetch(operand);
                    Operand<Float> operand2 = this.xOp;
                    if (operand2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"xOp");
                        operand2 = null;
                    }
                    List list = runner2.feed((Operand)operand2.asOutput(), testImages2).feed((Operand)this.getTraining().asOutput(), isTraining).run();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"session.runner()\n       \u2026                   .run()");
                    nArray = (int[])AutoClosableExtensionsKt.use((List)list, (Function1)new Function1<List<? extends Tensor<?>>, int[]>(imageShape, this, callbacks, batchCounter, (int[])predictions, batchSize){
                        final /* synthetic */ long[] $imageShape;
                        final /* synthetic */ GraphTrainableModel this$0;
                        final /* synthetic */ List<Callback> $callbacks;
                        final /* synthetic */ Ref.IntRef $batchCounter;
                        final /* synthetic */ int[] $predictions;
                        final /* synthetic */ int $batchSize;
                        {
                            this.$imageShape = $imageShape;
                            this.this$0 = $receiver;
                            this.$callbacks = $callbacks;
                            this.$batchCounter = $batchCounter;
                            this.$predictions = $predictions;
                            this.$batchSize = $batchSize;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final int[] invoke(@NotNull List<? extends Tensor<?>> tensors) {
                            void n10;
                            int n;
                            Intrinsics.checkNotNullParameter(tensors, (String)"tensors");
                            int n2 = (int)this.$imageShape[0];
                            float[][] fArrayArray = new float[n2][];
                            for (int i = 0; i < n2; ++i) {
                                int n3 = i;
                                n = 0;
                                int n4 = (int)this.this$0.getNumberOfClasses();
                                float[] fArray = new float[n4];
                                int n5 = n3;
                                float[][] fArrayArray2 = fArrayArray;
                                while (n < n4) {
                                    int n6 = n++;
                                    fArray[n6] = 0.0f;
                                }
                                fArrayArray2[n5] = fArray;
                            }
                            float[][] dst = fArrayArray;
                            ((Tensor)CollectionsKt.first(tensors)).copyTo((Object)dst);
                            boolean bl = false;
                            int n7 = (int)this.$imageShape[0];
                            int[] nArray = new int[n7];
                            while (n10 < n7) {
                                n = n10++;
                                nArray[n] = 0;
                            }
                            int[] argMaxBatchPrediction = nArray;
                            Object[] objectArray = (Object[])dst;
                            boolean $i$f$forEachIndexed = false;
                            int index$iv = 0;
                            for (Object item$iv : objectArray) {
                                void element;
                                int n8 = index$iv++;
                                float[] fArray = (float[])item$iv;
                                int index = n8;
                                boolean bl2 = false;
                                argMaxBatchPrediction[index] = FloatArrayExtensionFunctionsKt.argmax((float[])element);
                            }
                            Iterable iterable = this.$callbacks;
                            Ref.IntRef intRef = this.$batchCounter;
                            int n9 = this.$batchSize;
                            boolean $i$f$forEach = false;
                            for (T element$iv : iterable) {
                                Callback it = (Callback)element$iv;
                                boolean bl3 = false;
                                it.onPredictBatchEnd(intRef.element, n9);
                            }
                            int n11 = this.$batchCounter.element;
                            this.$batchCounter.element = n11 + 1;
                            return ArraysKt.copyInto$default((int[])argMaxBatchPrediction, (int[])this.$predictions, (int)(this.$batchSize * (this.$batchCounter.element - 1)), (int)0, (int)0, (int)12, null);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)bl2, (Throwable)throwable);
                }
                testImages2 = nArray;
            }
            catch (Throwable testImages2) {
                try {
                    object = testImages2;
                    throw testImages2;
                }
                catch (Throwable testImages2) {
                    AutoCloseableKt.closeFinally((AutoCloseable)$i$f$forEach22, object);
                    throw testImages2;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$forEach22, (Throwable)object);
        }
        $this$forEach$iv = callbacks;
        $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Callback it3 = (Callback)element$iv2;
            boolean bl = false;
            it3.onPredictEnd();
        }
        return predictions;
    }

    @Override
    public int predict(@NotNull float[] inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        float[] softPrediction = InferenceModel.DefaultImpls.predictSoftly$default((InferenceModel)this, (float[])inputData, null, (int)2, null);
        return FloatArrayExtensionFunctionsKt.argmax((float[])softPrediction);
    }

    @Override
    public int predict(@NotNull float[] inputData, @NotNull String predictionTensorName) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Intrinsics.checkNotNullParameter((Object)predictionTensorName, (String)"predictionTensorName");
        float[] softPrediction = this.predictSoftly(inputData, predictionTensorName);
        return FloatArrayExtensionFunctionsKt.argmax((float[])softPrediction);
    }

    @Override
    @NotNull
    public Pair<Integer, List<?>> predictAndGetActivations(@NotNull float[] inputData, @NotNull String predictionTensorName) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Intrinsics.checkNotNullParameter((Object)predictionTensorName, (String)"predictionTensorName");
        Pair<float[], List<?>> pair = this.internalPredict(inputData, true, predictionTensorName);
        float[] softPrediction = (float[])pair.component1();
        List activations = (List)pair.component2();
        return new Pair((Object)FloatArrayExtensionFunctionsKt.argmax((float[])softPrediction), (Object)activations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public float[][] predictSoftly(@NotNull Dataset dataset, int batchSize, @NotNull List<? extends Callback> callbacks) {
        boolean $i$f$forEach22;
        Iterable $this$forEach$iv;
        int n;
        Object it;
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        if (!(dataset.xSize() % batchSize == 0)) {
            boolean $i$a$-require-GraphTrainableModel$predictSoftly$22 = false;
            String $i$a$-require-GraphTrainableModel$predictSoftly$22 = "The amount of images must be a multiple of batch size.";
            throw new IllegalArgumentException($i$a$-require-GraphTrainableModel$predictSoftly$22.toString());
        }
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$predictSoftly$42 = false;
            String $i$a$-check-GraphTrainableModel$predictSoftly$42 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$predictSoftly$42.toString());
        }
        if (!this.isModelInitialized()) {
            boolean $i$a$-check-GraphTrainableModel$predictSoftly$52 = false;
            String $i$a$-check-GraphTrainableModel$predictSoftly$52 = "The model is not initialized yet. Initialize the model weights with init() method or load weights to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$predictSoftly$52.toString());
        }
        Iterable $this$forEach$iv2 = callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (Callback)element$iv;
            boolean bl = false;
            ((Callback)it).setModel$tensorflow(this);
        }
        $this$forEach$iv2 = callbacks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (Callback)element$iv;
            n = 0;
            ((Callback)it).onPredictBegin();
        }
        long[] imageShape = this.calculateXShape(batchSize);
        int element$iv = dataset.xSize();
        it = new float[element$iv][];
        for (int i = 0; i < element$iv; ++i) {
            n = i;
            int n2 = 0;
            int n3 = (int)this.getNumberOfClasses();
            float[] fArray = new float[n3];
            int n4 = n;
            Object object = it;
            while (n2 < n3) {
                int n5 = n2++;
                fArray[n5] = 0.0f;
            }
            object[n4] = fArray;
        }
        Object predictions = it;
        Dataset.BatchIterator batchIter = dataset.batchIterator(batchSize);
        Ref.IntRef batchCounter = new Ref.IntRef();
        while (batchIter.hasNext()) {
            $this$forEach$iv = callbacks;
            $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Callback it2 = (Callback)element$iv2;
                boolean bl = false;
                it2.onPredictBatchBegin(batchCounter.element, batchSize);
            }
            DataBatch batch = batchIter.next();
            AutoCloseable $i$f$forEach22 = (AutoCloseable)Tensor.create((long[])imageShape, (FloatBuffer)ConvertersKt.serializeToBuffer(batch.getX()));
            Object object = null;
            try {
                Object testImages2 = (Tensor)$i$f$forEach22;
                boolean bl = false;
                Session.Runner runner = this.getSession$tensorflow().runner();
                Operand<Float> operand = this.predictionOp;
                if (operand == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"predictionOp");
                    operand = null;
                }
                Session.Runner runner2 = runner.fetch(operand);
                Operand<Float> operand2 = this.xOp;
                if (operand2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xOp");
                    operand2 = null;
                }
                List list = runner2.feed((Operand)operand2.asOutput(), testImages2).run();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"session.runner()\n       \u2026                   .run()");
                testImages2 = (float[][])AutoClosableExtensionsKt.use((List)list, (Function1)new Function1<List<? extends Tensor<?>>, float[][]>(imageShape, this, callbacks, batchCounter, (float[][])predictions, batchSize){
                    final /* synthetic */ long[] $imageShape;
                    final /* synthetic */ GraphTrainableModel this$0;
                    final /* synthetic */ List<Callback> $callbacks;
                    final /* synthetic */ Ref.IntRef $batchCounter;
                    final /* synthetic */ float[][] $predictions;
                    final /* synthetic */ int $batchSize;
                    {
                        this.$imageShape = $imageShape;
                        this.this$0 = $receiver;
                        this.$callbacks = $callbacks;
                        this.$batchCounter = $batchCounter;
                        this.$predictions = $predictions;
                        this.$batchSize = $batchSize;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final float[][] invoke(@NotNull List<? extends Tensor<?>> tensors) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter(tensors, (String)"tensors");
                        int n = (int)this.$imageShape[0];
                        float[][] fArrayArray = new float[n][];
                        for (int i = 0; i < n; ++i) {
                            int n2 = i;
                            int n3 = 0;
                            int n4 = (int)this.this$0.getNumberOfClasses();
                            float[] fArray = new float[n4];
                            int n5 = n2;
                            float[][] fArrayArray2 = fArrayArray;
                            while (n3 < n4) {
                                int n6 = n3++;
                                fArray[n6] = 0.0f;
                            }
                            fArrayArray2[n5] = fArray;
                        }
                        float[][] dst = fArrayArray;
                        ((Tensor)CollectionsKt.first(tensors)).copyTo((Object)dst);
                        Iterable iterable = this.$callbacks;
                        Ref.IntRef intRef = this.$batchCounter;
                        int n7 = this.$batchSize;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Callback it = (Callback)element$iv;
                            boolean bl = false;
                            it.onPredictBatchEnd(intRef.element, n7);
                        }
                        int n8 = this.$batchCounter.element;
                        this.$batchCounter.element = n8 + 1;
                        return (float[][])ArraysKt.copyInto$default((Object[])((Object[])dst), (Object[])((Object[])this.$predictions), (int)(this.$batchSize * (this.$batchCounter.element - 1)), (int)0, (int)0, (int)12, null);
                    }
                });
            }
            catch (Throwable testImages2) {
                try {
                    object = testImages2;
                    throw testImages2;
                }
                catch (Throwable testImages2) {
                    AutoCloseableKt.closeFinally((AutoCloseable)$i$f$forEach22, object);
                    throw testImages2;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$forEach22, (Throwable)object);
        }
        $this$forEach$iv = callbacks;
        $i$f$forEach22 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Callback it3 = (Callback)element$iv3;
            boolean bl = false;
            it3.onPredictEnd();
        }
        return predictions;
    }

    @Override
    @NotNull
    public float[] predictSoftly(@NotNull float[] inputData, @NotNull String predictionTensorName) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Intrinsics.checkNotNullParameter((Object)predictionTensorName, (String)"predictionTensorName");
        float[] softPrediction = (float[])this.internalPredict(inputData, false, predictionTensorName).component1();
        return softPrediction;
    }

    @Override
    @NotNull
    protected Pair<float[], List<?>> predictSoftlyAndGetActivations(@NotNull float[] inputData, @NotNull String predictionTensorName) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Intrinsics.checkNotNullParameter((Object)predictionTensorName, (String)"predictionTensorName");
        return this.internalPredict(inputData, true, predictionTensorName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<float[], List<?>> internalPredict(float[] inputData, boolean visualizationIsEnabled, String predictionTensorName) {
        Pair pair;
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$internalPredict$32 = false;
            String $i$a$-check-GraphTrainableModel$internalPredict$32 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$internalPredict$32.toString());
        }
        if (!this.isModelInitialized()) {
            boolean bl = false;
            String string = "The model is not initialized yet. Initialize the model weights with init() method or load weights to use this method.";
            throw new IllegalStateException(string.toString());
        }
        long[] imageShape = this.calculateXShape(1);
        AutoCloseable autoCloseable = (AutoCloseable)Tensor.create((long[])imageShape, (FloatBuffer)FloatBuffer.wrap(inputData));
        Throwable throwable = null;
        try {
            Tensor testImages = (Tensor)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)testImages, (String)"testImages");
            pair = (Pair)AutoClosableExtensionsKt.use(this.formPredictionAndActivationsTensors(predictionTensorName, (Tensor<Float>)testImages, visualizationIsEnabled), (Function1)new Function1<List<? extends Tensor<?>>, Pair<? extends float[], ? extends List<Object>>>(visualizationIsEnabled){
                final /* synthetic */ boolean $visualizationIsEnabled;
                {
                    this.$visualizationIsEnabled = $visualizationIsEnabled;
                    super(1);
                }

                @NotNull
                public final Pair<float[], List<Object>> invoke(@NotNull List<? extends Tensor<?>> tensors) {
                    Intrinsics.checkNotNullParameter(tensors, (String)"tensors");
                    float[] prediction = TensorExtensionFunctionsKt.convertTensorToFlattenFloatArray(tensors.get(0));
                    List activations = new ArrayList<E>();
                    if (this.$visualizationIsEnabled && tensors.size() > 1) {
                        int n = tensors.size();
                        for (int i = 1; i < n; ++i) {
                            activations.add(TensorExtensionFunctionsKt.convertTensorToMultiDimArray(tensors.get(i)));
                        }
                    }
                    return TuplesKt.to((Object)prediction, (Object)activations);
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return pair;
    }

    private final List<Tensor<?>> formPredictionAndActivationsTensors(String predictionTensorName, Tensor<Float> testImages, boolean visualizationIsEnabled) {
        Session.Runner runner = this.getSession$tensorflow().runner();
        if (((CharSequence)predictionTensorName).length() == 0) {
            Operand<Float> operand = this.predictionOp;
            if (operand == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"predictionOp");
                operand = null;
            }
            Session.Runner runner2 = runner.fetch(operand);
            Operand<Float> operand2 = this.xOp;
            if (operand2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xOp");
                operand2 = null;
            }
            runner2.feed((Operand)operand2.asOutput(), testImages);
        } else {
            if (!(this.kGraph().getTfGraph$tensorflow().operation(predictionTensorName) != null)) {
                boolean bl = false;
                String string = "No such tensor output named [" + predictionTensorName + "] in the TensorFlow graph!";
                throw new IllegalArgumentException(string.toString());
            }
            Session.Runner runner3 = runner.fetch(predictionTensorName);
            Operand<Float> operand = this.xOp;
            if (operand == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xOp");
                operand = null;
            }
            runner3.feed((Operand)operand.asOutput(), testImages);
        }
        if (visualizationIsEnabled) {
            for (Layer layer : this.layers) {
                if (!layer.getHasActivation() || Intrinsics.areEqual((Object)layer, (Object)CollectionsKt.last(this.layers))) continue;
                runner.fetch(NameConventionsKt.defaultActivationName(layer));
            }
        }
        List list = runner.run();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runner.run()");
        return list;
    }

    private final Pair<long[], long[]> calculateXYShapes(DataBatch batch) {
        int batchSize = batch.getSize();
        long[] xBatchShape = this.calculateXShape(batchSize);
        long[] yBatchShape = this.calculateYShape(batchSize);
        if (batchSize > 0) {
            this.batchValidation(batch, xBatchShape, yBatchShape);
        }
        return new Pair((Object)xBatchShape, (Object)yBatchShape);
    }

    private final long[] calculateYShape(int batchSize) {
        long[] lArray = new long[]{batchSize, this.getNumberOfClasses()};
        return lArray;
    }

    private final void batchValidation(DataBatch batch, long[] xBatchShape, long[] yBatchShape) {
        if (!((int)new TensorShape(xBatchShape).numElements() == ((Object[])batch.getX()).length * batch.getX()[0].length)) {
            boolean $i$a$-check-GraphTrainableModel$batchValidation$32 = false;
            StringBuilder stringBuilder = new StringBuilder().append("The calculated [from the Model] data batch shape ");
            String string = Arrays.toString(xBatchShape);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            String $i$a$-check-GraphTrainableModel$batchValidation$32 = stringBuilder.append(string).append(" doesn't match actual data buffer size ").append(((Object[])batch.getX()).length * batch.getX()[0].length).append(". Please, check input data.").toString();
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$batchValidation$32.toString());
        }
        if (!((int)new TensorShape(yBatchShape).numElements() == batch.getY().length * (int)this.getNumberOfClasses())) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("The calculated [from the model] label batch shape ");
            String string = Arrays.toString(yBatchShape);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            String string2 = stringBuilder.append(string).append(" doesn't match actual data buffer size ").append(batch.getY().length * (int)this.getNumberOfClasses()).append(". \nPlease, check the input label data or correct number of classes [number of neurons] in last Dense layer, if you have a classification problem.\nHighly likely, you have different number of classes presented in data and described in model as desired output.").toString();
            throw new IllegalStateException(string2.toString());
        }
    }

    private final long[] calculateXShape(int batchSize) {
        Object object = CollectionsKt.first(this.layers);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dl.api.core.layer.core.Input");
        Input inputLayer = (Input)object;
        Shape xTensorShape = inputLayer.getInput().asOutput().shape();
        LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(2);
        longSpreadBuilder.add((long)batchSize);
        Intrinsics.checkNotNullExpressionValue((Object)xTensorShape, (String)"xTensorShape");
        longSpreadBuilder.addSpread((Object)ShapeFunctionsKt.tail(xTensorShape));
        return longSpreadBuilder.toArray();
    }

    @NotNull
    public final KGraph kGraph() {
        return this.getKGraph();
    }

    @Override
    public void save(@NotNull File modelDirectory, @NotNull SavingFormat savingFormat, boolean saveOptimizerState, @NotNull WritingMode writingMode) {
        Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)savingFormat), (String)"savingFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)writingMode), (String)"writingMode");
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$save$52 = false;
            String $i$a$-check-GraphTrainableModel$save$52 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$save$52.toString());
        }
        if (!this.isModelInitialized()) {
            boolean $i$a$-check-GraphTrainableModel$save$62 = false;
            String $i$a$-check-GraphTrainableModel$save$62 = "The model is not initialized yet. Initialize the model weights with init() method or load weights to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$save$62.toString());
        }
        if (saveOptimizerState && !this.isOptimizerVariableInitialized()) {
            boolean bl = false;
            String string = "The optimizer variables are not initialized yet. Initialize the optimizer variables with init() method or load optimizer weights to use this method.";
            throw new IllegalStateException(string.toString());
        }
        String pathToModelDirectory = modelDirectory.getAbsolutePath();
        switch (WhenMappings.$EnumSwitchMapping$0[writingMode.ordinal()]) {
            case 1: {
                if (!(!modelDirectory.exists())) {
                    boolean bl = false;
                    String string = "The directory exists on path " + pathToModelDirectory + ", please be careful it could contain valuable model! Change this mode to OVERRIDE if you want to override this directory.";
                    throw new IllegalStateException(string.toString());
                }
                Files.createDirectories(modelDirectory.toPath(), new FileAttribute[0]);
                break;
            }
            case 2: {
                if (modelDirectory.exists()) {
                    FilesKt.deleteRecursively((File)modelDirectory);
                }
                Files.createDirectories(modelDirectory.toPath(), new FileAttribute[0]);
                break;
            }
            case 3: {
                if (modelDirectory.exists()) break;
                Files.createDirectories(modelDirectory.toPath(), new FileAttribute[0]);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[savingFormat.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)pathToModelDirectory, (String)"pathToModelDirectory");
                this.saveInSimpleFormat(pathToModelDirectory, saveOptimizerState);
                break;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)pathToModelDirectory, (String)"pathToModelDirectory");
                this.saveInSavedModelFormat(pathToModelDirectory);
                break;
            }
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)pathToModelDirectory, (String)"pathToModelDirectory");
                this.saveInKerasFormat(pathToModelDirectory, saveOptimizerState);
            }
        }
    }

    private final void saveInKerasFormat(String pathToModelDirectory, boolean saveOptimizerState) {
        this.saveModel(pathToModelDirectory);
        this.saveVariables(pathToModelDirectory, saveOptimizerState);
    }

    private final void saveModel(String pathToModelDirectory) {
        File jsonConfig = new File(pathToModelDirectory + "/modelConfig.json");
        ModelSaverKt.saveModelConfiguration$default(this, jsonConfig, false, 2, null);
    }

    private final void saveInSavedModelFormat(String pathToModelDirectory) {
        this.saveGraphDef(pathToModelDirectory);
    }

    private final void saveInSimpleFormat(String pathToModelDirectory, boolean saveOptimizerState) {
        this.saveGraphDef(pathToModelDirectory);
        this.saveVariables(pathToModelDirectory, saveOptimizerState);
    }

    private final void saveGraphDef(String pathToModelDirectory) {
        File file = new File(pathToModelDirectory + "/graph.pb");
        Files.createDirectories(Paths.get(pathToModelDirectory, new String[0]), new FileAttribute[0]);
        byte[] byArray = this.getKGraph().getTfGraph$tensorflow().toGraphDef();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"kGraph.tfGraph.toGraphDef()");
        FilesKt.writeBytes((File)file, (byte[])byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void saveVariables(@NotNull String pathToModelDirectory, boolean saveOptimizerState) {
        Intrinsics.checkNotNullParameter((Object)pathToModelDirectory, (String)"pathToModelDirectory");
        List<Pair<Variable<Float>, Tensor<?>>> variablesAndTensors = this.getVariablesAndTensors(saveOptimizerState);
        Files.createDirectories(Paths.get(pathToModelDirectory, new String[0]), new FileAttribute[0]);
        File file = new File(pathToModelDirectory + "/variableNames.txt");
        Object object = file;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter variableNamesFile = (BufferedWriter)object;
            boolean bl = false;
            for (Pair<Variable<Float>, Tensor<?>> pair : variablesAndTensors) {
                Variable variable = (Variable)pair.component1();
                Tensor tensorForCopying = (Tensor)pair.component2();
                String variableName = variable.asOutput().op().name();
                variableNamesFile.write(variableName);
                variableNamesFile.newLine();
                File variableNameFile = new File(pathToModelDirectory + '/' + variableName + ".txt");
                Object object4 = variableNameFile;
                Object object5 = Charsets.UTF_8;
                int n2 = 8192;
                Object object6 = object4;
                object6 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object6), (Charset)object5);
                object4 = object6 instanceof BufferedWriter ? (BufferedWriter)object6 : new BufferedWriter((Writer)object6, n2);
                object5 = null;
                try {
                    BufferedWriter file2 = (BufferedWriter)object4;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable = (AutoCloseable)tensorForCopying;
                    Throwable throwable = null;
                    try {
                        Tensor it = (Tensor)autoCloseable;
                        boolean bl3 = false;
                        float[] reshaped = TensorExtensionFunctionsKt.convertTensorToFlattenFloatArray(tensorForCopying);
                        int i = 0;
                        int n3 = reshaped.length - 2;
                        if (i <= n3) {
                            while (true) {
                                file2.write("" + reshaped[i] + ' ');
                                if (i == n3) break;
                                ++i;
                            }
                        }
                        file2.write(String.valueOf(reshaped[reshaped.length - 1]));
                        file2.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object5 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object4, (Throwable)object5);
                }
                variableNamesFile.flush();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Variable<Float>, Tensor<?>>> getVariablesAndTensors(boolean saveOptimizerState) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.layerVariables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KVariable kVariable = (KVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVariable());
        }
        List variables2 = (List)destination$iv$iv;
        if (saveOptimizerState) {
            variables2 = CollectionsKt.plus((Collection)variables2, (Iterable)this.getKGraph().optimizerVariables());
        }
        Session.Runner modelWeightsExtractorRunner = this.getSession$tensorflow().runner();
        Iterable $this$forEach$iv = variables2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operand p0 = (Operand)element$iv;
            boolean bl = false;
            modelWeightsExtractorRunner.fetch(p0);
        }
        Iterable iterable2 = variables2;
        List list = modelWeightsExtractorRunner.run();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"modelWeightsExtractorRunner.run()");
        return CollectionsKt.zip((Iterable)iterable2, (Iterable)list);
    }

    @Override
    public void loadWeights(@NotNull File modelDirectory, boolean loadOptimizerState) {
        Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$loadWeights$32 = false;
            String $i$a$-check-GraphTrainableModel$loadWeights$32 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$loadWeights$32.toString());
        }
        if (!(!this.isModelInitialized())) {
            boolean bl = false;
            String string = "The model is initialized already.";
            throw new IllegalStateException(string.toString());
        }
        Files.createDirectories(modelDirectory.toPath(), new FileAttribute[0]);
        String string = modelDirectory.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modelDirectory.path");
        this.loadVariablesFromTxt(string, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this, loadOptimizerState){
            final /* synthetic */ GraphTrainableModel this$0;
            final /* synthetic */ boolean $loadOptimizerState;
            {
                this.this$0 = $receiver;
                this.$loadOptimizerState = $loadOptimizerState;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String variableName) {
                Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
                return !GraphTrainableModel.access$isOptimizerVariable(this.this$0, variableName) ? true : (this.$loadOptimizerState ? !GraphTrainableModel.access$isVariableRelatedToFrozenLayer(this.this$0, variableName) : false);
            }
        }));
        this.setModelInitialized$tensorflow(true);
        if (loadOptimizerState) {
            this.setOptimizerVariableInitialized$tensorflow(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isVariableRelatedToFrozenLayer(String variableName) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.frozenLayerVariables();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KVariable kVariable = (KVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.contains$default((CharSequence)variableName, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void loadVariables(@NotNull Collection<String> variableNames, @NotNull Function2<? super String, ? super Shape, ? extends Object> getData) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(variableNames, (String)"variableNames");
        Intrinsics.checkNotNullParameter(getData, (String)"getData");
        Iterable $this$associateBy$iv = this.layerVariables();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KVariable kVariable = (KVariable)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map layerVariablesByName = destination$iv$iv;
        for (String variableName : variableNames) {
            GraphOperation variableOperation = this.getKGraph().getTfGraph$tensorflow().operation(variableName);
            if (!(variableOperation != null)) {
                boolean $i$a$-check-GraphTrainableModel$loadVariables$22 = false;
                String $i$a$-check-GraphTrainableModel$loadVariables$22 = "Operation " + variableName + " is not found in static graph.";
                throw new IllegalStateException($i$a$-check-GraphTrainableModel$loadVariables$22.toString());
            }
            Shape variableShape = variableOperation.output(0).shape();
            Intrinsics.checkNotNullExpressionValue((Object)variableShape, (String)"variableShape");
            Object data = getData.invoke((Object)variableName, (Object)variableShape);
            KVariable variable = (KVariable)layerVariablesByName.get(variableName);
            if (variable != null) {
                this.fill$tensorflow(variable, data);
                continue;
            }
            this.assignVariable(variableName, variableShape, data);
        }
    }

    public final void fill$tensorflow(@NotNull KVariable variable, @NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        variable.getInitializerOperation().fill(data, this.getSession$tensorflow());
    }

    public final void init$tensorflow(@NotNull KVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        variable.getInitializerOperation().run(this.getSession$tensorflow());
    }

    @NotNull
    public final Layer getLayer(@NotNull String layerName) {
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        Layer layer = this.layersByName.get(layerName);
        if (layer == null) {
            throw new IllegalStateException(("No such layer " + layerName + " in the model.").toString());
        }
        return layer;
    }

    @Override
    @NotNull
    public String toString() {
        return "GraphTrainableModel(numberOfLayers=" + this.layers.size() + ") " + super.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TfModelSummary summary() {
        long l;
        Layer it;
        long l2;
        Collection<LayerSummary> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-GraphTrainableModel$summary$22 = false;
            String $i$a$-check-GraphTrainableModel$summary$22 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-GraphTrainableModel$summary$22.toString());
        }
        Iterable $this$partition$iv = this.layers;
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Layer it2 = (Layer)element$iv;
            boolean bl = false;
            if (TrainableLayerKt.isTrainable(it2)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List trainableLayers = (List)pair.component1();
        List frozenLayers = (List)pair.component2();
        first$iv = this.layers;
        String string = this.getName();
        String string2 = String.valueOf(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void layer;
            Layer layer2 = (Layer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable = layer.getInboundLayers();
            long l3 = ParametrizedLayerKt.getParamCount((Layer)layer);
            TensorShape tensorShape = layer.getOutputShape();
            String string3 = String.valueOf(Reflection.getOrCreateKotlinClass(layer.getClass()).getSimpleName());
            String string4 = layer.getName();
            boolean $i$f$map2 = false;
            void var20_32 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it3;
                Layer layer3 = (Layer)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(it3.getName());
            }
            Collection<String> collection3 = collection2 = (List)destination$iv$iv2;
            long l4 = l3;
            TensorShape tensorShape2 = tensorShape;
            String string5 = string3;
            String string6 = string4;
            collection.add(new LayerSummary(string6, string5, tensorShape2, l4, (List<String>)collection3));
        }
        collection = (List)destination$iv$iv;
        Iterable iterable = trainableLayers;
        long l5 = 0L;
        for (Object t : iterable) {
            Layer bl = (Layer)t;
            l2 = l5;
            boolean bl3 = false;
            l = ParametrizedLayerKt.getParamCount(it);
            l5 = l2 + l;
        }
        l2 = l5;
        iterable = frozenLayers;
        l5 = 0L;
        for (Object t : iterable) {
            it = (Layer)t;
            l = l5;
            boolean bl = false;
            long l6 = ParametrizedLayerKt.getParamCount(it);
            l5 = l + l6;
        }
        long l7 = l = l5;
        long l8 = l2;
        Collection<LayerSummary> collection4 = collection;
        String string7 = string;
        String string8 = string2;
        return new TfModelSummary(string8, string7, (List<LayerSummary>)collection4, l8, l7);
    }

    public static final /* synthetic */ boolean access$isOptimizerVariable(GraphTrainableModel $this, String variableName) {
        return $this.isOptimizerVariable(variableName);
    }

    public static final /* synthetic */ boolean access$isVariableRelatedToFrozenLayer(GraphTrainableModel $this, String variableName) {
        return $this.isVariableRelatedToFrozenLayer(variableName);
    }

    public static final /* synthetic */ List access$getMetricOps$p(GraphTrainableModel $this) {
        return $this.metricOps;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b\bJ\u001f\u0010\t\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel$Companion;", "", "()V", "layerValidation", "", "layers", "", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "layerValidation$tensorflow", "preProcessLayerNames", "", "preProcessLayerNames$tensorflow", "([Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;)V", "tensorflow"})
    @SourceDebugExtension(value={"SMAP\nGraphTrainableModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphTrainableModel.kt\norg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1015:1\n1#2:1016\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void preProcessLayerNames$tensorflow(@NotNull Layer[] layers) {
            Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
            int n = layers.length;
            for (int i = 0; i < n; ++i) {
                int index = i;
                Layer layer = layers[i];
                if (!(((CharSequence)layer.getName()).length() == 0)) continue;
                String string = Reflection.getOrCreateKotlinClass(layer.getClass()).getSimpleName();
                if (string == null) {
                    string = "layer";
                }
                String simpleName = string;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = simpleName;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                layer.setName(stringBuilder.append(string3).append('_').append(index + 1).toString());
            }
        }

        public final void layerValidation$tensorflow(@NotNull List<? extends Layer> layers) {
            Intrinsics.checkNotNullParameter(layers, (String)"layers");
            if (!(!((Collection)layers).isEmpty())) {
                boolean bl = false;
                String string = "Model should contain layers!";
                throw new IllegalArgumentException(string.toString());
            }
            Layer input = layers.get(0);
            if (!(input instanceof Input)) {
                boolean bl = false;
                String string = "Model should start from the Input layer";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WritingMode.values().length];
            try {
                nArray[WritingMode.FAIL_IF_EXISTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WritingMode.OVERRIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WritingMode.APPEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SavingFormat.values().length];
            try {
                nArray[SavingFormat.TF_GRAPH_CUSTOM_VARIABLES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SavingFormat.TF_GRAPH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

