/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.Functional;
import org.jetbrains.kotlinx.dl.api.core.GraphTrainableModel;
import org.jetbrains.kotlinx.dl.api.core.SavingFormat;
import org.jetbrains.kotlinx.dl.api.core.Sequential;
import org.jetbrains.kotlinx.dl.api.core.WritingMode;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.LayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.TrainableLayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.WeightsKt;
import org.jetbrains.kotlinx.dl.api.core.layer.core.Input;
import org.jetbrains.kotlinx.dl.api.core.util.GraphUtilKt;
import org.jetbrains.kotlinx.dl.api.inference.keras.ModelLoaderKt;
import org.jetbrains.kotlinx.dl.api.inference.keras.ModelSaverKt;
import org.jetbrains.kotlinx.dl.api.inference.keras.config.KerasModel;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Placeholder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J<\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\nH\u0014J\u001a\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\u0000J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001a\u0010 \u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\fH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "layers", "", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "([Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;)V", "buildLayers", "Lkotlin/Pair;", "Lorg/tensorflow/op/core/Placeholder;", "", "Lorg/tensorflow/Operand;", "training", "", "numberOfLosses", "copy", "saveOptimizerState", "copyWeights", "removeLastLayer", "save", "", "modelDirectory", "Ljava/io/File;", "savingFormat", "Lorg/jetbrains/kotlinx/dl/api/core/SavingFormat;", "writingMode", "Lorg/jetbrains/kotlinx/dl/api/core/WritingMode;", "saveGraphDef", "pathToModelDirectory", "", "saveInKerasFormat", "saveInSavedModelFormat", "saveInSimpleFormat", "saveModel", "isKerasFullyCompatible", "Companion", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nFunctional.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Functional.kt\norg/jetbrains/kotlinx/dl/api/core/Functional\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n766#2:386\n857#2,2:387\n1855#2:389\n1549#2:390\n1620#2,3:391\n1856#2:394\n1855#2,2:396\n1#3:395\n*S KotlinDebug\n*F\n+ 1 Functional.kt\norg/jetbrains/kotlinx/dl/api/core/Functional\n*L\n267#1:386\n267#1:387,2\n267#1:389\n268#1:390\n268#1:391,3\n267#1:394\n356#1:396,2\n*E\n"})
public final class Functional
extends GraphTrainableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public Functional(Layer ... layers) {
        Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
        super(Arrays.copyOf(layers, layers.length));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Pair<Placeholder<Float>, Operand<Float>> buildLayers(@NotNull Operand<Boolean> training, @NotNull Operand<Float> numberOfLosses) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(training, (String)"training");
        Intrinsics.checkNotNullParameter(numberOfLosses, (String)"numberOfLosses");
        Placeholder<Float> input = this.getInputLayer().build(this.getTf());
        Layer layer = this.getInputLayer();
        Shape shape = input.asOutput().shape();
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"input.asOutput().shape()");
        LayerKt.setOutputShape(layer, shape);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.getInputLayer(), input)};
        Map output = MapsKt.mutableMapOf((Pair[])pairArray);
        Iterable $this$filter$iv = this.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Layer it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof Input))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<Operand> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv$iv;
            Layer layer2 = (Layer)element$iv;
            boolean bl = false;
            element$iv$iv = layer2.getInboundLayers();
            Ops ops = this.getTf();
            Layer layer3 = layer2;
            boolean $i$f$map = false;
            void var15_18 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Layer layer4 = (Layer)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Object v = output.get(it);
                Intrinsics.checkNotNull(v);
                collection.add((Operand)v);
            }
            collection = (List)destination$iv$iv2;
            Operand<Float> out = layer3.build(ops, (List<? extends Operand<Float>>)collection, training, numberOfLosses);
            output.put(layer2, out);
            Shape shape2 = out.asOutput().shape();
            Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"out.asOutput().shape()");
            LayerKt.setOutputShape(layer2, shape2);
        }
        Object v = output.get(CollectionsKt.last(this.getLayers()));
        Intrinsics.checkNotNull(v);
        return TuplesKt.to(input, v);
    }

    @Override
    public void save(@NotNull File modelDirectory, @NotNull SavingFormat savingFormat, boolean saveOptimizerState, @NotNull WritingMode writingMode) {
        Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)savingFormat), (String)"savingFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)writingMode), (String)"writingMode");
        if (!this.isModelCompiled()) {
            boolean $i$a$-check-Functional$save$52 = false;
            String $i$a$-check-Functional$save$52 = "The model is not compiled yet. Compile the model to use this method.";
            throw new IllegalStateException($i$a$-check-Functional$save$52.toString());
        }
        if (!this.isModelInitialized()) {
            boolean $i$a$-check-Functional$save$62 = false;
            String $i$a$-check-Functional$save$62 = "The model is not initialized yet. Initialize the model weights with init() method or load weights to use this method.";
            throw new IllegalStateException($i$a$-check-Functional$save$62.toString());
        }
        if (saveOptimizerState && !this.isOptimizerVariableInitialized()) {
            boolean bl = false;
            String string = "The optimizer variables are not initialized yet. Initialize the optimizer variables with init() method or load optimizer weights to use this method.";
            throw new IllegalStateException(string.toString());
        }
        String pathToModelDirectory = modelDirectory.getAbsolutePath();
        switch (WhenMappings.$EnumSwitchMapping$0[writingMode.ordinal()]) {
            case 1: {
                if (!(!modelDirectory.exists())) {
                    boolean bl = false;
                    String string = "The directory exists on path " + pathToModelDirectory + ", please be careful it could contain valuable model! Change this mode to OVERRIDE if you want to override this directory.";
                    throw new IllegalStateException(string.toString());
                }
                Files.createDirectories(modelDirectory.toPath(), new FileAttribute[0]);
                break;
            }
            case 2: {
                if (modelDirectory.exists()) {
                    FilesKt.deleteRecursively((File)modelDirectory);
                }
                Files.createDirectories(modelDirectory.toPath(), new FileAttribute[0]);
                break;
            }
            case 3: {
                if (modelDirectory.exists()) break;
                Files.createDirectories(modelDirectory.toPath(), new FileAttribute[0]);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[savingFormat.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)pathToModelDirectory, (String)"pathToModelDirectory");
                this.saveInSimpleFormat(pathToModelDirectory, saveOptimizerState);
                break;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)pathToModelDirectory, (String)"pathToModelDirectory");
                this.saveInSavedModelFormat(pathToModelDirectory);
                break;
            }
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)pathToModelDirectory, (String)"pathToModelDirectory");
                this.saveInKerasFormat(pathToModelDirectory, saveOptimizerState);
            }
        }
    }

    private final void saveInKerasFormat(String pathToModelDirectory, boolean saveOptimizerState) {
        Functional.saveModel$default(this, pathToModelDirectory, false, 2, null);
        this.saveVariables(pathToModelDirectory, saveOptimizerState);
    }

    private final void saveModel(String pathToModelDirectory, boolean isKerasFullyCompatible) {
        File jsonConfig = new File(pathToModelDirectory + "/modelConfig.json");
        ModelSaverKt.saveModelConfiguration(this, jsonConfig, isKerasFullyCompatible);
    }

    static /* synthetic */ void saveModel$default(Functional functional2, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        functional2.saveModel(string, bl);
    }

    private final void saveInSavedModelFormat(String pathToModelDirectory) {
        this.saveGraphDef(pathToModelDirectory);
    }

    private final void saveInSimpleFormat(String pathToModelDirectory, boolean saveOptimizerState) {
        this.saveGraphDef(pathToModelDirectory);
        this.saveVariables(pathToModelDirectory, saveOptimizerState);
    }

    private final void saveGraphDef(String pathToModelDirectory) {
        File file = new File(pathToModelDirectory + "/graph.pb");
        byte[] byArray = this.getKGraph().getTfGraph$tensorflow().toGraphDef();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"kGraph.tfGraph.toGraphDef()");
        FilesKt.writeBytes((File)file, (byte[])byArray);
    }

    @NotNull
    public final Functional copy(boolean saveOptimizerState, boolean copyWeights) {
        KerasModel serializedModel = ModelSaverKt.serializeModel(this, true);
        Functional deserializedModel = ModelLoaderKt.deserializeFunctionalModel$default(serializedModel, null, 2, null);
        if (!copyWeights) {
            return deserializedModel;
        }
        deserializedModel.compile(this.getOptimizer(), this.getLoss(), this.getMetrics());
        Iterable $this$forEach$iv = deserializedModel.getLayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Layer it = (Layer)element$iv;
            boolean bl = false;
            WeightsKt.setWeights(it, WeightsKt.getWeights(this.getLayer(it.getName())));
        }
        deserializedModel.setModelInitialized$tensorflow(true);
        return deserializedModel;
    }

    public static /* synthetic */ Functional copy$default(Functional functional2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return functional2.copy(bl, bl2);
    }

    @NotNull
    public final Functional removeLastLayer() {
        if (!(!this.isModelCompiled())) {
            boolean $i$a$-require-Functional$removeLastLayer$22 = false;
            String $i$a$-require-Functional$removeLastLayer$22 = "It works for non-compiled models only!";
            throw new IllegalArgumentException($i$a$-require-Functional$removeLastLayer$22.toString());
        }
        List layers = new ArrayList();
        for (Layer layer : this.getLayers()) {
            layers.add(layer);
        }
        Layer lastLayer = (Layer)CollectionsKt.last((List)layers);
        for (Layer outboundLayer : lastLayer.getInboundLayers()) {
            outboundLayer.getOutboundLayers().remove(lastLayer);
        }
        CollectionsKt.removeLast((List)layers);
        return org.jetbrains.kotlinx.dl.api.core.Functional$Companion.of$default(Companion, layers, false, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Functional of(@NotNull Layer[] layers, boolean noInput) {
        return Companion.of(layers, noInput);
    }

    @JvmStatic
    @NotNull
    public static final Functional of(@NotNull List<? extends Layer> layers, boolean noInput) {
        return Companion.of(layers, noInput);
    }

    @JvmStatic
    @NotNull
    public static final Functional of(@NotNull GraphTrainableModel pretrainedModel, @NotNull GraphTrainableModel topModel) {
        return Companion.of(pretrainedModel, topModel);
    }

    @JvmStatic
    @NotNull
    public static final Functional fromOutput(@NotNull Layer finalLayer) {
        return Companion.fromOutput(finalLayer);
    }

    @JvmStatic
    @NotNull
    public static final Functional loadModelConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
        return Companion.loadModelConfiguration(configuration, inputShape);
    }

    @JvmStatic
    @NotNull
    public static final List<Layer> loadModelLayersFromConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
        return Companion.loadModelLayersFromConfiguration(configuration, inputShape);
    }

    @JvmStatic
    @NotNull
    public static final Functional loadDefaultModelConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
        return Companion.loadDefaultModelConfiguration(modelDirectory, inputShape);
    }

    @JvmStatic
    @NotNull
    public static final List<Layer> loadModelLayersFromDefaultConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
        return Companion.loadModelLayersFromDefaultConfiguration(modelDirectory, inputShape);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u001c\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u001c\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J+\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0017\"\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010\u001aJ \u0010\u0016\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007J\u0016\u0010\u001e\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010 \u001a\u00020\tH\u0002J\u001e\u0010!\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/Functional$Companion;", "", "()V", "fillOutputLayers", "", "layers", "", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "findInputLayer", "Lorg/jetbrains/kotlinx/dl/api/core/layer/core/Input;", "fromOutput", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "finalLayer", "loadDefaultModelConfiguration", "modelDirectory", "Ljava/io/File;", "inputShape", "", "loadModelConfiguration", "configuration", "loadModelLayersFromConfiguration", "loadModelLayersFromDefaultConfiguration", "of", "", "noInput", "", "([Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;Z)Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "pretrainedModel", "Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "topModel", "preprocessAndCreate", "topologicalSort", "inputLayer", "visitInboundNodes", "", "tensorflow"})
    @SourceDebugExtension(value={"SMAP\nFunctional.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Functional.kt\norg/jetbrains/kotlinx/dl/api/core/Functional$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,385:1\n1#2:386\n1855#3,2:387\n1864#3,3:389\n800#3,11:392\n1855#3:403\n1855#3,2:404\n1856#3:406\n1549#3:407\n1620#3,3:408\n37#4,2:411\n37#4,2:413\n*S KotlinDebug\n*F\n+ 1 Functional.kt\norg/jetbrains/kotlinx/dl/api/core/Functional$Companion\n*L\n90#1:387,2\n101#1:389,3\n141#1:392,11\n147#1:403\n149#1:404,2\n147#1:406\n160#1:407\n160#1:408,3\n178#1:411,2\n179#1:413,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Functional of(@NotNull Layer[] layers, boolean noInput) {
            Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
            if (!noInput) {
                GraphTrainableModel.Companion.layerValidation$tensorflow(ArraysKt.toList((Object[])layers));
            }
            return this.preprocessAndCreate(ArraysKt.toList((Object[])layers));
        }

        public static /* synthetic */ Functional of$default(Companion companion, Layer[] layerArray, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.of(layerArray, bl);
        }

        @JvmStatic
        @NotNull
        public final Functional of(@NotNull List<? extends Layer> layers, boolean noInput) {
            Intrinsics.checkNotNullParameter(layers, (String)"layers");
            if (!noInput) {
                GraphTrainableModel.Companion.layerValidation$tensorflow(CollectionsKt.toList((Iterable)layers));
            }
            return this.preprocessAndCreate(layers);
        }

        public static /* synthetic */ Functional of$default(Companion companion, List list, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.of(list, bl);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Functional of(@NotNull GraphTrainableModel pretrainedModel, @NotNull GraphTrainableModel topModel) {
            Intrinsics.checkNotNullParameter((Object)pretrainedModel, (String)"pretrainedModel");
            Intrinsics.checkNotNullParameter((Object)topModel, (String)"topModel");
            if (!(!pretrainedModel.isModelCompiled())) {
                boolean $i$a$-require-Functional$Companion$of$32 = false;
                String $i$a$-require-Functional$Companion$of$32 = "Pretrained model should not be compiled!";
                throw new IllegalArgumentException($i$a$-require-Functional$Companion$of$32.toString());
            }
            if (!(!topModel.isModelCompiled())) {
                boolean $i$a$-require-Functional$Companion$of$42 = false;
                String $i$a$-require-Functional$Companion$of$42 = "Top model should not be compiled!";
                throw new IllegalArgumentException($i$a$-require-Functional$Companion$of$42.toString());
            }
            List<Layer> pretrainedLayers = pretrainedModel.getLayers();
            Iterable $this$forEach$iv = pretrainedLayers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Layer it = (Layer)element$iv;
                boolean bl = false;
                TrainableLayerKt.freeze(it);
            }
            List layers = new ArrayList();
            CollectionsKt.addAll((Collection)layers, (Iterable)pretrainedLayers);
            List<Layer> topLayers = topModel.getLayers();
            CollectionsKt.addAll((Collection)layers, (Iterable)topLayers);
            topLayers.get(0).getInboundLayers().add((Layer)CollectionsKt.last(pretrainedLayers));
            if (topModel instanceof Sequential && layers.size() > 1) {
                Iterable $this$forEachIndexed$iv = topLayers.subList(1, topLayers.size());
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void layer;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Layer layer2 = (Layer)item$iv;
                    int index = n;
                    boolean bl = false;
                    int topLayersIndex = index - 1 + 1;
                    layer.getInboundLayers().add(topLayers.get(topLayersIndex));
                }
            }
            return org.jetbrains.kotlinx.dl.api.core.Functional$Companion.of$default(this, layers, false, 2, null);
        }

        @JvmStatic
        @NotNull
        public final Functional fromOutput(@NotNull Layer finalLayer) {
            Intrinsics.checkNotNullParameter((Object)finalLayer, (String)"finalLayer");
            if (!(!((Collection)finalLayer.getInboundLayers()).isEmpty())) {
                boolean bl = false;
                String string = "Model should contain more than 1 layer!";
                throw new IllegalArgumentException(string.toString());
            }
            Set layers = new LinkedHashSet();
            layers.add(finalLayer);
            this.visitInboundNodes(finalLayer, layers);
            return this.preprocessAndCreate(CollectionsKt.toList((Iterable)layers));
        }

        private final void visitInboundNodes(Layer finalLayer, Set<Layer> layers) {
            for (Layer inboundNode : finalLayer.getInboundLayers()) {
                if (layers.contains(inboundNode)) continue;
                layers.add(inboundNode);
                this.visitInboundNodes(inboundNode, layers);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Input findInputLayer(List<? extends Layer> layers) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = layers;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Input)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List inputs = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            if (!(inputs.size() == 1)) {
                boolean bl = false;
                String string = "Model should contain only one layer with type Input. There is a " + inputs.size() + " input layers.";
                throw new IllegalArgumentException(string.toString());
            }
            return (Input)inputs.get(0);
        }

        private final void fillOutputLayers(List<? extends Layer> layers) {
            Iterable $this$forEach$iv = layers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Layer layer = (Layer)element$iv;
                boolean bl = false;
                List<Layer> inboundLayers = layer.getInboundLayers();
                Iterable $this$forEach$iv2 = inboundLayers;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Layer it = (Layer)element$iv2;
                    boolean bl2 = false;
                    if (it.getOutboundLayers().contains(layer)) continue;
                    it.getOutboundLayers().add(layer);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<Layer> topologicalSort(List<? extends Layer> layers, Input inputLayer) {
            List<Layer> sortedListOfLayers2 = GraphUtilKt.sortTopologically(inputLayer, (Function1)topologicalSort.sortedListOfLayers.1.INSTANCE);
            if (!(sortedListOfLayers2.size() == layers.size())) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                boolean bl = false;
                Iterable iterable = CollectionsKt.minus((Iterable)layers, (Iterable)CollectionsKt.toSet((Iterable)sortedListOfLayers2));
                StringBuilder stringBuilder = new StringBuilder().append("The following layers are not reachable from the input: ");
                boolean $i$f$map = false;
                void var8_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Layer layer = (Layer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getName() + " (" + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + ')');
                }
                String string = stringBuilder.append((List)destination$iv$iv).toString();
                throw new IllegalStateException(string.toString());
            }
            return sortedListOfLayers2;
        }

        private final Functional preprocessAndCreate(List<? extends Layer> layers) {
            Input inputLayer = this.findInputLayer(layers);
            this.fillOutputLayers(layers);
            List<Layer> layerList = this.topologicalSort(layers, inputLayer);
            Collection $this$toTypedArray$iv = layerList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            GraphTrainableModel.Companion.preProcessLayerNames$tensorflow(thisCollection$iv.toArray(new Layer[0]));
            Collection $this$toTypedArray$iv2 = layerList;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            Layer[] layerArray = thisCollection$iv2.toArray(new Layer[0]);
            return new Functional(Arrays.copyOf(layerArray, layerArray.length));
        }

        @JvmStatic
        @NotNull
        public final Functional loadModelConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (!configuration.isFile()) {
                boolean bl = false;
                String string = configuration.getAbsolutePath() + " is not a file. Should be a .json file with configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            return ModelLoaderKt.loadFunctionalModelConfiguration(configuration, inputShape);
        }

        public static /* synthetic */ Functional loadModelConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadModelConfiguration(file, nArray);
        }

        @JvmStatic
        @NotNull
        public final List<Layer> loadModelLayersFromConfiguration(@NotNull File configuration, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (!configuration.isFile()) {
                boolean bl = false;
                String string = configuration.getAbsolutePath() + " is not a file. Should be a .json file with configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            KerasModel functionalConfig = ModelLoaderKt.loadSerializedModel(configuration);
            return ModelLoaderKt.loadFunctionalModelLayers(functionalConfig, inputShape);
        }

        public static /* synthetic */ List loadModelLayersFromConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadModelLayersFromConfiguration(file, nArray);
        }

        @JvmStatic
        @NotNull
        public final Functional loadDefaultModelConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
            if (!modelDirectory.isDirectory()) {
                boolean bl = false;
                String string = modelDirectory.getAbsolutePath() + " is not a directory. Should be a directory with a 'modelConfig.json' file with configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            File configuration = new File(modelDirectory.getAbsolutePath() + "/modelConfig.json");
            if (!configuration.exists()) {
                throw new FileNotFoundException("File 'modelConfig.json' is not found. This file must be in the model directory. It is generated during Sequential model saving with SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.");
            }
            return ModelLoaderKt.loadFunctionalModelConfiguration(configuration, inputShape);
        }

        public static /* synthetic */ Functional loadDefaultModelConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadDefaultModelConfiguration(file, nArray);
        }

        @JvmStatic
        @NotNull
        public final List<Layer> loadModelLayersFromDefaultConfiguration(@NotNull File modelDirectory, @Nullable int[] inputShape) {
            Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
            if (!modelDirectory.isDirectory()) {
                boolean $i$a$-require-Functional$Companion$loadModelLayersFromDefaultConfiguration$22 = false;
                String $i$a$-require-Functional$Companion$loadModelLayersFromDefaultConfiguration$22 = modelDirectory.getAbsolutePath() + " is not a directory. Should be a directory with a 'modelConfig.json' file with configuration.";
                throw new IllegalArgumentException($i$a$-require-Functional$Companion$loadModelLayersFromDefaultConfiguration$22.toString());
            }
            File configuration = new File(modelDirectory.getAbsolutePath() + "/modelConfig.json");
            if (!configuration.exists()) {
                throw new FileNotFoundException("File 'modelConfig.json' is not found. This file must be in the model directory. It is generated during Sequential model saving with SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.");
            }
            KerasModel functionalConfig = ModelLoaderKt.loadSerializedModel(configuration);
            return ModelLoaderKt.loadFunctionalModelLayers(functionalConfig, inputShape);
        }

        public static /* synthetic */ List loadModelLayersFromDefaultConfiguration$default(Companion companion, File file, int[] nArray, int n, Object object) {
            if ((n & 2) != 0) {
                nArray = null;
            }
            return companion.loadModelLayersFromDefaultConfiguration(file, nArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WritingMode.values().length];
            try {
                nArray[WritingMode.FAIL_IF_EXISTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WritingMode.OVERRIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WritingMode.APPEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SavingFormat.values().length];
            try {
                nArray[SavingFormat.TF_GRAPH_CUSTOM_VARIABLES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SavingFormat.TF_GRAPH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

