/*
 * Copyright 2020-2022 JetBrains s.r.o. and Kotlin Deep Learning project contributors. All Rights Reserved.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE.txt file.
 */

package org.jetbrains.kotlinx.dl.api.inference.keras.config

import com.beust.klaxon.Json

internal data class LayerConfig(
    @Json(serializeNull = false)
    val activation: String? = null,
    @Json(serializeNull = false)
    val activity_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val alpha: Double? = null,
    @Json(serializeNull = false)
    val alpha_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val alpha_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val axis: Any? = null,
    @Json(serializeNull = false)
    var batch_input_shape: List<Int?>? = null,
    @Json(serializeNull = false)
    val beta_constraint: Any? = null,
    @Json(serializeNull = false)
    val beta_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val beta_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val bias_constraint: Any? = null,
    @Json(serializeNull = false)
    val bias_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val bias_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val center: Boolean? = null,
    @Json(serializeNull = false)
    val cropping: List<Any>? = null,
    @Json(serializeNull = false)
    val data_format: String? = null,
    @Json(serializeNull = false)
    val depth_multiplier: Int? = null,
    @Json(serializeNull = false)
    val depthwise_constraint: Any? = null,
    @Json(serializeNull = false)
    val depthwise_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val depthwise_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val dilation_rate: List<Int>? = null,
    @Json(serializeNull = false)
    val dropout: Double? = null,
    @Json(serializeNull = false)
    val dtype: String? = null,
    @Json(serializeNull = false)
    val epsilon: Double? = null,
    @Json(serializeNull = false)
    val filters: Int? = null,
    @Json(serializeNull = false)
    val gamma_constraint: Any? = null,
    @Json(serializeNull = false)
    val gamma_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val gamma_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val go_backwards: Boolean? = null,
    @Json(serializeNull = false)
    val implementation: Int? = null,
    @Json(serializeNull = false)
    val interpolation: String? = null,
    @Json(serializeNull = false)
    val kernel_constraint: Any? = null,
    @Json(serializeNull = false)
    val kernel_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val kernel_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val kernel_size: List<Int>? = null,
    @Json(serializeNull = false)
    val max_value: Double? = null,
    @Json(serializeNull = false)
    val momentum: Double? = null,
    @Json(serializeNull = false)
    val moving_mean_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val moving_variance_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val n: Int? = null,
    @Json(serializeNull = false)
    val name: String? = null,
    @Json(serializeNull = false)
    val negative_slope: Double? = null,
    @Json(serializeNull = false)
    val padding: KerasPadding? = null,
    @Json(serializeNull = false)
    val output_padding: List<Int>? = null,
    @Json(serializeNull = false)
    val pointwise_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val pointwise_regularizer: KerasRegularizer? = null,
    @Json(serializeNull = false)
    val noise_shape: List<Any>? = null,
    @Json(serializeNull = false)
    val offset: Double? = null,
    @Json(serializeNull = false)
    val ragged: Boolean? = null,
    @Json(serializeNull = false)
    val rate: Double? = null,
    @Json(serializeNull = false)
    val recurrent_activation: String? = null,
    @Json(serializeNull = false)
    val recurrent_constraint: Any? = null,
    @Json(serializeNull = false)
    val recurrent_dropout: Double? = null,
    @Json(serializeNull = false)
    val recurrent_initializer: KerasInitializer? = null,
    @Json(serializeNull = false)
    val recurrent_regularizer: Any? = null,
    @Json(serializeNull = false)
    val return_sequences: Boolean? = null,
    @Json(serializeNull = false)
    val return_state: Boolean? = null,
    @Json(serializeNull = false)
    val pool_size: List<Int>? = null,
    @Json(serializeNull = false)
    val seed: Any? = null,
    @Json(serializeNull = false)
    val scale: Any? = null,
    @Json(serializeNull = false)
    val shared_axes: List<Int>? = null,
    @Json(serializeNull = false)
    val size: Any? = null,
    @Json(serializeNull = false)
    val sparse: Boolean? = null,
    @Json(serializeNull = false)
    val stateful: Boolean? = null,
    @Json(serializeNull = false)
    val strides: List<Int>? = null,
    @Json(serializeNull = false)
    val target_shape: List<Int>? = null,
    @Json(serializeNull = false)
    val time_major: Boolean? = null,
    @Json(serializeNull = false)
    val trainable: Boolean? = true,
    @Json(serializeNull = false)
    val theta: Double? = null,
    @Json(serializeNull = false)
    val threshold: Double? = null,
    @Json(serializeNull = false)
    val unit_forget_bias: Boolean? = null,
    @Json(serializeNull = false)
    val units: Int? = null,
    @Json(serializeNull = false)
    val unroll: Boolean? = null,
    @Json(serializeNull = false)
    val use_bias: Boolean? = null,
    @Json(serializeNull = false)
    val dims: IntArray? = null,
    @Json(serializeNull = false)
    val normalize: Boolean? = null
)
