/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.summary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.summary.Cell;
import org.jetbrains.kotlinx.dl.api.summary.FormatUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0003\"\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/dl/api/summary/TableRow;", "", "cells", "", "Lorg/jetbrains/kotlinx/dl/api/summary/Cell;", "([Lorg/jetbrains/kotlinx/dl/api/summary/Cell;)V", "lines", "", "([Ljava/lang/String;)V", "", "(Ljava/util/List;)V", "getLines", "()Ljava/util/List;", "columnWidth", "", "column", "format", "columnSeparator", "columnsWidths", "api"})
@SourceDebugExtension(value={"SMAP\nFormatUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatUtils.kt\norg/jetbrains/kotlinx/dl/api/summary/TableRow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1549#2:216\n1620#2,3:217\n1549#2:221\n1620#2,2:222\n1549#2:224\n1620#2,3:225\n1622#2:228\n1549#2:229\n1620#2,3:230\n1#3:220\n*S KotlinDebug\n*F\n+ 1 FormatUtils.kt\norg/jetbrains/kotlinx/dl/api/summary/TableRow\n*L\n167#1:216\n167#1:217,3\n175#1:221\n175#1:222,2\n176#1:224\n176#1:225,3\n175#1:228\n195#1:229\n195#1:230,3\n*E\n"})
public final class TableRow {
    @NotNull
    private final List<Cell> cells;

    public TableRow(@NotNull List<Cell> cells) {
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        this.cells = cells;
    }

    public TableRow(Cell ... cells) {
        Intrinsics.checkNotNullParameter((Object)cells, (String)"cells");
        this(ArraysKt.toList((Object[])cells));
    }

    /*
     * WARNING - void declaration
     */
    public TableRow(String ... lines) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Iterable iterable = ArraysKt.toList((Object[])lines);
        TableRow tableRow = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Cell((String)it));
        }
        tableRow((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<String>> getLines() {
        void $this$mapTo$iv$iv;
        Iterator iterator = ((Iterable)this.cells).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Cell it22 = (Cell)iterator.next();
        boolean bl = false;
        int it22 = it22.getLines().size();
        while (iterator.hasNext()) {
            Cell it32 = (Cell)iterator.next();
            $i$a$-maxOf-TableRow$lines$maxLinesInCell$1 = false;
            int it32 = it32.getLines().size();
            if (it22 >= it32) continue;
            it22 = it32;
        }
        int maxLinesInCell = it22;
        Iterable $this$map$iv = (Iterable)new IntRange(0, maxLinesInCell - 1);
        boolean $i$f$map = false;
        Iterable it32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Iterable $this$map$iv2 = this.cells;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void idx;
                Cell cell = (Cell)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                List<String> cellLines = cell.component1();
                String string = (String)CollectionsKt.getOrNull(cellLines, (int)idx);
                if (string == null) {
                    string = " ";
                }
                collection2.add(string);
            }
            collection.add((List)destination$iv$iv2);
        }
        List rowLines = (List)destination$iv$iv;
        return rowLines;
    }

    public final int columnWidth(int column) {
        Cell cell = (Cell)CollectionsKt.getOrNull(this.cells, (int)column);
        if (cell == null) {
            return 0;
        }
        Cell cell2 = cell;
        return cell2.getWidth();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> format(@NotNull String columnSeparator, @NotNull List<Integer> columnsWidths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)columnSeparator, (String)"columnSeparator");
        Intrinsics.checkNotNullParameter(columnsWidths, (String)"columnsWidths");
        Iterable $this$map$iv = this.getLines();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FormatUtilsKt.formatLine(columnSeparator, columnsWidths, (List<String>)line));
        }
        return (List)destination$iv$iv;
    }
}

