/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.summary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.summary.FormatUtilsKt;
import org.jetbrains.kotlinx.dl.api.summary.Section;
import org.jetbrains.kotlinx.dl.api.summary.TableRow;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c2\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J@\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\t\u0010\u001c\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlinx/dl/api/summary/SectionWithColumns;", "Lorg/jetbrains/kotlinx/dl/api/summary/Section;", "rows", "", "Lorg/jetbrains/kotlinx/dl/api/summary/TableRow;", "columnNames", "", "(Ljava/util/List;Ljava/util/List;)V", "columnsCount", "", "getColumnsCount", "()I", "columnWidth", "column", "component1", "component2", "copy", "equals", "", "other", "", "format", "alignedColumnsWidths", "tableWidth", "columnSeparator", "lineSeparatorSymbol", "", "thickLineSeparatorSymbol", "hashCode", "toString", "api"})
@SourceDebugExtension(value={"SMAP\nFormatUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatUtils.kt\norg/jetbrains/kotlinx/dl/api/summary/SectionWithColumns\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1#2:216\n1855#3,2:217\n*S KotlinDebug\n*F\n+ 1 FormatUtils.kt\norg/jetbrains/kotlinx/dl/api/summary/SectionWithColumns\n*L\n151#1:217,2\n*E\n"})
public final class SectionWithColumns
implements Section {
    @NotNull
    private final List<TableRow> rows;
    @NotNull
    private final List<String> columnNames;

    public SectionWithColumns(@NotNull List<TableRow> rows, @NotNull List<String> columnNames) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
        this.rows = rows;
        this.columnNames = columnNames;
    }

    public final int getColumnsCount() {
        return this.columnNames.size();
    }

    public final int columnWidth(int column) {
        Iterator iterator = ((Iterable)this.rows).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        TableRow it = (TableRow)iterator.next();
        boolean bl = false;
        int n = it.columnWidth(column);
        while (iterator.hasNext()) {
            TableRow it2 = (TableRow)iterator.next();
            $i$a$-maxOf-SectionWithColumns$columnWidth$1 = false;
            int n2 = it2.columnWidth(column);
            if (n >= n2) continue;
            n = n2;
        }
        String string = (String)CollectionsKt.getOrNull(this.columnNames, (int)column);
        return RangesKt.coerceAtLeast((int)n, (int)(string != null ? string.length() : 0));
    }

    @NotNull
    public final List<String> format(@NotNull List<Integer> alignedColumnsWidths, int tableWidth, @NotNull String columnSeparator, char lineSeparatorSymbol, char thickLineSeparatorSymbol) {
        Intrinsics.checkNotNullParameter(alignedColumnsWidths, (String)"alignedColumnsWidths");
        Intrinsics.checkNotNullParameter((Object)columnSeparator, (String)"columnSeparator");
        String lineSeparator = StringsKt.repeat((CharSequence)String.valueOf(lineSeparatorSymbol), (int)tableWidth);
        String thickLineSeparator = StringsKt.repeat((CharSequence)String.valueOf(thickLineSeparatorSymbol), (int)tableWidth);
        List result = new ArrayList();
        result.add(FormatUtilsKt.formatLine(columnSeparator, alignedColumnsWidths, this.columnNames));
        result.add(thickLineSeparator);
        Iterable $this$forEach$iv = this.rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableRow row = (TableRow)element$iv;
            boolean bl = false;
            result.addAll((Collection)row.format(columnSeparator, alignedColumnsWidths));
            result.add(lineSeparator);
        }
        return result;
    }

    public static /* synthetic */ List format$default(SectionWithColumns sectionWithColumns, List list, int n, String string, char c, char c2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = " ";
        }
        if ((n2 & 8) != 0) {
            c = (char)95;
        }
        if ((n2 & 0x10) != 0) {
            c2 = (char)61;
        }
        return sectionWithColumns.format(list, n, string, c, c2);
    }

    private final List<TableRow> component1() {
        return this.rows;
    }

    private final List<String> component2() {
        return this.columnNames;
    }

    @NotNull
    public final SectionWithColumns copy(@NotNull List<TableRow> rows, @NotNull List<String> columnNames) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
        return new SectionWithColumns(rows, columnNames);
    }

    public static /* synthetic */ SectionWithColumns copy$default(SectionWithColumns sectionWithColumns, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = sectionWithColumns.rows;
        }
        if ((n & 2) != 0) {
            list2 = sectionWithColumns.columnNames;
        }
        return sectionWithColumns.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "SectionWithColumns(rows=" + this.rows + ", columnNames=" + this.columnNames + ')';
    }

    public int hashCode() {
        int result = ((Object)this.rows).hashCode();
        result = result * 31 + ((Object)this.columnNames).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SectionWithColumns)) {
            return false;
        }
        SectionWithColumns sectionWithColumns = (SectionWithColumns)other;
        if (!Intrinsics.areEqual(this.rows, sectionWithColumns.rows)) {
            return false;
        }
        return Intrinsics.areEqual(this.columnNames, sectionWithColumns.columnNames);
    }
}

