/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.shape;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0012\u0010\u0012\u001a\u00020\u00002\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0006J\u001c\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\n\u0010\u0014\u001a\u00020\u0003\"\u00020\u0006H\u0002J\u0006\u0010\u0002\u001a\u00020\u0003J\u0013\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\rH\u0086\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\rH\u0002J\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\rJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0006J\u0019\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0006H\u0086\u0002J\u000e\u0010$\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010%\u001a\u00020\u0003J\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "", "dims", "", "([J)V", "firstDimension", "", "(J[J)V", "()V", "almostEqual", "", "tensorShape", "except", "", "assertKnown", "", "i", "clone", "concatenate", "first", "last", "equals", "other", "get", "hashCode", "head", "isKnown", "numDimensions", "numElements", "rank", "replace", "dim", "replaceFirst", "replaceLast", "set", "value", "size", "tail", "toString", "", "Companion", "api"})
@SourceDebugExtension(value={"SMAP\nTensorShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TensorShape.kt\norg/jetbrains/kotlinx/dl/api/core/shape/TensorShape\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class TensorShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long[] dims;

    public TensorShape() {
    }

    public TensorShape(@NotNull long[] dims) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        this();
        this.dims = dims;
    }

    public TensorShape(long firstDimension, long ... dims) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        this();
        long[] lArray = this.dims = new long[dims.length + 1];
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        lArray[0] = firstDimension;
        long[] lArray2 = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray2 = null;
        }
        ArraysKt.copyInto$default((long[])dims, (long[])lArray2, (int)1, (int)0, (int)0, (int)12, null);
    }

    private final int numDimensions() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return lArray.length;
    }

    public final long numElements() {
        long prod = 1L;
        int n = this.numDimensions();
        for (int i = 0; i < n; ++i) {
            long[] lArray = this.dims;
            if (this.dims == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
                lArray = null;
            }
            prod *= Math.abs(lArray[i]);
        }
        return prod;
    }

    public final int rank() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return lArray.length;
    }

    @NotNull
    public final long[] dims() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return lArray;
    }

    public final long get(int i) {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return lArray[i];
    }

    public final void set(int i, long value) {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        lArray[i] = value;
    }

    private final boolean isKnown(int i) {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return lArray[i] != -1L;
    }

    public final void assertKnown(int i) {
        if (!this.isKnown(i)) {
            boolean bl = false;
            String string = "Dimension " + i + " in shape needs to be known.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final TensorShape replace(int i, long dim) {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        lArray[i] = dim;
        return this;
    }

    @NotNull
    public final TensorShape replaceLast(long dim) {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return this.replace(lArray.length - 1, dim);
    }

    @NotNull
    public final TensorShape replaceFirst(long dim) {
        return this.replace(0, dim);
    }

    public final long size(int i) {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return lArray[i];
    }

    @NotNull
    public final TensorShape concatenate(long ... dims) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        this.dims = this.concatenate(lArray, Arrays.copyOf(dims, dims.length));
        return this;
    }

    private final long[] concatenate(long[] first, long ... last) {
        long[] dims = new long[first.length + last.length];
        ArraysKt.copyInto$default((long[])first, (long[])dims, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((long[])last, (long[])dims, (int)first.length, (int)0, (int)0, (int)12, null);
        return dims;
    }

    public final long head() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return lArray[0];
    }

    @NotNull
    public final long[] tail() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        long[] lArray2 = lArray;
        int n = 1;
        long[] lArray3 = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray3 = null;
        }
        int n2 = lArray3.length;
        return ArraysKt.copyOfRange((long[])lArray2, (int)n, (int)n2);
    }

    @NotNull
    public String toString() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        String string = Arrays.toString(lArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return StringsKt.replace$default((String)string, (String)"-1", (String)"None", (boolean)false, (int)4, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TensorShape cfr_ignored_0 = (TensorShape)other;
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        long[] lArray2 = lArray;
        long[] lArray3 = ((TensorShape)other).dims;
        if (((TensorShape)other).dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray3 = null;
        }
        return Arrays.equals(lArray2, lArray3);
    }

    public int hashCode() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return Arrays.hashCode(lArray);
    }

    @NotNull
    public final TensorShape clone() {
        long[] lArray = this.dims;
        if (this.dims == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dims");
            lArray = null;
        }
        return new TensorShape(lArray);
    }

    public final boolean almostEqual(@NotNull TensorShape tensorShape, int except) {
        Intrinsics.checkNotNullParameter((Object)tensorShape, (String)"tensorShape");
        boolean almostEqual = true;
        int n = tensorShape.numDimensions();
        for (int i = 0; i < n; ++i) {
            if (i == except || this.get(i) == tensorShape.get(i)) continue;
            almostEqual = false;
        }
        return almostEqual;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\u0004J\u0012\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u00020\u0006\"\u00020\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape$Companion;", "", "()V", "head", "", "dims", "", "tail", "api"})
    public static final class Companion {
        private Companion() {
        }

        public final long head(long ... dims) {
            Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
            return dims[0];
        }

        @NotNull
        public final long[] tail(long ... dims) {
            Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
            long[] lArray = dims;
            int n = 1;
            int n2 = dims.length;
            return ArraysKt.copyOfRange((long[])lArray, (int)n, (int)n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

