/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.io.CommonKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "isOpenApiStr", "", "text", "", "isOpenApi", "path", "url", "Ljava/net/URL;", "file", "Ljava/io/File;", "dataframe-openapi-generator"})
public final class IsOpenApiKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(IsOpenApiKt::logger$lambda$0);

    public static final boolean isOpenApiStr(@NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            SwaggerParseResult parsed = new OpenAPIParser().readContents(text, null, null);
            OpenAPI openAPI = parsed.getOpenAPI();
            bl = (openAPI != null && (openAPI = openAPI.getComponents()) != null ? openAPI.getSchemas() : null) != null;
        }
        catch (Throwable e) {
            logger.debug(e, IsOpenApiKt::isOpenApiStr$lambda$1);
            bl = false;
        }
        return bl;
    }

    public static final boolean isOpenApi(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return IsOpenApiKt.isOpenApi(CommonKt.asUrl((String)path));
    }

    public static final boolean isOpenApi(@NotNull URL url) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                String string = url.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (StringsKt.endsWith$default((String)string, (String)".yml", (boolean)false, (int)2, null)) break block4;
                String string2 = url.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)"yaml", (boolean)false, (int)2, null)) break block5;
            }
            return true;
        }
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"json", (boolean)false, (int)2, null)) {
            return false;
        }
        URL uRL = url;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        return IsOpenApiKt.isOpenApiStr(new String(byArray, charset));
    }

    public static final boolean isOpenApi(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new String[]{"yml", "yaml"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        String string = FilesKt.getExtension((File)file).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (list.contains(string)) {
            return true;
        }
        String string2 = FilesKt.getExtension((File)file).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)"json")) {
            return false;
        }
        return IsOpenApiKt.isOpenApiStr(FilesKt.readText$default((File)file, null, (int)1, null));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object isOpenApiStr$lambda$1() {
        return "Attempt to read input as YAML/JSON OpenAPI specification failed.";
    }
}

