/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io.db;

import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.io.db.H2;
import org.jetbrains.kotlinx.dataframe.io.db.MariaDb;
import org.jetbrains.kotlinx.dataframe.io.db.MySql;
import org.jetbrains.kotlinx.dataframe.io.db.PostgreSql;
import org.jetbrains.kotlinx.dataframe.io.db.Sqlite;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0005"}, d2={"driverClassNameFromUrl", "", "url", "extractDBTypeFromUrl", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "dataframe-jdbc"})
public final class UtilKt {
    @NotNull
    public static final DbType extractDBTypeFromUrl(@Nullable String url) {
        if (url != null) {
            DbType dbType;
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)H2.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = H2.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)MariaDb.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = MariaDb.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)MySql.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = MySql.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)Sqlite.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = Sqlite.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)PostgreSql.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = PostgreSql.INSTANCE;
            } else {
                throw new IllegalArgumentException("Unsupported database type in the url: " + url + ". Only H2, MariaDB, MySQL, SQLite and PostgreSQL are supported!");
            }
            return dbType;
        }
        throw new SQLException("Database URL could not be null. The existing value is " + url);
    }

    @NotNull
    public static final String driverClassNameFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        return dbType.getDriverClassName();
    }
}

