/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.io;

import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.parsers.Parsers;
import io.deephaven.csv.reading.CsvReader;
import io.deephaven.csv.sinks.SinkFactory;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import kotlin.time.Duration;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.ConvertKt;
import org.jetbrains.kotlinx.dataframe.api.ParseKt;
import org.jetbrains.kotlinx.dataframe.api.ParserOptions;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.ColumnNameGenerator;
import org.jetbrains.kotlinx.dataframe.impl.io.DataFrameCustomDoubleParser;
import org.jetbrains.kotlinx.dataframe.impl.io.ListSink;
import org.jetbrains.kotlinx.dataframe.io.ColType;
import org.jetbrains.kotlinx.dataframe.io.CommonKt;
import org.jetbrains.kotlinx.dataframe.io.Compression;
import org.jetbrains.kotlinx.dataframe.io.CsvKt;
import org.jetbrains.kotlinx.dataframe.io.UtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\u001a\u00dc\u0001\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2!\u0010\u001e\u001a\u001d\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001fj\u0002`\"\u00a2\u0006\u0002\b!H\u0000\u00a2\u0006\u0002\u0010#\u001a$\u0010$\u001a\u0006\u0012\u0002\b\u00030%*\u00020&2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010'\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\u000e\u0010(\u001a\u00020)*\u0004\u0018\u00010*H\u0002\u001a!\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0,2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0,H\u0002\u00a2\u0006\u0002\u0010-\u001a\u001c\u0010\u0012\u001a\u00020 *\u00020 2\u0006\u0010.\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a*\u0010/\u001a\u00020 *\u00020 2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\u001a\u0010\u0006\u001a\u00020 *\u00020 2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0012\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u000101*\u00020\u0011H\u0000\u001a\u0010\u00102\u001a\u0006\u0012\u0002\b\u000301*\u00020\u0011H\u0000\u001a\f\u00103\u001a\u00020\u0011*\u00020)H\u0000\"\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020)05X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u00068"}, d2={"readDelimImpl", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "inputStream", "Ljava/io/InputStream;", "delimiter", "", "header", "", "", "hasFixedWidthColumns", "", "fixedColumnWidths", "", "compression", "Lorg/jetbrains/kotlinx/dataframe/io/Compression;", "colTypes", "", "Lorg/jetbrains/kotlinx/dataframe/io/ColType;", "skipLines", "", "readLines", "parserOptions", "Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;", "ignoreEmptyLines", "allowMissingColumns", "ignoreExcessColumns", "quote", "ignoreSurroundingSpaces", "trimInsideQuoted", "parseParallel", "adjustCsvSpecs", "Lkotlin/Function2;", "Lio/deephaven/csv/CsvSpecs$Builder;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/io/AdjustCsvSpecs;", "(Ljava/io/InputStream;CLjava/util/List;ZLjava/util/List;Lorg/jetbrains/kotlinx/dataframe/io/Compression;Ljava/util/Map;JLjava/lang/Long;Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;ZZZCZZZLkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "toDataColumn", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lio/deephaven/csv/reading/CsvReader$ResultColumn;", "desiredColType", "toKType", "Lkotlin/reflect/KType;", "Lio/deephaven/csv/parsers/DataType;", "legalizeHeader", "", "([Ljava/lang/String;)[Ljava/lang/String;", "takeHeaderFromCsv", "parsers", "toCsvParserOrNull", "Lio/deephaven/csv/parsers/Parser;", "toCsvParser", "toColType", "typesDeephavenAlreadyParses", "", "getTypesDeephavenAlreadyParses", "()Ljava/util/Set;", "dataframe-csv"})
@JvmName(name="ReadDelimDeephavenKt")
@SourceDebugExtension(value={"SMAP\nreadDelim.kt\nKotlin\n*S Kotlin\n*F\n+ 1 readDelim.kt\norg/jetbrains/kotlinx/dataframe/impl/io/ReadDelimDeephavenKt\n+ 2 Compression.kt\norg/jetbrains/kotlinx/dataframe/io/CompressionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n82#2,7:374\n1557#3:381\n1628#3,3:382\n1611#3,9:391\n1863#3:400\n1864#3:402\n1620#3:403\n11165#4:385\n11500#4,3:386\n37#5,2:389\n1#6:401\n*S KotlinDebug\n*F\n+ 1 readDelim.kt\norg/jetbrains/kotlinx/dataframe/impl/io/ReadDelimDeephavenKt\n*L\n138#1:374,7\n164#1:381\n164#1:382,3\n298#1:391,9\n298#1:400\n298#1:402\n298#1:403\n249#1:385\n249#1:386,3\n249#1:389,2\n298#1:401\n*E\n"})
public final class ReadDelimDeephavenKt {
    @NotNull
    private static final Set<KType> typesDeephavenAlreadyParses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrame<?> readDelimImpl(@NotNull InputStream inputStream, char delimiter, @NotNull List<String> header, boolean hasFixedWidthColumns, @NotNull List<Integer> fixedColumnWidths, @NotNull Compression<?> compression, @NotNull Map<String, ? extends ColType> colTypes, long skipLines, @Nullable Long readLines, @Nullable ParserOptions parserOptions, boolean ignoreEmptyLines, boolean allowMissingColumns, boolean ignoreExcessColumns, char quote, boolean ignoreSurroundingSpaces, boolean trimInsideQuoted, boolean parseParallel, @NotNull Function2<? super CsvSpecs.Builder, ? super CsvSpecs.Builder, ? extends CsvSpecs.Builder> adjustCsvSpecs) {
        void $this$mapTo$iv$iv;
        InputStream decompressedInputStream;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(fixedColumnWidths, (String)"fixedColumnWidths");
        Intrinsics.checkNotNullParameter(compression, (String)"compression");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Intrinsics.checkNotNullParameter(adjustCsvSpecs, (String)"adjustCsvSpecs");
        CsvSpecs.Builder $this$readDelimImpl_u24lambda_u240 = CsvSpecs.builder();
        boolean bl = false;
        $this$readDelimImpl_u24lambda_u240.customDoubleParser((Tokenizer.CustomDoubleParser)new DataFrameCustomDoubleParser(parserOptions));
        Object object = parserOptions;
        if (object == null || (object = object.getNullStrings()) == null) {
            object = SetsKt.plus((Set)ParseKt.getParser((DataFrame.Companion)DataFrame.Companion).getNulls(), (Iterable)UtilKt.getDEFAULT_DELIM_NULL_STRINGS());
        }
        Object nullStrings = object;
        $this$readDelimImpl_u24lambda_u240.nullValueLiterals((Iterable)nullStrings);
        $this$readDelimImpl_u24lambda_u240.headerLegalizer(ReadDelimDeephavenKt::legalizeHeader);
        Long l = readLines;
        $this$readDelimImpl_u24lambda_u240.numRows(l != null ? l : Long.MAX_VALUE);
        $this$readDelimImpl_u24lambda_u240.ignoreEmptyLines(ignoreEmptyLines);
        $this$readDelimImpl_u24lambda_u240.allowMissingColumns(allowMissingColumns);
        $this$readDelimImpl_u24lambda_u240.ignoreExcessColumns(ignoreExcessColumns);
        if (!hasFixedWidthColumns) {
            $this$readDelimImpl_u24lambda_u240.delimiter(delimiter);
        }
        $this$readDelimImpl_u24lambda_u240.quote(quote);
        $this$readDelimImpl_u24lambda_u240.ignoreSurroundingSpaces(ignoreSurroundingSpaces);
        $this$readDelimImpl_u24lambda_u240.trim(trimInsideQuoted);
        $this$readDelimImpl_u24lambda_u240.concurrent(parseParallel);
        Intrinsics.checkNotNull((Object)$this$readDelimImpl_u24lambda_u240);
        ReadDelimDeephavenKt.header($this$readDelimImpl_u24lambda_u240, header);
        $this$readDelimImpl_u24lambda_u240.hasFixedWidthColumns(hasFixedWidthColumns);
        if (hasFixedWidthColumns && !((Collection)fixedColumnWidths).isEmpty()) {
            $this$readDelimImpl_u24lambda_u240.fixedColumnWidths((Iterable)fixedColumnWidths);
        }
        ReadDelimDeephavenKt.skipLines($this$readDelimImpl_u24lambda_u240, header.isEmpty(), skipLines);
        ReadDelimDeephavenKt.parsers($this$readDelimImpl_u24lambda_u240, parserOptions, colTypes);
        CsvSpecs csvSpecs = ((CsvSpecs.Builder)adjustCsvSpecs.invoke((Object)$this$readDelimImpl_u24lambda_u240, (Object)$this$readDelimImpl_u24lambda_u240)).build();
        InputStream $this$useDecompressed$iv = inputStream;
        boolean $i$f$useDecompressed = false;
        InputStream wrappedStream$iv = compression.wrapStream($this$useDecompressed$iv);
        compression.doFirst(wrappedStream$iv);
        try {
            CsvReader.Result result;
            decompressedInputStream = wrappedStream$iv;
            boolean bl2 = false;
            try {
                result = CsvReader.read((CsvSpecs)csvSpecs, (InputStream)CommonKt.skippingBomCharacters((InputStream)decompressedInputStream), (SinkFactory)ListSink.Companion.getSINK_FACTORY());
            }
            catch (CsvReaderException e) {
                if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"Can't proceed because hasHeaderRow is set but input file is empty or shorter than skipHeaderRows")) {
                    DataFrame dataFrame = DataFrame.Companion.empty$default((DataFrame.Companion)DataFrame.Companion, (int)0, (int)1, null);
                    compression.doFinally(wrappedStream$iv);
                    return dataFrame;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Could not read delimiter-separated data: CsvReaderException: ").append(e.getMessage()).append(": ");
                Object object2 = e.getCause();
                if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                    object2 = "";
                }
                throw new IllegalStateException(stringBuilder.append((String)object2).toString(), e);
            }
            decompressedInputStream = result;
        }
        finally {
            compression.doFinally(wrappedStream$iv);
        }
        InputStream csvReaderResult = decompressedInputStream;
        ColType defaultColType = colTypes.get(".default");
        Intrinsics.checkNotNull((Object)csvReaderResult);
        Iterable $this$map$iv = (Iterable)((Object)csvReaderResult);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CsvReader.ResultColumn resultColumn = (CsvReader.ResultColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            ColType colType = colTypes.get(it.name());
            if (colType == null) {
                colType = defaultColType;
            }
            collection.add(ReadDelimDeephavenKt.toDataColumn((CsvReader.ResultColumn)it, parserOptions, colType));
        }
        List cols = (List)destination$iv$iv;
        return ConstructorsKt.dataFrameOf((Iterable)cols);
    }

    private static final DataColumn<?> toDataColumn(CsvReader.ResultColumn $this$toDataColumn, ParserOptions parserOptions, ColType desiredColType) {
        DataColumn dataColumn;
        Object object = $this$toDataColumn.data();
        Intrinsics.checkNotNull((Object)object);
        ListSink listSink = (ListSink)object;
        List<Object> columnData = listSink.getData();
        DataType dataType = listSink.getDataType();
        boolean hasNulls = listSink.getHasNulls();
        KType type = KTypes.withNullability((KType)ReadDelimDeephavenKt.toKType($this$toDataColumn.dataType()), (boolean)hasNulls);
        String string = $this$toDataColumn.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        ValueColumn column = DataColumn.Companion.createValueColumn$default((DataColumn.Companion)DataColumn.Companion, (String)string, columnData, (KType)type, null, null, (int)24, null);
        if (dataType != DataType.STRING) {
            return (DataColumn)column;
        }
        Intrinsics.checkNotNull((Object)column, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.columns.ValueColumn<kotlin.String?>");
        if (desiredColType != null) {
            dataColumn = ConvertKt.convertTo((DataColumn)((DataColumn)column), (KType)KTypes.withNullability((KType)CsvKt.toKType((ColType)desiredColType), (boolean)true), (ParserOptions)parserOptions);
        } else {
            Object object2 = parserOptions;
            if (object2 == null || (object2 = object2.getSkipTypes()) == null) {
                object2 = ParseKt.getParser((DataFrame.Companion)DataFrame.Companion).getSkipTypes();
            }
            Object givenSkipTypes = object2;
            Set adjustedSkipTypes = SetsKt.plus((Set)givenSkipTypes, (Iterable)typesDeephavenAlreadyParses);
            ParserOptions parserOptions2 = parserOptions;
            if (parserOptions2 == null) {
                parserOptions2 = new ParserOptions(null, null, null, null, null, null, 63, null);
            }
            ParserOptions adjustedParserOptions = ParserOptions.copy$default((ParserOptions)parserOptions2, null, null, null, null, (Set)adjustedSkipTypes, null, (int)47, null);
            dataColumn = ParseKt.tryParse((DataColumn)((DataColumn)column), (ParserOptions)adjustedParserOptions);
        }
        return dataColumn;
    }

    private static final KType toKType(DataType $this$toKType) {
        KType kType;
        DataType dataType = $this$toKType;
        switch (dataType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1: {
                kType = Reflection.typeOf(Boolean.TYPE);
                break;
            }
            case 2: {
                kType = Reflection.typeOf(Byte.TYPE);
                break;
            }
            case 3: {
                kType = Reflection.typeOf(Short.TYPE);
                break;
            }
            case 4: {
                kType = Reflection.typeOf(Integer.TYPE);
                break;
            }
            case 5: {
                kType = Reflection.typeOf(Long.TYPE);
                break;
            }
            case 6: {
                kType = Reflection.typeOf(Float.TYPE);
                break;
            }
            case 7: {
                kType = Reflection.typeOf(Double.TYPE);
                break;
            }
            case 8: {
                kType = Reflection.typeOf(LocalDateTime.class);
                break;
            }
            case 9: {
                kType = Reflection.typeOf(Character.TYPE);
                break;
            }
            case 10: {
                kType = Reflection.typeOf(String.class);
                break;
            }
            case 11: {
                kType = Reflection.typeOf(LocalDateTime.class);
                break;
            }
            case 12: {
                throw new IllegalStateException("custom data type".toString());
            }
            case -1: {
                throw new IllegalStateException("null data type".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kType;
    }

    /*
     * WARNING - void declaration
     */
    private static final String[] legalizeHeader(String[] header) {
        void $this$mapTo$iv$iv;
        ColumnNameGenerator generator = new ColumnNameGenerator(null, 1, null);
        String[] $this$map$iv = header;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(generator.addUnique((String)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private static final CsvSpecs.Builder skipLines(CsvSpecs.Builder $this$skipLines, boolean takeHeaderFromCsv, long skipLines) {
        CsvSpecs.Builder builder;
        if (takeHeaderFromCsv) {
            CsvSpecs.Builder builder2 = $this$skipLines.skipHeaderRows(skipLines);
            Intrinsics.checkNotNull((Object)builder2);
            builder = builder2;
        } else {
            CsvSpecs.Builder builder3 = $this$skipLines.skipRows(skipLines);
            Intrinsics.checkNotNull((Object)builder3);
            builder = builder3;
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private static final CsvSpecs.Builder parsers(CsvSpecs.Builder $this$parsers, ParserOptions parserOptions, Map<String, ? extends ColType> colTypes) {
        Collection collection;
        Object[] colType;
        for (Map.Entry<String, ? extends ColType> entry : colTypes.entrySet()) {
            String colName = entry.getKey();
            colType = entry.getValue();
            if (Intrinsics.areEqual((Object)colName, (Object)".default")) continue;
            $this$parsers.putParserForName(colName, ReadDelimDeephavenKt.toCsvParser((ColType)colType));
        }
        List list = Parsers.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DEFAULT");
        List defaultParsers = CollectionsKt.minus((Iterable)list, (Object)Parsers.DATETIME);
        Object object = parserOptions;
        if (object == null || (object = object.getSkipTypes()) == null) {
            object = ParseKt.getParser((DataFrame.Companion)DataFrame.Companion).getSkipTypes();
        }
        Object skipTypes = object;
        if (colTypes.containsKey(".default")) {
            colType = new Parser[2];
            ColType colType2 = colTypes.get(".default");
            Intrinsics.checkNotNull((Object)colType2);
            colType[0] = ReadDelimDeephavenKt.toCsvParser(colType2);
            colType[1] = Parsers.STRING;
            collection = CollectionsKt.listOf((Object[])colType);
        } else if (!((Collection)skipTypes).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = (Iterable)skipTypes;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Parser<?> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KType it = (KType)element$iv$iv;
                boolean bl2 = false;
                if (ReadDelimDeephavenKt.toCsvParserOrNull(ReadDelimDeephavenKt.toColType(it)) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List parsersToSkip = (List)destination$iv$iv;
            collection = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)defaultParsers), (Iterable)CollectionsKt.toSet((Iterable)parsersToSkip));
        } else {
            collection = defaultParsers;
        }
        Collection parsersToUse = collection;
        $this$parsers.parsers((Iterable)parsersToUse);
        return $this$parsers;
    }

    private static final CsvSpecs.Builder header(CsvSpecs.Builder $this$header, List<String> header) {
        CsvSpecs.Builder builder;
        if (header.isEmpty()) {
            CsvSpecs.Builder builder2 = $this$header.hasHeaderRow(true);
            Intrinsics.checkNotNull((Object)builder2);
            builder = builder2;
        } else {
            CsvSpecs.Builder builder3 = $this$header.hasHeaderRow(false).headers((Iterable)header);
            Intrinsics.checkNotNull((Object)builder3);
            builder = builder3;
        }
        return builder;
    }

    @Nullable
    public static final Parser<?> toCsvParserOrNull(@NotNull ColType $this$toCsvParserOrNull) {
        Parser parser;
        Intrinsics.checkNotNullParameter((Object)$this$toCsvParserOrNull, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toCsvParserOrNull.ordinal()]) {
            case 1: {
                parser = Parsers.INT;
                break;
            }
            case 2: {
                parser = Parsers.LONG;
                break;
            }
            case 3: {
                parser = Parsers.DOUBLE;
                break;
            }
            case 4: {
                parser = Parsers.CHAR;
                break;
            }
            case 5: {
                parser = Parsers.BOOLEAN;
                break;
            }
            case 6: {
                parser = Parsers.STRING;
                break;
            }
            default: {
                parser = null;
            }
        }
        return parser;
    }

    @NotNull
    public static final Parser<?> toCsvParser(@NotNull ColType $this$toCsvParser) {
        Intrinsics.checkNotNullParameter((Object)$this$toCsvParser, (String)"<this>");
        Parser parser = ReadDelimDeephavenKt.toCsvParserOrNull($this$toCsvParser);
        if (parser == null) {
            Parser parser2 = Parsers.STRING;
            parser = parser2;
            Intrinsics.checkNotNullExpressionValue((Object)parser2, (String)"STRING");
        }
        return parser;
    }

    @NotNull
    public static final ColType toColType(@NotNull KType $this$toColType) {
        Intrinsics.checkNotNullParameter((Object)$this$toColType, (String)"<this>");
        KType kType = KTypes.withNullability((KType)$this$toColType, (boolean)false);
        return Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Integer.TYPE)) ? ColType.Int : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE)) ? ColType.Long : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Double.TYPE)) ? ColType.Double : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Boolean.TYPE)) ? ColType.Boolean : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigDecimal.class)) ? ColType.BigDecimal : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigInteger.class)) ? ColType.BigInteger : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(LocalDate.class)) ? ColType.LocalDate : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(LocalTime.class)) ? ColType.LocalTime : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(LocalDateTime.class)) ? ColType.LocalDateTime : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(String.class)) ? ColType.String : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Instant.class)) ? ColType.Instant : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Duration.class)) ? ColType.Duration : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(URL.class)) ? ColType.Url : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(DataFrame.class, (KTypeProjection)KTypeProjection.Companion.getSTAR())) ? ColType.JsonArray : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(DataRow.class, (KTypeProjection)KTypeProjection.Companion.getSTAR())) ? ColType.JsonObject : (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Character.TYPE)) ? ColType.Char : ColType.String)))))))))))))));
    }

    @NotNull
    public static final Set<KType> getTypesDeephavenAlreadyParses() {
        return typesDeephavenAlreadyParses;
    }

    static {
        Object[] objectArray = new KType[]{Reflection.typeOf(Integer.TYPE), Reflection.typeOf(Long.TYPE), Reflection.typeOf(Double.TYPE), Reflection.typeOf(Character.TYPE), Reflection.typeOf(Boolean.TYPE)};
        typesDeephavenAlreadyParses = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.BOOLEAN_AS_BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DATETIME_AS_LONG.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.CHAR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.STRING.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.TIMESTAMP_AS_LONG.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.CUSTOM.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ColType.values().length];
            try {
                nArray[ColType.Int.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.Long.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.Double.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.Char.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.Boolean.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.String.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

