/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.io;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.sinks.SinkFactory;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.ConvertersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.impl.io.SinkSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010!\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020#2\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020\u0014H\u0016J(\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020\u0000H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/io/ListSink;", "Lorg/jetbrains/kotlinx/dataframe/impl/io/SinkSource;", "", "columnIndex", "", "dataType", "Lio/deephaven/csv/parsers/DataType;", "<init>", "(ILio/deephaven/csv/parsers/DataType;)V", "getColumnIndex", "()I", "getDataType", "()Lio/deephaven/csv/parsers/DataType;", "_data", "", "data", "", "getData", "()Ljava/util/List;", "value", "", "hasNulls", "getHasNulls", "()Z", "getValue", "src", "srcIndex", "isNull", "", "writeAppending", "", "destBegin", "destEnd", "writeReplacing", "write", "", "appending", "read", "dest", "srcBegin", "srcEnd", "getUnderlying", "Companion", "dataframe-csv"})
@SourceDebugExtension(value={"SMAP\nListSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListSink.kt\norg/jetbrains/kotlinx/dataframe/impl/io/ListSink\n+ 2 Duration.kt\nkotlin/time/Duration\n*L\n1#1,205:1\n731#2,2:206\n731#2,2:208\n*S KotlinDebug\n*F\n+ 1 ListSink.kt\norg/jetbrains/kotlinx/dataframe/impl/io/ListSink\n*L\n93#1:206,2\n99#1:208,2\n*E\n"})
public final class ListSink
implements SinkSource<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int columnIndex;
    @NotNull
    private final DataType dataType;
    @NotNull
    private final List<Object> _data;
    private boolean hasNulls;
    @NotNull
    private static final SinkFactory SINK_FACTORY;

    public ListSink(int columnIndex, @NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        this.columnIndex = columnIndex;
        this.dataType = dataType;
        this._data = new ArrayList(1000);
    }

    public final int getColumnIndex() {
        return this.columnIndex;
    }

    @NotNull
    public final DataType getDataType() {
        return this.dataType;
    }

    @NotNull
    public final List<Object> getData() {
        return this._data;
    }

    public final boolean getHasNulls() {
        return this.hasNulls;
    }

    /*
     * WARNING - void declaration
     */
    private final Object getValue(Object src, int srcIndex, boolean[] isNull) {
        Comparable comparable;
        if (isNull[srcIndex]) {
            this.hasNulls = true;
            comparable = null;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    comparable = Boolean.valueOf(((byte[])src)[srcIndex] == 1);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    comparable = Byte.valueOf(((byte[])src)[srcIndex]);
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.ShortArray");
                    comparable = Short.valueOf(((short[])src)[srcIndex]);
                    break;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.IntArray");
                    comparable = Integer.valueOf(((int[])src)[srcIndex]);
                    break;
                }
                case 5: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.LongArray");
                    comparable = Long.valueOf(((long[])src)[srcIndex]);
                    break;
                }
                case 6: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.FloatArray");
                    comparable = Float.valueOf(((float[])src)[srcIndex]);
                    break;
                }
                case 7: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.DoubleArray");
                    comparable = Double.valueOf(((double[])src)[srcIndex]);
                    break;
                }
                case 8: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.CharArray");
                    comparable = Character.valueOf(((char[])src)[srcIndex]);
                    break;
                }
                case 9: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    comparable = (Comparable)((Object)((String[])src)[srcIndex]);
                    break;
                }
                case 10: {
                    void nanoseconds;
                    void arg0$iv;
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.LongArray");
                    long l = DurationKt.toDuration((long)((long[])src)[srcIndex], (DurationUnit)DurationUnit.NANOSECONDS);
                    boolean bl = false;
                    int n = Duration.getNanosecondsComponent-impl((long)arg0$iv);
                    long seconds = Duration.getInWholeSeconds-impl((long)arg0$iv);
                    boolean bl2 = false;
                    LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(seconds, (int)nanoseconds, ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toComponents-impl(...)");
                    comparable = (Comparable)ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
                    break;
                }
                case 11: {
                    Intrinsics.checkNotNull((Object)src, (String)"null cannot be cast to non-null type kotlin.LongArray");
                    long arg0$iv = DurationKt.toDuration((long)((long[])src)[srcIndex], (DurationUnit)DurationUnit.NANOSECONDS);
                    boolean bl = false;
                    int nanoseconds = Duration.getNanosecondsComponent-impl((long)arg0$iv);
                    long seconds = Duration.getInWholeSeconds-impl((long)arg0$iv);
                    boolean bl3 = false;
                    LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(seconds, nanoseconds, ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toComponents-impl(...)");
                    comparable = (Comparable)ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported parser".toString());
                }
            }
        }
        return comparable;
    }

    private final void writeAppending(Object src, int destBegin, int destEnd, boolean[] isNull) {
        while (this.getData().size() < destBegin) {
            ((Collection)this._data).add(null);
            this.hasNulls = true;
        }
        int n = 0;
        for (int i = destBegin; i < destEnd; ++i) {
            int srcIndex = n++;
            ((Collection)this._data).add(this.getValue(src, srcIndex, isNull));
        }
    }

    private final void writeReplacing(Object src, int destBegin, int destEnd, boolean[] isNull) {
        int n = destBegin;
        int n2 = 0;
        while (n < destEnd) {
            int srcIndex = n2++;
            int destIndex = n++;
            this._data.set(destIndex, this.getValue(src, srcIndex, isNull));
        }
    }

    public void write(@NotNull Object src, @NotNull boolean[] isNull, long destBegin, long destEnd, boolean appending) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)isNull, (String)"isNull");
        if (destBegin == destEnd) {
            return;
        }
        int destBeginAsInt = (int)destBegin;
        int destEndAsInt = (int)destEnd;
        if (appending) {
            this.writeAppending(src, destBeginAsInt, destEndAsInt, isNull);
        } else {
            this.writeReplacing(src, destBeginAsInt, destEndAsInt, isNull);
        }
    }

    public void read(@NotNull Object dest, @NotNull boolean[] isNull, long srcBegin, long srcEnd) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)isNull, (String)"isNull");
        if (srcBegin == srcEnd) {
            return;
        }
        int srcBeginAsInt = (int)srcBegin;
        int srcEndAsInt = (int)srcEnd;
        switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
            case 2: {
                byte[] cfr_ignored_0 = (byte[])dest;
                int n = 0;
                for (int i = srcBeginAsInt; i < srcEndAsInt; ++i) {
                    int srcIndex = n++;
                    int destIndex = i;
                    Byte value = (Byte)this.getData().get(srcIndex);
                    if (value != null) {
                        ((byte[])dest)[destIndex] = value;
                    }
                    isNull[destIndex] = value == null;
                }
                break;
            }
            case 3: {
                short[] cfr_ignored_1 = (short[])dest;
                int n = 0;
                for (int i = srcBeginAsInt; i < srcEndAsInt; ++i) {
                    int srcIndex = n++;
                    int destIndex = i;
                    Short value = (Short)this.getData().get(srcIndex);
                    if (value != null) {
                        ((short[])dest)[destIndex] = value;
                    }
                    isNull[destIndex] = value == null;
                }
                break;
            }
            case 4: {
                int[] cfr_ignored_2 = (int[])dest;
                int n = 0;
                for (int i = srcBeginAsInt; i < srcEndAsInt; ++i) {
                    int srcIndex = n++;
                    int destIndex = i;
                    Integer value = (Integer)this.getData().get(srcIndex);
                    if (value != null) {
                        ((int[])dest)[destIndex] = value;
                    }
                    isNull[destIndex] = value == null;
                }
                break;
            }
            case 5: {
                long[] cfr_ignored_3 = (long[])dest;
                int n = 0;
                for (int i = srcBeginAsInt; i < srcEndAsInt; ++i) {
                    int srcIndex = n++;
                    int destIndex = i;
                    Long value = (Long)this.getData().get(srcIndex);
                    if (value != null) {
                        ((long[])dest)[destIndex] = value;
                    }
                    isNull[destIndex] = value == null;
                }
                break;
            }
            default: {
                throw new IllegalStateException("unsupported sink state".toString());
            }
        }
    }

    @NotNull
    public ListSink getUnderlying() {
        return this;
    }

    private static final SinkSource SINK_FACTORY$lambda$2(int it) {
        return new ListSink(it, DataType.BYTE);
    }

    private static final SinkSource SINK_FACTORY$lambda$3(int it) {
        return new ListSink(it, DataType.SHORT);
    }

    private static final SinkSource SINK_FACTORY$lambda$4(int it) {
        return new ListSink(it, DataType.INT);
    }

    private static final SinkSource SINK_FACTORY$lambda$5(int it) {
        return new ListSink(it, DataType.LONG);
    }

    private static final SinkSource SINK_FACTORY$lambda$6(int it) {
        return new ListSink(it, DataType.FLOAT);
    }

    private static final SinkSource SINK_FACTORY$lambda$7(int it) {
        return new ListSink(it, DataType.DOUBLE);
    }

    private static final SinkSource SINK_FACTORY$lambda$8(int it) {
        return new ListSink(it, DataType.BOOLEAN_AS_BYTE);
    }

    private static final SinkSource SINK_FACTORY$lambda$9(int it) {
        return new ListSink(it, DataType.CHAR);
    }

    private static final SinkSource SINK_FACTORY$lambda$10(int it) {
        return new ListSink(it, DataType.STRING);
    }

    private static final SinkSource SINK_FACTORY$lambda$11(int it) {
        return new ListSink(it, DataType.DATETIME_AS_LONG);
    }

    private static final SinkSource SINK_FACTORY$lambda$12(int it) {
        return new ListSink(it, DataType.TIMESTAMP_AS_LONG);
    }

    static {
        SinkFactory sinkFactory = SinkFactory.of(ListSink::SINK_FACTORY$lambda$2, ListSink::SINK_FACTORY$lambda$3, ListSink::SINK_FACTORY$lambda$4, ListSink::SINK_FACTORY$lambda$5, ListSink::SINK_FACTORY$lambda$6, ListSink::SINK_FACTORY$lambda$7, ListSink::SINK_FACTORY$lambda$8, ListSink::SINK_FACTORY$lambda$9, ListSink::SINK_FACTORY$lambda$10, ListSink::SINK_FACTORY$lambda$11, ListSink::SINK_FACTORY$lambda$12);
        Intrinsics.checkNotNullExpressionValue((Object)sinkFactory, (String)"of(...)");
        SINK_FACTORY = sinkFactory;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/io/ListSink$Companion;", "", "<init>", "()V", "SINK_FACTORY", "Lio/deephaven/csv/sinks/SinkFactory;", "getSINK_FACTORY", "()Lio/deephaven/csv/sinks/SinkFactory;", "dataframe-csv"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SinkFactory getSINK_FACTORY() {
            return SINK_FACTORY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.BOOLEAN_AS_BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.CHAR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DATETIME_AS_LONG.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.TIMESTAMP_AS_LONG.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

