/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.io.ArrowWriterKt;
import org.jetbrains.kotlinx.dataframe.io.ConvertingMismatch;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a(\u0010\u0000\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u001a.\u0010\b\u001a\u00020\t*\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0002j\u0002`\u00030\n2\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a8\u0006\u000b"}, d2={"toArrowField", "Lorg/apache/arrow/vector/types/pojo/Field;", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "mismatchSubscriber", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/dataframe/io/ConvertingMismatch;", "", "toArrowSchema", "Lorg/apache/arrow/vector/types/pojo/Schema;", "", "dataframe-arrow"})
@SourceDebugExtension(value={"SMAP\narrowTypesMatching.kt\nKotlin\n*S Kotlin\n*F\n+ 1 arrowTypesMatching.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowTypesMatchingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1549#2:109\n1620#2,3:110\n*S KotlinDebug\n*F\n+ 1 arrowTypesMatching.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowTypesMatchingKt\n*L\n105#1:109\n105#1:110,3\n*E\n"})
public final class ArrowTypesMatchingKt {
    @NotNull
    public static final Field toArrowField(@NotNull DataColumn<?> $this$toArrowField, @NotNull Function1<? super ConvertingMismatch, Unit> mismatchSubscriber) {
        Field field;
        Intrinsics.checkNotNullParameter($this$toArrowField, (String)"<this>");
        Intrinsics.checkNotNullParameter(mismatchSubscriber, (String)"mismatchSubscriber");
        DataColumn<?> column = $this$toArrowField;
        KType columnType = column.type();
        boolean nullable = columnType.isMarkedNullable();
        if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(String.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Utf8(), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(Boolean.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Bool(), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(Byte.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Int(8, true), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(Short.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Int(16, true), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(Integer.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Int(32, true), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(Long.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Int(64, true), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(Float.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(Double.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(LocalDate.class)) || KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(kotlinx.datetime.LocalDate.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Date(DateUnit.DAY), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(LocalDateTime.class)) || KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(kotlinx.datetime.LocalDateTime.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Date(DateUnit.MILLISECOND), null), CollectionsKt.emptyList());
        } else if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(LocalTime.class))) {
            field = new Field(column.name(), new FieldType(nullable, (ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 64), null), CollectionsKt.emptyList());
        } else {
            mismatchSubscriber.invoke((Object)new ConvertingMismatch.SavedAsString(column.name(), JvmClassMappingKt.getJavaClass((KClass)DataColumnKt.getTypeClass(column))));
            field = new Field(column.name(), new FieldType(true, (ArrowType)new ArrowType.Utf8(), null), CollectionsKt.emptyList());
        }
        return field;
    }

    public static /* synthetic */ Field toArrowField$default(DataColumn dataColumn, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = ArrowWriterKt.getIgnoreMismatchMessage();
        }
        return ArrowTypesMatchingKt.toArrowField(dataColumn, function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Schema toArrowSchema(@NotNull List<? extends DataColumn<?>> $this$toArrowSchema, @NotNull Function1<? super ConvertingMismatch, Unit> mismatchSubscriber) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toArrowSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter(mismatchSubscriber, (String)"mismatchSubscriber");
        Iterable $this$map$iv = $this$toArrowSchema;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ArrowTypesMatchingKt.toArrowField(it, mismatchSubscriber));
        }
        List fields = (List)destination$iv$iv;
        return new Schema((Iterable)fields);
    }

    public static /* synthetic */ Schema toArrowSchema$default(List list, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = ArrowWriterKt.getIgnoreMismatchMessage();
        }
        return ArrowTypesMatchingKt.toArrowSchema(list, function1);
    }
}

