/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.channels.WritableByteChannel;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedWidthVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VariableWidthVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.ConvertKt;
import org.jetbrains.kotlinx.dataframe.api.ForEachKt;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.exceptions.CellConversionException;
import org.jetbrains.kotlinx.dataframe.exceptions.TypeConverterNotFoundException;
import org.jetbrains.kotlinx.dataframe.io.ArrowTypesMatchingKt;
import org.jetbrains.kotlinx.dataframe.io.ArrowWriter;
import org.jetbrains.kotlinx.dataframe.io.ArrowWriterKt;
import org.jetbrains.kotlinx.dataframe.io.ConvertingException;
import org.jetbrains.kotlinx.dataframe.io.ConvertingMismatch;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ)\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010#j\u0004\u0018\u0001`$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u000bH\u0016J0\u0010+\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010#j\u0004\u0018\u0001`$2\u0012\u0010\"\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010#j\u0004\u0018\u0001`$2\u0006\u0010,\u001a\u00020-H\u0002J\u001f\u0010.\u001a\u0004\u0018\u00010\u001d2\u000e\u0010\"\u001a\n\u0012\u0002\b\u00030#j\u0002`$H\u0002\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\"\u001a\n\u0012\u0002\b\u00030#j\u0002`$H\u0002J\u0018\u00101\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u00102\u001a\b\u0012\u0004\u0012\u00020\u001903*\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030#j\u0002`$03H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriterImpl;", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter;", "dataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "targetSchema", "Lorg/apache/arrow/vector/types/pojo/Schema;", "mode", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "mismatchSubscriber", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/dataframe/io/ConvertingMismatch;", "", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Lorg/apache/arrow/vector/types/pojo/Schema;Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;Lkotlin/jvm/functions/Function1;)V", "allocator", "Lorg/apache/arrow/memory/RootAllocator;", "getDataFrame", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getMismatchSubscriber", "()Lkotlin/jvm/functions/Function1;", "getMode", "()Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "getTargetSchema", "()Lorg/apache/arrow/vector/types/pojo/Schema;", "allocateVector", "vector", "Lorg/apache/arrow/vector/FieldVector;", "size", "", "totalBytes", "", "(Lorg/apache/arrow/vector/FieldVector;ILjava/lang/Long;)V", "allocateVectorAndInfill", "field", "Lorg/apache/arrow/vector/types/pojo/Field;", "column", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "strictType", "", "strictNullable", "allocateVectorSchemaRoot", "Lorg/apache/arrow/vector/VectorSchemaRoot;", "close", "convertColumnToTarget", "targetFieldType", "Lorg/apache/arrow/vector/types/pojo/ArrowType;", "countTotalBytes", "(Lorg/jetbrains/kotlinx/dataframe/DataColumn;)Ljava/lang/Long;", "infillVector", "infillWithNulls", "toVectors", "", "dataframe-arrow"})
@SourceDebugExtension(value={"SMAP\nArrowWriterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrowWriterImpl.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowWriterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 map.kt\norg/jetbrains/kotlinx/dataframe/api/MapKt\n*L\n1#1,266:1\n1#2:267\n1789#3,3:268\n1549#3:283\n1620#3,3:284\n1855#3,2:287\n766#3:289\n857#3,2:290\n1855#3,2:292\n1855#3,2:294\n32#4,6:271\n32#4,6:277\n*S KotlinDebug\n*F\n+ 1 ArrowWriterImpl.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowWriterImpl\n*L\n88#1:268,3\n218#1:283\n218#1:284,3\n243#1:287,2\n248#1:289\n248#1:290,2\n251#1:292,2\n255#1:294,2\n105#1:271,6\n106#1:277,6\n*E\n"})
public final class ArrowWriterImpl
implements ArrowWriter {
    @NotNull
    private final DataFrame<?> dataFrame;
    @NotNull
    private final Schema targetSchema;
    @NotNull
    private final ArrowWriter.Mode mode;
    @NotNull
    private final Function1<ConvertingMismatch, Unit> mismatchSubscriber;
    @NotNull
    private final RootAllocator allocator;

    public ArrowWriterImpl(@NotNull DataFrame<?> dataFrame, @NotNull Schema targetSchema, @NotNull ArrowWriter.Mode mode, @NotNull Function1<? super ConvertingMismatch, Unit> mismatchSubscriber) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)targetSchema, (String)"targetSchema");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(mismatchSubscriber, (String)"mismatchSubscriber");
        this.dataFrame = dataFrame;
        this.targetSchema = targetSchema;
        this.mode = mode;
        this.mismatchSubscriber = mismatchSubscriber;
        this.allocator = new RootAllocator();
    }

    public /* synthetic */ ArrowWriterImpl(DataFrame dataFrame, Schema schema, ArrowWriter.Mode mode, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = ArrowWriterKt.getIgnoreMismatchMessage();
        }
        this(dataFrame, schema, mode, function1);
    }

    @Override
    @NotNull
    public DataFrame<?> getDataFrame() {
        return this.dataFrame;
    }

    @Override
    @NotNull
    public Schema getTargetSchema() {
        return this.targetSchema;
    }

    @Override
    @NotNull
    public ArrowWriter.Mode getMode() {
        return this.mode;
    }

    @Override
    @NotNull
    public Function1<ConvertingMismatch, Unit> getMismatchSubscriber() {
        return this.mismatchSubscriber;
    }

    private final void allocateVector(FieldVector vector, int size, Long totalBytes) {
        FieldVector fieldVector = vector;
        if (fieldVector instanceof FixedWidthVector) {
            ((FixedWidthVector)vector).allocateNew(size);
        } else if (fieldVector instanceof VariableWidthVector) {
            Unit unit;
            Long l = totalBytes;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                ((VariableWidthVector)vector).allocateNew(it, size);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                ((VariableWidthVector)vector).allocateNew(size);
            }
        } else {
            throw new IllegalArgumentException("Can not allocate " + vector.getClass().getCanonicalName());
        }
    }

    static /* synthetic */ void allocateVector$default(ArrowWriterImpl arrowWriterImpl, FieldVector fieldVector, int n, Long l, int n2, Object object) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        arrowWriterImpl.allocateVector(fieldVector, n, l);
    }

    /*
     * WARNING - void declaration
     */
    private final Long countTotalBytes(DataColumn<?> column) {
        Long l;
        KType columnType = column.type();
        if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(String.class))) {
            void $this$fold$iv;
            Iterable iterable = DataColumnKt.getValues(column);
            Long initial$iv = 0L;
            boolean $i$f$fold = false;
            Long accumulator$iv = initial$iv;
            Iterator iterator = $this$fold$iv.iterator();
            while (iterator.hasNext()) {
                void value;
                Object element$iv;
                Object t = element$iv = iterator.next();
                long totalBytes = ((Number)accumulator$iv).longValue();
                boolean bl = false;
                accumulator$iv = totalBytes + (long)(String.valueOf(value).length() * 4);
            }
            l = accumulator$iv;
        } else {
            l = null;
        }
        return l;
    }

    private final void infillWithNulls(FieldVector vector, int size) {
        FieldVector fieldVector = vector;
        if (fieldVector instanceof BaseFixedWidthVector) {
            for (int i = 0; i < size; ++i) {
                vector.setNull(i);
            }
        } else if (fieldVector instanceof BaseVariableWidthVector) {
            for (int i = 0; i < size; ++i) {
                vector.setNull(i);
            }
        } else {
            throw new IllegalArgumentException("Can not infill " + vector.getClass().getCanonicalName());
        }
        vector.setValueCount(size);
    }

    /*
     * WARNING - void declaration
     */
    private final DataColumn<?> convertColumnToTarget(DataColumn<?> column, ArrowType targetFieldType) {
        DataColumn dataColumn;
        if (column == null) {
            return null;
        }
        ArrowType arrowType = targetFieldType;
        if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Utf8())) {
            DataColumn<?> $this$map_u24default$iv = column;
            Infer infer$iv = Infer.Nulls;
            boolean $i$f$map = false;
            int n = $this$map_u24default$iv.size();
            Object[] objectArray = new String[n];
            for (int i = 0; i < n; ++i) {
                void it;
                int n2 = i;
                Object object = $this$map_u24default$iv.get(n2);
                int n3 = n2;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                void v0 = it;
                String string = v0 != null ? v0.toString() : null;
                objectArray2[n3] = string;
            }
            List newValues$iv = ArraysKt.asList((Object[])objectArray);
            dataColumn = DataColumn.Companion.create($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(String.class), infer$iv);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.LargeUtf8())) {
            DataColumn<?> $this$map_u24default$iv = column;
            Infer infer$iv = Infer.Nulls;
            boolean $i$f$map = false;
            int n = $this$map_u24default$iv.size();
            Object[] objectArray = new String[n];
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                Object it = $this$map_u24default$iv.get(n4);
                int n5 = n4;
                Object[] objectArray3 = objectArray;
                boolean bl = false;
                Object object = it;
                String string = object != null ? object.toString() : null;
                objectArray3[n5] = string;
            }
            List newValues$iv = ArraysKt.asList((Object[])objectArray);
            dataColumn = DataColumn.Companion.create($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(String.class), infer$iv);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Bool())) {
            dataColumn = ConvertKt.convertToBoolean(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(8, true))) {
            dataColumn = ConvertKt.convertToByte(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(16, true))) {
            dataColumn = ConvertKt.convertToShort(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(32, true))) {
            dataColumn = ConvertKt.convertToInt(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(64, true))) {
            dataColumn = ConvertKt.convertToLong(column);
        } else if (arrowType instanceof ArrowType.Decimal) {
            dataColumn = ConvertKt.convertToBigDecimal(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE))) {
            dataColumn = ConvertKt.convertToFloat((DataColumn)ConvertKt.convertToDouble(column));
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE))) {
            dataColumn = ConvertKt.convertToDouble(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Date(DateUnit.DAY))) {
            dataColumn = ConvertKt.convertToLocalDate(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Date(DateUnit.MILLISECOND))) {
            dataColumn = ConvertKt.convertToLocalDateTime(column);
        } else if (arrowType instanceof ArrowType.Time) {
            dataColumn = ConvertKt.convertToLocalTime(column);
        } else {
            throw new NotImplementedError("Saving " + targetFieldType.getClass().getCanonicalName() + " is currently not implemented");
        }
        return dataColumn;
    }

    private final void infillVector(FieldVector vector, DataColumn<?> column) {
        FieldVector fieldVector = vector;
        if (fieldVector instanceof VarCharVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToString(column), (Function2)((Function2)new Function2<Integer, String, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable String value) {
                    String string = value;
                    if (string != null) {
                        String string2 = string;
                        FieldVector fieldVector = this.$vector;
                        String it = string2;
                        boolean bl = false;
                        ((VarCharVector)fieldVector).set(i, new Text(value));
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof LargeVarCharVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToString(column), (Function2)((Function2)new Function2<Integer, String, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable String value) {
                    String string = value;
                    if (string != null) {
                        String string2 = string;
                        FieldVector fieldVector = this.$vector;
                        String it = string2;
                        boolean bl = false;
                        ((LargeVarCharVector)fieldVector).set(i, new Text(value));
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof BitVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToBoolean(column), (Function2)((Function2)new Function2<Integer, Boolean, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable Boolean value) {
                    Boolean bl = value;
                    if (bl != null) {
                        Boolean bl2 = bl;
                        FieldVector fieldVector = this.$vector;
                        boolean it = bl2;
                        boolean bl3 = false;
                        ((BitVector)fieldVector).set(i, Boolean.compare(value, false));
                        value.booleanValue();
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof TinyIntVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToInt(column), (Function2)((Function2)new Function2<Integer, Integer, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable Integer value) {
                    Integer n = value;
                    if (n != null) {
                        Integer n2 = n;
                        FieldVector fieldVector = this.$vector;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        ((TinyIntVector)fieldVector).set(i, value.intValue());
                        value.intValue();
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof SmallIntVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToInt(column), (Function2)((Function2)new Function2<Integer, Integer, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable Integer value) {
                    Integer n = value;
                    if (n != null) {
                        Integer n2 = n;
                        FieldVector fieldVector = this.$vector;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        ((SmallIntVector)fieldVector).set(i, value.intValue());
                        value.intValue();
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof IntVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToInt(column), (Function2)((Function2)new Function2<Integer, Integer, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable Integer value) {
                    Integer n = value;
                    if (n != null) {
                        Integer n2 = n;
                        FieldVector fieldVector = this.$vector;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        ((IntVector)fieldVector).set(i, value.intValue());
                        value.intValue();
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof BigIntVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToLong(column), (Function2)((Function2)new Function2<Integer, Long, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable Long value) {
                    Long l = value;
                    if (l != null) {
                        Long l2 = l;
                        FieldVector fieldVector = this.$vector;
                        long it = ((Number)l2).longValue();
                        boolean bl = false;
                        ((BigIntVector)fieldVector).set(i, value.longValue());
                        value.longValue();
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof DecimalVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToBigDecimal(column), (Function2)((Function2)new Function2<Integer, BigDecimal, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable BigDecimal value) {
                    BigDecimal bigDecimal = value;
                    if (bigDecimal != null) {
                        BigDecimal bigDecimal2 = bigDecimal;
                        FieldVector fieldVector = this.$vector;
                        BigDecimal it = bigDecimal2;
                        boolean bl = false;
                        ((DecimalVector)fieldVector).set(i, value);
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof Decimal256Vector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToBigDecimal(column), (Function2)((Function2)new Function2<Integer, BigDecimal, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable BigDecimal value) {
                    BigDecimal bigDecimal = value;
                    if (bigDecimal != null) {
                        BigDecimal bigDecimal2 = bigDecimal;
                        FieldVector fieldVector = this.$vector;
                        BigDecimal it = bigDecimal2;
                        boolean bl = false;
                        ((Decimal256Vector)fieldVector).set(i, value);
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof Float8Vector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToDouble(column), (Function2)((Function2)new Function2<Integer, Double, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable Double value) {
                    Double d = value;
                    if (d != null) {
                        Double d2 = d;
                        FieldVector fieldVector = this.$vector;
                        double it = ((Number)d2).doubleValue();
                        boolean bl = false;
                        ((Float8Vector)fieldVector).set(i, value.doubleValue());
                        value.doubleValue();
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof Float4Vector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToFloat(column), (Function2)((Function2)new Function2<Integer, Float, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable Float value) {
                    Float f = value;
                    if (f != null) {
                        Float f2 = f;
                        FieldVector fieldVector = this.$vector;
                        float it = ((Number)f2).floatValue();
                        boolean bl = false;
                        ((Float4Vector)fieldVector).set(i, value.floatValue());
                        value.floatValue();
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof DateDayVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToLocalDate(column), (Function2)((Function2)new Function2<Integer, LocalDate, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable LocalDate value) {
                    LocalDate localDate = value;
                    if (localDate != null) {
                        LocalDate localDate2 = localDate;
                        FieldVector fieldVector = this.$vector;
                        LocalDate it = localDate2;
                        boolean bl = false;
                        ((DateDayVector)fieldVector).set(i, (int)ConvertersKt.toJavaLocalDate((LocalDate)value).toEpochDay());
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof DateMilliVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToLocalDateTime(column), (Function2)((Function2)new Function2<Integer, LocalDateTime, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable LocalDateTime value) {
                    LocalDateTime localDateTime = value;
                    if (localDateTime != null) {
                        LocalDateTime localDateTime2 = localDateTime;
                        FieldVector fieldVector = this.$vector;
                        LocalDateTime it = localDateTime2;
                        boolean bl = false;
                        ((DateMilliVector)fieldVector).set(i, TimeZoneKt.toInstant((LocalDateTime)value, (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds());
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof TimeNanoVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToLocalTime(column), (Function2)((Function2)new Function2<Integer, LocalTime, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable LocalTime value) {
                    LocalTime localTime = value;
                    if (localTime != null) {
                        LocalTime localTime2 = localTime;
                        FieldVector fieldVector = this.$vector;
                        LocalTime it = localTime2;
                        boolean bl = false;
                        ((TimeNanoVector)fieldVector).set(i, value.toNanoOfDay());
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof TimeMicroVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToLocalTime(column), (Function2)((Function2)new Function2<Integer, LocalTime, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable LocalTime value) {
                    LocalTime localTime = value;
                    if (localTime != null) {
                        LocalTime localTime2 = localTime;
                        FieldVector fieldVector = this.$vector;
                        LocalTime it = localTime2;
                        boolean bl = false;
                        ((TimeMicroVector)fieldVector).set(i, value.toNanoOfDay() / (long)1000);
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof TimeMilliVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToLocalTime(column), (Function2)((Function2)new Function2<Integer, LocalTime, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable LocalTime value) {
                    LocalTime localTime = value;
                    if (localTime != null) {
                        LocalTime localTime2 = localTime;
                        FieldVector fieldVector = this.$vector;
                        LocalTime it = localTime2;
                        boolean bl = false;
                        ((TimeMilliVector)fieldVector).set(i, (int)(value.toNanoOfDay() / (long)1000 / (long)1000));
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else if (fieldVector instanceof TimeSecVector) {
            ForEachKt.forEachIndexed((DataColumn)ConvertKt.convertToLocalTime(column), (Function2)((Function2)new Function2<Integer, LocalTime, Unit>(vector){
                final /* synthetic */ FieldVector $vector;
                {
                    this.$vector = $vector;
                    super(2);
                }

                public final void invoke(int i, @Nullable LocalTime value) {
                    LocalTime localTime = value;
                    if (localTime != null) {
                        LocalTime localTime2 = localTime;
                        FieldVector fieldVector = this.$vector;
                        LocalTime it = localTime2;
                        boolean bl = false;
                        ((TimeSecVector)fieldVector).set(i, (int)(value.toNanoOfDay() / (long)1000 / (long)1000 / (long)1000));
                    } else {
                        this.$vector.setNull(i);
                    }
                }
            }));
        } else {
            throw new NotImplementedError("Saving to " + vector.getClass().getCanonicalName() + " is currently not implemented");
        }
        vector.setValueCount(this.getDataFrame().rowsCount());
    }

    private final FieldVector allocateVectorAndInfill(Field field, DataColumn<?> column, boolean strictType, boolean strictNullable) {
        FieldVector fieldVector;
        Pair pair;
        boolean containNulls = column == null || column.hasNulls();
        try {
            ArrowType arrowType = field.getType();
            Intrinsics.checkNotNullExpressionValue((Object)arrowType, (String)"field.type");
            pair = TuplesKt.to(this.convertColumnToTarget(column, arrowType), (Object)field);
        }
        catch (CellConversionException e) {
            if (strictType) {
                Object object = e.getColumn();
                if (object == null || (object = object.name()) == null) {
                    object = "";
                }
                ConvertingMismatch.TypeConversionFail.ConversionFailError mismatch = new ConvertingMismatch.TypeConversionFail.ConversionFailError((String)object, e.getRow(), e);
                this.getMismatchSubscriber().invoke((Object)mismatch);
                throw new ConvertingException(mismatch);
            }
            Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
            Object object = e.getColumn();
            if (object == null || (object = object.name()) == null) {
                object = "";
            }
            function1.invoke((Object)new ConvertingMismatch.TypeConversionFail.ConversionFailIgnored((String)object, e.getRow(), e));
            DataColumn<?> dataColumn = column;
            Intrinsics.checkNotNull(dataColumn);
            pair = TuplesKt.to(column, (Object)ArrowTypesMatchingKt.toArrowField(dataColumn, this.getMismatchSubscriber()));
        }
        catch (TypeConverterNotFoundException e) {
            if (strictType) {
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                ConvertingMismatch.TypeConversionNotFound.ConversionNotFoundError mismatch = new ConvertingMismatch.TypeConversionNotFound.ConversionNotFoundError(string, e);
                this.getMismatchSubscriber().invoke((Object)mismatch);
                throw new ConvertingException(mismatch);
            }
            Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
            String string = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
            function1.invoke((Object)new ConvertingMismatch.TypeConversionNotFound.ConversionNotFoundIgnored(string, e));
            DataColumn<?> dataColumn = column;
            Intrinsics.checkNotNull(dataColumn);
            pair = TuplesKt.to(column, (Object)ArrowTypesMatchingKt.toArrowField(dataColumn, this.getMismatchSubscriber()));
        }
        Pair pair2 = pair;
        DataColumn convertedColumn = (DataColumn)pair2.component1();
        Field actualField = (Field)pair2.component2();
        if (!actualField.isNullable() && containNulls) {
            int n;
            Integer firstNullValue = null;
            DataColumn<?> dataColumn = column;
            int n2 = n = dataColumn != null ? dataColumn.size() : -1;
            for (int i = 0; i < n; ++i) {
                DataColumn<?> dataColumn2 = column;
                Intrinsics.checkNotNull(dataColumn2);
                if (dataColumn2.get(i) != null) continue;
                firstNullValue = i;
                break;
            }
            if (strictNullable) {
                String string = actualField.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actualField.name");
                ConvertingMismatch.NullableMismatch.NullValueError mismatch = new ConvertingMismatch.NullableMismatch.NullValueError(string, firstNullValue);
                this.getMismatchSubscriber().invoke((Object)mismatch);
                throw new ConvertingException(mismatch);
            }
            Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
            String string = actualField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actualField.name");
            function1.invoke((Object)new ConvertingMismatch.NullableMismatch.NullValueIgnored(string, firstNullValue));
            FieldVector fieldVector2 = new Field(actualField.getName(), new FieldType(true, actualField.getFieldType().getType(), actualField.getFieldType().getDictionary()), actualField.getChildren()).createVector((BufferAllocator)this.allocator);
            fieldVector = fieldVector2;
            Intrinsics.checkNotNull((Object)fieldVector2);
        } else {
            FieldVector fieldVector3 = actualField.createVector((BufferAllocator)this.allocator);
            fieldVector = fieldVector3;
            Intrinsics.checkNotNull((Object)fieldVector3);
        }
        FieldVector vector = fieldVector;
        if (convertedColumn == null) {
            if (!actualField.isNullable()) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            ArrowWriterImpl.allocateVector$default(this, vector, this.getDataFrame().rowsCount(), null, 4, null);
            this.infillWithNulls(vector, this.getDataFrame().rowsCount());
        } else {
            this.allocateVector(vector, this.getDataFrame().rowsCount(), this.countTotalBytes(convertedColumn));
            this.infillVector(vector, convertedColumn);
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldVector> toVectors(List<? extends DataColumn<?>> $this$toVectors) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toVectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Field field = ArrowTypesMatchingKt.toArrowField(it, this.getMismatchSubscriber());
            collection.add(this.allocateVectorAndInfill(field, (DataColumn<?>)it, true, true));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VectorSchemaRoot allocateVectorSchemaRoot() {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        LinkedHashMap mainVectors = new LinkedHashMap();
        try {
            for (Field field : this.getTargetSchema().getFields()) {
                DataFrame<?> dataFrame = this.getDataFrame();
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                DataColumn column = dataFrame.getColumnOrNull(string);
                if (column == null && !field.isNullable()) {
                    if (this.getMode().getRestrictNarrowing()) {
                        String string2 = field.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name");
                        ConvertingMismatch.NarrowingMismatch.NotPresentedColumnError mismatch = new ConvertingMismatch.NarrowingMismatch.NotPresentedColumnError(string2);
                        this.getMismatchSubscriber().invoke((Object)mismatch);
                        throw new ConvertingException(mismatch);
                    }
                    Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
                    String string3 = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"field.name");
                    function1.invoke((Object)new ConvertingMismatch.NarrowingMismatch.NotPresentedColumnIgnored(string3));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                FieldVector vector = this.allocateVectorAndInfill(field, column, this.getMode().getStrictType(), this.getMode().getStrictNullable());
                Iterator iterator = mainVectors;
                String string4 = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"field.name");
                iterator.put(string4, vector);
            }
        }
        catch (Exception e) {
            Collection collection = mainVectors.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"mainVectors.values");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                FieldVector it = (FieldVector)element$iv;
                boolean bl = false;
                it.close();
            }
            throw e;
        }
        ArrayList vectors = new ArrayList();
        vectors.addAll(mainVectors.values());
        Iterable $this$filter$iv = this.getDataFrame().columns();
        boolean $i$f$filter = false;
        Iterable element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataColumn column = (DataColumn)element$iv$iv;
            boolean bl = false;
            if (!(!mainVectors.containsKey(column.name()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherColumns = (List)destination$iv$iv;
        if (!this.getMode().getRestrictWidening()) {
            vectors.addAll((Collection)this.toVectors(otherColumns));
            $this$forEach$iv = otherColumns;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                DataColumn it = (DataColumn)element$iv2;
                boolean bl = false;
                this.getMismatchSubscriber().invoke((Object)new ConvertingMismatch.WideningMismatch.AddedColumn(DataColumnKt.getName((DataColumn)it)));
            }
        } else {
            $this$forEach$iv = otherColumns;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                DataColumn it = (DataColumn)element$iv2;
                boolean bl = false;
                this.getMismatchSubscriber().invoke((Object)new ConvertingMismatch.WideningMismatch.RejectedColumn(DataColumnKt.getName((DataColumn)it)));
            }
        }
        return new VectorSchemaRoot((Iterable)vectors);
    }

    @Override
    public void close() {
        this.allocator.close();
    }

    @Override
    public void writeArrowIPC(@NotNull WritableByteChannel channel) {
        ArrowWriter.DefaultImpls.writeArrowIPC((ArrowWriter)this, channel);
    }

    @Override
    public void writeArrowIPC(@NotNull OutputStream stream) {
        ArrowWriter.DefaultImpls.writeArrowIPC((ArrowWriter)this, stream);
    }

    @Override
    public void writeArrowIPC(@NotNull File file, boolean append) {
        ArrowWriter.DefaultImpls.writeArrowIPC(this, file, append);
    }

    @Override
    @NotNull
    public byte[] saveArrowIPCToByteArray() {
        return ArrowWriter.DefaultImpls.saveArrowIPCToByteArray(this);
    }

    @Override
    public void writeArrowFeather(@NotNull WritableByteChannel channel) {
        ArrowWriter.DefaultImpls.writeArrowFeather((ArrowWriter)this, channel);
    }

    @Override
    public void writeArrowFeather(@NotNull OutputStream stream) {
        ArrowWriter.DefaultImpls.writeArrowFeather((ArrowWriter)this, stream);
    }

    @Override
    public void writeArrowFeather(@NotNull File file) {
        ArrowWriter.DefaultImpls.writeArrowFeather((ArrowWriter)this, file);
    }

    @Override
    @NotNull
    public byte[] saveArrowFeatherToByteArray() {
        return ArrowWriter.DefaultImpls.saveArrowFeatherToByteArray(this);
    }
}

