/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.validation;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\f\u0010\u001e\u001a\u00020\u000e*\u00020\u0006H\u0002R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR \u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\nR\u0016\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkotlinx/validation/ApiCompareCompareTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "apiBuildDir", "Ljava/io/File;", "getApiBuildDir", "()Ljava/io/File;", "setApiBuildDir", "(Ljava/io/File;)V", "dummyOutputFile", "getDummyOutputFile", "nonExistingProjectApiDir", "", "getNonExistingProjectApiDir", "()Ljava/lang/String;", "setNonExistingProjectApiDir", "(Ljava/lang/String;)V", "projectApiDir", "getProjectApiDir", "setProjectApiDir", "projectName", "kotlin.jvm.PlatformType", "rootDir", "compareFiles", "checkFile", "builtFile", "verify", "", "relativePath", "binary-compatibility-validator"})
public class ApiCompareCompareTask
extends DefaultTask {
    @Optional
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Nullable
    private File projectApiDir;
    @Input
    @Optional
    @Nullable
    private String nonExistingProjectApiDir;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File apiBuildDir;
    @OutputFile
    @Optional
    @Nullable
    private final File dummyOutputFile;
    private final String projectName;
    private final File rootDir;
    private final ObjectFactory objects;

    @Nullable
    public final File getProjectApiDir() {
        return this.projectApiDir;
    }

    public final void setProjectApiDir(@Nullable File file) {
        this.projectApiDir = file;
    }

    @Nullable
    public final String getNonExistingProjectApiDir() {
        return this.nonExistingProjectApiDir;
    }

    public final void setNonExistingProjectApiDir(@Nullable String string) {
        this.nonExistingProjectApiDir = string;
    }

    @NotNull
    public final File getApiBuildDir() {
        File file = this.apiBuildDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        return file;
    }

    public final void setApiBuildDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.apiBuildDir = file;
    }

    @Nullable
    public final File getDummyOutputFile() {
        return this.dummyOutputFile;
    }

    @TaskAction
    public final void verify() {
        File projectApiDir = this.projectApiDir;
        if (projectApiDir == null) {
            String string = "Expected folder with API declarations '" + this.nonExistingProjectApiDir + "' does not exist.\n" + "Please ensure that ':apiDump' was executed in order to get API dump to compare the build against";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String subject = this.projectName;
        boolean bl = false;
        Set apiBuildDirFiles = new LinkedHashSet();
        boolean bl2 = false;
        Set expectedApiFiles = new LinkedHashSet();
        ConfigurableFileTree configurableFileTree = this.objects.fileTree();
        File file = this.apiBuildDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        configurableFileTree.from((Object)file).visit((Action)new Action<FileVisitDetails>(apiBuildDirFiles){
            final /* synthetic */ Set $apiBuildDirFiles;

            public final void execute(FileVisitDetails file) {
                FileVisitDetails fileVisitDetails = file;
                Intrinsics.checkNotNullExpressionValue((Object)fileVisitDetails, (String)"file");
                RelativePath relativePath = fileVisitDetails.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"file.relativePath");
                this.$apiBuildDirFiles.add(relativePath);
            }
            {
                this.$apiBuildDirFiles = set;
            }
        });
        this.objects.fileTree().from((Object)projectApiDir).visit((Action)new Action<FileVisitDetails>(expectedApiFiles){
            final /* synthetic */ Set $expectedApiFiles;

            public final void execute(FileVisitDetails file) {
                FileVisitDetails fileVisitDetails = file;
                Intrinsics.checkNotNullExpressionValue((Object)fileVisitDetails, (String)"file");
                RelativePath relativePath = fileVisitDetails.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"file.relativePath");
                this.$expectedApiFiles.add(relativePath);
            }
            {
                this.$expectedApiFiles = set;
            }
        });
        if (apiBuildDirFiles.size() != 1) {
            String string = "Expected a single file " + subject + ".api, but found: " + expectedApiFiles;
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RelativePath expectedApiDeclaration = (RelativePath)CollectionsKt.single((Iterable)apiBuildDirFiles);
        if (!expectedApiFiles.contains(expectedApiDeclaration)) {
            String string = "File " + expectedApiDeclaration.getLastName() + " is missing from " + this.relativePath(projectApiDir) + ", please run " + ':' + subject + ":apiDump task to generate one";
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean bl5 = false;
        Set diffSet = new LinkedHashSet();
        File expectedFile = expectedApiDeclaration.getFile(projectApiDir);
        File file2 = this.apiBuildDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        File actualFile = expectedApiDeclaration.getFile(file2);
        File file3 = expectedFile;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"expectedFile");
        File file4 = actualFile;
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"actualFile");
        String diff = this.compareFiles(file3, file4);
        if (diff != null) {
            diffSet.add(diff);
        }
        Collection collection = diffSet;
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            String diffText = CollectionsKt.joinToString$default((Iterable)diffSet, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
            String string = "API check failed for project " + subject + ".\n" + diffText + "\n\n You can run :" + subject + ":apiDump task to overwrite API declarations";
            boolean bl7 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final String relativePath(File $this$relativePath) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = this.rootDir;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
        return stringBuilder.append(FilesKt.relativeTo((File)$this$relativePath, (File)file).toString()).append("/").toString();
    }

    private final String compareFiles(File checkFile, File builtFile) {
        List diff;
        List builtLines;
        String checkText = FilesKt.readText$default((File)checkFile, null, (int)1, null);
        String builtText = FilesKt.readText$default((File)builtFile, null, (int)1, null);
        List checkLines = StringsKt.lines((CharSequence)checkText);
        if (Intrinsics.areEqual((Object)checkLines, (Object)(builtLines = StringsKt.lines((CharSequence)builtText)))) {
            return null;
        }
        Patch patch = DiffUtils.diff((List)checkLines, (List)builtLines);
        List list = diff = DiffUtils.generateUnifiedDiff((String)checkFile.toString(), (String)builtFile.toString(), (List)checkLines, (Patch)patch, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"diff");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Inject
    public ApiCompareCompareTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.objects = objects;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.projectName = project.getName();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Project project3 = project2.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project.rootProject");
        this.rootDir = project3.getRootDir();
    }
}

