/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.validation.api.klib;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.validation.api.klib.DeclarationContainer;
import kotlinx.validation.api.klib.KlibAbiDumpFileMergerKt;
import kotlinx.validation.api.klib.KlibAbiDumpHeader;
import kotlinx.validation.api.klib.KlibAbiDumpMerger;
import kotlinx.validation.api.klib.KlibTarget;
import kotlinx.validation.api.klib.KlibTargetKt;
import kotlinx.validation.api.klib.KlibsTargetsFormatter;
import kotlinx.validation.api.klib.PeekingLineIterator;
import kotlinx.validation.api.klib.TargetHierarchy;
import kotlinx.validation.api.klib.TargetHierarchyKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J!\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\u001dJ'\u0010\u001a\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0000J\u001a\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0000J\u0014\u0010#\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0005J!\u0010(\u001a\u00020\u00122\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120*H\u0000\u00a2\u0006\u0002\b+J\f\u0010,\u001a\u00020-*\u00020!H\u0002J\u001e\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0/*\u00020!H\u0002JJ\u00100\u001a\u00020\u000e*\u00020!2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000e2\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\u00072\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0/H\u0002J\u001e\u00106\u001a\u000207*\u00020!2\u0006\u00108\u001a\u00020-2\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lkotlinx/validation/api/klib/KlibAbiDumpMerger;", "", "()V", "_targets", "", "Lkotlinx/validation/api/klib/KlibTarget;", "headerContent", "", "", "targets", "", "getTargets$binary_compatibility_validator", "()Ljava/util/Set;", "topLevelDeclaration", "Lkotlinx/validation/api/klib/DeclarationContainer;", "createFormatter", "Lkotlinx/validation/api/klib/KlibsTargetsFormatter;", "dump", "", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "extractTargets", "platformString", "targetsString", "configurableTargetName", "merge", "file", "Ljava/io/File;", "merge$binary_compatibility_validator", "lines", "", "other", "Lkotlinx/validation/api/klib/PeekingLineIterator;", "mergeTargetSpecific", "overrideTargets", "remove", "target", "retainCommonAbi", "retainTargetSpecificAbi", "visit", "action", "Lkotlin/Function1;", "visit$binary_compatibility_validator", "determineFileType", "", "parseAliases", "", "parseDeclaration", "depth", "", "parent", "parentTargetsStack", "aliases", "parseFileHeader", "Lkotlinx/validation/api/klib/KlibAbiDumpHeader;", "isMergedFile", "parseTargets", "binary-compatibility-validator"})
@SourceDebugExtension(value={"SMAP\nKlibAbiDumpFileMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibAbiDumpFileMerger.kt\nkotlinx/validation/api/klib/KlibAbiDumpMerger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,907:1\n1#2:908\n1549#3:909\n1620#3,3:910\n1549#3:913\n1620#3,3:914\n1360#3:917\n1446#3,5:918\n1855#3,2:923\n1855#3,2:925\n*E\n*S KotlinDebug\n*F\n+ 1 KlibAbiDumpFileMerger.kt\nkotlinx/validation/api/klib/KlibAbiDumpMerger\n*L\n230#1:909\n230#1,3:910\n308#1:913\n308#1,3:914\n351#1:917\n351#1,5:918\n373#1,2:923\n483#1,2:925\n*E\n"})
public final class KlibAbiDumpMerger {
    @NotNull
    private final Set<KlibTarget> _targets = new LinkedHashSet();
    @NotNull
    private final List<String> headerContent = new ArrayList();
    @NotNull
    private final DeclarationContainer topLevelDeclaration = new DeclarationContainer("", null, 2, null);
    @NotNull
    private final Set<KlibTarget> targets = this._targets;

    @NotNull
    public final Set<KlibTarget> getTargets$binary_compatibility_validator() {
        return this.targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void merge$binary_compatibility_validator(@NotNull File file, @Nullable String configurableTargetName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            boolean bl = false;
            String string = "File does not exist: " + file;
            throw new IllegalArgumentException(string.toString());
        }
        AutoCloseable autoCloseable = Files.lines(file.toPath());
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            Iterator<String> iterator = it.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"it.iterator()");
            this.merge$binary_compatibility_validator(iterator, configurableTargetName);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void merge$binary_compatibility_validator$default(KlibAbiDumpMerger klibAbiDumpMerger, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        klibAbiDumpMerger.merge$binary_compatibility_validator(file, string);
    }

    public final void merge$binary_compatibility_validator(@NotNull Iterator<String> lines, @Nullable String configurableTargetName) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.merge(new PeekingLineIterator(lines), configurableTargetName);
    }

    public static /* synthetic */ void merge$binary_compatibility_validator$default(KlibAbiDumpMerger klibAbiDumpMerger, Iterator iterator, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        klibAbiDumpMerger.merge$binary_compatibility_validator(iterator, string);
    }

    private final void merge(PeekingLineIterator lines, String configurableTargetName) {
        List $i$a$-check-KlibAbiDumpMerger$merge$5$222;
        Set $i$a$-check-KlibAbiDumpMerger$merge$522;
        if (!(lines.peek() != null)) {
            boolean $i$a$-require-KlibAbiDumpMerger$merge$42 = false;
            String $i$a$-require-KlibAbiDumpMerger$merge$42 = "File is empty";
            throw new IllegalArgumentException($i$a$-require-KlibAbiDumpMerger$merge$42.toString());
        }
        boolean isMergedFile = this.determineFileType(lines);
        Map aliases = new LinkedHashMap();
        Set bcvTargets = new LinkedHashSet();
        if (isMergedFile) {
            lines.next();
            bcvTargets.addAll((Collection)this.parseTargets(lines, configurableTargetName));
            if (!(bcvTargets.size() == 1 || configurableTargetName == null)) {
                boolean $i$a$-check-KlibAbiDumpMerger$merge$522 = false;
                String $i$a$-check-KlibAbiDumpMerger$merge$522 = "Can't use an explicit target name with a multi-target dump. targetName: " + configurableTargetName + ", dump targets: " + bcvTargets;
                throw new IllegalStateException($i$a$-check-KlibAbiDumpMerger$merge$522.toString());
            }
            aliases.putAll(this.parseAliases(lines));
        }
        KlibAbiDumpHeader header = this.parseFileHeader(lines, isMergedFile, configurableTargetName);
        bcvTargets.addAll((Collection)header.getUnderlyingTargets());
        Set it = $i$a$-check-KlibAbiDumpMerger$merge$522 = CollectionsKt.intersect((Iterable)bcvTargets, (Iterable)this.targets);
        boolean bl = false;
        if (!it.isEmpty()) {
            boolean $i$a$-check-KlibAbiDumpMerger$merge$5$222 = false;
            String $i$a$-check-KlibAbiDumpMerger$merge$5$222 = "This dump and a file to merge share some targets: " + it;
            throw new IllegalStateException($i$a$-check-KlibAbiDumpMerger$merge$5$222.toString());
        }
        if (this._targets.isEmpty()) {
            this.headerContent.addAll((Collection<String>)header.getContent());
        } else if (!Intrinsics.areEqual(this.headerContent, header.getContent())) {
            throw new IllegalStateException("File header doesn't match the header of other files\n" + this.headerContent + "\n\n\n" + header.getContent());
        }
        this._targets.addAll(bcvTargets);
        this.topLevelDeclaration.getTargets().addAll(bcvTargets);
        DeclarationContainer currentContainer = null;
        currentContainer = this.topLevelDeclaration;
        int depth = -1;
        List $this$merge_u24lambda_u246 = $i$a$-check-KlibAbiDumpMerger$merge$5$222 = (List)new ArrayList();
        boolean bl2 = false;
        $this$merge_u24lambda_u246.add(bcvTargets);
        List targetsStack = $i$a$-check-KlibAbiDumpMerger$merge$5$222;
        while (lines.hasNext()) {
            String line;
            Intrinsics.checkNotNull((Object)lines.peek());
            if (((CharSequence)line).length() == 0) {
                lines.next();
                continue;
            }
            int lineDepth = KlibAbiDumpFileMergerKt.access$depth(line);
            if (depth == lineDepth) {
                CollectionsKt.removeLast((List)targetsStack);
                DeclarationContainer declarationContainer = currentContainer.getParent();
                Intrinsics.checkNotNull((Object)declarationContainer);
                currentContainer = this.parseDeclaration(lines, lineDepth, declarationContainer, targetsStack, aliases);
                continue;
            }
            if (depth < lineDepth) {
                if (!(lineDepth - depth == 1)) {
                    boolean bl3 = false;
                    String string = "The line has too big indentation relative to a previous line\nline: " + line + "\nprevious: " + currentContainer.getText();
                    throw new IllegalStateException(string.toString());
                }
                currentContainer = this.parseDeclaration(lines, lineDepth, currentContainer, targetsStack, aliases);
                depth = lineDepth;
                continue;
            }
            while (KlibAbiDumpFileMergerKt.access$depth(currentContainer.getText()) > lineDepth) {
                Intrinsics.checkNotNull((Object)currentContainer.getParent());
                CollectionsKt.removeLast((List)targetsStack);
            }
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)line)).toString(), (Object)"}")) {
                currentContainer.setDelimiter(line);
                lines.next();
            }
            depth = currentContainer.getParent() == null ? -1 : KlibAbiDumpFileMergerKt.access$depth(currentContainer.getText());
        }
    }

    private final Set<KlibTarget> parseTargets(PeekingLineIterator $this$parseTargets, String configurableTargetName) {
        String line = $this$parseTargets.peek();
        if (!(line != null)) {
            boolean $i$a$-require-KlibAbiDumpMerger$parseTargets$42 = false;
            String $i$a$-require-KlibAbiDumpMerger$parseTargets$42 = "List of targets expected, but there are no more lines left.";
            throw new IllegalArgumentException($i$a$-require-KlibAbiDumpMerger$parseTargets$42.toString());
        }
        if (!StringsKt.startsWith$default((String)line, (String)"// Targets: [", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "The line should starts with // Targets: [, but was: " + line;
            throw new IllegalArgumentException(string.toString());
        }
        $this$parseTargets.next();
        Set targets = KlibAbiDumpFileMergerKt.access$parseBcvTargetsLine(line);
        if (!(configurableTargetName == null || targets.size() == 1)) {
            boolean bl = false;
            String string = "Can't use configurableTargetName (" + configurableTargetName + ") for a multi-target dump: " + targets;
            throw new IllegalArgumentException(string.toString());
        }
        if (configurableTargetName != null) {
            return SetsKt.setOf((Object)new KlibTarget(((KlibTarget)CollectionsKt.first((Iterable)targets)).getTargetName(), configurableTargetName));
        }
        return targets;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Set<KlibTarget>> parseAliases(PeekingLineIterator $this$parseAliases) {
        Map aliases = new LinkedHashMap();
        while (true) {
            String name;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String trimmedLine;
            String string = $this$parseAliases.peek();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"// Alias: ", (boolean)false, (int)2, null) : false;
            if (!bl) break;
            String line = $this$parseAliases.next();
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(10), (String)"substring(...)");
            int separatorIdx = StringsKt.indexOf$default((CharSequence)trimmedLine, (String)" => [", (int)0, (boolean)false, (int)6, null);
            if (separatorIdx == -1 || !StringsKt.endsWith$default((CharSequence)trimmedLine, (char)']', (boolean)false, (int)2, null)) {
                throw new IllegalStateException("Invalid alias line: " + line);
            }
            Intrinsics.checkNotNullExpressionValue((Object)trimmedLine.substring(0, separatorIdx), (String)"substring(...)");
            String string2 = trimmedLine.substring(separatorIdx + 5, trimmedLine.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(KlibTarget.Companion.parse(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
            }
            Set targets = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            aliases.put(name, targets);
        }
        return aliases;
    }

    private final KlibAbiDumpHeader parseFileHeader(PeekingLineIterator $this$parseFileHeader, boolean isMergedFile, String configurableTargetName) {
        String next;
        List header = new ArrayList();
        String targets = null;
        String platform = null;
        while ($this$parseFileHeader.hasNext()) {
            Intrinsics.checkNotNull((Object)$this$parseFileHeader.peek());
            if (!StringsKt.isBlank((CharSequence)next) && !StringsKt.startsWith$default((String)next, (String)"//", (boolean)false, (int)2, null)) {
                throw new IllegalStateException("Library header has invalid format at line \"" + next + '\"');
            }
            header.add(next);
            $this$parseFileHeader.next();
            if (!StringsKt.startsWith$default((String)next, (String)"// Library unique name:", (boolean)false, (int)2, null)) continue;
        }
        while ($this$parseFileHeader.hasNext()) {
            String[] stringArray;
            Intrinsics.checkNotNull((Object)$this$parseFileHeader.peek());
            if (!StringsKt.startsWith$default((String)next, (String)"//", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)next, (String)"// Targets: [", (boolean)false, (int)2, null)) break;
            $this$parseFileHeader.next();
            if (!(!isMergedFile)) {
                boolean $i$a$-check-KlibAbiDumpMerger$parseFileHeader$32 = false;
                String $i$a$-check-KlibAbiDumpMerger$parseFileHeader$32 = "Unexpected header line: " + next;
                throw new IllegalStateException($i$a$-check-KlibAbiDumpMerger$parseFileHeader$32.toString());
            }
            if (StringsKt.startsWith$default((String)next, (String)"// Platform: ", (boolean)false, (int)2, null)) {
                stringArray = new String[]{": "};
                platform = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)next, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
                continue;
            }
            if (!StringsKt.startsWith$default((String)next, (String)"// Native targets: ", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)next, (String)"// WASM targets: ", (boolean)false, (int)2, null)) continue;
            if (!(targets == null)) {
                boolean bl = false;
                String string = "Targets list was already parsed";
                throw new IllegalStateException(string.toString());
            }
            stringArray = new String[]{": "};
            targets = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)next, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
        }
        if (isMergedFile) {
            return new KlibAbiDumpHeader((List<String>)header, SetsKt.emptySet());
        }
        return new KlibAbiDumpHeader((List<String>)header, this.extractTargets(platform, targets, configurableTargetName));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KlibTarget> extractTargets(String platformString, String targetsString, String configurableTargetName) {
        void $this$mapTo$iv$iv;
        if (!(platformString != null)) {
            boolean $i$a$-check-KlibAbiDumpMerger$extractTargets$42 = false;
            String $i$a$-check-KlibAbiDumpMerger$extractTargets$42 = "The dump does not contain platform name. Please make sure that the manifest was included in the dump";
            throw new IllegalStateException($i$a$-check-KlibAbiDumpMerger$extractTargets$42.toString());
        }
        if (Intrinsics.areEqual((Object)platformString, (Object)"WASM") && targetsString == null) {
            if (!(configurableTargetName != null)) {
                boolean $i$a$-check-KlibAbiDumpMerger$extractTargets$52 = false;
                String $i$a$-check-KlibAbiDumpMerger$extractTargets$52 = "targetName has to be specified for a Wasm target";
                throw new IllegalStateException($i$a$-check-KlibAbiDumpMerger$extractTargets$52.toString());
            }
            return SetsKt.setOf((Object)KlibTargetKt.KlibTarget(configurableTargetName));
        }
        if (!Intrinsics.areEqual((Object)platformString, (Object)"NATIVE") && !Intrinsics.areEqual((Object)platformString, (Object)"WASM")) {
            String $i$a$-check-KlibAbiDumpMerger$extractTargets$52 = platformString;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string = $i$a$-check-KlibAbiDumpMerger$extractTargets$52.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String platformStringLc = string;
            return configurableTargetName == null ? SetsKt.setOf((Object)KlibTargetKt.KlibTarget(platformStringLc)) : SetsKt.setOf((Object)new KlibTarget(platformStringLc, configurableTargetName));
        }
        if (!(targetsString != null)) {
            boolean $i$a$-check-KlibAbiDumpMerger$extractTargets$62 = false;
            String $i$a$-check-KlibAbiDumpMerger$extractTargets$62 = "Dump for a native platform missing targets list.";
            throw new IllegalStateException($i$a$-check-KlibAbiDumpMerger$extractTargets$62.toString());
        }
        String[] $i$a$-check-KlibAbiDumpMerger$extractTargets$62 = new String[]{", "};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)targetsString, (String[])$i$a$-check-KlibAbiDumpMerger$extractTargets$62, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = TargetHierarchyKt.getKonanTargetNameMapping().get(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            if (string2 == null) {
                throw new IllegalStateException("Unknown native target: " + (String)it);
            }
            collection.add(string2);
        }
        List targetsList = (List)destination$iv$iv;
        if (!(targetsList.size() == 1 || configurableTargetName == null)) {
            boolean bl = false;
            String string = "Can't use configurableTargetName (" + configurableTargetName + ") for a multi-target dump: " + targetsList;
            throw new IllegalArgumentException(string.toString());
        }
        if (targetsList.size() == 1 && configurableTargetName != null) {
            return SetsKt.setOf((Object)new KlibTarget((String)CollectionsKt.first((List)targetsList), configurableTargetName));
        }
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)targetsList), (Function1)extractTargets.5.INSTANCE));
    }

    private final boolean determineFileType(PeekingLineIterator $this$determineFileType) {
        String string;
        String string2 = $this$determineFileType.peek();
        if (string2 == null) {
            throw new IllegalStateException("File is empty");
        }
        String headerLine = string2;
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trimEnd((CharSequence)headerLine)).toString(), (Object)"// Klib ABI Dump")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trimEnd((CharSequence)headerLine)).toString(), (Object)"// Rendering settings:")) {
            return false;
        }
        if (headerLine.length() > 32) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = headerLine.substring(0, 32);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string = stringBuilder.append(string3).append("...").toString();
        } else {
            string = headerLine;
        }
        String headerStart = string;
        throw new IllegalStateException("Expected a file staring with \"// Rendering settings:\" or \"// Klib ABI Dump\", but the file stats with \"" + headerStart + '\"');
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationContainer parseDeclaration(PeekingLineIterator $this$parseDeclaration, int depth, DeclarationContainer parent, List<Set<KlibTarget>> parentTargetsStack, Map<String, ? extends Set<KlibTarget>> aliases) {
        DeclarationContainer declarationContainer;
        String string = $this$parseDeclaration.peek();
        Intrinsics.checkNotNull((Object)string);
        String line = string;
        if (StringsKt.startsWith$default((String)line, (String)(StringsKt.repeat((CharSequence)" ", (int)(depth * 4)) + "// Targets: ["), (boolean)false, (int)2, null)) {
            void $this$flatMapTo$iv$iv;
            $this$parseDeclaration.next();
            Set targets = KlibAbiDumpFileMergerKt.access$parseBcvTargetsLine(line);
            Iterable $this$flatMap$iv = targets;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KlibTarget it = (KlibTarget)element$iv$iv;
                boolean bl = false;
                Set<KlibTarget> set = aliases.get(it.getConfigurableName());
                Iterable list$iv$iv = set != null ? (Collection)set : (Collection)CollectionsKt.listOf((Object)it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Set expandedTargets = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            parentTargetsStack.add(expandedTargets);
            declarationContainer = parent.createOrUpdateChildren($this$parseDeclaration.next(), expandedTargets);
        } else {
            parentTargetsStack.add((Set<KlibTarget>)CollectionsKt.last(parentTargetsStack));
            declarationContainer = parent.createOrUpdateChildren($this$parseDeclaration.next(), (Set)CollectionsKt.last(parentTargetsStack));
        }
        return declarationContainer;
    }

    public final void dump(@NotNull Appendable appendable) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        if (this.targets.isEmpty()) {
            if (!this.topLevelDeclaration.getChildren().isEmpty()) {
                boolean $i$a$-check-KlibAbiDumpMerger$dump$22 = false;
                String $i$a$-check-KlibAbiDumpMerger$dump$22 = "Dump containing some declaration should have at least a single target";
                throw new IllegalStateException($i$a$-check-KlibAbiDumpMerger$dump$22.toString());
            }
            return;
        }
        KlibsTargetsFormatter formatter = this.createFormatter();
        appendable.append("// Klib ABI Dump").append('\n');
        appendable.append(formatter.formatHeader(this.targets)).append('\n');
        Iterable $this$forEach$iv = this.headerContent;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            appendable.append(it).append('\n');
        }
        this.topLevelDeclaration.dump(appendable, this._targets, formatter);
    }

    private final KlibsTargetsFormatter createFormatter() {
        for (KlibTarget target : this.targets) {
            TargetHierarchy.NodeClosure node = TargetHierarchy.INSTANCE.getHierarchyIndex$binary_compatibility_validator().get(target.getTargetName());
            if (node == null || node.getAllLeafs().size() != 1 || Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)node.getAllLeafs()), (Object)node.getNode().getName())) continue;
            throw new IllegalStateException("Can't use target aliases as one of the this dump's targets has the same name as a group in the default targets hierarchy: " + target);
        }
        return new KlibsTargetsFormatter(this);
    }

    public final void remove(@NotNull KlibTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this._targets.remove(target)) {
            return;
        }
        this.topLevelDeclaration.remove(target);
    }

    public final void retainTargetSpecificAbi(@NotNull KlibTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this._targets.contains(target)) {
            this._targets.clear();
            this.topLevelDeclaration.getChildren().clear();
            this.topLevelDeclaration.getTargets().clear();
            return;
        }
        this.topLevelDeclaration.retainSpecific(target, this._targets);
        this._targets.retainAll(SetsKt.setOf((Object)target));
    }

    public final void retainCommonAbi() {
        this.topLevelDeclaration.retainCommon(this._targets);
        if (this.topLevelDeclaration.getChildren().isEmpty()) {
            this._targets.clear();
        }
    }

    public final void mergeTargetSpecific(@NotNull KlibAbiDumpMerger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other._targets.size() == 1)) {
            boolean $i$a$-require-KlibAbiDumpMerger$mergeTargetSpecific$32 = false;
            String $i$a$-require-KlibAbiDumpMerger$mergeTargetSpecific$32 = "The dump to merge in should have a single target, but its targets are: " + other.targets;
            throw new IllegalArgumentException($i$a$-require-KlibAbiDumpMerger$mergeTargetSpecific$32.toString());
        }
        if (!(!this._targets.contains(CollectionsKt.first((Iterable)other._targets)))) {
            boolean bl = false;
            String string = "Targets of this dump and the dump to merge into it should not intersect. Common target: " + CollectionsKt.first((Iterable)other.targets) + '}';
            throw new IllegalArgumentException(string.toString());
        }
        this._targets.addAll((Collection<KlibTarget>)other._targets);
        this.topLevelDeclaration.mergeTargetSpecific(other.topLevelDeclaration);
    }

    public final void merge(@NotNull KlibAbiDumpMerger other) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.targets.isEmpty()) {
            return;
        }
        Set it = set = CollectionsKt.intersect((Iterable)this.targets, (Iterable)other.targets);
        boolean bl = false;
        if (!it.isEmpty()) {
            boolean bl2 = false;
            String string = "Targets of this dump and the dump to merge into it should not intersect. Common targets: " + it;
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual(this.headerContent, other.headerContent)) {
            if (this.headerContent.isEmpty() && this.targets.isEmpty()) {
                this.headerContent.addAll((Collection<String>)other.headerContent);
            } else {
                throw new IllegalArgumentException("Dumps headers does not match");
            }
        }
        this._targets.addAll((Collection<KlibTarget>)other._targets);
        this.topLevelDeclaration.merge(other.topLevelDeclaration);
    }

    public final void overrideTargets(@NotNull Set<KlibTarget> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this._targets.clear();
        this._targets.addAll((Collection<KlibTarget>)targets);
        this.topLevelDeclaration.overrideTargets(targets);
    }

    public final void visit$binary_compatibility_validator(@NotNull Function1<? super DeclarationContainer, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = this.topLevelDeclaration.getChildren().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }
}

