/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.validation;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\r\u0010\u0011\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u0013R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/validation/KotlinApiCompareTask;", "Lorg/gradle/api/DefaultTask;", "()V", "generatedApiFile", "Lorg/gradle/api/file/RegularFileProperty;", "getGeneratedApiFile", "()Lorg/gradle/api/file/RegularFileProperty;", "projectApiFile", "getProjectApiFile", "projectName", "", "kotlin.jvm.PlatformType", "rootDir", "Ljava/io/File;", "compareFiles", "checkFile", "builtFile", "verify", "", "verify$binary_compatibility_validator", "binary-compatibility-validator"})
public class KotlinApiCompareTask
extends DefaultTask {
    @NotNull
    private final RegularFileProperty projectApiFile;
    @NotNull
    private final RegularFileProperty generatedApiFile;
    private final String projectName;
    private final File rootDir;

    public KotlinApiCompareTask() {
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.projectApiFile = regularFileProperty;
        RegularFileProperty regularFileProperty2 = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"project.objects.fileProperty()");
        this.generatedApiFile = regularFileProperty2;
        this.projectName = this.getProject().getName();
        this.rootDir = this.getProject().getRootDir();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final RegularFileProperty getProjectApiFile() {
        return this.projectApiFile;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final RegularFileProperty getGeneratedApiFile() {
        return this.generatedApiFile;
    }

    @TaskAction
    public final void verify$binary_compatibility_validator() {
        File projectApiFile = ((RegularFile)this.projectApiFile.get()).getAsFile();
        File generatedApiFile = ((RegularFile)this.generatedApiFile.get()).getAsFile();
        if (!projectApiFile.exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Expected file with API declarations '");
            Intrinsics.checkNotNullExpressionValue((Object)projectApiFile, (String)"projectApiFile");
            File file = this.rootDir;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
            String string = stringBuilder.append(FilesKt.relativeTo((File)projectApiFile, (File)file)).append("' does not exist.\nPlease ensure that ':apiDump' was executed in order to get an API dump to compare the build against").toString();
            throw new IllegalStateException(string.toString());
        }
        if (!generatedApiFile.exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Expected file with generated API declarations '");
            Intrinsics.checkNotNullExpressionValue((Object)generatedApiFile, (String)"generatedApiFile");
            File file = this.rootDir;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
            String string = stringBuilder.append(FilesKt.relativeTo((File)generatedApiFile, (File)file)).append("' does not exist.").toString();
            throw new IllegalStateException(string.toString());
        }
        Set diffSet = new LinkedHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)projectApiFile, (String)"projectApiFile");
        Intrinsics.checkNotNullExpressionValue((Object)generatedApiFile, (String)"generatedApiFile");
        String diff = this.compareFiles(projectApiFile, generatedApiFile);
        if (diff != null) {
            diffSet.add(diff);
        }
        if (!((Collection)diffSet).isEmpty()) {
            String diffText = CollectionsKt.joinToString$default((Iterable)diffSet, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
            String subject = this.projectName;
            throw new IllegalStateException(("API check failed for project " + subject + ".\n" + diffText + "\n\nYou can run :" + subject + ":apiDump task to overwrite API declarations").toString());
        }
    }

    private final String compareFiles(File checkFile, File builtFile) {
        List builtLines;
        String checkText = FilesKt.readText$default((File)checkFile, null, (int)1, null);
        String builtText = FilesKt.readText$default((File)builtFile, null, (int)1, null);
        List checkLines = StringsKt.lines((CharSequence)checkText);
        if (Intrinsics.areEqual((Object)checkLines, (Object)(builtLines = StringsKt.lines((CharSequence)builtText)))) {
            return null;
        }
        Patch patch = DiffUtils.diff((List)checkLines, (List)builtLines);
        List diff = UnifiedDiffUtils.generateUnifiedDiff((String)checkFile.toString(), (String)builtFile.toString(), (List)checkLines, (Patch)patch, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)diff, (String)"diff");
        return CollectionsKt.joinToString$default((Iterable)diff, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

