/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.validation.api.klib;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.validation.api.klib.DeclarationType;
import kotlinx.validation.api.klib.DeclarationsComparator;
import kotlinx.validation.api.klib.KlibAbiDumpFileMergerKt;
import kotlinx.validation.api.klib.KlibTarget;
import kotlinx.validation.api.klib.KlibsTargetsFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u001c\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000J(\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u00060#j\u0002`$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u0000J\u000e\u0010,\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u0000J\u001d\u0010-\u001a\u00020\u001c2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001c0/H\u0082\bJ\u0014\u00100\u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fJ\u000e\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u0013J\u0014\u00103\u001a\u00020\u001c2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fJ\u001c\u00105\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fJ!\u00106\u001a\u00020\u001c2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001c0/H\u0000\u00a2\u0006\u0002\b8R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00069"}, d2={"Lkotlinx/validation/api/klib/DeclarationContainer;", "", "text", "", "parent", "(Ljava/lang/String;Lkotlinx/validation/api/klib/DeclarationContainer;)V", "children", "", "getChildren", "()Ljava/util/Map;", "delimiter", "getDelimiter", "()Ljava/lang/String;", "setDelimiter", "(Ljava/lang/String;)V", "getParent", "()Lkotlinx/validation/api/klib/DeclarationContainer;", "targets", "", "Lkotlinx/validation/api/klib/KlibTarget;", "getTargets", "()Ljava/util/Set;", "getText", "type", "Lkotlinx/validation/api/klib/DeclarationType;", "getType", "()Lkotlinx/validation/api/klib/DeclarationType;", "addTargetRecursively", "", "first", "createOrUpdateChildren", "", "deepCopy", "dump", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "allTargets", "formatter", "Lkotlinx/validation/api/klib/KlibsTargetsFormatter;", "isTypeDeclaration", "", "merge", "other", "mergeTargetSpecific", "mutateChildrenAndRemoveTargetless", "blockAction", "Lkotlin/Function1;", "overrideTargets", "remove", "target", "retainCommon", "commonTargets", "retainSpecific", "visit", "action", "visit$binary_compatibility_validator", "binary-compatibility-validator"})
@SourceDebugExtension(value={"SMAP\nKlibAbiDumpFileMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibAbiDumpFileMerger.kt\nkotlinx/validation/api/klib/DeclarationContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,907:1\n640#1,9:910\n640#1,9:919\n640#1,9:928\n1855#2,2:908\n215#3,2:937\n215#3,2:939\n215#3,2:941\n215#3,2:943\n215#3,2:945\n215#3,2:947\n*E\n*S KotlinDebug\n*F\n+ 1 KlibAbiDumpFileMerger.kt\nkotlinx/validation/api/klib/DeclarationContainer\n*L\n554#1,9:910\n564#1,9:919\n583#1,9:928\n519#1,2:908\n588#1,2:937\n597#1,2:939\n607#1,2:941\n630#1,2:943\n636#1,2:945\n651#1,2:947\n*E\n"})
public final class DeclarationContainer {
    @NotNull
    private final String text;
    @Nullable
    private final DeclarationContainer parent;
    @Nullable
    private final DeclarationType type;
    @NotNull
    private final Set<KlibTarget> targets;
    @NotNull
    private final Map<String, DeclarationContainer> children;
    @Nullable
    private String delimiter;

    public DeclarationContainer(@NotNull String text, @Nullable DeclarationContainer parent) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.parent = parent;
        this.type = !StringsKt.isBlank((CharSequence)this.text) ? DeclarationType.Companion.parseFromDeclaration(this.text) : null;
        this.targets = new LinkedHashSet();
        this.children = new LinkedHashMap();
    }

    public /* synthetic */ DeclarationContainer(String string, DeclarationContainer declarationContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            declarationContainer = null;
        }
        this(string, declarationContainer);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final DeclarationContainer getParent() {
        return this.parent;
    }

    @Nullable
    public final DeclarationType getType() {
        return this.type;
    }

    @NotNull
    public final Set<KlibTarget> getTargets() {
        return this.targets;
    }

    @NotNull
    public final Map<String, DeclarationContainer> getChildren() {
        return this.children;
    }

    @Nullable
    public final String getDelimiter() {
        return this.delimiter;
    }

    public final void setDelimiter(@Nullable String string) {
        this.delimiter = string;
    }

    @NotNull
    public final DeclarationContainer createOrUpdateChildren(@NotNull String text, @NotNull Set<KlibTarget> targets) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Function1 function1 = (Function1)new Function1<String, DeclarationContainer>(this){
            final /* synthetic */ DeclarationContainer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final DeclarationContainer invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DeclarationContainer newChild = new DeclarationContainer(it, this.this$0);
                return newChild;
            }
        };
        DeclarationContainer declarationContainer = this.children.computeIfAbsent(text, new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)declarationContainer, (String)"fun createOrUpdateChildr\u2026       return child\n    }");
        DeclarationContainer child2 = declarationContainer;
        child2.targets.addAll((Collection<KlibTarget>)targets);
        return child2;
    }

    public final void dump(@NotNull Appendable appendable, @NotNull Set<KlibTarget> allTargets, @NotNull KlibsTargetsFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter(allTargets, (String)"allTargets");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        if (!Intrinsics.areEqual(this.targets, allTargets)) {
            appendable.append(StringsKt.repeat((CharSequence)" ", (int)(KlibAbiDumpFileMergerKt.access$depth(this.text) * 4))).append(formatter.formatDeclarationTargets(this.targets)).append('\n');
        }
        appendable.append(this.text);
        if (((CharSequence)this.text).length() > 0) {
            appendable.append('\n');
        }
        DeclarationContainer previousDeclaration = null;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)this.children.values(), (Comparator)DeclarationsComparator.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationContainer currentDeclaration = (DeclarationContainer)element$iv;
            boolean bl = false;
            if (previousDeclaration != null) {
                DeclarationContainer pd = previousDeclaration;
                if (pd.type != currentDeclaration.type || !Intrinsics.areEqual(currentDeclaration.targets, this.targets) || currentDeclaration.isTypeDeclaration()) {
                    appendable.append('\n');
                }
            }
            currentDeclaration.dump(appendable, this.targets, formatter);
            previousDeclaration = currentDeclaration;
        }
        if (this.delimiter != null) {
            appendable.append(this.delimiter).append('\n');
        }
    }

    private final boolean isTypeDeclaration() {
        boolean bl;
        DeclarationType declarationType = this.type;
        switch (declarationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[declarationType.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final void remove(@NotNull KlibTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.parent != null && !this.targets.contains(target)) {
            return;
        }
        this.targets.remove(target);
        DeclarationContainer this_$iv = this;
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator$iv = this_$iv.children.entrySet().iterator();
        while (iterator$iv.hasNext()) {
            DeclarationContainer child$iv;
            DeclarationContainer it = child$iv = iterator$iv.next().getValue();
            boolean bl = false;
            it.remove(target);
            if (!child$iv.targets.isEmpty()) continue;
            iterator$iv.remove();
        }
    }

    public final void retainSpecific(@NotNull KlibTarget target, @NotNull Set<KlibTarget> allTargets) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(allTargets, (String)"allTargets");
        if (this.parent != null && !this.targets.contains(target)) {
            this.children.clear();
            this.targets.clear();
            return;
        }
        DeclarationContainer this_$iv = this;
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator$iv = this_$iv.children.entrySet().iterator();
        while (iterator$iv.hasNext()) {
            DeclarationContainer child$iv;
            DeclarationContainer it = child$iv = iterator$iv.next().getValue();
            boolean bl = false;
            it.retainSpecific(target, allTargets);
            if (!child$iv.targets.isEmpty()) continue;
            iterator$iv.remove();
        }
        if (Intrinsics.areEqual(this.targets, allTargets)) {
            if (this.children.isEmpty()) {
                this.targets.clear();
            } else {
                this.targets.retainAll(SetsKt.setOf((Object)target));
            }
        } else {
            this.targets.retainAll(SetsKt.setOf((Object)target));
        }
    }

    public final void retainCommon(@NotNull Set<KlibTarget> commonTargets) {
        Intrinsics.checkNotNullParameter(commonTargets, (String)"commonTargets");
        if (this.parent != null && !Intrinsics.areEqual(this.targets, commonTargets)) {
            this.children.clear();
            this.targets.clear();
            return;
        }
        DeclarationContainer this_$iv = this;
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator$iv = this_$iv.children.entrySet().iterator();
        while (iterator$iv.hasNext()) {
            DeclarationContainer child$iv;
            DeclarationContainer it = child$iv = iterator$iv.next().getValue();
            boolean bl = false;
            it.retainCommon(commonTargets);
            if (!child$iv.targets.isEmpty()) continue;
            iterator$iv.remove();
        }
    }

    public final void mergeTargetSpecific(@NotNull DeclarationContainer other) {
        Map.Entry<String, DeclarationContainer> element$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.targets.addAll((Collection<KlibTarget>)other.targets);
        Map<String, DeclarationContainer> $this$forEach$iv = other.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> otherChild = element$iv = iterator.next();
            boolean bl = false;
            DeclarationContainer child2 = this.children.get(otherChild.getKey());
            if (child2 == null) {
                this.children.put(otherChild.getKey(), otherChild.getValue().deepCopy(this));
                continue;
            }
            child2.mergeTargetSpecific(otherChild.getValue());
        }
        $this$forEach$iv = this.children;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            if (it.getValue().targets.contains(CollectionsKt.first((Iterable)other.targets))) continue;
            it.getValue().addTargetRecursively((KlibTarget)CollectionsKt.first((Iterable)other.targets));
        }
    }

    public final void merge(@NotNull DeclarationContainer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.targets.addAll((Collection<KlibTarget>)other.targets);
        DeclarationContainer parent = this;
        Map<String, DeclarationContainer> $this$forEach$iv = other.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> entry = element$iv = iterator.next();
            boolean bl = false;
            String line = entry.getKey();
            DeclarationContainer decl = entry.getValue();
            Function2 function2 = (Function2)new Function2<String, DeclarationContainer, DeclarationContainer>(decl, parent){
                final /* synthetic */ DeclarationContainer $decl;
                final /* synthetic */ DeclarationContainer $parent;
                {
                    this.$decl = $decl;
                    this.$parent = $parent;
                    super(2);
                }

                @Nullable
                public final DeclarationContainer invoke(@NotNull String string, @Nullable DeclarationContainer thisDecl) {
                    DeclarationContainer declarationContainer;
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    if (thisDecl == null) {
                        declarationContainer = this.$decl.deepCopy(this.$parent);
                    } else {
                        DeclarationContainer declarationContainer2 = thisDecl;
                        DeclarationContainer declarationContainer3 = this.$decl;
                        DeclarationContainer $this$invoke_u24lambda_u240 = declarationContainer2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.merge(declarationContainer3);
                        declarationContainer = declarationContainer2;
                    }
                    return declarationContainer;
                }
            };
            this.children.compute(line, new BiFunction(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0, Object p1) {
                    return this.function.invoke(p0, p1);
                }
            });
        }
    }

    @NotNull
    public final DeclarationContainer deepCopy(@NotNull DeclarationContainer parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        DeclarationContainer copy = new DeclarationContainer(this.text, parent);
        copy.delimiter = this.delimiter;
        copy.targets.addAll((Collection<KlibTarget>)this.targets);
        Function2 function2 = (Function2)new Function2<String, DeclarationContainer, Unit>(copy){
            final /* synthetic */ DeclarationContainer $copy;
            {
                this.$copy = $copy;
                super(2);
            }

            public final void invoke(@NotNull String key, @NotNull DeclarationContainer value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$copy.getChildren().put(key, value.deepCopy(this.$copy));
            }
        };
        this.children.forEach(new BiConsumer(function2){
            private final /* synthetic */ Function2 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0, Object p1) {
                this.function.invoke(p0, p1);
            }
        });
        return copy;
    }

    private final void addTargetRecursively(KlibTarget first) {
        this.targets.add(first);
        Map<String, DeclarationContainer> $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().addTargetRecursively(first);
        }
    }

    public final void overrideTargets(@NotNull Set<KlibTarget> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this.targets.clear();
        this.targets.addAll((Collection<KlibTarget>)targets);
        Map<String, DeclarationContainer> $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().overrideTargets(targets);
        }
    }

    private final void mutateChildrenAndRemoveTargetless(Function1<? super DeclarationContainer, Unit> blockAction) {
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = this.children.entrySet().iterator();
        while (iterator.hasNext()) {
            DeclarationContainer child2 = iterator.next().getValue();
            blockAction.invoke((Object)child2);
            if (!child2.targets.isEmpty()) continue;
            iterator.remove();
        }
    }

    public final void visit$binary_compatibility_validator(@NotNull Function1<? super DeclarationContainer, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map<String, DeclarationContainer> $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            action.invoke((Object)it.getValue());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeclarationType.values().length];
            try {
                nArray[DeclarationType.Object.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.Class.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.Interface.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.AnnotationClass.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.EnumClass.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

