/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.transformer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.transformer.AbortKt;
import kotlinx.atomicfu.transformer.AbortTransform;
import kotlinx.atomicfu.transformer.AsmUtilKt;
import kotlinx.atomicfu.transformer.AtomicFUTransformer;
import kotlinx.atomicfu.transformer.AtomicFUTransformerBase;
import kotlinx.atomicfu.transformer.AtomicFUTransformerKt;
import kotlinx.atomicfu.transformer.FieldId;
import kotlinx.atomicfu.transformer.FieldInfo;
import kotlinx.atomicfu.transformer.FlowAnalyzer;
import kotlinx.atomicfu.transformer.JvmVariant;
import kotlinx.atomicfu.transformer.MetadataTransformer;
import kotlinx.atomicfu.transformer.MethodId;
import kotlinx.atomicfu.transformer.TransformerException;
import kotlinx.atomicfu.transformer.TypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\b>?@ABCDEB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020!H\u0002J\u0016\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060&2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\"\u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J\"\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020*H\u0002J\u0014\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u00101\u001a\u00020\u0004H\u0002J \u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020!H\u0002J\b\u00106\u001a\u00020\u001eH\u0016J \u00107\u001a\u0002082\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u00109\u001a\u0002082\u0006\u0010\"\u001a\u00020!H\u0002J\u000e\u0010:\u001a\u0004\u0018\u00010\u0012*\u00020;H\u0002J\u000e\u0010<\u001a\u0004\u0018\u00010\u0012*\u00020;H\u0002J\f\u0010=\u001a\u00020!*\u00020\u0012H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase;", "classpath", "", "", "inputDir", "Ljava/io/File;", "outputDir", "jvmVariant", "Lkotlinx/atomicfu/transformer/JvmVariant;", "(Ljava/util/List;Ljava/io/File;Ljava/io/File;Lkotlinx/atomicfu/transformer/JvmVariant;)V", "accessors", "", "Lkotlinx/atomicfu/transformer/MethodId;", "Lkotlinx/atomicfu/transformer/FieldInfo;", "classPathLoader", "Ljava/net/URLClassLoader;", "delegatedPropertiesAccessors", "Lkotlinx/atomicfu/transformer/FieldId;", "fieldDelegates", "fields", "getJvmVariant", "()Lkotlinx/atomicfu/transformer/JvmVariant;", "setJvmVariant", "(Lkotlinx/atomicfu/transformer/JvmVariant;)V", "removeMethods", "", "traceAccessors", "traceFields", "analyzeFileForFields", "", "file", "analyzeFileForRefs", "", "vh", "analyzeFilesForFields", "files", "analyzeFilesForRefs", "", "descToName", "desc", "getPotentialAccessorType", "Lorg/objectweb/asm/Type;", "access", "", "className", "methodType", "loadClass", "Ljava/lang/Class;", "type", "registerField", "field", "fieldType", "isStatic", "transform", "transformFile", "", "bytes", "checkGetFieldOrGetStatic", "Lorg/objectweb/asm/tree/FieldInsnNode;", "checkPutFieldOrPutStatic", "isFieldDelegate", "AccessorCollectorMV", "CV", "CW", "DelegateFieldsCollectorMV", "DelegatedFieldAccessorCollectorMV", "FieldsCollectorCV", "TransformerCV", "TransformerMV", "atomicfu-transformer"})
public final class AtomicFUTransformer
extends AtomicFUTransformerBase {
    private final URLClassLoader classPathLoader;
    private final Map<FieldId, FieldInfo> fields;
    private final Map<MethodId, FieldInfo> accessors;
    private final Set<FieldId> traceFields;
    private final Set<MethodId> traceAccessors;
    private final Map<FieldId, FieldInfo> fieldDelegates;
    private final Map<FieldId, MethodId> delegatedPropertiesAccessors;
    private final Set<MethodId> removeMethods;
    @NotNull
    private JvmVariant jvmVariant;

    @Override
    public void transform() {
        AtomicFUTransformerBase.info$default(this, "Analyzing in " + this.getInputDir(), null, 2, null);
        List files2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)this.getInputDir(), null, (int)1, null)), (Function1)transform.files.1.INSTANCE));
        boolean needTransform = this.analyzeFilesForFields(files2);
        if (needTransform || Intrinsics.areEqual((Object)this.getOutputDir(), (Object)this.getInputDir())) {
            boolean vh = this.jvmVariant == JvmVariant.VH;
            Set<File> needsTransform = this.analyzeFilesForRefs(files2, vh);
            AtomicFUTransformerBase.info$default(this, "Transforming to " + this.getOutputDir(), null, 2, null);
            Iterable $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                byte[] bytes = FilesKt.readBytes((File)file);
                byte[] outBytes = this.isClassFile(file) && needsTransform.contains(file) ? this.transformFile(file, bytes, vh) : bytes;
                File outFile = this.toOutputFile(file);
                this.mkdirsAndWrite(outFile, outBytes);
                if (this.jvmVariant != JvmVariant.BOTH || outBytes == bytes) continue;
                byte[] vhBytes = this.transformFile(file, bytes, true);
                File file2 = this.div(this.div(this.div(this.getOutputDir(), "META-INF"), "versions"), "9");
                String string = FilesKt.relativeTo((File)file, (File)this.getInputDir()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.relativeTo(inputDir).toString()");
                File vhFile = this.div(file2, string);
                this.mkdirsAndWrite(vhFile, vhBytes);
            }
        } else {
            AtomicFUTransformerBase.info$default(this, "Nothing to transform -- all classes are up to date", null, 2, null);
        }
    }

    private final boolean analyzeFilesForFields(List<? extends File> files2) {
        boolean needTransform = false;
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long outTime;
            File file = (File)element$iv;
            boolean bl = false;
            long inpTime = file.lastModified();
            if (inpTime > (outTime = this.toOutputFile(file).lastModified())) {
                needTransform = true;
            }
            if (!this.isClassFile(file)) continue;
            this.analyzeFileForFields(file);
        }
        if (this.getLastError() != null) {
            throw (Throwable)new TransformerException("Encountered errors while analyzing fields", this.getLastError());
        }
        return needTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void analyzeFileForFields(File file) {
        Object object = file;
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl = false;
            new ClassReader((InputStream)it).accept((ClassVisitor)new FieldsCollectorCV(), 4);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final Set<File> analyzeFilesForRefs(List<? extends File> files2, boolean vh) {
        HashSet result = new HashSet();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            if (!this.isClassFile(file) || !this.analyzeFileForRefs(file, vh)) continue;
            Collection collection = result;
            collection.add(file);
        }
        if (this.getLastError() != null) {
            throw (Throwable)new TransformerException("Encountered errors while analyzing references", this.getLastError());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean analyzeFileForRefs(File file, boolean vh) {
        boolean bl;
        Object object = file;
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            block7: {
                FileInputStream input = (FileInputStream)object;
                boolean bl2 = false;
                this.setTransformed(false);
                TransformerCV cv = new TransformerCV(null, vh, true);
                try {
                    new ClassReader((InputStream)input).accept((ClassVisitor)cv, 4);
                }
                catch (Exception e) {
                    this.error("Failed to analyze: " + e, cv.getSourceInfo());
                    e.printStackTrace(System.out);
                    if (this.getLastError() != null) break block7;
                    this.setLastError(e);
                }
            }
            bl = this.getTransformed();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return bl;
    }

    private final byte[] transformFile(File file, byte[] bytes, boolean vh) {
        CW cw;
        block4: {
            this.setTransformed(false);
            cw = new CW();
            TransformerCV cv = new TransformerCV((ClassVisitor)cw, vh, false);
            try {
                new ClassReader((InputStream)new ByteArrayInputStream(bytes)).accept((ClassVisitor)cv, 4);
            }
            catch (Throwable e) {
                this.error("Failed to transform: " + e, cv.getSourceInfo());
                e.printStackTrace(System.out);
                if (this.getLastError() != null) break block4;
                this.setLastError(e);
            }
        }
        if (!this.getTransformed()) {
            AtomicFUTransformerBase.error$default(this, "Invoked transformFile on a file that does not need transformation: " + file, null, 2, null);
        }
        if (this.getLastError() != null) {
            throw (Throwable)new TransformerException("Encountered errors while transforming: " + file, this.getLastError());
        }
        AtomicFUTransformerBase.info$default(this, "Transformed " + file, null, 2, null);
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cw.toByteArray()");
        return byArray;
    }

    private final FieldInfo registerField(FieldId field, Type fieldType, boolean isStatic) {
        FieldInfo result;
        FieldInfo fieldInfo;
        Map<FieldId, FieldInfo> $this$getOrPut$iv = this.fields;
        boolean $i$f$getOrPut = false;
        FieldInfo value$iv = $this$getOrPut$iv.get(field);
        if (value$iv == null) {
            boolean bl = false;
            FieldInfo answer$iv = new FieldInfo(field, fieldType, isStatic);
            $this$getOrPut$iv.put(field, answer$iv);
            fieldInfo = answer$iv;
        } else {
            fieldInfo = value$iv;
        }
        if (Intrinsics.areEqual((Object)(result = fieldInfo).getFieldType(), (Object)fieldType) ^ true) {
            Void void_ = AbortKt.abort$default(field + " type mismatch between " + fieldType + " and " + result.getFieldType(), null, 2, null);
            throw new KotlinNothingValueException();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Type getPotentialAccessorType(int access, String className, Type methodType) {
        Type type;
        Type type2;
        Type[] typeArray = AtomicFUTransformerKt.access$getAFU_TYPES$p();
        if (!typeArray.containsKey(type2 = methodType.getReturnType()) && Intrinsics.areEqual((Object)methodType.getReturnType(), (Object)AtomicFUTransformerKt.access$getTRACE_BASE_TYPE$p()) ^ true) {
            return null;
        }
        if ((access & 8) != 0) {
            if ((access & 0x10) != 0) {
                Type[] typeArray2 = methodType.getArgumentTypes();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"methodType.argumentTypes");
                typeArray = typeArray2;
                if (typeArray.length == 0) {
                    type = Type.getObjectType((String)className);
                    return type;
                }
            }
            if (methodType.getArgumentTypes().length != 1) return null;
            Type type3 = methodType.getArgumentTypes()[0];
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"methodType.argumentTypes[0]");
            if (type3.getSort() != 10) return null;
            type = methodType.getArgumentTypes()[0];
            return type;
        }
        if ((access & 0x10) == 0) return null;
        Type[] typeArray3 = methodType.getArgumentTypes();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray3, (String)"methodType.argumentTypes");
        typeArray = typeArray3;
        if (typeArray.length != 0) return null;
        boolean bl = true;
        if (!bl) return null;
        type = Type.getObjectType((String)className);
        return type;
    }

    private final String descToName(String desc) {
        return StringsKt.dropLast((String)StringsKt.drop((String)desc, (int)1), (int)1);
    }

    private final FieldId checkPutFieldOrPutStatic(FieldInsnNode $this$checkPutFieldOrPutStatic) {
        if ($this$checkPutFieldOrPutStatic.getOpcode() != 181 && $this$checkPutFieldOrPutStatic.getOpcode() != 179) {
            return null;
        }
        String string = $this$checkPutFieldOrPutStatic.owner;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner");
        String string2 = $this$checkPutFieldOrPutStatic.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        String string3 = $this$checkPutFieldOrPutStatic.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
        FieldId fieldId = new FieldId(string, string2, string3);
        Map<FieldId, FieldInfo> map = this.fields;
        return map.containsKey(fieldId) ? fieldId : null;
    }

    private final FieldId checkGetFieldOrGetStatic(FieldInsnNode $this$checkGetFieldOrGetStatic) {
        if ($this$checkGetFieldOrGetStatic.getOpcode() != 180 && $this$checkGetFieldOrGetStatic.getOpcode() != 178) {
            return null;
        }
        String string = $this$checkGetFieldOrGetStatic.owner;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner");
        String string2 = $this$checkGetFieldOrGetStatic.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        String string3 = $this$checkGetFieldOrGetStatic.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
        FieldId fieldId = new FieldId(string, string2, string3);
        Map<FieldId, FieldInfo> map = this.fields;
        return map.containsKey(fieldId) ? fieldId : null;
    }

    private final boolean isFieldDelegate(FieldId $this$isFieldDelegate) {
        Map<FieldId, Object> map = this.fieldDelegates;
        return map.containsKey($this$isFieldDelegate) && (map = this.delegatedPropertiesAccessors).containsKey($this$isFieldDelegate);
    }

    private final Class<?> loadClass(String type) {
        Class<?> clazz;
        try {
            Class<?> clazz2 = Class.forName(StringsKt.replace$default((String)type, (char)'/', (char)'.', (boolean)false, (int)4, null), false, this.classPathLoader);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"Class.forName(type.repla\u2026, false, classPathLoader)");
            clazz = clazz2;
        }
        catch (Exception e) {
            throw (Throwable)new TransformerException("Failed to load class for '" + type + '\'', e);
        }
        return clazz;
    }

    @NotNull
    public final JvmVariant getJvmVariant() {
        return this.jvmVariant;
    }

    public final void setJvmVariant(@NotNull JvmVariant jvmVariant) {
        Intrinsics.checkNotNullParameter((Object)((Object)jvmVariant), (String)"<set-?>");
        this.jvmVariant = jvmVariant;
    }

    /*
     * WARNING - void declaration
     */
    public AtomicFUTransformer(@NotNull List<String> classpath, @NotNull File inputDir, @NotNull File outputDir, @NotNull JvmVariant jvmVariant) {
        void $this$toTypedArray$iv;
        File it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)((Object)jvmVariant), (String)"jvmVariant");
        super(inputDir, outputDir);
        this.jvmVariant = jvmVariant;
        Iterable iterable = classpath;
        Collection collection = CollectionsKt.listOf((Object)inputDir);
        AtomicFUTransformer atomicFUTransformer = this;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)((Object)it));
            object.add(file);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.minus((Iterable)((Iterable)object), (Object)outputDir));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.toURI().toURL();
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        Intrinsics.checkNotNull((Object)uRLArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        URL[] uRLArray2 = uRLArray;
        atomicFUTransformer.classPathLoader = new URLClassLoader(uRLArray2);
        this.fields = new LinkedHashMap();
        this.accessors = new LinkedHashMap();
        this.traceFields = new LinkedHashSet();
        this.traceAccessors = new LinkedHashSet();
        this.fieldDelegates = new LinkedHashMap();
        this.delegatedPropertiesAccessors = new LinkedHashMap();
        this.removeMethods = new LinkedHashSet();
    }

    public /* synthetic */ AtomicFUTransformer(List list, File file, File file2, JvmVariant jvmVariant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file2 = file;
        }
        if ((n & 8) != 0) {
            jvmVariant = JvmVariant.FU;
        }
        this(list, file, file2, jvmVariant);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003JK\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CV;", "Lorg/objectweb/asm/ClassVisitor;", "cv", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Lorg/objectweb/asm/ClassVisitor;)V", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "atomicfu-transformer"})
    private abstract class CV
    extends ClassVisitor {
        public String className;

        @NotNull
        public final String getClassName() {
            String string = this.className;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"className");
            }
            return string;
        }

        public final void setClassName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.className = string;
        }

        public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.className = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public CV(ClassVisitor cv) {
            super(589824, cv);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J6\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016JC\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$FieldsCollectorCV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;)V", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "access", "", "name", "", "desc", "signature", "value", "", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "atomicfu-transformer"})
    private final class FieldsCollectorCV
    extends CV {
        @Nullable
        public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
            String string;
            Map map;
            Type fieldType;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Type type = fieldType = Type.getType((String)desc);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"fieldType");
            if (type.getSort() == 10 && (map = AtomicFUTransformerKt.access$getAFU_CLASSES$p()).containsKey(string = fieldType.getInternalName())) {
                FieldId field = new FieldId(this.getClassName(), name, desc);
                AtomicFUTransformerBase.info$default(AtomicFUTransformer.this, field + " field found", null, 2, null);
                if (AtomicFUTransformerKt.access$contains(access, 1)) {
                    AtomicFUTransformerBase.error$default(AtomicFUTransformer.this, field + " field cannot be public", null, 2, null);
                }
                if (!AtomicFUTransformerKt.access$contains(access, 16)) {
                    AtomicFUTransformerBase.error$default(AtomicFUTransformer.this, field + " field must be final", null, 2, null);
                }
                AtomicFUTransformer.this.registerField(field, fieldType, AtomicFUTransformerKt.access$contains(access, 8));
            }
            return null;
        }

        @Nullable
        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            Type[] typeArray;
            boolean bl;
            Type methodType;
            block5: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                Type type = methodType = Type.getMethodType((String)desc);
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"methodType");
                Type[] typeArray2 = type.getArgumentTypes();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"methodType.argumentTypes");
                Type[] $this$any$iv = typeArray2;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    Type element$iv;
                    Type it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    Map map = AtomicFUTransformerKt.access$getAFU_TYPES$p();
                    if (!map.containsKey(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                MethodId methodId = new MethodId(this.getClassName(), name, desc, AsmUtilKt.accessToInvokeOpcode(access));
                AtomicFUTransformerBase.info$default(AtomicFUTransformer.this, methodId + " method to be removed", null, 2, null);
                Collection $i$f$any = AtomicFUTransformer.this.removeMethods;
                $i$f$any.add(methodId);
            }
            Type[] typeArray3 = AtomicFUTransformer.this.getPotentialAccessorType(access, this.getClassName(), methodType);
            if (typeArray3 != null) {
                Type[] onType = typeArray = typeArray3;
                boolean bl3 = false;
                String string = onType.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"onType.internalName");
                return (MethodVisitor)new AccessorCollectorMV(string, access, name, desc, signature, exceptions);
            }
            if (Intrinsics.areEqual((Object)name, (Object)"<init>") || Intrinsics.areEqual((Object)name, (Object)"<clinit>")) {
                return (MethodVisitor)new DelegateFieldsCollectorMV(access, name, desc, signature, exceptions);
            }
            Type[] typeArray4 = methodType.getArgumentTypes();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray4, (String)"methodType.argumentTypes");
            typeArray = typeArray4;
            if (typeArray.length == 0) {
                String string = this.getClassName();
                Type type = methodType.getReturnType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"methodType.returnType");
                return (MethodVisitor)new DelegatedFieldAccessorCollectorMV(string, type, access, name, desc, signature, exceptions);
            }
            return null;
        }

        public FieldsCollectorCV() {
            super(null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$AccessorCollectorMV;", "Lorg/objectweb/asm/tree/MethodNode;", "className", "", "access", "", "name", "desc", "signature", "exceptions", "", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "", "atomicfu-transformer"})
    private final class AccessorCollectorMV
    extends MethodNode {
        private final String className;

        public void visitEnd() {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            List<AbstractInsnNode> insns = AsmUtilKt.listUseful(insnList, 4);
            if (insns.size() == 3 && AsmUtilKt.isAload(insns.get(0), 0) && AsmUtilKt.isGetField(insns.get(1), this.className) && AsmUtilKt.isAreturn(insns.get(2)) || insns.size() == 2 && AsmUtilKt.isGetStatic(insns.get(0), this.className) && AsmUtilKt.isAreturn(insns.get(1))) {
                String fieldName;
                boolean isStatic = insns.size() == 2;
                AbstractInsnNode abstractInsnNode = isStatic ? insns.get(0) : insns.get(1);
                if (abstractInsnNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
                }
                FieldInsnNode fi = (FieldInsnNode)abstractInsnNode;
                String string = fieldName = fi.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fieldName");
                String string2 = fi.desc;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fi.desc");
                FieldId field = new FieldId(this.className, string, string2);
                Type fieldType = Type.getType((String)fi.desc);
                String string3 = this.name;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                String string4 = this.desc;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"desc");
                MethodId accessorMethod = new MethodId(this.className, string3, string4, AsmUtilKt.accessToInvokeOpcode(this.access));
                AtomicFUTransformerBase.info$default(AtomicFUTransformer.this, field + " accessor " + this.name + " found", null, 2, null);
                if (Intrinsics.areEqual((Object)fieldType, (Object)AtomicFUTransformerKt.access$getTRACE_BASE_TYPE$p())) {
                    AtomicFUTransformer.this.traceAccessors.add(accessorMethod);
                } else {
                    Type type = fieldType;
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"fieldType");
                    FieldInfo fieldInfo = AtomicFUTransformer.this.registerField(field, type, isStatic);
                    Collection collection = fieldInfo.getAccessors();
                    collection.add(accessorMethod);
                    AtomicFUTransformer.this.accessors.put(accessorMethod, fieldInfo);
                }
            }
        }

        public AccessorCollectorMV(String className, @NotNull int access, @NotNull String name, @Nullable String desc, @Nullable String signature, String[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            super(589824, access, name, desc, signature, exceptions);
            this.className = className;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$DelegatedFieldAccessorCollectorMV;", "Lorg/objectweb/asm/tree/MethodNode;", "className", "", "returnType", "Lorg/objectweb/asm/Type;", "access", "", "name", "desc", "signature", "exceptions", "", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Ljava/lang/String;Lorg/objectweb/asm/Type;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "", "atomicfu-transformer"})
    private final class DelegatedFieldAccessorCollectorMV
    extends MethodNode {
        private final String className;
        private final Type returnType;

        /*
         * Enabled aggressive block sorting
         */
        public void visitEnd() {
            Type type;
            Map map;
            AbstractInsnNode cur;
            Intrinsics.checkNotNullExpressionValue((Object)this.instructions, (String)"instructions");
            for (cur = (v1649).getFirst(); !(cur == null || AsmUtilKt.isGetFieldOrGetStatic(cur) && (map = AtomicFUTransformerKt.access$getAFU_TYPES$p()).containsKey(type = Type.getType((String)((FieldInsnNode)cur).desc))); cur = cur.getNext()) {
            }
            if (cur != null) {
                AbstractInsnNode abstractInsnNode = cur.getNext();
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"cur.next");
                if (abstractInsnNode.getOpcode() == 58) {
                    AbstractInsnNode invokeVirtual;
                    FieldInsnNode fi = (FieldInsnNode)cur;
                    String string = fi.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fi.name");
                    String string2 = fi.desc;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fi.desc");
                    FieldId fieldDelegate = new FieldId(this.className, string, string2);
                    Type atomicType = Type.getType((String)fi.desc);
                    AbstractInsnNode abstractInsnNode2 = ((FieldInsnNode)cur).getNext();
                    if (abstractInsnNode2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.VarInsnNode");
                    }
                    int v = ((VarInsnNode)abstractInsnNode2).var;
                    while (!(cur instanceof VarInsnNode) || ((VarInsnNode)cur).getOpcode() != 25 || ((VarInsnNode)cur).var != v) {
                        AbstractInsnNode abstractInsnNode3 = cur;
                        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode3, (String)"cur");
                        cur = abstractInsnNode3.getNext();
                    }
                    AbstractInsnNode abstractInsnNode4 = invokeVirtual = ((VarInsnNode)cur).getNext();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode4, (String)"invokeVirtual");
                    if (abstractInsnNode4.getOpcode() == 182 && Intrinsics.areEqual((Object)((MethodInsnNode)invokeVirtual).name, (Object)"getValue")) {
                        String string3 = ((MethodInsnNode)invokeVirtual).owner;
                        Type type2 = atomicType;
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"atomicType");
                        if (Intrinsics.areEqual((Object)string3, (Object)type2.getInternalName())) {
                            AbstractInsnNode ret;
                            AbstractInsnNode next;
                            AbstractInsnNode abstractInsnNode5 = next = AsmUtilKt.getNextUseful(invokeVirtual);
                            AbstractInsnNode abstractInsnNode6 = ret = abstractInsnNode5 != null && abstractInsnNode5.getOpcode() == 192 ? AsmUtilKt.getNextUseful(next) : next;
                            if (ret != null && AsmUtilKt.isTypeReturn(ret, this.returnType)) {
                                Map map2 = AtomicFUTransformer.this.delegatedPropertiesAccessors;
                                String string4 = this.name;
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                                String string5 = this.desc;
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"desc");
                                map2.put(fieldDelegate, new MethodId(this.className, string4, string5, AsmUtilKt.accessToInvokeOpcode(this.access)));
                            }
                        }
                    }
                }
            }
        }

        public DelegatedFieldAccessorCollectorMV(@NotNull String className, Type returnType, @NotNull int access, @NotNull String name, @Nullable String desc, @Nullable String signature, String[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            super(327680, access, name, desc, signature, exceptions);
            this.className = className;
            this.returnType = returnType;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$DelegateFieldsCollectorMV;", "Lorg/objectweb/asm/tree/MethodNode;", "access", "", "name", "", "desc", "signature", "exceptions", "", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "", "atomicfu-transformer"})
    private final class DelegateFieldsCollectorMV
    extends MethodNode {
        public void visitEnd() {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            Iterable $this$forEach$iv = (Iterable)insnList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Object object2;
                Object delegateFieldId;
                AbstractInsnNode insn = (AbstractInsnNode)element$iv;
                boolean bl = false;
                if (insn instanceof FieldInsnNode && AtomicFUTransformer.this.checkGetFieldOrGetStatic((FieldInsnNode)insn) != null) {
                    Object object3;
                    FieldId fieldId;
                    FieldId getfieldId = fieldId;
                    boolean bl2 = false;
                    AbstractInsnNode next = ((FieldInsnNode)insn).getNext();
                    AbstractInsnNode abstractInsnNode = next;
                    if (!(abstractInsnNode instanceof FieldInsnNode)) {
                        abstractInsnNode = null;
                    }
                    if ((object3 = (FieldInsnNode)abstractInsnNode) != null && (object3 = AtomicFUTransformer.this.checkPutFieldOrPutStatic(object3)) != null) {
                        FieldId fieldId2;
                        Object object4 = object3;
                        delegateFieldId = object4;
                        boolean bl3 = false;
                        Map map = AtomicFUTransformer.this.fields;
                        if (map.containsKey(fieldId2 = getfieldId) && (map = AtomicFUTransformer.this.fields).containsKey(delegateFieldId)) {
                            Object v = AtomicFUTransformer.this.fields.get(getfieldId);
                            Intrinsics.checkNotNull(v);
                            FieldInfo originalField = (FieldInfo)v;
                            AtomicFUTransformer.this.fieldDelegates.put(delegateFieldId, originalField);
                        }
                    }
                }
                if (!(insn instanceof MethodInsnNode)) continue;
                String string = ((MethodInsnNode)insn).owner;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"insn.owner");
                String string2 = ((MethodInsnNode)insn).name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"insn.name");
                String string3 = ((MethodInsnNode)insn).desc;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"insn.desc");
                MethodId methodId = new MethodId(string, string2, string3, ((MethodInsnNode)insn).getOpcode());
                if (!AtomicFUTransformerKt.access$getFACTORIES$p().contains(methodId)) continue;
                AbstractInsnNode abstractInsnNode = AsmUtilKt.getNextUseful(insn);
                if (!(abstractInsnNode instanceof FieldInsnNode)) {
                    abstractInsnNode = null;
                }
                if ((object2 = (FieldInsnNode)abstractInsnNode) == null || (object2 = AtomicFUTransformer.this.checkPutFieldOrPutStatic(object2)) == null) continue;
                Object delegateFieldId2 = object = object2;
                boolean bl4 = false;
                Type type = Type.getType((String)((MethodInsnNode)insn).desc);
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(insn.desc)");
                Type fieldType = type.getReturnType();
                delegateFieldId = AtomicFUTransformerKt.access$getAFU_TYPES$p();
                if (!delegateFieldId.containsKey(fieldType)) continue;
                AbstractInsnNode abstractInsnNode2 = AsmUtilKt.getNextUseful(insn);
                Intrinsics.checkNotNull((Object)abstractInsnNode2);
                boolean isStatic = abstractInsnNode2.getOpcode() == 179;
                Map map = AtomicFUTransformer.this.fieldDelegates;
                Type type2 = fieldType;
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"fieldType");
                map.put(delegateFieldId2, new FieldInfo((FieldId)delegateFieldId2, type2, isStatic));
            }
        }

        public DelegateFieldsCollectorMV(@NotNull int access, @NotNull String name, @Nullable String desc, @Nullable String signature, String[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            super(589824, access, name, desc, signature, exceptions);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\fJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J6\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u000f2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016JC\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u000f2\u0010\u0010,\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010.J\u001c\u0010/\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u00100\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$TransformerCV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer;", "cv", "Lorg/objectweb/asm/ClassVisitor;", "vh", "", "analyzePhase2", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Lorg/objectweb/asm/ClassVisitor;ZZ)V", "metadata", "Lorg/objectweb/asm/tree/AnnotationNode;", "newClinit", "Lorg/objectweb/asm/tree/MethodNode;", "originalClinit", "source", "", "sourceInfo", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "getSourceInfo", "()Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "setSourceInfo", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;)V", "fuField", "", "protection", "", "f", "Lkotlinx/atomicfu/transformer/FieldInfo;", "getOrCreateNewClinit", "vhField", "visitAnnotation", "Lorg/objectweb/asm/AnnotationVisitor;", "desc", "visible", "visitEnd", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "access", "name", "signature", "value", "", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "visitSource", "debug", "atomicfu-transformer"})
    private final class TransformerCV
    extends CV {
        private String source;
        @Nullable
        private AtomicFUTransformerBase.SourceInfo sourceInfo;
        private AnnotationNode metadata;
        private MethodNode originalClinit;
        private MethodNode newClinit;
        private final boolean vh;
        private final boolean analyzePhase2;

        @Nullable
        public final AtomicFUTransformerBase.SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        public final void setSourceInfo(@Nullable AtomicFUTransformerBase.SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
        }

        private final MethodNode newClinit() {
            return new MethodNode(589824, 8, "<clinit>", "()V", null, null);
        }

        @NotNull
        public final MethodNode getOrCreateNewClinit() {
            MethodNode methodNode = this.newClinit;
            if (methodNode == null) {
                MethodNode methodNode2;
                MethodNode it = methodNode2 = this.newClinit();
                boolean bl = false;
                this.newClinit = it;
                methodNode = methodNode2;
            }
            return methodNode;
        }

        public void visitSource(@Nullable String source, @Nullable String debug) {
            this.source = source;
            super.visitSource(source, debug);
        }

        @Nullable
        public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
            Object object;
            Object object2;
            Type fieldType;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Type type = fieldType = Type.getType((String)desc);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"fieldType");
            if (type.getSort() == 10 && (object2 = AtomicFUTransformerKt.access$getAFU_CLASSES$p()).containsKey(object = fieldType.getInternalName())) {
                FieldVisitor fv;
                FieldVisitor fieldVisitor;
                int visibility;
                FieldId fieldId = new FieldId(this.getClassName(), name, desc);
                if (AtomicFUTransformer.this.isFieldDelegate(fieldId)) {
                    Object v = AtomicFUTransformer.this.fieldDelegates.get(fieldId);
                    Intrinsics.checkNotNull(v);
                    if (Intrinsics.areEqual((Object)fieldId, (Object)((FieldInfo)v).getFieldId()) ^ true) {
                        AtomicFUTransformer.this.setTransformed(true);
                        return null;
                    }
                }
                Object v = AtomicFUTransformer.this.fields.get(fieldId);
                Intrinsics.checkNotNull(v);
                FieldInfo f = (FieldInfo)v;
                int n = f.getHasExternalAccess() ? 1 : (visibility = f.getAccessors().isEmpty() ? 2 : 0);
                int protection = 0x1000 | visibility | (f.isStatic() && !this.vh ? 24 : (f.isStatic() && this.vh ? 8 : 0));
                Type primitiveType = f.getPrimitiveType(this.vh);
                if (f.isArray() && !this.vh) {
                    fieldVisitor = super.visitField(protection, f.getName(), f.getFuType().getDescriptor(), null, null);
                } else if (f.isStatic() && !this.vh) {
                    String string = f.getStaticRefVolatileField();
                    Type type2 = Type.getObjectType((String)f.getRefVolatileClassName());
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getObjectType(f.refVolatileClassName)");
                    fieldVisitor = super.visitField(protection, string, type2.getDescriptor(), null, null);
                } else {
                    fieldVisitor = fv = super.visitField(protection | 0x40, f.getName(), primitiveType.getDescriptor(), null, null);
                }
                if (this.vh) {
                    if (f.getHasAtomicOps() || f.isArray()) {
                        this.vhField(protection, f);
                    }
                } else if (f.getHasAtomicOps() && !f.isArray()) {
                    this.fuField(protection, f);
                }
                AtomicFUTransformer.this.setTransformed(true);
                return fv;
            }
            if (Intrinsics.areEqual((Object)fieldType, (Object)AtomicFUTransformerKt.access$getTRACE_BASE_TYPE$p())) {
                object2 = AtomicFUTransformer.this.traceFields;
                object = new FieldId(this.getClassName(), name, desc);
                object2.add(object);
                AtomicFUTransformer.this.setTransformed(true);
                return null;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        private final void vhField(int protection, FieldInfo f) {
            String string = f.getFuName();
            Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"VH_TYPE");
            super.visitField(protection | 0x10 | 8, string, type.getDescriptor(), null, null);
            MethodVisitor mv$iv = (MethodVisitor)this.getOrCreateNewClinit();
            boolean $i$f$code = false;
            InstructionAdapter $this$code = new InstructionAdapter(mv$iv);
            boolean bl = false;
            if (!f.isArray()) {
                $this$code.invokestatic(AtomicFUTransformerKt.access$getMETHOD_HANDLES$p(), "lookup", "()L" + AtomicFUTransformerKt.access$getLOOKUP$p() + ';', false);
                $this$code.aconst((Object)Type.getObjectType((String)this.getClassName()));
                $this$code.aconst((Object)f.getName());
                Type primitiveType = f.getPrimitiveType(this.vh);
                if (primitiveType.getSort() == 10) {
                    $this$code.aconst((Object)primitiveType);
                } else {
                    String wrapper = (String)MapsKt.getValue((Map)AtomicFUTransformerKt.access$getWRAPPER$p(), (Object)primitiveType);
                    Type type2 = AtomicFUTransformerKt.access$getCLASS_TYPE$p();
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"CLASS_TYPE");
                    $this$code.getstatic(wrapper, "TYPE", type2.getDescriptor());
                }
                String findVHName = f.isStatic() ? "findStaticVarHandle" : "findVarHandle";
                $this$code.invokevirtual(AtomicFUTransformerKt.access$getLOOKUP$p(), findVHName, Type.getMethodDescriptor((Type)AtomicFUTransformerKt.access$getVH_TYPE$p(), (Type[])new Type[]{AtomicFUTransformerKt.access$getCLASS_TYPE$p(), AtomicFUTransformerKt.access$getSTRING_TYPE$p(), AtomicFUTransformerKt.access$getCLASS_TYPE$p()}), false);
                String string2 = this.getClassName();
                String string3 = f.getFuName();
                Type type3 = AtomicFUTransformerKt.access$getVH_TYPE$p();
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"VH_TYPE");
                $this$code.putstatic(string2, string3, type3.getDescriptor());
            } else {
                $this$code.aconst((Object)f.getPrimitiveType(this.vh));
                $this$code.invokestatic(AtomicFUTransformerKt.access$getMETHOD_HANDLES$p(), "arrayElementVarHandle", Type.getMethodDescriptor((Type)AtomicFUTransformerKt.access$getVH_TYPE$p(), (Type[])new Type[]{AtomicFUTransformerKt.access$getCLASS_TYPE$p()}), false);
                String string4 = this.getClassName();
                String string5 = f.getFuName();
                Type type4 = AtomicFUTransformerKt.access$getVH_TYPE$p();
                Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"VH_TYPE");
                $this$code.putstatic(string4, string5, type4.getDescriptor());
            }
        }

        private final void fuField(int protection, FieldInfo f) {
            Type type;
            super.visitField(protection | 0x10 | 8, f.getFuName(), f.getFuType().getDescriptor(), null, null);
            MethodVisitor mv$iv = (MethodVisitor)this.getOrCreateNewClinit();
            boolean $i$f$code = false;
            InstructionAdapter $this$code = new InstructionAdapter(mv$iv);
            boolean bl = false;
            List params = new ArrayList();
            Collection collection = params;
            Object object = AtomicFUTransformerKt.access$getCLASS_TYPE$p();
            collection.add(object);
            if (!f.isStatic()) {
                $this$code.aconst((Object)Type.getObjectType((String)this.getClassName()));
            } else {
                $this$code.aconst((Object)Type.getObjectType((String)f.getRefVolatileClassName()));
            }
            Type primitiveType = f.getPrimitiveType(this.vh);
            if (primitiveType.getSort() == 10) {
                object = params;
                type = AtomicFUTransformerKt.access$getCLASS_TYPE$p();
                object.add(type);
                $this$code.aconst((Object)primitiveType);
            }
            object = params;
            type = AtomicFUTransformerKt.access$getSTRING_TYPE$p();
            object.add(type);
            $this$code.aconst((Object)f.getName());
            String string = f.getFuType().getInternalName();
            Type type2 = f.getFuType();
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
            Intrinsics.checkNotNull((Object)typeArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            $this$code.invokestatic(string, "newUpdater", Type.getMethodDescriptor((Type)type2, (Type[])Arrays.copyOf(typeArray, typeArray.length)), false);
            $this$code.putstatic(this.getClassName(), f.getFuName(), f.getFuType().getDescriptor());
        }

        @Nullable
        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            MethodId methodId = new MethodId(this.getClassName(), name, desc, AsmUtilKt.accessToInvokeOpcode(access));
            Map map = AtomicFUTransformer.this.accessors;
            if (map.containsKey(methodId) || AtomicFUTransformer.this.traceAccessors.contains(methodId) || AtomicFUTransformer.this.removeMethods.contains(methodId)) {
                AtomicFUTransformer.this.setTransformed(true);
                return null;
            }
            AtomicFUTransformerBase.SourceInfo sourceInfo = new AtomicFUTransformerBase.SourceInfo(methodId, this.source, null, null, 12, null);
            if (Intrinsics.areEqual((Object)name, (Object)"<clinit>") && Intrinsics.areEqual((Object)desc, (Object)"()V")) {
                if ((access & 8) == 0) {
                    Void void_ = AbortKt.abort$default("<clinit> method not marked as static", null, 2, null);
                    throw new KotlinNothingValueException();
                }
                MethodNode node = new MethodNode(589824, access, name, desc, signature, exceptions);
                if (this.originalClinit != null) {
                    Void void_ = AbortKt.abort$default("Multiple <clinit> methods found", null, 2, null);
                    throw new KotlinNothingValueException();
                }
                this.originalClinit = node;
                methodVisitor = (MethodVisitor)node;
            } else {
                methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            }
            MethodVisitor superMV = methodVisitor;
            TransformerMV mv = new TransformerMV(sourceInfo, access, name, desc, signature, exceptions, superMV, AsmUtilKt.getOwnerPackageName(this.getClassName()), this.vh, this.analyzePhase2);
            this.sourceInfo = mv.getSourceInfo();
            return (MethodVisitor)mv;
        }

        @Nullable
        public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
            if (Intrinsics.areEqual((Object)desc, (Object)"Lkotlin/Metadata;")) {
                AnnotationNode annotationNode;
                boolean bl;
                if (!visible) {
                    boolean bl2 = false;
                    String string = "Expected run-time visible Lkotlin/Metadata; annotation";
                    throw new IllegalStateException(string.toString());
                }
                boolean bl3 = bl = this.metadata == null;
                if (!bl) {
                    boolean $i$a$-check-AtomicFUTransformer$TransformerCV$visitAnnotation$32 = false;
                    String $i$a$-check-AtomicFUTransformer$TransformerCV$visitAnnotation$32 = "Only one Lkotlin/Metadata; annotation is expected";
                    throw new IllegalStateException($i$a$-check-AtomicFUTransformer$TransformerCV$visitAnnotation$32.toString());
                }
                AnnotationNode it = annotationNode = new AnnotationNode(desc);
                boolean bl4 = false;
                this.metadata = it;
                return (AnnotationVisitor)annotationNode;
            }
            return super.visitAnnotation(desc, visible);
        }

        public void visitEnd() {
            AnnotationNode annotationNode = this.metadata;
            if (annotationNode != null) {
                AnnotationNode annotationNode2;
                AnnotationNode it = annotationNode2 = annotationNode;
                boolean bl = false;
                MetadataTransformer mt = new MetadataTransformer(SetsKt.plus(AtomicFUTransformer.this.fields.keySet(), (Iterable)AtomicFUTransformer.this.traceFields), SetsKt.plus((Set)SetsKt.plus(AtomicFUTransformer.this.accessors.keySet(), (Iterable)AtomicFUTransformer.this.traceAccessors), (Iterable)AtomicFUTransformer.this.removeMethods));
                if (mt.transformMetadata(it)) {
                    AtomicFUTransformer.this.setTransformed(true);
                }
                if (this.cv != null) {
                    it.accept(this.cv.visitAnnotation("Lkotlin/Metadata;", true));
                }
            }
            if (this.analyzePhase2) {
                return;
            }
            if (this.originalClinit != null || this.newClinit != null) {
                MethodNode newClinit = this.newClinit;
                if (newClinit == null) {
                    MethodNode methodNode = this.originalClinit;
                    Intrinsics.checkNotNull((Object)methodNode);
                    methodNode.accept(this.cv);
                } else {
                    MethodNode methodNode = this.originalClinit;
                    if (methodNode == null) {
                        MethodNode bl;
                        MethodNode it = bl = this.newClinit();
                        boolean bl2 = false;
                        boolean $i$f$code = false;
                        InstructionAdapter $this$code = new InstructionAdapter((MethodVisitor)it);
                        boolean bl3 = false;
                        $this$code.visitInsn(177);
                        methodNode = bl;
                    }
                    MethodNode originalClinit = methodNode;
                    InsnList insnList = originalClinit.instructions;
                    Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"originalClinit.instructions");
                    AbstractInsnNode last = insnList.getLast();
                    AbstractInsnNode ret = AsmUtilKt.getThisOrPrevUseful(last);
                    if (ret == null || !AsmUtilKt.isReturn(ret)) {
                        Void void_ = AbortKt.abort("Last instruction in <clinit> shall be RETURN", ret);
                        throw new KotlinNothingValueException();
                    }
                    originalClinit.instructions.insertBefore(ret, newClinit.instructions);
                    originalClinit.accept(this.cv);
                }
            }
            super.visitEnd();
        }

        public TransformerCV(ClassVisitor cv, boolean vh, boolean analyzePhase2) {
            super(cv);
            this.vh = vh;
            this.analyzePhase2 = analyzePhase2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ0\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%H\u0002J*\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J2\u0010*\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010%H\u0002J\"\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020)H\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J2\u0010.\u001a\u0004\u0018\u00010\u001c2\u0006\u0010/\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010%H\u0002J\"\u00100\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J \u00101\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u00104\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00105\u001a\u000206H\u0002J\"\u00107\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J(\u00108\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u001cH\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010\u001c2\u0006\u0010=\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J*\u0010>\u001a\u0004\u0018\u00010\u001c2\u0006\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020!H\u0002J*\u0010B\u001a\u0004\u0018\u00010\u001c2\u0006\u0010C\u001a\u00020)2\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020!H\u0002J*\u0010D\u001a\u0004\u0018\u00010\u001c2\u0006\u0010E\u001a\u00020)2\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020!H\u0002J\u000f\u0010F\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010GJ\u0010\u0010H\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020\u001cH\u0002J\u0018\u0010J\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020)2\u0006\u0010L\u001a\u00020\u0010H\u0002J\u0012\u0010M\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010N\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010O\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001cH\u0002J \u0010R\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010S\u001a\u00020\u0018H\u0016J0\u0010T\u001a\u00020\u00182\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010W\u001a\u00020\u0010H\u0016J\u000e\u0010X\u001a\u0004\u0018\u00010\u001c*\u00020!H\u0002J\f\u0010Y\u001a\u00020\u0010*\u00020\u001cH\u0002J\f\u0010Z\u001a\u00020\u0010*\u00020\u001cH\u0002R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$TransformerMV;", "Lorg/objectweb/asm/tree/MethodNode;", "sourceInfo", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "access", "", "name", "", "desc", "signature", "exceptions", "", "mv", "Lorg/objectweb/asm/MethodVisitor;", "packageName", "vh", "", "analyzePhase2", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Lorg/objectweb/asm/MethodVisitor;Ljava/lang/String;ZZ)V", "bumpedLocals", "getSourceInfo", "()Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "tempLocal", "bumpLocals", "", "n", "checkDataFlowComplexity", "i", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "fixupArrayElementLoad", "f", "Lkotlinx/atomicfu/transformer/FieldInfo;", "ld", "Lorg/objectweb/asm/tree/FieldInsnNode;", "otherLd", "Lorg/objectweb/asm/tree/VarInsnNode;", "arrayElementInfo", "", "fixupInvokeVirtual", "onArrayElement", "iv", "Lorg/objectweb/asm/tree/MethodInsnNode;", "fixupLoad", "fixupLoadedArrayElement", "getter", "fixupLoadedAtomicVar", "fixupOperationOnAtomicVar", "operation", "fixupVarLoad", "fuOperation", "typeInfo", "Lkotlinx/atomicfu/transformer/TypeInfo;", "generateRefVolatileClass", "arg", "Lorg/objectweb/asm/Type;", "getPureTypeField", "initRefVolatile", "argType", "firstInitInsn", "lastInitInsn", "insertPureVhArray", "getVarHandleInsn", "putJucaAtomicArray", "arrayfactoryInsn", "initStart", "next", "putPrimitiveTypeWrapper", "factoryInsn", "putPureVhArray", "arrayFactoryInsn", "removeAtomicReferencesFromLVT", "()Ljava/lang/Boolean;", "removeTraceAppend", "append", "removeTraceInit", "atomicFactory", "isArrayFactory", "transform", "transformDelegatedFieldAccessor", "fieldId", "Lkotlinx/atomicfu/transformer/FieldId;", "tryEraseUncheckedCast", "vhOperation", "visitEnd", "visitMethodInsn", "opcode", "owner", "itf", "checkCopyToDelegate", "isAtomicGetFieldOrGetStatic", "isAtomicGetValueOrSetValue", "atomicfu-transformer"})
    private final class TransformerMV
    extends MethodNode {
        @NotNull
        private final AtomicFUTransformerBase.SourceInfo sourceInfo;
        private int tempLocal;
        private int bumpedLocals;
        private final String packageName;
        private final boolean vh;
        private final boolean analyzePhase2;

        @NotNull
        public final AtomicFUTransformerBase.SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        private final void bumpLocals(int n) {
            if (this.bumpedLocals == 0) {
                this.tempLocal = this.maxLocals;
            }
            while (n > this.bumpedLocals) {
                this.bumpedLocals = n;
            }
            this.maxLocals = this.tempLocal + this.bumpedLocals;
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            MethodId methodId = new MethodId(owner, name, desc, opcode);
            FieldInfo fieldInfo = (FieldInfo)AtomicFUTransformer.this.accessors.get(methodId);
            if (fieldInfo != null && Intrinsics.areEqual((Object)AsmUtilKt.getOwnerPackageName(methodId.getOwner()), (Object)this.packageName) ^ true) {
                if (this.analyzePhase2) {
                    fieldInfo.setHasExternalAccess(true);
                } else {
                    boolean bl = fieldInfo.getHasExternalAccess();
                    if (!bl) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitEnd() {
            boolean hasErrors = false;
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            AbstractInsnNode i = insnList.getFirst();
            while (i != null) {
                try {
                    i = this.transform(i);
                }
                catch (AbortTransform e) {
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    AtomicFUTransformer.this.error(string, AtomicFUTransformerBase.SourceInfo.copy$default(this.sourceInfo, null, null, e.getI(), null, 11, null));
                    i = i.getNext();
                    hasErrors = true;
                }
            }
            this.removeAtomicReferencesFromLVT();
            if (!hasErrors && !this.analyzePhase2) {
                this.accept(this.mv);
            }
        }

        private final Boolean removeAtomicReferencesFromLVT() {
            List list = this.localVariables;
            return list != null ? Boolean.valueOf(list.removeIf(removeAtomicReferencesFromLVT.1.INSTANCE)) : null;
        }

        private final AbstractInsnNode checkCopyToDelegate(FieldInsnNode $this$checkCopyToDelegate) {
            String string = $this$checkCopyToDelegate.owner;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner");
            String string2 = $this$checkCopyToDelegate.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            String string3 = $this$checkCopyToDelegate.desc;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
            FieldId fieldId = new FieldId(string, string2, string3);
            if (AtomicFUTransformer.this.isFieldDelegate(fieldId)) {
                Object v = AtomicFUTransformer.this.fieldDelegates.get(fieldId);
                Intrinsics.checkNotNull(v);
                FieldInfo originalField = (FieldInfo)v;
                AbstractInsnNode abstractInsnNode = $this$checkCopyToDelegate.getPrevious();
                if (abstractInsnNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
                }
                FieldInsnNode getField = (FieldInsnNode)abstractInsnNode;
                AbstractInsnNode next = $this$checkCopyToDelegate.getNext();
                if (!originalField.isStatic()) {
                    this.instructions.remove(getField.getPrevious());
                }
                this.instructions.remove((AbstractInsnNode)getField);
                this.instructions.remove((AbstractInsnNode)$this$checkCopyToDelegate);
                return next;
            }
            return null;
        }

        private final AbstractInsnNode fixupInvokeVirtual(FieldInsnNode ld, boolean onArrayElement, MethodInsnNode iv, FieldInfo f) {
            boolean arrayLength2;
            TypeInfo typeInfo;
            TypeInfo typeInfo2;
            boolean bl;
            boolean bl2 = bl = f.isArray() || !onArrayElement;
            if (!bl) {
                boolean $i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$42 = false;
                String $i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$42 = "Cannot fix array element access on non array fields";
                throw new IllegalStateException($i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$42.toString());
            }
            if (onArrayElement) {
                typeInfo2 = f.getTypeInfo();
            } else {
                Map map = AtomicFUTransformerKt.access$getAFU_CLASSES$p();
                String string = iv.owner;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"iv.owner");
                typeInfo2 = typeInfo = (TypeInfo)MapsKt.getValue((Map)map, (Object)string);
            }
            if (Intrinsics.areEqual((Object)iv.name, (Object)"getValue") || Intrinsics.areEqual((Object)iv.name, (Object)"setValue")) {
                boolean $i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$42;
                boolean bl3 = $i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$42 = !f.isArray() || onArrayElement;
                if (!$i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$42) {
                    boolean $i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$52 = false;
                    String $i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$52 = "getValue/setValue can only be called on elements of arrays";
                    throw new IllegalStateException($i$a$-check-AtomicFUTransformer$TransformerMV$fixupInvokeVirtual$52.toString());
                }
                boolean setInsn = Intrinsics.areEqual((Object)iv.name, (Object)"setValue");
                if (!onArrayElement) {
                    return this.getPureTypeField(ld, f, iv);
                }
                Type methodType = Type.getMethodType((String)iv.desc);
                if (Intrinsics.areEqual((Object)f.getTypeInfo().getOriginalType(), (Object)f.getTypeInfo().getTransformedType()) ^ true && !this.vh) {
                    String string;
                    Type ret = f.getTypeInfo().getTransformedType().getElementType();
                    if (setInsn) {
                        Type type = methodType;
                        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"methodType");
                        string = Type.getMethodDescriptor((Type)type.getReturnType(), (Type[])new Type[]{ret});
                    } else {
                        Type type = methodType;
                        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"methodType");
                        Type[] typeArray = type.getArgumentTypes();
                        string = Type.getMethodDescriptor((Type)ret, (Type[])Arrays.copyOf(typeArray, typeArray.length));
                    }
                    iv.desc = string;
                    methodType = Type.getMethodType((String)iv.desc);
                }
                String string = iv.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"iv.name");
                String string2 = string;
                int n = 0;
                int n2 = 3;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                iv.name = string3;
                if (!this.vh) {
                    String string4 = f.getFuType().getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"f.fuType.descriptor");
                    iv.owner = AtomicFUTransformer.this.descToName(string4);
                    Type type = methodType;
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"methodType");
                    Type type2 = type.getReturnType();
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)Type.INT_TYPE);
                    spreadBuilder.addSpread((Object)methodType.getArgumentTypes());
                    iv.desc = Type.getMethodDescriptor((Type)type2, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
                } else {
                    Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"VH_TYPE");
                    String string5 = type.getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"VH_TYPE.descriptor");
                    iv.owner = AtomicFUTransformer.this.descToName(string5);
                    Type type3 = methodType;
                    Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"methodType");
                    Type type4 = type3.getReturnType();
                    SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                    spreadBuilder.add((Object)f.getPrimitiveType(this.vh));
                    spreadBuilder.add((Object)Type.INT_TYPE);
                    spreadBuilder.addSpread((Object)methodType.getArgumentTypes());
                    iv.desc = Type.getMethodDescriptor((Type)type4, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
                }
                return (AbstractInsnNode)iv;
            }
            if (f.isArray() && Intrinsics.areEqual((Object)iv.name, (Object)"getSize")) {
                if (this.vh) {
                    InsnNode arrayLength2 = new InsnNode(190);
                    this.instructions.insert((AbstractInsnNode)ld, (AbstractInsnNode)arrayLength2);
                    if (!f.isStatic()) {
                        AbstractInsnNode abstractInsnNode = ld.getPrevious();
                        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"ld.previous");
                        this.instructions.remove(abstractInsnNode.getPrevious());
                        this.instructions.remove(ld.getPrevious());
                    } else {
                        this.instructions.remove(ld.getPrevious());
                    }
                    this.instructions.remove((AbstractInsnNode)iv);
                    return (AbstractInsnNode)arrayLength2;
                }
                String string = f.getFuType().getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.fuType.descriptor");
                iv.owner = AtomicFUTransformer.this.descToName(string);
                iv.name = "length";
                return (AbstractInsnNode)iv;
            }
            if (f.isArray() && Intrinsics.areEqual((Object)iv.name, (Object)"get")) {
                return this.fixupLoadedArrayElement(f, ld, iv);
            }
            boolean bl4 = arrayLength2 = f.isArray() == onArrayElement;
            if (!arrayLength2) {
                boolean bl5 = false;
                String string = "Atomic operations can be performed on atomic elements only";
                throw new IllegalStateException(string.toString());
            }
            if (this.analyzePhase2) {
                f.setHasAtomicOps(true);
            } else {
                arrayLength2 = f.getHasAtomicOps();
                if (!arrayLength2) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
            }
            if (this.vh) {
                this.vhOperation(iv, typeInfo, f);
            } else {
                this.fuOperation(iv, typeInfo, f);
            }
            if (f.isStatic() && !onArrayElement) {
                if (!this.vh) {
                    String string = f.getOwner();
                    String string6 = f.getStaticRefVolatileField();
                    Type type = Type.getObjectType((String)f.getRefVolatileClassName());
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(f.refVolatileClassName)");
                    FieldInsnNode aload = new FieldInsnNode(178, string, string6, type.getDescriptor());
                    this.instructions.insert((AbstractInsnNode)ld, (AbstractInsnNode)aload);
                }
                return iv.getNext();
            }
            if (!onArrayElement) {
                InsnNode swap = new InsnNode(95);
                this.instructions.insert((AbstractInsnNode)ld, (AbstractInsnNode)swap);
                return swap.getNext();
            }
            return iv.getNext();
        }

        private final AbstractInsnNode getPureTypeField(FieldInsnNode ld, FieldInfo f, MethodInsnNode iv) {
            String owner;
            Type primitiveType = f.getPrimitiveType(this.vh);
            String string = owner = !this.vh && f.isStatic() ? f.getRefVolatileClassName() : f.getOwner();
            if (!this.vh && f.isStatic()) {
                String string2 = f.getOwner();
                String string3 = f.getStaticRefVolatileField();
                Type type = Type.getObjectType((String)owner);
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(owner)");
                FieldInsnNode getOwnerClass = new FieldInsnNode(178, string2, string3, type.getDescriptor());
                this.instructions.insert((AbstractInsnNode)ld, (AbstractInsnNode)getOwnerClass);
            }
            this.instructions.remove((AbstractInsnNode)ld);
            FieldInsnNode j = new FieldInsnNode(Intrinsics.areEqual((Object)iv.name, (Object)"getValue") ? (f.isStatic() && this.vh ? 178 : 180) : (f.isStatic() && this.vh ? 179 : 181), owner, f.getName(), primitiveType.getDescriptor());
            this.instructions.set((AbstractInsnNode)iv, (AbstractInsnNode)j);
            return j.getNext();
        }

        /*
         * WARNING - void declaration
         */
        private final void vhOperation(MethodInsnNode iv, TypeInfo typeInfo, FieldInfo f) {
            List list;
            Type methodType;
            Type type = methodType = Type.getMethodType((String)iv.desc);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"methodType");
            Type[] args = type.getArgumentTypes();
            Type type2 = AtomicFUTransformerKt.access$getVH_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"VH_TYPE");
            iv.owner = type2.getInternalName();
            if (!f.isArray() && !f.isStatic()) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                Type type3 = InstructionAdapter.OBJECT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"OBJECT_TYPE");
                spreadBuilder.add((Object)type3);
                Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
                spreadBuilder.addSpread((Object)args);
                list = CollectionsKt.mutableListOf((Object[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
            } else if (!f.isArray() && f.isStatic()) {
                Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
                list = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(args, args.length));
            } else {
                SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)typeInfo.getOriginalType());
                spreadBuilder.add((Object)Type.INT_TYPE);
                Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
                spreadBuilder.addSpread((Object)args);
                list = CollectionsKt.mutableListOf((Object[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
            }
            List params = list;
            Type elementType = f.isArray() ? typeInfo.getOriginalType().getElementType() : typeInfo.getOriginalType();
            boolean bl = Intrinsics.areEqual((Object)elementType, (Object)Type.LONG_TYPE);
            String string = iv.name;
            if (string != null) {
                switch (string) {
                    case "lazySet": {
                        iv.name = "setRelease";
                        break;
                    }
                    case "getAndIncrement": {
                        void $this$insns;
                        boolean $i$f$insns22 = false;
                        MethodNode node$iv = new MethodNode(589824);
                        InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)node$iv);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl2 = false;
                        if (bl) {
                            $this$insns.lconst(1L);
                        } else {
                            $this$insns.iconst(1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList2 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList2);
                        Collection $i$f$insns22 = params;
                        $i$f$insns22.add(elementType);
                        iv.name = "getAndAdd";
                        break;
                    }
                    case "getAndDecrement": {
                        boolean $i$f$insns32 = false;
                        MethodNode node$iv = new MethodNode(589824);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl3 = false;
                        if (bl) {
                            $this$insns.lconst(-1L);
                        } else {
                            $this$insns.iconst(-1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList3 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList3, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList3);
                        Collection $i$f$insns32 = params;
                        $i$f$insns32.add(elementType);
                        iv.name = "getAndAdd";
                        break;
                    }
                    case "addAndGet": {
                        this.bumpLocals(bl ? 2 : 1);
                        boolean $i$f$insns = false;
                        MethodNode node$iv = new MethodNode(589824);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl4 = false;
                        if (bl) {
                            $this$insns.dup2();
                        } else {
                            $this$insns.dup();
                        }
                        $this$insns.store(this.tempLocal, elementType);
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList4 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList4, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList4);
                        iv.name = "getAndAdd";
                        $i$f$insns = false;
                        node$iv = new MethodNode(589824);
                        $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        abstractInsnNode = (AbstractInsnNode)iv;
                        insnList = this.instructions;
                        boolean bl5 = false;
                        $this$insns.load(this.tempLocal, elementType);
                        $this$insns.add(elementType);
                        unit = Unit.INSTANCE;
                        InsnList insnList5 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList5, (String)"node.instructions");
                        insnList.insert(abstractInsnNode, insnList5);
                        break;
                    }
                    case "incrementAndGet": {
                        boolean $i$f$insns42 = false;
                        MethodNode node$iv = new MethodNode(589824);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl6 = false;
                        if (bl) {
                            $this$insns.lconst(1L);
                        } else {
                            $this$insns.iconst(1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList6 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList6, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList6);
                        Collection $i$f$insns42 = params;
                        $i$f$insns42.add(elementType);
                        iv.name = "getAndAdd";
                        boolean $i$f$insns = false;
                        node$iv = new MethodNode(589824);
                        $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        abstractInsnNode = (AbstractInsnNode)iv;
                        insnList = this.instructions;
                        boolean bl7 = false;
                        if (bl) {
                            $this$insns.lconst(1L);
                        } else {
                            $this$insns.iconst(1);
                        }
                        $this$insns.add(elementType);
                        unit = Unit.INSTANCE;
                        InsnList insnList7 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList7, (String)"node.instructions");
                        insnList.insert(abstractInsnNode, insnList7);
                        break;
                    }
                    case "decrementAndGet": {
                        boolean $i$f$insns52 = false;
                        MethodNode node$iv = new MethodNode(589824);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl8 = false;
                        if (bl) {
                            $this$insns.lconst(-1L);
                        } else {
                            $this$insns.iconst(-1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList8 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList8, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList8);
                        Collection $i$f$insns52 = params;
                        $i$f$insns52.add(elementType);
                        iv.name = "getAndAdd";
                        boolean $i$f$insns = false;
                        node$iv = new MethodNode(589824);
                        $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        abstractInsnNode = (AbstractInsnNode)iv;
                        insnList = this.instructions;
                        boolean bl9 = false;
                        if (bl) {
                            $this$insns.lconst(-1L);
                        } else {
                            $this$insns.iconst(-1);
                        }
                        $this$insns.add(elementType);
                        unit = Unit.INSTANCE;
                        InsnList insnList9 = node$iv.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)insnList9, (String)"node.instructions");
                        insnList.insert(abstractInsnNode, insnList9);
                    }
                }
            }
            Type type4 = methodType.getReturnType();
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
            Intrinsics.checkNotNull((Object)typeArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            iv.desc = Type.getMethodDescriptor((Type)type4, (Type[])Arrays.copyOf(typeArray, typeArray.length));
        }

        /*
         * WARNING - void declaration
         */
        private final void fuOperation(MethodInsnNode iv, TypeInfo typeInfo, FieldInfo f) {
            Type methodType = Type.getMethodType((String)iv.desc);
            Type originalElementType = f.isArray() ? typeInfo.getOriginalType().getElementType() : typeInfo.getOriginalType();
            Type transformedElementType = f.isArray() ? typeInfo.getTransformedType().getElementType() : typeInfo.getTransformedType();
            boolean trans = Intrinsics.areEqual((Object)originalElementType, (Object)transformedElementType) ^ true;
            Type type = methodType;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"methodType");
            Type[] args = type.getArgumentTypes();
            Type ret = methodType.getReturnType();
            if (trans) {
                Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
                Type[] $this$forEachIndexed$iv = args;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Type item$iv : $this$forEachIndexed$iv) {
                    void type2;
                    int n = index$iv++;
                    Type type3 = item$iv;
                    int i = n;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)type2, (Object)originalElementType)) continue;
                    args[i] = transformedElementType;
                }
                if (Intrinsics.areEqual((Object)iv.name, (Object)"getAndSet")) {
                    ret = transformedElementType;
                }
            }
            if (f.isArray()) {
                iv.owner = typeInfo.getFuType().getInternalName();
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)Type.INT_TYPE);
                spreadBuilder.addSpread((Object)args);
                iv.desc = Type.getMethodDescriptor((Type)ret, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
                return;
            }
            iv.owner = typeInfo.getFuType().getInternalName();
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)InstructionAdapter.OBJECT_TYPE);
            spreadBuilder.addSpread((Object)args);
            iv.desc = Type.getMethodDescriptor((Type)ret, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
        }

        private final void tryEraseUncheckedCast(AbstractInsnNode getter) {
            AbstractInsnNode abstractInsnNode = getter.getNext();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"getter.next");
            if (abstractInsnNode.getOpcode() == 89) {
                AbstractInsnNode abstractInsnNode2 = getter.getNext();
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode2, (String)"getter.next");
                AbstractInsnNode abstractInsnNode3 = abstractInsnNode2.getNext();
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode3, (String)"getter.next.next");
                if (abstractInsnNode3.getOpcode() == 199) {
                    AbstractInsnNode abstractInsnNode4 = getter.getNext();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode4, (String)"getter.next");
                    AbstractInsnNode abstractInsnNode5 = abstractInsnNode4.getNext();
                    if (abstractInsnNode5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.JumpInsnNode");
                    }
                    JumpInsnNode ifnonnull = (JumpInsnNode)abstractInsnNode5;
                    AbstractInsnNode abstractInsnNode6 = getter.getNext();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode6, (String)"getter.next");
                    AbstractInsnNode i = abstractInsnNode6;
                    while (true) {
                        if (i instanceof LabelNode) {
                            Label label = ((LabelNode)i).getLabel();
                            LabelNode labelNode = ifnonnull.label;
                            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"ifnonnull.label");
                            if (Intrinsics.areEqual((Object)label, (Object)labelNode.getLabel())) break;
                        }
                        AbstractInsnNode next = i.getNext();
                        this.instructions.remove(i);
                        Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
                    }
                }
            }
        }

        private final AbstractInsnNode fixupLoadedAtomicVar(FieldInfo f, FieldInsnNode ld) {
            if (Intrinsics.areEqual((Object)f.getFieldType(), (Object)AtomicFUTransformerKt.access$getREF_TYPE$p())) {
                this.tryEraseUncheckedCast((AbstractInsnNode)ld);
            }
            AbstractInsnNode j = new FlowAnalyzer(ld.getNext()).execute();
            return this.fixupOperationOnAtomicVar(j, f, ld, null);
        }

        private final AbstractInsnNode fixupLoadedArrayElement(FieldInfo f, FieldInsnNode ld, MethodInsnNode getter) {
            if (Intrinsics.areEqual((Object)f.getFieldType(), (Object)AtomicFUTransformerKt.access$getATOMIC_ARRAY_TYPE$p())) {
                this.tryEraseUncheckedCast((AbstractInsnNode)getter);
            }
            List arrayElementInfo = new ArrayList();
            if (this.vh) {
                if (!f.isStatic()) {
                    AbstractInsnNode abstractInsnNode = ld.getPrevious();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"ld.previous");
                    AbstractInsnNode abstractInsnNode2 = abstractInsnNode.getPrevious();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode2, (String)"ld.previous.previous");
                    arrayElementInfo.add(abstractInsnNode2);
                    AbstractInsnNode abstractInsnNode3 = ld.getPrevious();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode3, (String)"ld.previous");
                    arrayElementInfo.add(abstractInsnNode3);
                } else {
                    AbstractInsnNode abstractInsnNode = ld.getPrevious();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"ld.previous");
                    arrayElementInfo.add(abstractInsnNode);
                }
            }
            AbstractInsnNode i = (AbstractInsnNode)ld;
            while (Intrinsics.areEqual((Object)i, (Object)getter) ^ true) {
                arrayElementInfo.add(i);
                Intrinsics.checkNotNullExpressionValue((Object)i.getNext(), (String)"i.next");
            }
            AbstractInsnNode args = getter.getNext();
            this.instructions.remove((AbstractInsnNode)getter);
            AbstractInsnNode arrayElementOperation = new FlowAnalyzer(args).execute();
            return this.fixupOperationOnAtomicVar(arrayElementOperation, f, ld, arrayElementInfo);
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode fixupOperationOnAtomicVar(AbstractInsnNode operation, FieldInfo f, FieldInsnNode ld, List<? extends AbstractInsnNode> arrayElementInfo) {
            AbstractInsnNode abstractInsnNode = operation;
            if (abstractInsnNode instanceof MethodInsnNode) {
                AtomicFUTransformer.this.debug("invoke " + f + '.' + ((MethodInsnNode)operation).name, AtomicFUTransformerBase.SourceInfo.copy$default(this.sourceInfo, null, null, operation, null, 11, null));
                return this.fixupInvokeVirtual(ld, arrayElementInfo != null, (MethodInsnNode)operation, f);
            }
            if (abstractInsnNode instanceof VarInsnNode) {
                boolean bl;
                boolean onArrayElement = arrayElementInfo != null;
                boolean bl2 = bl = f.isArray() == onArrayElement;
                if (!bl) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                int v = ((VarInsnNode)operation).var;
                AbstractInsnNode next = ((VarInsnNode)operation).getNext();
                if (onArrayElement) {
                    List<? extends AbstractInsnNode> list = arrayElementInfo;
                    Intrinsics.checkNotNull(list);
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AbstractInsnNode it = (AbstractInsnNode)element$iv;
                        boolean bl3 = false;
                        this.instructions.remove(it);
                    }
                } else {
                    this.instructions.remove((AbstractInsnNode)ld);
                }
                LocalVariableNode lv = AsmUtilKt.localVar(this, v, operation);
                if (f.isStatic()) {
                    this.instructions.remove(operation);
                }
                if (lv != null) {
                    void start$iv;
                    if (Intrinsics.areEqual((Object)lv.desc, (Object)f.getFieldType().getDescriptor()) ^ true && !onArrayElement) {
                        Void void_ = AbortKt.abort$default("field " + f + " was stored to a local variable #" + v + " \"" + lv.name + "\" with unexpected type: " + lv.desc, null, 2, null);
                        throw new KotlinNothingValueException();
                    }
                    lv.desc = f.getOwnerType().getDescriptor();
                    lv.signature = null;
                    LabelNode labelNode = lv.start;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"lv.start");
                    LabelNode $i$f$forEach = labelNode;
                    LabelNode labelNode2 = lv.end;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"lv.end");
                    LabelNode end$iv = labelNode2;
                    boolean $i$f$forVarLoads = false;
                    AbstractInsnNode cur$iv = (AbstractInsnNode)start$iv;
                    while (cur$iv != null && cur$iv != end$iv) {
                        if (cur$iv instanceof VarInsnNode && ((VarInsnNode)cur$iv).getOpcode() == 25 && ((VarInsnNode)cur$iv).var == v) {
                            VarInsnNode otherLd = (VarInsnNode)cur$iv;
                            boolean bl4 = false;
                            cur$iv = this.fixupLoad(f, ld, otherLd, arrayElementInfo);
                            continue;
                        }
                        cur$iv = cur$iv.getNext();
                    }
                } else {
                    AbstractInsnNode abstractInsnNode2 = next;
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode2, (String)"next");
                    this.fixupLoad(f, ld, AsmUtilKt.nextVarLoad(v, abstractInsnNode2), arrayElementInfo);
                }
                return next;
            }
            Void void_ = AbortKt.abort$default("cannot happen", null, 2, null);
            throw new KotlinNothingValueException();
        }

        private final AbstractInsnNode fixupLoad(FieldInfo f, FieldInsnNode ld, VarInsnNode otherLd, List<? extends AbstractInsnNode> arrayElementInfo) {
            AbstractInsnNode next;
            AbstractInsnNode abstractInsnNode = next = arrayElementInfo != null ? this.fixupArrayElementLoad(f, ld, otherLd, arrayElementInfo) : this.fixupVarLoad(f, ld, otherLd);
            if (f.isStatic()) {
                this.instructions.remove((AbstractInsnNode)otherLd);
            }
            return next;
        }

        private final AbstractInsnNode fixupVarLoad(FieldInfo f, FieldInsnNode ld, VarInsnNode otherLd) {
            AbstractInsnNode abstractInsnNode = ld.clone(null);
            if (abstractInsnNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
            }
            FieldInsnNode ldCopy = (FieldInsnNode)abstractInsnNode;
            this.instructions.insert((AbstractInsnNode)otherLd, (AbstractInsnNode)ldCopy);
            return this.fixupLoadedAtomicVar(f, ldCopy);
        }

        private final AbstractInsnNode fixupArrayElementLoad(FieldInfo f, FieldInsnNode ld, VarInsnNode otherLd, List<? extends AbstractInsnNode> arrayElementInfo) {
            AbstractInsnNode it;
            if (Intrinsics.areEqual((Object)f.getFieldType(), (Object)AtomicFUTransformerKt.access$getATOMIC_ARRAY_TYPE$p())) {
                this.tryEraseUncheckedCast((AbstractInsnNode)otherLd);
            }
            List index = CollectionsKt.drop((Iterable)arrayElementInfo, (int)(this.vh ? 3 : 1));
            for (AbstractInsnNode indexInsn : index) {
                this.checkDataFlowComplexity(indexInsn);
            }
            AbstractInsnNode args = otherLd.getNext();
            AbstractInsnNode operationOnArrayElement = new FlowAnalyzer(args).execute();
            List arrayElementInfoCopy = new ArrayList();
            Iterable $this$forEach$iv = arrayElementInfo;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl = false;
                AbstractInsnNode abstractInsnNode = it.clone(null);
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"it.clone(null)");
                arrayElementInfoCopy.add(abstractInsnNode);
            }
            $this$forEach$iv = arrayElementInfoCopy;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl = false;
                this.instructions.insertBefore(args, it);
            }
            return this.fixupOperationOnAtomicVar(operationOnArrayElement, f, ld, arrayElementInfo);
        }

        public final void checkDataFlowComplexity(@NotNull AbstractInsnNode i) {
            Intrinsics.checkNotNullParameter((Object)i, (String)"i");
            AbstractInsnNode abstractInsnNode = i;
            if (abstractInsnNode instanceof MethodInsnNode) {
                Void void_ = AbortKt.abort("No method invocations are allowed for calculation of an array element index at the point of loading the reference to this element.\nExtract index calculation to the local variable.", i);
                throw new KotlinNothingValueException();
            }
            if (!(abstractInsnNode instanceof LdcInsnNode)) {
                switch (i.getOpcode()) {
                    case 96: 
                    case 100: 
                    case 104: 
                    case 108: 
                    case 112: 
                    case 120: 
                    case 122: 
                    case 124: 
                    case 126: 
                    case 128: 
                    case 130: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 21: 
                    case 46: {
                        break;
                    }
                    case 178: 
                    case 180: {
                        break;
                    }
                    default: {
                        Void void_ = AbortKt.abort("Complex data flow is not allowed for calculation of an array element index at the point of loading the reference to this element.\nExtract index calculation to the local variable.", i);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }

        private final AbstractInsnNode putPrimitiveTypeWrapper(MethodInsnNode factoryInsn, AbstractInsnNode initStart, FieldInfo f, FieldInsnNode next) {
            Type factoryArg;
            Type type = Type.getMethodType((String)factoryInsn.desc);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getMethodType(factoryInsn.desc)");
            Type type2 = factoryArg = type.getArgumentTypes()[0];
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"factoryArg");
            this.generateRefVolatileClass(f, type2);
            AbstractInsnNode afterPutStatic = next.getNext();
            this.instructions.remove((AbstractInsnNode)factoryInsn);
            this.instructions.remove((AbstractInsnNode)next);
            AbstractInsnNode abstractInsnNode = afterPutStatic;
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"afterPutStatic");
            this.initRefVolatile(f, factoryArg, initStart, abstractInsnNode);
            return afterPutStatic;
        }

        private final AbstractInsnNode putJucaAtomicArray(MethodInsnNode arrayfactoryInsn, AbstractInsnNode initStart, FieldInfo f, FieldInsnNode next) {
            String jucaAtomicArrayDesc = f.getTypeInfo().getFuType().getDescriptor();
            if (initStart.getOpcode() == 187) {
                AbstractInsnNode abstractInsnNode = initStart;
                if (abstractInsnNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.TypeInsnNode");
                }
                TypeInsnNode typeInsnNode = (TypeInsnNode)abstractInsnNode;
                String string = jucaAtomicArrayDesc;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jucaAtomicArrayDesc");
                typeInsnNode.desc = AtomicFUTransformer.this.descToName(string);
                arrayfactoryInsn.owner = AtomicFUTransformer.this.descToName(jucaAtomicArrayDesc);
            } else {
                String string = jucaAtomicArrayDesc;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jucaAtomicArrayDesc");
                TypeInsnNode newInsn = new TypeInsnNode(187, AtomicFUTransformer.this.descToName(string));
                this.instructions.insert(initStart.getPrevious(), (AbstractInsnNode)newInsn);
                this.instructions.insert((AbstractInsnNode)newInsn, (AbstractInsnNode)new InsnNode(89));
                MethodInsnNode jucaArrayFactory = new MethodInsnNode(183, AtomicFUTransformer.this.descToName(jucaAtomicArrayDesc), "<init>", "(I)V", false);
                this.instructions.set((AbstractInsnNode)arrayfactoryInsn, (AbstractInsnNode)jucaArrayFactory);
            }
            next.desc = jucaAtomicArrayDesc;
            next.name = f.getName();
            AtomicFUTransformer.this.setTransformed(true);
            return next.getNext();
        }

        private final AbstractInsnNode putPureVhArray(MethodInsnNode arrayFactoryInsn, AbstractInsnNode initStart, FieldInfo f, FieldInsnNode next) {
            AbstractInsnNode abstractInsnNode;
            if (initStart.getOpcode() == 187) {
                this.instructions.remove(initStart.getNext());
                this.instructions.remove(initStart);
            }
            Type primitiveType = f.getPrimitiveType(this.vh);
            Integer primitiveElementType = (Integer)AtomicFUTransformerKt.access$getARRAY_ELEMENT_TYPE$p().get(f.getTypeInfo().getOriginalType());
            if (primitiveElementType != null) {
                abstractInsnNode = (AbstractInsnNode)new IntInsnNode(188, primitiveElementType.intValue());
            } else {
                Type type = primitiveType.getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"primitiveType.elementType");
                String string = type.getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"primitiveType.elementType.descriptor");
                abstractInsnNode = (AbstractInsnNode)new TypeInsnNode(189, AtomicFUTransformer.this.descToName(string));
            }
            AbstractInsnNode newArray = abstractInsnNode;
            this.instructions.set((AbstractInsnNode)arrayFactoryInsn, newArray);
            next.desc = primitiveType.getDescriptor();
            next.name = f.getName();
            AtomicFUTransformer.this.setTransformed(true);
            return next.getNext();
        }

        private final AbstractInsnNode removeTraceInit(MethodInsnNode atomicFactory, boolean isArrayFactory) {
            AbstractInsnNode initStart = new FlowAnalyzer((AbstractInsnNode)atomicFactory).getInitStart(1);
            if (isArrayFactory) {
                return initStart;
            }
            AbstractInsnNode lastArg = atomicFactory.getPrevious();
            AbstractInsnNode valueArgInitLast = new FlowAnalyzer((AbstractInsnNode)atomicFactory).getValueArgInitLast();
            while (Intrinsics.areEqual((Object)lastArg, (Object)valueArgInitLast) ^ true) {
                AbstractInsnNode abstractInsnNode = lastArg;
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"lastArg");
                AbstractInsnNode prev = abstractInsnNode.getPrevious();
                this.instructions.remove(lastArg);
                lastArg = prev;
            }
            return initStart;
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode removeTraceAppend(AbstractInsnNode append) {
            void start;
            AbstractInsnNode afterAppend = append.getNext();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = append;
            Function1 isGetFieldTrace2 = (Function1)new Function1<AbstractInsnNode, Boolean>((Ref.ObjectRef)start){
                final /* synthetic */ Ref.ObjectRef $start;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    if (insn.getOpcode() != 180) return false;
                    AbstractInsnNode abstractInsnNode = (AbstractInsnNode)this.$start.element;
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
                    }
                    String string = ((FieldInsnNode)abstractInsnNode).desc;
                    Type type = Type.getObjectType((String)"kotlinx/atomicfu/TraceBase");
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(TRACE_BASE_CLS)");
                    if (!Intrinsics.areEqual((Object)string, (Object)type.getDescriptor())) return false;
                    return true;
                }
                {
                    this.$start = objectRef;
                    super(1);
                }
            };
            Function1 isTraceAccessor2 = (Function1)new Function1<AbstractInsnNode, Boolean>(this){
                final /* synthetic */ TransformerMV this$0;

                public final boolean invoke(@NotNull AbstractInsnNode insn) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    if (insn instanceof MethodInsnNode) {
                        String string = ((MethodInsnNode)insn).owner;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"insn.owner");
                        String string2 = ((MethodInsnNode)insn).name;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"insn.name");
                        String string3 = ((MethodInsnNode)insn).desc;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"insn.desc");
                        MethodId methodId = new MethodId(string, string2, string3, ((MethodInsnNode)insn).getOpcode());
                        bl = AtomicFUTransformer.access$getTraceAccessors$p(this.this$0.AtomicFUTransformer.this).contains(methodId);
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.this$0 = transformerMV;
                    super(1);
                }
            };
            while (!((Boolean)isGetFieldTrace2.invoke((Object)((AbstractInsnNode)start.element))).booleanValue() && !((Boolean)isTraceAccessor2.invoke((Object)((AbstractInsnNode)start.element))).booleanValue()) {
                Intrinsics.checkNotNullExpressionValue((Object)((AbstractInsnNode)start.element).getPrevious(), (String)"start.previous");
                start.element = start.element;
            }
            if (((Boolean)isTraceAccessor2.invoke((Object)((AbstractInsnNode)start.element))).booleanValue()) {
                AbstractInsnNode abstractInsnNode = ((AbstractInsnNode)start.element).getPrevious();
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"start.previous");
                this.instructions.remove(abstractInsnNode.getPrevious());
                this.instructions.remove(((AbstractInsnNode)start.element).getPrevious());
            } else {
                this.instructions.remove(((AbstractInsnNode)start.element).getPrevious());
            }
            while (Intrinsics.areEqual((Object)((AbstractInsnNode)start.element), (Object)afterAppend) ^ true) {
                if ((AbstractInsnNode)start.element instanceof VarInsnNode) {
                    this.localVariables.removeIf(new Predicate((Ref.ObjectRef)start){
                        final /* synthetic */ Ref.ObjectRef $start;

                        public final boolean test(LocalVariableNode it) {
                            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)this.$start.element;
                            if (abstractInsnNode == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.VarInsnNode");
                            }
                            return it.index == ((VarInsnNode)abstractInsnNode).var;
                        }
                        {
                            this.$start = objectRef;
                        }
                    });
                }
                AbstractInsnNode next = ((AbstractInsnNode)start.element).getNext();
                this.instructions.remove((AbstractInsnNode)start.element);
                Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
                start.element = start.element;
            }
            return afterAppend;
        }

        private final AbstractInsnNode transform(AbstractInsnNode i) {
            AbstractInsnNode abstractInsnNode = i;
            if (abstractInsnNode instanceof MethodInsnNode) {
                String putfield2;
                Map argsSize2;
                String string = ((MethodInsnNode)i).owner;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"i.owner");
                String string2 = ((MethodInsnNode)i).name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"i.name");
                String string3 = ((MethodInsnNode)i).desc;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"i.desc");
                MethodId methodId = new MethodId(string, string2, string3, ((MethodInsnNode)i).getOpcode());
                if (AtomicFUTransformerKt.access$getFACTORIES$p().contains(methodId)) {
                    boolean bl;
                    Object object;
                    if (Intrinsics.areEqual((Object)this.name, (Object)"<init>") ^ true && Intrinsics.areEqual((Object)this.name, (Object)"<clinit>") ^ true) {
                        Void void_ = AbortKt.abort$default("factory " + methodId + " is used outside of constructor or class initialisation", null, 2, null);
                        throw new KotlinNothingValueException();
                    }
                    AbstractInsnNode next = AsmUtilKt.getNextUseful(i);
                    AbstractInsnNode abstractInsnNode2 = next;
                    if (!(abstractInsnNode2 instanceof FieldInsnNode)) {
                        abstractInsnNode2 = null;
                    }
                    if ((object = (FieldInsnNode)abstractInsnNode2) == null || (object = AtomicFUTransformer.this.checkPutFieldOrPutStatic(object)) == null) {
                        Void void_ = AbortKt.abort$default("factory " + methodId + " invocation must be followed by putfield", null, 2, null);
                        throw new KotlinNothingValueException();
                    }
                    Object fieldId = object;
                    Object v = AtomicFUTransformer.this.fields.get(fieldId);
                    Intrinsics.checkNotNull(v);
                    FieldInfo f = (FieldInfo)v;
                    TypeInfo typeInfo = (TypeInfo)AtomicFUTransformerKt.access$getAFU_CLASSES$p().get(((MethodInsnNode)i).owner);
                    if (typeInfo != null) {
                        TypeInfo typeInfo2;
                        TypeInfo it = typeInfo2 = typeInfo;
                        boolean bl2 = false;
                        bl = it.getOriginalType().getSort() == 9;
                    } else {
                        bl = false;
                    }
                    boolean isArray = bl;
                    AbstractInsnNode newInitStart = this.removeTraceInit((MethodInsnNode)i, isArray);
                    if (!this.vh && f.isStatic() && !f.isArray()) {
                        return this.putPrimitiveTypeWrapper((MethodInsnNode)i, newInitStart, f, (FieldInsnNode)next);
                    }
                    if (f.isArray()) {
                        return this.vh ? this.putPureVhArray((MethodInsnNode)i, newInitStart, f, (FieldInsnNode)next) : this.putJucaAtomicArray((MethodInsnNode)i, newInitStart, f, (FieldInsnNode)next);
                    }
                    this.instructions.remove(i);
                    AtomicFUTransformer.this.setTransformed(true);
                    Type primitiveType = f.getPrimitiveType(this.vh);
                    ((FieldInsnNode)next).desc = primitiveType.getDescriptor();
                    ((FieldInsnNode)next).name = f.getName();
                    return ((FieldInsnNode)next).getNext();
                }
                Map next = AtomicFUTransformer.this.accessors;
                if (next.containsKey(methodId)) {
                    String string4;
                    Object v = AtomicFUTransformer.this.accessors.get(methodId);
                    Intrinsics.checkNotNull(v);
                    FieldInfo f = (FieldInfo)v;
                    String string5 = f.getOwner();
                    String string6 = f.getFuName();
                    if (this.vh) {
                        Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
                        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"VH_TYPE");
                        string4 = type.getDescriptor();
                    } else {
                        string4 = f.getFuType().getDescriptor();
                    }
                    FieldInsnNode j = new FieldInsnNode(178, string5, string6, string4);
                    if (!this.vh && f.isArray()) {
                        j.setOpcode(!f.isStatic() ? 180 : 178);
                        j.name = f.getName();
                    }
                    this.instructions.set(i, (AbstractInsnNode)j);
                    if (this.vh && f.isArray()) {
                        return this.insertPureVhArray(j, f);
                    }
                    AtomicFUTransformer.this.setTransformed(true);
                    return this.fixupLoadedAtomicVar(f, j);
                }
                if (Intrinsics.areEqual((Object)methodId, (Object)AtomicFUTransformerKt.access$getTRACE_FACTORY$p()) || Intrinsics.areEqual((Object)methodId, (Object)AtomicFUTransformerKt.access$getTRACE_PARTIAL_ARGS_FACTORY$p())) {
                    AbstractInsnNode putfield2;
                    if (Intrinsics.areEqual((Object)methodId, (Object)AtomicFUTransformerKt.access$getTRACE_FACTORY$p())) {
                        AbstractInsnNode checkcastTraceFormat = i;
                        while (checkcastTraceFormat.getOpcode() != 192) {
                            Intrinsics.checkNotNullExpressionValue((Object)checkcastTraceFormat.getPrevious(), (String)"checkcastTraceFormat.previous");
                        }
                        AbstractInsnNode astoreTraceFormat = checkcastTraceFormat.getNext();
                        AbstractInsnNode tranceFormatInitStart = new FlowAnalyzer(checkcastTraceFormat.getPrevious()).getInitStart(1).getPrevious();
                        AbstractInsnNode initInsn = checkcastTraceFormat;
                        while (Intrinsics.areEqual((Object)initInsn, (Object)tranceFormatInitStart) ^ true) {
                            AbstractInsnNode prev = initInsn.getPrevious();
                            this.instructions.remove(initInsn);
                            Intrinsics.checkNotNullExpressionValue((Object)prev, (String)"prev");
                        }
                        this.instructions.insertBefore(astoreTraceFormat, (AbstractInsnNode)new InsnNode(1));
                    }
                    Type type = Type.getMethodType((String)methodId.getDesc());
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getMethodType(methodId.desc)");
                    int argsSize2 = type.getArgumentTypes().length;
                    AbstractInsnNode abstractInsnNode3 = putfield2 = ((MethodInsnNode)i).getNext();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode3, (String)"putfield");
                    AbstractInsnNode next2 = abstractInsnNode3.getNext();
                    int depth = ((MethodInsnNode)i).getOpcode() == 183 ? 2 : argsSize2;
                    AbstractInsnNode initStart = new FlowAnalyzer(((MethodInsnNode)i).getPrevious()).getInitStart(depth).getPrevious();
                    AbstractInsnNode lastArg = i;
                    while (Intrinsics.areEqual((Object)lastArg, (Object)initStart) ^ true) {
                        AbstractInsnNode prev = lastArg.getPrevious();
                        this.instructions.remove(lastArg);
                        Intrinsics.checkNotNullExpressionValue((Object)prev, (String)"prev");
                    }
                    this.instructions.remove(initStart);
                    this.instructions.remove(putfield2);
                    return next2;
                }
                if (Intrinsics.areEqual((Object)methodId, (Object)AtomicFUTransformerKt.access$getTRACE_APPEND$p()) || Intrinsics.areEqual((Object)methodId, (Object)AtomicFUTransformerKt.access$getTRACE_APPEND_2$p()) || Intrinsics.areEqual((Object)methodId, (Object)AtomicFUTransformerKt.access$getTRACE_APPEND_3$p()) || Intrinsics.areEqual((Object)methodId, (Object)AtomicFUTransformerKt.access$getTRACE_APPEND_4$p())) {
                    return this.removeTraceAppend(i);
                }
                if (AtomicFUTransformer.this.removeMethods.contains(methodId)) {
                    Void void_ = AbortKt.abort("invocation of method " + methodId + " on atomic types. " + "Make the latter method 'inline' to use it", i);
                    throw new KotlinNothingValueException();
                }
                if (((MethodInsnNode)i).getOpcode() == 182 && (argsSize2 = AtomicFUTransformerKt.access$getAFU_CLASSES$p()).containsKey(putfield2 = ((MethodInsnNode)i).owner)) {
                    Void void_ = AbortKt.abort("standalone invocation of " + methodId + " that was not traced to previous field load", i);
                    throw new KotlinNothingValueException();
                }
            } else if (abstractInsnNode instanceof FieldInsnNode) {
                Map argsSize2;
                String string = ((FieldInsnNode)i).owner;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"i.owner");
                String string7 = ((FieldInsnNode)i).name;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"i.name");
                String string8 = ((FieldInsnNode)i).desc;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"i.desc");
                FieldId fieldId = new FieldId(string, string7, string8);
                if ((((FieldInsnNode)i).getOpcode() == 180 || ((FieldInsnNode)i).getOpcode() == 178) && (argsSize2 = AtomicFUTransformer.this.fields).containsKey(fieldId)) {
                    String string9;
                    boolean isArray;
                    FieldInsnNode fieldInsnNode;
                    AbstractInsnNode abstractInsnNode4;
                    if (AtomicFUTransformer.this.isFieldDelegate(fieldId)) {
                        AbstractInsnNode abstractInsnNode5 = ((FieldInsnNode)i).getNext();
                        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode5, (String)"i.next");
                        if (abstractInsnNode5.getOpcode() == 58) {
                            return this.transformDelegatedFieldAccessor((FieldInsnNode)i, fieldId);
                        }
                    }
                    if (!((abstractInsnNode4 = ((FieldInsnNode)i).getNext()) instanceof FieldInsnNode)) {
                        abstractInsnNode4 = null;
                    }
                    if ((fieldInsnNode = (FieldInsnNode)abstractInsnNode4) != null && (fieldInsnNode = this.checkCopyToDelegate(fieldInsnNode)) != null) {
                        Map it = argsSize2 = fieldInsnNode;
                        boolean bl = false;
                        return it;
                    }
                    Object v = AtomicFUTransformer.this.fields.get(fieldId);
                    Intrinsics.checkNotNull(v);
                    FieldInfo f = (FieldInfo)v;
                    boolean bl = isArray = f.getPrimitiveType(this.vh).getSort() == 9;
                    if (!isArray || this.vh) {
                        if (Intrinsics.areEqual((Object)((FieldInsnNode)i).desc, (Object)f.getFieldType().getDescriptor()) ^ true) {
                            return ((FieldInsnNode)i).getNext();
                        }
                        ((FieldInsnNode)i).setOpcode(178);
                        ((FieldInsnNode)i).name = f.getFuName();
                    }
                    if (!this.vh && isArray && f.getHasExternalAccess()) {
                        ((FieldInsnNode)i).name = f.getName();
                    }
                    FieldInsnNode fieldInsnNode2 = (FieldInsnNode)i;
                    if (this.vh) {
                        Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
                        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"VH_TYPE");
                        string9 = type.getDescriptor();
                    } else {
                        string9 = f.getFuType().getDescriptor();
                    }
                    fieldInsnNode2.desc = string9;
                    AbstractInsnNode prev = ((FieldInsnNode)i).getPrevious();
                    if (this.vh && f.getPrimitiveType(this.vh).getSort() == 9) {
                        return AsmUtilKt.getInsnOrNull(prev, this.insertPureVhArray((FieldInsnNode)i, f), (Function1<? super AbstractInsnNode, Boolean>)((Function1)new Function1<AbstractInsnNode, Boolean>(this){
                            final /* synthetic */ TransformerMV this$0;

                            public final boolean invoke(@NotNull AbstractInsnNode it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return TransformerMV.access$isAtomicGetFieldOrGetStatic(this.this$0, it);
                            }
                            {
                                this.this$0 = transformerMV;
                                super(1);
                            }
                        }));
                    }
                    AtomicFUTransformer.this.setTransformed(true);
                    return AsmUtilKt.getInsnOrNull(prev, this.fixupLoadedAtomicVar(f, (FieldInsnNode)i), (Function1<? super AbstractInsnNode, Boolean>)((Function1)new Function1<AbstractInsnNode, Boolean>(this){
                        final /* synthetic */ TransformerMV this$0;

                        public final boolean invoke(@NotNull AbstractInsnNode it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return TransformerMV.access$isAtomicGetFieldOrGetStatic(this.this$0, it);
                        }
                        {
                            this.this$0 = transformerMV;
                            super(1);
                        }
                    }));
                }
            }
            return i.getNext();
        }

        private final AbstractInsnNode transformDelegatedFieldAccessor(FieldInsnNode i, FieldId fieldId) {
            Object v = AtomicFUTransformer.this.fieldDelegates.get(fieldId);
            Intrinsics.checkNotNull(v);
            FieldInfo f = (FieldInfo)v;
            AbstractInsnNode abstractInsnNode = i.getNext();
            if (abstractInsnNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.VarInsnNode");
            }
            int v2 = ((VarInsnNode)abstractInsnNode).var;
            AbstractInsnNode abstractInsnNode2 = i.getNext();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode2, (String)"i.next");
            AbstractInsnNode cur = abstractInsnNode2;
            while (!(cur instanceof VarInsnNode) || ((VarInsnNode)cur).getOpcode() != 25 || ((VarInsnNode)cur).var != v2) {
                AbstractInsnNode next = cur.getNext();
                this.instructions.remove(cur);
                Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
            }
            AbstractInsnNode iv = new FlowAnalyzer(((VarInsnNode)cur).getNext()).execute();
            boolean bl = this.isAtomicGetValueOrSetValue(iv);
            if (!bl) {
                boolean bl2 = false;
                String string = "Aload of the field delegate " + f + " should be followed with Atomic*.getValue()/setValue() invocation";
                throw new IllegalStateException(string.toString());
            }
            AbstractInsnNode abstractInsnNode3 = iv;
            if (abstractInsnNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.MethodInsnNode");
            }
            boolean isGetter = Intrinsics.areEqual((Object)((MethodInsnNode)abstractInsnNode3).name, (Object)"getValue");
            this.instructions.remove(cur);
            this.localVariables.removeIf(new Predicate(this, f, isGetter){
                final /* synthetic */ TransformerMV this$0;
                final /* synthetic */ FieldInfo $f;
                final /* synthetic */ boolean $isGetter;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean test(LocalVariableNode it) {
                    Type type = Type.getType((String)it.desc);
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(it.desc)");
                    if (Intrinsics.areEqual((Object)type.getInternalName(), (Object)this.$f.getOwner())) return false;
                    if (this.$isGetter) return true;
                    Type type2 = Type.getType((String)it.desc);
                    Type type3 = Type.getType((String)this.this$0.desc);
                    Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getType(desc)");
                    Object[] objectArray = type3.getArgumentTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getType(desc).argumentTypes");
                    if (!Intrinsics.areEqual((Object)type2, (Object)((Type)ArraysKt.first((Object[])objectArray)))) return true;
                    if (Intrinsics.areEqual((Object)it.name, (Object)"<set-?>")) return false;
                    return true;
                }
                {
                    this.this$0 = transformerMV;
                    this.$f = fieldInfo;
                    this.$isGetter = bl;
                }
            });
            return this.getPureTypeField(i, f, (MethodInsnNode)iv);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAtomicGetFieldOrGetStatic(AbstractInsnNode $this$isAtomicGetFieldOrGetStatic) {
            if (!($this$isAtomicGetFieldOrGetStatic instanceof FieldInsnNode)) return false;
            if (((FieldInsnNode)$this$isAtomicGetFieldOrGetStatic).getOpcode() != 180) {
                if (((FieldInsnNode)$this$isAtomicGetFieldOrGetStatic).getOpcode() != 178) return false;
            }
            Map map = AtomicFUTransformer.this.fields;
            String string = ((FieldInsnNode)$this$isAtomicGetFieldOrGetStatic).owner;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner");
            String string2 = ((FieldInsnNode)$this$isAtomicGetFieldOrGetStatic).name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            String string3 = ((FieldInsnNode)$this$isAtomicGetFieldOrGetStatic).desc;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
            FieldId fieldId = new FieldId(string, string2, string3);
            if (!map.containsKey(fieldId)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAtomicGetValueOrSetValue(AbstractInsnNode $this$isAtomicGetValueOrSetValue) {
            if (!AsmUtilKt.isInvokeVirtual($this$isAtomicGetValueOrSetValue)) return false;
            Map map = AtomicFUTransformerKt.access$getAFU_TYPES$p();
            AbstractInsnNode abstractInsnNode = $this$isAtomicGetValueOrSetValue;
            if (abstractInsnNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.MethodInsnNode");
            }
            Type type = Type.getObjectType((String)((MethodInsnNode)abstractInsnNode).owner);
            if (!map.containsKey(type)) return false;
            if (Intrinsics.areEqual((Object)((MethodInsnNode)$this$isAtomicGetValueOrSetValue).name, (Object)"getValue")) return true;
            if (!Intrinsics.areEqual((Object)((MethodInsnNode)$this$isAtomicGetValueOrSetValue).name, (Object)"setValue")) return false;
            return true;
        }

        private final AbstractInsnNode insertPureVhArray(FieldInsnNode getVarHandleInsn, FieldInfo f) {
            FieldInsnNode getPureArray = new FieldInsnNode(180, f.getOwner(), f.getName(), f.getPrimitiveType(this.vh).getDescriptor());
            if (!f.isStatic()) {
                InsnNode swap = new InsnNode(95);
                this.instructions.insert((AbstractInsnNode)getVarHandleInsn, (AbstractInsnNode)swap);
                this.instructions.insert((AbstractInsnNode)swap, (AbstractInsnNode)getPureArray);
            } else {
                getPureArray.setOpcode(178);
                this.instructions.insert((AbstractInsnNode)getVarHandleInsn, (AbstractInsnNode)getPureArray);
            }
            AtomicFUTransformer.this.setTransformed(true);
            return this.fixupLoadedAtomicVar(f, getPureArray);
        }

        private final void generateRefVolatileClass(FieldInfo f, Type arg) {
            MethodVisitor cons;
            if (this.analyzePhase2) {
                return;
            }
            ClassWriter cw = new ClassWriter(0);
            int visibility = f.getHasExternalAccess() ? 1 : 0;
            cw.visit(50, visibility | 0x1000, f.getRefVolatileClassName(), null, "java/lang/Object", null);
            MethodVisitor methodVisitor = cons = cw.visitMethod(1, "<init>", '(' + arg.getDescriptor() + ")V", null, null);
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"cons");
            MethodVisitor mv$iv = methodVisitor;
            boolean $i$f$code = false;
            InstructionAdapter $this$code = new InstructionAdapter(mv$iv);
            boolean bl = false;
            $this$code.visitVarInsn(25, 0);
            $this$code.invokespecial("java/lang/Object", "<init>", "()V", false);
            $this$code.visitVarInsn(25, 0);
            $this$code.load(1, arg);
            $this$code.putfield(f.getRefVolatileClassName(), f.getName(), f.getPrimitiveType(this.vh).getDescriptor());
            $this$code.visitInsn(177);
            $this$code.visitMaxs(3, 3);
            cw.visitField(visibility | 0x40, f.getName(), f.getPrimitiveType(this.vh).getDescriptor(), null, null);
            File genFile = AtomicFUTransformer.this.div(AtomicFUTransformer.this.getOutputDir(), f.getRefVolatileClassName() + ".class");
            byte[] byArray = cw.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cw.toByteArray()");
            AtomicFUTransformer.this.mkdirsAndWrite(genFile, byArray);
        }

        private final void initRefVolatile(FieldInfo f, Type argType, AbstractInsnNode firstInitInsn, AbstractInsnNode lastInitInsn) {
            TypeInsnNode typeInsnNode = new TypeInsnNode(187, f.getRefVolatileClassName());
            InsnNode dup = new InsnNode(89);
            this.instructions.insertBefore(firstInitInsn, (AbstractInsnNode)typeInsnNode);
            this.instructions.insertBefore(firstInitInsn, (AbstractInsnNode)dup);
            MethodInsnNode invokespecial = new MethodInsnNode(183, f.getRefVolatileClassName(), "<init>", '(' + argType.getDescriptor() + ")V", false);
            String string = f.getOwner();
            String string2 = f.getStaticRefVolatileField();
            Type type = Type.getObjectType((String)f.getRefVolatileClassName());
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(f.refVolatileClassName)");
            FieldInsnNode putstatic = new FieldInsnNode(179, string, string2, type.getDescriptor());
            this.instructions.insertBefore(lastInitInsn, (AbstractInsnNode)invokespecial);
            this.instructions.insert((AbstractInsnNode)invokespecial, (AbstractInsnNode)putstatic);
        }

        public TransformerMV(AtomicFUTransformerBase.SourceInfo sourceInfo, @NotNull int access, @NotNull String name, @Nullable String desc, @Nullable String signature, @Nullable String[] exceptions, @NotNull MethodVisitor mv, String packageName, boolean vh, boolean analyzePhase2) {
            Intrinsics.checkNotNullParameter((Object)sourceInfo, (String)"sourceInfo");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            super(589824, access, name, desc, signature, exceptions);
            this.packageName = packageName;
            this.vh = vh;
            this.analyzePhase2 = analyzePhase2;
            this.mv = mv;
            this.sourceInfo = AtomicFUTransformerBase.SourceInfo.copy$default(sourceInfo, null, null, null, this.instructions, 7, null);
        }

        public static final /* synthetic */ boolean access$isAtomicGetFieldOrGetStatic(TransformerMV $this, AbstractInsnNode $this$access_u24isAtomicGetFieldOrGetStatic) {
            return $this.isAtomicGetFieldOrGetStatic($this$access_u24isAtomicGetFieldOrGetStatic);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0014\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CW;", "Lorg/objectweb/asm/ClassWriter;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;)V", "getCommonSuperClass", "", "type1", "type2", "atomicfu-transformer"})
    private final class CW
    extends ClassWriter {
        @NotNull
        protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)type1, (String)"type1");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type2");
            Class c = AtomicFUTransformer.this.loadClass(type1);
            Class d = AtomicFUTransformer.this.loadClass(type2);
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                string = "java/lang/Object";
            } else {
                do {
                    Intrinsics.checkNotNullExpressionValue(c.getSuperclass(), (String)"c.superclass");
                } while (!c.isAssignableFrom(d));
                String string2 = c.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"c.name");
                string = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
            return string;
        }

        public CW() {
            super(3);
        }
    }
}

