/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.transformer;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.transformer.AbortKt;
import kotlinx.atomicfu.transformer.AtomicFUTransformerBase;
import kotlinx.atomicfu.transformer.AtomicFUTransformerJS;
import kotlinx.atomicfu.transformer.AtomicFUTransformerJSKt;
import kotlinx.atomicfu.transformer.EmptyLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0007%&'()*+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\b*\u00020\u0015H\u0002J*\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u0018*\u00020\u0003H\u0002J\f\u0010\u001f\u001a\u00020\u0018*\u00020\u0015H\u0002J\f\u0010 \u001a\u00020\b*\u00020!H\u0002J\f\u0010\"\u001a\u00020\b*\u00020\u0015H\u0002J\u0014\u0010#\u001a\u00020\u0010*\u00020\u00192\u0006\u0010$\u001a\u00020\bH\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase;", "inputDir", "Ljava/io/File;", "outputDir", "(Ljava/io/File;Ljava/io/File;)V", "atomicArrayConstructors", "", "", "atomicConstructors", "", "delegatedProperties", "fieldDelegates", "traceConstructors", "traceFormatObjects", "transform", "", "transformFile", "", "file", "eraseAtomicFieldFromUncheckedCast", "Lorg/mozilla/javascript/ast/AstNode;", "eraseGetValue", "inlineAtomicOperation", "", "Lorg/mozilla/javascript/ast/FunctionCall;", "funcName", "field", "args", "", "isJsFile", "isThisNode", "resolvePropName", "Lorg/mozilla/javascript/ast/PropertyGet;", "scopedSource", "setImpl", "code", "AtomicConstructorDetector", "AtomicOperationsInliner", "DelegatedPropertyAccessorsVisitor", "DependencyEraser", "FieldDelegatesVisitor", "ReceiverResolver", "TransformVisitor", "atomicfu-transformer"})
public final class AtomicFUTransformerJS
extends AtomicFUTransformerBase {
    private final Set<String> atomicConstructors;
    private final Map<String, String> fieldDelegates;
    private final Map<String, String> delegatedProperties;
    private final Map<String, String> atomicArrayConstructors;
    private final Set<String> traceConstructors;
    private final Set<String> traceFormatObjects;

    @Override
    public void transform() {
        AtomicFUTransformerBase.info$default(this, "Transforming to " + this.getOutputDir(), null, 2, null);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)this.getInputDir(), null, (int)1, null)), (Function1)transform.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] byArray;
            File file = (File)element$iv;
            boolean bl = false;
            if (this.isJsFile(file)) {
                String string = "Transforming file: " + file.getCanonicalPath();
                System.out.println((Object)string);
                byArray = this.transformFile(file);
            } else {
                byArray = FilesKt.readBytes((File)file);
            }
            byte[] outBytes = byArray;
            this.mkdirsAndWrite(this.toOutputFile(file), outBytes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJsFile(File $this$isJsFile) {
        String string = $this$isJsFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)".js", (boolean)false, (int)2, null)) return false;
        String string2 = $this$isJsFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        if (StringsKt.endsWith$default((String)string2, (String)".meta.js", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final byte[] transformFile(File file) {
        Parser p = new Parser(new CompilerEnvirons());
        AstRoot root = p.parse((Reader)new FileReader(file), null, 0);
        root.visit((NodeVisitor)new DependencyEraser());
        root.visit((NodeVisitor)new AtomicConstructorDetector());
        root.visit((NodeVisitor)new FieldDelegatesVisitor());
        root.visit((NodeVisitor)new DelegatedPropertyAccessorsVisitor());
        root.visit((NodeVisitor)new TransformVisitor());
        root.visit((NodeVisitor)new AtomicOperationsInliner());
        AstRoot astRoot = root;
        Intrinsics.checkNotNullExpressionValue((Object)astRoot, (String)"root");
        String string = this.eraseGetValue((AstNode)astRoot);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    private final String eraseGetValue(AstNode $this$eraseGetValue) {
        Function1 function1;
        CharSequence charSequence;
        String res = $this$eraseGetValue.toSource();
        Regex primitiveGetValue = AtomicFUTransformerJSKt.access$getMANGLE_VALUE_REGEX$p();
        Regex arrayGetElement = AtomicFUTransformerJSKt.access$getARRAY_GET_ELEMENT_REGEX$p();
        while (true) {
            String string = res;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res");
            charSequence = string;
            if (!arrayGetElement.containsMatchIn(charSequence)) break;
            charSequence = res;
            function1 = eraseGetValue.1.INSTANCE;
            res = arrayGetElement.replace(charSequence, function1);
        }
        charSequence = res;
        function1 = eraseGetValue.2.INSTANCE;
        return primitiveGetValue.replace(charSequence, function1);
    }

    private final AstNode eraseAtomicFieldFromUncheckedCast(AstNode $this$eraseAtomicFieldFromUncheckedCast) {
        if ($this$eraseAtomicFieldFromUncheckedCast instanceof ParenthesizedExpression && ((ParenthesizedExpression)$this$eraseAtomicFieldFromUncheckedCast).getExpression() instanceof ConditionalExpression) {
            AstNode astNode = ((ParenthesizedExpression)$this$eraseAtomicFieldFromUncheckedCast).getExpression();
            if (astNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.ConditionalExpression");
            }
            AstNode testExpression = ((ConditionalExpression)astNode).getTestExpression();
            if (testExpression instanceof FunctionCall && Intrinsics.areEqual((Object)((FunctionCall)testExpression).getTarget().toSource(), (Object)"Kotlin.isType")) {
                AstNode typeToCast;
                AstNode astNode2 = typeToCast = (AstNode)((FunctionCall)testExpression).getArguments().get(1);
                if (astNode2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.Name");
                }
                if (Intrinsics.areEqual((Object)((Name)astNode2).getIdentifier(), (Object)"AtomicRef")) {
                    Object e = ((FunctionCall)testExpression).getArguments().get(0);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                    }
                    return ((Assignment)e).getRight();
                }
            }
        }
        return null;
    }

    private final boolean isThisNode(AstNode $this$isThisNode) {
        boolean bl;
        AstNode astNode = $this$isThisNode;
        if (astNode instanceof PropertyGet) {
            AstNode astNode2 = ((PropertyGet)$this$isThisNode).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)astNode2, (String)"target");
            bl = this.isThisNode(astNode2);
        } else if (astNode instanceof FunctionCall) {
            AstNode astNode3 = ((FunctionCall)$this$isThisNode).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)astNode3, (String)"target");
            bl = this.isThisNode(astNode3);
        } else {
            bl = $this$isThisNode.getType() == 43;
        }
        return bl;
    }

    private final String resolvePropName(PropertyGet $this$resolvePropName) {
        String string;
        AstNode target = $this$resolvePropName.getTarget();
        if (target instanceof PropertyGet) {
            string = this.resolvePropName((PropertyGet)target) + '.' + $this$resolvePropName.getProperty().toSource();
        } else {
            String string2 = $this$resolvePropName.getProperty().toSource();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.toSource()");
        }
        return string;
    }

    private final String scopedSource(AstNode $this$scopedSource) {
        if (this.isThisNode($this$scopedSource)) {
            if ($this$scopedSource instanceof PropertyGet) {
                String property = this.resolvePropName((PropertyGet)$this$scopedSource);
                return "scope." + property;
            }
            if ($this$scopedSource instanceof FunctionCall && ((FunctionCall)$this$scopedSource).getTarget() instanceof PropertyGet) {
                if (((FunctionCall)$this$scopedSource).getTarget() instanceof PropertyGet) {
                    AstNode astNode = ((FunctionCall)$this$scopedSource).getTarget();
                    if (astNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                    }
                    String funcName = ((PropertyGet)astNode).getProperty().toSource();
                    Regex regex = new Regex("atomicfu\\$get");
                    String string = funcName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"funcName");
                    if (regex.matches((CharSequence)string)) {
                        AstNode astNode2 = ((FunctionCall)$this$scopedSource).getTarget();
                        if (astNode2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        }
                        String property = this.resolvePropName((PropertyGet)astNode2);
                        return "scope." + property + '(' + ((AstNode)((FunctionCall)$this$scopedSource).getArguments().get(0)).toSource() + ')';
                    }
                }
            } else if ($this$scopedSource.getType() == 43) {
                return "scope";
            }
        }
        String string = $this$scopedSource.toSource();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.toSource()");
        return string;
    }

    private final boolean inlineAtomicOperation(FunctionCall $this$inlineAtomicOperation, String funcName, AstNode field, List<? extends AstNode> args) {
        String code;
        String f = this.scopedSource(field);
        switch (funcName) {
            case "atomicfu$getAndSet": {
                String arg = args.get(0).toSource();
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + arg + "; return oldValue;})()";
                break;
            }
            case "atomicfu$compareAndSet": {
                String expected = this.scopedSource(args.get(0));
                String updated = this.scopedSource(args.get(1));
                String equals = Intrinsics.areEqual((Object)expected, (Object)"null") ? "==" : "===";
                String string = "(function(scope) {return " + f + ' ' + equals + ' ' + expected + " ? function() { " + f + " = " + updated + "; return true }() : false})()";
                break;
            }
            case "atomicfu$getAndIncrement": {
                String string = "(function(scope) {return " + f + "++;})()";
                break;
            }
            case "atomicfu$getAndIncrement$long": {
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".inc(); return oldValue;})()";
                break;
            }
            case "atomicfu$getAndDecrement": {
                String string = "(function(scope) {return " + f + "--;})()";
                break;
            }
            case "atomicfu$getAndDecrement$long": {
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".dec(); return oldValue;})()";
                break;
            }
            case "atomicfu$getAndAdd": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " += " + arg + "; return oldValue;})()";
                break;
            }
            case "atomicfu$getAndAdd$long": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".add(" + arg + "); return oldValue;})()";
                break;
            }
            case "atomicfu$addAndGet": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {" + f + " += " + arg + "; return " + f + ";})()";
                break;
            }
            case "atomicfu$addAndGet$long": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {" + f + " = " + f + ".add(" + arg + "); return " + f + ";})()";
                break;
            }
            case "atomicfu$incrementAndGet": {
                String string = "(function(scope) {return ++" + f + ";})()";
                break;
            }
            case "atomicfu$incrementAndGet$long": {
                String string = "(function(scope) {return " + f + " = " + f + ".inc();})()";
                break;
            }
            case "atomicfu$decrementAndGet": {
                String string = "(function(scope) {return --" + f + ";})()";
                break;
            }
            case "atomicfu$decrementAndGet$long": {
                String string = "(function(scope) {return " + f + " = " + f + ".dec();})()";
                break;
            }
            default: {
                String string = code = null;
            }
        }
        if (code != null) {
            this.setImpl($this$inlineAtomicOperation, code);
            return true;
        }
        return false;
    }

    private final void setImpl(FunctionCall $this$setImpl, String code) {
        AstRoot node;
        Parser p = new Parser(new CompilerEnvirons());
        AstRoot astRoot = node = p.parse(code, null, 0);
        Intrinsics.checkNotNullExpressionValue((Object)astRoot, (String)"node");
        if (astRoot.getFirstChild() != null) {
            AstRoot thisNode;
            AstNode expr;
            Node node2 = node.getFirstChild();
            if (node2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.ExpressionStatement");
            }
            AstNode astNode = expr = ((ExpressionStatement)node2).getExpression();
            if (astNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
            }
            $this$setImpl.setTarget(((FunctionCall)astNode).getTarget());
            AstRoot astRoot2 = thisNode = new Parser(new CompilerEnvirons()).parse("this", null, 0);
            Intrinsics.checkNotNullExpressionValue((Object)astRoot2, (String)"thisNode");
            Node node3 = astRoot2.getFirstChild();
            if (node3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.ExpressionStatement");
            }
            $this$setImpl.setArguments(CollectionsKt.listOf((Object)((ExpressionStatement)node3).getExpression()));
        }
    }

    public AtomicFUTransformerJS(@NotNull File inputDir, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        super(inputDir, outputDir);
        this.atomicConstructors = new LinkedHashSet();
        this.fieldDelegates = new LinkedHashMap();
        this.delegatedProperties = new LinkedHashMap();
        this.atomicArrayConstructors = new LinkedHashMap();
        this.traceConstructors = new LinkedHashSet();
        this.traceFormatObjects = new LinkedHashSet();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$DependencyEraser;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "isAtomicfuDependency", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "isAtomicfuModule", "visit", "atomicfu-transformer"})
    public final class DependencyEraser
    implements NodeVisitor {
        private final boolean isAtomicfuDependency(AstNode node) {
            return node.getType() == 41 && Intrinsics.areEqual((Object)node.toSource(), (Object)"'kotlinx-atomicfu'");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAtomicfuModule(AstNode node) {
            if (node.getType() != 39) return false;
            String string = node.toSource();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.toSource()");
            CharSequence charSequence = string;
            Regex regex = new Regex("\\$module\\$kotlinx_atomicfu");
            if (!regex.matches(charSequence)) return false;
            return true;
        }

        public boolean visit(@NotNull AstNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            switch (node.getType()) {
                case 66: {
                    List list = ((ArrayLiteral)node).getElements();
                    if (list == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<org.mozilla.javascript.ast.AstNode!>");
                    }
                    List elements = TypeIntrinsics.asMutableList((Object)list);
                    ListIterator it = elements.listIterator();
                    while (it.hasNext()) {
                        AstNode arg;
                        AstNode astNode = arg = (AstNode)it.next();
                        Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"arg");
                        if (!this.isAtomicfuDependency(astNode)) continue;
                        it.remove();
                    }
                    break;
                }
                case 110: {
                    if (!(node instanceof FunctionNode)) break;
                    ListIterator it = ((FunctionNode)node).getParams().listIterator();
                    while (it.hasNext()) {
                        Object e = it.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"it.next()");
                        if (!this.isAtomicfuModule((AstNode)e)) continue;
                        it.remove();
                    }
                    break;
                }
                case 38: {
                    if (!(node instanceof FunctionCall) || !Intrinsics.areEqual((Object)((FunctionCall)node).getTarget().toSource(), (Object)"factory")) break;
                    ListIterator it = ((FunctionCall)node).getArguments().listIterator();
                    while (it.hasNext()) {
                        AstNode arg;
                        AstNode astNode = arg = (AstNode)it.next();
                        Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"arg");
                        switch (astNode.getType()) {
                            case 36: {
                                AstNode astNode2 = ((ElementGet)arg).getElement();
                                Intrinsics.checkNotNullExpressionValue((Object)astNode2, (String)"(arg as ElementGet).element");
                                if (!this.isAtomicfuDependency(astNode2)) break;
                                it.remove();
                                break;
                            }
                            case 38: {
                                if (!Intrinsics.areEqual((Object)((FunctionCall)arg).getTarget().toSource(), (Object)"require")) break;
                                Object e = ((FunctionCall)arg).getArguments().get(0);
                                Intrinsics.checkNotNullExpressionValue(e, (String)"arg.arguments[0]");
                                if (!this.isAtomicfuDependency((AstNode)e)) break;
                                it.remove();
                            }
                        }
                    }
                    break;
                }
                case 36: {
                    AstNode enclosingNode;
                    AstNode astNode = ((ElementGet)node).getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"(node as ElementGet).element");
                    if (!this.isAtomicfuDependency(astNode)) break;
                    AstNode astNode3 = enclosingNode = ((ElementGet)node).getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode3, (String)"enclosingNode");
                    if (astNode3.getType() != 32) break;
                    AstNode astNode4 = enclosingNode.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode4, (String)"enclosingNode.parent");
                    AstNode astNode5 = astNode4.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode5, (String)"enclosingNode.parent.parent");
                    if (astNode5.getType() != 113) break;
                    AstNode astNode6 = enclosingNode.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode6, (String)"enclosingNode.parent");
                    AstNode astNode7 = astNode6.getParent();
                    if (astNode7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.IfStatement");
                    }
                    IfStatement ifStatement = (IfStatement)astNode7;
                    KeywordLiteral falseKeyword = new KeywordLiteral();
                    falseKeyword.setType(44);
                    ifStatement.setCondition((AstNode)falseKeyword);
                    Block oneLineBlock = new Block();
                    oneLineBlock.addStatement((AstNode)new EmptyLine());
                    ifStatement.setThenPart((AstNode)oneLineBlock);
                    break;
                }
                case 130: {
                    for (Node stmt : node) {
                        AstNode expr;
                        if (!(stmt instanceof ExpressionStatement) || !((expr = ((ExpressionStatement)stmt).getExpression()) instanceof Assignment) || !(((Assignment)expr).getLeft() instanceof ElementGet)) continue;
                        AstNode astNode = ((Assignment)expr).getLeft();
                        if (astNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.ElementGet");
                        }
                        AstNode astNode8 = ((ElementGet)astNode).getElement();
                        Intrinsics.checkNotNullExpressionValue((Object)astNode8, (String)"(expr.left as ElementGet).element");
                        if (!this.isAtomicfuDependency(astNode8)) continue;
                        node.replaceChild(stmt, (Node)new EmptyLine());
                    }
                    break;
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicConstructorDetector;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "kotlinxAtomicfuModuleName", "", "name", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class AtomicConstructorDetector
    implements NodeVisitor {
        private final String kotlinxAtomicfuModuleName(String name) {
            return "\\$module\\$kotlinx_atomicfu.kotlinx.atomicfu." + name;
        }

        public boolean visit(@Nullable AstNode node) {
            String initializer;
            Unit unit;
            Object it;
            PropertyGet propertyGet;
            Object object;
            Object varInit;
            if (node instanceof Block) {
                for (Object stmt : node) {
                    String initializer2;
                    if (!(stmt instanceof VariableDeclaration)) continue;
                    Object e = ((VariableDeclaration)stmt).getVariables().get(0);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.VariableInitializer");
                    }
                    varInit = (VariableInitializer)e;
                    if (!(varInit.getInitializer() instanceof PropertyGet)) continue;
                    String string = initializer2 = varInit.getInitializer().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"initializer");
                    CharSequence charSequence = string;
                    Regex regex = new Regex(this.kotlinxAtomicfuModuleName("((atomic\\$(ref|int|long|boolean)\\$|Atomic(Ref|Int|Long|Boolean))|(atomic\\$(ref|int|long|boolean)\\$1))"));
                    if (regex.matches(charSequence)) {
                        Set set = AtomicFUTransformerJS.this.atomicConstructors;
                        String string2 = varInit.getTarget().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"varInit.target.toSource()");
                        set.add(string2);
                        node.replaceChild(stmt, (Node)new EmptyLine());
                        continue;
                    }
                    charSequence = initializer2;
                    regex = new Regex(this.kotlinxAtomicfuModuleName("atomicfu\\$Trace"));
                    if (regex.matches(charSequence)) {
                        Set set = AtomicFUTransformerJS.this.traceConstructors;
                        String string3 = varInit.getTarget().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"varInit.target.toSource()");
                        set.add(string3);
                        node.replaceChild(stmt, (Node)new EmptyLine());
                        continue;
                    }
                    charSequence = initializer2;
                    regex = new Regex(this.kotlinxAtomicfuModuleName("(locks|atomicfu\\$TraceFormat|atomicfu\\$TraceBase|atomicfu\\$Trace\\$named)"));
                    if (!regex.matches(charSequence)) continue;
                    node.replaceChild(stmt, (Node)new EmptyLine());
                }
            }
            if (node instanceof PropertyGet) {
                Object stmt;
                String string = ((PropertyGet)node).getProperty().toSource();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.property.toSource()");
                stmt = string;
                object = new Regex("atomicfu\\$TraceFormat\\$format");
                if (object.matches((CharSequence)stmt)) {
                    AstNode target = ((PropertyGet)node).getTarget();
                    object = new Name();
                    varInit = object;
                    propertyGet = (PropertyGet)node;
                    boolean bl = false;
                    it.setIdentifier("emptyProperty");
                    unit = Unit.INSTANCE;
                    propertyGet.setProperty((Name)object);
                    if (target instanceof PropertyGet) {
                        String string4 = ((PropertyGet)target).getProperty().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"target.property.toSource()");
                        object = string4;
                        it = new Regex("prototype");
                        if (it.matches((CharSequence)object)) {
                            Set set = AtomicFUTransformerJS.this.traceFormatObjects;
                            String string5 = ((PropertyGet)target).getTarget().toSource();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"target.target.toSource()");
                            set.add(string5);
                        }
                    }
                }
            }
            if (node instanceof VariableInitializer && ((VariableInitializer)node).getInitializer() instanceof PropertyGet) {
                String string = initializer = ((VariableInitializer)node).getInitializer().toSource();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"initializer");
                object = string;
                it = new Regex("locks.atomicfu\\$reentrantLock");
                if (it.matches((CharSequence)object)) {
                    ((VariableInitializer)node).setInitializer((AstNode)null);
                }
                object = initializer;
                it = new Regex(this.kotlinxAtomicfuModuleName("((atomic\\$(ref|int|long|boolean)\\$|Atomic(Ref|Int|Long|Boolean))|(atomic\\$(ref|int|long|boolean)\\$1))"));
                if (it.matches((CharSequence)object)) {
                    Set set = AtomicFUTransformerJS.this.atomicConstructors;
                    String string6 = ((VariableInitializer)node).getTarget().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"node.target.toSource()");
                    set.add(string6);
                    ((VariableInitializer)node).setInitializer((AstNode)null);
                }
                object = initializer;
                it = new Regex(this.kotlinxAtomicfuModuleName("(atomicfu)\\$(Atomic(Ref|Int|Long|Boolean)Array)\\$(ref|int|long|boolean|ofNulls)"));
                if (it.matches((CharSequence)object)) {
                    String string7;
                    switch (StringsKt.substringAfterLast$default((String)initializer, (char)'$', null, (int)2, null)) {
                        case "int": {
                            string7 = "0";
                            break;
                        }
                        case "long": {
                            string7 = "0";
                            break;
                        }
                        case "boolean": {
                            string7 = "false";
                            break;
                        }
                        default: {
                            string7 = null;
                        }
                    }
                    String initialValue = string7;
                    Map map = AtomicFUTransformerJS.this.atomicArrayConstructors;
                    String string8 = ((VariableInitializer)node).getTarget().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"node.target.toSource()");
                    map.put(string8, initialValue);
                    ((VariableInitializer)node).setInitializer((AstNode)null);
                }
                return false;
            }
            if (node instanceof Assignment && ((Assignment)node).getRight() instanceof PropertyGet) {
                String string = initializer = ((Assignment)node).getRight().toSource();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"initializer");
                object = string;
                it = new Regex("locks.atomicfu\\$reentrantLock");
                if (it.matches((CharSequence)object)) {
                    it = object = new Name();
                    propertyGet = (Assignment)node;
                    boolean bl = false;
                    it.setIdentifier("null");
                    unit = Unit.INSTANCE;
                    propertyGet.setRight((AstNode)object);
                    return false;
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$FieldDelegatesVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class FieldDelegatesVisitor
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof FunctionCall) {
                String functionName = ((FunctionCall)node).getTarget().toSource();
                if (AtomicFUTransformerJS.this.atomicConstructors.contains(functionName) && ((FunctionCall)node).getParent() instanceof Assignment) {
                    AstNode astNode = ((FunctionCall)node).getParent();
                    if (astNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                    }
                    Assignment assignment = (Assignment)astNode;
                    AstNode atomicField = assignment.getLeft();
                    AstNode astNode2 = ((FunctionCall)node).getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode2, (String)"node.parent");
                    AstNode astNode3 = astNode2.getParent();
                    if (!(astNode3 instanceof ExpressionStatement)) {
                        astNode3 = null;
                    }
                    ExpressionStatement expressionStatement = (ExpressionStatement)astNode3;
                    Object object = expressionStatement != null ? expressionStatement.getParent() : null;
                    if (!(object instanceof Block)) {
                        object = null;
                    }
                    Block block = (Block)object;
                    if (block == null) {
                        Void void_ = AbortKt.abort$default("Incorrect tree structure of the constructor block initializing " + ((FunctionCall)node).getParent().toSource(), null, 2, null);
                        throw new KotlinNothingValueException();
                    }
                    Block constructorBlock = block;
                    for (Node stmt : constructorBlock) {
                        if (!(stmt instanceof ExpressionStatement) || !(((ExpressionStatement)stmt).getExpression() instanceof Assignment)) continue;
                        AstNode astNode4 = ((ExpressionStatement)stmt).getExpression();
                        if (astNode4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                        }
                        Assignment delegateAssignment = (Assignment)astNode4;
                        if (!(delegateAssignment.getRight() instanceof PropertyGet)) continue;
                        AstNode astNode5 = delegateAssignment.getRight();
                        if (astNode5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        }
                        PropertyGet initializer = (PropertyGet)astNode5;
                        if (!Intrinsics.areEqual((Object)initializer.toSource(), (Object)atomicField.toSource())) continue;
                        Map map = AtomicFUTransformerJS.this.fieldDelegates;
                        AstNode astNode6 = delegateAssignment.getLeft();
                        if (astNode6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        }
                        String string = ((PropertyGet)astNode6).getProperty().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(delegateAssignment.left\u2026yGet).property.toSource()");
                        AstNode astNode7 = atomicField;
                        if (astNode7 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        }
                        String string2 = ((PropertyGet)astNode7).getProperty().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(atomicField as PropertyGet).property.toSource()");
                        map.put(string, string2);
                    }
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$DelegatedPropertyAccessorsVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class DelegatedPropertyAccessorsVisitor
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof PropertyGet && ((PropertyGet)node).getTarget() instanceof PropertyGet) {
                Map map = AtomicFUTransformerJS.this.fieldDelegates;
                AstNode astNode = ((PropertyGet)node).getTarget();
                if (astNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                Map map2 = map;
                String string = ((PropertyGet)astNode).getProperty().toSource();
                if (map2.containsKey(string) && Intrinsics.areEqual((Object)((PropertyGet)node).getProperty().toSource(), (Object)"kotlinx$atomicfu$value") && ((PropertyGet)node).getParent() instanceof ReturnStatement) {
                    AstNode astNode2 = ((PropertyGet)node).getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode2, (String)"node.parent");
                    AstNode astNode3 = astNode2.getParent();
                    if (!(astNode3 instanceof Block)) {
                        astNode3 = null;
                    }
                    Block block = (Block)astNode3;
                    Object object = block != null ? block.getParent() : null;
                    if (!(object instanceof FunctionNode)) {
                        object = null;
                    }
                    FunctionNode functionNode = (FunctionNode)object;
                    Object object2 = functionNode != null ? functionNode.getParent() : null;
                    if (!(object2 instanceof ObjectProperty)) {
                        object2 = null;
                    }
                    ObjectProperty objectProperty = (ObjectProperty)object2;
                    Object object3 = objectProperty != null ? objectProperty.getParent() : null;
                    if (!(object3 instanceof ObjectLiteral)) {
                        object3 = null;
                    }
                    ObjectLiteral objectLiteral = (ObjectLiteral)object3;
                    if (objectLiteral == null) {
                        Void void_ = AbortKt.abort$default("Incorrect tree structure of the accessor for the property delegated " + "to the atomic field " + (String)AtomicFUTransformerJS.this.fieldDelegates.get(((PropertyGet)node).getTarget().toSource()), null, 2, null);
                        throw new KotlinNothingValueException();
                    }
                    ObjectLiteral getter = objectLiteral;
                    AstNode astNode4 = getter.getParent();
                    if (astNode4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                    }
                    FunctionCall definePropertyCall = (FunctionCall)astNode4;
                    Object e = definePropertyCall.getArguments().get(1);
                    if (!(e instanceof StringLiteral)) {
                        e = null;
                    }
                    StringLiteral stringLiteral = (StringLiteral)e;
                    if (stringLiteral == null) {
                        Void void_ = AbortKt.abort$default("Object.defineProperty invocation should take a property name as the second argument", null, 2, null);
                        throw new KotlinNothingValueException();
                    }
                    StringLiteral stringLiteral2 = stringLiteral;
                    String delegatedProperty = stringLiteral2.getValue().toString();
                    Map map3 = AtomicFUTransformerJS.this.delegatedProperties;
                    AstNode astNode5 = ((PropertyGet)node).getTarget();
                    if (astNode5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                    }
                    String string2 = ((PropertyGet)astNode5).getProperty().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(node.target as PropertyGet).property.toSource()");
                    map3.put(delegatedProperty, string2);
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$TransformVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "getArrayElement", "Lorg/mozilla/javascript/ast/AstNode;", "getterCall", "Lorg/mozilla/javascript/ast/FunctionCall;", "visit", "", "node", "atomicfu-transformer"})
    public final class TransformVisitor
    implements NodeVisitor {
        /*
         * WARNING - void declaration
         */
        public boolean visit(@NotNull AstNode node) {
            PropertyGet left;
            Unit unit;
            PropertyGet propertyGet;
            Object it;
            String functionName;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof FunctionCall) {
                functionName = ((FunctionCall)node).getTarget().toSource();
                if (AtomicFUTransformerJS.this.atomicConstructors.contains(functionName)) {
                    if (((FunctionCall)node).getParent() instanceof Assignment) {
                        AstNode valueNode = (AstNode)((FunctionCall)node).getArguments().get(0);
                        AstNode astNode = ((FunctionCall)node).getParent();
                        if (astNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                        }
                        ((Assignment)astNode).setRight(valueNode);
                    }
                    return true;
                }
                Map valueNode = AtomicFUTransformerJS.this.atomicArrayConstructors;
                Object object = valueNode;
                if (object.containsKey(functionName)) {
                    Name arrayConstructor = new Name();
                    arrayConstructor.setIdentifier("Array");
                    ((FunctionCall)node).setTarget((AstNode)arrayConstructor);
                    String string = (String)AtomicFUTransformerJS.this.atomicArrayConstructors.get(functionName);
                    if (string != null) {
                        Object it2 = object = string;
                        boolean bl = false;
                        FunctionCall arrayConsCall = new FunctionCall();
                        arrayConsCall.setTarget(((FunctionCall)node).getTarget());
                        arrayConsCall.setArguments(((FunctionCall)node).getArguments());
                        PropertyGet target = new PropertyGet();
                        Name fill = new Name();
                        fill.setIdentifier("fill");
                        target.setTarget((AstNode)arrayConsCall);
                        target.setProperty(fill);
                        ((FunctionCall)node).setTarget((AstNode)target);
                        Name initialValue = new Name();
                        initialValue.setIdentifier((String)it2);
                        ((FunctionCall)node).setArguments(CollectionsKt.listOf((Object)initialValue));
                    }
                    return true;
                }
                if (((FunctionCall)node).getTarget() instanceof PropertyGet) {
                    AstNode astNode = ((FunctionCall)node).getTarget();
                    if (astNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                    }
                    if (((PropertyGet)astNode).getTarget() instanceof FunctionCall) {
                        AstNode astNode2 = ((FunctionCall)node).getTarget();
                        if (astNode2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        }
                        PropertyGet atomicOperationTarget = (PropertyGet)astNode2;
                        AstNode astNode3 = atomicOperationTarget.getTarget();
                        if (astNode3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                        }
                        FunctionCall funcCall = (FunctionCall)astNode3;
                        if (funcCall.getTarget() instanceof PropertyGet) {
                            AstNode astNode4 = funcCall.getTarget();
                            if (astNode4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            }
                            Name getterCall = ((PropertyGet)astNode4).getProperty();
                            Regex regex = new Regex("atomicfu\\$get");
                            String string = getterCall.toSource();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getterCall.toSource()");
                            if (regex.matches((CharSequence)string)) {
                                AstNode getter = this.getArrayElement(funcCall);
                                atomicOperationTarget.setTarget(getter);
                            }
                        }
                    }
                }
            }
            if (node instanceof PropertyGet) {
                String originalField;
                String fieldDelegate;
                Map clearProperety2;
                Map it3;
                Object rr;
                Object receiverName;
                if (Intrinsics.areEqual((Object)((PropertyGet)node).getProperty().toSource(), (Object)"kotlinx$atomicfu$value")) {
                    AstNode targetNode;
                    Object clearField;
                    AstNode astNode = ((PropertyGet)node).getTarget();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"node.target");
                    AstNode astNode5 = AtomicFUTransformerJS.this.eraseAtomicFieldFromUncheckedCast(astNode);
                    if (astNode5 != null) {
                        functionName = astNode5;
                        it = functionName;
                        boolean bl = false;
                        ((PropertyGet)node).setTarget((AstNode)it);
                    }
                    AstNode astNode6 = ((PropertyGet)node).getTarget();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode6, (String)"node.target");
                    if (astNode6.getType() == 33) {
                        AstNode astNode7 = ((PropertyGet)node).getTarget();
                        if (astNode7 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        }
                        clearField = (PropertyGet)astNode7;
                        targetNode = clearField.getTarget();
                        Name clearProperety2 = clearField.getProperty();
                        ((PropertyGet)node).setLeftAndRight(targetNode, (AstNode)clearProperety2);
                    } else {
                        String string = ((PropertyGet)node).getTarget().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.target.toSource()");
                        clearField = string;
                        targetNode = new Regex("(\\$(receiver)(_\\d+)?)");
                        if (targetNode.matches((CharSequence)clearField)) {
                            Object object = receiverName = ((PropertyGet)node).getTarget().toSource();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"receiverName");
                            rr = new ReceiverResolver((String)object);
                            ((PropertyGet)node).getEnclosingFunction().visit((NodeVisitor)rr);
                            AstNode astNode8 = ((ReceiverResolver)rr).getReceiver();
                            if (astNode8 != null) {
                                AstNode clearProperety2 = astNode8;
                                it3 = clearProperety2;
                                boolean bl = false;
                                ((PropertyGet)node).setTarget((AstNode)it3);
                            }
                        }
                    }
                }
                if ((clearProperety2 = (receiverName = AtomicFUTransformerJS.this.delegatedProperties)).containsKey(rr = ((PropertyGet)node).getProperty().toSource())) {
                    void $this$apply;
                    fieldDelegate = (String)AtomicFUTransformerJS.this.delegatedProperties.get(((PropertyGet)node).getProperty().toSource());
                    clearProperety2 = AtomicFUTransformerJS.this.fieldDelegates;
                    Object v = clearProperety2.get(fieldDelegate);
                    Intrinsics.checkNotNull(v);
                    originalField = (String)v;
                    it3 = clearProperety2 = new Name();
                    propertyGet = (PropertyGet)node;
                    boolean bl = false;
                    $this$apply.setIdentifier(originalField);
                    unit = Unit.INSTANCE;
                    propertyGet.setProperty((Name)clearProperety2);
                }
                if (Intrinsics.areEqual((Object)((PropertyGet)node).getProperty().toSource(), (Object)"atomicfu$size")) {
                    originalField = fieldDelegate = new Name();
                    propertyGet = (PropertyGet)node;
                    boolean bl = false;
                    it.setIdentifier("length");
                    unit = Unit.INSTANCE;
                    propertyGet.setProperty((Name)fieldDelegate);
                }
            }
            if (node instanceof Block) {
                it = node.iterator();
                while (it.hasNext()) {
                    CharSequence functionName2;
                    Node stmt = (Node)it.next();
                    if (!(stmt instanceof ExpressionStatement)) continue;
                    if (((ExpressionStatement)stmt).getExpression() instanceof Assignment) {
                        AstNode astNode = ((ExpressionStatement)stmt).getExpression();
                        if (astNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                        }
                        Assignment assignment = (Assignment)astNode;
                        if (assignment.getRight() instanceof FunctionCall) {
                            AstNode astNode9 = assignment.getRight();
                            if (astNode9 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                            }
                            functionName2 = ((FunctionCall)astNode9).getTarget().toSource();
                            if (AtomicFUTransformerJS.this.traceConstructors.contains(functionName2)) {
                                node.replaceChild(stmt, (Node)new EmptyLine());
                            }
                        }
                    }
                    if (!(((ExpressionStatement)stmt).getExpression() instanceof FunctionCall)) continue;
                    AstNode astNode = ((ExpressionStatement)stmt).getExpression();
                    if (astNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                    }
                    AstNode funcNode = ((FunctionCall)astNode).getTarget();
                    if (!(funcNode instanceof PropertyGet)) continue;
                    String string = ((PropertyGet)funcNode).getProperty().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"funcNode.property.toSource()");
                    Regex bl = new Regex("(atomicfu)\\$(Trace)\\$(append)\\$([1234])");
                    functionName2 = string;
                    if (!bl.matches(functionName2)) continue;
                    node.replaceChild(stmt, (Node)new EmptyLine());
                }
            }
            if (node instanceof Assignment && ((Assignment)node).getLeft() instanceof PropertyGet) {
                AstNode astNode = ((Assignment)node).getLeft();
                if (astNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                left = (PropertyGet)astNode;
                if (AtomicFUTransformerJS.this.traceFormatObjects.contains(left.getTarget().toSource()) && ((Assignment)node).getRight() instanceof FunctionCall) {
                    void it4;
                    AstNode astNode10 = ((Assignment)node).getRight();
                    if (astNode10 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                    }
                    Object funcNode = it = new Name();
                    propertyGet = (FunctionCall)astNode10;
                    boolean bl = false;
                    it4.setIdentifier("null");
                    unit = Unit.INSTANCE;
                    propertyGet.setArguments(CollectionsKt.listOf((Object)it));
                }
            }
            if (node instanceof FunctionNode && AtomicFUTransformerJS.this.traceFormatObjects.contains(((FunctionNode)node).getName())) {
                AstNode body = ((FunctionNode)node).getBody();
                for (Node stmt : body) {
                    body.replaceChild(stmt, (Node)new EmptyLine());
                }
            }
            if (node instanceof Assignment && ((Assignment)node).getLeft() instanceof PropertyGet && ((Assignment)node).getRight() instanceof ObjectLiteral) {
                AstNode astNode = ((Assignment)node).getLeft();
                if (astNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                left = (PropertyGet)astNode;
                AstNode astNode11 = ((Assignment)node).getRight();
                if (astNode11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.ObjectLiteral");
                }
                ObjectLiteral metadata = (ObjectLiteral)astNode11;
                if (AtomicFUTransformerJS.this.traceFormatObjects.contains(left.getTarget().toSource())) {
                    Iterator iterator = metadata.getElements().iterator();
                    while (iterator.hasNext()) {
                        String array;
                        ObjectProperty e;
                        ObjectProperty objectProperty = e = (ObjectProperty)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)objectProperty, (String)"e");
                        if (!(objectProperty.getRight() instanceof ArrayLiteral)) continue;
                        AstNode astNode12 = e.getRight();
                        if (astNode12 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.ArrayLiteral");
                        }
                        String string = array = ((ArrayLiteral)astNode12).toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"array");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"TraceFormat", (boolean)false, (int)2, null)) continue;
                        AstNode astNode13 = e.getRight();
                        if (astNode13 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.ArrayLiteral");
                        }
                        ((ArrayLiteral)astNode13).setElements(CollectionsKt.emptyList());
                    }
                }
            }
            return true;
        }

        private final AstNode getArrayElement(FunctionCall getterCall) {
            AstNode astNode;
            AstNode astNode2;
            boolean isStatic;
            AstNode index = (AstNode)getterCall.getArguments().get(0);
            AstNode astNode3 = getterCall.getTarget();
            if (astNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
            }
            AstNode arrayField = ((PropertyGet)astNode3).getTarget();
            boolean bl = isStatic = !(arrayField instanceof PropertyGet);
            if (isStatic) {
                astNode2 = arrayField;
            } else {
                AstNode astNode4 = arrayField;
                if (astNode4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                astNode2 = (AstNode)((PropertyGet)astNode4).getProperty();
            }
            AstNode arrName = astNode2;
            ElementGet getter = new ElementGet(arrName, index);
            if (isStatic) {
                astNode = (AstNode)getter;
            } else {
                PropertyGet call = new PropertyGet();
                AstNode astNode5 = arrayField;
                if (astNode5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                call.setTarget(((PropertyGet)astNode5).getTarget());
                Name name = new Name();
                name.setIdentifier(getter.toSource());
                call.setProperty(name);
                astNode = (AstNode)call;
            }
            return astNode;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$ReceiverResolver;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "receiverName", "", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;Ljava/lang/String;)V", "receiver", "Lorg/mozilla/javascript/ast/AstNode;", "getReceiver", "()Lorg/mozilla/javascript/ast/AstNode;", "setReceiver", "(Lorg/mozilla/javascript/ast/AstNode;)V", "visit", "", "node", "atomicfu-transformer"})
    public final class ReceiverResolver
    implements NodeVisitor {
        @Nullable
        private AstNode receiver;
        private final String receiverName;

        @Nullable
        public final AstNode getReceiver() {
            return this.receiver;
        }

        public final void setReceiver(@Nullable AstNode astNode) {
            this.receiver = astNode;
        }

        public boolean visit(@NotNull AstNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof VariableInitializer && Intrinsics.areEqual((Object)((VariableInitializer)node).getTarget().toSource(), (Object)this.receiverName)) {
                this.receiver = ((VariableInitializer)node).getInitializer();
                return false;
            }
            return true;
        }

        public ReceiverResolver(String receiverName) {
            Intrinsics.checkNotNullParameter((Object)receiverName, (String)"receiverName");
            this.receiverName = receiverName;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicOperationsInliner;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class AtomicOperationsInliner
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof FunctionCall && ((FunctionCall)node).getTarget() instanceof PropertyGet) {
                String receiverName;
                AstNode astNode = ((FunctionCall)node).getTarget();
                if (astNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                Name funcName = ((PropertyGet)astNode).getProperty();
                AstNode astNode2 = ((FunctionCall)node).getTarget();
                if (astNode2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                Object field = ((PropertyGet)astNode2).getTarget();
                String string = field.toSource();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.toSource()");
                CharSequence charSequence = string;
                Regex regex = new Regex("(\\$(receiver)(_\\d+)?)");
                if (regex.matches(charSequence)) {
                    String string2 = receiverName = field.toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"receiverName");
                    ReceiverResolver rr = new ReceiverResolver(string2);
                    ((FunctionCall)node).getEnclosingFunction().visit((NodeVisitor)rr);
                    if (rr.getReceiver() != null) {
                        field = rr.getReceiver();
                    }
                }
                AstNode astNode3 = field;
                Intrinsics.checkNotNullExpressionValue((Object)astNode3, (String)"field");
                AstNode astNode4 = AtomicFUTransformerJS.this.eraseAtomicFieldFromUncheckedCast(astNode3);
                if (astNode4 != null) {
                    String it = receiverName = astNode4;
                    boolean bl = false;
                    field = it;
                }
                List args = ((FunctionCall)node).getArguments();
                FunctionCall functionCall = (FunctionCall)node;
                String string3 = funcName.toSource();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"funcName.toSource()");
                Object object = field;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"field");
                List list = args;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"args");
                boolean inlined = AtomicFUTransformerJS.this.inlineAtomicOperation(functionCall, string3, object, list);
                return !inlined;
            }
            return true;
        }
    }
}

