/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.fus.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.fus.Metric;
import org.jetbrains.kotlin.gradle.fus.internal.InternalGradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.internal.WriteMetricToFileKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/BuildCloseFusStatisticsBuildService;", "Lorg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService;", "Lorg/jetbrains/kotlin/gradle/fus/internal/BuildCloseFusStatisticsBuildService$Parameter;", "providersFactor", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "buildId", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "getExecutionTimeMetrics", "Lorg/gradle/api/provider/Provider;", "", "Lorg/jetbrains/kotlin/gradle/fus/Metric;", "Parameter", "fus-statistics-gradle-plugin_common"})
public abstract class BuildCloseFusStatisticsBuildService
extends InternalGradleBuildFusStatisticsService<Parameter> {
    @NotNull
    private final ProviderFactory providersFactor;
    private final Logger log;
    @NotNull
    private final String buildId;

    @Inject
    public BuildCloseFusStatisticsBuildService(@NotNull ProviderFactory providersFactor) {
        Intrinsics.checkNotNullParameter((Object)providersFactor, (String)"providersFactor");
        this.providersFactor = providersFactor;
        this.log = Logging.getLogger(this.getClass());
        Object object = ((Parameter)this.getParameters()).getBuildId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.buildId.get()");
        this.buildId = (String)object;
    }

    @Override
    @NotNull
    public Provider<List<Metric>> getExecutionTimeMetrics() {
        Provider provider = this.providersFactor.provider(new Callable(this){
            final /* synthetic */ BuildCloseFusStatisticsBuildService this$0;
            {
                this.this$0 = $receiver;
            }

            public final List<Metric> call() {
                ArrayList<Metric> reportedMetrics = new ArrayList<Metric>();
                ((Parameter)this.this$0.getParameters()).getConfigurationMetrics().map(new Transformer(reportedMetrics){
                    final /* synthetic */ ArrayList<Metric> $reportedMetrics;
                    {
                        this.$reportedMetrics = $reportedMetrics;
                    }

                    public final Boolean transform(List<Metric> it) {
                        return this.$reportedMetrics.addAll((Collection<Metric>)it);
                    }
                });
                reportedMetrics.addAll((Collection<Metric>)this.this$0.getExecutionTimeMetrics$fus_statistics_gradle_plugin_common());
                return reportedMetrics;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"override fun getExecutio\u2026dMetrics\n        }\n\n    }");
        return provider;
    }

    @Override
    public void close() {
        this.log.debug("InternalGradleBuildFusStatisticsService is closed for " + this.buildId + " build");
        InternalGradleBuildFusStatisticsService internalGradleBuildFusStatisticsService = this;
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        WriteMetricToFileKt.writeDownFusMetrics(internalGradleBuildFusStatisticsService, this.buildId, logger, (List)((Parameter)this.getParameters()).getConfigurationMetrics().getOrNull());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/BuildCloseFusStatisticsBuildService$Parameter;", "Lorg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService$Parameter;", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "configurationMetrics", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/fus/Metric;", "getConfigurationMetrics", "()Lorg/gradle/api/provider/ListProperty;", "fus-statistics-gradle-plugin_common"})
    public static interface Parameter
    extends InternalGradleBuildFusStatisticsService.Parameter {
        @NotNull
        public ListProperty<Metric> getConfigurationMetrics();

        @NotNull
        public Property<String> getBuildId();
    }
}

