/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.fus;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.fus.TaskId;
import org.jetbrains.kotlin.gradle.fus.UniqueId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0096\u0002J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/TaskId;", "Lorg/jetbrains/kotlin/gradle/fus/UniqueId;", "projectName", "", "taskName", "(Ljava/lang/String;Ljava/lang/String;)V", "getProjectName", "()Ljava/lang/String;", "getTaskName", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "fus-statistics-gradle-plugin_common"})
public final class TaskId
implements UniqueId {
    @Nullable
    private final String projectName;
    @NotNull
    private final String taskName;

    public TaskId(@Nullable String projectName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        this.projectName = projectName;
        this.taskName = taskName;
    }

    @Override
    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final String getTaskName() {
        return this.taskName;
    }

    @Override
    public int compareTo(@NotNull UniqueId other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof TaskId) {
            Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE};
            n = ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
        } else {
            n = UniqueId.DefaultImpls.compareTo(this, other);
        }
        return n;
    }

    @Nullable
    public final String component1() {
        return this.projectName;
    }

    @NotNull
    public final String component2() {
        return this.taskName;
    }

    @NotNull
    public final TaskId copy(@Nullable String projectName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        return new TaskId(projectName, taskName);
    }

    public static /* synthetic */ TaskId copy$default(TaskId taskId, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = taskId.projectName;
        }
        if ((n & 2) != 0) {
            string2 = taskId.taskName;
        }
        return taskId.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "TaskId(projectName=" + this.projectName + ", taskName=" + this.taskName + ')';
    }

    public int hashCode() {
        int result = this.projectName == null ? 0 : this.projectName.hashCode();
        result = result * 31 + this.taskName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TaskId)) {
            return false;
        }
        TaskId taskId = (TaskId)other;
        if (!Intrinsics.areEqual((Object)this.projectName, (Object)taskId.projectName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.taskName, (Object)taskId.taskName);
    }
}

