/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.fus.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.fus.BuildUidService;
import org.jetbrains.kotlin.gradle.fus.GradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.UsesGradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.internal.BuildCloseFusStatisticsBuildService;
import org.jetbrains.kotlin.gradle.fus.internal.BuildFlowFusStatisticsBuildService;
import org.jetbrains.kotlin.gradle.fus.internal.FusBuildFinishFlowManager;
import org.jetbrains.kotlin.gradle.fus.internal.GradleBuildFusStatisticsBuildServiceKt;
import org.jetbrains.kotlin.gradle.fus.internal.InternalGradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.internal.NoConsentGradleBuildFusService;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u00070\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u001a.\u0010\u0014\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u00070\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH\u0002\u001a\u001a\u0010\u0015\u001a\u00020\u0016*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"FUS_STATISTICS_PATH", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "serviceClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/gradle/fus/GradleBuildFusStatisticsService;", "serviceName", "getServiceName", "()Ljava/lang/String;", "statisticsIsEnabled", "", "registerGradleBuildFusStatisticsServiceIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/services/BuildServiceParameters;", "project", "Lorg/gradle/api/Project;", "uidService", "Lorg/jetbrains/kotlin/gradle/fus/BuildUidService;", "registerIfAbsent", "registerTaskCreatingFusService", "", "fusService", "Lorg/jetbrains/kotlin/gradle/fus/internal/BuildCloseFusStatisticsBuildService;", "fus-statistics-gradle-plugin_common"})
public final class GradleBuildFusStatisticsBuildServiceKt {
    private static final boolean statisticsIsEnabled = true;
    @NotNull
    private static final String FUS_STATISTICS_PATH = "kotlin.session.logger.root.path";
    @NotNull
    private static final Class<GradleBuildFusStatisticsService<?>> serviceClass = GradleBuildFusStatisticsService.class;
    @NotNull
    private static final String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();
    private static final Logger log = Logging.getLogger(GradleBuildFusStatisticsService.class);

    @NotNull
    public static final String getServiceName() {
        return serviceName;
    }

    @NotNull
    public static final Provider<? extends GradleBuildFusStatisticsService<? extends BuildServiceParameters>> registerGradleBuildFusStatisticsServiceIfAbsent(@NotNull Project project, @NotNull Provider<BuildUidService> uidService) {
        Provider<? extends GradleBuildFusStatisticsService<? extends BuildServiceParameters>> provider;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(uidService, (String)"uidService");
        Provider<? extends GradleBuildFusStatisticsService<? extends BuildServiceParameters>> service = provider = GradleBuildFusStatisticsBuildServiceKt.registerIfAbsent(project, uidService);
        boolean bl = false;
        project.getTasks().withType(UsesGradleBuildFusStatisticsService.class).configureEach(new Action(service){
            final /* synthetic */ Provider<? extends GradleBuildFusStatisticsService<? extends BuildServiceParameters>> $service;
            {
                this.$service = $service;
            }

            public final void execute(UsesGradleBuildFusStatisticsService task) {
                task.getFusStatisticsBuildService().value(this.$service).disallowChanges();
                task.usesService(this.$service);
            }
        });
        return provider;
    }

    /*
     * WARNING - void declaration
     */
    private static final Provider<? extends GradleBuildFusStatisticsService<? extends BuildServiceParameters>> registerIfAbsent(Project project, Provider<BuildUidService> uidService) {
        Provider provider;
        String customPath;
        BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
        if (buildServiceRegistration != null) {
            BuildServiceRegistration it = buildServiceRegistration;
            boolean bl = false;
            Provider provider2 = it.getService();
            Intrinsics.checkNotNull((Object)provider2, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.fus.GradleBuildFusStatisticsService<out org.gradle.api.services.BuildServiceParameters>>");
            return provider2;
        }
        String string = (String)project.getProviders().gradleProperty(FUS_STATISTICS_PATH).getOrNull();
        if (string == null) {
            String string2 = project.getGradle().getGradleUserHomeDir().getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.gradle.gradleUserHomeDir.path");
        }
        if (StringsKt.isBlank((CharSequence)(customPath = string))) {
            log.info("Fus metrics wont be collected as statistic was enabled" + (StringsKt.isBlank((CharSequence)customPath) ? " and custom path is blank" : ""));
            Provider provider3 = project.getGradle().getSharedServices().registerIfAbsent(serviceName, NoConsentGradleBuildFusService.class, (Action)registerIfAbsent.2.INSTANCE);
            provider = provider3;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"{\n        log.info(\n    \u2026ice::class.java) {}\n    }");
        } else if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) < 0) {
            Provider fusService2 = project.getGradle().getSharedServices().registerIfAbsent(serviceName, BuildCloseFusStatisticsBuildService.class, new Action(customPath, uidService){
                final /* synthetic */ String $customPath;
                final /* synthetic */ Provider<BuildUidService> $uidService;
                {
                    this.$customPath = $customPath;
                    this.$uidService = $uidService;
                }

                public final void execute(BuildServiceSpec<InternalGradleBuildFusStatisticsService.Parameter> it) {
                    ((InternalGradleBuildFusStatisticsService.Parameter)it.getParameters()).getFusStatisticsRootDirPath().value((Object)this.$customPath).disallowChanges();
                    ((InternalGradleBuildFusStatisticsService.Parameter)it.getParameters()).getConfigurationMetrics().empty();
                    ((InternalGradleBuildFusStatisticsService.Parameter)it.getParameters()).getBuildId().value(this.$uidService.map((Transformer)registerIfAbsent.fusService.1.INSTANCE)).disallowChanges();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)fusService2, (String)"fusService");
            GradleBuildFusStatisticsBuildServiceKt.registerTaskCreatingFusService(project, (Provider<BuildCloseFusStatisticsBuildService>)fusService2);
            provider = fusService2;
        } else {
            void var3_5;
            Provider fusService3 = project.getGradle().getSharedServices().registerIfAbsent(serviceName, BuildFlowFusStatisticsBuildService.class, new Action(customPath, uidService){
                final /* synthetic */ String $customPath;
                final /* synthetic */ Provider<BuildUidService> $uidService;
                {
                    this.$customPath = $customPath;
                    this.$uidService = $uidService;
                }

                public final void execute(BuildServiceSpec<InternalGradleBuildFusStatisticsService.Parameter> it) {
                    ((InternalGradleBuildFusStatisticsService.Parameter)it.getParameters()).getFusStatisticsRootDirPath().value((Object)this.$customPath).disallowChanges();
                    ((InternalGradleBuildFusStatisticsService.Parameter)it.getParameters()).getConfigurationMetrics().empty();
                    ((InternalGradleBuildFusStatisticsService.Parameter)it.getParameters()).getBuildId().value(this.$uidService.map((Transformer)registerIfAbsent.fusService.1.INSTANCE)).disallowChanges();
                }
            });
            FusBuildFinishFlowManager.Companion.getInstance(project).subscribeForBuildFinish();
            void v5 = var3_5;
            provider = v5;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"uidService: Provider<Bui\u2026\n        fusService\n    }");
        }
        return provider;
    }

    private static final void registerTaskCreatingFusService(Project $this$registerTaskCreatingFusService, Provider<BuildCloseFusStatisticsBuildService> fusService2) {
        TaskProvider writeFusTask2 = $this$registerTaskCreatingFusService.getTasks().register("kotlinFus", DefaultTask.class, new Action(fusService2){
            final /* synthetic */ Provider<BuildCloseFusStatisticsBuildService> $fusService;
            {
                this.$fusService = $fusService;
            }

            public final void execute(DefaultTask task) {
                task.doNotTrackState("Task is stateless");
                task.usesService(this.$fusService);
                task.doLast(new Action(this.$fusService){
                    final /* synthetic */ Provider<BuildCloseFusStatisticsBuildService> $fusService;
                    {
                        this.$fusService = $fusService;
                    }

                    public final void execute(Task it) {
                        this.$fusService.get();
                    }
                });
            }
        });
        List list = $this$registerTaskCreatingFusService.getProject().getGradle().getStartParameter().getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"project.gradle.startParameter.taskNames");
        String startTaskName = (String)CollectionsKt.first((List)list);
        $this$registerTaskCreatingFusService.getProject().getTasks().configureEach(new Action(startTaskName, (TaskProvider<DefaultTask>)writeFusTask2){
            final /* synthetic */ String $startTaskName;
            final /* synthetic */ TaskProvider<DefaultTask> $writeFusTask;
            {
                this.$startTaskName = $startTaskName;
                this.$writeFusTask = $writeFusTask;
            }

            public final void execute(Task t) {
                if (Intrinsics.areEqual((Object)t.getName(), (Object)this.$startTaskName)) {
                    Object[] objectArray = new Object[]{this.$writeFusTask};
                    t.finalizedBy(objectArray);
                }
            }
        });
    }
}

