/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.targets;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.platform.KotlinDeserializedDeclarationsOrigin;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.KotlinPlatformSettings;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactoryKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopics;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.test.framework.targets.TestSymbolTarget;
import org.jetbrains.kotlin.analysis.test.framework.targets.TestSymbolTargetResolver;
import org.jetbrains.kotlin.analysis.test.framework.targets.UtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0014J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/targets/KtElementTestSymbolTargetResolver;", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver;", "Lorg/jetbrains/kotlin/psi/KtElement;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "declarationProvider", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProvider;", "resolveClassTarget", "", "target", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ClassTarget;", "resolveClasses", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveScriptTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ScriptTarget;", "resolveTypeAliasTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeAliasTarget;", "resolveCallableTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$CallableTarget;", "resolveTypeParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeParameterTarget;", "owner", "resolveValueParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ValueParameterTarget;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtElementTestSymbolTargetResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtElementTestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/KtElementTestSymbolTargetResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 TestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver\n*L\n1#1,113:1\n1#2:114\n1#2:128\n29#3,2:115\n35#4,9:117\n46#4,2:131\n1625#5:126\n1869#5:127\n1870#5:129\n1626#5:130\n63#6,4:133\n63#6,4:137\n*S KotlinDebug\n*F\n+ 1 KtElementTestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/KtElementTestSymbolTargetResolver\n*L\n89#1:128\n82#1:115,2\n82#1:117,9\n82#1:131,2\n89#1:126\n89#1:127\n89#1:129\n89#1:130\n102#1:133,4\n108#1:137,4\n*E\n"})
public final class KtElementTestSymbolTargetResolver
extends TestSymbolTargetResolver<KtElement> {
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinDeclarationProvider declarationProvider;

    public KtElementTestSymbolTargetResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        this.declarationProvider = KotlinDeclarationProviderFactoryKt.createDeclarationProvider((Project)this.project, (GlobalSearchScope)globalSearchScope, null);
        if (!(KotlinPlatformSettings.Companion.getInstance(this.project).getDeserializedDeclarationsOrigin() == KotlinDeserializedDeclarationsOrigin.STUBS)) {
            boolean bl = false;
            String string = '`' + Reflection.getOrCreateKotlinClass(KtElementTestSymbolTargetResolver.class).getSimpleName() + "` currently relies on stub-indexed binary libraries. See the class's KDoc for more information.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    protected List<KtElement> resolveClassTarget(@NotNull TestSymbolTarget.ClassTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.resolveClasses(target.getClassId());
    }

    private final List<KtClassOrObject> resolveClasses(ClassId classId) {
        Collection collection = this.declarationProvider.getAllClassesByClassId(classId);
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("Cannot find a class `" + classId + "`.").toString());
        }
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @NotNull
    protected List<KtElement> resolveScriptTarget(@NotNull TestSymbolTarget.ScriptTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KtScript ktScript = target.getFile().getScript();
        if (ktScript == null) {
            throw new IllegalStateException(("The file `" + target.getFile().getName() + "` is not a script.").toString());
        }
        KtScript ktScript2 = ktScript;
        return CollectionsKt.listOf((Object)ktScript2);
    }

    @Override
    @NotNull
    protected List<KtElement> resolveTypeAliasTarget(@NotNull TestSymbolTarget.TypeAliasTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Collection collection = this.declarationProvider.getAllTypeAliasesByClassId(target.getClassId());
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("Cannot find a type alias `" + target.getClassId() + "`.").toString());
        }
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<KtElement> resolveCallableTarget(@NotNull TestSymbolTarget.CallableTarget target) {
        List list;
        List $this$resolveCallableTarget_u24lambda_u243;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CallableId callableId = target.getCallableId();
        ClassId classId = callableId.getClassId();
        if (classId == null) {
            collection = CollectionsKt.createListBuilder();
            $this$resolveCallableTarget_u24lambda_u243 = collection;
            boolean bl = false;
            $this$resolveCallableTarget_u24lambda_u243.addAll(this.declarationProvider.getTopLevelFunctions(callableId));
            $this$resolveCallableTarget_u24lambda_u243.addAll(this.declarationProvider.getTopLevelProperties(callableId));
            list = CollectionsKt.build((List)collection);
        } else {
            List<KtClassOrObject> classes = this.resolveClasses(classId);
            List $this$resolveCallableTarget_u24lambda_u247 = $this$resolveCallableTarget_u24lambda_u243 = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (KtClassOrObject ktClass : classes) {
                void this_$iv$iv;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)ktClass).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktClass);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)ktClass);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        boolean bl2 = false;
                        KaSession $this$resolveCallableTarget_u24lambda_u247_u24lambda_u246 = analysisSession$iv$iv;
                        boolean bl3 = false;
                        if ($this$resolveCallableTarget_u24lambda_u247_u24lambda_u246.getClassSymbol(ktClass) != null) {
                            void $this$mapNotNullTo$iv;
                            KaClassSymbol classSymbol;
                            if (!Intrinsics.areEqual((Object)classSymbol.getPsi(), (Object)ktClass)) {
                                boolean $i$a$-check-KtElementTestSymbolTargetResolver$resolveCallableTarget$callables$2$1$22 = false;
                                String $i$a$-check-KtElementTestSymbolTargetResolver$resolveCallableTarget$callables$2$1$22 = "`classSymbol` returned the wrong class symbol for the given " + Reflection.getOrCreateKotlinClass(KtClassOrObject.class).getSimpleName() + '.';
                                throw new IllegalStateException($i$a$-check-KtElementTestSymbolTargetResolver$resolveCallableTarget$callables$2$1$22.toString());
                            }
                            Iterable iterable = UtilsKt.findMatchingCallableSymbols($this$resolveCallableTarget_u24lambda_u247_u24lambda_u246, callableId, classSymbol);
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                            boolean $i$f$forEach = false;
                            Iterator iterator = $this$forEach$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                KtElement it$iv;
                                Object element$iv$iv;
                                Object element$iv = element$iv$iv = iterator.next();
                                boolean bl4 = false;
                                KaCallableSymbol it = (KaCallableSymbol)element$iv;
                                boolean bl5 = false;
                                PsiElement psiElement = $this$resolveCallableTarget_u24lambda_u247_u24lambda_u246.getFakeOverrideOriginal(it).getPsi();
                                if ((psiElement instanceof KtElement ? (KtElement)psiElement : null) == null) continue;
                                it$iv = it$iv;
                                boolean bl6 = false;
                                ((Collection)$this$resolveCallableTarget_u24lambda_u247).add(it$iv);
                            }
                        }
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)ktClass);
                }
            }
            list = CollectionsKt.build((List)$this$resolveCallableTarget_u24lambda_u243);
        }
        List callables = list;
        ((KotlinGlobalModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)this.project).syncPublisher(KotlinModificationTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION())).onModification();
        collection = callables;
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("Cannot find a callable `" + callableId + "`.").toString());
        }
        return (List)collection;
    }

    @Override
    @Nullable
    protected KtElement resolveTypeParameterTarget(@NotNull TestSymbolTarget.TypeParameterTarget target, @NotNull KtElement owner) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            TestSymbolTargetResolver this_$iv = this;
            boolean $i$f$requireSpecificOwner = false;
            if (!(owner instanceof KtTypeParameterListOwner)) {
                boolean bl = false;
                String string = "Expected a `" + Reflection.getOrCreateKotlinClass(KtTypeParameterListOwner.class).getSimpleName() + "` owner for `" + (TestSymbolTarget)target + "`, but found: " + owner + '.';
                throw new IllegalArgumentException(string.toString());
            }
            List list = ((KtTypeParameterListOwner)owner).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeParameters(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                KtTypeParameter it = (KtTypeParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)target.getName().asString())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Override
    @Nullable
    protected KtElement resolveValueParameterTarget(@NotNull TestSymbolTarget.ValueParameterTarget target, @NotNull KtElement owner) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            TestSymbolTargetResolver this_$iv = this;
            boolean $i$f$requireSpecificOwner = false;
            if (!(owner instanceof KtCallableDeclaration)) {
                boolean bl = false;
                String string = "Expected a `" + Reflection.getOrCreateKotlinClass(KtCallableDeclaration.class).getSimpleName() + "` owner for `" + (TestSymbolTarget)target + "`, but found: " + owner + '.';
                throw new IllegalArgumentException(string.toString());
            }
            List list = ((KtCallableDeclaration)owner).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                KtParameter it = (KtParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)target.getName().asString())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }
}

