/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.caches;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.ValueWithPostCompute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostComputeTest;", "", "<init>", "()V", "testTheSameValueIsComputedFromDifferentThreads", "", "testPCEIsRethrownAndNotSavedInCache", "testPCEFromPostCompute", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nValueWithPostComputeTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueWithPostComputeTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostComputeTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1563#2:129\n1634#2,3:130\n1869#2,2:133\n1869#2,2:135\n1740#2,3:137\n1#3:140\n*S KotlinDebug\n*F\n+ 1 ValueWithPostComputeTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostComputeTest\n*L\n35#1:129\n35#1:130,3\n40#1:133,2\n41#1:135,2\n47#1:137,3\n*E\n"})
public final class ValueWithPostComputeTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public final void testTheSameValueIsComputedFromDifferentThreads() {
        boolean bl;
        List resultsList;
        block6: {
            Iterator $this$mapTo$iv$iv;
            ValueWithPostCompute valueWithPostCompute = new ValueWithPostCompute((Object)1, ValueWithPostComputeTest::testTheSameValueIsComputedFromDifferentThreads$lambda$0, ValueWithPostComputeTest::testTheSameValueIsComputedFromDifferentThreads$lambda$1);
            ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
            Iterable $this$map$iv = (Iterable)new IntRange(0, 9);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void threadIndex;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = "" + 't' + (int)threadIndex;
                collection.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)string, (int)0, () -> ValueWithPostComputeTest.testTheSameValueIsComputedFromDifferentThreads$lambda$3$lambda$2(results, valueWithPostCompute), (int)22, null));
            }
            List threads = (List)destination$iv$iv;
            Iterable $this$forEach$iv = threads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl3 = false;
                it.start();
            }
            $this$forEach$iv = threads;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl4 = false;
                it.join();
            }
            resultsList = CollectionsKt.toList((Iterable)results);
            Assertions.assertEquals((int)threads.size(), (int)results.size());
            Iterable $this$all$iv = resultsList;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual((Object)it, resultsList.get(0))) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        Assertions.assertTrue((boolean)bl, (String)("All results got from ValueWithPostCompute should be equal, but was " + resultsList));
    }

    @Test
    public final void testPCEIsRethrownAndNotSavedInCache() {
        Object object;
        Object $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22;
        ValueWithPostCompute valueWithPostCompute = new ValueWithPostCompute((Object)1, ValueWithPostComputeTest::testPCEIsRethrownAndNotSavedInCache$lambda$7, ValueWithPostComputeTest::testPCEIsRethrownAndNotSavedInCache$lambda$8);
        try {
            boolean $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22 = false;
            $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22 = Result.constructor-impl((Object)((String)valueWithPostCompute.getValue()));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable pceOnFirstAccess = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22);
        Assertions.assertInstanceOf(ProcessCanceledException.class, (Object)pceOnFirstAccess);
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)((String)valueWithPostCompute.getValue()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable pceOnSecondAccess = Result.exceptionOrNull-impl((Object)object);
        Assertions.assertInstanceOf(ProcessCanceledException.class, (Object)pceOnSecondAccess);
        Assertions.assertNotEquals((Object)pceOnFirstAccess, (Object)pceOnSecondAccess, (String)"different PCE should be thrown on every access");
    }

    @Test
    public final void testPCEFromPostCompute() {
        for (int i = 1; i < 101; ++i) {
            CountDownLatch t1CalledCalculate = new CountDownLatch(1);
            CountDownLatch t2AccessedTheCache = new CountDownLatch(1);
            AtomicReference<Object> resultRef = new AtomicReference<Object>(null);
            ValueWithPostCompute valueWithPostCompute = new ValueWithPostCompute((Object)1, arg_0 -> ValueWithPostComputeTest.testPCEFromPostCompute$lambda$11(t1CalledCalculate, arg_0), (arg_0, arg_1, arg_2) -> ValueWithPostComputeTest.testPCEFromPostCompute$lambda$12(t2AccessedTheCache, arg_0, arg_1, arg_2));
            Thread t1 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"t1", (int)0, () -> ValueWithPostComputeTest.testPCEFromPostCompute$lambda$13(valueWithPostCompute), (int)23, null);
            Thread t2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"t2", (int)0, () -> ValueWithPostComputeTest.testPCEFromPostCompute$lambda$14(t1CalledCalculate, t2AccessedTheCache, resultRef, valueWithPostCompute), (int)23, null);
            t2.join();
            t1.join();
            Object result = resultRef.get();
            if (result instanceof Throwable) {
                throw (Throwable)result;
            }
            Assertions.assertEquals((Object)"t2", result);
        }
    }

    private static final Pair testTheSameValueIsComputedFromDifferentThreads$lambda$0(int it) {
        return TuplesKt.to((Object)Thread.currentThread().getName(), (Object)Unit.INSTANCE);
    }

    private static final Unit testTheSameValueIsComputedFromDifferentThreads$lambda$1(int n, String string, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit testTheSameValueIsComputedFromDifferentThreads$lambda$3$lambda$2(ConcurrentLinkedQueue $results, ValueWithPostCompute $valueWithPostCompute) {
        $results.offer($valueWithPostCompute.getValue());
        return Unit.INSTANCE;
    }

    private static final Pair testPCEIsRethrownAndNotSavedInCache$lambda$7(int it) {
        return TuplesKt.to((Object)"value", (Object)Unit.INSTANCE);
    }

    private static final Unit testPCEIsRethrownAndNotSavedInCache$lambda$8(int n, String string, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        throw new ProcessCanceledException();
    }

    private static final Pair testPCEFromPostCompute$lambda$11(CountDownLatch $t1CalledCalculate, int it) {
        if (Intrinsics.areEqual((Object)Thread.currentThread().getName(), (Object)"t1")) {
            $t1CalledCalculate.countDown();
        }
        return TuplesKt.to((Object)Thread.currentThread().getName(), (Object)Unit.INSTANCE);
    }

    private static final Unit testPCEFromPostCompute$lambda$12(CountDownLatch $t2AccessedTheCache, int n, String string, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        $t2AccessedTheCache.await();
        if (Intrinsics.areEqual((Object)Thread.currentThread().getName(), (Object)"t1")) {
            throw new ProcessCanceledException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit testPCEFromPostCompute$lambda$13(ValueWithPostCompute $valueWithPostCompute) {
        try {
            $valueWithPostCompute.getValue();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final Unit testPCEFromPostCompute$lambda$14(CountDownLatch $t1CalledCalculate, CountDownLatch $t2AccessedTheCache, AtomicReference $resultRef, ValueWithPostCompute $valueWithPostCompute) {
        $t1CalledCalculate.await();
        $t2AccessedTheCache.countDown();
        try {
            $resultRef.set($valueWithPostCompute.getValue());
        }
        catch (Throwable e) {
            $resultRef.set(e);
        }
        return Unit.INSTANCE;
    }
}

