/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostic.compiler.based;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/tests-spec/testData/diagnostics")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeSpecTestGenerated extends AbstractLLFirDiagnosticCompilerTestDataSpecTest {
  @Test
  public void testAllFilesPresentInDiagnostics() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "helpers", "linked/annotations", "linked/built-in-types-and-their-semantics", "linked/control--and-data-flow-analysis.control-flow-graph.expressions-1.conditional-expressions", "linked/control--and-data-flow-analysis/performing-analysis-on-the-control-flow-graph", "linked/declarations/classifier-declaration/class-declaration/nested-and-inner-classifiers", "linked/declarations/classifier-declaration/classifier-initialization", "linked/declarations/classifier-declaration/data-class-declaration", "linked/declarations/function-declaration", "linked/declarations/property-declaration/property-initialization", "linked/declarations/type-alias", "linked/expressions/call-and-property-access-expressions", "linked/expressions/function-literals", "linked/inheritance", "linked/overload-resolution/c-level-partition", "linked/overload-resolution/determining-function-applicability-for-a-specific-call/rationale", "linked/overloadable-operators", "linked/statements/assignments/simple-assignments", "linked/type-inference/local-type-inference", "linked/type-inference/smart-casts/smart-cast-types", "linked/type-system/subtyping/subtyping-for-nullable-types", "linked/type-system/type-kinds/type-parameters");
  }

  @Nested
  @TestMetadata("compiler/tests-spec/testData/diagnostics/linked")
  @TestDataPath("$PROJECT_ROOT")
  public class Linked {
    @Test
    public void testAllFilesPresentInLinked() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "annotations", "built-in-types-and-their-semantics", "control--and-data-flow-analysis.control-flow-graph.expressions-1.conditional-expressions", "control--and-data-flow-analysis/performing-analysis-on-the-control-flow-graph", "declarations/classifier-declaration/class-declaration/nested-and-inner-classifiers", "declarations/classifier-declaration/classifier-initialization", "declarations/classifier-declaration/data-class-declaration", "declarations/function-declaration", "declarations/property-declaration/property-initialization", "declarations/type-alias", "expressions/call-and-property-access-expressions", "expressions/function-literals", "inheritance", "overload-resolution/c-level-partition", "overload-resolution/determining-function-applicability-for-a-specific-call/rationale", "overloadable-operators", "statements/assignments/simple-assignments", "type-inference/local-type-inference", "type-inference/smart-casts/smart-cast-types", "type-system/subtyping/subtyping-for-nullable-types", "type-system/type-kinds/type-parameters");
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis")
    @TestDataPath("$PROJECT_ROOT")
    public class Control__and_data_flow_analysis {
      @Test
      public void testAllFilesPresentInControl__and_data_flow_analysis() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "performing-analysis-on-the-control-flow-graph");
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph")
      @TestDataPath("$PROJECT_ROOT")
      public class Control_flow_graph {
        @Test
        public void testAllFilesPresentInControl_flow_graph() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1")
        @TestDataPath("$PROJECT_ROOT")
        public class Expressions_1 {
          @Test
          public void testAllFilesPresentInExpressions_1() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions")
          @TestDataPath("$PROJECT_ROOT")
          public class Conditional_expressions {
            @Test
            public void testAllFilesPresentInConditional_expressions() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1")
            @TestDataPath("$PROJECT_ROOT")
            public class P_1 {
              @Test
              public void testAllFilesPresentInP_1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.1.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.2.kt");
                }

                @Test
                @TestMetadata("1.3.kt")
                public void test1_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.3.kt");
                }

                @Test
                @TestMetadata("1.4.kt")
                public void test1_4() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.4.kt");
                }

                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/2.1.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos/1.1.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos/1.2.kt");
                }

                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos/2.1.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations")
    @TestDataPath("$PROJECT_ROOT")
    public class Declarations {
      @Test
      public void testAllFilesPresentInDeclarations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "classifier-declaration/class-declaration/nested-and-inner-classifiers", "classifier-declaration/classifier-initialization", "classifier-declaration/data-class-declaration", "function-declaration", "property-declaration/property-initialization", "type-alias");
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration")
      @TestDataPath("$PROJECT_ROOT")
      public class Classifier_declaration {
        @Test
        public void testAllFilesPresentInClassifier_declaration() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "class-declaration/nested-and-inner-classifiers", "classifier-initialization", "data-class-declaration");
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration")
        @TestDataPath("$PROJECT_ROOT")
        public class Class_declaration {
          @Test
          public void testAllFilesPresentInClass_declaration() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "nested-and-inner-classifiers");
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes")
          @TestDataPath("$PROJECT_ROOT")
          public class Abstract_classes {
            @Test
            public void testAllFilesPresentInAbstract_classes() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1")
            @TestDataPath("$PROJECT_ROOT")
            public class P_1 {
              @Test
              public void testAllFilesPresentInP_1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg/1.1.kt");
                }

                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg/2.1.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/pos/2.1.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2")
            @TestDataPath("$PROJECT_ROOT")
            public class P_2 {
              @Test
              public void testAllFilesPresentInP_2() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.1.kt");
                }

                @Test
                @TestMetadata("1.10.kt")
                public void test1_10() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.10.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.2.kt");
                }

                @Test
                @TestMetadata("1.3.kt")
                public void test1_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.3.kt");
                }

                @Test
                @TestMetadata("1.4.kt")
                public void test1_4() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.4.kt");
                }

                @Test
                @TestMetadata("1.5.kt")
                public void test1_5() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.5.kt");
                }

                @Test
                @TestMetadata("1.6.kt")
                public void test1_6() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.6.kt");
                }

                @Test
                @TestMetadata("1.7.kt")
                public void test1_7() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.7.kt");
                }

                @Test
                @TestMetadata("1.8.kt")
                public void test1_8() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.8.kt");
                }

                @Test
                @TestMetadata("1.9.kt")
                public void test1_9() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.9.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.1.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.2.kt");
                }

                @Test
                @TestMetadata("1.3.kt")
                public void test1_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.3.kt");
                }

                @Test
                @TestMetadata("1.4.kt")
                public void test1_4() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.4.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration")
          @TestDataPath("$PROJECT_ROOT")
          public class Constructor_declaration {
            @Test
            public void testAllFilesPresentInConstructor_declaration() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4")
            @TestDataPath("$PROJECT_ROOT")
            public class P_4 {
              @Test
              public void testAllFilesPresentInP_4() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4/pos/1.1.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5")
            @TestDataPath("$PROJECT_ROOT")
            public class P_5 {
              @Test
              public void testAllFilesPresentInP_5() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/1.1.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/1.2.kt");
                }

                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/2.1.kt");
                }

                @Test
                @TestMetadata("3.1.kt")
                public void test3_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/3.1.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.1.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.2.kt");
                }

                @Test
                @TestMetadata("1.3.kt")
                public void test1_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.3.kt");
                }

                @Test
                @TestMetadata("1.4.kt")
                public void test1_4() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.4.kt");
                }

                @Test
                @TestMetadata("1.5.kt")
                public void test1_5() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.5.kt");
                }

                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.1.kt");
                }

                @Test
                @TestMetadata("2.2.kt")
                public void test2_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.2.kt");
                }

                @Test
                @TestMetadata("2.3.kt")
                public void test2_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.3.kt");
                }

                @Test
                @TestMetadata("2.4.kt")
                public void test2_4() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.4.kt");
                }

                @Test
                @TestMetadata("3.1.kt")
                public void test3_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.1.kt");
                }

                @Test
                @TestMetadata("3.2.kt")
                public void test3_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.2.kt");
                }

                @Test
                @TestMetadata("3.3.kt")
                public void test3_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.3.kt");
                }

                @Test
                @TestMetadata("3.4.kt")
                public void test3_4() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.4.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration")
      @TestDataPath("$PROJECT_ROOT")
      public class Property_declaration {
        @Test
        public void testAllFilesPresentInProperty_declaration() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "property-initialization");
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration")
        @TestDataPath("$PROJECT_ROOT")
        public class Local_property_declaration {
          @Test
          public void testAllFilesPresentInLocal_property_declaration() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions")
    @TestDataPath("$PROJECT_ROOT")
    public class Expressions {
      @Test
      public void testAllFilesPresentInExpressions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "call-and-property-access-expressions", "function-literals");
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Additive_expression {
        @Test
        public void testAllFilesPresentInAdditive_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4")
        @TestDataPath("$PROJECT_ROOT")
        public class P_4 {
          @Test
          public void testAllFilesPresentInP_4() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics")
      @TestDataPath("$PROJECT_ROOT")
      public class Built_in_types_and_their_semantics {
        @Test
        public void testAllFilesPresentInBuilt_in_types_and_their_semantics() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1")
        @TestDataPath("$PROJECT_ROOT")
        public class Kotlin_nothing_1 {
          @Test
          public void testAllFilesPresentInKotlin_nothing_1() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit")
        @TestDataPath("$PROJECT_ROOT")
        public class Kotlin_unit {
          @Test
          public void testAllFilesPresentInKotlin_unit() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Comparison_expressions {
        @Test
        public void testAllFilesPresentInComparison_expressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1")
        @TestDataPath("$PROJECT_ROOT")
        public class P_1 {
          @Test
          public void testAllFilesPresentInP_1() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1/neg/2.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4")
        @TestDataPath("$PROJECT_ROOT")
        public class P_4 {
          @Test
          public void testAllFilesPresentInP_4() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4/neg/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5")
        @TestDataPath("$PROJECT_ROOT")
        public class P_5 {
          @Test
          public void testAllFilesPresentInP_5() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Conditional_expression {
        @Test
        public void testAllFilesPresentInConditional_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6")
        @TestDataPath("$PROJECT_ROOT")
        public class P_6 {
          @Test
          public void testAllFilesPresentInP_6() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/neg/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals")
      @TestDataPath("$PROJECT_ROOT")
      public class Constant_literals {
        @Test
        public void testAllFilesPresentInConstant_literals() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals")
        @TestDataPath("$PROJECT_ROOT")
        public class Boolean_literals {
          @Test
          public void testAllFilesPresentInBoolean_literals() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg/2.1.kt");
              }

              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg/3.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.1.kt");
              }

              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos/3.1.kt");
              }

              @Test
              @TestMetadata("3.2.kt")
              public void test3_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos/3.2.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals")
        @TestDataPath("$PROJECT_ROOT")
        public class Character_literals {
          @Test
          public void testAllFilesPresentInCharacter_literals() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4")
          @TestDataPath("$PROJECT_ROOT")
          public class P_4 {
            @Test
            public void testAllFilesPresentInP_4() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos/1.2.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals")
        @TestDataPath("$PROJECT_ROOT")
        public class Integer_literals {
          @Test
          public void testAllFilesPresentInInteger_literals() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals")
          @TestDataPath("$PROJECT_ROOT")
          public class Binary_integer_literals {
            @Test
            public void testAllFilesPresentInBinary_integer_literals() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1")
            @TestDataPath("$PROJECT_ROOT")
            public class P_1 {
              @Test
              public void testAllFilesPresentInP_1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/1.1.kt");
                }

                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.1.kt");
                }

                @Test
                @TestMetadata("2.2.kt")
                public void test2_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.2.kt");
                }

                @Test
                @TestMetadata("2.3.kt")
                public void test2_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.3.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals")
          @TestDataPath("$PROJECT_ROOT")
          public class Decimal_integer_literals {
            @Test
            public void testAllFilesPresentInDecimal_integer_literals() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1")
            @TestDataPath("$PROJECT_ROOT")
            public class P_1 {
              @Test
              public void testAllFilesPresentInP_1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.1.kt");
                }

                @Test
                @TestMetadata("2.2.kt")
                public void test2_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.2.kt");
                }

                @Test
                @TestMetadata("2.3.kt")
                public void test2_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.3.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals")
          @TestDataPath("$PROJECT_ROOT")
          public class Hexadecimal_integer_literals {
            @Test
            public void testAllFilesPresentInHexadecimal_integer_literals() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1")
            @TestDataPath("$PROJECT_ROOT")
            public class P_1 {
              @Test
              public void testAllFilesPresentInP_1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/1.1.kt");
                }

                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.1.kt");
                }

                @Test
                @TestMetadata("2.2.kt")
                public void test2_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.2.kt");
                }

                @Test
                @TestMetadata("2.3.kt")
                public void test2_3() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.3.kt");
                }

                @Test
                @TestMetadata("2.4.kt")
                public void test2_4() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.4.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals")
        @TestDataPath("$PROJECT_ROOT")
        public class Real_literals {
          @Test
          public void testAllFilesPresentInReal_literals() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg/1.1.kt");
              }

              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg/3.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/1.2.kt");
              }

              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/3.1.kt");
              }

              @Test
              @TestMetadata("3.2.kt")
              public void test3_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/3.2.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.4.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos/1.2.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg/1.2.kt");
              }

              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg/2.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.4.kt");
              }

              @Test
              @TestMetadata("1.5.kt")
              public void test1_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.5.kt");
              }

              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/2.3.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4")
          @TestDataPath("$PROJECT_ROOT")
          public class P_4 {
            @Test
            public void testAllFilesPresentInP_4() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/1.2.kt");
              }

              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/2.3.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.4.kt");
              }

              @Test
              @TestMetadata("1.5.kt")
              public void test1_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.5.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5")
          @TestDataPath("$PROJECT_ROOT")
          public class P_5 {
            @Test
            public void testAllFilesPresentInP_5() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.4.kt");
              }

              @Test
              @TestMetadata("1.5.kt")
              public void test1_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.5.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals")
        @TestDataPath("$PROJECT_ROOT")
        public class The_types_for_integer_literals {
          @Test
          public void testAllFilesPresentInThe_types_for_integer_literals() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/1.3.kt");
              }

              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.5.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.5.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Elvis_operator_expression {
        @Test
        public void testAllFilesPresentInElvis_operator_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3")
        @TestDataPath("$PROJECT_ROOT")
        public class P_3 {
          @Test
          public void testAllFilesPresentInP_3() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Equality_expressions {
        @Test
        public void testAllFilesPresentInEquality_expressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions")
        @TestDataPath("$PROJECT_ROOT")
        public class Value_equality_expressions {
          @Test
          public void testAllFilesPresentInValue_equality_expressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Jump_expressions {
        @Test
        public void testAllFilesPresentInJump_expressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Break_expression {
          @Test
          public void testAllFilesPresentInBreak_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Continue_expression {
          @Test
          public void testAllFilesPresentInContinue_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions")
        @TestDataPath("$PROJECT_ROOT")
        public class Return_expressions {
          @Test
          public void testAllFilesPresentInReturn_expressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4")
          @TestDataPath("$PROJECT_ROOT")
          public class P_4 {
            @Test
            public void testAllFilesPresentInP_4() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Logical_conjunction_expression {
        @Test
        public void testAllFilesPresentInLogical_conjunction_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/neg/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Logical_disjunction_expression {
        @Test
        public void testAllFilesPresentInLogical_disjunction_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/neg/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Multiplicative_expression {
        @Test
        public void testAllFilesPresentInMultiplicative_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5")
        @TestDataPath("$PROJECT_ROOT")
        public class P_5 {
          @Test
          public void testAllFilesPresentInP_5() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Not_null_assertion_expression {
        @Test
        public void testAllFilesPresentInNot_null_assertion_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3")
        @TestDataPath("$PROJECT_ROOT")
        public class P_3 {
          @Test
          public void testAllFilesPresentInP_3() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Prefix_expressions {
        @Test
        public void testAllFilesPresentInPrefix_expressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Logical_not_expression {
          @Test
          public void testAllFilesPresentInLogical_not_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Prefix_decrement_expression {
          @Test
          public void testAllFilesPresentInPrefix_decrement_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4")
          @TestDataPath("$PROJECT_ROOT")
          public class P_4 {
            @Test
            public void testAllFilesPresentInP_4() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5")
          @TestDataPath("$PROJECT_ROOT")
          public class P_5 {
            @Test
            public void testAllFilesPresentInP_5() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/neg/2.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Prefix_increment_expression {
          @Test
          public void testAllFilesPresentInPrefix_increment_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4")
          @TestDataPath("$PROJECT_ROOT")
          public class P_4 {
            @Test
            public void testAllFilesPresentInP_4() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5")
          @TestDataPath("$PROJECT_ROOT")
          public class P_5 {
            @Test
            public void testAllFilesPresentInP_5() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/neg/2.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Unary_minus_expression {
          @Test
          public void testAllFilesPresentInUnary_minus_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Unary_plus_expression {
          @Test
          public void testAllFilesPresentInUnary_plus_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Range_expression {
        @Test
        public void testAllFilesPresentInRange_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4")
        @TestDataPath("$PROJECT_ROOT")
        public class P_4 {
          @Test
          public void testAllFilesPresentInP_4() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class Try_expression {
        @Test
        public void testAllFilesPresentInTry_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1")
        @TestDataPath("$PROJECT_ROOT")
        public class P_1 {
          @Test
          public void testAllFilesPresentInP_1() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/1.1.kt");
            }

            @Test
            @TestMetadata("3.1.kt")
            public void test3_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/3.1.kt");
            }

            @Test
            @TestMetadata("4.1.kt")
            public void test4_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/4.1.kt");
            }

            @Test
            @TestMetadata("5.1.kt")
            public void test5_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/5.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/1.1.kt");
            }

            @Test
            @TestMetadata("3.1.kt")
            public void test3_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/3.1.kt");
            }

            @Test
            @TestMetadata("3.2.kt")
            public void test3_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/3.2.kt");
            }

            @Test
            @TestMetadata("4.1.kt")
            public void test4_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/4.1.kt");
            }

            @Test
            @TestMetadata("4.2.kt")
            public void test4_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/4.2.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2/pos/2.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5")
        @TestDataPath("$PROJECT_ROOT")
        public class P_5 {
          @Test
          public void testAllFilesPresentInP_5() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos/1.1.kt");
            }

            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos/2.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8")
        @TestDataPath("$PROJECT_ROOT")
        public class P_8 {
          @Test
          public void testAllFilesPresentInP_8() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/neg/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Type_checking_and_containment_checking_expressions {
        @Test
        public void testAllFilesPresentInType_checking_and_containment_checking_expressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Containment_checking_expression {
          @Test
          public void testAllFilesPresentInContainment_checking_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5")
          @TestDataPath("$PROJECT_ROOT")
          public class P_5 {
            @Test
            public void testAllFilesPresentInP_5() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/pos/2.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression")
        @TestDataPath("$PROJECT_ROOT")
        public class Type_checking_expression {
          @Test
          public void testAllFilesPresentInType_checking_expression() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4")
          @TestDataPath("$PROJECT_ROOT")
          public class P_4 {
            @Test
            public void testAllFilesPresentInP_4() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression")
      @TestDataPath("$PROJECT_ROOT")
      public class When_expression {
        @Test
        public void testAllFilesPresentInWhen_expression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions")
        @TestDataPath("$PROJECT_ROOT")
        public class Exhaustive_when_expressions {
          @Test
          public void testAllFilesPresentInExhaustive_when_expressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("11.1.kt")
              public void test11_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/11.1.kt");
              }

              @Test
              @TestMetadata("11.2.kt")
              public void test11_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/11.2.kt");
              }

              @Test
              @TestMetadata("11.3.kt")
              public void test11_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/11.3.kt");
              }

              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/1.2.kt");
              }

              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/3.1.kt");
              }

              @Test
              @TestMetadata("9.1.kt")
              public void test9_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/9.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("10.1.kt")
              public void test10_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/10.1.kt");
              }

              @Test
              @TestMetadata("11.1.kt")
              public void test11_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/11.1.kt");
              }

              @Test
              @TestMetadata("11.2.kt")
              public void test11_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/11.2.kt");
              }

              @Test
              @TestMetadata("11.3.kt")
              public void test11_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/11.3.kt");
              }

              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/1.3.kt");
              }

              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/3.1.kt");
              }

              @Test
              @TestMetadata("7.1.kt")
              public void test7_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/7.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1")
        @TestDataPath("$PROJECT_ROOT")
        public class P_1 {
          @Test
          public void testAllFilesPresentInP_1() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("3.1.kt")
            public void test3_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos/3.1.kt");
            }

            @Test
            @TestMetadata("3.2.kt")
            public void test3_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos/3.2.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg/2.1.kt");
            }

            @Test
            @TestMetadata("2.2.kt")
            public void test2_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg/2.2.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/1.1.kt");
            }

            @Test
            @TestMetadata("1.2.kt")
            public void test1_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/1.2.kt");
            }

            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/2.1.kt");
            }

            @Test
            @TestMetadata("2.2.kt")
            public void test2_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/2.2.kt");
            }

            @Test
            @TestMetadata("2.3.kt")
            public void test2_3() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/2.3.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3")
        @TestDataPath("$PROJECT_ROOT")
        public class P_3 {
          @Test
          public void testAllFilesPresentInP_3() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3/neg/2.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4")
        @TestDataPath("$PROJECT_ROOT")
        public class P_4 {
          @Test
          public void testAllFilesPresentInP_4() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/neg/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/pos/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5")
        @TestDataPath("$PROJECT_ROOT")
        public class P_5 {
          @Test
          public void testAllFilesPresentInP_5() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/neg/1.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos/1.1.kt");
            }

            @Test
            @TestMetadata("1.2.kt")
            public void test1_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos/1.2.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6")
        @TestDataPath("$PROJECT_ROOT")
        public class P_6 {
          @Test
          public void testAllFilesPresentInP_6() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/1.1.kt");
            }

            @Test
            @TestMetadata("1.2.kt")
            public void test1_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/1.2.kt");
            }

            @Test
            @TestMetadata("3.1.kt")
            public void test3_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/3.1.kt");
            }

            @Test
            @TestMetadata("3.2.kt")
            public void test3_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/3.2.kt");
            }

            @Test
            @TestMetadata("5.1.kt")
            public void test5_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/5.1.kt");
            }

            @Test
            @TestMetadata("5.2.kt")
            public void test5_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/5.2.kt");
            }

            @Test
            @TestMetadata("7.1.kt")
            public void test7_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/7.1.kt");
            }

            @Test
            @TestMetadata("7.2.kt")
            public void test7_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/7.2.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.1.kt");
            }

            @Test
            @TestMetadata("1.2.kt")
            public void test1_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.2.kt");
            }

            @Test
            @TestMetadata("1.3.kt")
            public void test1_3() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.3.kt");
            }

            @Test
            @TestMetadata("1.4.kt")
            public void test1_4() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.4.kt");
            }

            @Test
            @TestMetadata("3.1.kt")
            public void test3_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/3.1.kt");
            }

            @Test
            @TestMetadata("3.2.kt")
            public void test3_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/3.2.kt");
            }

            @Test
            @TestMetadata("5.1.kt")
            public void test5_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/5.1.kt");
            }

            @Test
            @TestMetadata("5.2.kt")
            public void test5_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/5.2.kt");
            }

            @Test
            @TestMetadata("6.1.kt")
            public void test6_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/6.1.kt");
            }

            @Test
            @TestMetadata("7.1.kt")
            public void test7_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/7.1.kt");
            }

            @Test
            @TestMetadata("7.2.kt")
            public void test7_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/7.2.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution")
    @TestDataPath("$PROJECT_ROOT")
    public class Overload_resolution {
      @Test
      public void testAllFilesPresentInOverload_resolution() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "c-level-partition", "determining-function-applicability-for-a-specific-call/rationale");
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs")
      @TestDataPath("$PROJECT_ROOT")
      public class Building_the_overload_candidate_set_ocs {
        @Test
        public void testAllFilesPresentInBuilding_the_overload_candidate_set_ocs() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver")
        @TestDataPath("$PROJECT_ROOT")
        public class Call_with_an_explicit_receiver {
          @Test
          public void testAllFilesPresentInCall_with_an_explicit_receiver() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver")
          @TestDataPath("$PROJECT_ROOT")
          public class Call_with_an_explicit_type_receiver {
            @Test
            public void testAllFilesPresentInCall_with_an_explicit_type_receiver() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3")
            @TestDataPath("$PROJECT_ROOT")
            public class P_3 {
              @Test
              public void testAllFilesPresentInP_3() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3/pos/2.1.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6")
          @TestDataPath("$PROJECT_ROOT")
          public class P_6 {
            @Test
            public void testAllFilesPresentInP_6() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.4.kt");
              }

              @Test
              @TestMetadata("1.5.kt")
              public void test1_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.5.kt");
              }

              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.4.kt");
              }

              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/3.1.kt");
              }

              @Test
              @TestMetadata("3.2.kt")
              public void test3_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/3.2.kt");
              }

              @Test
              @TestMetadata("4.1.kt")
              public void test4_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/4.1.kt");
              }

              @Test
              @TestMetadata("4.2.kt")
              public void test4_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/4.2.kt");
              }

              @Test
              @TestMetadata("5.1.kt")
              public void test5_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/5.1.kt");
              }

              @Test
              @TestMetadata("5.2.kt")
              public void test5_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/5.2.kt");
              }

              @Test
              @TestMetadata("6.1.kt")
              public void test6_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/6.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters")
        @TestDataPath("$PROJECT_ROOT")
        public class Call_with_named_parameters {
          @Test
          public void testAllFilesPresentInCall_with_named_parameters() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.10.kt")
              public void test2_10() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.10.kt");
              }

              @Test
              @TestMetadata("2.11.kt")
              public void test2_11() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.11.kt");
              }

              @Test
              @TestMetadata("2.12.kt")
              public void test2_12() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.12.kt");
              }

              @Test
              @TestMetadata("2.13.kt")
              public void test2_13() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.13.kt");
              }

              @Test
              @TestMetadata("2.14.kt")
              public void test2_14() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.14.kt");
              }

              @Test
              @TestMetadata("2.15.kt")
              public void test2_15() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.15.kt");
              }

              @Test
              @TestMetadata("2.16.kt")
              public void test2_16() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.16.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.5.kt");
              }

              @Test
              @TestMetadata("2.6.kt")
              public void test2_6() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.6.kt");
              }

              @Test
              @TestMetadata("2.7.kt")
              public void test2_7() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.7.kt");
              }

              @Test
              @TestMetadata("2.8.kt")
              public void test2_8() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.8.kt");
              }

              @Test
              @TestMetadata("2.9.kt")
              public void test2_9() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.9.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5")
          @TestDataPath("$PROJECT_ROOT")
          public class P_5 {
            @Test
            public void testAllFilesPresentInP_5() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters")
        @TestDataPath("$PROJECT_ROOT")
        public class Call_with_specified_type_parameters {
          @Test
          public void testAllFilesPresentInCall_with_specified_type_parameters() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions")
        @TestDataPath("$PROJECT_ROOT")
        public class Call_with_trailing_lambda_expressions {
          @Test
          public void testAllFilesPresentInCall_with_trailing_lambda_expressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.10.kt")
              public void test2_10() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.10.kt");
              }

              @Test
              @TestMetadata("2.11.kt")
              public void test2_11() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.11.kt");
              }

              @Test
              @TestMetadata("2.12.kt")
              public void test2_12() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.12.kt");
              }

              @Test
              @TestMetadata("2.13.kt")
              public void test2_13() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.13.kt");
              }

              @Test
              @TestMetadata("2.14.kt")
              public void test2_14() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.14.kt");
              }

              @Test
              @TestMetadata("2.15.kt")
              public void test2_15() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.15.kt");
              }

              @Test
              @TestMetadata("2.16.kt")
              public void test2_16() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.16.kt");
              }

              @Test
              @TestMetadata("2.17.kt")
              public void test2_17() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.17.kt");
              }

              @Test
              @TestMetadata("2.18.kt")
              public void test2_18() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.18.kt");
              }

              @Test
              @TestMetadata("2.19.kt")
              public void test2_19() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.19.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.20.kt")
              public void test2_20() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.20.kt");
              }

              @Test
              @TestMetadata("2.21.kt")
              public void test2_21() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.21.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.5.kt");
              }

              @Test
              @TestMetadata("2.6.kt")
              public void test2_6() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.6.kt");
              }

              @Test
              @TestMetadata("2.7.kt")
              public void test2_7() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.7.kt");
              }

              @Test
              @TestMetadata("2.8.kt")
              public void test2_8() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.8.kt");
              }

              @Test
              @TestMetadata("2.9.kt")
              public void test2_9() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.9.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver")
        @TestDataPath("$PROJECT_ROOT")
        public class Call_without_an_explicit_receiver {
          @Test
          public void testAllFilesPresentInCall_without_an_explicit_receiver() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5")
          @TestDataPath("$PROJECT_ROOT")
          public class P_5 {
            @Test
            public void testAllFilesPresentInP_5() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/2.5.kt");
              }

              @Test
              @TestMetadata("4.1.kt")
              public void test4_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/4.1.kt");
              }

              @Test
              @TestMetadata("4.2.kt")
              public void test4_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/4.2.kt");
              }

              @Test
              @TestMetadata("6.1.kt")
              public void test6_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/6.1.kt");
              }

              @Test
              @TestMetadata("6.4.kt")
              public void test6_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/6.4.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.5.kt");
              }

              @Test
              @TestMetadata("4.1.kt")
              public void test4_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.1.kt");
              }

              @Test
              @TestMetadata("4.2.kt")
              public void test4_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.2.kt");
              }

              @Test
              @TestMetadata("4.3.kt")
              public void test4_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.3.kt");
              }

              @Test
              @TestMetadata("4.4.kt")
              public void test4_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.4.kt");
              }

              @Test
              @TestMetadata("4.5.kt")
              public void test4_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.5.kt");
              }

              @Test
              @TestMetadata("4.6.kt")
              public void test4_6() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.6.kt");
              }

              @Test
              @TestMetadata("5.1.kt")
              public void test5_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/5.1.kt");
              }

              @Test
              @TestMetadata("6.1.kt")
              public void test6_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/6.1.kt");
              }

              @Test
              @TestMetadata("6.2.kt")
              public void test6_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/6.2.kt");
              }

              @Test
              @TestMetadata("6.3.kt")
              public void test6_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/6.3.kt");
              }

              @Test
              @TestMetadata("7.1.kt")
              public void test7_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/7.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call")
        @TestDataPath("$PROJECT_ROOT")
        public class Infix_function_call {
          @Test
          public void testAllFilesPresentInInfix_function_call() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.4.kt");
              }

              @Test
              @TestMetadata("4.5.kt")
              public void test4_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/4.5.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("4.1.kt")
              public void test4_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.1.kt");
              }

              @Test
              @TestMetadata("4.2.kt")
              public void test4_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.2.kt");
              }

              @Test
              @TestMetadata("4.3.kt")
              public void test4_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.3.kt");
              }

              @Test
              @TestMetadata("4.4.kt")
              public void test4_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.4.kt");
              }

              @Test
              @TestMetadata("4.5.kt")
              public void test4_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.5.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call")
        @TestDataPath("$PROJECT_ROOT")
        public class Operator_call {
          @Test
          public void testAllFilesPresentInOperator_call() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.2.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.5.kt");
              }

              @Test
              @TestMetadata("2.6.kt")
              public void test2_6() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.6.kt");
              }

              @Test
              @TestMetadata("2.7.kt")
              public void test2_7() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.7.kt");
              }

              @Test
              @TestMetadata("2.8.kt")
              public void test2_8() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.8.kt");
              }

              @Test
              @TestMetadata("2.9.kt")
              public void test2_9() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.9.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.3.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("3.1.kt")
              public void test3_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.1.kt");
              }

              @Test
              @TestMetadata("3.2.kt")
              public void test3_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.2.kt");
              }

              @Test
              @TestMetadata("3.3.kt")
              public void test3_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.3.kt");
              }

              @Test
              @TestMetadata("3.4.kt")
              public void test3_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.4.kt");
              }

              @Test
              @TestMetadata("3.5.kt")
              public void test3_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.5.kt");
              }

              @Test
              @TestMetadata("3.6.kt")
              public void test3_6() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.6.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4")
          @TestDataPath("$PROJECT_ROOT")
          public class P_4 {
            @Test
            public void testAllFilesPresentInP_4() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention")
      @TestDataPath("$PROJECT_ROOT")
      public class Callables_and_invoke_convention {
        @Test
        public void testAllFilesPresentInCallables_and_invoke_convention() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("10.1.kt")
            public void test10_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos/10.1.kt");
            }

            @Test
            @TestMetadata("8.1.kt")
            public void test8_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos/8.1.kt");
            }

            @Test
            @TestMetadata("9.1.kt")
            public void test9_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos/9.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set")
      @TestDataPath("$PROJECT_ROOT")
      public class Choosing_the_most_specific_candidate_from_the_overload_candidate_set {
        @Test
        public void testAllFilesPresentInChoosing_the_most_specific_candidate_from_the_overload_candidate_set() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection")
        @TestDataPath("$PROJECT_ROOT")
        public class Algorithm_of_msc_selection {
          @Test
          public void testAllFilesPresentInAlgorithm_of_msc_selection() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11")
          @TestDataPath("$PROJECT_ROOT")
          public class P_11 {
            @Test
            public void testAllFilesPresentInP_11() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/1.2.kt");
              }

              @Test
              @TestMetadata("4.1.kt")
              public void test4_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.1.kt");
              }

              @Test
              @TestMetadata("4.2.kt")
              public void test4_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.2.kt");
              }

              @Test
              @TestMetadata("4.3.kt")
              public void test4_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.3.kt");
              }

              @Test
              @TestMetadata("4.4.kt")
              public void test4_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.4.kt");
              }

              @Test
              @TestMetadata("4.5.kt")
              public void test4_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.5.kt");
              }

              @Test
              @TestMetadata("5.1.kt")
              public void test5_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/5.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12")
          @TestDataPath("$PROJECT_ROOT")
          public class P_12 {
            @Test
            public void testAllFilesPresentInP_12() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.3.kt");
              }

              @Test
              @TestMetadata("2.4.kt")
              public void test2_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.4.kt");
              }

              @Test
              @TestMetadata("2.5.kt")
              public void test2_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.5.kt");
              }

              @Test
              @TestMetadata("2.6.kt")
              public void test2_6() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.6.kt");
              }

              @Test
              @TestMetadata("2.7.kt")
              public void test2_7() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.7.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14")
          @TestDataPath("$PROJECT_ROOT")
          public class P_14 {
            @Test
            public void testAllFilesPresentInP_14() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.4.kt");
              }

              @Test
              @TestMetadata("1.5.kt")
              public void test1_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.5.kt");
              }

              @Test
              @TestMetadata("1.6.kt")
              public void test1_6() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.6.kt");
              }

              @Test
              @TestMetadata("1.7.kt")
              public void test1_7() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.7.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17")
          @TestDataPath("$PROJECT_ROOT")
          public class P_17 {
            @Test
            public void testAllFilesPresentInP_17() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg/2.2.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.4.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9")
          @TestDataPath("$PROJECT_ROOT")
          public class P_9 {
            @Test
            public void testAllFilesPresentInP_9() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg/2.1.kt");
              }

              @Test
              @TestMetadata("2.2.kt")
              public void test2_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg/2.2.kt");
              }

              @Test
              @TestMetadata("2.3.kt")
              public void test2_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg/2.3.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1")
        @TestDataPath("$PROJECT_ROOT")
        public class Rationale_1 {
          @Test
          public void testAllFilesPresentInRationale_1() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call")
      @TestDataPath("$PROJECT_ROOT")
      public class Determining_function_applicability_for_a_specific_call {
        @Test
        public void testAllFilesPresentInDetermining_function_applicability_for_a_specific_call() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "rationale");
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description")
        @TestDataPath("$PROJECT_ROOT")
        public class Description {
          @Test
          public void testAllFilesPresentInDescription() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2/neg/2.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers")
      @TestDataPath("$PROJECT_ROOT")
      public class Receivers {
        @Test
        public void testAllFilesPresentInReceivers() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5")
        @TestDataPath("$PROJECT_ROOT")
        public class P_5 {
          @Test
          public void testAllFilesPresentInP_5() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos/2.1.kt");
            }

            @Test
            @TestMetadata("3.1.kt")
            public void test3_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos/3.1.kt");
            }

            @Test
            @TestMetadata("5.1.kt")
            public void test5_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos/5.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references")
      @TestDataPath("$PROJECT_ROOT")
      public class Resolving_callable_references {
        @Test
        public void testAllFilesPresentInResolving_callable_references() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls")
        @TestDataPath("$PROJECT_ROOT")
        public class Bidirectional_resolution_for_callable_calls {
          @Test
          public void testAllFilesPresentInBidirectional_resolution_for_callable_calls() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.4.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2/pos/2.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call")
        @TestDataPath("$PROJECT_ROOT")
        public class Resolving_callable_references_not_used_as_arguments_to_a_call {
          @Test
          public void testAllFilesPresentInResolving_callable_references_not_used_as_arguments_to_a_call() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.3.kt");
              }

              @Test
              @TestMetadata("1.4.kt")
              public void test1_4() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.4.kt");
              }

              @Test
              @TestMetadata("1.5.kt")
              public void test1_5() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.5.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos/1.3.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements")
    @TestDataPath("$PROJECT_ROOT")
    public class Statements {
      @Test
      public void testAllFilesPresentInStatements() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "assignments/simple-assignments");
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments")
      @TestDataPath("$PROJECT_ROOT")
      public class Assignments {
        @Test
        public void testAllFilesPresentInAssignments() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "simple-assignments");
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments")
        @TestDataPath("$PROJECT_ROOT")
        public class Operator_assignments {
          @Test
          public void testAllFilesPresentInOperator_assignments() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1")
        @TestDataPath("$PROJECT_ROOT")
        public class P_1 {
          @Test
          public void testAllFilesPresentInP_1() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1/neg/2.1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2")
        @TestDataPath("$PROJECT_ROOT")
        public class P_2 {
          @Test
          public void testAllFilesPresentInP_2() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg/1.1.kt");
            }

            @Test
            @TestMetadata("1.2.kt")
            public void test1_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg/1.2.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements")
      @TestDataPath("$PROJECT_ROOT")
      public class Loop_statements {
        @Test
        public void testAllFilesPresentInLoop_statements() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement")
        @TestDataPath("$PROJECT_ROOT")
        public class Do_while_loop_statement {
          @Test
          public void testAllFilesPresentInDo_while_loop_statement() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement")
        @TestDataPath("$PROJECT_ROOT")
        public class While_loop_statement {
          @Test
          public void testAllFilesPresentInWhile_loop_statement() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3")
          @TestDataPath("$PROJECT_ROOT")
          public class P_3 {
            @Test
            public void testAllFilesPresentInP_3() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference")
    @TestDataPath("$PROJECT_ROOT")
    public class Type_inference {
      @Test
      public void testAllFilesPresentInType_inference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "local-type-inference", "smart-casts/smart-cast-types");
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts")
      @TestDataPath("$PROJECT_ROOT")
      public class Smart_casts {
        @Test
        public void testAllFilesPresentInSmart_casts() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "smart-cast-types");
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability")
        @TestDataPath("$PROJECT_ROOT")
        public class Smart_cast_sink_stability {
          @Test
          public void testAllFilesPresentInSmart_cast_sink_stability() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5")
          @TestDataPath("$PROJECT_ROOT")
          public class P_5 {
            @Test
            public void testAllFilesPresentInP_5() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/neg/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system")
    @TestDataPath("$PROJECT_ROOT")
    public class Type_system {
      @Test
      public void testAllFilesPresentInType_system() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "subtyping/subtyping-for-nullable-types", "type-kinds/type-parameters");
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1")
      @TestDataPath("$PROJECT_ROOT")
      public class Introduction_1 {
        @Test
        public void testAllFilesPresentInIntroduction_1() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6")
        @TestDataPath("$PROJECT_ROOT")
        public class P_6 {
          @Test
          public void testAllFilesPresentInP_6() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg/2.1.kt");
            }

            @Test
            @TestMetadata("2.2.kt")
            public void test2_2() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg/2.2.kt");
            }

            @Test
            @TestMetadata("2.3.kt")
            public void test2_3() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg/2.3.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8")
        @TestDataPath("$PROJECT_ROOT")
        public class P_8 {
          @Test
          public void testAllFilesPresentInP_8() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.1.kt")
            public void test1_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos/1.1.kt");
            }

            @Test
            @TestMetadata("2.1.kt")
            public void test2_1() {
              runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos/2.1.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping")
      @TestDataPath("$PROJECT_ROOT")
      public class Subtyping {
        @Test
        public void testAllFilesPresentInSubtyping() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "subtyping-for-nullable-types");
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types")
        @TestDataPath("$PROJECT_ROOT")
        public class Subtyping_for_intersection_types {
          @Test
          public void testAllFilesPresentInSubtyping_for_intersection_types() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos/1.2.kt");
              }

              @Test
              @TestMetadata("1.3.kt")
              public void test1_3() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos/1.3.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules")
        @TestDataPath("$PROJECT_ROOT")
        public class Subtyping_rules {
          @Test
          public void testAllFilesPresentInSubtyping_rules() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2")
          @TestDataPath("$PROJECT_ROOT")
          public class P_2 {
            @Test
            public void testAllFilesPresentInP_2() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2/pos/1.1.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes")
      @TestDataPath("$PROJECT_ROOT")
      public class Type_contexts_and_scopes {
        @Test
        public void testAllFilesPresentInType_contexts_and_scopes() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts")
        @TestDataPath("$PROJECT_ROOT")
        public class Inner_and_nested_type_contexts {
          @Test
          public void testAllFilesPresentInInner_and_nested_type_contexts() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1")
          @TestDataPath("$PROJECT_ROOT")
          public class P_1 {
            @Test
            public void testAllFilesPresentInP_1() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg/1.2.kt");
              }

              @Test
              @TestMetadata("2.1.kt")
              public void test2_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg/2.1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.1.kt")
              public void test1_1() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos/1.1.kt");
              }

              @Test
              @TestMetadata("1.2.kt")
              public void test1_2() {
                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos/1.2.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds")
      @TestDataPath("$PROJECT_ROOT")
      public class Type_kinds {
        @Test
        public void testAllFilesPresentInType_kinds() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "type-parameters");
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types")
        @TestDataPath("$PROJECT_ROOT")
        public class Built_in_types {
          @Test
          public void testAllFilesPresentInBuilt_in_types() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any")
          @TestDataPath("$PROJECT_ROOT")
          public class Kotlin_any {
            @Test
            public void testAllFilesPresentInKotlin_any() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1")
            @TestDataPath("$PROJECT_ROOT")
            public class P_1 {
              @Test
              public void testAllFilesPresentInP_1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos/1.1.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos/1.2.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing")
          @TestDataPath("$PROJECT_ROOT")
          public class Kotlin_nothing {
            @Test
            public void testAllFilesPresentInKotlin_nothing() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1")
            @TestDataPath("$PROJECT_ROOT")
            public class P_1 {
              @Test
              public void testAllFilesPresentInP_1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("2.1.kt")
                public void test2_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/neg/2.1.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.1.kt")
                public void test1_1() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos/1.1.kt");
                }

                @Test
                @TestMetadata("1.2.kt")
                public void test1_2() {
                  runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos/1.2.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }
        }
      }
    }
  }

  @Nested
  @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked")
  @TestDataPath("$PROJECT_ROOT")
  public class NotLinked {
    @Test
    public void testAllFilesPresentInNotLinked() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes")
      @TestDataPath("$PROJECT_ROOT")
      public class Annotation_classes {
        @Test
        public void testAllFilesPresentInAnnotation_classes() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg")
        @TestDataPath("$PROJECT_ROOT")
        public class Neg {
          @Test
          @TestMetadata("1.kt")
          public void test1() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg/1.kt");
          }

          @Test
          public void testAllFilesPresentInNeg() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations")
      @TestDataPath("$PROJECT_ROOT")
      public class Type_annotations {
        @Test
        public void testAllFilesPresentInType_annotations() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg")
        @TestDataPath("$PROJECT_ROOT")
        public class Neg {
          @Test
          @TestMetadata("1.kt")
          public void test1() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/1.kt");
          }

          @Test
          @TestMetadata("10.kt")
          public void test10() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/10.kt");
          }

          @Test
          @TestMetadata("11.kt")
          public void test11() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/11.kt");
          }

          @Test
          @TestMetadata("2.kt")
          public void test2() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/2.kt");
          }

          @Test
          @TestMetadata("3.kt")
          public void test3() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/3.kt");
          }

          @Test
          @TestMetadata("4.kt")
          public void test4() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/4.kt");
          }

          @Test
          @TestMetadata("5.kt")
          public void test5() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/5.kt");
          }

          @Test
          @TestMetadata("6.kt")
          public void test6() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/6.kt");
          }

          @Test
          @TestMetadata("7.kt")
          public void test7() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/7.kt");
          }

          @Test
          @TestMetadata("8.kt")
          public void test8() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/8.kt");
          }

          @Test
          @TestMetadata("9.kt")
          public void test9() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/9.kt");
          }

          @Test
          public void testAllFilesPresentInNeg() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit")
    @TestDataPath("$PROJECT_ROOT")
    public class Coercion_to_unit {
      @Test
      public void testAllFilesPresentInCoercion_to_unit() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit/neg")
      @TestDataPath("$PROJECT_ROOT")
      public class Neg {
        @Test
        @TestMetadata("1.kt")
        public void test1() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit/neg/1.kt");
        }

        @Test
        public void testAllFilesPresentInNeg() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts")
    @TestDataPath("$PROJECT_ROOT")
    public class Contracts {
      @Test
      public void testAllFilesPresentInContracts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis")
      @TestDataPath("$PROJECT_ROOT")
      public class Analysis {
        @Test
        public void testAllFilesPresentInAnalysis() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common")
        @TestDataPath("$PROJECT_ROOT")
        public class Common {
          @Test
          public void testAllFilesPresentInCommon() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.kt")
            public void test1() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg/1.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.kt")
            public void test1() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos/1.kt");
            }

            @Test
            @TestMetadata("2.kt")
            public void test2() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos/2.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow")
        @TestDataPath("$PROJECT_ROOT")
        public class ControlFlow {
          @Test
          public void testAllFilesPresentInControlFlow() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization")
          @TestDataPath("$PROJECT_ROOT")
          public class Initialization {
            @Test
            public void testAllFilesPresentInInitialization() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.kt")
              public void test1() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/1.kt");
              }

              @Test
              @TestMetadata("2.kt")
              public void test2() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/2.kt");
              }

              @Test
              @TestMetadata("3.kt")
              public void test3() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/3.kt");
              }

              @Test
              @TestMetadata("4.kt")
              public void test4() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/4.kt");
              }

              @Test
              @TestMetadata("5.kt")
              public void test5() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/5.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.kt")
              public void test1() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/1.kt");
              }

              @Test
              @TestMetadata("2.kt")
              public void test2() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/2.kt");
              }

              @Test
              @TestMetadata("3.kt")
              public void test3() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/3.kt");
              }

              @Test
              @TestMetadata("4.kt")
              public void test4() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/4.kt");
              }

              @Test
              @TestMetadata("5.kt")
              public void test5() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/5.kt");
              }

              @Test
              @TestMetadata("6.kt")
              public void test6() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/6.kt");
              }

              @Test
              @TestMetadata("7.kt")
              public void test7() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/7.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode")
          @TestDataPath("$PROJECT_ROOT")
          public class UnreachableCode {
            @Test
            public void testAllFilesPresentInUnreachableCode() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.kt")
              public void test1() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg/1.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.kt")
              public void test1() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/1.kt");
              }

              @Test
              @TestMetadata("2.kt")
              public void test2() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/2.kt");
              }

              @Test
              @TestMetadata("3.kt")
              public void test3() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/3.kt");
              }

              @Test
              @TestMetadata("4.kt")
              public void test4() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/4.kt");
              }

              @Test
              @TestMetadata("5.kt")
              public void test5() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/5.kt");
              }

              @Test
              @TestMetadata("6.kt")
              public void test6() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/6.kt");
              }

              @Test
              @TestMetadata("7.kt")
              public void test7() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/7.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts")
        @TestDataPath("$PROJECT_ROOT")
        public class Smartcasts {
          @Test
          public void testAllFilesPresentInSmartcasts() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.kt")
            public void test1() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/1.kt");
            }

            @Test
            @TestMetadata("10.kt")
            public void test10() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/10.kt");
            }

            @Test
            @TestMetadata("11.kt")
            public void test11() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/11.kt");
            }

            @Test
            @TestMetadata("12.kt")
            public void test12() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/12.kt");
            }

            @Test
            @TestMetadata("13.kt")
            public void test13() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/13.kt");
            }

            @Test
            @TestMetadata("14.kt")
            public void test14() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/14.kt");
            }

            @Test
            @TestMetadata("15.kt")
            public void test15() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/15.kt");
            }

            @Test
            @TestMetadata("2.kt")
            public void test2() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/2.kt");
            }

            @Test
            @TestMetadata("3.kt")
            public void test3() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/3.kt");
            }

            @Test
            @TestMetadata("4.kt")
            public void test4() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/4.kt");
            }

            @Test
            @TestMetadata("5.kt")
            public void test5() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/5.kt");
            }

            @Test
            @TestMetadata("6.kt")
            public void test6() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/6.kt");
            }

            @Test
            @TestMetadata("7.kt")
            public void test7() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/7.kt");
            }

            @Test
            @TestMetadata("8.kt")
            public void test8() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/8.kt");
            }

            @Test
            @TestMetadata("9.kt")
            public void test9() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/9.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.kt")
            public void test1() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/1.kt");
            }

            @Test
            @TestMetadata("10.kt")
            public void test10() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/10.kt");
            }

            @Test
            @TestMetadata("11.kt")
            public void test11() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/11.kt");
            }

            @Test
            @TestMetadata("12.kt")
            public void test12() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/12.kt");
            }

            @Test
            @TestMetadata("13.kt")
            public void test13() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/13.kt");
            }

            @Test
            @TestMetadata("14.kt")
            public void test14() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/14.kt");
            }

            @Test
            @TestMetadata("2.kt")
            public void test2() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/2.kt");
            }

            @Test
            @TestMetadata("3.kt")
            public void test3() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/3.kt");
            }

            @Test
            @TestMetadata("4.kt")
            public void test4() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/4.kt");
            }

            @Test
            @TestMetadata("5.kt")
            public void test5() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/5.kt");
            }

            @Test
            @TestMetadata("6.kt")
            public void test6() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/6.kt");
            }

            @Test
            @TestMetadata("7.kt")
            public void test7() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/7.kt");
            }

            @Test
            @TestMetadata("8.kt")
            public void test8() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/8.kt");
            }

            @Test
            @TestMetadata("9.kt")
            public void test9() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/9.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations")
      @TestDataPath("$PROJECT_ROOT")
      public class Declarations {
        @Test
        public void testAllFilesPresentInDeclarations() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder")
        @TestDataPath("$PROJECT_ROOT")
        public class ContractBuilder {
          @Test
          public void testAllFilesPresentInContractBuilder() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common")
          @TestDataPath("$PROJECT_ROOT")
          public class Common {
            @Test
            public void testAllFilesPresentInCommon() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg")
            @TestDataPath("$PROJECT_ROOT")
            public class Neg {
              @Test
              @TestMetadata("1.kt")
              public void test1() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/1.kt");
              }

              @Test
              @TestMetadata("10.kt")
              public void test10() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/10.kt");
              }

              @Test
              @TestMetadata("11.kt")
              public void test11() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/11.kt");
              }

              @Test
              @TestMetadata("12.kt")
              public void test12() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/12.kt");
              }

              @Test
              @TestMetadata("13.kt")
              public void test13() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/13.kt");
              }

              @Test
              @TestMetadata("14.kt")
              public void test14() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/14.kt");
              }

              @Test
              @TestMetadata("15.kt")
              public void test15() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/15.kt");
              }

              @Test
              @TestMetadata("16.kt")
              public void test16() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/16.kt");
              }

              @Test
              @TestMetadata("17.kt")
              public void test17() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/17.kt");
              }

              @Test
              @TestMetadata("19.kt")
              public void test19() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/19.kt");
              }

              @Test
              @TestMetadata("2.kt")
              public void test2() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/2.kt");
              }

              @Test
              @TestMetadata("3.kt")
              public void test3() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/3.kt");
              }

              @Test
              @TestMetadata("4.kt")
              public void test4() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/4.kt");
              }

              @Test
              @TestMetadata("5.kt")
              public void test5() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/5.kt");
              }

              @Test
              @TestMetadata("6.kt")
              public void test6() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/6.kt");
              }

              @Test
              @TestMetadata("7.kt")
              public void test7() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/7.kt");
              }

              @Test
              @TestMetadata("8.kt")
              public void test8() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/8.kt");
              }

              @Test
              @TestMetadata("9.kt")
              public void test9() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/9.kt");
              }

              @Test
              public void testAllFilesPresentInNeg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos")
            @TestDataPath("$PROJECT_ROOT")
            public class Pos {
              @Test
              @TestMetadata("1.kt")
              public void test1() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos/1.kt");
              }

              @Test
              @TestMetadata("2.kt")
              public void test2() {
                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos/2.kt");
              }

              @Test
              public void testAllFilesPresentInPos() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects")
          @TestDataPath("$PROJECT_ROOT")
          public class Effects {
            @Test
            public void testAllFilesPresentInEffects() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace")
            @TestDataPath("$PROJECT_ROOT")
            public class CallsInPlace {
              @Test
              public void testAllFilesPresentInCallsInPlace() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.kt")
                public void test1() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg/1.kt");
                }

                @Test
                @TestMetadata("2.kt")
                public void test2() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg/2.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.kt")
                public void test1() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/1.kt");
                }

                @Test
                @TestMetadata("2.kt")
                public void test2() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/2.kt");
                }

                @Test
                @TestMetadata("3.kt")
                public void test3() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/3.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common")
            @TestDataPath("$PROJECT_ROOT")
            public class Common {
              @Test
              public void testAllFilesPresentInCommon() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.kt")
                public void test1() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg/1.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }

            @Nested
            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns")
            @TestDataPath("$PROJECT_ROOT")
            public class Returns {
              @Test
              public void testAllFilesPresentInReturns() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg")
              @TestDataPath("$PROJECT_ROOT")
              public class Neg {
                @Test
                @TestMetadata("1.kt")
                public void test1() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/1.kt");
                }

                @Test
                @TestMetadata("2.kt")
                public void test2() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/2.kt");
                }

                @Test
                @TestMetadata("3.kt")
                public void test3() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/3.kt");
                }

                @Test
                @TestMetadata("4.kt")
                public void test4() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/4.kt");
                }

                @Test
                @TestMetadata("5.kt")
                public void test5() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/5.kt");
                }

                @Test
                @TestMetadata("6.kt")
                public void test6() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/6.kt");
                }

                @Test
                @TestMetadata("7.kt")
                public void test7() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/7.kt");
                }

                @Test
                public void testAllFilesPresentInNeg() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }

              @Nested
              @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos")
              @TestDataPath("$PROJECT_ROOT")
              public class Pos {
                @Test
                @TestMetadata("1.kt")
                public void test1() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/1.kt");
                }

                @Test
                @TestMetadata("2.kt")
                public void test2() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/2.kt");
                }

                @Test
                @TestMetadata("3.kt")
                public void test3() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/3.kt");
                }

                @Test
                @TestMetadata("4.kt")
                public void test4() {
                  runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/4.kt");
                }

                @Test
                public void testAllFilesPresentInPos() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
                }
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction")
        @TestDataPath("$PROJECT_ROOT")
        public class ContractFunction {
          @Test
          public void testAllFilesPresentInContractFunction() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg")
          @TestDataPath("$PROJECT_ROOT")
          public class Neg {
            @Test
            @TestMetadata("1.kt")
            public void test1() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/1.kt");
            }

            @Test
            @TestMetadata("2.kt")
            public void test2() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/2.kt");
            }

            @Test
            @TestMetadata("3.kt")
            public void test3() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/3.kt");
            }

            @Test
            @TestMetadata("4.kt")
            public void test4() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/4.kt");
            }

            @Test
            public void testAllFilesPresentInNeg() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.kt")
            public void test1() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos/1.kt");
            }

            @Test
            @TestMetadata("2.kt")
            public void test2() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos/2.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/dfa")
    @TestDataPath("$PROJECT_ROOT")
    public class Dfa {
      @Test
      public void testAllFilesPresentInDfa() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/dfa"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg")
      @TestDataPath("$PROJECT_ROOT")
      public class Neg {
        @Test
        @TestMetadata("1.kt")
        public void test1() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/1.kt");
        }

        @Test
        @TestMetadata("10.kt")
        public void test10() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/10.kt");
        }

        @Test
        @TestMetadata("11.kt")
        public void test11() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/11.kt");
        }

        @Test
        @TestMetadata("12.kt")
        public void test12() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/12.kt");
        }

        @Test
        @TestMetadata("13.kt")
        public void test13() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/13.kt");
        }

        @Test
        @TestMetadata("14.kt")
        public void test14() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/14.kt");
        }

        @Test
        @TestMetadata("15.kt")
        public void test15() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/15.kt");
        }

        @Test
        @TestMetadata("16.kt")
        public void test16() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/16.kt");
        }

        @Test
        @TestMetadata("17.kt")
        public void test17() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/17.kt");
        }

        @Test
        @TestMetadata("18.kt")
        public void test18() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/18.kt");
        }

        @Test
        @TestMetadata("19.kt")
        public void test19() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/19.kt");
        }

        @Test
        @TestMetadata("2.kt")
        public void test2() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/2.kt");
        }

        @Test
        @TestMetadata("20.kt")
        public void test20() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/20.kt");
        }

        @Test
        @TestMetadata("21.kt")
        public void test21() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/21.kt");
        }

        @Test
        @TestMetadata("22.kt")
        public void test22() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/22.kt");
        }

        @Test
        @TestMetadata("23.kt")
        public void test23() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/23.kt");
        }

        @Test
        @TestMetadata("24.kt")
        public void test24() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/24.kt");
        }

        @Test
        @TestMetadata("25.kt")
        public void test25() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/25.kt");
        }

        @Test
        @TestMetadata("26.kt")
        public void test26() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/26.kt");
        }

        @Test
        @TestMetadata("27.kt")
        public void test27() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/27.kt");
        }

        @Test
        @TestMetadata("28.kt")
        public void test28() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/28.kt");
        }

        @Test
        @TestMetadata("29.kt")
        public void test29() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/29.kt");
        }

        @Test
        @TestMetadata("3.kt")
        public void test3() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/3.kt");
        }

        @Test
        @TestMetadata("30.kt")
        public void test30() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/30.kt");
        }

        @Test
        @TestMetadata("31.kt")
        public void test31() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/31.kt");
        }

        @Test
        @TestMetadata("32.kt")
        public void test32() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/32.kt");
        }

        @Test
        @TestMetadata("33.kt")
        public void test33() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/33.kt");
        }

        @Test
        @TestMetadata("34.kt")
        public void test34() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/34.kt");
        }

        @Test
        @TestMetadata("35.kt")
        public void test35() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/35.kt");
        }

        @Test
        @TestMetadata("36.kt")
        public void test36() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/36.kt");
        }

        @Test
        @TestMetadata("37.kt")
        public void test37() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/37.kt");
        }

        @Test
        @TestMetadata("38.kt")
        public void test38() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/38.kt");
        }

        @Test
        @TestMetadata("39.kt")
        public void test39() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/39.kt");
        }

        @Test
        @TestMetadata("4.kt")
        public void test4() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/4.kt");
        }

        @Test
        @TestMetadata("40.kt")
        public void test40() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/40.kt");
        }

        @Test
        @TestMetadata("41.kt")
        public void test41() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/41.kt");
        }

        @Test
        @TestMetadata("42.kt")
        public void test42() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/42.kt");
        }

        @Test
        @TestMetadata("43.kt")
        public void test43() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/43.kt");
        }

        @Test
        @TestMetadata("44.kt")
        public void test44() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/44.kt");
        }

        @Test
        @TestMetadata("45.kt")
        public void test45() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/45.kt");
        }

        @Test
        @TestMetadata("5.kt")
        public void test5() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/5.kt");
        }

        @Test
        @TestMetadata("6.kt")
        public void test6() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/6.kt");
        }

        @Test
        @TestMetadata("7.kt")
        public void test7() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/7.kt");
        }

        @Test
        @TestMetadata("8.kt")
        public void test8() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/8.kt");
        }

        @Test
        @TestMetadata("9.kt")
        public void test9() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/9.kt");
        }

        @Test
        public void testAllFilesPresentInNeg() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos")
      @TestDataPath("$PROJECT_ROOT")
      public class Pos {
        @Test
        @TestMetadata("1.kt")
        public void test1() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/1.kt");
        }

        @Test
        @TestMetadata("10.kt")
        public void test10() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/10.kt");
        }

        @Test
        @TestMetadata("11.kt")
        public void test11() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/11.kt");
        }

        @Test
        @TestMetadata("12.kt")
        public void test12() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/12.kt");
        }

        @Test
        @TestMetadata("13.kt")
        public void test13() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/13.kt");
        }

        @Test
        @TestMetadata("14.kt")
        public void test14() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/14.kt");
        }

        @Test
        @TestMetadata("15.kt")
        public void test15() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/15.kt");
        }

        @Test
        @TestMetadata("16.kt")
        public void test16() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/16.kt");
        }

        @Test
        @TestMetadata("17.kt")
        public void test17() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/17.kt");
        }

        @Test
        @TestMetadata("18.kt")
        public void test18() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/18.kt");
        }

        @Test
        @TestMetadata("19.kt")
        public void test19() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/19.kt");
        }

        @Test
        @TestMetadata("2.kt")
        public void test2() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/2.kt");
        }

        @Test
        @TestMetadata("20.kt")
        public void test20() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/20.kt");
        }

        @Test
        @TestMetadata("21.kt")
        public void test21() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/21.kt");
        }

        @Test
        @TestMetadata("22.kt")
        public void test22() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/22.kt");
        }

        @Test
        @TestMetadata("23.kt")
        public void test23() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/23.kt");
        }

        @Test
        @TestMetadata("24.kt")
        public void test24() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/24.kt");
        }

        @Test
        @TestMetadata("25.kt")
        public void test25() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/25.kt");
        }

        @Test
        @TestMetadata("26.kt")
        public void test26() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/26.kt");
        }

        @Test
        @TestMetadata("27.kt")
        public void test27() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/27.kt");
        }

        @Test
        @TestMetadata("28.kt")
        public void test28() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/28.kt");
        }

        @Test
        @TestMetadata("29.kt")
        public void test29() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/29.kt");
        }

        @Test
        @TestMetadata("3.kt")
        public void test3() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/3.kt");
        }

        @Test
        @TestMetadata("30.kt")
        public void test30() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/30.kt");
        }

        @Test
        @TestMetadata("31.kt")
        public void test31() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/31.kt");
        }

        @Test
        @TestMetadata("32.kt")
        public void test32() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/32.kt");
        }

        @Test
        @TestMetadata("33.kt")
        public void test33() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/33.kt");
        }

        @Test
        @TestMetadata("34.kt")
        public void test34() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/34.kt");
        }

        @Test
        @TestMetadata("35.kt")
        public void test35() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/35.kt");
        }

        @Test
        @TestMetadata("36.kt")
        public void test36() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/36.kt");
        }

        @Test
        @TestMetadata("37.kt")
        public void test37() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/37.kt");
        }

        @Test
        @TestMetadata("38.kt")
        public void test38() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/38.kt");
        }

        @Test
        @TestMetadata("39.kt")
        public void test39() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/39.kt");
        }

        @Test
        @TestMetadata("4.kt")
        public void test4() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/4.kt");
        }

        @Test
        @TestMetadata("40.kt")
        public void test40() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/40.kt");
        }

        @Test
        @TestMetadata("41.kt")
        public void test41() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/41.kt");
        }

        @Test
        @TestMetadata("42.kt")
        public void test42() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/42.kt");
        }

        @Test
        @TestMetadata("43.kt")
        public void test43() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/43.kt");
        }

        @Test
        @TestMetadata("44.kt")
        public void test44() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/44.kt");
        }

        @Test
        @TestMetadata("45.kt")
        public void test45() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/45.kt");
        }

        @Test
        @TestMetadata("46.kt")
        public void test46() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/46.kt");
        }

        @Test
        @TestMetadata("47.kt")
        public void test47() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/47.kt");
        }

        @Test
        @TestMetadata("48.kt")
        public void test48() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/48.kt");
        }

        @Test
        @TestMetadata("49.kt")
        public void test49() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/49.kt");
        }

        @Test
        @TestMetadata("5.kt")
        public void test5() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/5.kt");
        }

        @Test
        @TestMetadata("50.kt")
        public void test50() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/50.kt");
        }

        @Test
        @TestMetadata("51.kt")
        public void test51() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/51.kt");
        }

        @Test
        @TestMetadata("52.kt")
        public void test52() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/52.kt");
        }

        @Test
        @TestMetadata("53.kt")
        public void test53() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/53.kt");
        }

        @Test
        @TestMetadata("54.kt")
        public void test54() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/54.kt");
        }

        @Test
        @TestMetadata("55.kt")
        public void test55() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/55.kt");
        }

        @Test
        @TestMetadata("56.kt")
        public void test56() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/56.kt");
        }

        @Test
        @TestMetadata("57.kt")
        public void test57() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/57.kt");
        }

        @Test
        @TestMetadata("58.kt")
        public void test58() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/58.kt");
        }

        @Test
        @TestMetadata("59.kt")
        public void test59() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/59.kt");
        }

        @Test
        @TestMetadata("6.kt")
        public void test6() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/6.kt");
        }

        @Test
        @TestMetadata("60.kt")
        public void test60() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/60.kt");
        }

        @Test
        @TestMetadata("61.kt")
        public void test61() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/61.kt");
        }

        @Test
        @TestMetadata("62.kt")
        public void test62() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/62.kt");
        }

        @Test
        @TestMetadata("63.kt")
        public void test63() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/63.kt");
        }

        @Test
        @TestMetadata("64.kt")
        public void test64() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/64.kt");
        }

        @Test
        @TestMetadata("65.kt")
        public void test65() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/65.kt");
        }

        @Test
        @TestMetadata("66.kt")
        public void test66() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/66.kt");
        }

        @Test
        @TestMetadata("67.kt")
        public void test67() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/67.kt");
        }

        @Test
        @TestMetadata("68.kt")
        public void test68() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/68.kt");
        }

        @Test
        @TestMetadata("69.kt")
        public void test69() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/69.kt");
        }

        @Test
        @TestMetadata("7.kt")
        public void test7() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/7.kt");
        }

        @Test
        @TestMetadata("70.kt")
        public void test70() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/70.kt");
        }

        @Test
        @TestMetadata("71.kt")
        public void test71() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/71.kt");
        }

        @Test
        @TestMetadata("72.kt")
        public void test72() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/72.kt");
        }

        @Test
        @TestMetadata("73.kt")
        public void test73() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/73.kt");
        }

        @Test
        @TestMetadata("8.kt")
        public void test8() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/8.kt");
        }

        @Test
        @TestMetadata("9.kt")
        public void test9() {
          runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/9.kt");
        }

        @Test
        public void testAllFilesPresentInPos() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables")
    @TestDataPath("$PROJECT_ROOT")
    public class Local_variables {
      @Test
      public void testAllFilesPresentInLocal_variables() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters")
      @TestDataPath("$PROJECT_ROOT")
      public class Type_parameters {
        @Test
        public void testAllFilesPresentInType_parameters() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg")
        @TestDataPath("$PROJECT_ROOT")
        public class Neg {
          @Test
          @TestMetadata("1.kt")
          public void test1() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg/1.kt");
          }

          @Test
          public void testAllFilesPresentInNeg() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/objects")
    @TestDataPath("$PROJECT_ROOT")
    public class Objects {
      @Test
      public void testAllFilesPresentInObjects() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/objects"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance")
      @TestDataPath("$PROJECT_ROOT")
      public class Inheritance {
        @Test
        public void testAllFilesPresentInInheritance() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg")
        @TestDataPath("$PROJECT_ROOT")
        public class Neg {
          @Test
          @TestMetadata("1.kt")
          public void test1() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/1.kt");
          }

          @Test
          @TestMetadata("2.kt")
          public void test2() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/2.kt");
          }

          @Test
          @TestMetadata("3.kt")
          public void test3() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/3.kt");
          }

          @Test
          @TestMetadata("4.kt")
          public void test4() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/4.kt");
          }

          @Test
          @TestMetadata("5.kt")
          public void test5() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/5.kt");
          }

          @Test
          @TestMetadata("6.kt")
          public void test6() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/6.kt");
          }

          @Test
          @TestMetadata("7.kt")
          public void test7() {
            runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/7.kt");
          }

          @Test
          public void testAllFilesPresentInNeg() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution")
    @TestDataPath("$PROJECT_ROOT")
    public class Overload_resolution {
      @Test
      public void testAllFilesPresentInOverload_resolution() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
      }

      @Nested
      @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs")
      @TestDataPath("$PROJECT_ROOT")
      public class Building_the_overload_candidate_set_ocs {
        @Test
        public void testAllFilesPresentInBuilding_the_overload_candidate_set_ocs() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call")
        @TestDataPath("$PROJECT_ROOT")
        public class Infix_function_call {
          @Test
          public void testAllFilesPresentInInfix_function_call() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
          }

          @Nested
          @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos")
          @TestDataPath("$PROJECT_ROOT")
          public class Pos {
            @Test
            @TestMetadata("1.kt")
            public void test1() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/1.kt");
            }

            @Test
            @TestMetadata("2.kt")
            public void test2() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/2.kt");
            }

            @Test
            @TestMetadata("3.kt")
            public void test3() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/3.kt");
            }

            @Test
            @TestMetadata("4.kt")
            public void test4() {
              runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/4.kt");
            }

            @Test
            public void testAllFilesPresentInPos() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true);
            }
          }
        }
      }
    }
  }
}
