/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostic.compiler.based;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
public class DiagnosticCompilerTestFirTestdataTestGenerated extends AbstractDiagnosticCompilerTestDataTest {
  @Nested
  @TestMetadata("compiler/fir/analysis-tests/testData/resolve")
  @TestDataPath("$PROJECT_ROOT")
  public class Resolve {
    @Test
    @TestMetadata("accessJavaFromKotlinViaImport.kt")
    public void testAccessJavaFromKotlinViaImport() {
      runTest("compiler/fir/analysis-tests/testData/resolve/accessJavaFromKotlinViaImport.kt");
    }

    @Test
    @TestMetadata("accessJavaFromKotlinViaStaticImport.kt")
    public void testAccessJavaFromKotlinViaStaticImport() {
      runTest("compiler/fir/analysis-tests/testData/resolve/accessJavaFromKotlinViaStaticImport.kt");
    }

    @Test
    @TestMetadata("accessJavaFromKotlinViaStaticImport2.kt")
    public void testAccessJavaFromKotlinViaStaticImport2() {
      runTest("compiler/fir/analysis-tests/testData/resolve/accessJavaFromKotlinViaStaticImport2.kt");
    }

    @Test
    @TestMetadata("accessJavaFromKotlinViaStaticImportAndPermits.kt")
    public void testAccessJavaFromKotlinViaStaticImportAndPermits() {
      runTest("compiler/fir/analysis-tests/testData/resolve/accessJavaFromKotlinViaStaticImportAndPermits.kt");
    }

    @Test
    @TestMetadata("accessJavaFromKotlinViaStaticImportWithoutPermits.kt")
    public void testAccessJavaFromKotlinViaStaticImportWithoutPermits() {
      runTest("compiler/fir/analysis-tests/testData/resolve/accessJavaFromKotlinViaStaticImportWithoutPermits.kt");
    }

    @Test
    public void testAllFilesPresentInResolve() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
    }

    @Test
    @TestMetadata("annotationOnDeclarationWithDifferentArguments.kt")
    public void testAnnotationOnDeclarationWithDifferentArguments() {
      runTest("compiler/fir/analysis-tests/testData/resolve/annotationOnDeclarationWithDifferentArguments.kt");
    }

    @Test
    @TestMetadata("annotationOnGetClassCall.kt")
    public void testAnnotationOnGetClassCall() {
      runTest("compiler/fir/analysis-tests/testData/resolve/annotationOnGetClassCall.kt");
    }

    @Test
    @TestMetadata("annotationUsedAsAnnotationArgument.kt")
    public void testAnnotationUsedAsAnnotationArgument() {
      runTest("compiler/fir/analysis-tests/testData/resolve/annotationUsedAsAnnotationArgument.kt");
    }

    @Test
    @TestMetadata("asImports.kt")
    public void testAsImports() {
      runTest("compiler/fir/analysis-tests/testData/resolve/asImports.kt");
    }

    @Test
    @TestMetadata("bareTypes.kt")
    public void testBareTypes() {
      runTest("compiler/fir/analysis-tests/testData/resolve/bareTypes.kt");
    }

    @Test
    @TestMetadata("bareTypes2.kt")
    public void testBareTypes2() {
      runTest("compiler/fir/analysis-tests/testData/resolve/bareTypes2.kt");
    }

    @Test
    @TestMetadata("bareTypesWithFlexibleArguments.kt")
    public void testBareTypesWithFlexibleArguments() {
      runTest("compiler/fir/analysis-tests/testData/resolve/bareTypesWithFlexibleArguments.kt");
    }

    @Test
    @TestMetadata("cast.kt")
    public void testCast() {
      runTest("compiler/fir/analysis-tests/testData/resolve/cast.kt");
    }

    @Test
    @TestMetadata("catchParameter.kt")
    public void testCatchParameter() {
      runTest("compiler/fir/analysis-tests/testData/resolve/catchParameter.kt");
    }

    @Test
    @TestMetadata("classCallInLambda.kt")
    public void testClassCallInLambda() {
      runTest("compiler/fir/analysis-tests/testData/resolve/classCallInLambda.kt");
    }

    @Test
    @TestMetadata("companion.kt")
    public void testCompanion() {
      runTest("compiler/fir/analysis-tests/testData/resolve/companion.kt");
    }

    @Test
    @TestMetadata("companionAccessInEnum.kt")
    public void testCompanionAccessInEnum() {
      runTest("compiler/fir/analysis-tests/testData/resolve/companionAccessInEnum.kt");
    }

    @Test
    @TestMetadata("companionObjectCall.kt")
    public void testCompanionObjectCall() {
      runTest("compiler/fir/analysis-tests/testData/resolve/companionObjectCall.kt");
    }

    @Test
    @TestMetadata("companionUsesNested.kt")
    public void testCompanionUsesNested() {
      runTest("compiler/fir/analysis-tests/testData/resolve/companionUsesNested.kt");
    }

    @Test
    @TestMetadata("constantValues.kt")
    public void testConstantValues() {
      runTest("compiler/fir/analysis-tests/testData/resolve/constantValues.kt");
    }

    @Test
    @TestMetadata("copy.kt")
    public void testCopy() {
      runTest("compiler/fir/analysis-tests/testData/resolve/copy.kt");
    }

    @Test
    @TestMetadata("covariantArrayAsReceiver.kt")
    public void testCovariantArrayAsReceiver() {
      runTest("compiler/fir/analysis-tests/testData/resolve/covariantArrayAsReceiver.kt");
    }

    @Test
    @TestMetadata("defaultJavaImportHiding.kt")
    public void testDefaultJavaImportHiding() {
      runTest("compiler/fir/analysis-tests/testData/resolve/defaultJavaImportHiding.kt");
    }

    @Test
    @TestMetadata("defaultParametersInheritedToJava.kt")
    public void testDefaultParametersInheritedToJava() {
      runTest("compiler/fir/analysis-tests/testData/resolve/defaultParametersInheritedToJava.kt");
    }

    @Test
    @TestMetadata("definitelyNotNullAmbiguity.kt")
    public void testDefinitelyNotNullAmbiguity() {
      runTest("compiler/fir/analysis-tests/testData/resolve/definitelyNotNullAmbiguity.kt");
    }

    @Test
    @TestMetadata("delegateByArrayLiteral.kt")
    public void testDelegateByArrayLiteral() {
      runTest("compiler/fir/analysis-tests/testData/resolve/delegateByArrayLiteral.kt");
    }

    @Test
    @TestMetadata("delegatedSuperType.kt")
    public void testDelegatedSuperType() {
      runTest("compiler/fir/analysis-tests/testData/resolve/delegatedSuperType.kt");
    }

    @Test
    @TestMetadata("delegatingConstructorCall.kt")
    public void testDelegatingConstructorCall() {
      runTest("compiler/fir/analysis-tests/testData/resolve/delegatingConstructorCall.kt");
    }

    @Test
    @TestMetadata("delegatingConstructorsAndTypeAliases.kt")
    public void testDelegatingConstructorsAndTypeAliases() {
      runTest("compiler/fir/analysis-tests/testData/resolve/delegatingConstructorsAndTypeAliases.kt");
    }

    @Test
    @TestMetadata("derivedClass.kt")
    public void testDerivedClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/derivedClass.kt");
    }

    @Test
    @TestMetadata("elvisReturnSimple.kt")
    public void testElvisReturnSimple() {
      runTest("compiler/fir/analysis-tests/testData/resolve/elvisReturnSimple.kt");
    }

    @Test
    @TestMetadata("enum.kt")
    public void testEnum() {
      runTest("compiler/fir/analysis-tests/testData/resolve/enum.kt");
    }

    @Test
    @TestMetadata("enumWithCompanion.kt")
    public void testEnumWithCompanion() {
      runTest("compiler/fir/analysis-tests/testData/resolve/enumWithCompanion.kt");
    }

    @Test
    @TestMetadata("extension.kt")
    public void testExtension() {
      runTest("compiler/fir/analysis-tests/testData/resolve/extension.kt");
    }

    @Test
    @TestMetadata("F.kt")
    public void testF() {
      runTest("compiler/fir/analysis-tests/testData/resolve/F.kt");
    }

    @Test
    @TestMetadata("fakeRecursiveSupertype.kt")
    public void testFakeRecursiveSupertype() {
      runTest("compiler/fir/analysis-tests/testData/resolve/fakeRecursiveSupertype.kt");
    }

    @Test
    @TestMetadata("fakeRecursiveTypealias.kt")
    public void testFakeRecursiveTypealias() {
      runTest("compiler/fir/analysis-tests/testData/resolve/fakeRecursiveTypealias.kt");
    }

    @Test
    @TestMetadata("falseOperatorAssignmentWithBooleanNot.kt")
    public void testFalseOperatorAssignmentWithBooleanNot() {
      runTest("compiler/fir/analysis-tests/testData/resolve/falseOperatorAssignmentWithBooleanNot.kt");
    }

    @Test
    @TestMetadata("falseRedundantConversionMethodOnThisProperty.kt")
    public void testFalseRedundantConversionMethodOnThisProperty() {
      runTest("compiler/fir/analysis-tests/testData/resolve/falseRedundantConversionMethodOnThisProperty.kt");
    }

    @Test
    @TestMetadata("fib.kt")
    public void testFib() {
      runTest("compiler/fir/analysis-tests/testData/resolve/fib.kt");
    }

    @Test
    @TestMetadata("flexibleCapturedType.kt")
    public void testFlexibleCapturedType() {
      runTest("compiler/fir/analysis-tests/testData/resolve/flexibleCapturedType.kt");
    }

    @Test
    @TestMetadata("flexibleTypeRendering.kt")
    public void testFlexibleTypeRendering() {
      runTest("compiler/fir/analysis-tests/testData/resolve/flexibleTypeRendering.kt");
    }

    @Test
    @TestMetadata("ft.kt")
    public void testFt() {
      runTest("compiler/fir/analysis-tests/testData/resolve/ft.kt");
    }

    @Test
    @TestMetadata("funInterfaceDeclaration.kt")
    public void testFunInterfaceDeclaration() {
      runTest("compiler/fir/analysis-tests/testData/resolve/funInterfaceDeclaration.kt");
    }

    @Test
    @TestMetadata("functionTypeAlias.kt")
    public void testFunctionTypeAlias() {
      runTest("compiler/fir/analysis-tests/testData/resolve/functionTypeAlias.kt");
    }

    @Test
    @TestMetadata("functionTypes.kt")
    public void testFunctionTypes() {
      runTest("compiler/fir/analysis-tests/testData/resolve/functionTypes.kt");
    }

    @Test
    @TestMetadata("genericConstructors.kt")
    public void testGenericConstructors() {
      runTest("compiler/fir/analysis-tests/testData/resolve/genericConstructors.kt");
    }

    @Test
    @TestMetadata("genericFunctions.kt")
    public void testGenericFunctions() {
      runTest("compiler/fir/analysis-tests/testData/resolve/genericFunctions.kt");
    }

    @Test
    @TestMetadata("genericReceiverPropertyOverride.kt")
    public void testGenericReceiverPropertyOverride() {
      runTest("compiler/fir/analysis-tests/testData/resolve/genericReceiverPropertyOverride.kt");
    }

    @Test
    @TestMetadata("implicitTypeFromOtherModule.kt")
    public void testImplicitTypeFromOtherModule() {
      runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeFromOtherModule.kt");
    }

    @Test
    @TestMetadata("implicitTypeInFakeOverride.kt")
    public void testImplicitTypeInFakeOverride() {
      runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeInFakeOverride.kt");
    }

    @Test
    @TestMetadata("implicitTypeIntersectionOverrideFromOtherModule.kt")
    public void testImplicitTypeIntersectionOverrideFromOtherModule() {
      runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeIntersectionOverrideFromOtherModule.kt");
    }

    @Test
    @TestMetadata("implicitTypeSubstituteOverrideFromOtherModule.kt")
    public void testImplicitTypeSubstituteOverrideFromOtherModule() {
      runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeSubstituteOverrideFromOtherModule.kt");
    }

    @Test
    @TestMetadata("implicitTypeSubstituteOverrideInNestedClassFromOtherModule.kt")
    public void testImplicitTypeSubstituteOverrideInNestedClassFromOtherModule() {
      runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeSubstituteOverrideInNestedClassFromOtherModule.kt");
    }

    @Test
    @TestMetadata("implicitTypeWithTypeBound.kt")
    public void testImplicitTypeWithTypeBound() {
      runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeWithTypeBound.kt");
    }

    @Test
    @TestMetadata("incorrectDataClass.kt")
    public void testIncorrectDataClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/incorrectDataClass.kt");
    }

    @Test
    @TestMetadata("incorrectSuperCall.kt")
    public void testIncorrectSuperCall() {
      runTest("compiler/fir/analysis-tests/testData/resolve/incorrectSuperCall.kt");
    }

    @Test
    @TestMetadata("inherentlyImportedTypeFromOtherModule.kt")
    public void testInherentlyImportedTypeFromOtherModule() {
      runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule.kt");
    }

    @Test
    @TestMetadata("inherentlyImportedTypeFromOtherModule2.kt")
    public void testInherentlyImportedTypeFromOtherModule2() {
      runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule2.kt");
    }

    @Test
    @TestMetadata("inherentlyImportedTypeFromOtherModule3.kt")
    public void testInherentlyImportedTypeFromOtherModule3() {
      runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule3.kt");
    }

    @Test
    @TestMetadata("intersectionScope.kt")
    public void testIntersectionScope() {
      runTest("compiler/fir/analysis-tests/testData/resolve/intersectionScope.kt");
    }

    @Test
    @TestMetadata("intersectionTypes.kt")
    public void testIntersectionTypes() {
      runTest("compiler/fir/analysis-tests/testData/resolve/intersectionTypes.kt");
    }

    @Test
    @TestMetadata("invokeInWhenSubjectVariableInitializer.kt")
    public void testInvokeInWhenSubjectVariableInitializer() {
      runTest("compiler/fir/analysis-tests/testData/resolve/invokeInWhenSubjectVariableInitializer.kt");
    }

    @Test
    @TestMetadata("invokeOfLambdaWithReceiver.kt")
    public void testInvokeOfLambdaWithReceiver() {
      runTest("compiler/fir/analysis-tests/testData/resolve/invokeOfLambdaWithReceiver.kt");
    }

    @Test
    @TestMetadata("javaFieldVsAccessor.kt")
    public void testJavaFieldVsAccessor() {
      runTest("compiler/fir/analysis-tests/testData/resolve/javaFieldVsAccessor.kt");
    }

    @Test
    @TestMetadata("javaStaticScopeInheritance.kt")
    public void testJavaStaticScopeInheritance() {
      runTest("compiler/fir/analysis-tests/testData/resolve/javaStaticScopeInheritance.kt");
    }

    @Test
    @TestMetadata("KT-65044.kt")
    public void testKT_65044() {
      runTest("compiler/fir/analysis-tests/testData/resolve/KT-65044.kt");
    }

    @Test
    @TestMetadata("kt41984.kt")
    public void testKt41984() {
      runTest("compiler/fir/analysis-tests/testData/resolve/kt41984.kt");
    }

    @Test
    @TestMetadata("kt41990.kt")
    public void testKt41990() {
      runTest("compiler/fir/analysis-tests/testData/resolve/kt41990.kt");
    }

    @Test
    @TestMetadata("kt54220.kt")
    public void testKt54220() {
      runTest("compiler/fir/analysis-tests/testData/resolve/kt54220.kt");
    }

    @Test
    @TestMetadata("kt54775.kt")
    public void testKt54775() {
      runTest("compiler/fir/analysis-tests/testData/resolve/kt54775.kt");
    }

    @Test
    @TestMetadata("labelAndReceiverForInfix.kt")
    public void testLabelAndReceiverForInfix() {
      runTest("compiler/fir/analysis-tests/testData/resolve/labelAndReceiverForInfix.kt");
    }

    @Test
    @TestMetadata("labeledReturnFromNotLabeledUnnamedFunction.kt")
    public void testLabeledReturnFromNotLabeledUnnamedFunction() {
      runTest("compiler/fir/analysis-tests/testData/resolve/labeledReturnFromNotLabeledUnnamedFunction.kt");
    }

    @Test
    @TestMetadata("lambdaArgInScopeFunction.kt")
    public void testLambdaArgInScopeFunction() {
      runTest("compiler/fir/analysis-tests/testData/resolve/lambdaArgInScopeFunction.kt");
    }

    @Test
    @TestMetadata("lambdaInLhsOfTypeOperatorCall.kt")
    public void testLambdaInLhsOfTypeOperatorCall() {
      runTest("compiler/fir/analysis-tests/testData/resolve/lambdaInLhsOfTypeOperatorCall.kt");
    }

    @Test
    @TestMetadata("lambdaPropertyTypeInference.kt")
    public void testLambdaPropertyTypeInference() {
      runTest("compiler/fir/analysis-tests/testData/resolve/lambdaPropertyTypeInference.kt");
    }

    @Test
    @TestMetadata("localFunctionsHiding.kt")
    public void testLocalFunctionsHiding() {
      runTest("compiler/fir/analysis-tests/testData/resolve/localFunctionsHiding.kt");
    }

    @Test
    @TestMetadata("localObject.kt")
    public void testLocalObject() {
      runTest("compiler/fir/analysis-tests/testData/resolve/localObject.kt");
    }

    @Test
    @TestMetadata("nestedClass.kt")
    public void testNestedClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/nestedClass.kt");
    }

    @Test
    @TestMetadata("nestedClassContructor.kt")
    public void testNestedClassContructor() {
      runTest("compiler/fir/analysis-tests/testData/resolve/nestedClassContructor.kt");
    }

    @Test
    @TestMetadata("nestedClassNameClash.kt")
    public void testNestedClassNameClash() {
      runTest("compiler/fir/analysis-tests/testData/resolve/nestedClassNameClash.kt");
    }

    @Test
    @TestMetadata("NestedOfAliasedType.kt")
    public void testNestedOfAliasedType() {
      runTest("compiler/fir/analysis-tests/testData/resolve/NestedOfAliasedType.kt");
    }

    @Test
    @TestMetadata("nestedReturnType.kt")
    public void testNestedReturnType() {
      runTest("compiler/fir/analysis-tests/testData/resolve/nestedReturnType.kt");
    }

    @Test
    @TestMetadata("NestedSuperType.kt")
    public void testNestedSuperType() {
      runTest("compiler/fir/analysis-tests/testData/resolve/NestedSuperType.kt");
    }

    @Test
    @TestMetadata("objectInnerClass.kt")
    public void testObjectInnerClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/objectInnerClass.kt");
    }

    @Test
    @TestMetadata("offOrderMultiBoundGenericOverride.kt")
    public void testOffOrderMultiBoundGenericOverride() {
      runTest("compiler/fir/analysis-tests/testData/resolve/offOrderMultiBoundGenericOverride.kt");
    }

    @Test
    @TestMetadata("openInInterface.kt")
    public void testOpenInInterface() {
      runTest("compiler/fir/analysis-tests/testData/resolve/openInInterface.kt");
    }

    @Test
    @TestMetadata("privateSubclassAsTypeArgInParentClass.kt")
    public void testPrivateSubclassAsTypeArgInParentClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/privateSubclassAsTypeArgInParentClass.kt");
    }

    @Test
    @TestMetadata("problems2.kt")
    public void testProblems2() {
      runTest("compiler/fir/analysis-tests/testData/resolve/problems2.kt");
    }

    @Test
    @TestMetadata("properLocalPackages.kt")
    public void testProperLocalPackages() {
      runTest("compiler/fir/analysis-tests/testData/resolve/properLocalPackages.kt");
    }

    @Test
    @TestMetadata("propertyFromJavaPlusAssign.kt")
    public void testPropertyFromJavaPlusAssign() {
      runTest("compiler/fir/analysis-tests/testData/resolve/propertyFromJavaPlusAssign.kt");
    }

    @Test
    @TestMetadata("propertyGetterWithoutType.kt")
    public void testPropertyGetterWithoutType() {
      runTest("compiler/fir/analysis-tests/testData/resolve/propertyGetterWithoutType.kt");
    }

    @Test
    @TestMetadata("qualifierWithCompanion.kt")
    public void testQualifierWithCompanion() {
      runTest("compiler/fir/analysis-tests/testData/resolve/qualifierWithCompanion.kt");
    }

    @Test
    @TestMetadata("rawTypeSam.kt")
    public void testRawTypeSam() {
      runTest("compiler/fir/analysis-tests/testData/resolve/rawTypeSam.kt");
    }

    @Test
    @TestMetadata("recursiveCallOnWhenWithSealedClass.kt")
    public void testRecursiveCallOnWhenWithSealedClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/recursiveCallOnWhenWithSealedClass.kt");
    }

    @Test
    @TestMetadata("recursiveTypeAlias.kt")
    public void testRecursiveTypeAlias() {
      runTest("compiler/fir/analysis-tests/testData/resolve/recursiveTypeAlias.kt");
    }

    @Test
    @TestMetadata("reifiedTypeOverload.kt")
    public void testReifiedTypeOverload() {
      runTest("compiler/fir/analysis-tests/testData/resolve/reifiedTypeOverload.kt");
    }

    @Test
    @TestMetadata("returnFromDelegatedConstuctor.kt")
    public void testReturnFromDelegatedConstuctor() {
      runTest("compiler/fir/analysis-tests/testData/resolve/returnFromDelegatedConstuctor.kt");
    }

    @Test
    @TestMetadata("sealedClass.kt")
    public void testSealedClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/sealedClass.kt");
    }

    @Test
    @TestMetadata("settersGetters.kt")
    public void testSettersGetters() {
      runTest("compiler/fir/analysis-tests/testData/resolve/settersGetters.kt");
    }

    @Test
    @TestMetadata("signatureEnhancementCycleTypeBound.kt")
    public void testSignatureEnhancementCycleTypeBound() {
      runTest("compiler/fir/analysis-tests/testData/resolve/signatureEnhancementCycleTypeBound.kt");
    }

    @Test
    @TestMetadata("signatureEnhancementOuterClassBoundsToInner.kt")
    public void testSignatureEnhancementOuterClassBoundsToInner() {
      runTest("compiler/fir/analysis-tests/testData/resolve/signatureEnhancementOuterClassBoundsToInner.kt");
    }

    @Test
    @TestMetadata("simpleClass.kt")
    public void testSimpleClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/simpleClass.kt");
    }

    @Test
    @TestMetadata("simpleTypeAlias.kt")
    public void testSimpleTypeAlias() {
      runTest("compiler/fir/analysis-tests/testData/resolve/simpleTypeAlias.kt");
    }

    @Test
    @TestMetadata("spreadOperator.kt")
    public void testSpreadOperator() {
      runTest("compiler/fir/analysis-tests/testData/resolve/spreadOperator.kt");
    }

    @Test
    @TestMetadata("statusResolveForTypealiasAsSuperClass.kt")
    public void testStatusResolveForTypealiasAsSuperClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/statusResolveForTypealiasAsSuperClass.kt");
    }

    @Test
    @TestMetadata("supertypesForAnnotationClass.kt")
    public void testSupertypesForAnnotationClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/supertypesForAnnotationClass.kt");
    }

    @Test
    @TestMetadata("syntheticsVsNormalProperties.kt")
    public void testSyntheticsVsNormalProperties() {
      runTest("compiler/fir/analysis-tests/testData/resolve/syntheticsVsNormalProperties.kt");
    }

    @Test
    @TestMetadata("throwableSubclass.kt")
    public void testThrowableSubclass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/throwableSubclass.kt");
    }

    @Test
    @TestMetadata("topLevelDestruction.kt")
    public void testTopLevelDestruction() {
      runTest("compiler/fir/analysis-tests/testData/resolve/topLevelDestruction.kt");
    }

    @Test
    @TestMetadata("treeSet.kt")
    public void testTreeSet() {
      runTest("compiler/fir/analysis-tests/testData/resolve/treeSet.kt");
    }

    @Test
    @TestMetadata("trueNegativeOperatorAssignmentOnPropertyFromClass.kt")
    public void testTrueNegativeOperatorAssignmentOnPropertyFromClass() {
      runTest("compiler/fir/analysis-tests/testData/resolve/trueNegativeOperatorAssignmentOnPropertyFromClass.kt");
    }

    @Test
    @TestMetadata("tryInference.kt")
    public void testTryInference() {
      runTest("compiler/fir/analysis-tests/testData/resolve/tryInference.kt");
    }

    @Test
    @TestMetadata("TwoDeclarationsInSameFile.kt")
    public void testTwoDeclarationsInSameFile() {
      runTest("compiler/fir/analysis-tests/testData/resolve/TwoDeclarationsInSameFile.kt");
    }

    @Test
    @TestMetadata("typeAliasWithGeneric.kt")
    public void testTypeAliasWithGeneric() {
      runTest("compiler/fir/analysis-tests/testData/resolve/typeAliasWithGeneric.kt");
    }

    @Test
    @TestMetadata("typeAliasWithTypeArguments.kt")
    public void testTypeAliasWithTypeArguments() {
      runTest("compiler/fir/analysis-tests/testData/resolve/typeAliasWithTypeArguments.kt");
    }

    @Test
    @TestMetadata("typeFromGetter.kt")
    public void testTypeFromGetter() {
      runTest("compiler/fir/analysis-tests/testData/resolve/typeFromGetter.kt");
    }

    @Test
    @TestMetadata("typeParameterInBoundsLocalFunction.kt")
    public void testTypeParameterInBoundsLocalFunction() {
      runTest("compiler/fir/analysis-tests/testData/resolve/typeParameterInBoundsLocalFunction.kt");
    }

    @Test
    @TestMetadata("typeParameterInPropertyReceiver.kt")
    public void testTypeParameterInPropertyReceiver() {
      runTest("compiler/fir/analysis-tests/testData/resolve/typeParameterInPropertyReceiver.kt");
    }

    @Test
    @TestMetadata("typeParameterVsNested.kt")
    public void testTypeParameterVsNested() {
      runTest("compiler/fir/analysis-tests/testData/resolve/typeParameterVsNested.kt");
    }

    @Test
    @TestMetadata("typesInLocalFunctions.kt")
    public void testTypesInLocalFunctions() {
      runTest("compiler/fir/analysis-tests/testData/resolve/typesInLocalFunctions.kt");
    }

    @Test
    @TestMetadata("unitTypeFromOtherModule.kt")
    public void testUnitTypeFromOtherModule() {
      runTest("compiler/fir/analysis-tests/testData/resolve/unitTypeFromOtherModule.kt");
    }

    @Test
    @TestMetadata("unitTypeSubstituteOverrideInNestedClassFromOtherModule.kt")
    public void testUnitTypeSubstituteOverrideInNestedClassFromOtherModule() {
      runTest("compiler/fir/analysis-tests/testData/resolve/unitTypeSubstituteOverrideInNestedClassFromOtherModule.kt");
    }

    @Test
    @TestMetadata("varargInPrimaryConstructor.kt")
    public void testVarargInPrimaryConstructor() {
      runTest("compiler/fir/analysis-tests/testData/resolve/varargInPrimaryConstructor.kt");
    }

    @Test
    @TestMetadata("visibleVsInvisibleQualifier.kt")
    public void testVisibleVsInvisibleQualifier() {
      runTest("compiler/fir/analysis-tests/testData/resolve/visibleVsInvisibleQualifier.kt");
    }

    @Test
    @TestMetadata("whenAsReceiver.kt")
    public void testWhenAsReceiver() {
      runTest("compiler/fir/analysis-tests/testData/resolve/whenAsReceiver.kt");
    }

    @Test
    @TestMetadata("whenElse.kt")
    public void testWhenElse() {
      runTest("compiler/fir/analysis-tests/testData/resolve/whenElse.kt");
    }

    @Test
    @TestMetadata("whenExpressionType.kt")
    public void testWhenExpressionType() {
      runTest("compiler/fir/analysis-tests/testData/resolve/whenExpressionType.kt");
    }

    @Test
    @TestMetadata("whenInference.kt")
    public void testWhenInference() {
      runTest("compiler/fir/analysis-tests/testData/resolve/whenInference.kt");
    }

    @Test
    @TestMetadata("whenWithWhenAsStatement.kt")
    public void testWhenWithWhenAsStatement() {
      runTest("compiler/fir/analysis-tests/testData/resolve/whenWithWhenAsStatement.kt");
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/annotations"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("kindaCompilerRequiredNestedAnnotation.kt")
      public void testKindaCompilerRequiredNestedAnnotation() {
        runTest("compiler/fir/analysis-tests/testData/resolve/annotations/kindaCompilerRequiredNestedAnnotation.kt");
      }

      @Test
      @TestMetadata("kt43936.kt")
      public void testKt43936() {
        runTest("compiler/fir/analysis-tests/testData/resolve/annotations/kt43936.kt");
      }

      @Test
      @TestMetadata("kt54478.kt")
      public void testKt54478() {
        runTest("compiler/fir/analysis-tests/testData/resolve/annotations/kt54478.kt");
      }

      @Test
      @TestMetadata("kt55286.kt")
      public void testKt55286() {
        runTest("compiler/fir/analysis-tests/testData/resolve/annotations/kt55286.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/arguments")
    @TestDataPath("$PROJECT_ROOT")
    public class Arguments {
      @Test
      public void testAllFilesPresentInArguments() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/arguments"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("ambiguityOnJavaOverride.kt")
      public void testAmbiguityOnJavaOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/ambiguityOnJavaOverride.kt");
      }

      @Test
      @TestMetadata("argParamTypeMismatch.kt")
      public void testArgParamTypeMismatch() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argParamTypeMismatch.kt");
      }

      @Test
      @TestMetadata("argumentsOfAnnotations.kt")
      public void testArgumentsOfAnnotations() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argumentsOfAnnotations.kt");
      }

      @Test
      @TestMetadata("argumentsOfJavaAnnotation.kt")
      public void testArgumentsOfJavaAnnotation() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argumentsOfJavaAnnotation.kt");
      }

      @Test
      @TestMetadata("default.kt")
      public void testDefault() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/default.kt");
      }

      @Test
      @TestMetadata("defaultFromOverrides.kt")
      public void testDefaultFromOverrides() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/defaultFromOverrides.kt");
      }

      @Test
      @TestMetadata("definetelyNotNullForTypeParameter.kt")
      public void testDefinetelyNotNullForTypeParameter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/definetelyNotNullForTypeParameter.kt");
      }

      @Test
      @TestMetadata("destructuring.kt")
      public void testDestructuring() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/destructuring.kt");
      }

      @Test
      @TestMetadata("extensionLambdaInDefaultArgument.kt")
      public void testExtensionLambdaInDefaultArgument() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/extensionLambdaInDefaultArgument.kt");
      }

      @Test
      @TestMetadata("fieldPlusAssign.kt")
      public void testFieldPlusAssign() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/fieldPlusAssign.kt");
      }

      @Test
      @TestMetadata("incorrectFunctionalType.kt")
      public void testIncorrectFunctionalType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/incorrectFunctionalType.kt");
      }

      @Test
      @TestMetadata("integerLiteralTypes.kt")
      public void testIntegerLiteralTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/integerLiteralTypes.kt");
      }

      @Test
      @TestMetadata("integerOverloads.kt")
      public void testIntegerOverloads() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/integerOverloads.kt");
      }

      @Test
      @TestMetadata("invoke.kt")
      public void testInvoke() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/invoke.kt");
      }

      @Test
      @TestMetadata("javaAnnotationsWithArrayValue.kt")
      public void testJavaAnnotationsWithArrayValue() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/javaAnnotationsWithArrayValue.kt");
      }

      @Test
      @TestMetadata("javaArrayVariance.kt")
      public void testJavaArrayVariance() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/javaArrayVariance.kt");
      }

      @Test
      @TestMetadata("kt41940.kt")
      public void testKt41940() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/kt41940.kt");
      }

      @Test
      @TestMetadata("lambda.kt")
      public void testLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambda.kt");
      }

      @Test
      @TestMetadata("lambdaInLambda.kt")
      public void testLambdaInLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInLambda.kt");
      }

      @Test
      @TestMetadata("lambdaInLambda2.kt")
      public void testLambdaInLambda2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInLambda2.kt");
      }

      @Test
      @TestMetadata("lambdaInUnresolvedCall.kt")
      public void testLambdaInUnresolvedCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInUnresolvedCall.kt");
      }

      @Test
      @TestMetadata("namedArrayInAnnotation.kt")
      public void testNamedArrayInAnnotation() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/namedArrayInAnnotation.kt");
      }

      @Test
      @TestMetadata("nestedClassInAnnotationArgument.kt")
      public void testNestedClassInAnnotationArgument() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/nestedClassInAnnotationArgument.kt");
      }

      @Test
      @TestMetadata("noParameterForName.kt")
      public void testNoParameterForName() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/noParameterForName.kt");
      }

      @Test
      @TestMetadata("nullForDifferentProjections.kt")
      public void testNullForDifferentProjections() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/nullForDifferentProjections.kt");
      }

      @Test
      @TestMetadata("operatorsOverLiterals.kt")
      public void testOperatorsOverLiterals() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/operatorsOverLiterals.kt");
      }

      @Test
      @TestMetadata("overloadByReceiver.kt")
      public void testOverloadByReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/overloadByReceiver.kt");
      }

      @Test
      @TestMetadata("overloadWithDefault.kt")
      public void testOverloadWithDefault() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/overloadWithDefault.kt");
      }

      @Test
      @TestMetadata("setWithTrailingLambda.kt")
      public void testSetWithTrailingLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/setWithTrailingLambda.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/simple.kt");
      }

      @Test
      @TestMetadata("stringTemplates.kt")
      public void testStringTemplates() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/stringTemplates.kt");
      }

      @Test
      @TestMetadata("tryInLambda.kt")
      public void testTryInLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/tryInLambda.kt");
      }

      @Test
      @TestMetadata("typeMismatchOnExpectedJavaMap.kt")
      public void testTypeMismatchOnExpectedJavaMap() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/typeMismatchOnExpectedJavaMap.kt");
      }

      @Test
      @TestMetadata("untouchedReturnInIf.kt")
      public void testUntouchedReturnInIf() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/untouchedReturnInIf.kt");
      }

      @Test
      @TestMetadata("vararg.kt")
      public void testVararg() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/vararg.kt");
      }

      @Test
      @TestMetadata("varargFromJava.kt")
      public void testVarargFromJava() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/varargFromJava.kt");
      }

      @Test
      @TestMetadata("varargOfLambdasWithReceiver.kt")
      public void testVarargOfLambdasWithReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/varargOfLambdasWithReceiver.kt");
      }

      @Test
      @TestMetadata("varargProjection.kt")
      public void testVarargProjection() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arguments/varargProjection.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/arrays")
    @TestDataPath("$PROJECT_ROOT")
    public class Arrays {
      @Test
      public void testAllFilesPresentInArrays() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/arrays"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("arraySet.kt")
      public void testArraySet() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arrays/arraySet.kt");
      }

      @Test
      @TestMetadata("arraySetWithOperation.kt")
      public void testArraySetWithOperation() {
        runTest("compiler/fir/analysis-tests/testData/resolve/arrays/arraySetWithOperation.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/builtins")
    @TestDataPath("$PROJECT_ROOT")
    public class Builtins {
      @Test
      public void testAllFilesPresentInBuiltins() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/builtins"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("lists.kt")
      public void testLists() {
        runTest("compiler/fir/analysis-tests/testData/resolve/builtins/lists.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/callResolution")
    @TestDataPath("$PROJECT_ROOT")
    public class CallResolution {
      @Test
      public void testAllFilesPresentInCallResolution() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/callResolution"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("arraySetWithPlusAssign.kt")
      public void testArraySetWithPlusAssign() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/arraySetWithPlusAssign.kt");
      }

      @Test
      @TestMetadata("chooseOverloadByShapeOfLambda.kt")
      public void testChooseOverloadByShapeOfLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/chooseOverloadByShapeOfLambda.kt");
      }

      @Test
      @TestMetadata("companionInvoke.kt")
      public void testCompanionInvoke() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/companionInvoke.kt");
      }

      @Test
      @TestMetadata("companionVsSuperStatic.kt")
      public void testCompanionVsSuperStatic() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/companionVsSuperStatic.kt");
      }

      @Test
      @TestMetadata("debugExpressionType.kt")
      public void testDebugExpressionType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/debugExpressionType.kt");
      }

      @Test
      @TestMetadata("debugInfoCall.kt")
      public void testDebugInfoCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/debugInfoCall.kt");
      }

      @Test
      @TestMetadata("errorCandidates.kt")
      public void testErrorCandidates() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/errorCandidates.kt");
      }

      @Test
      @TestMetadata("exponentialArraySetWithPlusAssign.kt")
      public void testExponentialArraySetWithPlusAssign() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/exponentialArraySetWithPlusAssign.kt");
      }

      @Test
      @TestMetadata("extensionInvokeAfterSafeCall.kt")
      public void testExtensionInvokeAfterSafeCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/extensionInvokeAfterSafeCall.kt");
      }

      @Test
      @TestMetadata("incorrectPlusOperatorFromJava.kt")
      public void testIncorrectPlusOperatorFromJava() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/incorrectPlusOperatorFromJava.kt");
      }

      @Test
      @TestMetadata("invokeAmbiguity.kt")
      public void testInvokeAmbiguity() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/invokeAmbiguity.kt");
      }

      @Test
      @TestMetadata("invokeWithReceiverAndArgument.kt")
      public void testInvokeWithReceiverAndArgument() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/invokeWithReceiverAndArgument.kt");
      }

      @Test
      @TestMetadata("kt37056.kt")
      public void testKt37056() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/kt37056.kt");
      }

      @Test
      @TestMetadata("kt50386.kt")
      public void testKt50386() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/kt50386.kt");
      }

      @Test
      @TestMetadata("lambdaAsReceiver.kt")
      public void testLambdaAsReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/lambdaAsReceiver.kt");
      }

      @Test
      @TestMetadata("objectInvoke.kt")
      public void testObjectInvoke() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/objectInvoke.kt");
      }

      @Test
      @TestMetadata("overloadsWithGenericAndGenericLambda.kt")
      public void testOverloadsWithGenericAndGenericLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/overloadsWithGenericAndGenericLambda.kt");
      }

      @Test
      @TestMetadata("referenceToNestedClass.kt")
      public void testReferenceToNestedClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/referenceToNestedClass.kt");
      }

      @Test
      @TestMetadata("safeCallOnTypeAlias.kt")
      public void testSafeCallOnTypeAlias() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/safeCallOnTypeAlias.kt");
      }

      @Test
      @TestMetadata("superAny.kt")
      public void testSuperAny() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/superAny.kt");
      }

      @Test
      @TestMetadata("suspendCOnversionForReceiver.kt")
      public void testSuspendCOnversionForReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/suspendCOnversionForReceiver.kt");
      }

      @Test
      @TestMetadata("syntheticPropertiesWrongImplicitReceiver.kt")
      public void testSyntheticPropertiesWrongImplicitReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/syntheticPropertiesWrongImplicitReceiver.kt");
      }

      @Test
      @TestMetadata("twoLocalLambdasWithSameName.kt")
      public void testTwoLocalLambdasWithSameName() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/twoLocalLambdasWithSameName.kt");
      }

      @Test
      @TestMetadata("typeAliasWithNotNullBound.kt")
      public void testTypeAliasWithNotNullBound() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/typeAliasWithNotNullBound.kt");
      }

      @Test
      @TestMetadata("uselessMultipleBounds.kt")
      public void testUselessMultipleBounds() {
        runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/uselessMultipleBounds.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/cfa")
    @TestDataPath("$PROJECT_ROOT")
    public class Cfa {
      @Test
      public void testAllFilesPresentInCfa() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/cfa"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("initializationInTry.kt")
      public void testInitializationInTry() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfa/initializationInTry.kt");
      }

      @Test
      @TestMetadata("kt53819.kt")
      public void testKt53819() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfa/kt53819.kt");
      }

      @Test
      @TestMetadata("reassignOfNonLocalProperty_initializedProperties.kt")
      public void testReassignOfNonLocalProperty_initializedProperties() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfa/reassignOfNonLocalProperty_initializedProperties.kt");
      }

      @Test
      @TestMetadata("reassignOfNonMemberProperty_lateInitialization.kt")
      public void testReassignOfNonMemberProperty_lateInitialization() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfa/reassignOfNonMemberProperty_lateInitialization.kt");
      }

      @Test
      @TestMetadata("smartcastOnThisDuringClassInitialization.kt")
      public void testSmartcastOnThisDuringClassInitialization() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfa/smartcastOnThisDuringClassInitialization.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/cfg")
    @TestDataPath("$PROJECT_ROOT")
    public class Cfg {
      @Test
      public void testAllFilesPresentInCfg() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/cfg"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("annotatedLocalClass.kt")
      public void testAnnotatedLocalClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/annotatedLocalClass.kt");
      }

      @Test
      @TestMetadata("anonymousObjectInUnreachableCode.kt")
      public void testAnonymousObjectInUnreachableCode() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/anonymousObjectInUnreachableCode.kt");
      }

      @Test
      @TestMetadata("binaryOperations.kt")
      public void testBinaryOperations() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/binaryOperations.kt");
      }

      @Test
      @TestMetadata("booleanOperatorsWithConsts.kt")
      public void testBooleanOperatorsWithConsts() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/booleanOperatorsWithConsts.kt");
      }

      @Test
      @TestMetadata("complex.kt")
      public void testComplex() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/complex.kt");
      }

      @Test
      @TestMetadata("defaultArguments.kt")
      public void testDefaultArguments() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/defaultArguments.kt");
      }

      @Test
      @TestMetadata("emptyWhen.kt")
      public void testEmptyWhen() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/emptyWhen.kt");
      }

      @Test
      @TestMetadata("flowFromInplaceLambda.kt")
      public void testFlowFromInplaceLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/flowFromInplaceLambda.kt");
      }

      @Test
      @TestMetadata("flowFromInplaceLambda2.kt")
      public void testFlowFromInplaceLambda2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/flowFromInplaceLambda2.kt");
      }

      @Test
      @TestMetadata("flowFromInplaceLambda3.kt")
      public void testFlowFromInplaceLambda3() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/flowFromInplaceLambda3.kt");
      }

      @Test
      @TestMetadata("flowFromTwoInplaceLambdas.kt")
      public void testFlowFromTwoInplaceLambdas() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/flowFromTwoInplaceLambdas.kt");
      }

      @Test
      @TestMetadata("initBlock.kt")
      public void testInitBlock() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/initBlock.kt");
      }

      @Test
      @TestMetadata("initBlockAndInPlaceLambda.kt")
      public void testInitBlockAndInPlaceLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/initBlockAndInPlaceLambda.kt");
      }

      @Test
      @TestMetadata("inlineLambdasAreInplace.kt")
      public void testInlineLambdasAreInplace() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/inlineLambdasAreInplace.kt");
      }

      @Test
      @TestMetadata("innerClassInAnonymousObject.kt")
      public void testInnerClassInAnonymousObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/innerClassInAnonymousObject.kt");
      }

      @Test
      @TestMetadata("inplaceLambdaInControlFlowExpressions.kt")
      public void testInplaceLambdaInControlFlowExpressions() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/inplaceLambdaInControlFlowExpressions.kt");
      }

      @Test
      @TestMetadata("jumps.kt")
      public void testJumps() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/jumps.kt");
      }

      @Test
      @TestMetadata("lambdaAsReturnOfLambda.kt")
      public void testLambdaAsReturnOfLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdaAsReturnOfLambda.kt");
      }

      @Test
      @TestMetadata("lambdaInIfInTry.kt")
      public void testLambdaInIfInTry() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdaInIfInTry.kt");
      }

      @Test
      @TestMetadata("lambdaReturningObject.kt")
      public void testLambdaReturningObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdaReturningObject.kt");
      }

      @Test
      @TestMetadata("lambdas.kt")
      public void testLambdas() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdas.kt");
      }

      @Test
      @TestMetadata("localClassesWithImplicit.kt")
      public void testLocalClassesWithImplicit() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/localClassesWithImplicit.kt");
      }

      @Test
      @TestMetadata("loops.kt")
      public void testLoops() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/loops.kt");
      }

      @Test
      @TestMetadata("nestedClass.kt")
      public void testNestedClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/nestedClass.kt");
      }

      @Test
      @TestMetadata("postponedLambdaInConstructor.kt")
      public void testPostponedLambdaInConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/postponedLambdaInConstructor.kt");
      }

      @Test
      @TestMetadata("postponedLambdaInReturn.kt")
      public void testPostponedLambdaInReturn() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/postponedLambdaInReturn.kt");
      }

      @Test
      @TestMetadata("postponedLambdas.kt")
      public void testPostponedLambdas() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/postponedLambdas.kt");
      }

      @Test
      @TestMetadata("propertiesAndInitBlocks.kt")
      public void testPropertiesAndInitBlocks() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/propertiesAndInitBlocks.kt");
      }

      @Test
      @TestMetadata("returnValuesFromLambda.kt")
      public void testReturnValuesFromLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/returnValuesFromLambda.kt");
      }

      @Test
      @TestMetadata("safeCalls.kt")
      public void testSafeCalls() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/safeCalls.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/simple.kt");
      }

      @Test
      @TestMetadata("tryCatch.kt")
      public void testTryCatch() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/tryCatch.kt");
      }

      @Test
      @TestMetadata("variableInitializedInTryBlock.kt")
      public void testVariableInitializedInTryBlock() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/variableInitializedInTryBlock.kt");
      }

      @Test
      @TestMetadata("when.kt")
      public void testWhen() {
        runTest("compiler/fir/analysis-tests/testData/resolve/cfg/when.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/checkers")
    @TestDataPath("$PROJECT_ROOT")
    public class Checkers {
      @Test
      public void testAllFilesPresentInCheckers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/checkers"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("complexConflictingProjections.kt")
      public void testComplexConflictingProjections() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/complexConflictingProjections.kt");
      }

      @Test
      @TestMetadata("contextReceiversSubtyping.kt")
      public void testContextReceiversSubtyping() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/contextReceiversSubtyping.kt");
      }

      @Test
      @TestMetadata("dnnTypeWithAdditionalNullableBound.kt")
      public void testDnnTypeWithAdditionalNullableBound() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/dnnTypeWithAdditionalNullableBound.kt");
      }

      @Test
      @TestMetadata("importAnnotationWithRequiresOptIn.kt")
      public void testImportAnnotationWithRequiresOptIn() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/importAnnotationWithRequiresOptIn.kt");
      }

      @Test
      @TestMetadata("internalImplicitInvokeFromInlineFun.kt")
      public void testInternalImplicitInvokeFromInlineFun() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/internalImplicitInvokeFromInlineFun.kt");
      }

      @Test
      @TestMetadata("internalSuperCallFromInlineFun.kt")
      public void testInternalSuperCallFromInlineFun() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/internalSuperCallFromInlineFun.kt");
      }

      @Test
      @TestMetadata("invalidLhsOfClassLiteral.kt")
      public void testInvalidLhsOfClassLiteral() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/invalidLhsOfClassLiteral.kt");
      }

      @Test
      @TestMetadata("notUselessCast_1.kt")
      public void testNotUselessCast_1() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/notUselessCast_1.kt");
      }

      @Test
      @TestMetadata("notUselessCast_2.kt")
      public void testNotUselessCast_2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/notUselessCast_2.kt");
      }

      @Test
      @TestMetadata("notUselessCast_3.kt")
      public void testNotUselessCast_3() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/notUselessCast_3.kt");
      }

      @Test
      @TestMetadata("recursiveDependencyBetweenReturnTypeAndSupertype.kt")
      public void testRecursiveDependencyBetweenReturnTypeAndSupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/recursiveDependencyBetweenReturnTypeAndSupertype.kt");
      }

      @Test
      @TestMetadata("redundantNullCheckOnAsCast.kt")
      public void testRedundantNullCheckOnAsCast() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/redundantNullCheckOnAsCast.kt");
      }

      @Test
      @TestMetadata("unsuccessfullCastToStartProjectedType.kt")
      public void testUnsuccessfullCastToStartProjectedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/unsuccessfullCastToStartProjectedType.kt");
      }

      @Test
      @TestMetadata("uselessCastLeadsToRecursiveProblem.kt")
      public void testUselessCastLeadsToRecursiveProblem() {
        runTest("compiler/fir/analysis-tests/testData/resolve/checkers/uselessCastLeadsToRecursiveProblem.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/classpathSubstitution")
    @TestDataPath("$PROJECT_ROOT")
    public class ClasspathSubstitution {
      @Test
      public void testAllFilesPresentInClasspathSubstitution() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/classpathSubstitution"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("cyclicSupertype.kt")
      public void testCyclicSupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/classpathSubstitution/cyclicSupertype.kt");
      }

      @Test
      @TestMetadata("cyclicSupertype2.kt")
      public void testCyclicSupertype2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/classpathSubstitution/cyclicSupertype2.kt");
      }

      @Test
      @TestMetadata("cyclicSupertypeBetweenModules.kt")
      public void testCyclicSupertypeBetweenModules() {
        runTest("compiler/fir/analysis-tests/testData/resolve/classpathSubstitution/cyclicSupertypeBetweenModules.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/constVal")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstVal {
      @Test
      public void testAllFilesPresentInConstVal() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/constVal"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("const.kt")
      public void testConst() {
        runTest("compiler/fir/analysis-tests/testData/resolve/constVal/const.kt");
      }

      @Test
      @TestMetadata("constValNotTopLevelOrObject.kt")
      public void testConstValNotTopLevelOrObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValNotTopLevelOrObject.kt");
      }

      @Test
      @TestMetadata("constValWithGetterOrDelegate.kt")
      public void testConstValWithGetterOrDelegate() {
        runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValWithGetterOrDelegate.kt");
      }

      @Test
      @TestMetadata("constValWithTypealiasType.kt")
      public void testConstValWithTypealiasType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValWithTypealiasType.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/constructors")
    @TestDataPath("$PROJECT_ROOT")
    public class Constructors {
      @Test
      public void testAllFilesPresentInConstructors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/constructors"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("erroneousDelegatedConstructorCall.kt")
      public void testErroneousDelegatedConstructorCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/constructors/erroneousDelegatedConstructorCall.kt");
      }

      @Test
      @TestMetadata("noSuperCallInSupertypes.kt")
      public void testNoSuperCallInSupertypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/constructors/noSuperCallInSupertypes.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/contextParameters")
    @TestDataPath("$PROJECT_ROOT")
    public class ContextParameters {
      @Test
      public void testAllFilesPresentInContextParameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/contextParameters"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("callableReference.kt")
      public void testCallableReference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/callableReference.kt");
      }

      @Test
      @TestMetadata("contextLambda.kt")
      public void testContextLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/contextLambda.kt");
      }

      @Test
      @TestMetadata("contextualLateinit.kt")
      public void testContextualLateinit() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/contextualLateinit.kt");
      }

      @Test
      @TestMetadata("expectActualMatch.kt")
      public void testExpectActualMatch() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/expectActualMatch.kt");
      }

      @Test
      @TestMetadata("expectActualMismatch.kt")
      public void testExpectActualMismatch() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/expectActualMismatch.kt");
      }

      @Test
      @TestMetadata("smoke.kt")
      public void testSmoke() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/smoke.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics")
      @TestDataPath("$PROJECT_ROOT")
      public class Diagnostics {
        @Test
        public void testAllFilesPresentInDiagnostics() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("contextParameterSyntaxWithoutLanguageFeature.kt")
        public void testContextParameterSyntaxWithoutLanguageFeature() {
          runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/contextParameterSyntaxWithoutLanguageFeature.kt");
        }

        @Test
        @TestMetadata("subtyping.kt")
        public void testSubtyping() {
          runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/subtyping.kt");
        }

        @Test
        @TestMetadata("unsupportedContextParameters.kt")
        public void testUnsupportedContextParameters() {
          runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/unsupportedContextParameters.kt");
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages")
        @TestDataPath("$PROJECT_ROOT")
        public class DeclarationAndUsages {
          @Test
          public void testAllFilesPresentInDeclarationAndUsages() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
          }

          @Test
          @TestMetadata("contextOnGetterSetter.kt")
          public void testContextOnGetterSetter() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/contextOnGetterSetter.kt");
          }

          @Test
          @TestMetadata("contextParameterIsNotInlined.kt")
          public void testContextParameterIsNotInlined() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/contextParameterIsNotInlined.kt");
          }

          @Test
          @TestMetadata("contextParameterToDefaultArgument.kt")
          public void testContextParameterToDefaultArgument() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/contextParameterToDefaultArgument.kt");
          }

          @Test
          @TestMetadata("emptyContextName.kt")
          public void testEmptyContextName() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/emptyContextName.kt");
          }

          @Test
          @TestMetadata("emptyListOfContextParameters.kt")
          public void testEmptyListOfContextParameters() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/emptyListOfContextParameters.kt");
          }

          @Test
          @TestMetadata("inFunctionDeclaration.kt")
          public void testInFunctionDeclaration() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/inFunctionDeclaration.kt");
          }

          @Test
          @TestMetadata("inFunctionalType.kt")
          public void testInFunctionalType() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/inFunctionalType.kt");
          }

          @Test
          @TestMetadata("inPropertyDeclaration.kt")
          public void testInPropertyDeclaration() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/inPropertyDeclaration.kt");
          }

          @Test
          @TestMetadata("initializerInProperty.kt")
          public void testInitializerInProperty() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/initializerInProperty.kt");
          }

          @Test
          @TestMetadata("inlineForTypeWithContext.kt")
          public void testInlineForTypeWithContext() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/inlineForTypeWithContext.kt");
          }

          @Test
          @TestMetadata("moreThenOneContext.kt")
          public void testMoreThenOneContext() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/moreThenOneContext.kt");
          }

          @Test
          @TestMetadata("multipleContextsWithTheSameType.kt")
          public void testMultipleContextsWithTheSameType() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/multipleContextsWithTheSameType.kt");
          }

          @Test
          @TestMetadata("nameClashes.kt")
          public void testNameClashes() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/nameClashes.kt");
          }

          @Test
          @TestMetadata("onClassifierDeclaration.kt")
          public void testOnClassifierDeclaration() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/onClassifierDeclaration.kt");
          }

          @Test
          @TestMetadata("onConstructor.kt")
          public void testOnConstructor() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/onConstructor.kt");
          }

          @Test
          @TestMetadata("parameterModifiersOnContextParameter.kt")
          public void testParameterModifiersOnContextParameter() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/parameterModifiersOnContextParameter.kt");
          }

          @Test
          @TestMetadata("parameterType.kt")
          public void testParameterType() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/parameterType.kt");
          }

          @Test
          @TestMetadata("parameterTypeWithContext.kt")
          public void testParameterTypeWithContext() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/parameterTypeWithContext.kt");
          }

          @Test
          @TestMetadata("parameterWithDefault.kt")
          public void testParameterWithDefault() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/parameterWithDefault.kt");
          }

          @Test
          @TestMetadata("propertyWithContextAndContextType.kt")
          public void testPropertyWithContextAndContextType() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/propertyWithContextAndContextType.kt");
          }

          @Test
          @TestMetadata("usageWithoutContext.kt")
          public void testUsageWithoutContext() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/usageWithoutContext.kt");
          }

          @Test
          @TestMetadata("usageWithoutContextForMultipleParameters.kt")
          public void testUsageWithoutContextForMultipleParameters() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/usageWithoutContextForMultipleParameters.kt");
          }

          @Test
          @TestMetadata("valVarOnContextParameter.kt")
          public void testValVarOnContextParameter() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/valVarOnContextParameter.kt");
          }

          @Test
          @TestMetadata("visibilityOfContextTypeOnFunction.kt")
          public void testVisibilityOfContextTypeOnFunction() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/visibilityOfContextTypeOnFunction.kt");
          }

          @Test
          @TestMetadata("visibilityOfContextTypeOnProperty.kt")
          public void testVisibilityOfContextTypeOnProperty() {
            runTest("compiler/fir/analysis-tests/testData/resolve/contextParameters/diagnostics/declarationAndUsages/visibilityOfContextTypeOnProperty.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/contracts")
    @TestDataPath("$PROJECT_ROOT")
    public class Contracts {
      @Test
      public void testAllFilesPresentInContracts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/contracts"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("contractFromOtherModule.kt")
      public void testContractFromOtherModule() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contracts/contractFromOtherModule.kt");
      }

      @Test
      @TestMetadata("contractFromOtherModule_samePackage.kt")
      public void testContractFromOtherModule_samePackage() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contracts/contractFromOtherModule_samePackage.kt");
      }

      @Test
      @TestMetadata("contractOnInfixFunction.kt")
      public void testContractOnInfixFunction() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contracts/contractOnInfixFunction.kt");
      }

      @Test
      @TestMetadata("disabledFeature.kt")
      public void testDisabledFeature() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contracts/disabledFeature.kt");
      }

      @Test
      @TestMetadata("exctlyOnceCallBetweenUnrelatedLambdas.kt")
      public void testExctlyOnceCallBetweenUnrelatedLambdas() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contracts/exctlyOnceCallBetweenUnrelatedLambdas.kt");
      }

      @Test
      @TestMetadata("genericContract.kt")
      public void testGenericContract() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contracts/genericContract.kt");
      }

      @Test
      @TestMetadata("inPlaceAfterVararg.kt")
      public void testInPlaceAfterVararg() {
        runTest("compiler/fir/analysis-tests/testData/resolve/contracts/inPlaceAfterVararg.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/delegates")
    @TestDataPath("$PROJECT_ROOT")
    public class Delegates {
      @Test
      public void testAllFilesPresentInDelegates() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/delegates"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("callOnThisInDelegateExpression.kt")
      public void testCallOnThisInDelegateExpression() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/callOnThisInDelegateExpression.kt");
      }

      @Test
      @TestMetadata("delegateInference.kt")
      public void testDelegateInference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateInference.kt");
      }

      @Test
      @TestMetadata("delegateWithArgInference.kt")
      public void testDelegateWithArgInference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateWithArgInference.kt");
      }

      @Test
      @TestMetadata("delegateWithLambda.kt")
      public void testDelegateWithLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateWithLambda.kt");
      }

      @Test
      @TestMetadata("extensionGenericGetValue.kt")
      public void testExtensionGenericGetValue() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/extensionGenericGetValue.kt");
      }

      @Test
      @TestMetadata("extensionGetValueWithTypeVariableAsReceiver.kt")
      public void testExtensionGetValueWithTypeVariableAsReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/extensionGetValueWithTypeVariableAsReceiver.kt");
      }

      @Test
      @TestMetadata("kt41982.kt")
      public void testKt41982() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/kt41982.kt");
      }

      @Test
      @TestMetadata("provideDelegate.kt")
      public void testProvideDelegate() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/provideDelegate.kt");
      }

      @Test
      @TestMetadata("receiverInference.kt")
      public void testReceiverInference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegates/receiverInference.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    public class Diagnostics {
      @Test
      @TestMetadata("abstractSuperCall.kt")
      public void testAbstractSuperCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/abstractSuperCall.kt");
      }

      @Test
      @TestMetadata("abstractSuperCallInPresenseOfNonAbstractMethodInParent.kt")
      public void testAbstractSuperCallInPresenseOfNonAbstractMethodInParent() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/abstractSuperCallInPresenseOfNonAbstractMethodInParent.kt");
      }

      @Test
      public void testAllFilesPresentInDiagnostics() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/diagnostics"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("annotationArgumentKClassLiteralTypeError.kt")
      public void testAnnotationArgumentKClassLiteralTypeError() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentKClassLiteralTypeError.kt");
      }

      @Test
      @TestMetadata("annotationArgumentMustBeConst.kt")
      public void testAnnotationArgumentMustBeConst() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeConst.kt");
      }

      @Test
      @TestMetadata("annotationArgumentMustBeEnumConst.kt")
      public void testAnnotationArgumentMustBeEnumConst() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeEnumConst.kt");
      }

      @Test
      @TestMetadata("annotationArgumentMustBeKClassLiteral.kt")
      public void testAnnotationArgumentMustBeKClassLiteral() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeKClassLiteral.kt");
      }

      @Test
      @TestMetadata("annotationClassMember.kt")
      public void testAnnotationClassMember() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationClassMember.kt");
      }

      @Test
      @TestMetadata("anonymousObjectByDelegate.kt")
      public void testAnonymousObjectByDelegate() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/anonymousObjectByDelegate.kt");
      }

      @Test
      @TestMetadata("classInSupertypeForEnum.kt")
      public void testClassInSupertypeForEnum() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/classInSupertypeForEnum.kt");
      }

      @Test
      @TestMetadata("conflictingOverloads.kt")
      public void testConflictingOverloads() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/conflictingOverloads.kt");
      }

      @Test
      @TestMetadata("conflictingOverloads2.kt")
      public void testConflictingOverloads2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/conflictingOverloads2.kt");
      }

      @Test
      @TestMetadata("conflictingProjection.kt")
      public void testConflictingProjection() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/conflictingProjection.kt");
      }

      @Test
      @TestMetadata("constructorInInterface.kt")
      public void testConstructorInInterface() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/constructorInInterface.kt");
      }

      @Test
      @TestMetadata("cyclicConstructorDelegationCall.kt")
      public void testCyclicConstructorDelegationCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/cyclicConstructorDelegationCall.kt");
      }

      @Test
      @TestMetadata("delegationInInterface.kt")
      public void testDelegationInInterface() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/delegationInInterface.kt");
      }

      @Test
      @TestMetadata("delegationSuperCallInEnumConstructor.kt")
      public void testDelegationSuperCallInEnumConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/delegationSuperCallInEnumConstructor.kt");
      }

      @Test
      @TestMetadata("explicitDelegationCallRequired.kt")
      public void testExplicitDelegationCallRequired() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/explicitDelegationCallRequired.kt");
      }

      @Test
      @TestMetadata("inapplicableLateinitModifier.kt")
      public void testInapplicableLateinitModifier() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/inapplicableLateinitModifier.kt");
      }

      @Test
      @TestMetadata("incompatibleModifiers.kt")
      public void testIncompatibleModifiers() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/incompatibleModifiers.kt");
      }

      @Test
      @TestMetadata("infixFunctions.kt")
      public void testInfixFunctions() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/infixFunctions.kt");
      }

      @Test
      @TestMetadata("instanceAccessBeforeSuperCall.kt")
      public void testInstanceAccessBeforeSuperCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/instanceAccessBeforeSuperCall.kt");
      }

      @Test
      @TestMetadata("instanceAccessBeforeSuperCallErrorOnRed.kt")
      public void testInstanceAccessBeforeSuperCallErrorOnRed() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/instanceAccessBeforeSuperCallErrorOnRed.kt");
      }

      @Test
      @TestMetadata("interfaceWithSuperclass.kt")
      public void testInterfaceWithSuperclass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/interfaceWithSuperclass.kt");
      }

      @Test
      @TestMetadata("javaInheritsPrivateJavaClass.kt")
      public void testJavaInheritsPrivateJavaClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/javaInheritsPrivateJavaClass.kt");
      }

      @Test
      @TestMetadata("javaInheritsPrivateKtClass2.kt")
      public void testJavaInheritsPrivateKtClass2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/javaInheritsPrivateKtClass2.kt");
      }

      @Test
      @TestMetadata("javaInheritsPrivateKtClassDisabled.kt")
      public void testJavaInheritsPrivateKtClassDisabled() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/javaInheritsPrivateKtClassDisabled.kt");
      }

      @Test
      @TestMetadata("javaInheritsPrivateKtClassEnabled.kt")
      public void testJavaInheritsPrivateKtClassEnabled() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/javaInheritsPrivateKtClassEnabled.kt");
      }

      @Test
      @TestMetadata("localAnnotationClass.kt")
      public void testLocalAnnotationClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/localAnnotationClass.kt");
      }

      @Test
      @TestMetadata("localEntitytNotAllowed.kt")
      public void testLocalEntitytNotAllowed() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/localEntitytNotAllowed.kt");
      }

      @Test
      @TestMetadata("manyCompanionObjects.kt")
      public void testManyCompanionObjects() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/manyCompanionObjects.kt");
      }

      @Test
      @TestMetadata("methodOfAnyImplementedInInterface.kt")
      public void testMethodOfAnyImplementedInInterface() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/methodOfAnyImplementedInInterface.kt");
      }

      @Test
      @TestMetadata("multipleBounds.kt")
      public void testMultipleBounds() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/multipleBounds.kt");
      }

      @Test
      @TestMetadata("nonConstValInAnnotationArgument.kt")
      public void testNonConstValInAnnotationArgument() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/nonConstValInAnnotationArgument.kt");
      }

      @Test
      @TestMetadata("notASupertype.kt")
      public void testNotASupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/notASupertype.kt");
      }

      @Test
      @TestMetadata("primaryConstructorParametersInSecondaryConstructor.kt")
      public void testPrimaryConstructorParametersInSecondaryConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/primaryConstructorParametersInSecondaryConstructor.kt");
      }

      @Test
      @TestMetadata("primaryConstructorRequiredForDataClass.kt")
      public void testPrimaryConstructorRequiredForDataClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/primaryConstructorRequiredForDataClass.kt");
      }

      @Test
      @TestMetadata("projectionsOnNonClassTypeArguments.kt")
      public void testProjectionsOnNonClassTypeArguments() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/projectionsOnNonClassTypeArguments.kt");
      }

      @Test
      @TestMetadata("propertyTypeMismatchOnOverride.kt")
      public void testPropertyTypeMismatchOnOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/propertyTypeMismatchOnOverride.kt");
      }

      @Test
      @TestMetadata("qualifiedSupertypeExtendedByOtherSupertype.kt")
      public void testQualifiedSupertypeExtendedByOtherSupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/qualifiedSupertypeExtendedByOtherSupertype.kt");
      }

      @Test
      @TestMetadata("recursiveProblemWithSyntaxError.kt")
      public void testRecursiveProblemWithSyntaxError() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/recursiveProblemWithSyntaxError.kt");
      }

      @Test
      @TestMetadata("redundantModifier.kt")
      public void testRedundantModifier() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/redundantModifier.kt");
      }

      @Test
      @TestMetadata("repeatedModifier.kt")
      public void testRepeatedModifier() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/repeatedModifier.kt");
      }

      @Test
      @TestMetadata("returnTypeMismatchOnOverride.kt")
      public void testReturnTypeMismatchOnOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/returnTypeMismatchOnOverride.kt");
      }

      @Test
      @TestMetadata("sealedClassConstructorCall.kt")
      public void testSealedClassConstructorCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/sealedClassConstructorCall.kt");
      }

      @Test
      @TestMetadata("sealedSupertype.kt")
      public void testSealedSupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/sealedSupertype.kt");
      }

      @Test
      @TestMetadata("someOverridesTest.kt")
      public void testSomeOverridesTest() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/someOverridesTest.kt");
      }

      @Test
      @TestMetadata("superCallWithDelegation.kt")
      public void testSuperCallWithDelegation() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superCallWithDelegation.kt");
      }

      @Test
      @TestMetadata("superIsNotAnExpression.kt")
      public void testSuperIsNotAnExpression() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superIsNotAnExpression.kt");
      }

      @Test
      @TestMetadata("superNotAvailable.kt")
      public void testSuperNotAvailable() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superNotAvailable.kt");
      }

      @Test
      @TestMetadata("superclassNotAccessibleFromInterface.kt")
      public void testSuperclassNotAccessibleFromInterface() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superclassNotAccessibleFromInterface.kt");
      }

      @Test
      @TestMetadata("supertypeInitializedInInterface.kt")
      public void testSupertypeInitializedInInterface() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/supertypeInitializedInInterface.kt");
      }

      @Test
      @TestMetadata("supertypeInitializedWithoutPrimaryConstructor.kt")
      public void testSupertypeInitializedWithoutPrimaryConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/supertypeInitializedWithoutPrimaryConstructor.kt");
      }

      @Test
      @TestMetadata("suspendAnonymousFunction.kt")
      public void testSuspendAnonymousFunction() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/suspendAnonymousFunction.kt");
      }

      @Test
      @TestMetadata("testIllegalAnnotationClass.kt")
      public void testTestIllegalAnnotationClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/testIllegalAnnotationClass.kt");
      }

      @Test
      @TestMetadata("typeArgumentsNotAllowed.kt")
      public void testTypeArgumentsNotAllowed() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeArgumentsNotAllowed.kt");
      }

      @Test
      @TestMetadata("typeOfAnnotationMember.kt")
      public void testTypeOfAnnotationMember() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeOfAnnotationMember.kt");
      }

      @Test
      @TestMetadata("typeParametersInEnum.kt")
      public void testTypeParametersInEnum() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeParametersInEnum.kt");
      }

      @Test
      @TestMetadata("typeParametersInObject.kt")
      public void testTypeParametersInObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeParametersInObject.kt");
      }

      @Test
      @TestMetadata("unusedAnonymLambdaParam.kt")
      public void testUnusedAnonymLambdaParam() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/unusedAnonymLambdaParam.kt");
      }

      @Test
      @TestMetadata("upperBoundViolated.kt")
      public void testUpperBoundViolated() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/upperBoundViolated.kt");
      }

      @Test
      @TestMetadata("valOnAnnotationParameter.kt")
      public void testValOnAnnotationParameter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/valOnAnnotationParameter.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression")
      @TestDataPath("$PROJECT_ROOT")
      public class FunctionAsExpression {
        @Test
        public void testAllFilesPresentInFunctionAsExpression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("Parameters.kt")
        public void testParameters() {
          runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression/Parameters.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness")
    @TestDataPath("$PROJECT_ROOT")
    public class Exhaustiveness {
      @Test
      public void testAllFilesPresentInExhaustiveness() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative")
      @TestDataPath("$PROJECT_ROOT")
      public class Negative {
        @Test
        public void testAllFilesPresentInNegative() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("missingBooleanBranch.kt")
        public void testMissingBooleanBranch() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingBooleanBranch.kt");
        }

        @Test
        @TestMetadata("missingElse.kt")
        public void testMissingElse() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingElse.kt");
        }

        @Test
        @TestMetadata("missingEnumEntry.kt")
        public void testMissingEnumEntry() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingEnumEntry.kt");
        }

        @Test
        @TestMetadata("missingSealedInheritor.kt")
        public void testMissingSealedInheritor() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingSealedInheritor.kt");
        }

        @Test
        @TestMetadata("nonExhaustiveWhenWithoutCoercionToUnit.kt")
        public void testNonExhaustiveWhenWithoutCoercionToUnit() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/nonExhaustiveWhenWithoutCoercionToUnit.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive")
      @TestDataPath("$PROJECT_ROOT")
      public class Positive {
        @Test
        public void testAllFilesPresentInPositive() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("annotatedBranch.kt")
        public void testAnnotatedBranch() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/annotatedBranch.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenAndDNNType.kt")
        public void testExhaustiveWhenAndDNNType() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveWhenAndDNNType.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenAndFlexibleType.kt")
        public void testExhaustiveWhenAndFlexibleType() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveWhenAndFlexibleType.kt");
        }

        @Test
        @TestMetadata("exhaustiveness_boolean.kt")
        public void testExhaustiveness_boolean() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_boolean.kt");
        }

        @Test
        @TestMetadata("exhaustiveness_enum.kt")
        public void testExhaustiveness_enum() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_enum.kt");
        }

        @Test
        @TestMetadata("exhaustiveness_enumJava.kt")
        public void testExhaustiveness_enumJava() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_enumJava.kt");
        }

        @Test
        @TestMetadata("exhaustiveness_sealedClass.kt")
        public void testExhaustiveness_sealedClass() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedClass.kt");
        }

        @Test
        @TestMetadata("exhaustiveness_sealedObject.kt")
        public void testExhaustiveness_sealedObject() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedObject.kt");
        }

        @Test
        @TestMetadata("exhaustiveness_sealedSubClass.kt")
        public void testExhaustiveness_sealedSubClass() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedSubClass.kt");
        }

        @Test
        @TestMetadata("exhaustiveness_smartcastedBoolean.kt")
        public void testExhaustiveness_smartcastedBoolean() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_smartcastedBoolean.kt");
        }

        @Test
        @TestMetadata("nestedIfInLambda.kt")
        public void testNestedIfInLambda() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/nestedIfInLambda.kt");
        }

        @Test
        @TestMetadata("nonExhaustiveWhenWithCoercionToUnit.kt")
        public void testNonExhaustiveWhenWithCoercionToUnit() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/nonExhaustiveWhenWithCoercionToUnit.kt");
        }

        @Test
        @TestMetadata("sameBranchMultipleConditions.kt")
        public void testSameBranchMultipleConditions() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/sameBranchMultipleConditions.kt");
        }

        @Test
        @TestMetadata("smartcastToExhaustiveInterface.kt")
        public void testSmartcastToExhaustiveInterface() {
          runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/smartcastToExhaustiveInterface.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions")
    @TestDataPath("$PROJECT_ROOT")
    public class Expresssions {
      @Test
      @TestMetadata("access.kt")
      public void testAccess() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/access.kt");
      }

      @Test
      public void testAllFilesPresentInExpresssions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("annotationWithReturn.kt")
      public void testAnnotationWithReturn() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/annotationWithReturn.kt");
      }

      @Test
      @TestMetadata("annotations.kt")
      public void testAnnotations() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/annotations.kt");
      }

      @Test
      @TestMetadata("baseQualifier.kt")
      public void testBaseQualifier() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/baseQualifier.kt");
      }

      @Test
      @TestMetadata("blockLocalScopes.kt")
      public void testBlockLocalScopes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/blockLocalScopes.kt");
      }

      @Test
      @TestMetadata("CallBasedInExpressionGenerator.kt")
      public void testCallBasedInExpressionGenerator() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/CallBasedInExpressionGenerator.kt");
      }

      @Test
      @TestMetadata("checkArguments.kt")
      public void testCheckArguments() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/checkArguments.kt");
      }

      @Test
      @TestMetadata("classifierAccessFromCompanion.kt")
      public void testClassifierAccessFromCompanion() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/classifierAccessFromCompanion.kt");
      }

      @Test
      @TestMetadata("companion.kt")
      public void testCompanion() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/companion.kt");
      }

      @Test
      @TestMetadata("companionExtension.kt")
      public void testCompanionExtension() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/companionExtension.kt");
      }

      @Test
      @TestMetadata("constructor.kt")
      public void testConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/constructor.kt");
      }

      @Test
      @TestMetadata("dispatchReceiver.kt")
      public void testDispatchReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/dispatchReceiver.kt");
      }

      @Test
      @TestMetadata("enumEntryUse.kt")
      public void testEnumEntryUse() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/enumEntryUse.kt");
      }

      @Test
      @TestMetadata("enumValues.kt")
      public void testEnumValues() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/enumValues.kt");
      }

      @Test
      @TestMetadata("errCallable.kt")
      public void testErrCallable() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/errCallable.kt");
      }

      @Test
      @TestMetadata("extensionPropertyInLambda.kt")
      public void testExtensionPropertyInLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/extensionPropertyInLambda.kt");
      }

      @Test
      @TestMetadata("genericDecorator.kt")
      public void testGenericDecorator() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDecorator.kt");
      }

      @Test
      @TestMetadata("genericDescriptor.kt")
      public void testGenericDescriptor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDescriptor.kt");
      }

      @Test
      @TestMetadata("genericDiagnostic.kt")
      public void testGenericDiagnostic() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDiagnostic.kt");
      }

      @Test
      @TestMetadata("genericPropertyAccess.kt")
      public void testGenericPropertyAccess() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericPropertyAccess.kt");
      }

      @Test
      @TestMetadata("genericUsedInFunction.kt")
      public void testGenericUsedInFunction() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericUsedInFunction.kt");
      }

      @Test
      @TestMetadata("importedReceiver.kt")
      public void testImportedReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/importedReceiver.kt");
      }

      @Test
      @TestMetadata("innerQualifier.kt")
      public void testInnerQualifier() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/innerQualifier.kt");
      }

      @Test
      @TestMetadata("innerWithSuperCompanion.kt")
      public void testInnerWithSuperCompanion() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/innerWithSuperCompanion.kt");
      }

      @Test
      @TestMetadata("javaFieldCallable.kt")
      public void testJavaFieldCallable() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/javaFieldCallable.kt");
      }

      @Test
      @TestMetadata("lambda.kt")
      public void testLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/lambda.kt");
      }

      @Test
      @TestMetadata("lambdaWithReceiver.kt")
      public void testLambdaWithReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/lambdaWithReceiver.kt");
      }

      @Test
      @TestMetadata("localClassAccessesContainingClass.kt")
      public void testLocalClassAccessesContainingClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localClassAccessesContainingClass.kt");
      }

      @Test
      @TestMetadata("localConstructor.kt")
      public void testLocalConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localConstructor.kt");
      }

      @Test
      @TestMetadata("localExtension.kt")
      public void testLocalExtension() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localExtension.kt");
      }

      @Test
      @TestMetadata("localImplicitBodies.kt")
      public void testLocalImplicitBodies() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localImplicitBodies.kt");
      }

      @Test
      @TestMetadata("localInnerClass.kt")
      public void testLocalInnerClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localInnerClass.kt");
      }

      @Test
      @TestMetadata("localObjects.kt")
      public void testLocalObjects() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localObjects.kt");
      }

      @Test
      @TestMetadata("localScopes.kt")
      public void testLocalScopes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localScopes.kt");
      }

      @Test
      @TestMetadata("localTypes.kt")
      public void testLocalTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localTypes.kt");
      }

      @Test
      @TestMetadata("localWithBooleanNot.kt")
      public void testLocalWithBooleanNot() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localWithBooleanNot.kt");
      }

      @Test
      @TestMetadata("memberExtension.kt")
      public void testMemberExtension() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/memberExtension.kt");
      }

      @Test
      @TestMetadata("nestedConstructorCallable.kt")
      public void testNestedConstructorCallable() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedConstructorCallable.kt");
      }

      @Test
      @TestMetadata("nestedObjects.kt")
      public void testNestedObjects() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedObjects.kt");
      }

      @Test
      @TestMetadata("nestedVisibility.kt")
      public void testNestedVisibility() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedVisibility.kt");
      }

      @Test
      @TestMetadata("objectOverrideCallViaImport.kt")
      public void testObjectOverrideCallViaImport() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objectOverrideCallViaImport.kt");
      }

      @Test
      @TestMetadata("objectVsProperty.kt")
      public void testObjectVsProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objectVsProperty.kt");
      }

      @Test
      @TestMetadata("objects.kt")
      public void testObjects() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objects.kt");
      }

      @Test
      @TestMetadata("outerMemberAccesses.kt")
      public void testOuterMemberAccesses() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/outerMemberAccesses.kt");
      }

      @Test
      @TestMetadata("outerObject.kt")
      public void testOuterObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/outerObject.kt");
      }

      @Test
      @TestMetadata("overriddenJavaGetter.kt")
      public void testOverriddenJavaGetter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/overriddenJavaGetter.kt");
      }

      @Test
      @TestMetadata("parenthesizedSafeCallsAndOperators.kt")
      public void testParenthesizedSafeCallsAndOperators() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/parenthesizedSafeCallsAndOperators.kt");
      }

      @Test
      @TestMetadata("plusWithAssignSmartCast.kt")
      public void testPlusWithAssignSmartCast() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/plusWithAssignSmartCast.kt");
      }

      @Test
      @TestMetadata("privateObjectLiteral.kt")
      public void testPrivateObjectLiteral() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/privateObjectLiteral.kt");
      }

      @Test
      @TestMetadata("privateVisibility.kt")
      public void testPrivateVisibility() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/privateVisibility.kt");
      }

      @Test
      @TestMetadata("propertyAccessWithExplicitTypeArguments.kt")
      public void testPropertyAccessWithExplicitTypeArguments() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/propertyAccessWithExplicitTypeArguments.kt");
      }

      @Test
      @TestMetadata("protectedVisibility.kt")
      public void testProtectedVisibility() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/protectedVisibility.kt");
      }

      @Test
      @TestMetadata("qualifiedExpressions.kt")
      public void testQualifiedExpressions() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/qualifiedExpressions.kt");
      }

      @Test
      @TestMetadata("qualifierPriority.kt")
      public void testQualifierPriority() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/qualifierPriority.kt");
      }

      @Test
      @TestMetadata("receiverConsistency.kt")
      public void testReceiverConsistency() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/receiverConsistency.kt");
      }

      @Test
      @TestMetadata("sameReceiver.kt")
      public void testSameReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/sameReceiver.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/simple.kt");
      }

      @Test
      @TestMetadata("syntheticInImplicitBody.kt")
      public void testSyntheticInImplicitBody() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/syntheticInImplicitBody.kt");
      }

      @Test
      @TestMetadata("syntheticSmartCast.kt")
      public void testSyntheticSmartCast() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/syntheticSmartCast.kt");
      }

      @Test
      @TestMetadata("this.kt")
      public void testThis() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/this.kt");
      }

      @Test
      @TestMetadata("topExtensionVsOuterMember.kt")
      public void testTopExtensionVsOuterMember() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/topExtensionVsOuterMember.kt");
      }

      @Test
      @TestMetadata("typeAliasConstructor.kt")
      public void testTypeAliasConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/typeAliasConstructor.kt");
      }

      @Test
      @TestMetadata("vararg.kt")
      public void testVararg() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/vararg.kt");
      }

      @Test
      @TestMetadata("when.kt")
      public void testWhen() {
        runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/when.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/inference")
      @TestDataPath("$PROJECT_ROOT")
      public class Inference {
        @Test
        public void testAllFilesPresentInInference() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("id.kt")
        public void testId() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/id.kt");
        }

        @Test
        @TestMetadata("typeParameters.kt")
        public void testTypeParameters() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/typeParameters.kt");
        }

        @Test
        @TestMetadata("typeParameters2.kt")
        public void testTypeParameters2() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/typeParameters2.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke")
      @TestDataPath("$PROJECT_ROOT")
      public class Invoke {
        @Test
        public void testAllFilesPresentInInvoke() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("doubleBrackets.kt")
        public void testDoubleBrackets() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/doubleBrackets.kt");
        }

        @Test
        @TestMetadata("explicitReceiver.kt")
        public void testExplicitReceiver() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/explicitReceiver.kt");
        }

        @Test
        @TestMetadata("explicitReceiver2.kt")
        public void testExplicitReceiver2() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/explicitReceiver2.kt");
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extension.kt");
        }

        @Test
        @TestMetadata("extensionOnObject.kt")
        public void testExtensionOnObject() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extensionOnObject.kt");
        }

        @Test
        @TestMetadata("extensionSafeCall.kt")
        public void testExtensionSafeCall() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extensionSafeCall.kt");
        }

        @Test
        @TestMetadata("farInvokeExtension.kt")
        public void testFarInvokeExtension() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/farInvokeExtension.kt");
        }

        @Test
        @TestMetadata("implicitTypeOrder.kt")
        public void testImplicitTypeOrder() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/implicitTypeOrder.kt");
        }

        @Test
        @TestMetadata("inBrackets.kt")
        public void testInBrackets() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/inBrackets.kt");
        }

        @Test
        @TestMetadata("incorrectInvokeReceiver.kt")
        public void testIncorrectInvokeReceiver() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/incorrectInvokeReceiver.kt");
        }

        @Test
        @TestMetadata("propertyFromParameter.kt")
        public void testPropertyFromParameter() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/propertyFromParameter.kt");
        }

        @Test
        @TestMetadata("propertyWithExtensionType.kt")
        public void testPropertyWithExtensionType() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/propertyWithExtensionType.kt");
        }

        @Test
        @TestMetadata("safeCallsWithImplicitInvoke.kt")
        public void testSafeCallsWithImplicitInvoke() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/safeCallsWithImplicitInvoke.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/simple.kt");
        }

        @Test
        @TestMetadata("threeReceivers.kt")
        public void testThreeReceivers() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/threeReceivers.kt");
        }

        @Test
        @TestMetadata("threeReceiversCorrect.kt")
        public void testThreeReceiversCorrect() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/threeReceiversCorrect.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/operators")
      @TestDataPath("$PROJECT_ROOT")
      public class Operators {
        @Test
        public void testAllFilesPresentInOperators() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/operators"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("plus.kt")
        public void testPlus() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plus.kt");
        }

        @Test
        @TestMetadata("plusAndPlusAssign.kt")
        public void testPlusAndPlusAssign() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plusAndPlusAssign.kt");
        }

        @Test
        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() {
          runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plusAssign.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extraCheckers")
    @TestDataPath("$PROJECT_ROOT")
    public class ExtraCheckers {
      @Test
      public void testAllFilesPresentInExtraCheckers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extraCheckers"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("ArrayEqualityCanBeReplacedWithEquals.kt")
      public void testArrayEqualityCanBeReplacedWithEquals() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/ArrayEqualityCanBeReplacedWithEquals.kt");
      }

      @Test
      @TestMetadata("CanBeValChecker.kt")
      public void testCanBeValChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/CanBeValChecker.kt");
      }

      @Test
      @TestMetadata("kt69190.kt")
      public void testKt69190() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/kt69190.kt");
      }

      @Test
      @TestMetadata("kt72164.kt")
      public void testKt72164() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/kt72164.kt");
      }

      @Test
      @TestMetadata("kt72537.kt")
      public void testKt72537() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/kt72537.kt");
      }

      @Test
      @TestMetadata("RedundantExplicitTypeChecker.kt")
      public void testRedundantExplicitTypeChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantExplicitTypeChecker.kt");
      }

      @Test
      @TestMetadata("RedundantModalityModifierChecker.kt")
      public void testRedundantModalityModifierChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantModalityModifierChecker.kt");
      }

      @Test
      @TestMetadata("RedundantReturnUnitTypeChecker.kt")
      public void testRedundantReturnUnitTypeChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantReturnUnitTypeChecker.kt");
      }

      @Test
      @TestMetadata("RedundantSetterParameterTypeChecker.kt")
      public void testRedundantSetterParameterTypeChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantSetterParameterTypeChecker.kt");
      }

      @Test
      @TestMetadata("RedundantSingleExpressionStringTemplateChecker.kt")
      public void testRedundantSingleExpressionStringTemplateChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantSingleExpressionStringTemplateChecker.kt");
      }

      @Test
      @TestMetadata("RedundantVisibilityDueToOverride.kt")
      public void testRedundantVisibilityDueToOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantVisibilityDueToOverride.kt");
      }

      @Test
      @TestMetadata("RedundantVisibilityModifierChecker.kt")
      public void testRedundantVisibilityModifierChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantVisibilityModifierChecker.kt");
      }

      @Test
      @TestMetadata("RedundantVisibilityModifierCheckerForInnerComponents.kt")
      public void testRedundantVisibilityModifierCheckerForInnerComponents() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantVisibilityModifierCheckerForInnerComponents.kt");
      }

      @Test
      @TestMetadata("RedundantVisibilityModifierCheckerWithExplicitApiMode.kt")
      public void testRedundantVisibilityModifierCheckerWithExplicitApiMode() {
        runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantVisibilityModifierCheckerWithExplicitApiMode.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment")
      @TestDataPath("$PROJECT_ROOT")
      public class CanBeReplacedWithOperatorAssignment {
        @Test
        public void testAllFilesPresentInCanBeReplacedWithOperatorAssignment() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("BasicTest.kt")
        public void testBasicTest() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/BasicTest.kt");
        }

        @Test
        @TestMetadata("ComplexExpression.kt")
        public void testComplexExpression() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/ComplexExpression.kt");
        }

        @Test
        @TestMetadata("flexibleTypeBug.kt")
        public void testFlexibleTypeBug() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/flexibleTypeBug.kt");
        }

        @Test
        @TestMetadata("illegalMultipleOperators.kt")
        public void testIllegalMultipleOperators() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/illegalMultipleOperators.kt");
        }

        @Test
        @TestMetadata("illegalMultipleOperatorsMiddle.kt")
        public void testIllegalMultipleOperatorsMiddle() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/illegalMultipleOperatorsMiddle.kt");
        }

        @Test
        @TestMetadata("invalidSubtraction.kt")
        public void testInvalidSubtraction() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/invalidSubtraction.kt");
        }

        @Test
        @TestMetadata("list.kt")
        public void testList() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/list.kt");
        }

        @Test
        @TestMetadata("logicOperators.kt")
        public void testLogicOperators() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/logicOperators.kt");
        }

        @Test
        @TestMetadata("multipleOperators.kt")
        public void testMultipleOperators() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/multipleOperators.kt");
        }

        @Test
        @TestMetadata("multipleOperatorsRightSideRepeat.kt")
        public void testMultipleOperatorsRightSideRepeat() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/multipleOperatorsRightSideRepeat.kt");
        }

        @Test
        @TestMetadata("mutableList.kt")
        public void testMutableList() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/mutableList.kt");
        }

        @Test
        @TestMetadata("nonCommutativeRepeat.kt")
        public void testNonCommutativeRepeat() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/nonCommutativeRepeat.kt");
        }

        @Test
        @TestMetadata("nonRepeatingAssignment.kt")
        public void testNonRepeatingAssignment() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/nonRepeatingAssignment.kt");
        }

        @Test
        @TestMetadata("OperatorAssignment.kt")
        public void testOperatorAssignment() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/OperatorAssignment.kt");
        }

        @Test
        @TestMetadata("plusAssignConflict.kt")
        public void testPlusAssignConflict() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/plusAssignConflict.kt");
        }

        @Test
        @TestMetadata("rightSideRepeat.kt")
        public void testRightSideRepeat() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/rightSideRepeat.kt");
        }

        @Test
        @TestMetadata("simpleAssign.kt")
        public void testSimpleAssign() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/simpleAssign.kt");
        }

        @Test
        @TestMetadata("validAddition.kt")
        public void testValidAddition() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/validAddition.kt");
        }

        @Test
        @TestMetadata("validSubtraction.kt")
        public void testValidSubtraction() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/canBeReplacedWithOperatorAssignment/validSubtraction.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extraCheckers/emptyRangeChecker")
      @TestDataPath("$PROJECT_ROOT")
      public class EmptyRangeChecker {
        @Test
        public void testAllFilesPresentInEmptyRangeChecker() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extraCheckers/emptyRangeChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("NoWarning.kt")
        public void testNoWarning() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/emptyRangeChecker/NoWarning.kt");
        }

        @Test
        @TestMetadata("Warning.kt")
        public void testWarning() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/emptyRangeChecker/Warning.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod")
      @TestDataPath("$PROJECT_ROOT")
      public class RedundantCallOfConversionMethod {
        @Test
        public void testAllFilesPresentInRedundantCallOfConversionMethod() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("booleanToInt.kt")
        public void testBooleanToInt() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/booleanToInt.kt");
        }

        @Test
        @TestMetadata("byte.kt")
        public void testByte() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/byte.kt");
        }

        @Test
        @TestMetadata("char.kt")
        public void testChar() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/char.kt");
        }

        @Test
        @TestMetadata("double.kt")
        public void testDouble() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/double.kt");
        }

        @Test
        @TestMetadata("float.kt")
        public void testFloat() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/float.kt");
        }

        @Test
        @TestMetadata("int.kt")
        public void testInt() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/int.kt");
        }

        @Test
        @TestMetadata("long.kt")
        public void testLong() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/long.kt");
        }

        @Test
        @TestMetadata("nullable.kt")
        public void testNullable() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/nullable.kt");
        }

        @Test
        @TestMetadata("nullable2.kt")
        public void testNullable2() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/nullable2.kt");
        }

        @Test
        @TestMetadata("safeString.kt")
        public void testSafeString() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/safeString.kt");
        }

        @Test
        @TestMetadata("safeString2.kt")
        public void testSafeString2() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/safeString2.kt");
        }

        @Test
        @TestMetadata("short.kt")
        public void testShort() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/short.kt");
        }

        @Test
        @TestMetadata("string.kt")
        public void testString() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/string.kt");
        }

        @Test
        @TestMetadata("StringTemplate.kt")
        public void testStringTemplate() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/StringTemplate.kt");
        }

        @Test
        @TestMetadata("toOtherType.kt")
        public void testToOtherType() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/toOtherType.kt");
        }

        @Test
        @TestMetadata("uByte.kt")
        public void testUByte() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/uByte.kt");
        }

        @Test
        @TestMetadata("uInt.kt")
        public void testUInt() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/uInt.kt");
        }

        @Test
        @TestMetadata("uLong.kt")
        public void testULong() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/uLong.kt");
        }

        @Test
        @TestMetadata("uShort.kt")
        public void testUShort() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/uShort.kt");
        }

        @Test
        @TestMetadata("variable.kt")
        public void testVariable() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/RedundantCallOfConversionMethod/variable.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused")
      @TestDataPath("$PROJECT_ROOT")
      public class Unused {
        @Test
        public void testAllFilesPresentInUnused() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("classProperty.kt")
        public void testClassProperty() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/classProperty.kt");
        }

        @Test
        @TestMetadata("invoke.kt")
        public void testInvoke() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invoke.kt");
        }

        @Test
        @TestMetadata("invokeCustomTypeExt.kt")
        public void testInvokeCustomTypeExt() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeCustomTypeExt.kt");
        }

        @Test
        @TestMetadata("invokeCustomTypeMember.kt")
        public void testInvokeCustomTypeMember() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeCustomTypeMember.kt");
        }

        @Test
        @TestMetadata("invokeKFunction.kt")
        public void testInvokeKFunction() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeKFunction.kt");
        }

        @Test
        @TestMetadata("invokeKFunctionFromMethodReference.kt")
        public void testInvokeKFunctionFromMethodReference() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeKFunctionFromMethodReference.kt");
        }

        @Test
        @TestMetadata("invokeKSuspendFunction.kt")
        public void testInvokeKSuspendFunction() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeKSuspendFunction.kt");
        }

        @Test
        @TestMetadata("invokeOverload1.kt")
        public void testInvokeOverload1() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeOverload1.kt");
        }

        @Test
        @TestMetadata("invokeOverload2.kt")
        public void testInvokeOverload2() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeOverload2.kt");
        }

        @Test
        @TestMetadata("invokeSuspend.kt")
        public void testInvokeSuspend() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeSuspend.kt");
        }

        @Test
        @TestMetadata("invokeWithExtensionReceiver.kt")
        public void testInvokeWithExtensionReceiver() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/invokeWithExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("lambda.kt")
        public void testLambda() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/lambda.kt");
        }

        @Test
        @TestMetadata("localVariable.kt")
        public void testLocalVariable() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/localVariable.kt");
        }

        @Test
        @TestMetadata("localVariableInSecondaryConstructor.kt")
        public void testLocalVariableInSecondaryConstructor() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/localVariableInSecondaryConstructor.kt");
        }

        @Test
        @TestMetadata("manyLocalVariables.kt")
        public void testManyLocalVariables() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/manyLocalVariables.kt");
        }

        @Test
        @TestMetadata("usedInAnnotationArguments.kt")
        public void testUsedInAnnotationArguments() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/usedInAnnotationArguments.kt");
        }

        @Test
        @TestMetadata("valueIsNeverRead.kt")
        public void testValueIsNeverRead() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/unused/valueIsNeverRead.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker")
      @TestDataPath("$PROJECT_ROOT")
      public class UselessCallOnNotNullChecker {
        @Test
        public void testAllFilesPresentInUselessCallOnNotNullChecker() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("Basic.kt")
        public void testBasic() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/Basic.kt");
        }

        @Test
        @TestMetadata("isNullOrEmptyFromJava.kt")
        public void testIsNullOrEmptyFromJava() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/isNullOrEmptyFromJava.kt");
        }

        @Test
        @TestMetadata("NotNullType.kt")
        public void testNotNullType() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/NotNullType.kt");
        }

        @Test
        @TestMetadata("NotNullTypeChain.kt")
        public void testNotNullTypeChain() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/NotNullTypeChain.kt");
        }

        @Test
        @TestMetadata("NullOrBlankSafe.kt")
        public void testNullOrBlankSafe() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/NullOrBlankSafe.kt");
        }

        @Test
        @TestMetadata("NullOrEmpty.kt")
        public void testNullOrEmpty() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/NullOrEmpty.kt");
        }

        @Test
        @TestMetadata("NullOrEmptyFake.kt")
        public void testNullOrEmptyFake() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/NullOrEmptyFake.kt");
        }

        @Test
        @TestMetadata("NullOrEmptySafe.kt")
        public void testNullOrEmptySafe() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/NullOrEmptySafe.kt");
        }

        @Test
        @TestMetadata("OrEmptyFake.kt")
        public void testOrEmptyFake() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/OrEmptyFake.kt");
        }

        @Test
        @TestMetadata("SafeCall.kt")
        public void testSafeCall() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/SafeCall.kt");
        }

        @Test
        @TestMetadata("Sequence.kt")
        public void testSequence() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/Sequence.kt");
        }

        @Test
        @TestMetadata("String.kt")
        public void testString() {
          runTest("compiler/fir/analysis-tests/testData/resolve/extraCheckers/UselessCallOnNotNullChecker/String.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/fromBuilder")
    @TestDataPath("$PROJECT_ROOT")
    public class FromBuilder {
      @Test
      public void testAllFilesPresentInFromBuilder() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/fromBuilder"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("complexTypes.kt")
      public void testComplexTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/complexTypes.kt");
      }

      @Test
      @TestMetadata("enums.kt")
      public void testEnums() {
        runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/enums.kt");
      }

      @Test
      @TestMetadata("noPrimaryConstructor.kt")
      public void testNoPrimaryConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/noPrimaryConstructor.kt");
      }

      @Test
      @TestMetadata("simpleClass.kt")
      public void testSimpleClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/simpleClass.kt");
      }

      @Test
      @TestMetadata("typeParameters.kt")
      public void testTypeParameters() {
        runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/typeParameters.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inference")
    @TestDataPath("$PROJECT_ROOT")
    public class Inference {
      @Test
      public void testAllFilesPresentInInference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("callableReferenceOnInstance.kt")
      public void testCallableReferenceOnInstance() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferenceOnInstance.kt");
      }

      @Test
      @TestMetadata("callableReferenceToLocalClass.kt")
      public void testCallableReferenceToLocalClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferenceToLocalClass.kt");
      }

      @Test
      @TestMetadata("callableReferencesAndDefaultParameters.kt")
      public void testCallableReferencesAndDefaultParameters() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferencesAndDefaultParameters.kt");
      }

      @Test
      @TestMetadata("capturedTypeForJavaTypeParameter.kt")
      public void testCapturedTypeForJavaTypeParameter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/capturedTypeForJavaTypeParameter.kt");
      }

      @Test
      @TestMetadata("coercionToUnitWithEarlyReturn.kt")
      public void testCoercionToUnitWithEarlyReturn() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/coercionToUnitWithEarlyReturn.kt");
      }

      @Test
      @TestMetadata("definitelyNotNullIntersectionType.kt")
      public void testDefinitelyNotNullIntersectionType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/definitelyNotNullIntersectionType.kt");
      }

      @Test
      @TestMetadata("dnnThrowJavaCall.kt")
      public void testDnnThrowJavaCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/dnnThrowJavaCall.kt");
      }

      @Test
      @TestMetadata("elvisAndUnit.kt")
      public void testElvisAndUnit() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/elvisAndUnit.kt");
      }

      @Test
      @TestMetadata("equals.kt")
      public void testEquals() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/equals.kt");
      }

      @Test
      @TestMetadata("extensionCallableReferences.kt")
      public void testExtensionCallableReferences() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/extensionCallableReferences.kt");
      }

      @Test
      @TestMetadata("flexibleTypeAtRightSideOfElvis.kt")
      public void testFlexibleTypeAtRightSideOfElvis() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/flexibleTypeAtRightSideOfElvis.kt");
      }

      @Test
      @TestMetadata("integerLiteralAsComparable.kt")
      public void testIntegerLiteralAsComparable() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/integerLiteralAsComparable.kt");
      }

      @Test
      @TestMetadata("intersectionTypesInConstraints.kt")
      public void testIntersectionTypesInConstraints() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/intersectionTypesInConstraints.kt");
      }

      @Test
      @TestMetadata("javaCollector.kt")
      public void testJavaCollector() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/javaCollector.kt");
      }

      @Test
      @TestMetadata("kt40131.kt")
      public void testKt40131() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt40131.kt");
      }

      @Test
      @TestMetadata("kt41989.kt")
      public void testKt41989() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt41989.kt");
      }

      @Test
      @TestMetadata("kt53494.kt")
      public void testKt53494() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt53494.kt");
      }

      @Test
      @TestMetadata("kt54990.kt")
      public void testKt54990() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt54990.kt");
      }

      @Test
      @TestMetadata("lambdaAsReturnStatementOfLambda.kt")
      public void testLambdaAsReturnStatementOfLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaAsReturnStatementOfLambda.kt");
      }

      @Test
      @TestMetadata("lambdaInElvis.kt")
      public void testLambdaInElvis() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaInElvis.kt");
      }

      @Test
      @TestMetadata("lambdaWithoutExpectedType.kt")
      public void testLambdaWithoutExpectedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaWithoutExpectedType.kt");
      }

      @Test
      @TestMetadata("lambdasReturns.kt")
      public void testLambdasReturns() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdasReturns.kt");
      }

      @Test
      @TestMetadata("nestedExtensionFunctionType.kt")
      public void testNestedExtensionFunctionType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/nestedExtensionFunctionType.kt");
      }

      @Test
      @TestMetadata("nestedLambdas.kt")
      public void testNestedLambdas() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/nestedLambdas.kt");
      }

      @Test
      @TestMetadata("noEnhancementOnFinalStaticConstFields.kt")
      public void testNoEnhancementOnFinalStaticConstFields() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/noEnhancementOnFinalStaticConstFields.kt");
      }

      @Test
      @TestMetadata("nullableIntegerLiteralType.kt")
      public void testNullableIntegerLiteralType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/nullableIntegerLiteralType.kt");
      }

      @Test
      @TestMetadata("onlyInputTypesCapturedTypeWithRecursiveBounds.kt")
      public void testOnlyInputTypesCapturedTypeWithRecursiveBounds() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/onlyInputTypesCapturedTypeWithRecursiveBounds.kt");
      }

      @Test
      @TestMetadata("onlyInputTypesCapturedTypeWithRecursiveBoundsAfter.kt")
      public void testOnlyInputTypesCapturedTypeWithRecursiveBoundsAfter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/onlyInputTypesCapturedTypeWithRecursiveBoundsAfter.kt");
      }

      @Test
      @TestMetadata("overloadResolutionByLambdaArgumentType.kt")
      public void testOverloadResolutionByLambdaArgumentType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/overloadResolutionByLambdaArgumentType.kt");
      }

      @Test
      @TestMetadata("postfixPrefixIncrementDecrement.kt")
      public void testPostfixPrefixIncrementDecrement() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/postfixPrefixIncrementDecrement.kt");
      }

      @Test
      @TestMetadata("receiverWithCapturedType.kt")
      public void testReceiverWithCapturedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/receiverWithCapturedType.kt");
      }

      @Test
      @TestMetadata("recursiveSelfTypes.kt")
      public void testRecursiveSelfTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/recursiveSelfTypes.kt");
      }

      @Test
      @TestMetadata("selfTypeFromJava.kt")
      public void testSelfTypeFromJava() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/selfTypeFromJava.kt");
      }

      @Test
      @TestMetadata("simpleCapturedTypes.kt")
      public void testSimpleCapturedTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/simpleCapturedTypes.kt");
      }

      @Test
      @TestMetadata("typeDepthForTypeAlias.kt")
      public void testTypeDepthForTypeAlias() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/typeDepthForTypeAlias.kt");
      }

      @Test
      @TestMetadata("unitUpperBound.kt")
      public void testUnitUpperBound() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inference/unitUpperBound.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inference/forks")
      @TestDataPath("$PROJECT_ROOT")
      public class Forks {
        @Test
        public void testAllFilesPresentInForks() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inference/forks"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("failForkPointWhenNoneOfThemSuccessfulFeatureDisabled.kt")
        public void testFailForkPointWhenNoneOfThemSuccessfulFeatureDisabled() {
          runTest("compiler/fir/analysis-tests/testData/resolve/inference/forks/failForkPointWhenNoneOfThemSuccessfulFeatureDisabled.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inference/incorporation")
      @TestDataPath("$PROJECT_ROOT")
      public class Incorporation {
        @Test
        public void testAllFilesPresentInIncorporation() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inference/incorporation"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("insideOtherConstraintsWithFlexibleTypes.kt")
        public void testInsideOtherConstraintsWithFlexibleTypes() {
          runTest("compiler/fir/analysis-tests/testData/resolve/inference/incorporation/insideOtherConstraintsWithFlexibleTypes.kt");
        }

        @Test
        @TestMetadata("insideOtherConstraintsWithFlexibleTypesOriginal.kt")
        public void testInsideOtherConstraintsWithFlexibleTypesOriginal() {
          runTest("compiler/fir/analysis-tests/testData/resolve/inference/incorporation/insideOtherConstraintsWithFlexibleTypesOriginal.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inference/pcla")
      @TestDataPath("$PROJECT_ROOT")
      public class Pcla {
        @Test
        public void testAllFilesPresentInPcla() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inference/pcla"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("doubleSquareBracketsInBuilderArgument.kt")
        public void testDoubleSquareBracketsInBuilderArgument() {
          runTest("compiler/fir/analysis-tests/testData/resolve/inference/pcla/doubleSquareBracketsInBuilderArgument.kt");
        }

        @Test
        @TestMetadata("ifInBuildMap.kt")
        public void testIfInBuildMap() {
          runTest("compiler/fir/analysis-tests/testData/resolve/inference/pcla/ifInBuildMap.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inlineClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("inlineClassConstructor.kt")
      public void testInlineClassConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassConstructor.kt");
      }

      @Test
      @TestMetadata("inlineClassDeclaration.kt")
      public void testInlineClassDeclaration() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassDeclaration.kt");
      }

      @Test
      @TestMetadata("inlineClassMembers.kt")
      public void testInlineClassMembers() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassMembers.kt");
      }

      @Test
      @TestMetadata("reservedMethodsInInterfaces.kt")
      public void testReservedMethodsInInterfaces() {
        runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/reservedMethodsInInterfaces.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InnerClasses {
      @Test
      public void testAllFilesPresentInInnerClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/innerClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("inner.kt")
      public void testInner() {
        runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/inner.kt");
      }

      @Test
      @TestMetadata("innerInsideNestedSealed.kt")
      public void testInnerInsideNestedSealed() {
        runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/innerInsideNestedSealed.kt");
      }

      @Test
      @TestMetadata("innerTypeFromSuperClassInBody.kt")
      public void testInnerTypeFromSuperClassInBody() {
        runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/innerTypeFromSuperClassInBody.kt");
      }

      @Test
      @TestMetadata("innerTypes.kt")
      public void testInnerTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/innerTypes.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/simple.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/localClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalClasses {
      @Test
      public void testAllFilesPresentInLocalClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/localClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("anonObject.kt")
      public void testAnonObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/anonObject.kt");
      }

      @Test
      @TestMetadata("anonymousInAnonymous.kt")
      public void testAnonymousInAnonymous() {
        runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/anonymousInAnonymous.kt");
      }

      @Test
      @TestMetadata("implicitInAnonymous.kt")
      public void testImplicitInAnonymous() {
        runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/implicitInAnonymous.kt");
      }

      @Test
      @TestMetadata("implicitInLocalClasses.kt")
      public void testImplicitInLocalClasses() {
        runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/implicitInLocalClasses.kt");
      }

      @Test
      @TestMetadata("lambdaWithAnonymousObject.kt")
      public void testLambdaWithAnonymousObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/lambdaWithAnonymousObject.kt");
      }

      @Test
      @TestMetadata("overrideInLocal.kt")
      public void testOverrideInLocal() {
        runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/overrideInLocal.kt");
      }

      @Test
      @TestMetadata("typesFromSuperClasses.kt")
      public void testTypesFromSuperClasses() {
        runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/typesFromSuperClasses.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/multifile")
    @TestDataPath("$PROJECT_ROOT")
    public class Multifile {
      @Test
      public void testAllFilesPresentInMultifile() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/multifile"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("Annotations.kt")
      public void testAnnotations() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/Annotations.kt");
      }

      @Test
      @TestMetadata("ByteArray.kt")
      public void testByteArray() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/ByteArray.kt");
      }

      @Test
      @TestMetadata("importFromObject.kt")
      public void testImportFromObject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/importFromObject.kt");
      }

      @Test
      @TestMetadata("NestedSuperType.kt")
      public void testNestedSuperType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/NestedSuperType.kt");
      }

      @Test
      @TestMetadata("sealedStarImport.kt")
      public void testSealedStarImport() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/sealedStarImport.kt");
      }

      @Test
      @TestMetadata("simpleAliasedImport.kt")
      public void testSimpleAliasedImport() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleAliasedImport.kt");
      }

      @Test
      @TestMetadata("simpleImport.kt")
      public void testSimpleImport() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImport.kt");
      }

      @Test
      @TestMetadata("simpleImportNested.kt")
      public void testSimpleImportNested() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImportNested.kt");
      }

      @Test
      @TestMetadata("simpleImportOuter.kt")
      public void testSimpleImportOuter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImportOuter.kt");
      }

      @Test
      @TestMetadata("simpleStarImport.kt")
      public void testSimpleStarImport() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleStarImport.kt");
      }

      @Test
      @TestMetadata("TypeAliasExpansion.kt")
      public void testTypeAliasExpansion() {
        runTest("compiler/fir/analysis-tests/testData/resolve/multifile/TypeAliasExpansion.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases")
    @TestDataPath("$PROJECT_ROOT")
    public class NestedTypeAliases {
      @Test
      public void testAllFilesPresentInNestedTypeAliases() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("deepInnerRHS.kt")
      public void testDeepInnerRHS() {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases/deepInnerRHS.kt");
      }

      @Test
      @TestMetadata("innerRHS.kt")
      public void testInnerRHS() {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases/innerRHS.kt");
      }

      @Test
      @TestMetadata("innerRHSandTypeArguments.kt")
      public void testInnerRHSandTypeArguments() {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases/innerRHSandTypeArguments.kt");
      }

      @Test
      @TestMetadata("kmp.kt")
      public void testKmp() {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases/kmp.kt");
      }

      @Test
      @TestMetadata("local.kt")
      public void testLocal() {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases/local.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases/simple.kt");
      }

      @Test
      @TestMetadata("visibility.kt")
      public void testVisibility() {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedTypeAliases/visibility.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/overrides")
    @TestDataPath("$PROJECT_ROOT")
    public class Overrides {
      @Test
      public void testAllFilesPresentInOverrides() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/overrides"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("generics.kt")
      public void testGenerics() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/generics.kt");
      }

      @Test
      @TestMetadata("protobufExt.kt")
      public void testProtobufExt() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/protobufExt.kt");
      }

      @Test
      @TestMetadata("sameValueParametersDifferentReceiver.kt")
      public void testSameValueParametersDifferentReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/sameValueParametersDifferentReceiver.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simple.kt");
      }

      @Test
      @TestMetadata("simpleFakeOverride.kt")
      public void testSimpleFakeOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simpleFakeOverride.kt");
      }

      @Test
      @TestMetadata("simpleMostSpecific.kt")
      public void testSimpleMostSpecific() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simpleMostSpecific.kt");
      }

      @Test
      @TestMetadata("supertypeGenerics.kt")
      public void testSupertypeGenerics() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/supertypeGenerics.kt");
      }

      @Test
      @TestMetadata("supertypeGenericsComplex.kt")
      public void testSupertypeGenericsComplex() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/supertypeGenericsComplex.kt");
      }

      @Test
      @TestMetadata("three.kt")
      public void testThree() {
        runTest("compiler/fir/analysis-tests/testData/resolve/overrides/three.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/problems")
    @TestDataPath("$PROJECT_ROOT")
    public class Problems {
      @Test
      public void testAllFilesPresentInProblems() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("classLiteralWithExclExcl.kt")
      public void testClassLiteralWithExclExcl() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/classLiteralWithExclExcl.kt");
      }

      @Test
      @TestMetadata("compilerPhase.kt")
      public void testCompilerPhase() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/compilerPhase.kt");
      }

      @Test
      @TestMetadata("complexLambdaWithTypeVariableAsExpectedType.kt")
      public void testComplexLambdaWithTypeVariableAsExpectedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/complexLambdaWithTypeVariableAsExpectedType.kt");
      }

      @Test
      @TestMetadata("defaultParametersFromDifferentScopes.kt")
      public void testDefaultParametersFromDifferentScopes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/defaultParametersFromDifferentScopes.kt");
      }

      @Test
      @TestMetadata("definitelyNotNullAndOriginalType.kt")
      public void testDefinitelyNotNullAndOriginalType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/definitelyNotNullAndOriginalType.kt");
      }

      @Test
      @TestMetadata("doubleGenericDiamond.kt")
      public void testDoubleGenericDiamond() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/doubleGenericDiamond.kt");
      }

      @Test
      @TestMetadata("emptySelectorInQualifiedExpression.kt")
      public void testEmptySelectorInQualifiedExpression() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/emptySelectorInQualifiedExpression.kt");
      }

      @Test
      @TestMetadata("enumEntryFieldShadow.kt")
      public void testEnumEntryFieldShadow() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/enumEntryFieldShadow.kt");
      }

      @Test
      @TestMetadata("expectConstructor.kt")
      public void testExpectConstructor() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/expectConstructor.kt");
      }

      @Test
      @TestMetadata("fakeTypeMismatchOnExtensionReference.kt")
      public void testFakeTypeMismatchOnExtensionReference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/fakeTypeMismatchOnExtensionReference.kt");
      }

      @Test
      @TestMetadata("falseIntersection.kt")
      public void testFalseIntersection() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/falseIntersection.kt");
      }

      @Test
      @TestMetadata("flexibleTypeVarAgainstNull.kt")
      public void testFlexibleTypeVarAgainstNull() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/flexibleTypeVarAgainstNull.kt");
      }

      @Test
      @TestMetadata("inaccessibleJavaGetter.kt")
      public void testInaccessibleJavaGetter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/inaccessibleJavaGetter.kt");
      }

      @Test
      @TestMetadata("incompleteUserType.kt")
      public void testIncompleteUserType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/incompleteUserType.kt");
      }

      @Test
      @TestMetadata("incompleteUserTypeWithUnresovledTypeArgument.kt")
      public void testIncompleteUserTypeWithUnresovledTypeArgument() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/incompleteUserTypeWithUnresovledTypeArgument.kt");
      }

      @Test
      @TestMetadata("incompleteWhen.kt")
      public void testIncompleteWhen() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/incompleteWhen.kt");
      }

      @Test
      @TestMetadata("incorrectGenericLambdaProperty.kt")
      public void testIncorrectGenericLambdaProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/incorrectGenericLambdaProperty.kt");
      }

      @Test
      @TestMetadata("innerClassHierarchy.kt")
      public void testInnerClassHierarchy() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/innerClassHierarchy.kt");
      }

      @Test
      @TestMetadata("invalidCode.kt")
      public void testInvalidCode() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/invalidCode.kt");
      }

      @Test
      @TestMetadata("javaClassWithEmptyAnnotationName.kt")
      public void testJavaClassWithEmptyAnnotationName() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/javaClassWithEmptyAnnotationName.kt");
      }

      @Test
      @TestMetadata("javaQualifier.kt")
      public void testJavaQualifier() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/javaQualifier.kt");
      }

      @Test
      @TestMetadata("kt42346.kt")
      public void testKt42346() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/kt42346.kt");
      }

      @Test
      @TestMetadata("multipleJavaClassesInOneFile.kt")
      public void testMultipleJavaClassesInOneFile() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/multipleJavaClassesInOneFile.kt");
      }

      @Test
      @TestMetadata("objectDerivedFromInnerClass.kt")
      public void testObjectDerivedFromInnerClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/objectDerivedFromInnerClass.kt");
      }

      @Test
      @TestMetadata("primaryConstructorParameterWithoutReturnType.kt")
      public void testPrimaryConstructorParameterWithoutReturnType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/primaryConstructorParameterWithoutReturnType.kt");
      }

      @Test
      @TestMetadata("questionableSmartCast.kt")
      public void testQuestionableSmartCast() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/questionableSmartCast.kt");
      }

      @Test
      @TestMetadata("recursiveNamedAnnotation.kt")
      public void testRecursiveNamedAnnotation() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/recursiveNamedAnnotation.kt");
      }

      @Test
      @TestMetadata("safeCallInvoke.kt")
      public void testSafeCallInvoke() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/safeCallInvoke.kt");
      }

      @Test
      @TestMetadata("secondaryConstructorCfg.kt")
      public void testSecondaryConstructorCfg() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/secondaryConstructorCfg.kt");
      }

      @Test
      @TestMetadata("symbolsAndDescriptors.kt")
      public void testSymbolsAndDescriptors() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/symbolsAndDescriptors.kt");
      }

      @Test
      @TestMetadata("transform.kt")
      public void testTransform() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/transform.kt");
      }

      @Test
      @TestMetadata("typeArgumentsOnThis.kt")
      public void testTypeArgumentsOnThis() {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems/typeArgumentsOnThis.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/properties")
    @TestDataPath("$PROJECT_ROOT")
    public class Properties {
      @Test
      public void testAllFilesPresentInProperties() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/properties"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("assignToStarProjectedType.kt")
      public void testAssignToStarProjectedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/assignToStarProjectedType.kt");
      }

      @Test
      @TestMetadata("getterWithEarlyReturn.kt")
      public void testGetterWithEarlyReturn() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/getterWithEarlyReturn.kt");
      }

      @Test
      @TestMetadata("javaAccessorConversion.kt")
      public void testJavaAccessorConversion() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/javaAccessorConversion.kt");
      }

      @Test
      @TestMetadata("javaAccessorsComplex.kt")
      public void testJavaAccessorsComplex() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/javaAccessorsComplex.kt");
      }

      @Test
      @TestMetadata("kotlinOverridesJavaComplex.kt")
      public void testKotlinOverridesJavaComplex() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/kotlinOverridesJavaComplex.kt");
      }

      @Test
      @TestMetadata("lazyValWithElvisToNothingInside.kt")
      public void testLazyValWithElvisToNothingInside() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/lazyValWithElvisToNothingInside.kt");
      }

      @Test
      @TestMetadata("noBackingFieldForExtension.kt")
      public void testNoBackingFieldForExtension() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/noBackingFieldForExtension.kt");
      }

      @Test
      @TestMetadata("noBackingFieldInProperty.kt")
      public void testNoBackingFieldInProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/noBackingFieldInProperty.kt");
      }

      @Test
      @TestMetadata("syntheticPropertiesForJavaAnnotations.kt")
      public void testSyntheticPropertiesForJavaAnnotations() {
        runTest("compiler/fir/analysis-tests/testData/resolve/properties/syntheticPropertiesForJavaAnnotations.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/propertyVsField")
    @TestDataPath("$PROJECT_ROOT")
    public class PropertyVsField {
      @Test
      public void testAllFilesPresentInPropertyVsField() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/propertyVsField"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("fieldPropertyShadow.kt")
      public void testFieldPropertyShadow() {
        runTest("compiler/fir/analysis-tests/testData/resolve/propertyVsField/fieldPropertyShadow.kt");
      }

      @Test
      @TestMetadata("javaFieldAndKotlinPropertyReferenceFromInner.kt")
      public void testJavaFieldAndKotlinPropertyReferenceFromInner() {
        runTest("compiler/fir/analysis-tests/testData/resolve/propertyVsField/javaFieldAndKotlinPropertyReferenceFromInner.kt");
      }

      @Test
      @TestMetadata("propertyAndTwoFields.kt")
      public void testPropertyAndTwoFields() {
        runTest("compiler/fir/analysis-tests/testData/resolve/propertyVsField/propertyAndTwoFields.kt");
      }

      @Test
      @TestMetadata("propertyFieldShadow.kt")
      public void testPropertyFieldShadow() {
        runTest("compiler/fir/analysis-tests/testData/resolve/propertyVsField/propertyFieldShadow.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/references")
    @TestDataPath("$PROJECT_ROOT")
    public class References {
      @Test
      public void testAllFilesPresentInReferences() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/references"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("ambigousParenthesizedReference.kt")
      public void testAmbigousParenthesizedReference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/ambigousParenthesizedReference.kt");
      }

      @Test
      @TestMetadata("incorrectReferenceOnInnerClassMember.kt")
      public void testIncorrectReferenceOnInnerClassMember() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/incorrectReferenceOnInnerClassMember.kt");
      }

      @Test
      @TestMetadata("integerLiteralInLhs.kt")
      public void testIntegerLiteralInLhs() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/integerLiteralInLhs.kt");
      }

      @Test
      @TestMetadata("leakedImplicitType.kt")
      public void testLeakedImplicitType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/leakedImplicitType.kt");
      }

      @Test
      @TestMetadata("mutablePropertyGenericButNotCapturedType.kt")
      public void testMutablePropertyGenericButNotCapturedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/mutablePropertyGenericButNotCapturedType.kt");
      }

      @Test
      @TestMetadata("mutablePropertyWithCapturedType.kt")
      public void testMutablePropertyWithCapturedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/mutablePropertyWithCapturedType.kt");
      }

      @Test
      @TestMetadata("referenceToExtension.kt")
      public void testReferenceToExtension() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/referenceToExtension.kt");
      }

      @Test
      @TestMetadata("referenceToField.kt")
      public void testReferenceToField() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/referenceToField.kt");
      }

      @Test
      @TestMetadata("referenceToSyntheticJavaPropertyWithProjection.kt")
      public void testReferenceToSyntheticJavaPropertyWithProjection() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/referenceToSyntheticJavaPropertyWithProjection.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/simple.kt");
      }

      @Test
      @TestMetadata("superMember.kt")
      public void testSuperMember() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/superMember.kt");
      }

      @Test
      @TestMetadata("unresovledReferenceInFinally.kt")
      public void testUnresovledReferenceInFinally() {
        runTest("compiler/fir/analysis-tests/testData/resolve/references/unresovledReferenceInFinally.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/samConstructors")
    @TestDataPath("$PROJECT_ROOT")
    public class SamConstructors {
      @Test
      public void testAllFilesPresentInSamConstructors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/samConstructors"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("funInterfaceConstructorReference.kt")
      public void testFunInterfaceConstructorReference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/funInterfaceConstructorReference.kt");
      }

      @Test
      @TestMetadata("genericSam.kt")
      public void testGenericSam() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/genericSam.kt");
      }

      @Test
      @TestMetadata("genericSamInferenceFromExpectType.kt")
      public void testGenericSamInferenceFromExpectType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/genericSamInferenceFromExpectType.kt");
      }

      @Test
      @TestMetadata("kotlinSam.kt")
      public void testKotlinSam() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/kotlinSam.kt");
      }

      @Test
      @TestMetadata("realConstructorFunction.kt")
      public void testRealConstructorFunction() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/realConstructorFunction.kt");
      }

      @Test
      @TestMetadata("runnable.kt")
      public void testRunnable() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/runnable.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/simple.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/samConversions")
    @TestDataPath("$PROJECT_ROOT")
    public class SamConversions {
      @Test
      public void testAllFilesPresentInSamConversions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/samConversions"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("genericSam.kt")
      public void testGenericSam() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/genericSam.kt");
      }

      @Test
      @TestMetadata("kotlinSam.kt")
      public void testKotlinSam() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/kotlinSam.kt");
      }

      @Test
      @TestMetadata("notSamBecauseOfSupertype.kt")
      public void testNotSamBecauseOfSupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/notSamBecauseOfSupertype.kt");
      }

      @Test
      @TestMetadata("nothingVararg.kt")
      public void testNothingVararg() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/nothingVararg.kt");
      }

      @Test
      @TestMetadata("runnable.kt")
      public void testRunnable() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/runnable.kt");
      }

      @Test
      @TestMetadata("samConversionInConstructorCall.kt")
      public void testSamConversionInConstructorCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samConversionInConstructorCall.kt");
      }

      @Test
      @TestMetadata("samSupertype.kt")
      public void testSamSupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samSupertype.kt");
      }

      @Test
      @TestMetadata("samSupertypeWithOverride.kt")
      public void testSamSupertypeWithOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samSupertypeWithOverride.kt");
      }

      @Test
      @TestMetadata("samVsLambda.kt")
      public void testSamVsLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samVsLambda.kt");
      }

      @Test
      @TestMetadata("samWithEquals.kt")
      public void testSamWithEquals() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samWithEquals.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/simple.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/scopes")
    @TestDataPath("$PROJECT_ROOT")
    public class Scopes {
      @Test
      public void testAllFilesPresentInScopes() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/scopes"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("delegatedDataClass.kt")
      public void testDelegatedDataClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/delegatedDataClass.kt");
      }

      @Test
      @TestMetadata("explicitOverrideOfTwoMembers.kt")
      public void testExplicitOverrideOfTwoMembers() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/explicitOverrideOfTwoMembers.kt");
      }

      @Test
      @TestMetadata("explicitOverrideOfTwoMembers_java.kt")
      public void testExplicitOverrideOfTwoMembers_java() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/explicitOverrideOfTwoMembers_java.kt");
      }

      @Test
      @TestMetadata("getterOverrideAndKotlinProperty.kt")
      public void testGetterOverrideAndKotlinProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/getterOverrideAndKotlinProperty.kt");
      }

      @Test
      @TestMetadata("intersectionOverrideOfTwoMembers.kt")
      public void testIntersectionOverrideOfTwoMembers() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/intersectionOverrideOfTwoMembers.kt");
      }

      @Test
      @TestMetadata("intersectionOverrideOfTwoMembers_java.kt")
      public void testIntersectionOverrideOfTwoMembers_java() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/intersectionOverrideOfTwoMembers_java.kt");
      }

      @Test
      @TestMetadata("javaFunctionAndKotlinPropertyFromDifferentSupertypes.kt")
      public void testJavaFunctionAndKotlinPropertyFromDifferentSupertypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/javaFunctionAndKotlinPropertyFromDifferentSupertypes.kt");
      }

      @Test
      @TestMetadata("kotlinAccessorsLikeFunctionsThrowJavaClass.kt")
      public void testKotlinAccessorsLikeFunctionsThrowJavaClass() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/kotlinAccessorsLikeFunctionsThrowJavaClass.kt");
      }

      @Test
      @TestMetadata("noIntersectionOverrideOfTwoMembers.kt")
      public void testNoIntersectionOverrideOfTwoMembers() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/noIntersectionOverrideOfTwoMembers.kt");
      }

      @Test
      @TestMetadata("noIntersectionOverrideOfTwoMembers_java.kt")
      public void testNoIntersectionOverrideOfTwoMembers_java() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/noIntersectionOverrideOfTwoMembers_java.kt");
      }

      @Test
      @TestMetadata("publicJavaAndPrivateKotlinVar.kt")
      public void testPublicJavaAndPrivateKotlinVar() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/publicJavaAndPrivateKotlinVar.kt");
      }

      @Test
      @TestMetadata("singleIntersectionOverride.kt")
      public void testSingleIntersectionOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/singleIntersectionOverride.kt");
      }

      @Test
      @TestMetadata("specialFunctionInJava_1.kt")
      public void testSpecialFunctionInJava_1() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_1.kt");
      }

      @Test
      @TestMetadata("specialFunctionInJava_2.kt")
      public void testSpecialFunctionInJava_2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_2.kt");
      }

      @Test
      @TestMetadata("specialFunctionInJava_3.kt")
      public void testSpecialFunctionInJava_3() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_3.kt");
      }

      @Test
      @TestMetadata("specialFunctionInJava_4.kt")
      public void testSpecialFunctionInJava_4() {
        runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_4.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/scripts")
    @TestDataPath("$PROJECT_ROOT")
    public class Scripts {
      @Test
      public void testAllFilesPresentInScripts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/scripts"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts")
    @TestDataPath("$PROJECT_ROOT")
    public class Smartcasts {
      @Test
      @TestMetadata("accessToMemberAfterReceiverReassignment.kt")
      public void testAccessToMemberAfterReceiverReassignment() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/accessToMemberAfterReceiverReassignment.kt");
      }

      @Test
      public void testAllFilesPresentInSmartcasts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("bangbang.kt")
      public void testBangbang() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/bangbang.kt");
      }

      @Test
      @TestMetadata("casts.kt")
      public void testCasts() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/casts.kt");
      }

      @Test
      @TestMetadata("contractSafeCall.kt")
      public void testContractSafeCall() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/contractSafeCall.kt");
      }

      @Test
      @TestMetadata("equalsAndIdentity.kt")
      public void testEqualsAndIdentity() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/equalsAndIdentity.kt");
      }

      @Test
      @TestMetadata("incorrectSmartcastToNothing.kt")
      public void testIncorrectSmartcastToNothing() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/incorrectSmartcastToNothing.kt");
      }

      @Test
      @TestMetadata("kt10240.kt")
      public void testKt10240() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt10240.kt");
      }

      @Test
      @TestMetadata("kt37327.kt")
      public void testKt37327() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt37327.kt");
      }

      @Test
      @TestMetadata("kt39000.kt")
      public void testKt39000() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt39000.kt");
      }

      @Test
      @TestMetadata("kt50788.kt")
      public void testKt50788() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt50788.kt");
      }

      @Test
      @TestMetadata("kt50875.kt")
      public void testKt50875() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt50875.kt");
      }

      @Test
      @TestMetadata("literalInWhenSubject.kt")
      public void testLiteralInWhenSubject() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/literalInWhenSubject.kt");
      }

      @Test
      @TestMetadata("longElvisChain.kt")
      public void testLongElvisChain() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/longElvisChain.kt");
      }

      @Test
      @TestMetadata("multipleCasts.kt")
      public void testMultipleCasts() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/multipleCasts.kt");
      }

      @Test
      @TestMetadata("nullability.kt")
      public void testNullability() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/nullability.kt");
      }

      @Test
      @TestMetadata("orInWhenBranch.kt")
      public void testOrInWhenBranch() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/orInWhenBranch.kt");
      }

      @Test
      @TestMetadata("smartCastInInit.kt")
      public void testSmartCastInInit() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartCastInInit.kt");
      }

      @Test
      @TestMetadata("smartcastInByClause.kt")
      public void testSmartcastInByClause() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastInByClause.kt");
      }

      @Test
      @TestMetadata("smartcastOnFunctionalType.kt")
      public void testSmartcastOnFunctionalType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastOnFunctionalType.kt");
      }

      @Test
      @TestMetadata("smartcastOnImplicitReceiverOfCallableReference.kt")
      public void testSmartcastOnImplicitReceiverOfCallableReference() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastOnImplicitReceiverOfCallableReference.kt");
      }

      @Test
      @TestMetadata("smartcastToNothing.kt")
      public void testSmartcastToNothing() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastToNothing.kt");
      }

      @Test
      @TestMetadata("smartcastToStarProjectedType.kt")
      public void testSmartcastToStarProjectedType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastToStarProjectedType.kt");
      }

      @Test
      @TestMetadata("smartcastToTypeParameter.kt")
      public void testSmartcastToTypeParameter() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastToTypeParameter.kt");
      }

      @Test
      @TestMetadata("smartcastedField.kt")
      public void testSmartcastedField() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastedField.kt");
      }

      @Test
      @TestMetadata("smartcastsFromEquals_differentModule.kt")
      public void testSmartcastsFromEquals_differentModule() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastsFromEquals_differentModule.kt");
      }

      @Test
      @TestMetadata("smartcastsFromEquals_sameModule.kt")
      public void testSmartcastsFromEquals_sameModule() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastsFromEquals_sameModule.kt");
      }

      @Test
      @TestMetadata("typeOfLambdaWithSmartcast.kt")
      public void testTypeOfLambdaWithSmartcast() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/typeOfLambdaWithSmartcast.kt");
      }

      @Test
      @TestMetadata("unstableSmartcastAndAmbiguity.kt")
      public void testUnstableSmartcastAndAmbiguity() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/unstableSmartcastAndAmbiguity.kt");
      }

      @Test
      @TestMetadata("valCapturedInLambda.kt")
      public void testValCapturedInLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/valCapturedInLambda.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans")
      @TestDataPath("$PROJECT_ROOT")
      public class Booleans {
        @Test
        public void testAllFilesPresentInBooleans() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("booleanElvisBoundSmartcast.kt")
        public void testBooleanElvisBoundSmartcast() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/booleanElvisBoundSmartcast.kt");
        }

        @Test
        @TestMetadata("booleanOperators.kt")
        public void testBooleanOperators() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/booleanOperators.kt");
        }

        @Test
        @TestMetadata("equalsToBoolean.kt")
        public void testEqualsToBoolean() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/equalsToBoolean.kt");
        }

        @Test
        @TestMetadata("jumpFromRhsOfOperator.kt")
        public void testJumpFromRhsOfOperator() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/jumpFromRhsOfOperator.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts")
      @TestDataPath("$PROJECT_ROOT")
      public class BoundSmartcasts {
        @Test
        public void testAllFilesPresentInBoundSmartcasts() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("assignToBoundSmartcastedVariable.kt")
        public void testAssignToBoundSmartcastedVariable() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/assignToBoundSmartcastedVariable.kt");
        }

        @Test
        @TestMetadata("boundSmartcastWithProjection.kt")
        public void testBoundSmartcastWithProjection() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/boundSmartcastWithProjection.kt");
        }

        @Test
        @TestMetadata("boundSmartcasts.kt")
        public void testBoundSmartcasts() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/boundSmartcasts.kt");
        }

        @Test
        @TestMetadata("boundSmartcastsInBranches.kt")
        public void testBoundSmartcastsInBranches() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/boundSmartcastsInBranches.kt");
        }

        @Test
        @TestMetadata("functionCallBound.kt")
        public void testFunctionCallBound() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/functionCallBound.kt");
        }

        @Test
        @TestMetadata("thisAssignment.kt")
        public void testThisAssignment() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/thisAssignment.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures")
      @TestDataPath("$PROJECT_ROOT")
      public class ControlStructures {
        @Test
        public void testAllFilesPresentInControlStructures() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("earlyReturnInNonExhaustiveWhen.kt")
        public void testEarlyReturnInNonExhaustiveWhen() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/earlyReturnInNonExhaustiveWhen.kt");
        }

        @Test
        @TestMetadata("elvis.kt")
        public void testElvis() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/elvis.kt");
        }

        @Test
        @TestMetadata("returnFromWhen.kt")
        public void testReturnFromWhen() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/returnFromWhen.kt");
        }

        @Test
        @TestMetadata("returns.kt")
        public void testReturns() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/returns.kt");
        }

        @Test
        @TestMetadata("simpleIf.kt")
        public void testSimpleIf() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/simpleIf.kt");
        }

        @Test
        @TestMetadata("smartcastFromArgument.kt")
        public void testSmartcastFromArgument() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/smartcastFromArgument.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/when.kt");
        }

        @Test
        @TestMetadata("whenSubjectExpression.kt")
        public void testWhenSubjectExpression() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/whenSubjectExpression.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas")
      @TestDataPath("$PROJECT_ROOT")
      public class Lambdas {
        @Test
        public void testAllFilesPresentInLambdas() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("inPlaceLambdas.kt")
        public void testInPlaceLambdas() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/inPlaceLambdas.kt");
        }

        @Test
        @TestMetadata("lambdaInWhenBranch.kt")
        public void testLambdaInWhenBranch() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/lambdaInWhenBranch.kt");
        }

        @Test
        @TestMetadata("smartcastOnLambda.kt")
        public void testSmartcastOnLambda() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/smartcastOnLambda.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops")
      @TestDataPath("$PROJECT_ROOT")
      public class Loops {
        @Test
        public void testAllFilesPresentInLoops() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("dataFlowInfoFromWhileCondition.kt")
        public void testDataFlowInfoFromWhileCondition() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops/dataFlowInfoFromWhileCondition.kt");
        }

        @Test
        @TestMetadata("elvisAtTheEndOfLoop.kt")
        public void testElvisAtTheEndOfLoop() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops/elvisAtTheEndOfLoop.kt");
        }

        @Test
        @TestMetadata("endlessLoops.kt")
        public void testEndlessLoops() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops/endlessLoops.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems")
      @TestDataPath("$PROJECT_ROOT")
      public class Problems {
        @Test
        public void testAllFilesPresentInProblems() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("invoke.kt")
        public void testInvoke() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems/invoke.kt");
        }

        @Test
        @TestMetadata("noSmartcastToNullableNothing.kt")
        public void testNoSmartcastToNullableNothing() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems/noSmartcastToNullableNothing.kt");
        }

        @Test
        @TestMetadata("smartcastToStarProjectedSubclass.kt")
        public void testSmartcastToStarProjectedSubclass() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems/smartcastToStarProjectedSubclass.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers")
      @TestDataPath("$PROJECT_ROOT")
      public class Receivers {
        @Test
        public void testAllFilesPresentInReceivers() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("implicitReceiverAsWhenSubject.kt")
        public void testImplicitReceiverAsWhenSubject() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/implicitReceiverAsWhenSubject.kt");
        }

        @Test
        @TestMetadata("implicitReceivers.kt")
        public void testImplicitReceivers() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/implicitReceivers.kt");
        }

        @Test
        @TestMetadata("mixingImplicitAndExplicitReceivers.kt")
        public void testMixingImplicitAndExplicitReceivers() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/mixingImplicitAndExplicitReceivers.kt");
        }

        @Test
        @TestMetadata("smartCastingExplicitReceiver.kt")
        public void testSmartCastingExplicitReceiver() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/smartCastingExplicitReceiver.kt");
        }

        @Test
        @TestMetadata("thisOfExtensionProperty.kt")
        public void testThisOfExtensionProperty() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/thisOfExtensionProperty.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls")
      @TestDataPath("$PROJECT_ROOT")
      public class SafeCalls {
        @Test
        public void testAllFilesPresentInSafeCalls() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("assignSafeCall.kt")
        public void testAssignSafeCall() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/assignSafeCall.kt");
        }

        @Test
        @TestMetadata("boundSafeCallAndIsCheck.kt")
        public void testBoundSafeCallAndIsCheck() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/boundSafeCallAndIsCheck.kt");
        }

        @Test
        @TestMetadata("complexIfWithOr.kt")
        public void testComplexIfWithOr() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/complexIfWithOr.kt");
        }

        @Test
        @TestMetadata("safeCallAndEqualityToBool.kt")
        public void testSafeCallAndEqualityToBool() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/safeCallAndEqualityToBool.kt");
        }

        @Test
        @TestMetadata("safeCalls.kt")
        public void testSafeCalls() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/safeCalls.kt");
        }

        @Test
        @TestMetadata("unstableSmartCastOnSafeCallArgument.kt")
        public void testUnstableSmartCastOnSafeCallArgument() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/unstableSmartCastOnSafeCallArgument.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability")
      @TestDataPath("$PROJECT_ROOT")
      public class Stability {
        @Test
        public void testAllFilesPresentInStability() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("overridenOpenVal.kt")
        public void testOverridenOpenVal() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability/overridenOpenVal.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables")
      @TestDataPath("$PROJECT_ROOT")
      public class Variables {
        @Test
        public void testAllFilesPresentInVariables() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("delayedAssignment.kt")
        public void testDelayedAssignment() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables/delayedAssignment.kt");
        }

        @Test
        @TestMetadata("smartcastAfterReassignment.kt")
        public void testSmartcastAfterReassignment() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables/smartcastAfterReassignment.kt");
        }

        @Test
        @TestMetadata("smartcastStoredInLocalVar.kt")
        public void testSmartcastStoredInLocalVar() {
          runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables/smartcastStoredInLocalVar.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/stdlib")
    @TestDataPath("$PROJECT_ROOT")
    public class Stdlib {
      @Test
      public void testAllFilesPresentInStdlib() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/stdlib"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k")
      @TestDataPath("$PROJECT_ROOT")
      public class J_k {
        @Test
        public void testAllFilesPresentInJ_k() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("ArrayInGenericArguments.kt")
        public void testArrayInGenericArguments() {
          runTest("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k/ArrayInGenericArguments.kt");
        }

        @Test
        @TestMetadata("flexibleWildcard.kt")
        public void testFlexibleWildcard() {
          runTest("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k/flexibleWildcard.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/suppress")
    @TestDataPath("$PROJECT_ROOT")
    public class Suppress {
      @Test
      public void testAllFilesPresentInSuppress() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/suppress"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("allWarnings.kt")
      public void testAllWarnings() {
        runTest("compiler/fir/analysis-tests/testData/resolve/suppress/allWarnings.kt");
      }

      @Test
      @TestMetadata("multipleWarnings.kt")
      public void testMultipleWarnings() {
        runTest("compiler/fir/analysis-tests/testData/resolve/suppress/multipleWarnings.kt");
      }

      @Test
      @TestMetadata("singleError.kt")
      public void testSingleError() {
        runTest("compiler/fir/analysis-tests/testData/resolve/suppress/singleError.kt");
      }

      @Test
      @TestMetadata("singleWarning.kt")
      public void testSingleWarning() {
        runTest("compiler/fir/analysis-tests/testData/resolve/suppress/singleWarning.kt");
      }

      @Test
      @TestMetadata("withSuppression.kt")
      public void testWithSuppression() {
        runTest("compiler/fir/analysis-tests/testData/resolve/suppress/withSuppression.kt");
      }

      @Test
      @TestMetadata("withSuppression2.kt")
      public void testWithSuppression2() {
        runTest("compiler/fir/analysis-tests/testData/resolve/suppress/withSuppression2.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/typeParameters")
    @TestDataPath("$PROJECT_ROOT")
    public class TypeParameters {
      @Test
      public void testAllFilesPresentInTypeParameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/typeParameters"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("illFormed.kt")
      public void testIllFormed() {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeParameters/illFormed.kt");
      }

      @Test
      @TestMetadata("kt38288.kt")
      public void testKt38288() {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeParameters/kt38288.kt");
      }

      @Test
      @TestMetadata("starProjectionForMultipleBounds.kt")
      public void testStarProjectionForMultipleBounds() {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeParameters/starProjectionForMultipleBounds.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/types")
    @TestDataPath("$PROJECT_ROOT")
    public class Types {
      @Test
      public void testAllFilesPresentInTypes() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/types"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("bareWithDnnArg.kt")
      public void testBareWithDnnArg() {
        runTest("compiler/fir/analysis-tests/testData/resolve/types/bareWithDnnArg.kt");
      }

      @Test
      @TestMetadata("bareWithFlexibleArg.kt")
      public void testBareWithFlexibleArg() {
        runTest("compiler/fir/analysis-tests/testData/resolve/types/bareWithFlexibleArg.kt");
      }

      @Test
      @TestMetadata("bareWithSubjectTypeAlias.kt")
      public void testBareWithSubjectTypeAlias() {
        runTest("compiler/fir/analysis-tests/testData/resolve/types/bareWithSubjectTypeAlias.kt");
      }

      @Test
      @TestMetadata("capturedParametersOfInnerClasses.kt")
      public void testCapturedParametersOfInnerClasses() {
        runTest("compiler/fir/analysis-tests/testData/resolve/types/capturedParametersOfInnerClasses.kt");
      }

      @Test
      @TestMetadata("castToBareType.kt")
      public void testCastToBareType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/types/castToBareType.kt");
      }

      @Test
      @TestMetadata("typeAliasInArguments.kt")
      public void testTypeAliasInArguments() {
        runTest("compiler/fir/analysis-tests/testData/resolve/types/typeAliasInArguments.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum")
    @TestDataPath("$PROJECT_ROOT")
    public class UnqualifiedEnum {
      @Test
      public void testAllFilesPresentInUnqualifiedEnum() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("correctJava.kt")
      public void testCorrectJava() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/correctJava.kt");
      }

      @Test
      @TestMetadata("enumWithTheSameNameAsEntry.kt")
      public void testEnumWithTheSameNameAsEntry() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/enumWithTheSameNameAsEntry.kt");
      }

      @Test
      @TestMetadata("incorrectJava.kt")
      public void testIncorrectJava() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/incorrectJava.kt");
      }

      @Test
      @TestMetadata("nested.kt")
      public void testNested() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/nested.kt");
      }

      @Test
      @TestMetadata("notInsideBranches.kt")
      public void testNotInsideBranches() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/notInsideBranches.kt");
      }

      @Test
      @TestMetadata("priority.kt")
      public void testPriority() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/priority.kt");
      }

      @Test
      @TestMetadata("typeAlias.kt")
      public void testTypeAlias() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/typeAlias.kt");
      }

      @Test
      @TestMetadata("unqualifiedEnum.kt")
      public void testUnqualifiedEnum() {
        runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/unqualifiedEnum.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/vfir")
    @TestDataPath("$PROJECT_ROOT")
    public class Vfir {
      @Test
      public void testAllFilesPresentInVfir() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/vfir"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolve/vfir/expressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Expressions {
        @Test
        public void testAllFilesPresentInExpressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/vfir/expressions"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("for.kt")
        public void testFor() {
          runTest("compiler/fir/analysis-tests/testData/resolve/vfir/expressions/for.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/visibility")
    @TestDataPath("$PROJECT_ROOT")
    public class Visibility {
      @Test
      public void testAllFilesPresentInVisibility() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/visibility"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("exposedFunctionParameterType.kt")
      public void testExposedFunctionParameterType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedFunctionParameterType.kt");
      }

      @Test
      @TestMetadata("exposedFunctionReturnType.kt")
      public void testExposedFunctionReturnType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedFunctionReturnType.kt");
      }

      @Test
      @TestMetadata("exposedPropertyType.kt")
      public void testExposedPropertyType() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedPropertyType.kt");
      }

      @Test
      @TestMetadata("exposedSupertype.kt")
      public void testExposedSupertype() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedSupertype.kt");
      }

      @Test
      @TestMetadata("exposedTypeAlias.kt")
      public void testExposedTypeAlias() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedTypeAlias.kt");
      }

      @Test
      @TestMetadata("exposedTypeParameters.kt")
      public void testExposedTypeParameters() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedTypeParameters.kt");
      }

      @Test
      @TestMetadata("intersectionOverrideWithImplicitTypes.kt")
      public void testIntersectionOverrideWithImplicitTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/intersectionOverrideWithImplicitTypes.kt");
      }

      @Test
      @TestMetadata("kotlinJavaKotlinHierarchy.kt")
      public void testKotlinJavaKotlinHierarchy() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/kotlinJavaKotlinHierarchy.kt");
      }

      @Test
      @TestMetadata("privateAliasInSamePackage.kt")
      public void testPrivateAliasInSamePackage() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/privateAliasInSamePackage.kt");
      }

      @Test
      @TestMetadata("protectedAnnotationClassFromJava.kt")
      public void testProtectedAnnotationClassFromJava() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/protectedAnnotationClassFromJava.kt");
      }

      @Test
      @TestMetadata("protectedInCompanion.kt")
      public void testProtectedInCompanion() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/protectedInCompanion.kt");
      }

      @Test
      @TestMetadata("singletonConstructors.kt")
      public void testSingletonConstructors() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/singletonConstructors.kt");
      }

      @Test
      @TestMetadata("superAccessToJavaField.kt")
      public void testSuperAccessToJavaField() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/superAccessToJavaField.kt");
      }

      @Test
      @TestMetadata("visibilityWithOverrides.kt")
      public void testVisibilityWithOverrides() {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibility/visibilityWithOverrides.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage")
    @TestDataPath("$PROJECT_ROOT")
    public class WithAllowedKotlinPackage {
      @Test
      public void testAllFilesPresentInWithAllowedKotlinPackage() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("extensionFunctionAddedToStdlib.kt")
      public void testExtensionFunctionAddedToStdlib() {
        runTest("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage/extensionFunctionAddedToStdlib.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib")
  @TestDataPath("$PROJECT_ROOT")
  public class ResolveWithStdlib {
    @Test
    @TestMetadata("addAllOnJavaCollection.kt")
    public void testAddAllOnJavaCollection() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/addAllOnJavaCollection.kt");
    }

    @Test
    public void testAllFilesPresentInResolveWithStdlib() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
    }

    @Test
    @TestMetadata("arrayFilterCapturedType.kt")
    public void testArrayFilterCapturedType() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/arrayFilterCapturedType.kt");
    }

    @Test
    @TestMetadata("arrayFirstOrNull.kt")
    public void testArrayFirstOrNull() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/arrayFirstOrNull.kt");
    }

    @Test
    @TestMetadata("arrayInLocal.kt")
    public void testArrayInLocal() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/arrayInLocal.kt");
    }

    @Test
    @TestMetadata("assignmentWithWrongLhs.kt")
    public void testAssignmentWithWrongLhs() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/assignmentWithWrongLhs.kt");
    }

    @Test
    @TestMetadata("backingField.kt")
    public void testBackingField() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/backingField.kt");
    }

    @Test
    @TestMetadata("castForFunctionsWithDifferentArities.kt")
    public void testCastForFunctionsWithDifferentArities() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/castForFunctionsWithDifferentArities.kt");
    }

    @Test
    @TestMetadata("ClassIdDiagnosticRendering.kt")
    public void testClassIdDiagnosticRendering() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/ClassIdDiagnosticRendering.kt");
    }

    @Test
    @TestMetadata("classLiteralForParameter.kt")
    public void testClassLiteralForParameter() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/classLiteralForParameter.kt");
    }

    @Test
    @TestMetadata("cloneArray.kt")
    public void testCloneArray() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/cloneArray.kt");
    }

    @Test
    @TestMetadata("companionLoad.kt")
    public void testCompanionLoad() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/companionLoad.kt");
    }

    @Test
    @TestMetadata("complexPostponedCfg.kt")
    public void testComplexPostponedCfg() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/complexPostponedCfg.kt");
    }

    @Test
    @TestMetadata("components.kt")
    public void testComponents() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/components.kt");
    }

    @Test
    @TestMetadata("concurrent.kt")
    public void testConcurrent() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/concurrent.kt");
    }

    @Test
    @TestMetadata("concurrentMapOfAliases.kt")
    public void testConcurrentMapOfAliases() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/concurrentMapOfAliases.kt");
    }

    @Test
    @TestMetadata("emptyArray.kt")
    public void testEmptyArray() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/emptyArray.kt");
    }

    @Test
    @TestMetadata("enumValuesDeserialized.kt")
    public void testEnumValuesDeserialized() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/enumValuesDeserialized.kt");
    }

    @Test
    @TestMetadata("errorsInUnreachable.kt")
    public void testErrorsInUnreachable() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/errorsInUnreachable.kt");
    }

    @Test
    @TestMetadata("exception.kt")
    public void testException() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/exception.kt");
    }

    @Test
    @TestMetadata("factoryFunctionOverloads.kt")
    public void testFactoryFunctionOverloads() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/factoryFunctionOverloads.kt");
    }

    @Test
    @TestMetadata("fillInStackTrace.kt")
    public void testFillInStackTrace() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/fillInStackTrace.kt");
    }

    @Test
    @TestMetadata("functionAndFunctionN.kt")
    public void testFunctionAndFunctionN() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/functionAndFunctionN.kt");
    }

    @Test
    @TestMetadata("functionX.kt")
    public void testFunctionX() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/functionX.kt");
    }

    @Test
    @TestMetadata("getOnKProperty.kt")
    public void testGetOnKProperty() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/getOnKProperty.kt");
    }

    @Test
    @TestMetadata("getOrPutAmbiguity.kt")
    public void testGetOrPutAmbiguity() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/getOrPutAmbiguity.kt");
    }

    @Test
    @TestMetadata("hashMapTypeAlias.kt")
    public void testHashMapTypeAlias() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/hashMapTypeAlias.kt");
    }

    @Test
    @TestMetadata("hashSet.kt")
    public void testHashSet() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/hashSet.kt");
    }

    @Test
    @TestMetadata("hashTableWithForEach.kt")
    public void testHashTableWithForEach() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/hashTableWithForEach.kt");
    }

    @Test
    @TestMetadata("helloWorld.kt")
    public void testHelloWorld() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/helloWorld.kt");
    }

    @Test
    @TestMetadata("implicitReceiverOrder.kt")
    public void testImplicitReceiverOrder() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/implicitReceiverOrder.kt");
    }

    @Test
    @TestMetadata("inapplicableRemoveAll.kt")
    public void testInapplicableRemoveAll() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inapplicableRemoveAll.kt");
    }

    @Test
    @TestMetadata("incorrectDeprecation.kt")
    public void testIncorrectDeprecation() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/incorrectDeprecation.kt");
    }

    @Test
    @TestMetadata("incorrectExtensionFunctionType.kt")
    public void testIncorrectExtensionFunctionType() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/incorrectExtensionFunctionType.kt");
    }

    @Test
    @TestMetadata("incorrectLabelReference.kt")
    public void testIncorrectLabelReference() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/incorrectLabelReference.kt");
    }

    @Test
    @TestMetadata("incorrectReturnFromNothingLambda.kt")
    public void testIncorrectReturnFromNothingLambda() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/incorrectReturnFromNothingLambda.kt");
    }

    @Test
    @TestMetadata("intersectDynamicAndString.kt")
    public void testIntersectDynamicAndString() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intersectDynamicAndString.kt");
    }

    @Test
    @TestMetadata("intersectRawAndMutable.kt")
    public void testIntersectRawAndMutable() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intersectRawAndMutable.kt");
    }

    @Test
    @TestMetadata("javaEnumSynthetic.kt")
    public void testJavaEnumSynthetic() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/javaEnumSynthetic.kt");
    }

    @Test
    @TestMetadata("javaLangComparator.kt")
    public void testJavaLangComparator() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/javaLangComparator.kt");
    }

    @Test
    @TestMetadata("kotlinComparatorAlias.kt")
    public void testKotlinComparatorAlias() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/kotlinComparatorAlias.kt");
    }

    @Test
    @TestMetadata("kt54220.kt")
    public void testKt54220() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/kt54220.kt");
    }

    @Test
    @TestMetadata("listPlusAssign.kt")
    public void testListPlusAssign() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/listPlusAssign.kt");
    }

    @Test
    @TestMetadata("lowPriorityInResolution.kt")
    public void testLowPriorityInResolution() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/lowPriorityInResolution.kt");
    }

    @Test
    @TestMetadata("mapList.kt")
    public void testMapList() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/mapList.kt");
    }

    @Test
    @TestMetadata("multipleImplicitReceivers.kt")
    public void testMultipleImplicitReceivers() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multipleImplicitReceivers.kt");
    }

    @Test
    @TestMetadata("noneWithForEach.kt")
    public void testNoneWithForEach() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/noneWithForEach.kt");
    }

    @Test
    @TestMetadata("nullableTypeParameter.kt")
    public void testNullableTypeParameter() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/nullableTypeParameter.kt");
    }

    @Test
    @TestMetadata("plusAssignNullable.kt")
    public void testPlusAssignNullable() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/plusAssignNullable.kt");
    }

    @Test
    @TestMetadata("problems.kt")
    public void testProblems() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems.kt");
    }

    @Test
    @TestMetadata("rangeTo.kt")
    public void testRangeTo() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/rangeTo.kt");
    }

    @Test
    @TestMetadata("recursiveBug.kt")
    public void testRecursiveBug() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/recursiveBug.kt");
    }

    @Test
    @TestMetadata("reflectionClass.kt")
    public void testReflectionClass() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/reflectionClass.kt");
    }

    @Test
    @TestMetadata("removeIf.kt")
    public void testRemoveIf() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/removeIf.kt");
    }

    @Test
    @TestMetadata("removeOnAbstractMap.kt")
    public void testRemoveOnAbstractMap() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/removeOnAbstractMap.kt");
    }

    @Test
    @TestMetadata("repeatedAnnotations.kt")
    public void testRepeatedAnnotations() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/repeatedAnnotations.kt");
    }

    @Test
    @TestMetadata("runOnIntegerLiteral.kt")
    public void testRunOnIntegerLiteral() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/runOnIntegerLiteral.kt");
    }

    @Test
    @TestMetadata("samForComparator.kt")
    public void testSamForComparator() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/samForComparator.kt");
    }

    @Test
    @TestMetadata("simpleLazy.kt")
    public void testSimpleLazy() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/simpleLazy.kt");
    }

    @Test
    @TestMetadata("stringConstructors.kt")
    public void testStringConstructors() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/stringConstructors.kt");
    }

    @Test
    @TestMetadata("toSortedMapWithComparator.kt")
    public void testToSortedMapWithComparator() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/toSortedMapWithComparator.kt");
    }

    @Test
    @TestMetadata("typeAliasDeserialization.kt")
    public void testTypeAliasDeserialization() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/typeAliasDeserialization.kt");
    }

    @Test
    @TestMetadata("typeAliasWithForEach.kt")
    public void testTypeAliasWithForEach() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/typeAliasWithForEach.kt");
    }

    @Test
    @TestMetadata("typeParameterDerived.kt")
    public void testTypeParameterDerived() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/typeParameterDerived.kt");
    }

    @Test
    @TestMetadata("unaryOperators.kt")
    public void testUnaryOperators() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/unaryOperators.kt");
    }

    @Test
    @TestMetadata("whenAsLambdaReturnStatement.kt")
    public void testWhenAsLambdaReturnStatement() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/whenAsLambdaReturnStatement.kt");
    }

    @Test
    @TestMetadata("withInInitializer.kt")
    public void testWithInInitializer() {
      runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/withInInitializer.kt");
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("annotationAllUseSiteTarget.kt")
      public void testAnnotationAllUseSiteTarget() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations/annotationAllUseSiteTarget.kt");
      }

      @Test
      @TestMetadata("annotationDefaultTargetFirstOnly.kt")
      public void testAnnotationDefaultTargetFirstOnly() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations/annotationDefaultTargetFirstOnly.kt");
      }

      @Test
      @TestMetadata("annotationDefaultTargetFirstOnlyWarn.kt")
      public void testAnnotationDefaultTargetFirstOnlyWarn() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations/annotationDefaultTargetFirstOnlyWarn.kt");
      }

      @Test
      @TestMetadata("annotationDefaultTargetParamProperty.kt")
      public void testAnnotationDefaultTargetParamProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations/annotationDefaultTargetParamProperty.kt");
      }

      @Test
      @TestMetadata("annotationUseSites.kt")
      public void testAnnotationUseSites() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations/annotationUseSites.kt");
      }

      @Test
      @TestMetadata("multipleAnnotationsWithAllUseSiteTarget.kt")
      public void testMultipleAnnotationsWithAllUseSiteTarget() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotations/multipleAnnotationsWithAllUseSiteTarget.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReferences {
      @Test
      public void testAllFilesPresentInCallableReferences() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("beyoundCalls.kt")
      public void testBeyoundCalls() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/beyoundCalls.kt");
      }

      @Test
      @TestMetadata("coercionToUnit.kt")
      public void testCoercionToUnit() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/coercionToUnit.kt");
      }

      @Test
      @TestMetadata("companions.kt")
      public void testCompanions() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/companions.kt");
      }

      @Test
      @TestMetadata("constructors.kt")
      public void testConstructors() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/constructors.kt");
      }

      @Test
      @TestMetadata("differentLevels.kt")
      public void testDifferentLevels() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/differentLevels.kt");
      }

      @Test
      @TestMetadata("extensionReceiverInference.kt")
      public void testExtensionReceiverInference() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/extensionReceiverInference.kt");
      }

      @Test
      @TestMetadata("genericInReceiver.kt")
      public void testGenericInReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/genericInReceiver.kt");
      }

      @Test
      @TestMetadata("ifWithCR.kt")
      public void testIfWithCR() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/ifWithCR.kt");
      }

      @Test
      @TestMetadata("implicitTypes.kt")
      public void testImplicitTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/implicitTypes.kt");
      }

      @Test
      @TestMetadata("inferenceFromCallableReferenceType.kt")
      public void testInferenceFromCallableReferenceType() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/inferenceFromCallableReferenceType.kt");
      }

      @Test
      @TestMetadata("inferenceFromExpectedType.kt")
      public void testInferenceFromExpectedType() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/inferenceFromExpectedType.kt");
      }

      @Test
      @TestMetadata("javaStatic.kt")
      public void testJavaStatic() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/javaStatic.kt");
      }

      @Test
      @TestMetadata("manyCandidatesInference.kt")
      public void testManyCandidatesInference() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyCandidatesInference.kt");
      }

      @Test
      @TestMetadata("manyInnerCandidates.kt")
      public void testManyInnerCandidates() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyInnerCandidates.kt");
      }

      @Test
      @TestMetadata("manyInnerManyOuterCandidates.kt")
      public void testManyInnerManyOuterCandidates() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyInnerManyOuterCandidates.kt");
      }

      @Test
      @TestMetadata("manyInnermanyOuterCandidatesAmbiguity.kt")
      public void testManyInnermanyOuterCandidatesAmbiguity() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyInnermanyOuterCandidatesAmbiguity.kt");
      }

      @Test
      @TestMetadata("manyOuterCandidates.kt")
      public void testManyOuterCandidates() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyOuterCandidates.kt");
      }

      @Test
      @TestMetadata("properties.kt")
      public void testProperties() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/properties.kt");
      }

      @Test
      @TestMetadata("referenceToJavaStdlib.kt")
      public void testReferenceToJavaStdlib() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/referenceToJavaStdlib.kt");
      }

      @Test
      @TestMetadata("sam.kt")
      public void testSam() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/sam.kt");
      }

      @Test
      @TestMetadata("simpleClassReceiver.kt")
      public void testSimpleClassReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/simpleClassReceiver.kt");
      }

      @Test
      @TestMetadata("simpleExpressionReceiver.kt")
      public void testSimpleExpressionReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/simpleExpressionReceiver.kt");
      }

      @Test
      @TestMetadata("simpleNoReceiver.kt")
      public void testSimpleNoReceiver() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/simpleNoReceiver.kt");
      }

      @Test
      @TestMetadata("varProperties.kt")
      public void testVarProperties() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/varProperties.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests")
      @TestDataPath("$PROJECT_ROOT")
      public class FromBasicDiagnosticTests {
        @Test
        public void testAllFilesPresentInFromBasicDiagnosticTests() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("ambiguityWhenNoApplicableCallableReferenceCandidate.kt")
        public void testAmbiguityWhenNoApplicableCallableReferenceCandidate() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/ambiguityWhenNoApplicableCallableReferenceCandidate.kt");
        }

        @Test
        @TestMetadata("applicableCallableReferenceFromDistantScope.kt")
        public void testApplicableCallableReferenceFromDistantScope() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/applicableCallableReferenceFromDistantScope.kt");
        }

        @Test
        @TestMetadata("chooseCallableReferenceDependingOnInferredReceiver.kt")
        public void testChooseCallableReferenceDependingOnInferredReceiver() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/chooseCallableReferenceDependingOnInferredReceiver.kt");
        }

        @Test
        @TestMetadata("commonSupertypeFromReturnTypesOfCallableReference.kt")
        public void testCommonSupertypeFromReturnTypesOfCallableReference() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/commonSupertypeFromReturnTypesOfCallableReference.kt");
        }

        @Test
        @TestMetadata("eagerAndPostponedCallableReferences.kt")
        public void testEagerAndPostponedCallableReferences() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/eagerAndPostponedCallableReferences.kt");
        }

        @Test
        @TestMetadata("eagerResolveOfSingleCallableReference.kt")
        public void testEagerResolveOfSingleCallableReference() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/eagerResolveOfSingleCallableReference.kt");
        }

        @Test
        @TestMetadata("moreSpecificAmbiguousExtensions.kt")
        public void testMoreSpecificAmbiguousExtensions() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/moreSpecificAmbiguousExtensions.kt");
        }

        @Test
        @TestMetadata("multipleOutersAndMultipleCallableReferences.kt")
        public void testMultipleOutersAndMultipleCallableReferences() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/multipleOutersAndMultipleCallableReferences.kt");
        }

        @Test
        @TestMetadata("noAmbiguityBetweenTopLevelAndMemberProperty.kt")
        public void testNoAmbiguityBetweenTopLevelAndMemberProperty() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/noAmbiguityBetweenTopLevelAndMemberProperty.kt");
        }

        @Test
        @TestMetadata("overloadsBound.kt")
        public void testOverloadsBound() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/overloadsBound.kt");
        }

        @Test
        @TestMetadata("postponedResolveOfManyCallableReference.kt")
        public void testPostponedResolveOfManyCallableReference() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/postponedResolveOfManyCallableReference.kt");
        }

        @Test
        @TestMetadata("resolveCallableReferencesAfterAllSimpleArguments.kt")
        public void testResolveCallableReferencesAfterAllSimpleArguments() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/resolveCallableReferencesAfterAllSimpleArguments.kt");
        }

        @Test
        @TestMetadata("withGenericFun.kt")
        public void testWithGenericFun() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/withGenericFun.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts")
    @TestDataPath("$PROJECT_ROOT")
    public class Contracts {
      @Test
      public void testAllFilesPresentInContracts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary")
      @TestDataPath("$PROJECT_ROOT")
      public class FromLibrary {
        @Test
        public void testAllFilesPresentInFromLibrary() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("callsInPlace.kt")
        public void testCallsInPlace() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary/callsInPlace.kt");
        }

        @Test
        @TestMetadata("conditionalEffects.kt")
        public void testConditionalEffects() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary/conditionalEffects.kt");
        }

        @Test
        @TestMetadata("notIsNullOrEmpty.kt")
        public void testNotIsNullOrEmpty() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary/notIsNullOrEmpty.kt");
        }

        @Test
        @TestMetadata("suspendCallsInPlace.kt")
        public void testSuspendCallsInPlace() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary/suspendCallsInPlace.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource")
      @TestDataPath("$PROJECT_ROOT")
      public class FromSource {
        @Test
        public void testAllFilesPresentInFromSource() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad")
        @TestDataPath("$PROJECT_ROOT")
        public class Bad {
          @Test
          public void testAllFilesPresentInBad() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
          }

          @Test
          @TestMetadata("noOptIn.kt")
          public void testNoOptIn() {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/noOptIn.kt");
          }

          @Nested
          @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace")
          @TestDataPath("$PROJECT_ROOT")
          public class CallsInPlace {
            @Test
            public void testAllFilesPresentInCallsInPlace() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
            }

            @Test
            @TestMetadata("coercedInvocationKind.kt")
            public void testCoercedInvocationKind() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/coercedInvocationKind.kt");
            }

            @Test
            @TestMetadata("contractAndImplicitTypeInterdependency1.kt")
            public void testContractAndImplicitTypeInterdependency1() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/contractAndImplicitTypeInterdependency1.kt");
            }

            @Test
            @TestMetadata("contractAndImplicitTypeInterdependency2.kt")
            public void testContractAndImplicitTypeInterdependency2() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/contractAndImplicitTypeInterdependency2.kt");
            }

            @Test
            @TestMetadata("inAnonymousObject.kt")
            public void testInAnonymousObject() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/inAnonymousObject.kt");
            }

            @Test
            @TestMetadata("inLocalClass.kt")
            public void testInLocalClass() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/inLocalClass.kt");
            }

            @Test
            @TestMetadata("inLocalFunction.kt")
            public void testInLocalFunction() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/inLocalFunction.kt");
            }

            @Test
            @TestMetadata("toLocalVariables.kt")
            public void testToLocalVariables() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/toLocalVariables.kt");
            }
          }

          @Nested
          @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies")
          @TestDataPath("$PROJECT_ROOT")
          public class ReturnsImplies {
            @Test
            public void testAllFilesPresentInReturnsImplies() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
            }

            @Test
            @TestMetadata("notNull.kt")
            public void testNotNull() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies/notNull.kt");
            }

            @Test
            @TestMetadata("propertyGetter.kt")
            public void testPropertyGetter() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies/propertyGetter.kt");
            }

            @Test
            @TestMetadata("redundantConditions.kt")
            public void testRedundantConditions() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies/redundantConditions.kt");
            }
          }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good")
        @TestDataPath("$PROJECT_ROOT")
        public class Good {
          @Test
          public void testAllFilesPresentInGood() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
          }

          @Nested
          @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace")
          @TestDataPath("$PROJECT_ROOT")
          public class CallsInPlace {
            @Test
            public void testAllFilesPresentInCallsInPlace() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
            }

            @Test
            @TestMetadata("atLeastOnce.kt")
            public void testAtLeastOnce() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/atLeastOnce.kt");
            }

            @Test
            @TestMetadata("atMostOnce.kt")
            public void testAtMostOnce() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/atMostOnce.kt");
            }

            @Test
            @TestMetadata("contractsUsage.kt")
            public void testContractsUsage() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/contractsUsage.kt");
            }

            @Test
            @TestMetadata("exactlyOnce.kt")
            public void testExactlyOnce() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/exactlyOnce.kt");
            }

            @Test
            @TestMetadata("flow.kt")
            public void testFlow() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/flow.kt");
            }

            @Test
            @TestMetadata("inPlaceLambda.kt")
            public void testInPlaceLambda() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/inPlaceLambda.kt");
            }

            @Test
            @TestMetadata("infiniteLoop.kt")
            public void testInfiniteLoop() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/infiniteLoop.kt");
            }

            @Test
            @TestMetadata("namedArgument.kt")
            public void testNamedArgument() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/namedArgument.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/simple.kt");
            }

            @Test
            @TestMetadata("tryFinally.kt")
            public void testTryFinally() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/tryFinally.kt");
            }

            @Test
            @TestMetadata("unknown.kt")
            public void testUnknown() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/unknown.kt");
            }
          }

          @Nested
          @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies")
          @TestDataPath("$PROJECT_ROOT")
          public class ReturnsImplies {
            @Test
            public void testAllFilesPresentInReturnsImplies() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
            }

            @Test
            @TestMetadata("booleanOperators.kt")
            public void testBooleanOperators() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/booleanOperators.kt");
            }

            @Test
            @TestMetadata("conditionLogic.kt")
            public void testConditionLogic() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/conditionLogic.kt");
            }

            @Test
            @TestMetadata("eqNotEq.kt")
            public void testEqNotEq() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/eqNotEq.kt");
            }

            @Test
            @TestMetadata("inapplicable.kt")
            public void testInapplicable() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/inapplicable.kt");
            }

            @Test
            @TestMetadata("namedArguments.kt")
            public void testNamedArguments() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/namedArguments.kt");
            }

            @Test
            @TestMetadata("notNull.kt")
            public void testNotNull() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/notNull.kt");
            }

            @Test
            @TestMetadata("propertyAccessors.kt")
            public void testPropertyAccessors() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/propertyAccessors.kt");
            }

            @Test
            @TestMetadata("receivers.kt")
            public void testReceivers() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/receivers.kt");
            }

            @Test
            @TestMetadata("safeCall.kt")
            public void testSafeCall() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/safeCall.kt");
            }

            @Test
            @TestMetadata("trickyCases.kt")
            public void testTrickyCases() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/trickyCases.kt");
            }

            @Test
            @TestMetadata("typePredicate.kt")
            public void testTypePredicate() {
              runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/typePredicate.kt");
            }
          }

          @Nested
          @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts")
          @TestDataPath("$PROJECT_ROOT")
          public class VariousContracts {
            @Test
            public void testAllFilesPresentInVariousContracts() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts/newSyntax")
            @TestDataPath("$PROJECT_ROOT")
            public class NewSyntax {
              @Test
              public void testAllFilesPresentInNewSyntax() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts/newSyntax"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
              }

              @Test
              @TestMetadata("functionsWithContract.kt")
              public void testFunctionsWithContract() {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts/newSyntax/functionsWithContract.kt");
              }
            }
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates")
    @TestDataPath("$PROJECT_ROOT")
    public class Delegates {
      @Test
      public void testAllFilesPresentInDelegates() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("annotationArgumentMapping.kt")
      public void testAnnotationArgumentMapping() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/annotationArgumentMapping.kt");
      }

      @Test
      @TestMetadata("anonymousInDelegate.kt")
      public void testAnonymousInDelegate() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/anonymousInDelegate.kt");
      }

      @Test
      @TestMetadata("delegateTypeMismatch.kt")
      public void testDelegateTypeMismatch() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/delegateTypeMismatch.kt");
      }

      @Test
      @TestMetadata("delegateWithAnonymousObject.kt")
      public void testDelegateWithAnonymousObject() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/delegateWithAnonymousObject.kt");
      }

      @Test
      @TestMetadata("getClassLet.kt")
      public void testGetClassLet() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/getClassLet.kt");
      }

      @Test
      @TestMetadata("kt41917.kt")
      public void testKt41917() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/kt41917.kt");
      }

      @Test
      @TestMetadata("mapValuesLazy.kt")
      public void testMapValuesLazy() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/mapValuesLazy.kt");
      }

      @Test
      @TestMetadata("nullableTypeDelegate.kt")
      public void testNullableTypeDelegate() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/nullableTypeDelegate.kt");
      }

      @Test
      @TestMetadata("propertyWithFunctionalType.kt")
      public void testPropertyWithFunctionalType() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/propertyWithFunctionalType.kt");
      }

      @Test
      @TestMetadata("sequentialLazy.kt")
      public void testSequentialLazy() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/sequentialLazy.kt");
      }

      @Test
      @TestMetadata("simpleDelegateProvider.kt")
      public void testSimpleDelegateProvider() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/simpleDelegateProvider.kt");
      }

      @Test
      @TestMetadata("simpleDelegatedToMap.kt")
      public void testSimpleDelegatedToMap() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/simpleDelegatedToMap.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    public class Diagnostics {
      @Test
      public void testAllFilesPresentInDiagnostics() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("forLoopChecker.kt")
      public void testForLoopChecker() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/forLoopChecker.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/functionReturnTypeMismatchChecker")
      @TestDataPath("$PROJECT_ROOT")
      public class FunctionReturnTypeMismatchChecker {
        @Test
        public void testAllFilesPresentInFunctionReturnTypeMismatchChecker() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/functionReturnTypeMismatchChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("basic.kt")
        public void testBasic() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/functionReturnTypeMismatchChecker/basic.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/initializerTypeMismatchChecker")
      @TestDataPath("$PROJECT_ROOT")
      public class InitializerTypeMismatchChecker {
        @Test
        public void testAllFilesPresentInInitializerTypeMismatchChecker() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/initializerTypeMismatchChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("functionType.kt")
        public void testFunctionType() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/initializerTypeMismatchChecker/functionType.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference")
    @TestDataPath("$PROJECT_ROOT")
    public class Inference {
      @Test
      public void testAllFilesPresentInInference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("builderInference.kt")
      public void testBuilderInference() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/builderInference.kt");
      }

      @Test
      @TestMetadata("builderInferenceAndCoercionToUnit.kt")
      public void testBuilderInferenceAndCoercionToUnit() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/builderInferenceAndCoercionToUnit.kt");
      }

      @Test
      @TestMetadata("builderInferenceFromStdlib.kt")
      public void testBuilderInferenceFromStdlib() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/builderInferenceFromStdlib.kt");
      }

      @Test
      @TestMetadata("complexConstraintSystem.kt")
      public void testComplexConstraintSystem() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/complexConstraintSystem.kt");
      }

      @Test
      @TestMetadata("flexibleTypeInSystem.kt")
      public void testFlexibleTypeInSystem() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/flexibleTypeInSystem.kt");
      }

      @Test
      @TestMetadata("ifElvisReturn.kt")
      public void testIfElvisReturn() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/ifElvisReturn.kt");
      }

      @Test
      @TestMetadata("plusAssignWithLambdaInRhs.kt")
      public void testPlusAssignWithLambdaInRhs() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/plusAssignWithLambdaInRhs.kt");
      }

      @Test
      @TestMetadata("subAtomAlreadyInitialized.kt")
      public void testSubAtomAlreadyInitialized() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/subAtomAlreadyInitialized.kt");
      }

      @Test
      @TestMetadata("subAtomAlreadyInitialized2.kt")
      public void testSubAtomAlreadyInitialized2() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/subAtomAlreadyInitialized2.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems")
      @TestDataPath("$PROJECT_ROOT")
      public class Problems {
        @Test
        public void testAllFilesPresentInProblems() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("buildList.kt")
        public void testBuildList() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/buildList.kt");
        }

        @Test
        @TestMetadata("buildListLazy.kt")
        public void testBuildListLazy() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/buildListLazy.kt");
        }

        @Test
        @TestMetadata("buildSetWithVisitor.kt")
        public void testBuildSetWithVisitor() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/buildSetWithVisitor.kt");
        }

        @Test
        @TestMetadata("expectedType.kt")
        public void testExpectedType() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/expectedType.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/initialization")
    @TestDataPath("$PROJECT_ROOT")
    public class Initialization {
      @Test
      public void testAllFilesPresentInInitialization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/initialization"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("fromLocalMembers.kt")
      public void testFromLocalMembers() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/initialization/fromLocalMembers.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij")
    @TestDataPath("$PROJECT_ROOT")
    public class Intellij {
      @Test
      @TestMetadata("accessInSetter.kt")
      public void testAccessInSetter() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/accessInSetter.kt");
      }

      @Test
      public void testAllFilesPresentInIntellij() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("arrayOfImports.kt")
      public void testArrayOfImports() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/arrayOfImports.kt");
      }

      @Test
      @TestMetadata("baseIntrospector.kt")
      public void testBaseIntrospector() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/baseIntrospector.kt");
      }

      @Test
      @TestMetadata("DailyAggregatedDoubleFactor.kt")
      public void testDailyAggregatedDoubleFactor() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/DailyAggregatedDoubleFactor.kt");
      }

      @Test
      @TestMetadata("defaultParameterFromBase.kt")
      public void testDefaultParameterFromBase() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/defaultParameterFromBase.kt");
      }

      @Test
      @TestMetadata("EnumWithToString.kt")
      public void testEnumWithToString() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/EnumWithToString.kt");
      }

      @Test
      @TestMetadata("FieldVsSyntheticAccessor.kt")
      public void testFieldVsSyntheticAccessor() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/FieldVsSyntheticAccessor.kt");
      }

      @Test
      @TestMetadata("hideBySeverity.kt")
      public void testHideBySeverity() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/hideBySeverity.kt");
      }

      @Test
      @TestMetadata("InnerClassOfThrowableOnObject.kt")
      public void testInnerClassOfThrowableOnObject() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/InnerClassOfThrowableOnObject.kt");
      }

      @Test
      @TestMetadata("IntersectionWithJavaString.kt")
      public void testIntersectionWithJavaString() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/IntersectionWithJavaString.kt");
      }

      @Test
      @TestMetadata("lambdaForKfunction.kt")
      public void testLambdaForKfunction() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/lambdaForKfunction.kt");
      }

      @Test
      @TestMetadata("ParentOfType.kt")
      public void testParentOfType() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/ParentOfType.kt");
      }

      @Test
      @TestMetadata("PersistentStateComponent.kt")
      public void testPersistentStateComponent() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/PersistentStateComponent.kt");
      }

      @Test
      @TestMetadata("typeAliasAmbiguity.kt")
      public void testTypeAliasAmbiguity() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/typeAliasAmbiguity.kt");
      }

      @Test
      @TestMetadata("UastPatterns.kt")
      public void testUastPatterns() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/UastPatterns.kt");
      }

      @Test
      @TestMetadata("WithSpeedSearch.kt")
      public void testWithSpeedSearch() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/WithSpeedSearch.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k")
    @TestDataPath("$PROJECT_ROOT")
    public class J_k {
      @Test
      public void testAllFilesPresentInJ_k() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("AnnotationWithEnum.kt")
      public void testAnnotationWithEnum() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/AnnotationWithEnum.kt");
      }

      @Test
      @TestMetadata("BasicWithAnnotatedJava.kt")
      public void testBasicWithAnnotatedJava() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithAnnotatedJava.kt");
      }

      @Test
      @TestMetadata("BasicWithAnnotatedOverriddenJava.kt")
      public void testBasicWithAnnotatedOverriddenJava() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithAnnotatedOverriddenJava.kt");
      }

      @Test
      @TestMetadata("BasicWithJava.kt")
      public void testBasicWithJava() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithJava.kt");
      }

      @Test
      @TestMetadata("BasicWithJavaFakeOverride.kt")
      public void testBasicWithJavaFakeOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithJavaFakeOverride.kt");
      }

      @Test
      @TestMetadata("BasicWithPrimitiveJava.kt")
      public void testBasicWithPrimitiveJava() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithPrimitiveJava.kt");
      }

      @Test
      @TestMetadata("capturedFlexible.kt")
      public void testCapturedFlexible() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/capturedFlexible.kt");
      }

      @Test
      @TestMetadata("complexFlexibleInference.kt")
      public void testComplexFlexibleInference() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/complexFlexibleInference.kt");
      }

      @Test
      @TestMetadata("FieldAccessFromDerived.kt")
      public void testFieldAccessFromDerived() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FieldAccessFromDerived.kt");
      }

      @Test
      @TestMetadata("FieldAndGetter.kt")
      public void testFieldAndGetter() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FieldAndGetter.kt");
      }

      @Test
      @TestMetadata("fieldOverride.kt")
      public void testFieldOverride() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/fieldOverride.kt");
      }

      @Test
      @TestMetadata("FieldSubstitution.kt")
      public void testFieldSubstitution() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FieldSubstitution.kt");
      }

      @Test
      @TestMetadata("FlexiblePrimitiveOverloading.kt")
      public void testFlexiblePrimitiveOverloading() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FlexiblePrimitiveOverloading.kt");
      }

      @Test
      @TestMetadata("flexibleTypeAliases.kt")
      public void testFlexibleTypeAliases() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/flexibleTypeAliases.kt");
      }

      @Test
      @TestMetadata("FunctionTypeInJava.kt")
      public void testFunctionTypeInJava() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FunctionTypeInJava.kt");
      }

      @Test
      @TestMetadata("genericGetterForJavaOverriddenProperty.kt")
      public void testGenericGetterForJavaOverriddenProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/genericGetterForJavaOverriddenProperty.kt");
      }

      @Test
      @TestMetadata("genericGetterForJavaOverriddenProperty2.kt")
      public void testGenericGetterForJavaOverriddenProperty2() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/genericGetterForJavaOverriddenProperty2.kt");
      }

      @Test
      @TestMetadata("genericGetterForSyntheticProperty.kt")
      public void testGenericGetterForSyntheticProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/genericGetterForSyntheticProperty.kt");
      }

      @Test
      @TestMetadata("IntersectionTypesProblem.kt")
      public void testIntersectionTypesProblem() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/IntersectionTypesProblem.kt");
      }

      @Test
      @TestMetadata("JavaGetPrefixConflict.kt")
      public void testJavaGetPrefixConflict() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaGetPrefixConflict.kt");
      }

      @Test
      @TestMetadata("JavaInheritsKotlinDerived.kt")
      public void testJavaInheritsKotlinDerived() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsKotlinDerived.kt");
      }

      @Test
      @TestMetadata("JavaInheritsKotlinExtension.kt")
      public void testJavaInheritsKotlinExtension() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsKotlinExtension.kt");
      }

      @Test
      @TestMetadata("JavaInheritsKotlinProperty.kt")
      public void testJavaInheritsKotlinProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsKotlinProperty.kt");
      }

      @Test
      @TestMetadata("JavaInheritsRawKotlin.kt")
      public void testJavaInheritsRawKotlin() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsRawKotlin.kt");
      }

      @Test
      @TestMetadata("JavaSyntheticProperty.kt")
      public void testJavaSyntheticProperty() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaSyntheticProperty.kt");
      }

      @Test
      @TestMetadata("JavaVisibility2.kt")
      public void testJavaVisibility2() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaVisibility2.kt");
      }

      @Test
      @TestMetadata("KJKComplexHierarchy.kt")
      public void testKJKComplexHierarchy() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("KJKComplexHierarchyWithNested.kt")
      public void testKJKComplexHierarchyWithNested() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKComplexHierarchyWithNested.kt");
      }

      @Test
      @TestMetadata("KJKInheritance.kt")
      public void testKJKInheritance() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKInheritance.kt");
      }

      @Test
      @TestMetadata("KJKInheritanceGeneric.kt")
      public void testKJKInheritanceGeneric() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKInheritanceGeneric.kt");
      }

      @Test
      @TestMetadata("KotlinClassParameter.kt")
      public void testKotlinClassParameter() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KotlinClassParameter.kt");
      }

      @Test
      @TestMetadata("KotlinClassParameterGeneric.kt")
      public void testKotlinClassParameterGeneric() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KotlinClassParameterGeneric.kt");
      }

      @Test
      @TestMetadata("kt39076.kt")
      public void testKt39076() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/kt39076.kt");
      }

      @Test
      @TestMetadata("LoggerInstance.kt")
      public void testLoggerInstance() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/LoggerInstance.kt");
      }

      @Test
      @TestMetadata("MapCompute.kt")
      public void testMapCompute() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MapCompute.kt");
      }

      @Test
      @TestMetadata("MapEntry.kt")
      public void testMapEntry() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MapEntry.kt");
      }

      @Test
      @TestMetadata("mapMerge.kt")
      public void testMapMerge() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/mapMerge.kt");
      }

      @Test
      @TestMetadata("MyException.kt")
      public void testMyException() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MyException.kt");
      }

      @Test
      @TestMetadata("MyIterable.kt")
      public void testMyIterable() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MyIterable.kt");
      }

      @Test
      @TestMetadata("MyMap.kt")
      public void testMyMap() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MyMap.kt");
      }

      @Test
      @TestMetadata("outerInnerClasses.kt")
      public void testOuterInnerClasses() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/outerInnerClasses.kt");
      }

      @Test
      @TestMetadata("OverrideWithJava.kt")
      public void testOverrideWithJava() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/OverrideWithJava.kt");
      }

      @Test
      @TestMetadata("RawType.kt")
      public void testRawType() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/RawType.kt");
      }

      @Test
      @TestMetadata("serializableString.kt")
      public void testSerializableString() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/serializableString.kt");
      }

      @Test
      @TestMetadata("smartSet.kt")
      public void testSmartSet() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/smartSet.kt");
      }

      @Test
      @TestMetadata("StaticClassConstructorFromBaseClass.kt")
      public void testStaticClassConstructorFromBaseClass() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/StaticClassConstructorFromBaseClass.kt");
      }

      @Test
      @TestMetadata("StaticFromBaseClass.kt")
      public void testStaticFromBaseClass() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/StaticFromBaseClass.kt");
      }

      @Test
      @TestMetadata("StaticGenericMethod.kt")
      public void testStaticGenericMethod() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/StaticGenericMethod.kt");
      }

      @Test
      @TestMetadata("SyntheticAfterFiltering.kt")
      public void testSyntheticAfterFiltering() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/SyntheticAfterFiltering.kt");
      }

      @Test
      @TestMetadata("SyntheticWithForEach.kt")
      public void testSyntheticWithForEach() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/SyntheticWithForEach.kt");
      }

      @Test
      @TestMetadata("typeParameterUse.kt")
      public void testTypeParameterUse() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/typeParameterUse.kt");
      }

      @Test
      @TestMetadata("UsingObject.kt")
      public void testUsingObject() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/UsingObject.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule")
    @TestDataPath("$PROJECT_ROOT")
    public class MultiModule {
      @Test
      public void testAllFilesPresentInMultiModule() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("Basic.kt")
      public void testBasic() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/Basic.kt");
      }

      @Test
      @TestMetadata("FakeOverrides.kt")
      public void testFakeOverrides() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/FakeOverrides.kt");
      }

      @Test
      @TestMetadata("MemberType.kt")
      public void testMemberType() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/MemberType.kt");
      }

      @Test
      @TestMetadata("Members.kt")
      public void testMembers() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/Members.kt");
      }

      @Test
      @TestMetadata("SuperTypes.kt")
      public void testSuperTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/SuperTypes.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems")
    @TestDataPath("$PROJECT_ROOT")
    public class Problems {
      @Test
      @TestMetadata("AbstractToolConfig.kt")
      public void testAbstractToolConfig() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/AbstractToolConfig.kt");
      }

      @Test
      public void testAllFilesPresentInProblems() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("argumentTypeMismatch.kt")
      public void testArgumentTypeMismatch() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/argumentTypeMismatch.kt");
      }

      @Test
      @TestMetadata("capturedTypeInEquality.kt")
      public void testCapturedTypeInEquality() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/capturedTypeInEquality.kt");
      }

      @Test
      @TestMetadata("classCastWithRawKotlinType.kt")
      public void testClassCastWithRawKotlinType() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/classCastWithRawKotlinType.kt");
      }

      @Test
      @TestMetadata("DeepCopyIrTree.kt")
      public void testDeepCopyIrTree() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/DeepCopyIrTree.kt");
      }

      @Test
      @TestMetadata("definitelyNotNullCast.kt")
      public void testDefinitelyNotNullCast() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/definitelyNotNullCast.kt");
      }

      @Test
      @TestMetadata("EnumMapGet.kt")
      public void testEnumMapGet() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/EnumMapGet.kt");
      }

      @Test
      @TestMetadata("exceptionInRepeatedAnnotation.kt")
      public void testExceptionInRepeatedAnnotation() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/exceptionInRepeatedAnnotation.kt");
      }

      @Test
      @TestMetadata("falseSamConversion.kt")
      public void testFalseSamConversion() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/falseSamConversion.kt");
      }

      @Test
      @TestMetadata("FieldAnnotationWithClasses.kt")
      public void testFieldAnnotationWithClasses() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/FieldAnnotationWithClasses.kt");
      }

      @Test
      @TestMetadata("forEachOnZip.kt")
      public void testForEachOnZip() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/forEachOnZip.kt");
      }

      @Test
      @TestMetadata("immutableName.kt")
      public void testImmutableName() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/immutableName.kt");
      }

      @Test
      @TestMetadata("invokePriority.kt")
      public void testInvokePriority() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/invokePriority.kt");
      }

      @Test
      @TestMetadata("invokePriorityComplex.kt")
      public void testInvokePriorityComplex() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/invokePriorityComplex.kt");
      }

      @Test
      @TestMetadata("isAncestor.kt")
      public void testIsAncestor() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/isAncestor.kt");
      }

      @Test
      @TestMetadata("KJKComplexHierarchyNestedLoop.kt")
      public void testKJKComplexHierarchyNestedLoop() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/KJKComplexHierarchyNestedLoop.kt");
      }

      @Test
      @TestMetadata("KtFirCompositeScope.kt")
      public void testKtFirCompositeScope() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/KtFirCompositeScope.kt");
      }

      @Test
      @TestMetadata("lightMember.kt")
      public void testLightMember() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/lightMember.kt");
      }

      @Test
      @TestMetadata("localScopesInAnonymousObject.kt")
      public void testLocalScopesInAnonymousObject() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/localScopesInAnonymousObject.kt");
      }

      @Test
      @TestMetadata("malformedRawTypes.kt")
      public void testMalformedRawTypes() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/malformedRawTypes.kt");
      }

      @Test
      @TestMetadata("NamedParameterInConcurrentMap.kt")
      public void testNamedParameterInConcurrentMap() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/NamedParameterInConcurrentMap.kt");
      }

      @Test
      @TestMetadata("overriddenFunctionReturningUnit.kt")
      public void testOverriddenFunctionReturningUnit() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/overriddenFunctionReturningUnit.kt");
      }

      @Test
      @TestMetadata("overriddenFunctionReturningUnit2.kt")
      public void testOverriddenFunctionReturningUnit2() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/overriddenFunctionReturningUnit2.kt");
      }

      @Test
      @TestMetadata("qualifierPriority.kt")
      public void testQualifierPriority() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/qualifierPriority.kt");
      }

      @Test
      @TestMetadata("receiverResolutionInLambda.kt")
      public void testReceiverResolutionInLambda() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/receiverResolutionInLambda.kt");
      }

      @Test
      @TestMetadata("resolveToLocalFromCallSite.kt")
      public void testResolveToLocalFromCallSite() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/resolveToLocalFromCallSite.kt");
      }

      @Test
      @TestMetadata("selfReferenceToCompanionObject.kt")
      public void testSelfReferenceToCompanionObject() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/selfReferenceToCompanionObject.kt");
      }

      @Test
      @TestMetadata("SpecialCallsWithLambdas.kt")
      public void testSpecialCallsWithLambdas() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/SpecialCallsWithLambdas.kt");
      }

      @Test
      @TestMetadata("stringConstructors.kt")
      public void testStringConstructors() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/stringConstructors.kt");
      }

      @Test
      @TestMetadata("TypeVariablesInWrappedSamCall.kt")
      public void testTypeVariablesInWrappedSamCall() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/TypeVariablesInWrappedSamCall.kt");
      }

      @Test
      @TestMetadata("TypesEligibleForSimpleVisit.kt")
      public void testTypesEligibleForSimpleVisit() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/TypesEligibleForSimpleVisit.kt");
      }

      @Test
      @TestMetadata("valueOfOrNull.kt")
      public void testValueOfOrNull() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/valueOfOrNull.kt");
      }

      @Test
      @TestMetadata("weakHashMap.kt")
      public void testWeakHashMap() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/weakHashMap.kt");
      }

      @Test
      @TestMetadata("WithValidityAssertion.kt")
      public void testWithValidityAssertion() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/WithValidityAssertion.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties")
    @TestDataPath("$PROJECT_ROOT")
    public class Properties {
      @Test
      public void testAllFilesPresentInProperties() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("explicitBackingFieldUnsupported.kt")
      public void testExplicitBackingFieldUnsupported() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/explicitBackingFieldUnsupported.kt");
      }

      @Nested
      @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField")
      @TestDataPath("$PROJECT_ROOT")
      public class BackingField {
        @Test
        public void testAllFilesPresentInBackingField() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
        }

        @Test
        @TestMetadata("backingFieldModifiers.kt")
        public void testBackingFieldModifiers() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/backingFieldModifiers.kt");
        }

        @Test
        @TestMetadata("backingFieldVisibility.kt")
        public void testBackingFieldVisibility() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/backingFieldVisibility.kt");
        }

        @Test
        @TestMetadata("backingFieldWithSmartTypeParameters.kt")
        public void testBackingFieldWithSmartTypeParameters() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/backingFieldWithSmartTypeParameters.kt");
        }

        @Test
        @TestMetadata("explicitBackingFieldInInterface.kt")
        public void testExplicitBackingFieldInInterface() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/explicitBackingFieldInInterface.kt");
        }

        @Test
        @TestMetadata("explicitBackingFieldType.kt")
        public void testExplicitBackingFieldType() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/explicitBackingFieldType.kt");
        }

        @Test
        @TestMetadata("explicitBackingFieldsWithDelegates.kt")
        public void testExplicitBackingFieldsWithDelegates() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/explicitBackingFieldsWithDelegates.kt");
        }

        @Test
        @TestMetadata("filePrivateBackingFieldAccess.kt")
        public void testFilePrivateBackingFieldAccess() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/filePrivateBackingFieldAccess.kt");
        }

        @Test
        @TestMetadata("lateinitBackingFields.kt")
        public void testLateinitBackingFields() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/lateinitBackingFields.kt");
        }

        @Test
        @TestMetadata("localVariablesWithBackingFields.kt")
        public void testLocalVariablesWithBackingFields() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/localVariablesWithBackingFields.kt");
        }

        @Test
        @TestMetadata("overriddenPropertiesWithExplicitBackingFields.kt")
        public void testOverriddenPropertiesWithExplicitBackingFields() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/overriddenPropertiesWithExplicitBackingFields.kt");
        }

        @Test
        @TestMetadata("propertyTypeNarrowing.kt")
        public void testPropertyTypeNarrowing() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/propertyTypeNarrowing.kt");
        }

        @Test
        @TestMetadata("randomWeirdBackingFields.kt")
        public void testRandomWeirdBackingFields() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/randomWeirdBackingFields.kt");
        }

        @Test
        @TestMetadata("redundantExplicitBackingField.kt")
        public void testRedundantExplicitBackingField() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/redundantExplicitBackingField.kt");
        }

        @Test
        @TestMetadata("untypedPropertyWithBackingFieldUsage.kt")
        public void testUntypedPropertyWithBackingFieldUsage() {
          runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/untypedPropertyWithBackingFieldUsage.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/reinitializations")
    @TestDataPath("$PROJECT_ROOT")
    public class Reinitializations {
      @Test
      public void testAllFilesPresentInReinitializations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/reinitializations"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("constructorVarWrite.kt")
      public void testConstructorVarWrite() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/reinitializations/constructorVarWrite.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts")
    @TestDataPath("$PROJECT_ROOT")
    public class Smartcasts {
      @Test
      public void testAllFilesPresentInSmartcasts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true, "lightTree");
      }

      @Test
      @TestMetadata("assertIs.kt")
      public void testAssertIs() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts/assertIs.kt");
      }

      @Test
      @TestMetadata("tryWithLambdaInside.kt")
      public void testTryWithLambdaInside() {
        runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts/tryWithLambdaInside.kt");
      }
    }
  }
}
