/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/psiBasedContainingClass")
@TestDataPath("$PROJECT_ROOT")
public class SourcePsiBasedContainingClassCalculatorConsistencyTestGenerated extends AbstractSourcePsiBasedContainingClassCalculatorConsistencyTest {
  @Test
  public void testAllFilesPresentInPsiBasedContainingClass() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/psiBasedContainingClass"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
  }

  @Test
  @TestMetadata("annotationClass.kt")
  public void testAnnotationClass() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/annotationClass.kt");
  }

  @Test
  @TestMetadata("anonymousFunction.kt")
  public void testAnonymousFunction() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/anonymousFunction.kt");
  }

  @Test
  @TestMetadata("classinitializer.kt")
  public void testClassinitializer() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/classinitializer.kt");
  }

  @Test
  @TestMetadata("companionObject.kt")
  public void testCompanionObject() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/companionObject.kt");
  }

  @Test
  @TestMetadata("danglingModifierLists.kt")
  public void testDanglingModifierLists() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/danglingModifierLists.kt");
  }

  @Test
  @TestMetadata("dataClass.kt")
  public void testDataClass() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/dataClass.kt");
  }

  @Test
  @TestMetadata("defaultAccessors.kt")
  public void testDefaultAccessors() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/defaultAccessors.kt");
  }

  @Test
  @TestMetadata("delegatedProperty.kt")
  public void testDelegatedProperty() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/delegatedProperty.kt");
  }

  @Test
  @TestMetadata("enumClass.kt")
  public void testEnumClass() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/enumClass.kt");
  }

  @Test
  @TestMetadata("genericClass.kt")
  public void testGenericClass() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/genericClass.kt");
  }

  @Test
  @TestMetadata("incompleteFunction.kt")
  public void testIncompleteFunction() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/incompleteFunction.kt");
  }

  @Test
  @TestMetadata("incompleteFunction2.kt")
  public void testIncompleteFunction2() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/incompleteFunction2.kt");
  }

  @Test
  @TestMetadata("lambda.kt")
  public void testLambda() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/lambda.kt");
  }

  @Test
  @TestMetadata("localClass.kt")
  public void testLocalClass() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/localClass.kt");
  }

  @Test
  @TestMetadata("localFunction.kt")
  public void testLocalFunction() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/localFunction.kt");
  }

  @Test
  @TestMetadata("localInnerClassWithCycle.kt")
  public void testLocalInnerClassWithCycle() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/localInnerClassWithCycle.kt");
  }

  @Test
  @TestMetadata("nestedClass.kt")
  public void testNestedClass() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/nestedClass.kt");
  }

  @Test
  @TestMetadata("noBodyAccessors.kt")
  public void testNoBodyAccessors() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/noBodyAccessors.kt");
  }

  @Test
  @TestMetadata("objectLiteral.kt")
  public void testObjectLiteral() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/objectLiteral.kt");
  }

  @Test
  @TestMetadata("primaryConstructor.kt")
  public void testPrimaryConstructor() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/primaryConstructor.kt");
  }

  @Test
  @TestMetadata("secondaryConstructor.kt")
  public void testSecondaryConstructor() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/secondaryConstructor.kt");
  }

  @Test
  @TestMetadata("simple.kt")
  public void testSimple() {
    runTest("analysis/low-level-api-fir/testData/psiBasedContainingClass/simple.kt");
  }
}
