/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors")
@TestDataPath("$PROJECT_ROOT")
public class SourceNonLocalDeclarationAnchorTestGenerated extends AbstractSourceNonLocalDeclarationAnchorTest {
  @Test
  public void testAllFilesPresentInNonLocalDeclarationAnchors() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
  }

  @Test
  @TestMetadata("classWithMembers.kt")
  public void testClassWithMembers() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/classWithMembers.kt");
  }

  @Test
  @TestMetadata("destructuringDeclarations.kt")
  public void testDestructuringDeclarations() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/destructuringDeclarations.kt");
  }

  @Test
  @TestMetadata("enumEntries.kt")
  public void testEnumEntries() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/enumEntries.kt");
  }

  @Test
  @TestMetadata("functionalType.kt")
  public void testFunctionalType() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/functionalType.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideAnnotationCall.kt")
  public void testLocalFunctionInsideAnnotationCall() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/localFunctionInsideAnnotationCall.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideFunctionLiteral.kt")
  public void testLocalFunctionInsideFunctionLiteral() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/localFunctionInsideFunctionLiteral.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideLambdaCallInsideStringTemplate.kt")
  public void testLocalFunctionInsideLambdaCallInsideStringTemplate() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/localFunctionInsideLambdaCallInsideStringTemplate.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideStringTemplate.kt")
  public void testLocalFunctionInsideStringTemplate() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/localFunctionInsideStringTemplate.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideSuperEntryCall.kt")
  public void testLocalFunctionInsideSuperEntryCall() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/localFunctionInsideSuperEntryCall.kt");
  }

  @Test
  @TestMetadata("topLevelProperty.kt")
  public void testTopLevelProperty() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/topLevelProperty.kt");
  }

  @Test
  @TestMetadata("typeParameters.kt")
  public void testTypeParameters() {
    runTest("analysis/low-level-api-fir/testData/nonLocalDeclarationAnchors/typeParameters.kt");
  }
}
