/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations")
@TestDataPath("$PROJECT_ROOT")
public class SourceLazyAnnotationsResolveTestGenerated extends AbstractSourceLazyAnnotationsResolveTest {
  @Test
  public void testAllFilesPresentInLazyAnnotations() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/annotations")
  @TestDataPath("$PROJECT_ROOT")
  public class Annotations {
    @Test
    public void testAllFilesPresentInAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/annotations"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("classWithRegularAnnotations.kt")
    public void testClassWithRegularAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/classWithRegularAnnotations.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsWithArguments.kt")
    public void testClassWithRegularAnnotationsWithArguments() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/classWithRegularAnnotationsWithArguments.kt");
    }

    @Test
    @TestMetadata("classWithoutAnnotations.kt")
    public void testClassWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/classWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameter.kt")
    public void testDataClassCopyParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/dataClassCopyParameter.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithExplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/dataClassCopyParameterWithExplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitUseSite.kt")
    public void testDataClassCopyParameterWithExplicitUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/dataClassCopyParameterWithExplicitUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithImplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithImplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/dataClassCopyParameterWithImplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("deprecation_class.kt")
    public void testDeprecation_class() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/deprecation_class.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations.kt")
    public void testFunctionWithRegularAndSpecialAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/functionWithRegularAndSpecialAnnotations.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotation.kt")
    public void testFunctionWithRegularAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/functionWithRegularAnnotation.kt");
    }

    @Test
    @TestMetadata("functionWithoutAnnotations.kt")
    public void testFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/functionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("jvmField_backingField.kt")
    public void testJvmField_backingField() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/jvmField_backingField.kt");
    }

    @Test
    @TestMetadata("jvmField_property.kt")
    public void testJvmField_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/jvmField_property.kt");
    }

    @Test
    @TestMetadata("jvmName_getter.kt")
    public void testJvmName_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/jvmName_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_getter.kt")
    public void testJvmName_getterOnProperty_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/jvmName_getterOnProperty_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_property.kt")
    public void testJvmName_getterOnProperty_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/jvmName_getterOnProperty_property.kt");
    }

    @Test
    @TestMetadata("jvmName_getter_property.kt")
    public void testJvmName_getter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/jvmName_getter_property.kt");
    }

    @Test
    @TestMetadata("jvmRecord.kt")
    public void testJvmRecord() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/jvmRecord.kt");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotation.kt")
    public void testLocalFunctionWithRegularAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/localFunctionWithRegularAnnotation.kt");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotations.kt")
    public void testLocalFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/localFunctionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("suppress_file.kt")
    public void testSuppress_file() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/suppress_file.kt");
    }

    @Test
    @TestMetadata("target.kt")
    public void testTarget() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/target.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_getter.kt")
    public void testVariableWithAnnotationOnGetter_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/variableWithAnnotationOnGetter_getter.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_property.kt")
    public void testVariableWithAnnotationOnGetter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/variableWithAnnotationOnGetter_property.kt");
    }

    @Test
    @TestMetadata("variableWithoutAnnotations.kt")
    public void testVariableWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/variableWithoutAnnotations.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/classIds")
  @TestDataPath("$PROJECT_ROOT")
  public class ClassIds {
    @Test
    public void testAllFilesPresentInClassIds() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/classIds"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("classWithRegularAnnotations.kt")
    public void testClassWithRegularAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/classWithRegularAnnotations.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsWithArguments.kt")
    public void testClassWithRegularAnnotationsWithArguments() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/classWithRegularAnnotationsWithArguments.kt");
    }

    @Test
    @TestMetadata("classWithoutAnnotations.kt")
    public void testClassWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/classWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameter.kt")
    public void testDataClassCopyParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/dataClassCopyParameter.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithExplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/dataClassCopyParameterWithExplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitUseSite.kt")
    public void testDataClassCopyParameterWithExplicitUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/dataClassCopyParameterWithExplicitUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithImplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithImplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/dataClassCopyParameterWithImplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("deprecation_class.kt")
    public void testDeprecation_class() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/deprecation_class.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations.kt")
    public void testFunctionWithRegularAndSpecialAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/functionWithRegularAndSpecialAnnotations.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotation.kt")
    public void testFunctionWithRegularAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/functionWithRegularAnnotation.kt");
    }

    @Test
    @TestMetadata("functionWithoutAnnotations.kt")
    public void testFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/functionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("jvmField_backingField.kt")
    public void testJvmField_backingField() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/jvmField_backingField.kt");
    }

    @Test
    @TestMetadata("jvmName_getter.kt")
    public void testJvmName_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/jvmName_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_getter.kt")
    public void testJvmName_getterOnProperty_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/jvmName_getterOnProperty_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_property.kt")
    public void testJvmName_getterOnProperty_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/jvmName_getterOnProperty_property.kt");
    }

    @Test
    @TestMetadata("jvmName_getter_property.kt")
    public void testJvmName_getter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/jvmName_getter_property.kt");
    }

    @Test
    @TestMetadata("jvmRecord.kt")
    public void testJvmRecord() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/jvmRecord.kt");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotation.kt")
    public void testLocalFunctionWithRegularAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/localFunctionWithRegularAnnotation.kt");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotations.kt")
    public void testLocalFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/localFunctionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("suppress_file.kt")
    public void testSuppress_file() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/suppress_file.kt");
    }

    @Test
    @TestMetadata("target.kt")
    public void testTarget() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/target.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_getter.kt")
    public void testVariableWithAnnotationOnGetter_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/variableWithAnnotationOnGetter_getter.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_property.kt")
    public void testVariableWithAnnotationOnGetter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/variableWithAnnotationOnGetter_property.kt");
    }

    @Test
    @TestMetadata("variableWithoutAnnotations.kt")
    public void testVariableWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/variableWithoutAnnotations.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/contains")
  @TestDataPath("$PROJECT_ROOT")
  public class Contains {
    @Test
    public void testAllFilesPresentInContains() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/contains"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsFalse.kt")
    public void testClassWithRegularAnnotationsFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/classWithRegularAnnotationsFalse.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsTrue.kt")
    public void testClassWithRegularAnnotationsTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/classWithRegularAnnotationsTrue.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsWithArgumentsFalse.kt")
    public void testClassWithRegularAnnotationsWithArgumentsFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/classWithRegularAnnotationsWithArgumentsFalse.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsWithArgumentsTrue.kt")
    public void testClassWithRegularAnnotationsWithArgumentsTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/classWithRegularAnnotationsWithArgumentsTrue.kt");
    }

    @Test
    @TestMetadata("classWithoutAnnotations.kt")
    public void testClassWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/classWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameter.kt")
    public void testDataClassCopyParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/dataClassCopyParameter.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithExplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/dataClassCopyParameterWithExplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitUseSite.kt")
    public void testDataClassCopyParameterWithExplicitUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/dataClassCopyParameterWithExplicitUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithImplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithImplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/dataClassCopyParameterWithImplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("deprecation_class.kt")
    public void testDeprecation_class() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/deprecation_class.kt");
    }

    @Test
    @TestMetadata("deprecation_classFalse.kt")
    public void testDeprecation_classFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/deprecation_classFalse.kt");
    }

    @Test
    @TestMetadata("falseTarget.kt")
    public void testFalseTarget() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/falseTarget.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations_regular.kt")
    public void testFunctionWithRegularAndSpecialAnnotations_regular() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithRegularAndSpecialAnnotations_regular.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations_special.kt")
    public void testFunctionWithRegularAndSpecialAnnotations_special() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithRegularAndSpecialAnnotations_special.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations_unrelated.kt")
    public void testFunctionWithRegularAndSpecialAnnotations_unrelated() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithRegularAndSpecialAnnotations_unrelated.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationFalse.kt")
    public void testFunctionWithRegularAnnotationFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithRegularAnnotationFalse.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationTrue.kt")
    public void testFunctionWithRegularAnnotationTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithRegularAnnotationTrue.kt");
    }

    @Test
    @TestMetadata("functionWithoutAnnotations.kt")
    public void testFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("jvmField_backingField.kt")
    public void testJvmField_backingField() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmField_backingField.kt");
    }

    @Test
    @TestMetadata("jvmField_property.kt")
    public void testJvmField_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmField_property.kt");
    }

    @Test
    @TestMetadata("jvmName_getter.kt")
    public void testJvmName_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmName_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_getter.kt")
    public void testJvmName_getterOnProperty_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmName_getterOnProperty_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_property.kt")
    public void testJvmName_getterOnProperty_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmName_getterOnProperty_property.kt");
    }

    @Test
    @TestMetadata("jvmName_getter_property.kt")
    public void testJvmName_getter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmName_getter_property.kt");
    }

    @Test
    @TestMetadata("jvmRecordFalse.kt")
    public void testJvmRecordFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmRecordFalse.kt");
    }

    @Test
    @TestMetadata("jvmRecordTrue.kt")
    public void testJvmRecordTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/jvmRecordTrue.kt");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationFalse.kt")
    public void testLocalFunctionWithRegularAnnotationFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/localFunctionWithRegularAnnotationFalse.kt");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationTrue.kt")
    public void testLocalFunctionWithRegularAnnotationTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/localFunctionWithRegularAnnotationTrue.kt");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotations.kt")
    public void testLocalFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/localFunctionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("suppress_fileFalse.kt")
    public void testSuppress_fileFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/suppress_fileFalse.kt");
    }

    @Test
    @TestMetadata("suppress_fileTrue.kt")
    public void testSuppress_fileTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/suppress_fileTrue.kt");
    }

    @Test
    @TestMetadata("target.kt")
    public void testTarget() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/target.kt");
    }

    @Test
    @TestMetadata("targetAndRegular_regular.kt")
    public void testTargetAndRegular_regular() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/targetAndRegular_regular.kt");
    }

    @Test
    @TestMetadata("targetAndRegular_target.kt")
    public void testTargetAndRegular_target() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/targetAndRegular_target.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_getter.kt")
    public void testVariableWithAnnotationOnGetter_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/variableWithAnnotationOnGetter_getter.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_property.kt")
    public void testVariableWithAnnotationOnGetter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/variableWithAnnotationOnGetter_property.kt");
    }

    @Test
    @TestMetadata("variableWithoutAnnotations.kt")
    public void testVariableWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/variableWithoutAnnotations.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/get")
  @TestDataPath("$PROJECT_ROOT")
  public class Get {
    @Test
    public void testAllFilesPresentInGet() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/get"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsFalse.kt")
    public void testClassWithRegularAnnotationsFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/classWithRegularAnnotationsFalse.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsTrue.kt")
    public void testClassWithRegularAnnotationsTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/classWithRegularAnnotationsTrue.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsWithArgumentsFalse.kt")
    public void testClassWithRegularAnnotationsWithArgumentsFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/classWithRegularAnnotationsWithArgumentsFalse.kt");
    }

    @Test
    @TestMetadata("classWithRegularAnnotationsWithArgumentsTrue.kt")
    public void testClassWithRegularAnnotationsWithArgumentsTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/classWithRegularAnnotationsWithArgumentsTrue.kt");
    }

    @Test
    @TestMetadata("classWithoutAnnotations.kt")
    public void testClassWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/classWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameter.kt")
    public void testDataClassCopyParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/dataClassCopyParameter.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithExplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/dataClassCopyParameterWithExplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithExplicitUseSite.kt")
    public void testDataClassCopyParameterWithExplicitUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/dataClassCopyParameterWithExplicitUseSite.kt");
    }

    @Test
    @TestMetadata("dataClassCopyParameterWithImplicitPropertyUseSite.kt")
    public void testDataClassCopyParameterWithImplicitPropertyUseSite() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/dataClassCopyParameterWithImplicitPropertyUseSite.kt");
    }

    @Test
    @TestMetadata("deprecation_class.kt")
    public void testDeprecation_class() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/deprecation_class.kt");
    }

    @Test
    @TestMetadata("deprecation_classFalse.kt")
    public void testDeprecation_classFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/deprecation_classFalse.kt");
    }

    @Test
    @TestMetadata("falseTarget.kt")
    public void testFalseTarget() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/falseTarget.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations_regular.kt")
    public void testFunctionWithRegularAndSpecialAnnotations_regular() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithRegularAndSpecialAnnotations_regular.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations_special.kt")
    public void testFunctionWithRegularAndSpecialAnnotations_special() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithRegularAndSpecialAnnotations_special.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAndSpecialAnnotations_unrelated.kt")
    public void testFunctionWithRegularAndSpecialAnnotations_unrelated() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithRegularAndSpecialAnnotations_unrelated.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationFalse.kt")
    public void testFunctionWithRegularAnnotationFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithRegularAnnotationFalse.kt");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationTrue.kt")
    public void testFunctionWithRegularAnnotationTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithRegularAnnotationTrue.kt");
    }

    @Test
    @TestMetadata("functionWithoutAnnotations.kt")
    public void testFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("jvmField_backingField.kt")
    public void testJvmField_backingField() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmField_backingField.kt");
    }

    @Test
    @TestMetadata("jvmField_property.kt")
    public void testJvmField_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmField_property.kt");
    }

    @Test
    @TestMetadata("jvmName_getter.kt")
    public void testJvmName_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmName_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_getter.kt")
    public void testJvmName_getterOnProperty_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmName_getterOnProperty_getter.kt");
    }

    @Test
    @TestMetadata("jvmName_getterOnProperty_property.kt")
    public void testJvmName_getterOnProperty_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmName_getterOnProperty_property.kt");
    }

    @Test
    @TestMetadata("jvmName_getter_property.kt")
    public void testJvmName_getter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmName_getter_property.kt");
    }

    @Test
    @TestMetadata("jvmRecordFalse.kt")
    public void testJvmRecordFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmRecordFalse.kt");
    }

    @Test
    @TestMetadata("jvmRecordTrue.kt")
    public void testJvmRecordTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/jvmRecordTrue.kt");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationFalse.kt")
    public void testLocalFunctionWithRegularAnnotationFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/localFunctionWithRegularAnnotationFalse.kt");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationTrue.kt")
    public void testLocalFunctionWithRegularAnnotationTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/localFunctionWithRegularAnnotationTrue.kt");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotations.kt")
    public void testLocalFunctionWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/localFunctionWithoutAnnotations.kt");
    }

    @Test
    @TestMetadata("suppress_fileFalse.kt")
    public void testSuppress_fileFalse() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/suppress_fileFalse.kt");
    }

    @Test
    @TestMetadata("suppress_fileTrue.kt")
    public void testSuppress_fileTrue() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/suppress_fileTrue.kt");
    }

    @Test
    @TestMetadata("target.kt")
    public void testTarget() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/target.kt");
    }

    @Test
    @TestMetadata("targetAndRegular_regular.kt")
    public void testTargetAndRegular_regular() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/targetAndRegular_regular.kt");
    }

    @Test
    @TestMetadata("targetAndRegular_target.kt")
    public void testTargetAndRegular_target() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/targetAndRegular_target.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_getter.kt")
    public void testVariableWithAnnotationOnGetter_getter() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/variableWithAnnotationOnGetter_getter.kt");
    }

    @Test
    @TestMetadata("variableWithAnnotationOnGetter_property.kt")
    public void testVariableWithAnnotationOnGetter_property() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/variableWithAnnotationOnGetter_property.kt");
    }

    @Test
    @TestMetadata("variableWithoutAnnotations.kt")
    public void testVariableWithoutAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/variableWithoutAnnotations.kt");
    }
  }
}
