/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation")
@TestDataPath("$PROJECT_ROOT")
public class SourceDeprecationsResolveTestGenerated extends AbstractSourceDeprecationsResolveTest {
  @Test
  public void testAllFilesPresentInLazyResolveDeprecation() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes")
  @TestDataPath("$PROJECT_ROOT")
  public class Classes {
    @Test
    public void testAllFilesPresentInClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("deprecated.kt")
    public void testDeprecated() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/deprecated.kt");
    }

    @Test
    @TestMetadata("deprecatedJava.kt")
    public void testDeprecatedJava() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/deprecatedJava.kt");
    }

    @Test
    @TestMetadata("noDeprecation.kt")
    public void testNoDeprecation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/noDeprecation.kt");
    }

    @Test
    @TestMetadata("randomAnnotation.kt")
    public void testRandomAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/randomAnnotation.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions")
  @TestDataPath("$PROJECT_ROOT")
  public class Functions {
    @Test
    public void testAllFilesPresentInFunctions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("deprecated.kt")
    public void testDeprecated() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/deprecated.kt");
    }

    @Test
    @TestMetadata("deprecatedJava.kt")
    public void testDeprecatedJava() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/deprecatedJava.kt");
    }

    @Test
    @TestMetadata("noDeprecation.kt")
    public void testNoDeprecation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/noDeprecation.kt");
    }

    @Test
    @TestMetadata("randomAnnotation.kt")
    public void testRandomAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/randomAnnotation.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java")
  @TestDataPath("$PROJECT_ROOT")
  public class Java {
    @Test
    public void testAllFilesPresentInJava() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("javaClass.kt")
    public void testJavaClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaClass.kt");
    }

    @Test
    @TestMetadata("javaClassNoComment.kt")
    public void testJavaClassNoComment() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaClassNoComment.kt");
    }

    @Test
    @TestMetadata("javaField.kt")
    public void testJavaField() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaField.kt");
    }

    @Test
    @TestMetadata("javaFieldNoComment.kt")
    public void testJavaFieldNoComment() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaFieldNoComment.kt");
    }

    @Test
    @TestMetadata("javaMethod.kt")
    public void testJavaMethod() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaMethod.kt");
    }

    @Test
    @TestMetadata("javaMethodNoComment.kt")
    public void testJavaMethodNoComment() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaMethodNoComment.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties")
  @TestDataPath("$PROJECT_ROOT")
  public class Properties {
    @Test
    public void testAllFilesPresentInProperties() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Nested
    @TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors")
    @TestDataPath("$PROJECT_ROOT")
    public class NoAcessors {
      @Test
      public void testAllFilesPresentInNoAcessors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
      }

      @Test
      @TestMetadata("deprecatedAnnotationPropertyNoAccessors.kt")
      public void testDeprecatedAnnotationPropertyNoAccessors() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors/deprecatedAnnotationPropertyNoAccessors.kt");
      }

      @Test
      @TestMetadata("noDeprecatedAnnotationPropertyNoAccessors.kt")
      public void testNoDeprecatedAnnotationPropertyNoAccessors() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors/noDeprecatedAnnotationPropertyNoAccessors.kt");
      }

      @Test
      @TestMetadata("randomAnnotationPropertyNoAccessors.kt")
      public void testRandomAnnotationPropertyNoAccessors() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors/randomAnnotationPropertyNoAccessors.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithAcessors {
      @Test
      public void testAllFilesPresentInWithAcessors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
      }

      @Test
      @TestMetadata("deprecatedFieldJava.kt")
      public void testDeprecatedFieldJava() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedFieldJava.kt");
      }

      @Test
      @TestMetadata("deprecatedGetter.kt")
      public void testDeprecatedGetter() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedGetter.kt");
      }

      @Test
      @TestMetadata("deprecatedGetterJava.kt")
      public void testDeprecatedGetterJava() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedGetterJava.kt");
      }

      @Test
      @TestMetadata("deprecatedProperty.kt")
      public void testDeprecatedProperty() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedProperty.kt");
      }

      @Test
      @TestMetadata("deprecatedPropertyJava.kt")
      public void testDeprecatedPropertyJava() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedPropertyJava.kt");
      }

      @Test
      @TestMetadata("deprecatedSetter.kt")
      public void testDeprecatedSetter() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedSetter.kt");
      }

      @Test
      @TestMetadata("deprecatedSetterJava.kt")
      public void testDeprecatedSetterJava() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedSetterJava.kt");
      }

      @Test
      @TestMetadata("noAnnotations.kt")
      public void testNoAnnotations() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/noAnnotations.kt");
      }

      @Test
      @TestMetadata("randomAnnotationGetter.kt")
      public void testRandomAnnotationGetter() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/randomAnnotationGetter.kt");
      }

      @Test
      @TestMetadata("randomAnnotationProperty.kt")
      public void testRandomAnnotationProperty() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/randomAnnotationProperty.kt");
      }

      @Test
      @TestMetadata("randomAnnotationSetter.kt")
      public void testRandomAnnotationSetter() {
        runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/randomAnnotationSetter.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeAliases {
    @Test
    public void testAllFilesPresentInTypeAliases() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("deprecated.kt")
    public void testDeprecated() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/deprecated.kt");
    }

    @Test
    @TestMetadata("deprecatedJava.kt")
    public void testDeprecatedJava() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/deprecatedJava.kt");
    }

    @Test
    @TestMetadata("noDeprecation.kt")
    public void testNoDeprecation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/noDeprecation.kt");
    }

    @Test
    @TestMetadata("randomAnnotation.kt")
    public void testRandomAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/randomAnnotation.kt");
    }
  }
}
