/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations")
@TestDataPath("$PROJECT_ROOT")
public class ScriptLazyAnnotationsResolveTestGenerated extends AbstractScriptLazyAnnotationsResolveTest {
  @Test
  public void testAllFilesPresentInLazyAnnotations() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/annotations")
  @TestDataPath("$PROJECT_ROOT")
  public class Annotations {
    @Test
    public void testAllFilesPresentInAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/annotations"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationScript.kts")
    public void testFunctionWithRegularAnnotationScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/functionWithRegularAnnotationScript.kts");
    }

    @Test
    @TestMetadata("functionWithoutAnnotationsScript.kts")
    public void testFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/functionWithoutAnnotationsScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationScript.kts")
    public void testLocalFunctionWithRegularAnnotationScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/localFunctionWithRegularAnnotationScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotationsScript.kts")
    public void testLocalFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/annotations/localFunctionWithoutAnnotationsScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/classIds")
  @TestDataPath("$PROJECT_ROOT")
  public class ClassIds {
    @Test
    public void testAllFilesPresentInClassIds() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/classIds"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationScript.kts")
    public void testFunctionWithRegularAnnotationScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/functionWithRegularAnnotationScript.kts");
    }

    @Test
    @TestMetadata("functionWithoutAnnotationsScript.kts")
    public void testFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/functionWithoutAnnotationsScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationScript.kts")
    public void testLocalFunctionWithRegularAnnotationScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/localFunctionWithRegularAnnotationScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotationsScript.kts")
    public void testLocalFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/classIds/localFunctionWithoutAnnotationsScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/contains")
  @TestDataPath("$PROJECT_ROOT")
  public class Contains {
    @Test
    public void testAllFilesPresentInContains() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/contains"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationFalseScript.kts")
    public void testFunctionWithRegularAnnotationFalseScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithRegularAnnotationFalseScript.kts");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationTrueScript.kts")
    public void testFunctionWithRegularAnnotationTrueScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithRegularAnnotationTrueScript.kts");
    }

    @Test
    @TestMetadata("functionWithoutAnnotationsScript.kts")
    public void testFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/functionWithoutAnnotationsScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationFalseScript.kts")
    public void testLocalFunctionWithRegularAnnotationFalseScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/localFunctionWithRegularAnnotationFalseScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationTrueScript.kts")
    public void testLocalFunctionWithRegularAnnotationTrueScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/localFunctionWithRegularAnnotationTrueScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotationsScript.kts")
    public void testLocalFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/contains/localFunctionWithoutAnnotationsScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyAnnotations/get")
  @TestDataPath("$PROJECT_ROOT")
  public class Get {
    @Test
    public void testAllFilesPresentInGet() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyAnnotations/get"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationFalseScript.kts")
    public void testFunctionWithRegularAnnotationFalseScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithRegularAnnotationFalseScript.kts");
    }

    @Test
    @TestMetadata("functionWithRegularAnnotationTrueScript.kts")
    public void testFunctionWithRegularAnnotationTrueScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithRegularAnnotationTrueScript.kts");
    }

    @Test
    @TestMetadata("functionWithoutAnnotationsScript.kts")
    public void testFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/functionWithoutAnnotationsScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationFalseScript.kts")
    public void testLocalFunctionWithRegularAnnotationFalseScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/localFunctionWithRegularAnnotationFalseScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithRegularAnnotationTrueScript.kts")
    public void testLocalFunctionWithRegularAnnotationTrueScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/localFunctionWithRegularAnnotationTrueScript.kts");
    }

    @Test
    @TestMetadata("localFunctionWithoutAnnotationsScript.kts")
    public void testLocalFunctionWithoutAnnotationsScript() {
      runTest("analysis/low-level-api-fir/testData/lazyAnnotations/get/localFunctionWithoutAnnotationsScript.kts");
    }
  }
}
