/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir")
@TestDataPath("$PROJECT_ROOT")
public class ScriptGetOrBuildFirTestGenerated extends AbstractScriptGetOrBuildFirTest {
  @Test
  public void testAllFilesPresentInGetOrBuildFir() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/annotations")
  @TestDataPath("$PROJECT_ROOT")
  public class Annotations {
    @Test
    public void testAllFilesPresentInAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/annotations"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("annotationApplicationArgumentOnStatement.kts")
    public void testAnnotationApplicationArgumentOnStatement() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationArgumentOnStatement.kts");
    }

    @Test
    @TestMetadata("annotationApplicationArgumentScript.kts")
    public void testAnnotationApplicationArgumentScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationArgumentScript.kts");
    }

    @Test
    @TestMetadata("annotationApplicationCallExpressionScript.kts")
    public void testAnnotationApplicationCallExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationCallExpressionScript.kts");
    }

    @Test
    @TestMetadata("annotationOnReturnTypeScript.kts")
    public void testAnnotationOnReturnTypeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationOnReturnTypeScript.kts");
    }

    @Test
    @TestMetadata("destructuringAnnotation.kts")
    public void testDestructuringAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/destructuringAnnotation.kts");
    }

    @Test
    @TestMetadata("destructuringEntryAnnotation.kts")
    public void testDestructuringEntryAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/destructuringEntryAnnotation.kts");
    }

    @Test
    @TestMetadata("fileAnnotation2Script.kts")
    public void testFileAnnotation2Script() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/fileAnnotation2Script.kts");
    }

    @Test
    @TestMetadata("fileAnnotationScript.kts")
    public void testFileAnnotationScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/fileAnnotationScript.kts");
    }

    @Test
    @TestMetadata("retentionValueScript.kts")
    public void testRetentionValueScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/retentionValueScript.kts");
    }

    @Test
    @TestMetadata("statementAnnotation.kts")
    public void testStatementAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/statementAnnotation.kts");
    }

    @Test
    @TestMetadata("superCallAnnotationScript.kts")
    public void testSuperCallAnnotationScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/superCallAnnotationScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorParameterExpressionScript.kts")
    public void testTypeOnAnnotationOnConstructorParameterExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorParameterExpressionScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorParameterScript.kts")
    public void testTypeOnAnnotationOnConstructorParameterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorParameterScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorPropertyScript.kts")
    public void testTypeOnAnnotationOnConstructorPropertyScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorPropertyScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorPropertyWithArgumentsScript.kts")
    public void testTypeOnAnnotationOnConstructorPropertyWithArgumentsScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorPropertyWithArgumentsScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnFunctionParameterScript.kts")
    public void testTypeOnAnnotationOnFunctionParameterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnFunctionParameterScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnFunctionParameterWithArgumentsScript.kts")
    public void testTypeOnAnnotationOnFunctionParameterWithArgumentsScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnFunctionParameterWithArgumentsScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverFunctionScript.kts")
    public void testTypeOnAnnotationOnReceiverFunctionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverFunctionScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverParameterScript.kts")
    public void testTypeOnAnnotationOnReceiverParameterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverParameterScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverPropertyCallScript.kts")
    public void testTypeOnAnnotationOnReceiverPropertyCallScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverPropertyCallScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverPropertyScript.kts")
    public void testTypeOnAnnotationOnReceiverPropertyScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverPropertyScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReturnFunctionScript.kts")
    public void testTypeOnAnnotationOnReturnFunctionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReturnFunctionScript.kts");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReturnPropertyScript.kts")
    public void testTypeOnAnnotationOnReturnPropertyScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReturnPropertyScript.kts");
    }

    @Nested
    @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite")
    @TestDataPath("$PROJECT_ROOT")
    public class UseSite {
      @Test
      public void testAllFilesPresentInUseSite() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
      }

      @Test
      @TestMetadata("delegateScript.kts")
      public void testDelegateScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/delegateScript.kts");
      }

      @Test
      @TestMetadata("fieldScript.kts")
      public void testFieldScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/fieldScript.kts");
      }

      @Test
      @TestMetadata("fileScript.kts")
      public void testFileScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/fileScript.kts");
      }

      @Test
      @TestMetadata("getterScript.kts")
      public void testGetterScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/getterScript.kts");
      }

      @Test
      @TestMetadata("paramScript.kts")
      public void testParamScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/paramScript.kts");
      }

      @Test
      @TestMetadata("propertyScript.kts")
      public void testPropertyScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/propertyScript.kts");
      }

      @Test
      @TestMetadata("setParamScript.kts")
      public void testSetParamScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/setParamScript.kts");
      }

      @Test
      @TestMetadata("setterScript.kts")
      public void testSetterScript() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/setterScript.kts");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/calls")
  @TestDataPath("$PROJECT_ROOT")
  public class Calls {
    @Test
    public void testAllFilesPresentInCalls() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/calls"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("argsFromFunction.kts")
    public void testArgsFromFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/argsFromFunction.kts");
    }

    @Test
    @TestMetadata("argsFromInit.kts")
    public void testArgsFromInit() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/argsFromInit.kts");
    }

    @Test
    @TestMetadata("argsFromMemberFunction.kts")
    public void testArgsFromMemberFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/argsFromMemberFunction.kts");
    }

    @Test
    @TestMetadata("argsFromMemberProperty.kts")
    public void testArgsFromMemberProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/argsFromMemberProperty.kts");
    }

    @Test
    @TestMetadata("argsFromProperty.kts")
    public void testArgsFromProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/argsFromProperty.kts");
    }

    @Test
    @TestMetadata("argsFromStatement.kts")
    public void testArgsFromStatement() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/argsFromStatement.kts");
    }

    @Test
    @TestMetadata("callArgumentScript.kts")
    public void testCallArgumentScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callArgumentScript.kts");
    }

    @Test
    @TestMetadata("callInsideLambdaInsideSuperCallAndExplicitConstructorScript.kts")
    public void testCallInsideLambdaInsideSuperCallAndExplicitConstructorScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallAndExplicitConstructorScript.kts");
    }

    @Test
    @TestMetadata("callOnePropertyFromAnother.kts")
    public void testCallOnePropertyFromAnother() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callOnePropertyFromAnother.kts");
    }

    @Test
    @TestMetadata("calllTypeArgumentsScript.kts")
    public void testCalllTypeArgumentsScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/calllTypeArgumentsScript.kts");
    }

    @Test
    @TestMetadata("compoundAssignOnVarScript.kts")
    public void testCompoundAssignOnVarScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVarScript.kts");
    }

    @Test
    @TestMetadata("compoundAssignWithArrayAccessConventionScript.kts")
    public void testCompoundAssignWithArrayAccessConventionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayAccessConventionScript.kts");
    }

    @Test
    @TestMetadata("compoundAssignWithArrayGetConventionScript.kts")
    public void testCompoundAssignWithArrayGetConventionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayGetConventionScript.kts");
    }

    @Test
    @TestMetadata("constructorDelegationSuperCallScript.kts")
    public void testConstructorDelegationSuperCallScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/constructorDelegationSuperCallScript.kts");
    }

    @Test
    @TestMetadata("functionCallArgumentListScript.kts")
    public void testFunctionCallArgumentListScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/functionCallArgumentListScript.kts");
    }

    @Test
    @TestMetadata("invokeCallArgumentListScript.kts")
    public void testInvokeCallArgumentListScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/invokeCallArgumentListScript.kts");
    }

    @Test
    @TestMetadata("qualifiedCallInsideSuperCallScript.kts")
    public void testQualifiedCallInsideSuperCallScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCallScript.kts");
    }

    @Test
    @TestMetadata("setOperatorScript.kts")
    public void testSetOperatorScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/setOperatorScript.kts");
    }

    @Test
    @TestMetadata("superTypeScript.kts")
    public void testSuperTypeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/superTypeScript.kts");
    }

    @Test
    @TestMetadata("syntheticResultDeclaration.kts")
    public void testSyntheticResultDeclaration() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/syntheticResultDeclaration.kts");
    }

    @Test
    @TestMetadata("syntheticResultDeclarationInitializer.kts")
    public void testSyntheticResultDeclarationInitializer() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/syntheticResultDeclarationInitializer.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/declarations")
  @TestDataPath("$PROJECT_ROOT")
  public class Declarations {
    @Test
    public void testAllFilesPresentInDeclarations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/declarations"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("constructorParameterScript.kts")
    public void testConstructorParameterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/constructorParameterScript.kts");
    }

    @Test
    @TestMetadata("constructorPropertyScript.kts")
    public void testConstructorPropertyScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/constructorPropertyScript.kts");
    }

    @Test
    @TestMetadata("destructionWithNoRValueScript.kts")
    public void testDestructionWithNoRValueScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructionWithNoRValueScript.kts");
    }

    @Test
    @TestMetadata("destructuringEntryScript.kts")
    public void testDestructuringEntryScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructuringEntryScript.kts");
    }

    @Test
    @TestMetadata("destructuringScript.kts")
    public void testDestructuringScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructuringScript.kts");
    }

    @Test
    @TestMetadata("objectLiteralExpressionScript.kts")
    public void testObjectLiteralExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/objectLiteralExpressionScript.kts");
    }

    @Test
    @TestMetadata("objectLiteralScript.kts")
    public void testObjectLiteralScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/objectLiteralScript.kts");
    }

    @Test
    @TestMetadata("propertyDelegateScript.kts")
    public void testPropertyDelegateScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/propertyDelegateScript.kts");
    }

    @Test
    @TestMetadata("whereClause1Script.kts")
    public void testWhereClause1Script() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/whereClause1Script.kts");
    }

    @Test
    @TestMetadata("whereClause2Script.kts")
    public void testWhereClause2Script() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/whereClause2Script.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/deserialized")
  @TestDataPath("$PROJECT_ROOT")
  public class Deserialized {
    @Test
    public void testAllFilesPresentInDeserialized() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/deserialized"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring")
  @TestDataPath("$PROJECT_ROOT")
  public class Destructuring {
    @Test
    public void testAllFilesPresentInDestructuring() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/expressions")
  @TestDataPath("$PROJECT_ROOT")
  public class Expressions {
    @Test
    public void testAllFilesPresentInExpressions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/expressions"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("arrayAccessExpressionScript.kts")
    public void testArrayAccessExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/arrayAccessExpressionScript.kts");
    }

    @Test
    @TestMetadata("arrayIndexExpressionWithIncScript.kts")
    public void testArrayIndexExpressionWithIncScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/arrayIndexExpressionWithIncScript.kts");
    }

    @Test
    @TestMetadata("assignment.kts")
    public void testAssignment() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/assignment.kts");
    }

    @Test
    @TestMetadata("binaryExpressionOperatorScript.kts")
    public void testBinaryExpressionOperatorScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/binaryExpressionOperatorScript.kts");
    }

    @Test
    @TestMetadata("binaryExpressionScript.kts")
    public void testBinaryExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/binaryExpressionScript.kts");
    }

    @Test
    @TestMetadata("blockExpressionScript.kts")
    public void testBlockExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/blockExpressionScript.kts");
    }

    @Test
    @TestMetadata("boolLiteralScript.kts")
    public void testBoolLiteralScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/boolLiteralScript.kts");
    }

    @Test
    @TestMetadata("callInsideFunction.kts")
    public void testCallInsideFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/callInsideFunction.kts");
    }

    @Test
    @TestMetadata("callInsideStatement.kts")
    public void testCallInsideStatement() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/callInsideStatement.kts");
    }

    @Test
    @TestMetadata("firstStatement.kts")
    public void testFirstStatement() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/firstStatement.kts");
    }

    @Test
    @TestMetadata("firstStatementCall.kts")
    public void testFirstStatementCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/firstStatementCall.kts");
    }

    @Test
    @TestMetadata("forExpressionRangeScript.kts")
    public void testForExpressionRangeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpressionRangeScript.kts");
    }

    @Test
    @TestMetadata("forExpressionScript.kts")
    public void testForExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpressionScript.kts");
    }

    @Test
    @TestMetadata("forExpressionVariableScript.kts")
    public void testForExpressionVariableScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpressionVariableScript.kts");
    }

    @Test
    @TestMetadata("ifExpressionScript.kts")
    public void testIfExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/ifExpressionScript.kts");
    }

    @Test
    @TestMetadata("incExpressionScript.kts")
    public void testIncExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/incExpressionScript.kts");
    }

    @Test
    @TestMetadata("insidePlusAssignTargetScript.kts")
    public void testInsidePlusAssignTargetScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/insidePlusAssignTargetScript.kts");
    }

    @Test
    @TestMetadata("intLiteralScript.kts")
    public void testIntLiteralScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteralScript.kts");
    }

    @Test
    @TestMetadata("isExpressionScript.kts")
    public void testIsExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/isExpressionScript.kts");
    }

    @Test
    @TestMetadata("objectLiteralExpressionScript.kts")
    public void testObjectLiteralExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/objectLiteralExpressionScript.kts");
    }

    @Test
    @TestMetadata("parenthesizedExpressionScript.kts")
    public void testParenthesizedExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/parenthesizedExpressionScript.kts");
    }

    @Test
    @TestMetadata("secondStatement.kts")
    public void testSecondStatement() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/secondStatement.kts");
    }

    @Test
    @TestMetadata("secondStatementCall.kts")
    public void testSecondStatementCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/secondStatementCall.kts");
    }

    @Test
    @TestMetadata("stringLiteralScript.kts")
    public void testStringLiteralScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/stringLiteralScript.kts");
    }

    @Test
    @TestMetadata("stringTemplateExpressionEntryScript.kts")
    public void testStringTemplateExpressionEntryScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/stringTemplateExpressionEntryScript.kts");
    }

    @Test
    @TestMetadata("throwExpressionScript.kts")
    public void testThrowExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/throwExpressionScript.kts");
    }

    @Test
    @TestMetadata("tryExpressionScript.kts")
    public void testTryExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/tryExpressionScript.kts");
    }

    @Test
    @TestMetadata("whenExpressionScript.kts")
    public void testWhenExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/whenExpressionScript.kts");
    }

    @Test
    @TestMetadata("whileExpressionScript.kts")
    public void testWhileExpressionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/whileExpressionScript.kts");
    }

    @Test
    @TestMetadata("wholeStringTemplateScript.kts")
    public void testWholeStringTemplateScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/wholeStringTemplateScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/inImport")
  @TestDataPath("$PROJECT_ROOT")
  public class InImport {
    @Test
    public void testAllFilesPresentInInImport() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/inImport"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("firstImportNamePartScript.kts")
    public void testFirstImportNamePartScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/firstImportNamePartScript.kts");
    }

    @Test
    @TestMetadata("importListScript.kts")
    public void testImportListScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/importListScript.kts");
    }

    @Test
    @TestMetadata("middleImportNamePartScript.kts")
    public void testMiddleImportNamePartScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/middleImportNamePartScript.kts");
    }

    @Test
    @TestMetadata("qualifiedImportNamePartScript.kts")
    public void testQualifiedImportNamePartScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/qualifiedImportNamePartScript.kts");
    }

    @Test
    @TestMetadata("wholeImportDirectiveScript.kts")
    public void testWholeImportDirectiveScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/wholeImportDirectiveScript.kts");
    }

    @Test
    @TestMetadata("wholeImportNameScript.kts")
    public void testWholeImportNameScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/wholeImportNameScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage")
  @TestDataPath("$PROJECT_ROOT")
  public class InPackage {
    @Test
    public void testAllFilesPresentInInPackage() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("firstPackageNamePartScript.kts")
    public void testFirstPackageNamePartScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/firstPackageNamePartScript.kts");
    }

    @Test
    @TestMetadata("middlePackageNamePartScript.kts")
    public void testMiddlePackageNamePartScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/middlePackageNamePartScript.kts");
    }

    @Test
    @TestMetadata("qualifiedPackageNamePartScript.kts")
    public void testQualifiedPackageNamePartScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/qualifiedPackageNamePartScript.kts");
    }

    @Test
    @TestMetadata("wholePackageDirectiveScript.kts")
    public void testWholePackageDirectiveScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/wholePackageDirectiveScript.kts");
    }

    @Test
    @TestMetadata("wholePackageNameScript.kts")
    public void testWholePackageNameScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/wholePackageNameScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode")
  @TestDataPath("$PROJECT_ROOT")
  public class InvalidCode {
    @Test
    public void testAllFilesPresentInInvalidCode() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions")
  @TestDataPath("$PROJECT_ROOT")
  public class QualifiedExpressions {
    @Test
    public void testAllFilesPresentInQualifiedExpressions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("firstPartOfQualifiedCallWithNestedClassesScript.kts")
    public void testFirstPartOfQualifiedCallWithNestedClassesScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/firstPartOfQualifiedCallWithNestedClassesScript.kts");
    }

    @Test
    @TestMetadata("qualifiedPartOfQualifiedCallUnresolvedScript.kts")
    public void testQualifiedPartOfQualifiedCallUnresolvedScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/qualifiedPartOfQualifiedCallUnresolvedScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/types")
  @TestDataPath("$PROJECT_ROOT")
  public class Types {
    @Test
    public void testAllFilesPresentInTypes() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/types"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("functionalTypeScript.kts")
    public void testFunctionalTypeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/functionalTypeScript.kts");
    }

    @Test
    @TestMetadata("nestedClassTypeScript.kts")
    public void testNestedClassTypeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nestedClassTypeScript.kts");
    }

    @Test
    @TestMetadata("nullableTypeScript.kts")
    public void testNullableTypeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nullableTypeScript.kts");
    }

    @Test
    @TestMetadata("receiverTypeScript.kts")
    public void testReceiverTypeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/receiverTypeScript.kts");
    }

    @Test
    @TestMetadata("wholeTypeScript.kts")
    public void testWholeTypeScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/wholeTypeScript.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration")
  @TestDataPath("$PROJECT_ROOT")
  public class WholeDeclaration {
    @Test
    public void testAllFilesPresentInWholeDeclaration() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
    }

    @Test
    @TestMetadata("assignmentStatement.kts")
    public void testAssignmentStatement() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/assignmentStatement.kts");
    }

    @Test
    @TestMetadata("class.kts")
    public void testClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/class.kts");
    }

    @Test
    @TestMetadata("classTypeParemeterScript.kts")
    public void testClassTypeParemeterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/classTypeParemeterScript.kts");
    }

    @Test
    @TestMetadata("enumEntryScript.kts")
    public void testEnumEntryScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/enumEntryScript.kts");
    }

    @Test
    @TestMetadata("fileAnnotationListScript.kts")
    public void testFileAnnotationListScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/fileAnnotationListScript.kts");
    }

    @Test
    @TestMetadata("fileAnnotationScript.kts")
    public void testFileAnnotationScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/fileAnnotationScript.kts");
    }

    @Test
    @TestMetadata("function.kts")
    public void testFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/function.kts");
    }

    @Test
    @TestMetadata("getterScript.kts")
    public void testGetterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/getterScript.kts");
    }

    @Test
    @TestMetadata("localClassScript.kts")
    public void testLocalClassScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localClassScript.kts");
    }

    @Test
    @TestMetadata("localFunctionScript.kts")
    public void testLocalFunctionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localFunctionScript.kts");
    }

    @Test
    @TestMetadata("localPropertyScript.kts")
    public void testLocalPropertyScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localPropertyScript.kts");
    }

    @Test
    @TestMetadata("memberFunctionScript.kts")
    public void testMemberFunctionScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberFunctionScript.kts");
    }

    @Test
    @TestMetadata("memberPropertyScript.kts")
    public void testMemberPropertyScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberPropertyScript.kts");
    }

    @Test
    @TestMetadata("memberTypeAliasScript.kts")
    public void testMemberTypeAliasScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberTypeAliasScript.kts");
    }

    @Test
    @TestMetadata("nestedClassScript.kts")
    public void testNestedClassScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/nestedClassScript.kts");
    }

    @Test
    @TestMetadata("primaryConstructorValueParameterScript.kts")
    public void testPrimaryConstructorValueParameterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/primaryConstructorValueParameterScript.kts");
    }

    @Test
    @TestMetadata("scriptInitializer.kts")
    public void testScriptInitializer() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/scriptInitializer.kts");
    }

    @Test
    @TestMetadata("secondaryConstructorValueParameterScript.kts")
    public void testSecondaryConstructorValueParameterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/secondaryConstructorValueParameterScript.kts");
    }

    @Test
    @TestMetadata("setterScript.kts")
    public void testSetterScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/setterScript.kts");
    }

    @Test
    @TestMetadata("statement.kts")
    public void testStatement() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/statement.kts");
    }

    @Test
    @TestMetadata("topLevelPropertyScript.kts")
    public void testTopLevelPropertyScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelPropertyScript.kts");
    }

    @Test
    @TestMetadata("topLevelTypelTypeAliasScript.kts")
    public void testTopLevelTypelTypeAliasScript() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelTypelTypeAliasScript.kts");
    }
  }
}
