/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir")
@TestDataPath("$PROJECT_ROOT")
public class OutOfContentRootGetOrBuildFirTestGenerated extends AbstractOutOfContentRootGetOrBuildFirTest {
  @Test
  public void testAllFilesPresentInGetOrBuildFir() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
  }

  @Test
  @TestMetadata("kt60638.kt")
  public void testKt60638() {
    runTest("analysis/low-level-api-fir/testData/getOrBuildFir/kt60638.kt");
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/annotations")
  @TestDataPath("$PROJECT_ROOT")
  public class Annotations {
    @Test
    public void testAllFilesPresentInAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/annotations"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("annotationApplicationArgument.kt")
    public void testAnnotationApplicationArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationArgument.kt");
    }

    @Test
    @TestMetadata("annotationApplicationArgumentList.kt")
    public void testAnnotationApplicationArgumentList() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationArgumentList.kt");
    }

    @Test
    @TestMetadata("annotationApplicationCallExpression.kt")
    public void testAnnotationApplicationCallExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationCallExpression.kt");
    }

    @Test
    @TestMetadata("annotationApplicationVarargArgument.kt")
    public void testAnnotationApplicationVarargArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationVarargArgument.kt");
    }

    @Test
    @TestMetadata("annotationApplicationWithArguments.kt")
    public void testAnnotationApplicationWithArguments() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationWithArguments.kt");
    }

    @Test
    @TestMetadata("annotationApplicationWithArgumentsOnCallSite.kt")
    public void testAnnotationApplicationWithArgumentsOnCallSite() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationWithArgumentsOnCallSite.kt");
    }

    @Test
    @TestMetadata("annotationInsideWhereClass.kt")
    public void testAnnotationInsideWhereClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationInsideWhereClass.kt");
    }

    @Test
    @TestMetadata("annotationInsideWhereFunction.kt")
    public void testAnnotationInsideWhereFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationInsideWhereFunction.kt");
    }

    @Test
    @TestMetadata("annotationInsideWhereProperty.kt")
    public void testAnnotationInsideWhereProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationInsideWhereProperty.kt");
    }

    @Test
    @TestMetadata("annotationOnConstructorProperty.kt")
    public void testAnnotationOnConstructorProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationOnConstructorProperty.kt");
    }

    @Test
    @TestMetadata("annotationOnEnumClass.kt")
    public void testAnnotationOnEnumClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationOnEnumClass.kt");
    }

    @Test
    @TestMetadata("annotationOnReturnType.kt")
    public void testAnnotationOnReturnType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationOnReturnType.kt");
    }

    @Test
    @TestMetadata("danglingAnnotation.kt")
    public void testDanglingAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/danglingAnnotation.kt");
    }

    @Test
    @TestMetadata("danglingAnnotationInClass.kt")
    public void testDanglingAnnotationInClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/danglingAnnotationInClass.kt");
    }

    @Test
    @TestMetadata("fileAnnotation.kt")
    public void testFileAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/fileAnnotation.kt");
    }

    @Test
    @TestMetadata("fileAnnotation2.kt")
    public void testFileAnnotation2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/fileAnnotation2.kt");
    }

    @Test
    @TestMetadata("jvmFieldAnnotationOnConstructorProperty.kt")
    public void testJvmFieldAnnotationOnConstructorProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/jvmFieldAnnotationOnConstructorProperty.kt");
    }

    @Test
    @TestMetadata("retentionValue.kt")
    public void testRetentionValue() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/retentionValue.kt");
    }

    @Test
    @TestMetadata("superCallAnnotation.kt")
    public void testSuperCallAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/superCallAnnotation.kt");
    }

    @Test
    @TestMetadata("superCallAnnotation2.kt")
    public void testSuperCallAnnotation2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/superCallAnnotation2.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorParameter.kt")
    public void testTypeOnAnnotationOnConstructorParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorParameter.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorParameterExpression.kt")
    public void testTypeOnAnnotationOnConstructorParameterExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorParameterExpression.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorProperty.kt")
    public void testTypeOnAnnotationOnConstructorProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorProperty.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorPropertyAndParameter.kt")
    public void testTypeOnAnnotationOnConstructorPropertyAndParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorPropertyAndParameter.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnConstructorPropertyWithArguments.kt")
    public void testTypeOnAnnotationOnConstructorPropertyWithArguments() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorPropertyWithArguments.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnFunctionParameter.kt")
    public void testTypeOnAnnotationOnFunctionParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnFunctionParameter.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnFunctionParameterWithArguments.kt")
    public void testTypeOnAnnotationOnFunctionParameterWithArguments() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnFunctionParameterWithArguments.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverFunction.kt")
    public void testTypeOnAnnotationOnReceiverFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverFunction.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverParameter.kt")
    public void testTypeOnAnnotationOnReceiverParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverParameter.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverProperty.kt")
    public void testTypeOnAnnotationOnReceiverProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverProperty.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReceiverPropertyCall.kt")
    public void testTypeOnAnnotationOnReceiverPropertyCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverPropertyCall.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReturnFunction.kt")
    public void testTypeOnAnnotationOnReturnFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReturnFunction.kt");
    }

    @Test
    @TestMetadata("typeOnAnnotationOnReturnProperty.kt")
    public void testTypeOnAnnotationOnReturnProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReturnProperty.kt");
    }

    @Nested
    @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite")
    @TestDataPath("$PROJECT_ROOT")
    public class UseSite {
      @Test
      public void testAllFilesPresentInUseSite() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
      }

      @Test
      @TestMetadata("delegate.kt")
      public void testDelegate() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/delegate.kt");
      }

      @Test
      @TestMetadata("field.kt")
      public void testField() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/field.kt");
      }

      @Test
      @TestMetadata("file.kt")
      public void testFile() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/file.kt");
      }

      @Test
      @TestMetadata("getter.kt")
      public void testGetter() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/getter.kt");
      }

      @Test
      @TestMetadata("param.kt")
      public void testParam() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/param.kt");
      }

      @Test
      @TestMetadata("property.kt")
      public void testProperty() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/property.kt");
      }

      @Test
      @TestMetadata("setParam.kt")
      public void testSetParam() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/setParam.kt");
      }

      @Test
      @TestMetadata("setter.kt")
      public void testSetter() {
        runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/setter.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/calls")
  @TestDataPath("$PROJECT_ROOT")
  public class Calls {
    @Test
    public void testAllFilesPresentInCalls() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/calls"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("arrayAssignOperatorAsSingleExpressionInIf.kt")
    public void testArrayAssignOperatorAsSingleExpressionInIf() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/arrayAssignOperatorAsSingleExpressionInIf.kt");
    }

    @Test
    @TestMetadata("arrayAssignOperatorAsSingleExpressionInWhen.kt")
    public void testArrayAssignOperatorAsSingleExpressionInWhen() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/arrayAssignOperatorAsSingleExpressionInWhen.kt");
    }

    @Test
    @TestMetadata("arrayMinusAssignOperatorsInVariousScopes.kt")
    public void testArrayMinusAssignOperatorsInVariousScopes() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/arrayMinusAssignOperatorsInVariousScopes.kt");
    }

    @Test
    @TestMetadata("arrayTimesAssignOperatorsInVariousScopes.kt")
    public void testArrayTimesAssignOperatorsInVariousScopes() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/arrayTimesAssignOperatorsInVariousScopes.kt");
    }

    @Test
    @TestMetadata("callArgument.kt")
    public void testCallArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callArgument.kt");
    }

    @Test
    @TestMetadata("callInsideLambdaInsideSuperCallAndExplicitConstructor.kt")
    public void testCallInsideLambdaInsideSuperCallAndExplicitConstructor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallAndExplicitConstructor.kt");
    }

    @Test
    @TestMetadata("callInsideLambdaInsideSuperCallAndImplicitConstructor.kt")
    public void testCallInsideLambdaInsideSuperCallAndImplicitConstructor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallAndImplicitConstructor.kt");
    }

    @Test
    @TestMetadata("callInsideLambdaInsideSuperCallFromSecondaryConstructor.kt")
    public void testCallInsideLambdaInsideSuperCallFromSecondaryConstructor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallFromSecondaryConstructor.kt");
    }

    @Test
    @TestMetadata("callInsideLambdaInsideSuperCallFromSingleSecondaryConstructor.kt")
    public void testCallInsideLambdaInsideSuperCallFromSingleSecondaryConstructor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallFromSingleSecondaryConstructor.kt");
    }

    @Test
    @TestMetadata("callInsideLambdaInsideSuperCallInsideImplicitConstructor.kt")
    public void testCallInsideLambdaInsideSuperCallInsideImplicitConstructor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallInsideImplicitConstructor.kt");
    }

    @Test
    @TestMetadata("calllTypeArguments.kt")
    public void testCalllTypeArguments() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/calllTypeArguments.kt");
    }

    @Test
    @TestMetadata("compoundAssignOnVal.kt")
    public void testCompoundAssignOnVal() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVal.kt");
    }

    @Test
    @TestMetadata("compoundAssignOnVal_lhs.kt")
    public void testCompoundAssignOnVal_lhs() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVal_lhs.kt");
    }

    @Test
    @TestMetadata("compoundAssignOnVar.kt")
    public void testCompoundAssignOnVar() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVar.kt");
    }

    @Test
    @TestMetadata("compoundAssignOnVar_lhs.kt")
    public void testCompoundAssignOnVar_lhs() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVar_lhs.kt");
    }

    @Test
    @TestMetadata("compoundAssignWithArrayAccessConvention.kt")
    public void testCompoundAssignWithArrayAccessConvention() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayAccessConvention.kt");
    }

    @Test
    @TestMetadata("compoundAssignWithArrayAccessConvention_lhs.kt")
    public void testCompoundAssignWithArrayAccessConvention_lhs() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayAccessConvention_lhs.kt");
    }

    @Test
    @TestMetadata("compoundAssignWithArrayAccessConvention_propertyAccess.kt")
    public void testCompoundAssignWithArrayAccessConvention_propertyAccess() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayAccessConvention_propertyAccess.kt");
    }

    @Test
    @TestMetadata("compoundAssignWithArrayGetConvention.kt")
    public void testCompoundAssignWithArrayGetConvention() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayGetConvention.kt");
    }

    @Test
    @TestMetadata("compoundAssignWithArrayGetConvention_lhs.kt")
    public void testCompoundAssignWithArrayGetConvention_lhs() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayGetConvention_lhs.kt");
    }

    @Test
    @TestMetadata("constructorDelegationSuperCall.kt")
    public void testConstructorDelegationSuperCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/constructorDelegationSuperCall.kt");
    }

    @Test
    @TestMetadata("constructorDelegationThisCall.kt")
    public void testConstructorDelegationThisCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/constructorDelegationThisCall.kt");
    }

    @Test
    @TestMetadata("functionCallArgumentList.kt")
    public void testFunctionCallArgumentList() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/functionCallArgumentList.kt");
    }

    @Test
    @TestMetadata("functionWithNestedJavaClass.kt")
    public void testFunctionWithNestedJavaClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/functionWithNestedJavaClass.kt");
    }

    @Test
    @TestMetadata("functionWithNestedJavaClass2.kt")
    public void testFunctionWithNestedJavaClass2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/functionWithNestedJavaClass2.kt");
    }

    @Test
    @TestMetadata("incWithArrayAccessConvention.kt")
    public void testIncWithArrayAccessConvention() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/incWithArrayAccessConvention.kt");
    }

    @Test
    @TestMetadata("incWithArrayAccessConvention_propertyAccess.kt")
    public void testIncWithArrayAccessConvention_propertyAccess() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/incWithArrayAccessConvention_propertyAccess.kt");
    }

    @Test
    @TestMetadata("incWithArrayAccessConvention_set.kt")
    public void testIncWithArrayAccessConvention_set() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/incWithArrayAccessConvention_set.kt");
    }

    @Test
    @TestMetadata("invokeCallArgumentList.kt")
    public void testInvokeCallArgumentList() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/invokeCallArgumentList.kt");
    }

    @Test
    @TestMetadata("noReceiverOnLambda.kt")
    public void testNoReceiverOnLambda() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/noReceiverOnLambda.kt");
    }

    @Test
    @TestMetadata("qualifiedCallInsidePropertyInsideConstructor.kt")
    public void testQualifiedCallInsidePropertyInsideConstructor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsidePropertyInsideConstructor.kt");
    }

    @Test
    @TestMetadata("qualifiedCallInsideSuperCall.kt")
    public void testQualifiedCallInsideSuperCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall.kt");
    }

    @Test
    @TestMetadata("qualifiedCallInsideSuperCall2.kt")
    public void testQualifiedCallInsideSuperCall2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall2.kt");
    }

    @Test
    @TestMetadata("qualifiedCallInsideSuperCall3.kt")
    public void testQualifiedCallInsideSuperCall3() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall3.kt");
    }

    @Test
    @TestMetadata("qualifiedCallInsideSuperCall4.kt")
    public void testQualifiedCallInsideSuperCall4() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall4.kt");
    }

    @Test
    @TestMetadata("qualifiedCallInsideSuperCall5.kt")
    public void testQualifiedCallInsideSuperCall5() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall5.kt");
    }

    @Test
    @TestMetadata("qualifiedCallSelector.kt")
    public void testQualifiedCallSelector() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallSelector.kt");
    }

    @Test
    @TestMetadata("qualifiedReferenceSelector.kt")
    public void testQualifiedReferenceSelector() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedReferenceSelector.kt");
    }

    @Test
    @TestMetadata("qualifiedWholeCall.kt")
    public void testQualifiedWholeCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedWholeCall.kt");
    }

    @Test
    @TestMetadata("qualifiedWholeReferenceSelector.kt")
    public void testQualifiedWholeReferenceSelector() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedWholeReferenceSelector.kt");
    }

    @Test
    @TestMetadata("safeQualifiedCallSelector.kt")
    public void testSafeQualifiedCallSelector() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/safeQualifiedCallSelector.kt");
    }

    @Test
    @TestMetadata("safeQualifiedReferenceSelector.kt")
    public void testSafeQualifiedReferenceSelector() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/safeQualifiedReferenceSelector.kt");
    }

    @Test
    @TestMetadata("safeQualifiedWholeCall.kt")
    public void testSafeQualifiedWholeCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/safeQualifiedWholeCall.kt");
    }

    @Test
    @TestMetadata("safeQualifiedWholeReferenceSelector.kt")
    public void testSafeQualifiedWholeReferenceSelector() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/safeQualifiedWholeReferenceSelector.kt");
    }

    @Test
    @TestMetadata("setOperator.kt")
    public void testSetOperator() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/setOperator.kt");
    }

    @Test
    @TestMetadata("superType.kt")
    public void testSuperType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/superType.kt");
    }

    @Test
    @TestMetadata("whenConditionInRange.kt")
    public void testWhenConditionInRange() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/whenConditionInRange.kt");
    }

    @Test
    @TestMetadata("whenConditionInRangeInverted.kt")
    public void testWhenConditionInRangeInverted() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/whenConditionInRangeInverted.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/declarations")
  @TestDataPath("$PROJECT_ROOT")
  public class Declarations {
    @Test
    public void testAllFilesPresentInDeclarations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/declarations"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("constructorParameter.kt")
    public void testConstructorParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/constructorParameter.kt");
    }

    @Test
    @TestMetadata("constructorProperty.kt")
    public void testConstructorProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/constructorProperty.kt");
    }

    @Test
    @TestMetadata("destructionWithNoRValue.kt")
    public void testDestructionWithNoRValue() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructionWithNoRValue.kt");
    }

    @Test
    @TestMetadata("destructuring.kt")
    public void testDestructuring() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructuring.kt");
    }

    @Test
    @TestMetadata("destructuringEntry.kt")
    public void testDestructuringEntry() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructuringEntry.kt");
    }

    @Test
    @TestMetadata("initializerConflict.kt")
    public void testInitializerConflict() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/initializerConflict.kt");
    }

    @Test
    @TestMetadata("kt60387.kt")
    public void testKt60387() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/kt60387.kt");
    }

    @Test
    @TestMetadata("ktij23263.kt")
    public void testKtij23263() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/ktij23263.kt");
    }

    @Test
    @TestMetadata("ktij24730.kt")
    public void testKtij24730() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/ktij24730.kt");
    }

    @Test
    @TestMetadata("objectLiteral.kt")
    public void testObjectLiteral() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/objectLiteral.kt");
    }

    @Test
    @TestMetadata("objectLiteralExpression.kt")
    public void testObjectLiteralExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/objectLiteralExpression.kt");
    }

    @Test
    @TestMetadata("propertyDelegate.kt")
    public void testPropertyDelegate() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/propertyDelegate.kt");
    }

    @Test
    @TestMetadata("propertyDelegateExpression.kt")
    public void testPropertyDelegateExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/propertyDelegateExpression.kt");
    }

    @Test
    @TestMetadata("whereClause1.kt")
    public void testWhereClause1() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/whereClause1.kt");
    }

    @Test
    @TestMetadata("whereClause2.kt")
    public void testWhereClause2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/whereClause2.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/deserialized")
  @TestDataPath("$PROJECT_ROOT")
  public class Deserialized {
    @Test
    public void testAllFilesPresentInDeserialized() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/deserialized"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("annotationWithEnumEntryArgument.kt")
    public void testAnnotationWithEnumEntryArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/deserialized/annotationWithEnumEntryArgument.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring")
  @TestDataPath("$PROJECT_ROOT")
  public class Destructuring {
    @Test
    public void testAllFilesPresentInDestructuring() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("destructuringDeclaration.kt")
    public void testDestructuringDeclaration() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/destructuringDeclaration.kt");
    }

    @Test
    @TestMetadata("destructuringDeclarationInLambda.kt")
    public void testDestructuringDeclarationInLambda() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/destructuringDeclarationInLambda.kt");
    }

    @Test
    @TestMetadata("destructuringDeclarationParameterInLambda.kt")
    public void testDestructuringDeclarationParameterInLambda() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/destructuringDeclarationParameterInLambda.kt");
    }

    @Test
    @TestMetadata("entryInDestructuringDeclaration.kt")
    public void testEntryInDestructuringDeclaration() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryInDestructuringDeclaration.kt");
    }

    @Test
    @TestMetadata("entryInDestructuringDeclarationParameterInLambda.kt")
    public void testEntryInDestructuringDeclarationParameterInLambda() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryInDestructuringDeclarationParameterInLambda.kt");
    }

    @Test
    @TestMetadata("entryUnderscoreInDestructuringDeclaration.kt")
    public void testEntryUnderscoreInDestructuringDeclaration() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryUnderscoreInDestructuringDeclaration.kt");
    }

    @Test
    @TestMetadata("entryUnderscoreInDestructuringDeclarationParameterInLambda.kt")
    public void testEntryUnderscoreInDestructuringDeclarationParameterInLambda() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryUnderscoreInDestructuringDeclarationParameterInLambda.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/expressions")
  @TestDataPath("$PROJECT_ROOT")
  public class Expressions {
    @Test
    public void testAllFilesPresentInExpressions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/expressions"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("arrayAccessExpression.kt")
    public void testArrayAccessExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/arrayAccessExpression.kt");
    }

    @Test
    @TestMetadata("arrayIndexExpressionWithInc.kt")
    public void testArrayIndexExpressionWithInc() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/arrayIndexExpressionWithInc.kt");
    }

    @Test
    @TestMetadata("asExpression.kt")
    public void testAsExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/asExpression.kt");
    }

    @Test
    @TestMetadata("binaryExpression.kt")
    public void testBinaryExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/binaryExpression.kt");
    }

    @Test
    @TestMetadata("binaryExpressionOperator.kt")
    public void testBinaryExpressionOperator() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/binaryExpressionOperator.kt");
    }

    @Test
    @TestMetadata("blockExpression.kt")
    public void testBlockExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/blockExpression.kt");
    }

    @Test
    @TestMetadata("boolLiteral.kt")
    public void testBoolLiteral() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/boolLiteral.kt");
    }

    @Test
    @TestMetadata("classAccessExpression.kt")
    public void testClassAccessExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/classAccessExpression.kt");
    }

    @Test
    @TestMetadata("forExpression.kt")
    public void testForExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpression.kt");
    }

    @Test
    @TestMetadata("forExpressionRange.kt")
    public void testForExpressionRange() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpressionRange.kt");
    }

    @Test
    @TestMetadata("forExpressionVariable.kt")
    public void testForExpressionVariable() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpressionVariable.kt");
    }

    @Test
    @TestMetadata("functionWithPostDecPropertyArgument.kt")
    public void testFunctionWithPostDecPropertyArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/functionWithPostDecPropertyArgument.kt");
    }

    @Test
    @TestMetadata("functionWithPostIncPropertyArgument.kt")
    public void testFunctionWithPostIncPropertyArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/functionWithPostIncPropertyArgument.kt");
    }

    @Test
    @TestMetadata("functionWithPreDecArrayAccessArgument.kt")
    public void testFunctionWithPreDecArrayAccessArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/functionWithPreDecArrayAccessArgument.kt");
    }

    @Test
    @TestMetadata("functionWithPreDecPropertyArgument.kt")
    public void testFunctionWithPreDecPropertyArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/functionWithPreDecPropertyArgument.kt");
    }

    @Test
    @TestMetadata("functionWithPreIncArrayAccessArgument.kt")
    public void testFunctionWithPreIncArrayAccessArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/functionWithPreIncArrayAccessArgument.kt");
    }

    @Test
    @TestMetadata("functionWithPreIncPropertyArgument.kt")
    public void testFunctionWithPreIncPropertyArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/functionWithPreIncPropertyArgument.kt");
    }

    @Test
    @TestMetadata("functionWithPropertyArgument.kt")
    public void testFunctionWithPropertyArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/functionWithPropertyArgument.kt");
    }

    @Test
    @TestMetadata("ifExpression.kt")
    public void testIfExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/ifExpression.kt");
    }

    @Test
    @TestMetadata("incExpression.kt")
    public void testIncExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/incExpression.kt");
    }

    @Test
    @TestMetadata("insidePlusAssignTarget.kt")
    public void testInsidePlusAssignTarget() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/insidePlusAssignTarget.kt");
    }

    @Test
    @TestMetadata("intLiteral.kt")
    public void testIntLiteral() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral.kt");
    }

    @Test
    @TestMetadata("intLiteral_minusOne_entire.kt")
    public void testIntLiteral_minusOne_entire() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_minusOne_entire.kt");
    }

    @Test
    @TestMetadata("intLiteral_minusOne_justOne.kt")
    public void testIntLiteral_minusOne_justOne() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_minusOne_justOne.kt");
    }

    @Test
    @TestMetadata("intLiteral_plusOne_entire.kt")
    public void testIntLiteral_plusOne_entire() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_plusOne_entire.kt");
    }

    @Test
    @TestMetadata("intLiteral_plusOne_justOne.kt")
    public void testIntLiteral_plusOne_justOne() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_plusOne_justOne.kt");
    }

    @Test
    @TestMetadata("isExpression.kt")
    public void testIsExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/isExpression.kt");
    }

    @Test
    @TestMetadata("lambdaExpression.kt")
    public void testLambdaExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/lambdaExpression.kt");
    }

    @Test
    @TestMetadata("objectLiteralExpression.kt")
    public void testObjectLiteralExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/objectLiteralExpression.kt");
    }

    @Test
    @TestMetadata("parenthesizedExpression.kt")
    public void testParenthesizedExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/parenthesizedExpression.kt");
    }

    @Test
    @TestMetadata("propertyReferenceExpression.kt")
    public void testPropertyReferenceExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/propertyReferenceExpression.kt");
    }

    @Test
    @TestMetadata("stringLiteral.kt")
    public void testStringLiteral() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/stringLiteral.kt");
    }

    @Test
    @TestMetadata("stringTemplateExpressionEntry.kt")
    public void testStringTemplateExpressionEntry() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/stringTemplateExpressionEntry.kt");
    }

    @Test
    @TestMetadata("thisExpression_anonymous_reference.kt")
    public void testThisExpression_anonymous_reference() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_anonymous_reference.kt");
    }

    @Test
    @TestMetadata("thisExpression_anonymous_this.kt")
    public void testThisExpression_anonymous_this() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_anonymous_this.kt");
    }

    @Test
    @TestMetadata("thisExpression_arrayAccessConvention_reference.kt")
    public void testThisExpression_arrayAccessConvention_reference() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_arrayAccessConvention_reference.kt");
    }

    @Test
    @TestMetadata("thisExpression_arrayAccessConvention_this.kt")
    public void testThisExpression_arrayAccessConvention_this() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_arrayAccessConvention_this.kt");
    }

    @Test
    @TestMetadata("thisExpression_plusAssignWithArrayGetConvention_reference.kt")
    public void testThisExpression_plusAssignWithArrayGetConvention_reference() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_plusAssignWithArrayGetConvention_reference.kt");
    }

    @Test
    @TestMetadata("thisExpression_plusAssignWithArrayGetConvention_this.kt")
    public void testThisExpression_plusAssignWithArrayGetConvention_this() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_plusAssignWithArrayGetConvention_this.kt");
    }

    @Test
    @TestMetadata("thisExpression_plusAssign_reference.kt")
    public void testThisExpression_plusAssign_reference() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_plusAssign_reference.kt");
    }

    @Test
    @TestMetadata("thisExpression_plusAssign_this.kt")
    public void testThisExpression_plusAssign_this() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_plusAssign_this.kt");
    }

    @Test
    @TestMetadata("thisExpression_regular_reference.kt")
    public void testThisExpression_regular_reference() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_regular_reference.kt");
    }

    @Test
    @TestMetadata("thisExpression_regular_this.kt")
    public void testThisExpression_regular_this() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/thisExpression_regular_this.kt");
    }

    @Test
    @TestMetadata("throwExpression.kt")
    public void testThrowExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/throwExpression.kt");
    }

    @Test
    @TestMetadata("tryExpression.kt")
    public void testTryExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/tryExpression.kt");
    }

    @Test
    @TestMetadata("unraryExpression.kt")
    public void testUnraryExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/unraryExpression.kt");
    }

    @Test
    @TestMetadata("unraryExpressionOperator.kt")
    public void testUnraryExpressionOperator() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/unraryExpressionOperator.kt");
    }

    @Test
    @TestMetadata("whenExpression.kt")
    public void testWhenExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/whenExpression.kt");
    }

    @Test
    @TestMetadata("whileExpression.kt")
    public void testWhileExpression() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/whileExpression.kt");
    }

    @Test
    @TestMetadata("wholeStringTemplate.kt")
    public void testWholeStringTemplate() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/wholeStringTemplate.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/inImport")
  @TestDataPath("$PROJECT_ROOT")
  public class InImport {
    @Test
    public void testAllFilesPresentInInImport() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/inImport"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("firstImportNamePart.kt")
    public void testFirstImportNamePart() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/firstImportNamePart.kt");
    }

    @Test
    @TestMetadata("importList.kt")
    public void testImportList() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/importList.kt");
    }

    @Test
    @TestMetadata("middleImportNamePart.kt")
    public void testMiddleImportNamePart() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/middleImportNamePart.kt");
    }

    @Test
    @TestMetadata("qualifiedImportNamePart.kt")
    public void testQualifiedImportNamePart() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/qualifiedImportNamePart.kt");
    }

    @Test
    @TestMetadata("wholeImportDirective.kt")
    public void testWholeImportDirective() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/wholeImportDirective.kt");
    }

    @Test
    @TestMetadata("wholeImportName.kt")
    public void testWholeImportName() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/wholeImportName.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage")
  @TestDataPath("$PROJECT_ROOT")
  public class InPackage {
    @Test
    public void testAllFilesPresentInInPackage() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("firstPackageNamePart.kt")
    public void testFirstPackageNamePart() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/firstPackageNamePart.kt");
    }

    @Test
    @TestMetadata("middlePackageNamePart.kt")
    public void testMiddlePackageNamePart() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/middlePackageNamePart.kt");
    }

    @Test
    @TestMetadata("qualifiedPackageNamePart.kt")
    public void testQualifiedPackageNamePart() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/qualifiedPackageNamePart.kt");
    }

    @Test
    @TestMetadata("wholePackageDirective.kt")
    public void testWholePackageDirective() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/wholePackageDirective.kt");
    }

    @Test
    @TestMetadata("wholePackageName.kt")
    public void testWholePackageName() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/wholePackageName.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode")
  @TestDataPath("$PROJECT_ROOT")
  public class InvalidCode {
    @Test
    public void testAllFilesPresentInInvalidCode() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("delegatedProperty.kt")
    public void testDelegatedProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/delegatedProperty.kt");
    }

    @Test
    @TestMetadata("duplicatedClasses.kt")
    public void testDuplicatedClasses() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/duplicatedClasses.kt");
    }

    @Test
    @TestMetadata("duplicatedClassesFunctionParameter.kt")
    public void testDuplicatedClassesFunctionParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/duplicatedClassesFunctionParameter.kt");
    }

    @Test
    @TestMetadata("expectAndActualInTheSameFile.kt")
    public void testExpectAndActualInTheSameFile() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/expectAndActualInTheSameFile.kt");
    }

    @Test
    @TestMetadata("incompletePropertyWithAnnotation.kt")
    public void testIncompletePropertyWithAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/incompletePropertyWithAnnotation.kt");
    }

    @Test
    @TestMetadata("javaClassLiteral.kt")
    public void testJavaClassLiteral() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/javaClassLiteral.kt");
    }

    @Test
    @TestMetadata("labelMultiple.kt")
    public void testLabelMultiple() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/labelMultiple.kt");
    }

    @Test
    @TestMetadata("labelUnderscore.kt")
    public void testLabelUnderscore() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/labelUnderscore.kt");
    }

    @Test
    @TestMetadata("longStringTemplateEntryWithTwoExpressions.kt")
    public void testLongStringTemplateEntryWithTwoExpressions() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/longStringTemplateEntryWithTwoExpressions.kt");
    }

    @Test
    @TestMetadata("missedTypeArgumentsInAnnotationCall.kt")
    public void testMissedTypeArgumentsInAnnotationCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/missedTypeArgumentsInAnnotationCall.kt");
    }

    @Test
    @TestMetadata("secondaryConstructor.kt")
    public void testSecondaryConstructor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/secondaryConstructor.kt");
    }

    @Test
    @TestMetadata("setterWithoutBodyValueParameterType.kt")
    public void testSetterWithoutBodyValueParameterType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/setterWithoutBodyValueParameterType.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions")
  @TestDataPath("$PROJECT_ROOT")
  public class QualifiedExpressions {
    @Test
    public void testAllFilesPresentInQualifiedExpressions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("firstPartOfQualifiedCallWithNestedClasses.kt")
    public void testFirstPartOfQualifiedCallWithNestedClasses() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/firstPartOfQualifiedCallWithNestedClasses.kt");
    }

    @Test
    @TestMetadata("lastPartOfQualifiedCallWithNestedClasses.kt")
    public void testLastPartOfQualifiedCallWithNestedClasses() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/lastPartOfQualifiedCallWithNestedClasses.kt");
    }

    @Test
    @TestMetadata("middlePartOfQualifiedCallWithNestedClasses.kt")
    public void testMiddlePartOfQualifiedCallWithNestedClasses() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/middlePartOfQualifiedCallWithNestedClasses.kt");
    }

    @Test
    @TestMetadata("qualifiedPartOfQualifiedCallUnresolved.kt")
    public void testQualifiedPartOfQualifiedCallUnresolved() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/qualifiedPartOfQualifiedCallUnresolved.kt");
    }

    @Test
    @TestMetadata("qualifiedPartOfQualifiedCallWithNestedClasses.kt")
    public void testQualifiedPartOfQualifiedCallWithNestedClasses() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/qualifiedPartOfQualifiedCallWithNestedClasses.kt");
    }

    @Test
    @TestMetadata("refPartOfQualifiedTypeCall.kt")
    public void testRefPartOfQualifiedTypeCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/refPartOfQualifiedTypeCall.kt");
    }

    @Test
    @TestMetadata("typedQualifiedPartOfQualifiedCall.kt")
    public void testTypedQualifiedPartOfQualifiedCall() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/typedQualifiedPartOfQualifiedCall.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/types")
  @TestDataPath("$PROJECT_ROOT")
  public class Types {
    @Test
    public void testAllFilesPresentInTypes() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/types"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("functionWithDeprecatedJavaClass.kt")
    public void testFunctionWithDeprecatedJavaClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/functionWithDeprecatedJavaClass.kt");
    }

    @Test
    @TestMetadata("functionalType.kt")
    public void testFunctionalType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/functionalType.kt");
    }

    @Test
    @TestMetadata("functionalTypeArgument.kt")
    public void testFunctionalTypeArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/functionalTypeArgument.kt");
    }

    @Test
    @TestMetadata("functionalTypeInsideAlias.kt")
    public void testFunctionalTypeInsideAlias() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/functionalTypeInsideAlias.kt");
    }

    @Test
    @TestMetadata("invalidTypeArgumentsCount.kt")
    public void testInvalidTypeArgumentsCount() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCount.kt");
    }

    @Test
    @TestMetadata("invalidTypeArgumentsCountArgument.kt")
    public void testInvalidTypeArgumentsCountArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCountArgument.kt");
    }

    @Test
    @TestMetadata("invalidTypeArgumentsCountFirstArgument.kt")
    public void testInvalidTypeArgumentsCountFirstArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCountFirstArgument.kt");
    }

    @Test
    @TestMetadata("invalidTypeArgumentsCountLastArgument.kt")
    public void testInvalidTypeArgumentsCountLastArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCountLastArgument.kt");
    }

    @Test
    @TestMetadata("nestedClassFromJava.kt")
    public void testNestedClassFromJava() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nestedClassFromJava.kt");
    }

    @Test
    @TestMetadata("nestedClassFromKotlin.kt")
    public void testNestedClassFromKotlin() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nestedClassFromKotlin.kt");
    }

    @Test
    @TestMetadata("nestedClassType.kt")
    public void testNestedClassType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nestedClassType.kt");
    }

    @Test
    @TestMetadata("nestedTypeArgument.kt")
    public void testNestedTypeArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nestedTypeArgument.kt");
    }

    @Test
    @TestMetadata("nullableType.kt")
    public void testNullableType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nullableType.kt");
    }

    @Test
    @TestMetadata("nullableTypeWithooutQuestionMark.kt")
    public void testNullableTypeWithooutQuestionMark() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nullableTypeWithooutQuestionMark.kt");
    }

    @Test
    @TestMetadata("receiverType.kt")
    public void testReceiverType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/receiverType.kt");
    }

    @Test
    @TestMetadata("superType.kt")
    public void testSuperType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superType.kt");
    }

    @Test
    @TestMetadata("superType2.kt")
    public void testSuperType2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superType2.kt");
    }

    @Test
    @TestMetadata("superType3.kt")
    public void testSuperType3() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superType3.kt");
    }

    @Test
    @TestMetadata("superTypeAndGeneratedProperty.kt")
    public void testSuperTypeAndGeneratedProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeAndGeneratedProperty.kt");
    }

    @Test
    @TestMetadata("superTypeInObject.kt")
    public void testSuperTypeInObject() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeInObject.kt");
    }

    @Test
    @TestMetadata("superTypeInObject2.kt")
    public void testSuperTypeInObject2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeInObject2.kt");
    }

    @Test
    @TestMetadata("superTypeInObject3.kt")
    public void testSuperTypeInObject3() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeInObject3.kt");
    }

    @Test
    @TestMetadata("superTypeOnEnumClass.kt")
    public void testSuperTypeOnEnumClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeOnEnumClass.kt");
    }

    @Test
    @TestMetadata("typeArgument.kt")
    public void testTypeArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/typeArgument.kt");
    }

    @Test
    @TestMetadata("typeParameterBound.kt")
    public void testTypeParameterBound() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/typeParameterBound.kt");
    }

    @Test
    @TestMetadata("typeParameterBoundNested.kt")
    public void testTypeParameterBoundNested() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/typeParameterBoundNested.kt");
    }

    @Test
    @TestMetadata("unresolvedTypeArgumentResolvedTypeConsturctor.kt")
    public void testUnresolvedTypeArgumentResolvedTypeConsturctor() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/unresolvedTypeArgumentResolvedTypeConsturctor.kt");
    }

    @Test
    @TestMetadata("unresolvedTypeConsturctorResolvedNestedTypeArgument.kt")
    public void testUnresolvedTypeConsturctorResolvedNestedTypeArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/unresolvedTypeConsturctorResolvedNestedTypeArgument.kt");
    }

    @Test
    @TestMetadata("unresolvedTypeConsturctorResolvedTypeArgument.kt")
    public void testUnresolvedTypeConsturctorResolvedTypeArgument() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/unresolvedTypeConsturctorResolvedTypeArgument.kt");
    }

    @Test
    @TestMetadata("whereClass.kt")
    public void testWhereClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/whereClass.kt");
    }

    @Test
    @TestMetadata("whereFunction.kt")
    public void testWhereFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/whereFunction.kt");
    }

    @Test
    @TestMetadata("whereProperty.kt")
    public void testWhereProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/whereProperty.kt");
    }

    @Test
    @TestMetadata("wholeType.kt")
    public void testWholeType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/wholeType.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration")
  @TestDataPath("$PROJECT_ROOT")
  public class WholeDeclaration {
    @Test
    public void testAllFilesPresentInWholeDeclaration() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("classTypeParemeter.kt")
    public void testClassTypeParemeter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/classTypeParemeter.kt");
    }

    @Test
    @TestMetadata("delegate.kt")
    public void testDelegate() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/delegate.kt");
    }

    @Test
    @TestMetadata("enum.kt")
    public void testEnum() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/enum.kt");
    }

    @Test
    @TestMetadata("enumEntry.kt")
    public void testEnumEntry() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/enumEntry.kt");
    }

    @Test
    @TestMetadata("externalJavaAnnotation.kt")
    public void testExternalJavaAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/externalJavaAnnotation.kt");
    }

    @Test
    @TestMetadata("fileAnnotation.kt")
    public void testFileAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/fileAnnotation.kt");
    }

    @Test
    @TestMetadata("fileAnnotationList.kt")
    public void testFileAnnotationList() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/fileAnnotationList.kt");
    }

    @Test
    @TestMetadata("functionTypeParemeter.kt")
    public void testFunctionTypeParemeter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/functionTypeParemeter.kt");
    }

    @Test
    @TestMetadata("functionValueParameter.kt")
    public void testFunctionValueParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/functionValueParameter.kt");
    }

    @Test
    @TestMetadata("getter.kt")
    public void testGetter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/getter.kt");
    }

    @Test
    @TestMetadata("incompleteFunctionTypeParemeter.kt")
    public void testIncompleteFunctionTypeParemeter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/incompleteFunctionTypeParemeter.kt");
    }

    @Test
    @TestMetadata("lambdaAsSAMInterfaceWithAnnotation.kt")
    public void testLambdaAsSAMInterfaceWithAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/lambdaAsSAMInterfaceWithAnnotation.kt");
    }

    @Test
    @TestMetadata("localClass.kt")
    public void testLocalClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localClass.kt");
    }

    @Test
    @TestMetadata("localDelegatedPropertyWithPropagatedType.kt")
    public void testLocalDelegatedPropertyWithPropagatedType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localDelegatedPropertyWithPropagatedType.kt");
    }

    @Test
    @TestMetadata("localFunction.kt")
    public void testLocalFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localFunction.kt");
    }

    @Test
    @TestMetadata("localProperty.kt")
    public void testLocalProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localProperty.kt");
    }

    @Test
    @TestMetadata("localPropertyWithPropagatedType.kt")
    public void testLocalPropertyWithPropagatedType() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localPropertyWithPropagatedType.kt");
    }

    @Test
    @TestMetadata("memberFunction.kt")
    public void testMemberFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberFunction.kt");
    }

    @Test
    @TestMetadata("memberProperty.kt")
    public void testMemberProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberProperty.kt");
    }

    @Test
    @TestMetadata("memberTypeAlias.kt")
    public void testMemberTypeAlias() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberTypeAlias.kt");
    }

    @Test
    @TestMetadata("nestedClass.kt")
    public void testNestedClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/nestedClass.kt");
    }

    @Test
    @TestMetadata("notNullJavaAnnotation.kt")
    public void testNotNullJavaAnnotation() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/notNullJavaAnnotation.kt");
    }

    @Test
    @TestMetadata("primaryConstructorValValueParameter.kt")
    public void testPrimaryConstructorValValueParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/primaryConstructorValValueParameter.kt");
    }

    @Test
    @TestMetadata("primaryConstructorValueParameter.kt")
    public void testPrimaryConstructorValueParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/primaryConstructorValueParameter.kt");
    }

    @Test
    @TestMetadata("propagateFlexibleTypeToAnonymousFunction.kt")
    public void testPropagateFlexibleTypeToAnonymousFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/propagateFlexibleTypeToAnonymousFunction.kt");
    }

    @Test
    @TestMetadata("propagateFlexibleTypeToAnonymousFunction2.kt")
    public void testPropagateFlexibleTypeToAnonymousFunction2() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/propagateFlexibleTypeToAnonymousFunction2.kt");
    }

    @Test
    @TestMetadata("secondaryConstructorValueParameter.kt")
    public void testSecondaryConstructorValueParameter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/secondaryConstructorValueParameter.kt");
    }

    @Test
    @TestMetadata("setter.kt")
    public void testSetter() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/setter.kt");
    }

    @Test
    @TestMetadata("topLevelClass.kt")
    public void testTopLevelClass() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelClass.kt");
    }

    @Test
    @TestMetadata("topLevelFunction.kt")
    public void testTopLevelFunction() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelFunction.kt");
    }

    @Test
    @TestMetadata("topLevelProperty.kt")
    public void testTopLevelProperty() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelProperty.kt");
    }

    @Test
    @TestMetadata("topLevelTypelTypeAlias.kt")
    public void testTopLevelTypelTypeAlias() {
      runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelTypelTypeAlias.kt");
    }
  }
}
