/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/lazyResolve")
@TestDataPath("$PROJECT_ROOT")
public class FirSourceLazyDeclarationResolveTestGenerated extends AbstractFirSourceLazyDeclarationResolveTest {
  @Test
  public void testAllFilesPresentInLazyResolve() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
  }

  @Test
  @TestMetadata("ambiguousLocalEnum.kt")
  public void testAmbiguousLocalEnum() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/ambiguousLocalEnum.kt");
  }

  @Test
  @TestMetadata("annotationArgumentsMix.kt")
  public void testAnnotationArgumentsMix() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationArgumentsMix.kt");
  }

  @Test
  @TestMetadata("annotationClassWithJavaTarget.kt")
  public void testAnnotationClassWithJavaTarget() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationClassWithJavaTarget.kt");
  }

  @Test
  @TestMetadata("annotationFromImplicitJavaType.kt")
  public void testAnnotationFromImplicitJavaType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationFromImplicitJavaType.kt");
  }

  @Test
  @TestMetadata("annotationFromImplicitJavaTypeWithJavaAnnotation.kt")
  public void testAnnotationFromImplicitJavaTypeWithJavaAnnotation() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationFromImplicitJavaTypeWithJavaAnnotation.kt");
  }

  @Test
  @TestMetadata("annotationInsideWhereFunction.kt")
  public void testAnnotationInsideWhereFunction() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationInsideWhereFunction.kt");
  }

  @Test
  @TestMetadata("annotationInsideWhereProperty.kt")
  public void testAnnotationInsideWhereProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationInsideWhereProperty.kt");
  }

  @Test
  @TestMetadata("annotationOnDelegatedInterface.kt")
  public void testAnnotationOnDelegatedInterface() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationOnDelegatedInterface.kt");
  }

  @Test
  @TestMetadata("annotationOnLocalClass.kt")
  public void testAnnotationOnLocalClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationOnLocalClass.kt");
  }

  @Test
  @TestMetadata("annotationParameters.kt")
  public void testAnnotationParameters() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationParameters.kt");
  }

  @Test
  @TestMetadata("annotationWithCycleInDefaults.kt")
  public void testAnnotationWithCycleInDefaults() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithCycleInDefaults.kt");
  }

  @Test
  @TestMetadata("annotationWithDefaults.kt")
  public void testAnnotationWithDefaults() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithDefaults.kt");
  }

  @Test
  @TestMetadata("annotationWithEnumFromBody.kt")
  public void testAnnotationWithEnumFromBody() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithEnumFromBody.kt");
  }

  @Test
  @TestMetadata("annotationWithSecondaryConstructor.kt")
  public void testAnnotationWithSecondaryConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithSecondaryConstructor.kt");
  }

  @Test
  @TestMetadata("annotationWithSecondaryConstructor2.kt")
  public void testAnnotationWithSecondaryConstructor2() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithSecondaryConstructor2.kt");
  }

  @Test
  @TestMetadata("annotationWithTypeArgument.kt")
  public void testAnnotationWithTypeArgument() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithTypeArgument.kt");
  }

  @Test
  @TestMetadata("annotationWithoutDefaults.kt")
  public void testAnnotationWithoutDefaults() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithoutDefaults.kt");
  }

  @Test
  @TestMetadata("annotations.kt")
  public void testAnnotations() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/annotations.kt");
  }

  @Test
  @TestMetadata("anonymousFunctionWithAnnotatedParameter.kt")
  public void testAnonymousFunctionWithAnnotatedParameter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameter.kt");
  }

  @Test
  @TestMetadata("anonymousFunctionWithAnnotatedParameter2.kt")
  public void testAnonymousFunctionWithAnnotatedParameter2() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameter2.kt");
  }

  @Test
  @TestMetadata("anonymousFunctionWithAnnotatedParameterOnImplicitTypePhase.kt")
  public void testAnonymousFunctionWithAnnotatedParameterOnImplicitTypePhase() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameterOnImplicitTypePhase.kt");
  }

  @Test
  @TestMetadata("classMembers.kt")
  public void testClassMembers() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/classMembers.kt");
  }

  @Test
  @TestMetadata("compilerRequiredAnnotationOnLocalClass.kt")
  public void testCompilerRequiredAnnotationOnLocalClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationOnLocalClass.kt");
  }

  @Test
  @TestMetadata("compilerRequiredAnnotationsOnConstructor.kt")
  public void testCompilerRequiredAnnotationsOnConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructor.kt");
  }

  @Test
  @TestMetadata("compilerRequiredAnnotationsOnConstructorProperty.kt")
  public void testCompilerRequiredAnnotationsOnConstructorProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructorProperty.kt");
  }

  @Test
  @TestMetadata("compilerRequiredAnnotationsOnFunction.kt")
  public void testCompilerRequiredAnnotationsOnFunction() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnFunction.kt");
  }

  @Test
  @TestMetadata("compilerRequiredAnnotationsOnProperty.kt")
  public void testCompilerRequiredAnnotationsOnProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnProperty.kt");
  }

  @Test
  @TestMetadata("compilerRequiredAnnotationsOnPropertyDelegate.kt")
  public void testCompilerRequiredAnnotationsOnPropertyDelegate() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnPropertyDelegate.kt");
  }

  @Test
  @TestMetadata("complexLocalHierarchy.kt")
  public void testComplexLocalHierarchy() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/complexLocalHierarchy.kt");
  }

  @Test
  @TestMetadata("complexRedeclaration.kt")
  public void testComplexRedeclaration() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/complexRedeclaration.kt");
  }

  @Test
  @TestMetadata("contextParameters.kt")
  public void testContextParameters() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/contextParameters.kt");
  }

  @Test
  @TestMetadata("contextParametersProperty.kt")
  public void testContextParametersProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/contextParametersProperty.kt");
  }

  @Test
  @TestMetadata("cyclicHierarchy.kt")
  public void testCyclicHierarchy() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy.kt");
  }

  @Test
  @TestMetadata("cyclicHierarchy2.kt")
  public void testCyclicHierarchy2() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy2.kt");
  }

  @Test
  @TestMetadata("cyclicHierarchy3.kt")
  public void testCyclicHierarchy3() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy3.kt");
  }

  @Test
  @TestMetadata("cyclicNestedHierarchy.kt")
  public void testCyclicNestedHierarchy() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchy.kt");
  }

  @Test
  @TestMetadata("cyclicNestedHierarchy2.kt")
  public void testCyclicNestedHierarchy2() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchy2.kt");
  }

  @Test
  @TestMetadata("dataClassCopy.kt")
  public void testDataClassCopy() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/dataClassCopy.kt");
  }

  @Test
  @TestMetadata("dataComponent2.kt")
  public void testDataComponent2() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/dataComponent2.kt");
  }

  @Test
  @TestMetadata("delegateWithImplicitType.kt")
  public void testDelegateWithImplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegateWithImplicitType.kt");
  }

  @Test
  @TestMetadata("delegateWithImplicitTypeInDifferentModules.kt")
  public void testDelegateWithImplicitTypeInDifferentModules() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegateWithImplicitTypeInDifferentModules.kt");
  }

  @Test
  @TestMetadata("delegatedField.kt")
  public void testDelegatedField() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedField.kt");
  }

  @Test
  @TestMetadata("delegatedFieldNestedNameClash.kt")
  public void testDelegatedFieldNestedNameClash() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedFieldNestedNameClash.kt");
  }

  @Test
  @TestMetadata("delegatedFieldNestedNameClashWithNestedTypes.kt")
  public void testDelegatedFieldNestedNameClashWithNestedTypes() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedFieldNestedNameClashWithNestedTypes.kt");
  }

  @Test
  @TestMetadata("delegates.kt")
  public void testDelegates() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegates.kt");
  }

  @Test
  @TestMetadata("delegationPropertyGetter.kt")
  public void testDelegationPropertyGetter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertyGetter.kt");
  }

  @Test
  @TestMetadata("delegationPropertyGetterWithImplicitType.kt")
  public void testDelegationPropertyGetterWithImplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertyGetterWithImplicitType.kt");
  }

  @Test
  @TestMetadata("delegationPropertySetter.kt")
  public void testDelegationPropertySetter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertySetter.kt");
  }

  @Test
  @TestMetadata("delegationPropertySetterWithImplicitType.kt")
  public void testDelegationPropertySetterWithImplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertySetterWithImplicitType.kt");
  }

  @Test
  @TestMetadata("enumEntries.kt")
  public void testEnumEntries() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntries.kt");
  }

  @Test
  @TestMetadata("enumEntry.kt")
  public void testEnumEntry() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntry.kt");
  }

  @Test
  @TestMetadata("enumValueOf.kt")
  public void testEnumValueOf() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValueOf.kt");
  }

  @Test
  @TestMetadata("enumValues.kt")
  public void testEnumValues() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValues.kt");
  }

  @Test
  @TestMetadata("expectClass.kt")
  public void testExpectClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/expectClass.kt");
  }

  @Test
  @TestMetadata("explicitSubstitutionOverrideProperty.kt")
  public void testExplicitSubstitutionOverrideProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/explicitSubstitutionOverrideProperty.kt");
  }

  @Test
  @TestMetadata("externalClassConstructor.kt")
  public void testExternalClassConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/externalClassConstructor.kt");
  }

  @Test
  @TestMetadata("fakeOverride.kt")
  public void testFakeOverride() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/fakeOverride.kt");
  }

  @Test
  @TestMetadata("fakePrimaryConstructor.kt")
  public void testFakePrimaryConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/fakePrimaryConstructor.kt");
  }

  @Test
  @TestMetadata("fileAnnotations.kt")
  public void testFileAnnotations() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/fileAnnotations.kt");
  }

  @Test
  @TestMetadata("fileElements.kt")
  public void testFileElements() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/fileElements.kt");
  }

  @Test
  @TestMetadata("fromLocalHierarchyToOuter.kt")
  public void testFromLocalHierarchyToOuter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/fromLocalHierarchyToOuter.kt");
  }

  @Test
  @TestMetadata("functionWithAnnotatedJavaClass.kt")
  public void testFunctionWithAnnotatedJavaClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithAnnotatedJavaClass.kt");
  }

  @Test
  @TestMetadata("functionWithImplicitTypeAndAnnotations.kt")
  public void testFunctionWithImplicitTypeAndAnnotations() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndAnnotations.kt");
  }

  @Test
  @TestMetadata("functionWithImplicitTypeAndStringTemplateAsDefaultValue.kt")
  public void testFunctionWithImplicitTypeAndStringTemplateAsDefaultValue() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndStringTemplateAsDefaultValue.kt");
  }

  @Test
  @TestMetadata("functionWithParameter.kt")
  public void testFunctionWithParameter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithParameter.kt");
  }

  @Test
  @TestMetadata("functionWithWhere.kt")
  public void testFunctionWithWhere() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithWhere.kt");
  }

  @Test
  @TestMetadata("implicitSubstitutionOverrideProperty.kt")
  public void testImplicitSubstitutionOverrideProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitSubstitutionOverrideProperty.kt");
  }

  @Test
  @TestMetadata("implicitTypeOnFunctionWithRawContract.kt")
  public void testImplicitTypeOnFunctionWithRawContract() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithRawContract.kt");
  }

  @Test
  @TestMetadata("implicitTypeOnFunctionWithUnresolvedRawContract.kt")
  public void testImplicitTypeOnFunctionWithUnresolvedRawContract() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithUnresolvedRawContract.kt");
  }

  @Test
  @TestMetadata("implicitTypeOnFunctionWithWrongRawContract.kt")
  public void testImplicitTypeOnFunctionWithWrongRawContract() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithWrongRawContract.kt");
  }

  @Test
  @TestMetadata("implicitTypeWithInaccessibleAnnotation.kt")
  public void testImplicitTypeWithInaccessibleAnnotation() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeWithInaccessibleAnnotation.kt");
  }

  @Test
  @TestMetadata("initWithAnnotation.kt")
  public void testInitWithAnnotation() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/initWithAnnotation.kt");
  }

  @Test
  @TestMetadata("lambdaAsSAMInterface.kt")
  public void testLambdaAsSAMInterface() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/lambdaAsSAMInterface.kt");
  }

  @Test
  @TestMetadata("lazyProperty.kt")
  public void testLazyProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/lazyProperty.kt");
  }

  @Test
  @TestMetadata("localAnnotations.kt")
  public void testLocalAnnotations() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localAnnotations.kt");
  }

  @Test
  @TestMetadata("localConstructor.kt")
  public void testLocalConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localConstructor.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideAnnotationCall.kt")
  public void testLocalFunctionInsideAnnotationCall() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideAnnotationCall.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideFunctionLiteral.kt")
  public void testLocalFunctionInsideFunctionLiteral() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideFunctionLiteral.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideLambdaCallInsideStringTemplate.kt")
  public void testLocalFunctionInsideLambdaCallInsideStringTemplate() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideLambdaCallInsideStringTemplate.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideStringTemplate.kt")
  public void testLocalFunctionInsideStringTemplate() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideStringTemplate.kt");
  }

  @Test
  @TestMetadata("localFunctionInsideSuperEntryCall.kt")
  public void testLocalFunctionInsideSuperEntryCall() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideSuperEntryCall.kt");
  }

  @Test
  @TestMetadata("localNestedClass.kt")
  public void testLocalNestedClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localNestedClass.kt");
  }

  @Test
  @TestMetadata("localParameterInsideSuperEntryCall.kt")
  public void testLocalParameterInsideSuperEntryCall() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/localParameterInsideSuperEntryCall.kt");
  }

  @Test
  @TestMetadata("nestedCompilerRequiredAnnotations.kt")
  public void testNestedCompilerRequiredAnnotations() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotations.kt");
  }

  @Test
  @TestMetadata("nestedCompilerRequiredAnnotationsForMember.kt")
  public void testNestedCompilerRequiredAnnotationsForMember() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsForMember.kt");
  }

  @Test
  @TestMetadata("nestedCompilerRequiredAnnotationsInsideBody.kt")
  public void testNestedCompilerRequiredAnnotationsInsideBody() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsInsideBody.kt");
  }

  @Test
  @TestMetadata("nestedTypeAlias.kt")
  public void testNestedTypeAlias() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAlias.kt");
  }

  @Test
  @TestMetadata("nestedTypeAlias2.kt")
  public void testNestedTypeAlias2() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAlias2.kt");
  }

  @Test
  @TestMetadata("parameterOfNonLocalSetter.kt")
  public void testParameterOfNonLocalSetter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfNonLocalSetter.kt");
  }

  @Test
  @TestMetadata("parameterOfTopSetter.kt")
  public void testParameterOfTopSetter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfTopSetter.kt");
  }

  @Test
  @TestMetadata("primaryConstructor.kt")
  public void testPrimaryConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructor.kt");
  }

  @Test
  @TestMetadata("primaryConstructorParameter.kt")
  public void testPrimaryConstructorParameter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorParameter.kt");
  }

  @Test
  @TestMetadata("primaryConstructorProperty.kt")
  public void testPrimaryConstructorProperty() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorProperty.kt");
  }

  @Test
  @TestMetadata("propertyDelegateWithImplicitType.kt")
  public void testPropertyDelegateWithImplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyDelegateWithImplicitType.kt");
  }

  @Test
  @TestMetadata("propertyWithGetter.kt")
  public void testPropertyWithGetter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetter.kt");
  }

  @Test
  @TestMetadata("propertyWithGetterAndSetter.kt")
  public void testPropertyWithGetterAndSetter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetterAndSetter.kt");
  }

  @Test
  @TestMetadata("propertyWithImplicitTypeAndAnnotations.kt")
  public void testPropertyWithImplicitTypeAndAnnotations() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndAnnotations.kt");
  }

  @Test
  @TestMetadata("propertyWithImplicitTypeAndFieldAnnotations.kt")
  public void testPropertyWithImplicitTypeAndFieldAnnotations() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndFieldAnnotations.kt");
  }

  @Test
  @TestMetadata("propertyWithInitializer.kt")
  public void testPropertyWithInitializer() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithInitializer.kt");
  }

  @Test
  @TestMetadata("propertyWithWhere.kt")
  public void testPropertyWithWhere() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithWhere.kt");
  }

  @Test
  @TestMetadata("redeclaration.kt")
  public void testRedeclaration() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/redeclaration.kt");
  }

  @Test
  @TestMetadata("resolveSuperTypeFromLocalClass.kt")
  public void testResolveSuperTypeFromLocalClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveSuperTypeFromLocalClass.kt");
  }

  @Test
  @TestMetadata("resolveTypeFromLocalClassConstructor.kt")
  public void testResolveTypeFromLocalClassConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalClassConstructor.kt");
  }

  @Test
  @TestMetadata("resolveTypeFromLocalFunction.kt")
  public void testResolveTypeFromLocalFunction() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalFunction.kt");
  }

  @Test
  @TestMetadata("secondaryConstructor.kt")
  public void testSecondaryConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructor.kt");
  }

  @Test
  @TestMetadata("secondaryConstructorParameter.kt")
  public void testSecondaryConstructorParameter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructorParameter.kt");
  }

  @Test
  @TestMetadata("substitutionFakeOverride.kt")
  public void testSubstitutionFakeOverride() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverride.kt");
  }

  @Test
  @TestMetadata("substitutionFakeOverrideConstructor.kt")
  public void testSubstitutionFakeOverrideConstructor() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideConstructor.kt");
  }

  @Test
  @TestMetadata("substitutionFakeOverrideFunction.kt")
  public void testSubstitutionFakeOverrideFunction() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideFunction.kt");
  }

  @Test
  @TestMetadata("substitutionFakeOverrideFunctionWithImplicitType.kt")
  public void testSubstitutionFakeOverrideFunctionWithImplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideFunctionWithImplicitType.kt");
  }

  @Test
  @TestMetadata("substitutionFakeOverrideInDifferentModules.kt")
  public void testSubstitutionFakeOverrideInDifferentModules() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideInDifferentModules.kt");
  }

  @Test
  @TestMetadata("substitutionFakeOverrideWithImplicitType.kt")
  public void testSubstitutionFakeOverrideWithImplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideWithImplicitType.kt");
  }

  @Test
  @TestMetadata("substitutionFakeOverrideWithImplicitTypeAndReceiver.kt")
  public void testSubstitutionFakeOverrideWithImplicitTypeAndReceiver() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideWithImplicitTypeAndReceiver.kt");
  }

  @Test
  @TestMetadata("superQualifierTypeArgsInDelegatedConstructorInnerClass.kt")
  public void testSuperQualifierTypeArgsInDelegatedConstructorInnerClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/superQualifierTypeArgsInDelegatedConstructorInnerClass.kt");
  }

  @Test
  @TestMetadata("superQualifierTypeArgsInDelegatedConstructorLocalClass.kt")
  public void testSuperQualifierTypeArgsInDelegatedConstructorLocalClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/superQualifierTypeArgsInDelegatedConstructorLocalClass.kt");
  }

  @Test
  @TestMetadata("superTypes.kt")
  public void testSuperTypes() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypes.kt");
  }

  @Test
  @TestMetadata("superTypesLoop.kt")
  public void testSuperTypesLoop() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypesLoop.kt");
  }

  @Test
  @TestMetadata("superclassMetaAnnotation.kt")
  public void testSuperclassMetaAnnotation() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/superclassMetaAnnotation.kt");
  }

  @Test
  @TestMetadata("topLevelFunctions.kt")
  public void testTopLevelFunctions() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctions.kt");
  }

  @Test
  @TestMetadata("topLevelFunctionsWithExpressionBodyAndExplicitType.kt")
  public void testTopLevelFunctionsWithExpressionBodyAndExplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithExpressionBodyAndExplicitType.kt");
  }

  @Test
  @TestMetadata("topLevelFunctionsWithImplicitType.kt")
  public void testTopLevelFunctionsWithImplicitType() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithImplicitType.kt");
  }

  @Test
  @TestMetadata("typeParameterBounds.kt")
  public void testTypeParameterBounds() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterBounds.kt");
  }

  @Test
  @TestMetadata("typeParameterOfClass.kt")
  public void testTypeParameterOfClass() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClass.kt");
  }

  @Test
  @TestMetadata("typeParameterOfClass2.kt")
  public void testTypeParameterOfClass2() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClass2.kt");
  }

  @Test
  @TestMetadata("typeParameterOfNonLocalFunction.kt")
  public void testTypeParameterOfNonLocalFunction() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfNonLocalFunction.kt");
  }

  @Test
  @TestMetadata("typeParameterOfTopFunction.kt")
  public void testTypeParameterOfTopFunction() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopFunction.kt");
  }

  @Test
  @TestMetadata("typeParameterOfTopSetter.kt")
  public void testTypeParameterOfTopSetter() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopSetter.kt");
  }

  @Test
  @TestMetadata("typeParameterOfTypeAlias.kt")
  public void testTypeParameterOfTypeAlias() {
    runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTypeAlias.kt");
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/classes")
  @TestDataPath("$PROJECT_ROOT")
  public class Classes {
    @Test
    @TestMetadata("actual.kt")
    public void testActual() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/actual.kt");
    }

    @Test
    public void testAllFilesPresentInClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/classes"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("annotationWithArgumentInsideSuperTypeCall.kt")
    public void testAnnotationWithArgumentInsideSuperTypeCall() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithArgumentInsideSuperTypeCall.kt");
    }

    @Test
    @TestMetadata("annotationWithArgumentInsideSuperTypeCallUnresolved.kt")
    public void testAnnotationWithArgumentInsideSuperTypeCallUnresolved() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithArgumentInsideSuperTypeCallUnresolved.kt");
    }

    @Test
    @TestMetadata("annotationWithConstantFromNestedClass.kt")
    public void testAnnotationWithConstantFromNestedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithConstantFromNestedClass.kt");
    }

    @Test
    @TestMetadata("annotationWithTarget.kt")
    public void testAnnotationWithTarget() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithTarget.kt");
    }

    @Test
    @TestMetadata("classDelegatedInCommonCode.kt")
    public void testClassDelegatedInCommonCode() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classDelegatedInCommonCode.kt");
    }

    @Test
    @TestMetadata("classWithTypeParameters.kt")
    public void testClassWithTypeParameters() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classWithTypeParameters.kt");
    }

    @Test
    @TestMetadata("classpathSubstitution.kt")
    public void testClasspathSubstitution() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classpathSubstitution.kt");
    }

    @Test
    @TestMetadata("compilerRequiredAnnotationConflict.kt")
    public void testCompilerRequiredAnnotationConflict() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/compilerRequiredAnnotationConflict.kt");
    }

    @Test
    @TestMetadata("compilerRequiredAnnotationConflict2.kt")
    public void testCompilerRequiredAnnotationConflict2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/compilerRequiredAnnotationConflict2.kt");
    }

    @Test
    @TestMetadata("complexEmptyInterfaceWithSuper.kt")
    public void testComplexEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/complexEmptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitution.kt")
    public void testCyclicSupertypeWithClasspathSubstitution() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitution.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitution2.kt")
    public void testCyclicSupertypeWithClasspathSubstitution2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitution2.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionAsLibrary.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionAsLibrary() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionAsLibrary.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionAsLibrary2.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionAsLibrary2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionAsLibrary2.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottom.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottom() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottom.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBase.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBase() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBase.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBaseWithLibrary.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBaseWithLibrary() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBaseWithLibrary.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAlias.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAlias() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAlias.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAliasWithLibrary.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAliasWithLibrary() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAliasWithLibrary.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithLibrary.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithLibrary() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithLibrary.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddle.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddle() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddle.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddleBase.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddleBase() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddleBase.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopBase.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopBase() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopBase.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmost.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmost() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmost.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmostBase.kt")
    public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmostBase() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmostBase.kt");
    }

    @Test
    @TestMetadata("deprecatedSinceKotlin.kt")
    public void testDeprecatedSinceKotlin() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/deprecatedSinceKotlin.kt");
    }

    @Test
    @TestMetadata("emptyClassWithSuper.kt")
    public void testEmptyClassWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/emptyClassWithSuper.kt");
    }

    @Test
    @TestMetadata("emptyInterfaceWithSuper.kt")
    public void testEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/emptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("expectWithSuperClass.kt")
    public void testExpectWithSuperClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/expectWithSuperClass.kt");
    }

    @Test
    @TestMetadata("functionInValueClass.kt")
    public void testFunctionInValueClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/functionInValueClass.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverride.kt")
    public void testHierarchyWithOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverride.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass.kt")
    public void testHierarchyWithOverrideAndNestedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass2.kt")
    public void testHierarchyWithOverrideAndNestedClass2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass2.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass3.kt")
    public void testHierarchyWithOverrideAndNestedClass3() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass3.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass4.kt")
    public void testHierarchyWithOverrideAndNestedClass4() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass4.kt");
    }

    @Test
    @TestMetadata("multiFieldValueClass.kt")
    public void testMultiFieldValueClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/multiFieldValueClass.kt");
    }

    @Test
    @TestMetadata("multiFieldValueClassWithTypeAlias.kt")
    public void testMultiFieldValueClassWithTypeAlias() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/multiFieldValueClassWithTypeAlias.kt");
    }

    @Test
    @TestMetadata("multiLevelClasspathSubstitution.kt")
    public void testMultiLevelClasspathSubstitution() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/multiLevelClasspathSubstitution.kt");
    }

    @Test
    @TestMetadata("nestedClass.kt")
    public void testNestedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClass.kt");
    }

    @Test
    @TestMetadata("nestedClassWithPropertiesOverrides.kt")
    public void testNestedClassWithPropertiesOverrides() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClassWithPropertiesOverrides.kt");
    }

    @Test
    @TestMetadata("nonEmptyClassWithSuper.kt")
    public void testNonEmptyClassWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nonEmptyClassWithSuper.kt");
    }

    @Test
    @TestMetadata("nonEmptyInterfaceWithSuper.kt")
    public void testNonEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nonEmptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("recursiveValueClass.kt")
    public void testRecursiveValueClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/recursiveValueClass.kt");
    }

    @Test
    @TestMetadata("recursiveValueClass2.kt")
    public void testRecursiveValueClass2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/recursiveValueClass2.kt");
    }

    @Test
    @TestMetadata("simpleLoopInOverride.kt")
    public void testSimpleLoopInOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverride.kt");
    }

    @Test
    @TestMetadata("simpleLoopInOverride2.kt")
    public void testSimpleLoopInOverride2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverride2.kt");
    }

    @Test
    @TestMetadata("sinceKotlin.kt")
    public void testSinceKotlin() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/sinceKotlin.kt");
    }

    @Test
    @TestMetadata("superTypeCallNameClash.kt")
    public void testSuperTypeCallNameClash() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNameClash.kt");
    }

    @Test
    @TestMetadata("superTypeCallNameClashImplicitConstructor.kt")
    public void testSuperTypeCallNameClashImplicitConstructor() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNameClashImplicitConstructor.kt");
    }

    @Test
    @TestMetadata("superTypeCallNestedNameClash.kt")
    public void testSuperTypeCallNestedNameClash() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNestedNameClash.kt");
    }

    @Test
    @TestMetadata("superTypeCallNestedNameClashImplicitConstructor.kt")
    public void testSuperTypeCallNestedNameClashImplicitConstructor() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNestedNameClashImplicitConstructor.kt");
    }

    @Test
    @TestMetadata("valueClassWithAnotherValueClass.kt")
    public void testValueClassWithAnotherValueClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithAnotherValueClass.kt");
    }

    @Test
    @TestMetadata("valueClassWithMultiFieldValueClass.kt")
    public void testValueClassWithMultiFieldValueClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithMultiFieldValueClass.kt");
    }

    @Test
    @TestMetadata("valueClassWithNestedClass.kt")
    public void testValueClassWithNestedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithNestedClass.kt");
    }

    @Test
    @TestMetadata("valueClassWithNullableMultiFieldValueClass.kt")
    public void testValueClassWithNullableMultiFieldValueClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithNullableMultiFieldValueClass.kt");
    }

    @Test
    @TestMetadata("valueClassWithParameterizedAlias.kt")
    public void testValueClassWithParameterizedAlias() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithParameterizedAlias.kt");
    }

    @Test
    @TestMetadata("valueClassWithTypeAliasOnAnotherValueClass.kt")
    public void testValueClassWithTypeAliasOnAnotherValueClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithTypeAliasOnAnotherValueClass.kt");
    }

    @Nested
    @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass")
    @TestDataPath("$PROJECT_ROOT")
    public class DataClass {
      @Test
      public void testAllFilesPresentInDataClass() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
      }

      @Test
      @TestMetadata("component1TypeCollision.kt")
      public void testComponent1TypeCollision() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/component1TypeCollision.kt");
      }

      @Test
      @TestMetadata("copyTypeCollision.kt")
      public void testCopyTypeCollision() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/copyTypeCollision.kt");
      }

      @Test
      @TestMetadata("dataClassComponent1.kt")
      public void testDataClassComponent1() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassComponent1.kt");
      }

      @Test
      @TestMetadata("dataClassConstructor.kt")
      public void testDataClassConstructor() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassConstructor.kt");
      }

      @Test
      @TestMetadata("dataClassCopy.kt")
      public void testDataClassCopy() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassCopy.kt");
      }

      @Test
      @TestMetadata("dataClassProperty.kt")
      public void testDataClassProperty() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassProperty.kt");
      }

      @Test
      @TestMetadata("parameterTypeCollision.kt")
      public void testParameterTypeCollision() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/parameterTypeCollision.kt");
      }

      @Test
      @TestMetadata("propertyTypeCollision.kt")
      public void testPropertyTypeCollision() {
        runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/propertyTypeCollision.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/errors")
  @TestDataPath("$PROJECT_ROOT")
  public class Errors {
    @Test
    public void testAllFilesPresentInErrors() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/errors"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("annotationWithNamedFunctionArgument.kt")
    public void testAnnotationWithNamedFunctionArgument() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/annotationWithNamedFunctionArgument.kt");
    }

    @Test
    @TestMetadata("anonymousObjectInInvalidPosition.kt")
    public void testAnonymousObjectInInvalidPosition() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/anonymousObjectInInvalidPosition.kt");
    }

    @Test
    @TestMetadata("classLevelDanglingAnnotationWithNestedDeclarations.kt")
    public void testClassLevelDanglingAnnotationWithNestedDeclarations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/classLevelDanglingAnnotationWithNestedDeclarations.kt");
    }

    @Test
    @TestMetadata("classLevelDeprecatedDanglingAnnotationWithNestedDeclarations.kt")
    public void testClassLevelDeprecatedDanglingAnnotationWithNestedDeclarations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/classLevelDeprecatedDanglingAnnotationWithNestedDeclarations.kt");
    }

    @Test
    @TestMetadata("danglingAnnotationWithNestedDeclarations.kt")
    public void testDanglingAnnotationWithNestedDeclarations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/danglingAnnotationWithNestedDeclarations.kt");
    }

    @Test
    @TestMetadata("deprecatedDanglingAnnotationWithNestedDeclarations.kt")
    public void testDeprecatedDanglingAnnotationWithNestedDeclarations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/deprecatedDanglingAnnotationWithNestedDeclarations.kt");
    }

    @Test
    @TestMetadata("parameterNoType.kt")
    public void testParameterNoType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/parameterNoType.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/functions")
  @TestDataPath("$PROJECT_ROOT")
  public class Functions {
    @Test
    @TestMetadata("actualOverride.kt")
    public void testActualOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/actualOverride.kt");
    }

    @Test
    public void testAllFilesPresentInFunctions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/functions"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("classpathSubstitution.kt")
    public void testClasspathSubstitution() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitution.kt");
    }

    @Test
    @TestMetadata("classpathSubstitution2.kt")
    public void testClasspathSubstitution2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitution2.kt");
    }

    @Test
    @TestMetadata("classpathSubstitutionWithLibraryClass.kt")
    public void testClasspathSubstitutionWithLibraryClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitutionWithLibraryClass.kt");
    }

    @Test
    @TestMetadata("classpathSubstitutionWithPreresolvedClass.kt")
    public void testClasspathSubstitutionWithPreresolvedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitutionWithPreresolvedClass.kt");
    }

    @Test
    @TestMetadata("contract.kt")
    public void testContract() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/contract.kt");
    }

    @Test
    @TestMetadata("functionCallWithGenericResult.kt")
    public void testFunctionCallWithGenericResult() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionCallWithGenericResult.kt");
    }

    @Test
    @TestMetadata("functionParameter.kt")
    public void testFunctionParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionParameter.kt");
    }

    @Test
    @TestMetadata("functionTypeParameter.kt")
    public void testFunctionTypeParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionTypeParameter.kt");
    }

    @Test
    @TestMetadata("functionWithGenericExpectedTypeInside.kt")
    public void testFunctionWithGenericExpectedTypeInside() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithGenericExpectedTypeInside.kt");
    }

    @Test
    @TestMetadata("functionWithTypeParameters.kt")
    public void testFunctionWithTypeParameters() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithTypeParameters.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverride.kt")
    public void testHierarchyWithOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverride.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass.kt")
    public void testHierarchyWithOverrideAndNestedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass2.kt")
    public void testHierarchyWithOverrideAndNestedClass2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass2.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass3.kt")
    public void testHierarchyWithOverrideAndNestedClass3() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass3.kt");
    }

    @Test
    @TestMetadata("implicitTypeFromFunctionWithDuplicatedName.kt")
    public void testImplicitTypeFromFunctionWithDuplicatedName() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/implicitTypeFromFunctionWithDuplicatedName.kt");
    }

    @Test
    @TestMetadata("incompleteFunctionTypeParameter.kt")
    public void testIncompleteFunctionTypeParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/incompleteFunctionTypeParameter.kt");
    }

    @Test
    @TestMetadata("javaAnnotationWithDefaultValueForenumArray.kt")
    public void testJavaAnnotationWithDefaultValueForenumArray() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/javaAnnotationWithDefaultValueForenumArray.kt");
    }

    @Test
    @TestMetadata("multiLevelClasspathSubstitution.kt")
    public void testMultiLevelClasspathSubstitution() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/multiLevelClasspathSubstitution.kt");
    }

    @Test
    @TestMetadata("multiLevelClasspathSubstitution2.kt")
    public void testMultiLevelClasspathSubstitution2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/multiLevelClasspathSubstitution2.kt");
    }

    @Test
    @TestMetadata("overrideWithTransitiveClass.kt")
    public void testOverrideWithTransitiveClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/overrideWithTransitiveClass.kt");
    }

    @Test
    @TestMetadata("overrideWithTransitiveClassWithPreresolvedClass.kt")
    public void testOverrideWithTransitiveClassWithPreresolvedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/overrideWithTransitiveClassWithPreresolvedClass.kt");
    }

    @Test
    @TestMetadata("preresolvedMultiLevelClasspathSubstitution.kt")
    public void testPreresolvedMultiLevelClasspathSubstitution() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/preresolvedMultiLevelClasspathSubstitution.kt");
    }

    @Test
    @TestMetadata("simpleLoopInOverride.kt")
    public void testSimpleLoopInOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverride.kt");
    }

    @Test
    @TestMetadata("simpleLoopInOverride2.kt")
    public void testSimpleLoopInOverride2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverride2.kt");
    }

    @Test
    @TestMetadata("superTypeCallNameClash.kt")
    public void testSuperTypeCallNameClash() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNameClash.kt");
    }

    @Test
    @TestMetadata("superTypeCallNameClashImplicitConstructor.kt")
    public void testSuperTypeCallNameClashImplicitConstructor() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNameClashImplicitConstructor.kt");
    }

    @Test
    @TestMetadata("superTypeCallNestedNameClash.kt")
    public void testSuperTypeCallNestedNameClash() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNestedNameClash.kt");
    }

    @Test
    @TestMetadata("superTypeCallNestedNameClashImplicitConstructor.kt")
    public void testSuperTypeCallNestedNameClashImplicitConstructor() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNestedNameClashImplicitConstructor.kt");
    }

    @Test
    @TestMetadata("transitiveSubstitutionFakeOverride.kt")
    public void testTransitiveSubstitutionFakeOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/transitiveSubstitutionFakeOverride.kt");
    }

    @Test
    @TestMetadata("typeArgumentInAnnotation.kt")
    public void testTypeArgumentInAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/typeArgumentInAnnotation.kt");
    }

    @Test
    @TestMetadata("unresolvedAnnotationOnFunctionType.kt")
    public void testUnresolvedAnnotationOnFunctionType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/unresolvedAnnotationOnFunctionType.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/noRuntime")
  @TestDataPath("$PROJECT_ROOT")
  public class NoRuntime {
    @Test
    public void testAllFilesPresentInNoRuntime() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/noRuntime"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("arrayOfCall.kt")
    public void testArrayOfCall() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/noRuntime/arrayOfCall.kt");
    }

    @Test
    @TestMetadata("integerLiteralCall.kt")
    public void testIntegerLiteralCall() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/noRuntime/integerLiteralCall.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/properties")
  @TestDataPath("$PROJECT_ROOT")
  public class Properties {
    @Test
    public void testAllFilesPresentInProperties() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/properties"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("constCyclePropertyWithExplicitType.kt")
    public void testConstCyclePropertyWithExplicitType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constCyclePropertyWithExplicitType.kt");
    }

    @Test
    @TestMetadata("constErrorPropertyWithExplicitType.kt")
    public void testConstErrorPropertyWithExplicitType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constErrorPropertyWithExplicitType.kt");
    }

    @Test
    @TestMetadata("constPropertiesWithExplicitType.kt")
    public void testConstPropertiesWithExplicitType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constPropertiesWithExplicitType.kt");
    }

    @Test
    @TestMetadata("constPropertyWithExplicitTypeAndInitializer.kt")
    public void testConstPropertyWithExplicitTypeAndInitializer() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constPropertyWithExplicitTypeAndInitializer.kt");
    }

    @Test
    @TestMetadata("constructorParameter.kt")
    public void testConstructorParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constructorParameter.kt");
    }

    @Test
    @TestMetadata("constructorParameterWithImplicitParameterAnnotation.kt")
    public void testConstructorParameterWithImplicitParameterAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constructorParameterWithImplicitParameterAnnotation.kt");
    }

    @Test
    @TestMetadata("delegateWithAnnotationOnAccessor.kt")
    public void testDelegateWithAnnotationOnAccessor() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/delegateWithAnnotationOnAccessor.kt");
    }

    @Test
    @TestMetadata("delegateWithAnnotationOnAccessorWithExplicitType.kt")
    public void testDelegateWithAnnotationOnAccessorWithExplicitType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/delegateWithAnnotationOnAccessorWithExplicitType.kt");
    }

    @Test
    @TestMetadata("generatedPropertyFromParameter.kt")
    public void testGeneratedPropertyFromParameter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/generatedPropertyFromParameter.kt");
    }

    @Test
    @TestMetadata("generatedPropertyFromParameterWithImplicitAnnotation.kt")
    public void testGeneratedPropertyFromParameterWithImplicitAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/generatedPropertyFromParameterWithImplicitAnnotation.kt");
    }

    @Test
    @TestMetadata("getterWithDelegation.kt")
    public void testGetterWithDelegation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/getterWithDelegation.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverride.kt")
    public void testHierarchyWithOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverride.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass.kt")
    public void testHierarchyWithOverrideAndNestedClass() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass2.kt")
    public void testHierarchyWithOverrideAndNestedClass2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass2.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass3.kt")
    public void testHierarchyWithOverrideAndNestedClass3() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass3.kt");
    }

    @Test
    @TestMetadata("hierarchyWithOverrideAndNestedClass4.kt")
    public void testHierarchyWithOverrideAndNestedClass4() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass4.kt");
    }

    @Test
    @TestMetadata("impliciyTypeWithAnnotationOnFunction.kt")
    public void testImpliciyTypeWithAnnotationOnFunction() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/impliciyTypeWithAnnotationOnFunction.kt");
    }

    @Test
    @TestMetadata("impliciyTypeWithAnnotationOnProperty.kt")
    public void testImpliciyTypeWithAnnotationOnProperty() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/impliciyTypeWithAnnotationOnProperty.kt");
    }

    @Test
    @TestMetadata("propertyGetterWithExplicitType.kt")
    public void testPropertyGetterWithExplicitType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitType.kt");
    }

    @Test
    @TestMetadata("propertyGetterWithExplicitTypeAndBody.kt")
    public void testPropertyGetterWithExplicitTypeAndBody() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitTypeAndBody.kt");
    }

    @Test
    @TestMetadata("propertyGetterWithImplicitType.kt")
    public void testPropertyGetterWithImplicitType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithImplicitType.kt");
    }

    @Test
    @TestMetadata("propertySetter.kt")
    public void testPropertySetter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertySetter.kt");
    }

    @Test
    @TestMetadata("propertyWithTypeParameters.kt")
    public void testPropertyWithTypeParameters() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyWithTypeParameters.kt");
    }

    @Test
    @TestMetadata("simpleLoopInOverride.kt")
    public void testSimpleLoopInOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverride.kt");
    }

    @Test
    @TestMetadata("simpleLoopInOverride2.kt")
    public void testSimpleLoopInOverride2() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverride2.kt");
    }

    @Test
    @TestMetadata("typeParameterAnnotations.kt")
    public void testTypeParameterAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/typeParameterAnnotations.kt");
    }

    @Test
    @TestMetadata("unresolvedAnnotationOnPropertyType.kt")
    public void testUnresolvedAnnotationOnPropertyType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/unresolvedAnnotationOnPropertyType.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties")
  @TestDataPath("$PROJECT_ROOT")
  public class SyntheticProperties {
    @Test
    public void testAllFilesPresentInSyntheticProperties() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("explicitReturnType.kt")
    public void testExplicitReturnType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnType.kt");
    }

    @Test
    @TestMetadata("explicitReturnTypeAndAnnotations.kt")
    public void testExplicitReturnTypeAndAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnTypeAndAnnotations.kt");
    }

    @Test
    @TestMetadata("explicitReturnTypeRecursiveResolve.kt")
    public void testExplicitReturnTypeRecursiveResolve() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnTypeRecursiveResolve.kt");
    }

    @Test
    @TestMetadata("explicitReturnTypeRecursiveResolveAsGetter.kt")
    public void testExplicitReturnTypeRecursiveResolveAsGetter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnTypeRecursiveResolveAsGetter.kt");
    }

    @Test
    @TestMetadata("getterFromLibraryAndSetterFromSources.kt")
    public void testGetterFromLibraryAndSetterFromSources() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/getterFromLibraryAndSetterFromSources.kt");
    }

    @Test
    @TestMetadata("implicitReturnType.kt")
    public void testImplicitReturnType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnType.kt");
    }

    @Test
    @TestMetadata("implicitReturnTypeAndAnnotations.kt")
    public void testImplicitReturnTypeAndAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnTypeAndAnnotations.kt");
    }

    @Test
    @TestMetadata("implicitReturnTypeAndAnnotationsAsGetter.kt")
    public void testImplicitReturnTypeAndAnnotationsAsGetter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnTypeAndAnnotationsAsGetter.kt");
    }

    @Test
    @TestMetadata("secondGenerationOverride.kt")
    public void testSecondGenerationOverride() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/secondGenerationOverride.kt");
    }

    @Test
    @TestMetadata("setterAndExplicitReturnType.kt")
    public void testSetterAndExplicitReturnType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnType.kt");
    }

    @Test
    @TestMetadata("setterAndExplicitReturnTypeAndAnnotations.kt")
    public void testSetterAndExplicitReturnTypeAndAnnotations() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotations.kt");
    }

    @Test
    @TestMetadata("setterAndExplicitReturnTypeAndAnnotationsAsGetter.kt")
    public void testSetterAndExplicitReturnTypeAndAnnotationsAsGetter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotationsAsGetter.kt");
    }

    @Test
    @TestMetadata("setterAndExplicitReturnTypeAndAnnotationsAsSetter.kt")
    public void testSetterAndExplicitReturnTypeAndAnnotationsAsSetter() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotationsAsSetter.kt");
    }

    @Test
    @TestMetadata("setterFromLibraryAndGetterFromSources.kt")
    public void testSetterFromLibraryAndGetterFromSources() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterFromLibraryAndGetterFromSources.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/typeAliases")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeAliases {
    @Test
    public void testAllFilesPresentInTypeAliases() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/typeAliases"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("typeAliasWithAnnotationOnType.kt")
    public void testTypeAliasWithAnnotationOnType() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasWithAnnotationOnType.kt");
    }

    @Test
    @TestMetadata("typeAliasWithTypeParameters.kt")
    public void testTypeAliasWithTypeParameters() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasWithTypeParameters.kt");
    }

    @Test
    @TestMetadata("typeAliasedConstructorCallWithUnderscoredTypeArgument.kt")
    public void testTypeAliasedConstructorCallWithUnderscoredTypeArgument() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasedConstructorCallWithUnderscoredTypeArgument.kt");
    }

    @Test
    @TestMetadata("typeAliasedSamConstructorCallWithUnderscoredTypeArgument.kt")
    public void testTypeAliasedSamConstructorCallWithUnderscoredTypeArgument() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasedSamConstructorCallWithUnderscoredTypeArgument.kt");
    }

    @Test
    @TestMetadata("unresolvedAnnotationOnTypeAlias.kt")
    public void testUnresolvedAnnotationOnTypeAlias() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/unresolvedAnnotationOnTypeAlias.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers")
  @TestDataPath("$PROJECT_ROOT")
  public class WithCallableMembers {
    @Test
    public void testAllFilesPresentInWithCallableMembers() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("complexEmptyInterfaceWithSuper.kt")
    public void testComplexEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/complexEmptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("emptyClassWithSuper.kt")
    public void testEmptyClassWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/emptyClassWithSuper.kt");
    }

    @Test
    @TestMetadata("emptyInterfaceWithSuper.kt")
    public void testEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/emptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("nonEmptyClassWithSuper.kt")
    public void testNonEmptyClassWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/nonEmptyClassWithSuper.kt");
    }

    @Test
    @TestMetadata("nonEmptyInterfaceWithSuper.kt")
    public void testNonEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/nonEmptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("preresolvedComplexEmptyInterfaceWithSuper.kt")
    public void testPreresolvedComplexEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedComplexEmptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("preresolvedEmptyClassWithSuper.kt")
    public void testPreresolvedEmptyClassWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedEmptyClassWithSuper.kt");
    }

    @Test
    @TestMetadata("preresolvedEmptyInterfaceWithSuper.kt")
    public void testPreresolvedEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedEmptyInterfaceWithSuper.kt");
    }

    @Test
    @TestMetadata("preresolvedNonEmptyClassWithSuper.kt")
    public void testPreresolvedNonEmptyClassWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedNonEmptyClassWithSuper.kt");
    }

    @Test
    @TestMetadata("preresolvedNonEmptyInterfaceWithSuper.kt")
    public void testPreresolvedNonEmptyInterfaceWithSuper() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedNonEmptyInterfaceWithSuper.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled")
  @TestDataPath("$PROJECT_ROOT")
  public class WithTestCompilerPluginEnabled {
    @Test
    public void testAllFilesPresentInWithTestCompilerPluginEnabled() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("dataClassComponent1.kt")
    public void testDataClassComponent1() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassComponent1.kt");
    }

    @Test
    @TestMetadata("dataClassConstructor.kt")
    public void testDataClassConstructor() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassConstructor.kt");
    }

    @Test
    @TestMetadata("dataClassCopy.kt")
    public void testDataClassCopy() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassCopy.kt");
    }

    @Test
    @TestMetadata("dataClassCopyAnnotation.kt")
    public void testDataClassCopyAnnotation() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassCopyAnnotation.kt");
    }

    @Test
    @TestMetadata("dataClassProperty.kt")
    public void testDataClassProperty() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassProperty.kt");
    }

    @Test
    @TestMetadata("serializable_starImport.kt")
    public void testSerializable_starImport() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/serializable_starImport.kt");
    }

    @Test
    @TestMetadata("serializable_starImport_twoAnnotationsChain.kt")
    public void testSerializable_starImport_twoAnnotationsChain() {
      runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/serializable_starImport_twoAnnotationsChain.kt");
    }
  }
}
