/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition")
@TestDataPath("$PROJECT_ROOT")
public class FirCustomScriptDefinitionLazyDeclarationResolveTestGenerated extends AbstractFirCustomScriptDefinitionLazyDeclarationResolveTest {
  @Test
  public void testAllFilesPresentInLazyResolveCustomScriptDefinition() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition"), Pattern.compile("^(.+)\\.(kts)$"), null, true);
  }

  @Test
  @TestMetadata("initWithProvidedProperties.test.kts")
  public void testInitWithProvidedProperties_test() {
    runTest("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition/initWithProvidedProperties.test.kts");
  }

  @Test
  @TestMetadata("providedPropertyWithDefaultImport.test.kts")
  public void testProvidedPropertyWithDefaultImport_test() {
    runTest("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition/providedPropertyWithDefaultImport.test.kts");
  }

  @Test
  @TestMetadata("providedPropertyWithoutDefaultImport.test.kts")
  public void testProvidedPropertyWithoutDefaultImport_test() {
    runTest("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition/providedPropertyWithoutDefaultImport.test.kts");
  }

  @Test
  @TestMetadata("providedProperty.test.kts")
  public void testProvidedProperty_test() {
    runTest("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition/providedProperty.test.kts");
  }

  @Test
  @TestMetadata("resultWithProvidedProperties.test.kts")
  public void testResultWithProvidedProperties_test() {
    runTest("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition/resultWithProvidedProperties.test.kts");
  }

  @Test
  @TestMetadata("scriptWithProvidedProperties.test.kts")
  public void testScriptWithProvidedProperties_test() {
    runTest("analysis/low-level-api-fir/testData/lazyResolveCustomScriptDefinition/scriptWithProvidedProperties.test.kts");
  }
}
