/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/compilationPeers")
@TestDataPath("$PROJECT_ROOT")
public class CompilationPeerAnalysisTestGenerated extends AbstractCompilationPeerAnalysisTest {
  @Test
  public void testAllFilesPresentInCompilationPeers() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/compilationPeers"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("functionCall.kt")
  public void testFunctionCall() {
    runTest("analysis/low-level-api-fir/testData/compilationPeers/functionCall.kt");
  }

  @Test
  @TestMetadata("functionCallDeep.kt")
  public void testFunctionCallDeep() {
    runTest("analysis/low-level-api-fir/testData/compilationPeers/functionCallDeep.kt");
  }

  @Test
  @TestMetadata("inlinedClasses.kt")
  public void testInlinedClasses() {
    runTest("analysis/low-level-api-fir/testData/compilationPeers/inlinedClasses.kt");
  }

  @Test
  @TestMetadata("libraryFunctionCall.kt")
  public void testLibraryFunctionCall() {
    runTest("analysis/low-level-api-fir/testData/compilationPeers/libraryFunctionCall.kt");
  }

  @Test
  @TestMetadata("noInline.kt")
  public void testNoInline() {
    runTest("analysis/low-level-api-fir/testData/compilationPeers/noInline.kt");
  }

  @Test
  @TestMetadata("propertyCall.kt")
  public void testPropertyCall() {
    runTest("analysis/low-level-api-fir/testData/compilationPeers/propertyCall.kt");
  }
}
