/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.generated.cases.components.resolver;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.configurators.AnalysisApiFirStandaloneModeTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.resolver.AbstractResolveReferenceTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi")
@TestDataPath("$PROJECT_ROOT")
public class FirStandaloneNormalAnalysisSourceModuleResolveReferenceTestGenerated extends AbstractResolveReferenceTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirStandaloneModeTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Standalone
      )
    );
  }

  @Test
  @TestMetadata("ActualizeBuiltins.kt")
  public void testActualizeBuiltins() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ActualizeBuiltins.kt");
  }

  @Test
  public void testAllFilesPresentInSingleByPsi() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
  }

  @Test
  @TestMetadata("annotationEntry.kt")
  public void testAnnotationEntry() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationEntry.kt");
  }

  @Test
  @TestMetadata("AnnotationForClass.kt")
  public void testAnnotationForClass() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/AnnotationForClass.kt");
  }

  @Test
  @TestMetadata("AnnotationFromJava.kt")
  public void testAnnotationFromJava() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/AnnotationFromJava.kt");
  }

  @Test
  @TestMetadata("annotationInAnnotation_arrayOf.kt")
  public void testAnnotationInAnnotation_arrayOf() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationInAnnotation_arrayOf.kt");
  }

  @Test
  @TestMetadata("annotationInAnnotation_collectionLiteral.kt")
  public void testAnnotationInAnnotation_collectionLiteral() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationInAnnotation_collectionLiteral.kt");
  }

  @Test
  @TestMetadata("annotationInAnnotation_collectionLiteral_badSpread.kt")
  public void testAnnotationInAnnotation_collectionLiteral_badSpread() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationInAnnotation_collectionLiteral_badSpread.kt");
  }

  @Test
  @TestMetadata("annotationInAnnotation_multipleAnnotations_arrayOf.kt")
  public void testAnnotationInAnnotation_multipleAnnotations_arrayOf() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationInAnnotation_multipleAnnotations_arrayOf.kt");
  }

  @Test
  @TestMetadata("annotationInAnnotation_multipleAnnotations_collectionLiteral.kt")
  public void testAnnotationInAnnotation_multipleAnnotations_collectionLiteral() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationInAnnotation_multipleAnnotations_collectionLiteral.kt");
  }

  @Test
  @TestMetadata("annotationInAnnotation_noarg.kt")
  public void testAnnotationInAnnotation_noarg() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationInAnnotation_noarg.kt");
  }

  @Test
  @TestMetadata("annotationInAnnotation_vararg.kt")
  public void testAnnotationInAnnotation_vararg() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationInAnnotation_vararg.kt");
  }

  @Test
  @TestMetadata("AnnotationInsideFunction.kt")
  public void testAnnotationInsideFunction() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/AnnotationInsideFunction.kt");
  }

  @Test
  @TestMetadata("AnnotationOnCallSite.kt")
  public void testAnnotationOnCallSite() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/AnnotationOnCallSite.kt");
  }

  @Test
  @TestMetadata("annotationOnDelegate.kt")
  public void testAnnotationOnDelegate() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnDelegate.kt");
  }

  @Test
  @TestMetadata("annotationOnExpression_if.kt")
  public void testAnnotationOnExpression_if() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnExpression_if.kt");
  }

  @Test
  @TestMetadata("annotationOnExpression_whenBranch.kt")
  public void testAnnotationOnExpression_whenBranch() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnExpression_whenBranch.kt");
  }

  @Test
  @TestMetadata("annotationOnFile.kt")
  public void testAnnotationOnFile() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnFile.kt");
  }

  @Test
  @TestMetadata("AnnotationOnFile2.kt")
  public void testAnnotationOnFile2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/AnnotationOnFile2.kt");
  }

  @Test
  @TestMetadata("AnnotationOnFileWithImport.kt")
  public void testAnnotationOnFileWithImport() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/AnnotationOnFileWithImport.kt");
  }

  @Test
  @TestMetadata("annotationOnParameter_param.kt")
  public void testAnnotationOnParameter_param() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnParameter_param.kt");
  }

  @Test
  @TestMetadata("annotationOnParameter_parameterProperty.kt")
  public void testAnnotationOnParameter_parameterProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnParameter_parameterProperty.kt");
  }

  @Test
  @TestMetadata("annotationOnParameter_reified.kt")
  public void testAnnotationOnParameter_reified() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnParameter_reified.kt");
  }

  @Test
  @TestMetadata("annotationOnParameter_setparam.kt")
  public void testAnnotationOnParameter_setparam() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnParameter_setparam.kt");
  }

  @Test
  @TestMetadata("annotationOnProperty_field.kt")
  public void testAnnotationOnProperty_field() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnProperty_field.kt");
  }

  @Test
  @TestMetadata("annotationOnProperty_get.kt")
  public void testAnnotationOnProperty_get() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnProperty_get.kt");
  }

  @Test
  @TestMetadata("annotationOnProperty_property.kt")
  public void testAnnotationOnProperty_property() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnProperty_property.kt");
  }

  @Test
  @TestMetadata("annotationOnProperty_set.kt")
  public void testAnnotationOnProperty_set() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/annotationOnProperty_set.kt");
  }

  @Test
  @TestMetadata("AnnotationTypeParameter.kt")
  public void testAnnotationTypeParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/AnnotationTypeParameter.kt");
  }

  @Test
  @TestMetadata("arrayIncWithDotQualifier.kt")
  public void testArrayIncWithDotQualifier() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayIncWithDotQualifier.kt");
  }

  @Test
  @TestMetadata("callableReference_genericQualifier1.kt")
  public void testCallableReference_genericQualifier1() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReference_genericQualifier1.kt");
  }

  @Test
  @TestMetadata("callableReference_genericQualifier2.kt")
  public void testCallableReference_genericQualifier2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReference_genericQualifier2.kt");
  }

  @Test
  @TestMetadata("calleeExpressionOfImplicitInvoke.kt")
  public void testCalleeExpressionOfImplicitInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/calleeExpressionOfImplicitInvoke.kt");
  }

  @Test
  @TestMetadata("checkNotNullCall.kt")
  public void testCheckNotNullCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/checkNotNullCall.kt");
  }

  @Test
  @TestMetadata("checkNotNullCallAsCallee.kt")
  public void testCheckNotNullCallAsCallee() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/checkNotNullCallAsCallee.kt");
  }

  @Test
  @TestMetadata("classCollectionLiteral.kt")
  public void testClassCollectionLiteral() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/classCollectionLiteral.kt");
  }

  @Test
  @TestMetadata("ClassInTypeConstraint.kt")
  public void testClassInTypeConstraint() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ClassInTypeConstraint.kt");
  }

  @Test
  @TestMetadata("ClassObjectClassLiteralReference.kt")
  public void testClassObjectClassLiteralReference() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ClassObjectClassLiteralReference.kt");
  }

  @Test
  @TestMetadata("ClassObjectClassLiteralReferenceWithField.kt")
  public void testClassObjectClassLiteralReferenceWithField() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ClassObjectClassLiteralReferenceWithField.kt");
  }

  @Test
  @TestMetadata("ClassQualifierForNestedClassConstructorCall.kt")
  public void testClassQualifierForNestedClassConstructorCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ClassQualifierForNestedClassConstructorCall.kt");
  }

  @Test
  @TestMetadata("ClassReferenceInImport.kt")
  public void testClassReferenceInImport() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ClassReferenceInImport.kt");
  }

  @Test
  @TestMetadata("CollectionStream.kt")
  public void testCollectionStream() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/CollectionStream.kt");
  }

  @Test
  @TestMetadata("companionObjectReference.kt")
  public void testCompanionObjectReference() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/companionObjectReference.kt");
  }

  @Test
  @TestMetadata("CompanionObjectWithName1.kt")
  public void testCompanionObjectWithName1() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/CompanionObjectWithName1.kt");
  }

  @Test
  @TestMetadata("CompanionObjectWithName2.kt")
  public void testCompanionObjectWithName2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/CompanionObjectWithName2.kt");
  }

  @Test
  @TestMetadata("comparisonCall.kt")
  public void testComparisonCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/comparisonCall.kt");
  }

  @Test
  @TestMetadata("consecutiveImplicitInvoke1.kt")
  public void testConsecutiveImplicitInvoke1() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/consecutiveImplicitInvoke1.kt");
  }

  @Test
  @TestMetadata("consecutiveImplicitInvoke2.kt")
  public void testConsecutiveImplicitInvoke2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/consecutiveImplicitInvoke2.kt");
  }

  @Test
  @TestMetadata("consecutiveImplicitInvoke3.kt")
  public void testConsecutiveImplicitInvoke3() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/consecutiveImplicitInvoke3.kt");
  }

  @Test
  @TestMetadata("consecutiveImplicitInvoke_callee.kt")
  public void testConsecutiveImplicitInvoke_callee() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/consecutiveImplicitInvoke_callee.kt");
  }

  @Test
  @TestMetadata("constructorCallWithSubstitution.kt")
  public void testConstructorCallWithSubstitution() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorCallWithSubstitution.kt");
  }

  @Test
  @TestMetadata("CtrlClickResolve.kt")
  public void testCtrlClickResolve() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/CtrlClickResolve.kt");
  }

  @Test
  @TestMetadata("DefaultObjectAsExtensionReceiverForFunction.kt")
  public void testDefaultObjectAsExtensionReceiverForFunction() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/DefaultObjectAsExtensionReceiverForFunction.kt");
  }

  @Test
  @TestMetadata("DefaultObjectAsExtensionReceiverForProperty.kt")
  public void testDefaultObjectAsExtensionReceiverForProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/DefaultObjectAsExtensionReceiverForProperty.kt");
  }

  @Test
  @TestMetadata("DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt")
  public void testDefaultObjectAsReceiverForExtensionFunctionOnSuperType() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt");
  }

  @Test
  @TestMetadata("DefaultObjectAsReceiverForMemberPropertyInSuperType.kt")
  public void testDefaultObjectAsReceiverForMemberPropertyInSuperType() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/DefaultObjectAsReceiverForMemberPropertyInSuperType.kt");
  }

  @Test
  @TestMetadata("DefaultObjectInShortReferenceFormCall.kt")
  public void testDefaultObjectInShortReferenceFormCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/DefaultObjectInShortReferenceFormCall.kt");
  }

  @Test
  @TestMetadata("defaultStarImportsInLibrarySource.kt")
  public void testDefaultStarImportsInLibrarySource() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/defaultStarImportsInLibrarySource.kt");
  }

  @Test
  @TestMetadata("delegatedConstructor.kt")
  public void testDelegatedConstructor() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedConstructor.kt");
  }

  @Test
  @TestMetadata("delegatedConstructorApplicable.kt")
  public void testDelegatedConstructorApplicable() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedConstructorApplicable.kt");
  }

  @Test
  @TestMetadata("delegatedConstructorCallWithSubstitution.kt")
  public void testDelegatedConstructorCallWithSubstitution() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedConstructorCallWithSubstitution.kt");
  }

  @Test
  @TestMetadata("delegatedConstructorWithSubstitution.kt")
  public void testDelegatedConstructorWithSubstitution() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedConstructorWithSubstitution.kt");
  }

  @Test
  @TestMetadata("Deprecated.kt")
  public void testDeprecated() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/Deprecated.kt");
  }

  @Test
  @TestMetadata("DestructuringDeclarationInInit.kt")
  public void testDestructuringDeclarationInInit() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/DestructuringDeclarationInInit.kt");
  }

  @Test
  @TestMetadata("enumAsAnnotationValue.kt")
  public void testEnumAsAnnotationValue() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/enumAsAnnotationValue.kt");
  }

  @Test
  @TestMetadata("enumEntrySuperclassEntry.kt")
  public void testEnumEntrySuperclassEntry() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/enumEntrySuperclassEntry.kt");
  }

  @Test
  @TestMetadata("enumEntrySuperclassReference.kt")
  public void testEnumEntrySuperclassReference() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/enumEntrySuperclassReference.kt");
  }

  @Test
  @TestMetadata("EnumValues.kt")
  public void testEnumValues() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/EnumValues.kt");
  }

  @Test
  @TestMetadata("eqEqCall_fromAny.kt")
  public void testEqEqCall_fromAny() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/eqEqCall_fromAny.kt");
  }

  @Test
  @TestMetadata("eqEqCall_fromDataClass.kt")
  public void testEqEqCall_fromDataClass() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/eqEqCall_fromDataClass.kt");
  }

  @Test
  @TestMetadata("eqEqCall_fromDataClass_overridden.kt")
  public void testEqEqCall_fromDataClass_overridden() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/eqEqCall_fromDataClass_overridden.kt");
  }

  @Test
  @TestMetadata("eqEqCall_fromSealedClass.kt")
  public void testEqEqCall_fromSealedClass() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/eqEqCall_fromSealedClass.kt");
  }

  @Test
  @TestMetadata("eqEqCall_fromSealedClass_genericUpperBound.kt")
  public void testEqEqCall_fromSealedClass_genericUpperBound() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/eqEqCall_fromSealedClass_genericUpperBound.kt");
  }

  @Test
  @TestMetadata("eqEqCall_fromSuperType.kt")
  public void testEqEqCall_fromSuperType() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/eqEqCall_fromSuperType.kt");
  }

  @Test
  @TestMetadata("eqEqCall_overridden.kt")
  public void testEqEqCall_overridden() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/eqEqCall_overridden.kt");
  }

  @Test
  @TestMetadata("EqualsOperator.kt")
  public void testEqualsOperator() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/EqualsOperator.kt");
  }

  @Test
  @TestMetadata("EqualsOperatorNoInfix.kt")
  public void testEqualsOperatorNoInfix() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/EqualsOperatorNoInfix.kt");
  }

  @Test
  @TestMetadata("explicitFunctionalInterfaceInvoke_globalVal.kt")
  public void testExplicitFunctionalInterfaceInvoke_globalVal() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/explicitFunctionalInterfaceInvoke_globalVal.kt");
  }

  @Test
  @TestMetadata("explicitFunctionalInterfaceInvoke_parameter.kt")
  public void testExplicitFunctionalInterfaceInvoke_parameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/explicitFunctionalInterfaceInvoke_parameter.kt");
  }

  @Test
  @TestMetadata("explicitLambdaParameter.kt")
  public void testExplicitLambdaParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/explicitLambdaParameter.kt");
  }

  @Test
  @TestMetadata("ExternalCompanionObject.kt")
  public void testExternalCompanionObject() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ExternalCompanionObject.kt");
  }

  @Test
  @TestMetadata("forEach.kt")
  public void testForEach() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forEach.kt");
  }

  @Test
  @TestMetadata("functionCall.kt")
  public void testFunctionCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCall.kt");
  }

  @Test
  @TestMetadata("functionCallInTheSameFile.kt")
  public void testFunctionCallInTheSameFile() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallInTheSameFile.kt");
  }

  @Test
  @TestMetadata("functionCallWithExtensionReceiverAndTypeArgument.kt")
  public void testFunctionCallWithExtensionReceiverAndTypeArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithExtensionReceiverAndTypeArgument.kt");
  }

  @Test
  @TestMetadata("functionCallWithLambdaArgument.kt")
  public void testFunctionCallWithLambdaArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithLambdaArgument.kt");
  }

  @Test
  @TestMetadata("functionCallWithNamedArgument.kt")
  public void testFunctionCallWithNamedArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithNamedArgument.kt");
  }

  @Test
  @TestMetadata("functionCallWithNonTrailingLambdaArgument.kt")
  public void testFunctionCallWithNonTrailingLambdaArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithNonTrailingLambdaArgument.kt");
  }

  @Test
  @TestMetadata("functionCallWithNonTrailingLambdaArgument2.kt")
  public void testFunctionCallWithNonTrailingLambdaArgument2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithNonTrailingLambdaArgument2.kt");
  }

  @Test
  @TestMetadata("functionCallWithSpreadArgument.kt")
  public void testFunctionCallWithSpreadArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithSpreadArgument.kt");
  }

  @Test
  @TestMetadata("functionCallWithTypeArgument.kt")
  public void testFunctionCallWithTypeArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithTypeArgument.kt");
  }

  @Test
  @TestMetadata("functionCallWithVarargArgument.kt")
  public void testFunctionCallWithVarargArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionCallWithVarargArgument.kt");
  }

  @Test
  @TestMetadata("functionTypeVariableCall_dispatchReceiver.kt")
  public void testFunctionTypeVariableCall_dispatchReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionTypeVariableCall_dispatchReceiver.kt");
  }

  @Test
  @TestMetadata("functionWithPostDecPropertyArgument.kt")
  public void testFunctionWithPostDecPropertyArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithPostDecPropertyArgument.kt");
  }

  @Test
  @TestMetadata("functionWithPostIncPropertyArgument.kt")
  public void testFunctionWithPostIncPropertyArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithPostIncPropertyArgument.kt");
  }

  @Test
  @TestMetadata("functionWithPreDecArrayAccessArgument.kt")
  public void testFunctionWithPreDecArrayAccessArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithPreDecArrayAccessArgument.kt");
  }

  @Test
  @TestMetadata("functionWithPreDecPropertyArgument.kt")
  public void testFunctionWithPreDecPropertyArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithPreDecPropertyArgument.kt");
  }

  @Test
  @TestMetadata("functionWithPreIncArrayAccessArgument.kt")
  public void testFunctionWithPreIncArrayAccessArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithPreIncArrayAccessArgument.kt");
  }

  @Test
  @TestMetadata("functionWithPreIncPropertyArgument.kt")
  public void testFunctionWithPreIncPropertyArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithPreIncPropertyArgument.kt");
  }

  @Test
  @TestMetadata("functionWithPropertyArgument.kt")
  public void testFunctionWithPropertyArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithPropertyArgument.kt");
  }

  @Test
  @TestMetadata("functionWithReceiverCall.kt")
  public void testFunctionWithReceiverCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithReceiverCall.kt");
  }

  @Test
  @TestMetadata("functionWithReceiverSafeCall.kt")
  public void testFunctionWithReceiverSafeCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/functionWithReceiverSafeCall.kt");
  }

  @Test
  @TestMetadata("GenericFunctionParameter.kt")
  public void testGenericFunctionParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/GenericFunctionParameter.kt");
  }

  @Test
  @TestMetadata("GenericTypeInFunctionParameter.kt")
  public void testGenericTypeInFunctionParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/GenericTypeInFunctionParameter.kt");
  }

  @Test
  @TestMetadata("groupBy.kt")
  public void testGroupBy() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/groupBy.kt");
  }

  @Test
  @TestMetadata("implicitConstructorDelegationCall.kt")
  public void testImplicitConstructorDelegationCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitConstructorDelegationCall.kt");
  }

  @Test
  @TestMetadata("implicitConstuctorCall.kt")
  public void testImplicitConstuctorCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitConstuctorCall.kt");
  }

  @Test
  @TestMetadata("implicitExtensionInvoke.kt")
  public void testImplicitExtensionInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitExtensionInvoke.kt");
  }

  @Test
  @TestMetadata("implicitFunctionInvoke.kt")
  public void testImplicitFunctionInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitFunctionInvoke.kt");
  }

  @Test
  @TestMetadata("implicitFunctionalInterfaceInvoke.kt")
  public void testImplicitFunctionalInterfaceInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitFunctionalInterfaceInvoke.kt");
  }

  @Test
  @TestMetadata("implicitInvoke.kt")
  public void testImplicitInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitInvoke.kt");
  }

  @Test
  @TestMetadata("implicitInvokeWithReceiver.kt")
  public void testImplicitInvokeWithReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitInvokeWithReceiver.kt");
  }

  @Test
  @TestMetadata("implicitJavaConstuctorCall.kt")
  public void testImplicitJavaConstuctorCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitJavaConstuctorCall.kt");
  }

  @Test
  @TestMetadata("implicitLambdaParameter.kt")
  public void testImplicitLambdaParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/implicitLambdaParameter.kt");
  }

  @Test
  @TestMetadata("importAlias.kt")
  public void testImportAlias() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/importAlias.kt");
  }

  @Test
  @TestMetadata("ImportFromRootScope.kt")
  public void testImportFromRootScope() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ImportFromRootScope.kt");
  }

  @Test
  @TestMetadata("InClassParameter.kt")
  public void testInClassParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InClassParameter.kt");
  }

  @Test
  @TestMetadata("InClassParameterField.kt")
  public void testInClassParameterField() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InClassParameterField.kt");
  }

  @Test
  @TestMetadata("InEnumEntry.kt")
  public void testInEnumEntry() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InEnumEntry.kt");
  }

  @Test
  @TestMetadata("InFunctionParameterType.kt")
  public void testInFunctionParameterType() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InFunctionParameterType.kt");
  }

  @Test
  @TestMetadata("InMethodParameter.kt")
  public void testInMethodParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InMethodParameter.kt");
  }

  @Test
  @TestMetadata("InMethodVarargParameter.kt")
  public void testInMethodVarargParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InMethodVarargParameter.kt");
  }

  @Test
  @TestMetadata("InOperator.kt")
  public void testInOperator() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InOperator.kt");
  }

  @Test
  @TestMetadata("InVaragReferenceInFunctionBody.kt")
  public void testInVaragReferenceInFunctionBody() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InVaragReferenceInFunctionBody.kt");
  }

  @Test
  @TestMetadata("InVaragReferenceInNamedParameter.kt")
  public void testInVaragReferenceInNamedParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/InVaragReferenceInNamedParameter.kt");
  }

  @Test
  @TestMetadata("incWithDotQualifier.kt")
  public void testIncWithDotQualifier() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/incWithDotQualifier.kt");
  }

  @Test
  @TestMetadata("indexedGet.kt")
  public void testIndexedGet() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/indexedGet.kt");
  }

  @Test
  @TestMetadata("indexedSet.kt")
  public void testIndexedSet() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/indexedSet.kt");
  }

  @Test
  @TestMetadata("intArrayOfInAnnotation.kt")
  public void testIntArrayOfInAnnotation() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/intArrayOfInAnnotation.kt");
  }

  @Test
  @TestMetadata("intCollectionLiteral.kt")
  public void testIntCollectionLiteral() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/intCollectionLiteral.kt");
  }

  @Test
  @TestMetadata("javaClassReference.kt")
  public void testJavaClassReference() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/javaClassReference.kt");
  }

  @Test
  @TestMetadata("javaFunctionCall.kt")
  public void testJavaFunctionCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/javaFunctionCall.kt");
  }

  @Test
  @TestMetadata("javaPropertyGetter.kt")
  public void testJavaPropertyGetter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/javaPropertyGetter.kt");
  }

  @Test
  @TestMetadata("javaPropertyNestedGetter.kt")
  public void testJavaPropertyNestedGetter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/javaPropertyNestedGetter.kt");
  }

  @Test
  @TestMetadata("javaPropertySetter.kt")
  public void testJavaPropertySetter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/javaPropertySetter.kt");
  }

  @Test
  @TestMetadata("JsAsDynamic.kt")
  public void testJsAsDynamic() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/JsAsDynamic.kt");
  }

  @Test
  @TestMetadata("KotlinPropertyAssignment.kt")
  public void testKotlinPropertyAssignment() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/KotlinPropertyAssignment.kt");
  }

  @Test
  @TestMetadata("kotlinPropertyGetter_unqualified.kt")
  public void testKotlinPropertyGetter_unqualified() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPropertyGetter_unqualified.kt");
  }

  @Test
  @TestMetadata("kotlinPropertyNestedGetter.kt")
  public void testKotlinPropertyNestedGetter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPropertyNestedGetter.kt");
  }

  @Test
  @TestMetadata("kotlinPropertySetter_unqualified.kt")
  public void testKotlinPropertySetter_unqualified() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPropertySetter_unqualified.kt");
  }

  @Test
  @TestMetadata("KotlinPropertyWithGetterAndSetterAssignment.kt")
  public void testKotlinPropertyWithGetterAndSetterAssignment() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/KotlinPropertyWithGetterAndSetterAssignment.kt");
  }

  @Test
  @TestMetadata("labeledLambda.kt")
  public void testLabeledLambda() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/labeledLambda.kt");
  }

  @Test
  @TestMetadata("labeledLambdaInsideParentheses.kt")
  public void testLabeledLambdaInsideParentheses() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/labeledLambdaInsideParentheses.kt");
  }

  @Test
  @TestMetadata("LabelsReturn.kt")
  public void testLabelsReturn() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/LabelsReturn.kt");
  }

  @Test
  @TestMetadata("memberFunctionCallWithTypeArgument.kt")
  public void testMemberFunctionCallWithTypeArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/memberFunctionCallWithTypeArgument.kt");
  }

  @Test
  @TestMetadata("memberFunctionVsTopLevel.kt")
  public void testMemberFunctionVsTopLevel() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/memberFunctionVsTopLevel.kt");
  }

  @Test
  @TestMetadata("MultiDeclarationExtension.kt")
  public void testMultiDeclarationExtension() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/MultiDeclarationExtension.kt");
  }

  @Test
  @TestMetadata("MultiDeclarationMember.kt")
  public void testMultiDeclarationMember() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/MultiDeclarationMember.kt");
  }

  @Test
  @TestMetadata("NamedClassObject.kt")
  public void testNamedClassObject() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/NamedClassObject.kt");
  }

  @Test
  @TestMetadata("noBuiltIns.kt")
  public void testNoBuiltIns() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/noBuiltIns.kt");
  }

  @Test
  @TestMetadata("NotEqualsOperator.kt")
  public void testNotEqualsOperator() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/NotEqualsOperator.kt");
  }

  @Test
  @TestMetadata("NotInOperator.kt")
  public void testNotInOperator() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/NotInOperator.kt");
  }

  @Test
  @TestMetadata("overloadWithReceiver.kt")
  public void testOverloadWithReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/overloadWithReceiver.kt");
  }

  @Test
  @TestMetadata("PackageFromAnnotationOnFile.kt")
  public void testPackageFromAnnotationOnFile() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/PackageFromAnnotationOnFile.kt");
  }

  @Test
  @TestMetadata("PackageFromAnnotationOnFunction.kt")
  public void testPackageFromAnnotationOnFunction() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/PackageFromAnnotationOnFunction.kt");
  }

  @Test
  @TestMetadata("PackageReference.kt")
  public void testPackageReference() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/PackageReference.kt");
  }

  @Test
  @TestMetadata("PackageReferenceInImport.kt")
  public void testPackageReferenceInImport() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/PackageReferenceInImport.kt");
  }

  @Test
  @TestMetadata("parameterByName.kt")
  public void testParameterByName() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/parameterByName.kt");
  }

  @Test
  @TestMetadata("parameterByNameInSafeCall.kt")
  public void testParameterByNameInSafeCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/parameterByNameInSafeCall.kt");
  }

  @Test
  @TestMetadata("PlusAssignByHand.kt")
  public void testPlusAssignByHand() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/PlusAssignByHand.kt");
  }

  @Test
  @TestMetadata("PlusAssignOperator.kt")
  public void testPlusAssignOperator() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/PlusAssignOperator.kt");
  }

  @Test
  @TestMetadata("PlusAssignViaPlusOperator.kt")
  public void testPlusAssignViaPlusOperator() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/PlusAssignViaPlusOperator.kt");
  }

  @Test
  @TestMetadata("postfixUnaryOperatorOnVar.kt")
  public void testPostfixUnaryOperatorOnVar() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/postfixUnaryOperatorOnVar.kt");
  }

  @Test
  @TestMetadata("postfixUnaryOperatorOnVar_base.kt")
  public void testPostfixUnaryOperatorOnVar_base() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/postfixUnaryOperatorOnVar_base.kt");
  }

  @Test
  @TestMetadata("postfixUnaryOperatorWithArrayAccessConvention.kt")
  public void testPostfixUnaryOperatorWithArrayAccessConvention() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/postfixUnaryOperatorWithArrayAccessConvention.kt");
  }

  @Test
  @TestMetadata("postfixUnaryOperatorWithArrayAccessConvention_base.kt")
  public void testPostfixUnaryOperatorWithArrayAccessConvention_base() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/postfixUnaryOperatorWithArrayAccessConvention_base.kt");
  }

  @Test
  @TestMetadata("postfixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt")
  public void testPostfixUnaryOperatorWithArrayAccessConvention_complexDispatcher() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/postfixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt");
  }

  @Test
  @TestMetadata("prefixUnaryOperatorOnVar.kt")
  public void testPrefixUnaryOperatorOnVar() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/prefixUnaryOperatorOnVar.kt");
  }

  @Test
  @TestMetadata("prefixUnaryOperatorOnVar_base.kt")
  public void testPrefixUnaryOperatorOnVar_base() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/prefixUnaryOperatorOnVar_base.kt");
  }

  @Test
  @TestMetadata("prefixUnaryOperatorWithArrayAccessConvention.kt")
  public void testPrefixUnaryOperatorWithArrayAccessConvention() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/prefixUnaryOperatorWithArrayAccessConvention.kt");
  }

  @Test
  @TestMetadata("prefixUnaryOperatorWithArrayAccessConvention_base.kt")
  public void testPrefixUnaryOperatorWithArrayAccessConvention_base() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/prefixUnaryOperatorWithArrayAccessConvention_base.kt");
  }

  @Test
  @TestMetadata("prefixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt")
  public void testPrefixUnaryOperatorWithArrayAccessConvention_complexDispatcher() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/prefixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt");
  }

  @Test
  @TestMetadata("qualifiedCallSelector.kt")
  public void testQualifiedCallSelector() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedCallSelector.kt");
  }

  @Test
  @TestMetadata("qualifiedCalleeExpressionOfImplicitInvoke.kt")
  public void testQualifiedCalleeExpressionOfImplicitInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedCalleeExpressionOfImplicitInvoke.kt");
  }

  @Test
  @TestMetadata("qualifiedReferenceSelector.kt")
  public void testQualifiedReferenceSelector() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedReferenceSelector.kt");
  }

  @Test
  @TestMetadata("qualifiedWholeCall.kt")
  public void testQualifiedWholeCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedWholeCall.kt");
  }

  @Test
  @TestMetadata("qualifiedWholeReferenceSelector.kt")
  public void testQualifiedWholeReferenceSelector() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedWholeReferenceSelector.kt");
  }

  @Test
  @TestMetadata("ReferenceInClassWhereConstraint.kt")
  public void testReferenceInClassWhereConstraint() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ReferenceInClassWhereConstraint.kt");
  }

  @Test
  @TestMetadata("ReferenceInFunWhereConstraint.kt")
  public void testReferenceInFunWhereConstraint() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ReferenceInFunWhereConstraint.kt");
  }

  @Test
  @TestMetadata("ResolveClass.kt")
  public void testResolveClass() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ResolveClass.kt");
  }

  @Test
  @TestMetadata("ResolvePackageInProperty.kt")
  public void testResolvePackageInProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ResolvePackageInProperty.kt");
  }

  @Test
  @TestMetadata("ResolvePackageInTheEndInProperty.kt")
  public void testResolvePackageInTheEndInProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ResolvePackageInTheEndInProperty.kt");
  }

  @Test
  @TestMetadata("ResolvePackageInTheMiddleInProperty.kt")
  public void testResolvePackageInTheMiddleInProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ResolvePackageInTheMiddleInProperty.kt");
  }

  @Test
  @TestMetadata("ResolvePackageInTheTypeNameInProperty.kt")
  public void testResolvePackageInTheTypeNameInProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ResolvePackageInTheTypeNameInProperty.kt");
  }

  @Test
  @TestMetadata("RetentionValue.kt")
  public void testRetentionValue() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/RetentionValue.kt");
  }

  @Test
  @TestMetadata("safeQualifiedCallSelector.kt")
  public void testSafeQualifiedCallSelector() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/safeQualifiedCallSelector.kt");
  }

  @Test
  @TestMetadata("safeQualifiedReferenceSelector.kt")
  public void testSafeQualifiedReferenceSelector() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/safeQualifiedReferenceSelector.kt");
  }

  @Test
  @TestMetadata("safeQualifiedWholeCall.kt")
  public void testSafeQualifiedWholeCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/safeQualifiedWholeCall.kt");
  }

  @Test
  @TestMetadata("safeQualifiedWholeReferenceSelector.kt")
  public void testSafeQualifiedWholeReferenceSelector() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/safeQualifiedWholeReferenceSelector.kt");
  }

  @Test
  @TestMetadata("SamAdapter.kt")
  public void testSamAdapter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/SamAdapter.kt");
  }

  @Test
  @TestMetadata("SamConstructor.kt")
  public void testSamConstructor() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/SamConstructor.kt");
  }

  @Test
  @TestMetadata("samConstructorCall.kt")
  public void testSamConstructorCall() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/samConstructorCall.kt");
  }

  @Test
  @TestMetadata("SamConstructorTypeArguments.kt")
  public void testSamConstructorTypeArguments() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/SamConstructorTypeArguments.kt");
  }

  @Test
  @TestMetadata("samLambda.kt")
  public void testSamLambda() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/samLambda.kt");
  }

  @Test
  @TestMetadata("samMethodReference.kt")
  public void testSamMethodReference() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/samMethodReference.kt");
  }

  @Test
  @TestMetadata("SeveralOverrides.kt")
  public void testSeveralOverrides() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/SeveralOverrides.kt");
  }

  @Test
  @TestMetadata("shadowedProperty.kt")
  public void testShadowedProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/shadowedProperty.kt");
  }

  @Test
  @TestMetadata("smartCastExplicitDispatchReceiver.kt")
  public void testSmartCastExplicitDispatchReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastExplicitDispatchReceiver.kt");
  }

  @Test
  @TestMetadata("smartCastExplicitExtensionReceiver.kt")
  public void testSmartCastExplicitExtensionReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastExplicitExtensionReceiver.kt");
  }

  @Test
  @TestMetadata("smartCastExpression.kt")
  public void testSmartCastExpression() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastExpression.kt");
  }

  @Test
  @TestMetadata("smartCastImplicitDispatchReceiver.kt")
  public void testSmartCastImplicitDispatchReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastImplicitDispatchReceiver.kt");
  }

  @Test
  @TestMetadata("smartCastImplicitExtensionReceiver.kt")
  public void testSmartCastImplicitExtensionReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastImplicitExtensionReceiver.kt");
  }

  @Test
  @TestMetadata("smartCastInvokeReceiver.kt")
  public void testSmartCastInvokeReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastInvokeReceiver.kt");
  }

  @Test
  @TestMetadata("smartCastedArg.kt")
  public void testSmartCastedArg() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastedArg.kt");
  }

  @Test
  @TestMetadata("smartCastedNonNullArg.kt")
  public void testSmartCastedNonNullArg() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/smartCastedNonNullArg.kt");
  }

  @Test
  @TestMetadata("staticFieldFromJavaClassFromSuper.kt")
  public void testStaticFieldFromJavaClassFromSuper() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticFieldFromJavaClassFromSuper.kt");
  }

  @Test
  @TestMetadata("staticImportFunction.kt")
  public void testStaticImportFunction() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportFunction.kt");
  }

  @Test
  @TestMetadata("staticImportFunctionFromSuper.kt")
  public void testStaticImportFunctionFromSuper() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportFunctionFromSuper.kt");
  }

  @Test
  @TestMetadata("staticImportNestedFunction.kt")
  public void testStaticImportNestedFunction() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportNestedFunction.kt");
  }

  @Test
  @TestMetadata("staticImportNestedJavaField.kt")
  public void testStaticImportNestedJavaField() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportNestedJavaField.kt");
  }

  @Test
  @TestMetadata("staticImportNestedJavaFunction.kt")
  public void testStaticImportNestedJavaFunction() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportNestedJavaFunction.kt");
  }

  @Test
  @TestMetadata("staticImportNestedProperty.kt")
  public void testStaticImportNestedProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportNestedProperty.kt");
  }

  @Test
  @TestMetadata("staticImportProperty.kt")
  public void testStaticImportProperty() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportProperty.kt");
  }

  @Test
  @TestMetadata("staticImportPropertyFromSuper.kt")
  public void testStaticImportPropertyFromSuper() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticImportPropertyFromSuper.kt");
  }

  @Test
  @TestMetadata("staticMethodFromJavaClass.kt")
  public void testStaticMethodFromJavaClass() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticMethodFromJavaClass.kt");
  }

  @Test
  @TestMetadata("staticMethodFromJavaClassFromSuper.kt")
  public void testStaticMethodFromJavaClassFromSuper() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/staticMethodFromJavaClassFromSuper.kt");
  }

  @Test
  @TestMetadata("SuperTypePrimaryConstructor.kt")
  public void testSuperTypePrimaryConstructor() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/SuperTypePrimaryConstructor.kt");
  }

  @Test
  @TestMetadata("SuperTypeSecondaryConstructor.kt")
  public void testSuperTypeSecondaryConstructor() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/SuperTypeSecondaryConstructor.kt");
  }

  @Test
  @TestMetadata("superWithLabel_caretAtLabel.kt")
  public void testSuperWithLabel_caretAtLabel() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/superWithLabel_caretAtLabel.kt");
  }

  @Test
  @TestMetadata("superWithLabel_caretAtSuper.kt")
  public void testSuperWithLabel_caretAtSuper() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/superWithLabel_caretAtSuper.kt");
  }

  @Test
  @TestMetadata("thisWithLabelToFunction_caretAtLabel.kt")
  public void testThisWithLabelToFunction_caretAtLabel() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/thisWithLabelToFunction_caretAtLabel.kt");
  }

  @Test
  @TestMetadata("thisWithLabelToFunction_caretAtThis.kt")
  public void testThisWithLabelToFunction_caretAtThis() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/thisWithLabelToFunction_caretAtThis.kt");
  }

  @Test
  @TestMetadata("thisWithLabelToProperty_caretAtLabel.kt")
  public void testThisWithLabelToProperty_caretAtLabel() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/thisWithLabelToProperty_caretAtLabel.kt");
  }

  @Test
  @TestMetadata("thisWithLabelToProperty_caretAtThis.kt")
  public void testThisWithLabelToProperty_caretAtThis() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/thisWithLabelToProperty_caretAtThis.kt");
  }

  @Test
  @TestMetadata("todo.kt")
  public void testTodo() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/todo.kt");
  }

  @Test
  @TestMetadata("TopLevelClassVsLocalClassConstructor.kt")
  public void testTopLevelClassVsLocalClassConstructor() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelClassVsLocalClassConstructor.kt");
  }

  @Test
  @TestMetadata("TopLevelClassVsLocalClassConstructor2.kt")
  public void testTopLevelClassVsLocalClassConstructor2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelClassVsLocalClassConstructor2.kt");
  }

  @Test
  @TestMetadata("TopLevelCompanionObjectVsLocalClassConstructor.kt")
  public void testTopLevelCompanionObjectVsLocalClassConstructor() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelCompanionObjectVsLocalClassConstructor.kt");
  }

  @Test
  @TestMetadata("TopLevelCompanionObjectVsLocalClassConstructor2.kt")
  public void testTopLevelCompanionObjectVsLocalClassConstructor2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelCompanionObjectVsLocalClassConstructor2.kt");
  }

  @Test
  @TestMetadata("TopLevelCompanionObjectVsLocalClassQualifier.kt")
  public void testTopLevelCompanionObjectVsLocalClassQualifier() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelCompanionObjectVsLocalClassQualifier.kt");
  }

  @Test
  @TestMetadata("TopLevelObjectVsLocalClassConstructor.kt")
  public void testTopLevelObjectVsLocalClassConstructor() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelObjectVsLocalClassConstructor.kt");
  }

  @Test
  @TestMetadata("TopLevelObjectVsLocalClassConstructor2.kt")
  public void testTopLevelObjectVsLocalClassConstructor2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelObjectVsLocalClassConstructor2.kt");
  }

  @Test
  @TestMetadata("TopLevelObjectVsLocalClassConstructor3.kt")
  public void testTopLevelObjectVsLocalClassConstructor3() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelObjectVsLocalClassConstructor3.kt");
  }

  @Test
  @TestMetadata("TopLevelObjectVsLocalClassConstructor4.kt")
  public void testTopLevelObjectVsLocalClassConstructor4() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelObjectVsLocalClassConstructor4.kt");
  }

  @Test
  @TestMetadata("TopLevelObjectVsLocalClassQualifier.kt")
  public void testTopLevelObjectVsLocalClassQualifier() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/TopLevelObjectVsLocalClassQualifier.kt");
  }

  @Test
  @TestMetadata("unresolvableOperator_elvis_1.kt")
  public void testUnresolvableOperator_elvis_1() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/unresolvableOperator_elvis_1.kt");
  }

  @Test
  @TestMetadata("unresolvableOperator_elvis_2.kt")
  public void testUnresolvableOperator_elvis_2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/unresolvableOperator_elvis_2.kt");
  }

  @Test
  @TestMetadata("unresolvableOperator_eqeqeq_1.kt")
  public void testUnresolvableOperator_eqeqeq_1() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/unresolvableOperator_eqeqeq_1.kt");
  }

  @Test
  @TestMetadata("unresolvableOperator_eqeqeq_2.kt")
  public void testUnresolvableOperator_eqeqeq_2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/unresolvableOperator_eqeqeq_2.kt");
  }

  @Test
  @TestMetadata("unresolvableOperator_excleqeq_1.kt")
  public void testUnresolvableOperator_excleqeq_1() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/unresolvableOperator_excleqeq_1.kt");
  }

  @Test
  @TestMetadata("unresolvableOperator_excleqeq_2.kt")
  public void testUnresolvableOperator_excleqeq_2() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/unresolvableOperator_excleqeq_2.kt");
  }

  @Test
  @TestMetadata("UnresolvedCallArgument.kt")
  public void testUnresolvedCallArgument() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/UnresolvedCallArgument.kt");
  }

  @Test
  @TestMetadata("unsignedArrayOf.kt")
  public void testUnsignedArrayOf() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/unsignedArrayOf.kt");
  }

  @Test
  @TestMetadata("ValueParameter.kt")
  public void testValueParameter() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/ValueParameter.kt");
  }

  @Test
  @TestMetadata("variableAsFunction.kt")
  public void testVariableAsFunction() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableAsFunction.kt");
  }

  @Test
  @TestMetadata("variableAsFunctionWithParameterName.kt")
  public void testVariableAsFunctionWithParameterName() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableAsFunctionWithParameterName.kt");
  }

  @Test
  @TestMetadata("variableAsFunctionWithParameterNameAnnotation.kt")
  public void testVariableAsFunctionWithParameterNameAnnotation() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableAsFunctionWithParameterNameAnnotation.kt");
  }

  @Test
  @TestMetadata("variableAsFunctionWithParameterNameAnnotationConflict.kt")
  public void testVariableAsFunctionWithParameterNameAnnotationConflict() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableAsFunctionWithParameterNameAnnotationConflict.kt");
  }

  @Test
  @TestMetadata("variableAsFunctionWithParameterNameGeneric.kt")
  public void testVariableAsFunctionWithParameterNameGeneric() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableAsFunctionWithParameterNameGeneric.kt");
  }

  @Test
  @TestMetadata("variableAsFunctionWithParameterNameInNonFunctionType.kt")
  public void testVariableAsFunctionWithParameterNameInNonFunctionType() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableAsFunctionWithParameterNameInNonFunctionType.kt");
  }

  @Test
  @TestMetadata("variableAsFunctionWithParameterNameMixed.kt")
  public void testVariableAsFunctionWithParameterNameMixed() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableAsFunctionWithParameterNameMixed.kt");
  }

  @Test
  @TestMetadata("variableWithExtensionInvoke.kt")
  public void testVariableWithExtensionInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableWithExtensionInvoke.kt");
  }

  @Test
  @TestMetadata("variableWithInvokeFunctionCall_dispatchReceiver.kt")
  public void testVariableWithInvokeFunctionCall_dispatchReceiver() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableWithInvokeFunctionCall_dispatchReceiver.kt");
  }

  @Test
  @TestMetadata("variableWithMemberInvoke.kt")
  public void testVariableWithMemberInvoke() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/variableWithMemberInvoke.kt");
  }

  @Test
  @TestMetadata("whenConditionInRange.kt")
  public void testWhenConditionInRange() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/whenConditionInRange.kt");
  }

  @Test
  @TestMetadata("whenConditionInRangeInverted.kt")
  public void testWhenConditionInRangeInverted() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/whenConditionInRangeInverted.kt");
  }

  @Test
  @TestMetadata("whenSelectorSmartCast.kt")
  public void testWhenSelectorSmartCast() {
    runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/whenSelectorSmartCast.kt");
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess")
  @TestDataPath("$PROJECT_ROOT")
  public class ArrayAccess {
    @Test
    public void testAllFilesPresentInArrayAccess() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("get.kt")
    public void testGet() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/get.kt");
    }

    @Test
    @TestMetadata("getOperator.kt")
    public void testGetOperator() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/getOperator.kt");
    }

    @Test
    @TestMetadata("set.kt")
    public void testSet() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/set.kt");
    }

    @Test
    @TestMetadata("setOperator.kt")
    public void testSetOperator() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/setOperator.kt");
    }

    @Test
    @TestMetadata("SetOperatorInc.kt")
    public void testSetOperatorInc() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/SetOperatorInc.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/withErrors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithErrors {
      @Test
      public void testAllFilesPresentInWithErrors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("getFunction.kt")
      public void testGetFunction() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/withErrors/getFunction.kt");
      }

      @Test
      @TestMetadata("setFunction.kt")
      public void testSetFunction() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/withErrors/setFunction.kt");
      }

      @Test
      @TestMetadata("SetOperatorInc.kt")
      public void testSetOperatorInc() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/arrayAccess/withErrors/SetOperatorInc.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences")
  @TestDataPath("$PROJECT_ROOT")
  public class CallableReferences {
    @Test
    public void testAllFilesPresentInCallableReferences() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("annotationConstructor.kt")
    public void testAnnotationConstructor() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/annotationConstructor.kt");
    }

    @Test
    @TestMetadata("boundMemberExtensionFunction.kt")
    public void testBoundMemberExtensionFunction() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/boundMemberExtensionFunction.kt");
    }

    @Test
    @TestMetadata("boundMemberFunction.kt")
    public void testBoundMemberFunction() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/boundMemberFunction.kt");
    }

    @Test
    @TestMetadata("boundMemberFunction_lhs.kt")
    public void testBoundMemberFunction_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/boundMemberFunction_lhs.kt");
    }

    @Test
    @TestMetadata("boundMemberFunction_rhs.kt")
    public void testBoundMemberFunction_rhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/boundMemberFunction_rhs.kt");
    }

    @Test
    @TestMetadata("boundMemberProperty.kt")
    public void testBoundMemberProperty() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/boundMemberProperty.kt");
    }

    @Test
    @TestMetadata("boundTopLevelExtensionFunction.kt")
    public void testBoundTopLevelExtensionFunction() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/boundTopLevelExtensionFunction.kt");
    }

    @Test
    @TestMetadata("boundTopLevelExtensionProperty.kt")
    public void testBoundTopLevelExtensionProperty() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/boundTopLevelExtensionProperty.kt");
    }

    @Test
    @TestMetadata("buildList_implicit.kt")
    public void testBuildList_implicit() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/buildList_implicit.kt");
    }

    @Test
    @TestMetadata("buildList_let.kt")
    public void testBuildList_let() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/buildList_let.kt");
    }

    @Test
    @TestMetadata("buildList_otherList.kt")
    public void testBuildList_otherList() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/buildList_otherList.kt");
    }

    @Test
    @TestMetadata("buildList_this.kt")
    public void testBuildList_this() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/buildList_this.kt");
    }

    @Test
    @TestMetadata("constructor.kt")
    public void testConstructor() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/constructor.kt");
    }

    @Test
    @TestMetadata("genericParameterType.kt")
    public void testGenericParameterType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/genericParameterType.kt");
    }

    @Test
    @TestMetadata("genericParameterTypeGenericConsumer.kt")
    public void testGenericParameterTypeGenericConsumer() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/genericParameterTypeGenericConsumer.kt");
    }

    @Test
    @TestMetadata("genericReturnType.kt")
    public void testGenericReturnType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/genericReturnType.kt");
    }

    @Test
    @TestMetadata("genericReturnTypeGenericConsumer.kt")
    public void testGenericReturnTypeGenericConsumer() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/genericReturnTypeGenericConsumer.kt");
    }

    @Test
    @TestMetadata("memberExtensionProperty.kt")
    public void testMemberExtensionProperty() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/memberExtensionProperty.kt");
    }

    @Test
    @TestMetadata("memberFunction.kt")
    public void testMemberFunction() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/memberFunction.kt");
    }

    @Test
    @TestMetadata("memberProperty.kt")
    public void testMemberProperty() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/memberProperty.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/simple.kt");
    }

    @Test
    @TestMetadata("topLevelExtensionFunction.kt")
    public void testTopLevelExtensionFunction() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/topLevelExtensionFunction.kt");
    }

    @Test
    @TestMetadata("topLevelExtensionProperty.kt")
    public void testTopLevelExtensionProperty() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/topLevelExtensionProperty.kt");
    }

    @Test
    @TestMetadata("topLevelFunction.kt")
    public void testTopLevelFunction() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/topLevelFunction.kt");
    }

    @Test
    @TestMetadata("topLevelProperty.kt")
    public void testTopLevelProperty() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/callableReferences/topLevelProperty.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment")
  @TestDataPath("$PROJECT_ROOT")
  public class CodeFragment {
    @Test
    public void testAllFilesPresentInCodeFragment() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment")
    @TestDataPath("$PROJECT_ROOT")
    public class BlockCodeFragment {
      @Test
      public void testAllFilesPresentInBlockCodeFragment() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("BinaryExpression.kt")
      public void testBinaryExpression() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/BinaryExpression.kt");
      }

      @Test
      @TestMetadata("CompanionCall.kt")
      public void testCompanionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/CompanionCall.kt");
      }

      @Test
      @TestMetadata("ContextFunctionCall.kt")
      public void testContextFunctionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/ContextFunctionCall.kt");
      }

      @Test
      @TestMetadata("FunctionCall.kt")
      public void testFunctionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/FunctionCall.kt");
      }

      @Test
      @TestMetadata("LocalFunctionCall.kt")
      public void testLocalFunctionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/LocalFunctionCall.kt");
      }

      @Test
      @TestMetadata("NestedCodeFragment.kt")
      public void testNestedCodeFragment() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/NestedCodeFragment.kt");
      }

      @Test
      @TestMetadata("NestedCodeFragmentClass.kt")
      public void testNestedCodeFragmentClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/NestedCodeFragmentClass.kt");
      }

      @Test
      @TestMetadata("NestedCodeFragmentClassMember.kt")
      public void testNestedCodeFragmentClassMember() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/NestedCodeFragmentClassMember.kt");
      }

      @Test
      @TestMetadata("NestedCodeFragmentFunction.kt")
      public void testNestedCodeFragmentFunction() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/NestedCodeFragmentFunction.kt");
      }

      @Test
      @TestMetadata("PropertyCall.kt")
      public void testPropertyCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/PropertyCall.kt");
      }

      @Test
      @TestMetadata("SecondStatement.kt")
      public void testSecondStatement() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/blockCodeFragment/SecondStatement.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment")
    @TestDataPath("$PROJECT_ROOT")
    public class ExpressionCodeFragment {
      @Test
      public void testAllFilesPresentInExpressionCodeFragment() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("ArrayAssignmentOperator.kt")
      public void testArrayAssignmentOperator() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/ArrayAssignmentOperator.kt");
      }

      @Test
      @TestMetadata("ArrayPlusAssignmentOperator.kt")
      public void testArrayPlusAssignmentOperator() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/ArrayPlusAssignmentOperator.kt");
      }

      @Test
      @TestMetadata("BinaryExpression.kt")
      public void testBinaryExpression() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/BinaryExpression.kt");
      }

      @Test
      @TestMetadata("CompanionCall.kt")
      public void testCompanionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/CompanionCall.kt");
      }

      @Test
      @TestMetadata("ContextFunctionCall.kt")
      public void testContextFunctionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/ContextFunctionCall.kt");
      }

      @Test
      @TestMetadata("FunctionCall.kt")
      public void testFunctionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/FunctionCall.kt");
      }

      @Test
      @TestMetadata("LocalFunctionCall.kt")
      public void testLocalFunctionCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/LocalFunctionCall.kt");
      }

      @Test
      @TestMetadata("NestedCodeFragment.kt")
      public void testNestedCodeFragment() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/NestedCodeFragment.kt");
      }

      @Test
      @TestMetadata("NestedCodeFragmentUsage.kt")
      public void testNestedCodeFragmentUsage() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/NestedCodeFragmentUsage.kt");
      }

      @Test
      @TestMetadata("PropertyCall.kt")
      public void testPropertyCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/expressionCodeFragment/PropertyCall.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment")
    @TestDataPath("$PROJECT_ROOT")
    public class TypeCodeFragment {
      @Test
      public void testAllFilesPresentInTypeCodeFragment() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("FromContextFile.kt")
      public void testFromContextFile() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/FromContextFile.kt");
      }

      @Test
      @TestMetadata("FromContextModule.kt")
      public void testFromContextModule() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/FromContextModule.kt");
      }

      @Test
      @TestMetadata("GenericType.kt")
      public void testGenericType() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/GenericType.kt");
      }

      @Test
      @TestMetadata("GenericTypeArgument.kt")
      public void testGenericTypeArgument() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/GenericTypeArgument.kt");
      }

      @Test
      @TestMetadata("LocalClass.kt")
      public void testLocalClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/LocalClass.kt");
      }

      @Test
      @TestMetadata("Simple.kt")
      public void testSimple() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/Simple.kt");
      }

      @Test
      @TestMetadata("TypeAnnotation.kt")
      public void testTypeAnnotation() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/TypeAnnotation.kt");
      }

      @Test
      @TestMetadata("TypeParameter.kt")
      public void testTypeParameter() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/codeFragment/typeCodeFragment/TypeParameter.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorDelegatingReference")
  @TestDataPath("$PROJECT_ROOT")
  public class ConstructorDelegatingReference {
    @Test
    public void testAllFilesPresentInConstructorDelegatingReference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorDelegatingReference"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("constructorDelegationReferenceSuper.kt")
    public void testConstructorDelegationReferenceSuper() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorDelegatingReference/constructorDelegationReferenceSuper.kt");
    }

    @Test
    @TestMetadata("constructorDelegationReferenceThis.kt")
    public void testConstructorDelegationReferenceThis() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorDelegatingReference/constructorDelegationReferenceThis.kt");
    }

    @Test
    @TestMetadata("constructorDelegationReferenceThisImplicit.kt")
    public void testConstructorDelegationReferenceThisImplicit() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorDelegatingReference/constructorDelegationReferenceThisImplicit.kt");
    }

    @Test
    @TestMetadata("toPrimary.kt")
    public void testToPrimary() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorDelegatingReference/toPrimary.kt");
    }

    @Test
    @TestMetadata("toSecondary.kt")
    public void testToSecondary() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/constructorDelegatingReference/toSecondary.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations")
  @TestDataPath("$PROJECT_ROOT")
  public class DanglingAnnotations {
    @Test
    public void testAllFilesPresentInDanglingAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("DanglingAnnotationsResolvedAnonymous.kt")
    public void testDanglingAnnotationsResolvedAnonymous() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations/DanglingAnnotationsResolvedAnonymous.kt");
    }

    @Test
    @TestMetadata("DanglingAnnotationsResolvedClass.kt")
    public void testDanglingAnnotationsResolvedClass() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations/DanglingAnnotationsResolvedClass.kt");
    }

    @Test
    @TestMetadata("DanglingAnnotationsResolvedFile.kt")
    public void testDanglingAnnotationsResolvedFile() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations/DanglingAnnotationsResolvedFile.kt");
    }

    @Test
    @TestMetadata("DanglingAnnotationsResolvedLocal.kt")
    public void testDanglingAnnotationsResolvedLocal() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations/DanglingAnnotationsResolvedLocal.kt");
    }

    @Test
    @TestMetadata("DanglingAnnotationsResolvedPackageFile.kt")
    public void testDanglingAnnotationsResolvedPackageFile() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations/DanglingAnnotationsResolvedPackageFile.kt");
    }

    @Test
    @TestMetadata("DanglingAnnotationsResolvedTopLevel.kt")
    public void testDanglingAnnotationsResolvedTopLevel() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/danglingAnnotations/DanglingAnnotationsResolvedTopLevel.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors")
  @TestDataPath("$PROJECT_ROOT")
  public class DelegatedPropertyAccessors {
    @Test
    public void testAllFilesPresentInDelegatedPropertyAccessors() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource")
    @TestDataPath("$PROJECT_ROOT")
    public class InSource {
      @Test
      public void testAllFilesPresentInInSource() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("getExtension.kt")
      public void testGetExtension() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource/getExtension.kt");
      }

      @Test
      @TestMetadata("getMember.kt")
      public void testGetMember() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource/getMember.kt");
      }

      @Test
      @TestMetadata("getMultipleDeclarations.kt")
      public void testGetMultipleDeclarations() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource/getMultipleDeclarations.kt");
      }

      @Test
      @TestMetadata("getOneFakeOverride.kt")
      public void testGetOneFakeOverride() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource/getOneFakeOverride.kt");
      }

      @Test
      @TestMetadata("provideDelegate.kt")
      public void testProvideDelegate() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource/provideDelegate.kt");
      }

      @Test
      @TestMetadata("provideDelegate_explicit.kt")
      public void testProvideDelegate_explicit() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inSource/provideDelegate_explicit.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inStandardLibrary")
    @TestDataPath("$PROJECT_ROOT")
    public class InStandardLibrary {
      @Test
      public void testAllFilesPresentInInStandardLibrary() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inStandardLibrary"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("lazy.kt")
      public void testLazy() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inStandardLibrary/lazy.kt");
      }

      @Test
      @TestMetadata("notNull.kt")
      public void testNotNull() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/inStandardLibrary/notNull.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/withErrors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithErrors {
      @Test
      public void testAllFilesPresentInWithErrors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("provideDelegate_badDelegate.kt")
      public void testProvideDelegate_badDelegate() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/withErrors/provideDelegate_badDelegate.kt");
      }

      @Test
      @TestMetadata("unresolved.kt")
      public void testUnresolved() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/delegatedPropertyAccessors/withErrors/unresolved.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions")
  @TestDataPath("$PROJECT_ROOT")
  public class Expressions {
    @Test
    public void testAllFilesPresentInExpressions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("arrayAccessConvention.kt")
    public void testArrayAccessConvention() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConvention.kt");
    }

    @Test
    @TestMetadata("arrayAccessConventionAsClass.kt")
    public void testArrayAccessConventionAsClass() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConventionAsClass.kt");
    }

    @Test
    @TestMetadata("arrayAccessConventionAsClass_lhs.kt")
    public void testArrayAccessConventionAsClass_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConventionAsClass_lhs.kt");
    }

    @Test
    @TestMetadata("arrayAccessConventionAsClass_op.kt")
    public void testArrayAccessConventionAsClass_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConventionAsClass_op.kt");
    }

    @Test
    @TestMetadata("arrayAccessConvention_complexReceivers.kt")
    public void testArrayAccessConvention_complexReceivers() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConvention_complexReceivers.kt");
    }

    @Test
    @TestMetadata("arrayAccessConvention_complexReceivers_lhs.kt")
    public void testArrayAccessConvention_complexReceivers_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConvention_complexReceivers_lhs.kt");
    }

    @Test
    @TestMetadata("arrayAccessConvention_complexReceivers_op.kt")
    public void testArrayAccessConvention_complexReceivers_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConvention_complexReceivers_op.kt");
    }

    @Test
    @TestMetadata("arrayAccessConvention_lhs.kt")
    public void testArrayAccessConvention_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConvention_lhs.kt");
    }

    @Test
    @TestMetadata("arrayAccessConvention_op.kt")
    public void testArrayAccessConvention_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/arrayAccessConvention_op.kt");
    }

    @Test
    @TestMetadata("infixFunction.kt")
    public void testInfixFunction() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/infixFunction.kt");
    }

    @Test
    @TestMetadata("infixFunction_op.kt")
    public void testInfixFunction_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/infixFunction_op.kt");
    }

    @Test
    @TestMetadata("plusAssignOnVal.kt")
    public void testPlusAssignOnVal() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/plusAssignOnVal.kt");
    }

    @Test
    @TestMetadata("plusAssignOnVal_lhs.kt")
    public void testPlusAssignOnVal_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/plusAssignOnVal_lhs.kt");
    }

    @Test
    @TestMetadata("plusAssignOnVal_operator.kt")
    public void testPlusAssignOnVal_operator() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/plusAssignOnVal_operator.kt");
    }

    @Test
    @TestMetadata("plusAssignWithArrayGetConvention.kt")
    public void testPlusAssignWithArrayGetConvention() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/plusAssignWithArrayGetConvention.kt");
    }

    @Test
    @TestMetadata("plusAssignWithArrayGetConvention_lhs.kt")
    public void testPlusAssignWithArrayGetConvention_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/plusAssignWithArrayGetConvention_lhs.kt");
    }

    @Test
    @TestMetadata("plusAssignWithArrayGetConvention_op.kt")
    public void testPlusAssignWithArrayGetConvention_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/plusAssignWithArrayGetConvention_op.kt");
    }

    @Test
    @TestMetadata("postfixInc.kt")
    public void testPostfixInc() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/postfixInc.kt");
    }

    @Test
    @TestMetadata("postfixInc_base.kt")
    public void testPostfixInc_base() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/postfixInc_base.kt");
    }

    @Test
    @TestMetadata("postfixInc_op.kt")
    public void testPostfixInc_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/postfixInc_op.kt");
    }

    @Test
    @TestMetadata("prefixDec.kt")
    public void testPrefixDec() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/prefixDec.kt");
    }

    @Test
    @TestMetadata("prefixDec_base.kt")
    public void testPrefixDec_base() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/prefixDec_base.kt");
    }

    @Test
    @TestMetadata("prefixDec_op.kt")
    public void testPrefixDec_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/prefixDec_op.kt");
    }

    @Test
    @TestMetadata("setOperator.kt")
    public void testSetOperator() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/setOperator.kt");
    }

    @Test
    @TestMetadata("setOperator_lhs.kt")
    public void testSetOperator_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/setOperator_lhs.kt");
    }

    @Test
    @TestMetadata("setOperator_op.kt")
    public void testSetOperator_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/setOperator_op.kt");
    }

    @Test
    @TestMetadata("unaryMinus.kt")
    public void testUnaryMinus() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/unaryMinus.kt");
    }

    @Test
    @TestMetadata("unaryMinus_base.kt")
    public void testUnaryMinus_base() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/unaryMinus_base.kt");
    }

    @Test
    @TestMetadata("unaryMinus_op.kt")
    public void testUnaryMinus_op() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/unaryMinus_op.kt");
    }

    @Test
    @TestMetadata("varConvention.kt")
    public void testVarConvention() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/varConvention.kt");
    }

    @Test
    @TestMetadata("varConvention_lhs.kt")
    public void testVarConvention_lhs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/varConvention_lhs.kt");
    }

    @Test
    @TestMetadata("varConvention_operator.kt")
    public void testVarConvention_operator() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/expressions/varConvention_operator.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn")
  @TestDataPath("$PROJECT_ROOT")
  public class ForLoopIn {
    @Test
    public void testAllFilesPresentInForLoopIn() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inBuiltIns")
    @TestDataPath("$PROJECT_ROOT")
    public class InBuiltIns {
      @Test
      public void testAllFilesPresentInInBuiltIns() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inBuiltIns"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("extension.kt")
      public void testExtension() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inBuiltIns/extension.kt");
      }

      @Test
      @TestMetadata("member.kt")
      public void testMember() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inBuiltIns/member.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inLibrary")
    @TestDataPath("$PROJECT_ROOT")
    public class InLibrary {
      @Test
      public void testAllFilesPresentInInLibrary() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inLibrary"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("extension.kt")
      public void testExtension() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inLibrary/extension.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inSource")
    @TestDataPath("$PROJECT_ROOT")
    public class InSource {
      @Test
      @TestMetadata("allExtensions.kt")
      public void testAllExtensions() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inSource/allExtensions.kt");
      }

      @Test
      public void testAllFilesPresentInInSource() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inSource"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("allMembers.kt")
      public void testAllMembers() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inSource/allMembers.kt");
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inSource/withErrors")
      @TestDataPath("$PROJECT_ROOT")
      public class WithErrors {
        @Test
        public void testAllFilesPresentInWithErrors() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inSource/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("nextMissing.kt")
        public void testNextMissing() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/inSource/withErrors/nextMissing.kt");
        }
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/withErrors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithErrors {
      @Test
      public void testAllFilesPresentInWithErrors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("unresolvedIterator.kt")
      public void testUnresolvedIterator() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/forLoopIn/withErrors/unresolvedIterator.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/globallyDuplicateLibraries")
  @TestDataPath("$PROJECT_ROOT")
  public class GloballyDuplicateLibraries {
    @Test
    public void testAllFilesPresentInGloballyDuplicateLibraries() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/globallyDuplicateLibraries"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("functionCallsInIndependentModulesWithGloballyDuplicateJavaLibrary.kt")
    public void testFunctionCallsInIndependentModulesWithGloballyDuplicateJavaLibrary() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/globallyDuplicateLibraries/functionCallsInIndependentModulesWithGloballyDuplicateJavaLibrary.kt");
    }

    @Test
    @TestMetadata("functionCallsInIndependentModulesWithGloballyDuplicateLibrary.kt")
    public void testFunctionCallsInIndependentModulesWithGloballyDuplicateLibrary() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/globallyDuplicateLibraries/functionCallsInIndependentModulesWithGloballyDuplicateLibrary.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke")
  @TestDataPath("$PROJECT_ROOT")
  public class Invoke {
    @Test
    public void testAllFilesPresentInInvoke() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("functionClash.kt")
    public void testFunctionClash() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/functionClash.kt");
    }

    @Test
    @TestMetadata("functionClashWithParenthesis.kt")
    public void testFunctionClashWithParenthesis() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/functionClashWithParenthesis.kt");
    }

    @Test
    @TestMetadata("lambdaAndParens.kt")
    public void testLambdaAndParens() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaAndParens.kt");
    }

    @Test
    @TestMetadata("lambdaNoPar.kt")
    public void testLambdaNoPar() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaNoPar.kt");
    }

    @Test
    @TestMetadata("lambdaNoParLabel.kt")
    public void testLambdaNoParLabel() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaNoParLabel.kt");
    }

    @Test
    @TestMetadata("lambdaNoParRCurly.kt")
    public void testLambdaNoParRCurly() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaNoParRCurly.kt");
    }

    @Test
    @TestMetadata("lambdaWithExtensionParameter_extensionProperty_regularCall.kt")
    public void testLambdaWithExtensionParameter_extensionProperty_regularCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaWithExtensionParameter_extensionProperty_regularCall.kt");
    }

    @Test
    @TestMetadata("lambdaWithExtensionParameter_extensionProperty_safeCall.kt")
    public void testLambdaWithExtensionParameter_extensionProperty_safeCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaWithExtensionParameter_extensionProperty_safeCall.kt");
    }

    @Test
    @TestMetadata("lambdaWithExtensionParameter_parameter_regularCall.kt")
    public void testLambdaWithExtensionParameter_parameter_regularCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaWithExtensionParameter_parameter_regularCall.kt");
    }

    @Test
    @TestMetadata("lambdaWithExtensionParameter_parameter_safeCall.kt")
    public void testLambdaWithExtensionParameter_parameter_safeCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaWithExtensionParameter_parameter_safeCall.kt");
    }

    @Test
    @TestMetadata("lambdaWithExtensionParameter_property_regularCall.kt")
    public void testLambdaWithExtensionParameter_property_regularCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaWithExtensionParameter_property_regularCall.kt");
    }

    @Test
    @TestMetadata("lambdaWithExtensionParameter_property_safeCall.kt")
    public void testLambdaWithExtensionParameter_property_safeCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/lambdaWithExtensionParameter_property_safeCall.kt");
    }

    @Test
    @TestMetadata("noParams.kt")
    public void testNoParams() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/noParams.kt");
    }

    @Test
    @TestMetadata("noParamsRPar.kt")
    public void testNoParamsRPar() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/noParamsRPar.kt");
    }

    @Test
    @TestMetadata("nonemptyLambdaRPar.kt")
    public void testNonemptyLambdaRPar() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/nonemptyLambdaRPar.kt");
    }

    @Test
    @TestMetadata("oneParam.kt")
    public void testOneParam() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/oneParam.kt");
    }

    @Test
    @TestMetadata("oneParamRPar.kt")
    public void testOneParamRPar() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/oneParamRPar.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects")
    @TestDataPath("$PROJECT_ROOT")
    public class OnObjects {
      @Test
      public void testAllFilesPresentInOnObjects() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("companionObject1.kt")
      public void testCompanionObject1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/companionObject1.kt");
      }

      @Test
      @TestMetadata("companionObject2.kt")
      public void testCompanionObject2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/companionObject2.kt");
      }

      @Test
      @TestMetadata("companionObjectWithName1.kt")
      public void testCompanionObjectWithName1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/companionObjectWithName1.kt");
      }

      @Test
      @TestMetadata("companionObjectWithName2.kt")
      public void testCompanionObjectWithName2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/companionObjectWithName2.kt");
      }

      @Test
      @TestMetadata("nestedObject1.kt")
      public void testNestedObject1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/nestedObject1.kt");
      }

      @Test
      @TestMetadata("nestedObject2.kt")
      public void testNestedObject2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/nestedObject2.kt");
      }

      @Test
      @TestMetadata("nestedObject3.kt")
      public void testNestedObject3() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/nestedObject3.kt");
      }

      @Test
      @TestMetadata("nestedObject4.kt")
      public void testNestedObject4() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/nestedObject4.kt");
      }

      @Test
      @TestMetadata("simpleObject1.kt")
      public void testSimpleObject1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/simpleObject1.kt");
      }

      @Test
      @TestMetadata("simpleObject2.kt")
      public void testSimpleObject2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/onObjects/simpleObject2.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/withErrors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithErrors {
      @Test
      public void testAllFilesPresentInWithErrors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("lambdaAndParensIncorrectVararg.kt")
      public void testLambdaAndParensIncorrectVararg() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/withErrors/lambdaAndParensIncorrectVararg.kt");
      }

      @Test
      @TestMetadata("lambdaNoParIncorrectVararg.kt")
      public void testLambdaNoParIncorrectVararg() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/withErrors/lambdaNoParIncorrectVararg.kt");
      }

      @Test
      @TestMetadata("lambdaNoParLabelIncorrectVararg.kt")
      public void testLambdaNoParLabelIncorrectVararg() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/withErrors/lambdaNoParLabelIncorrectVararg.kt");
      }

      @Test
      @TestMetadata("lambdaNoParRCurlyIncorrectVararg.kt")
      public void testLambdaNoParRCurlyIncorrectVararg() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/withErrors/lambdaNoParRCurlyIncorrectVararg.kt");
      }

      @Test
      @TestMetadata("nonemptyLambdaRParIncorrectVararg.kt")
      public void testNonemptyLambdaRParIncorrectVararg() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invoke/withErrors/nonemptyLambdaRParIncorrectVararg.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects")
  @TestDataPath("$PROJECT_ROOT")
  public class InvokeOnObjects {
    @Test
    public void testAllFilesPresentInInvokeOnObjects() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("companionObject1.kt")
    public void testCompanionObject1() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/companionObject1.kt");
    }

    @Test
    @TestMetadata("companionObject2.kt")
    public void testCompanionObject2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/companionObject2.kt");
    }

    @Test
    @TestMetadata("companionObjectWithName1.kt")
    public void testCompanionObjectWithName1() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/companionObjectWithName1.kt");
    }

    @Test
    @TestMetadata("companionObjectWithName2.kt")
    public void testCompanionObjectWithName2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/companionObjectWithName2.kt");
    }

    @Test
    @TestMetadata("nestedObject1.kt")
    public void testNestedObject1() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/nestedObject1.kt");
    }

    @Test
    @TestMetadata("nestedObject2.kt")
    public void testNestedObject2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/nestedObject2.kt");
    }

    @Test
    @TestMetadata("nestedObject3.kt")
    public void testNestedObject3() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/nestedObject3.kt");
    }

    @Test
    @TestMetadata("nestedObject4.kt")
    public void testNestedObject4() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/nestedObject4.kt");
    }

    @Test
    @TestMetadata("simpleObject1.kt")
    public void testSimpleObject1() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/simpleObject1.kt");
    }

    @Test
    @TestMetadata("simpleObject2.kt")
    public void testSimpleObject2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/invokeOnObjects/simpleObject2.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/java")
  @TestDataPath("$PROJECT_ROOT")
  public class Java {
    @Test
    public void testAllFilesPresentInJava() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/java"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("defaultJavaConstructorWithTypeParameter.kt")
    public void testDefaultJavaConstructorWithTypeParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/defaultJavaConstructorWithTypeParameter.kt");
    }

    @Test
    @TestMetadata("JavaAnnotationParameter.kt")
    public void testJavaAnnotationParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaAnnotationParameter.kt");
    }

    @Test
    @TestMetadata("JavaCallWithGenerics.kt")
    public void testJavaCallWithGenerics() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaCallWithGenerics.kt");
    }

    @Test
    @TestMetadata("JavaConstructorNotNullParameter.kt")
    public void testJavaConstructorNotNullParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaConstructorNotNullParameter.kt");
    }

    @Test
    @TestMetadata("JavaEnumEntry.kt")
    public void testJavaEnumEntry() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaEnumEntry.kt");
    }

    @Test
    @TestMetadata("JavaEnumValueOf.kt")
    public void testJavaEnumValueOf() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaEnumValueOf.kt");
    }

    @Test
    @TestMetadata("JavaReference.kt")
    public void testJavaReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaReference.kt");
    }

    @Test
    @TestMetadata("JavaSameSourceLibrary.kt")
    public void testJavaSameSourceLibrary() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaSameSourceLibrary.kt");
    }

    @Test
    @TestMetadata("JavaStaticMethod.kt")
    public void testJavaStaticMethod() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/JavaStaticMethod.kt");
    }

    @Test
    @TestMetadata("ReferenceToSam.kt")
    public void testReferenceToSam() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/ReferenceToSam.kt");
    }

    @Test
    @TestMetadata("SyntheticProperty.kt")
    public void testSyntheticProperty() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/SyntheticProperty.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/java/enumWithCustomGetName")
    @TestDataPath("$PROJECT_ROOT")
    public class EnumWithCustomGetName {
      @Test
      public void testAllFilesPresentInEnumWithCustomGetName() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/java/enumWithCustomGetName"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("FunctionCallOnConstant.kt")
      public void testFunctionCallOnConstant() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/enumWithCustomGetName/FunctionCallOnConstant.kt");
      }

      @Test
      @TestMetadata("FunctionCallOnVariable.kt")
      public void testFunctionCallOnVariable() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/enumWithCustomGetName/FunctionCallOnVariable.kt");
      }

      @Test
      @TestMetadata("PropertyAccessOnConstant.kt")
      public void testPropertyAccessOnConstant() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/enumWithCustomGetName/PropertyAccessOnConstant.kt");
      }

      @Test
      @TestMetadata("PropertyAccessOnVariable.kt")
      public void testPropertyAccessOnVariable() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/java/enumWithCustomGetName/PropertyAccessOnVariable.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc")
  @TestDataPath("$PROJECT_ROOT")
  public class KDoc {
    @Test
    public void testAllFilesPresentInKDoc() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject")
    @TestDataPath("$PROJECT_ROOT")
    public class CompanionObject {
      @Test
      public void testAllFilesPresentInCompanionObject() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("childQualifiedFunctionFromSuperClassCompanion.kt")
      public void testChildQualifiedFunctionFromSuperClassCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/childQualifiedFunctionFromSuperClassCompanion.kt");
      }

      @Test
      @TestMetadata("qualifiedClassNestedInClassNestedInCompanion.kt")
      public void testQualifiedClassNestedInClassNestedInCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedClassNestedInClassNestedInCompanion.kt");
      }

      @Test
      @TestMetadata("qualifiedFunctionFromCompanion.kt")
      public void testQualifiedFunctionFromCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedFunctionFromCompanion.kt");
      }

      @Test
      @TestMetadata("qualifiedFunctionFromCompanionInOtherFile.kt")
      public void testQualifiedFunctionFromCompanionInOtherFile() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedFunctionFromCompanionInOtherFile.kt");
      }

      @Test
      @TestMetadata("qualifiedFunctionFromCompanionWithImport.kt")
      public void testQualifiedFunctionFromCompanionWithImport() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedFunctionFromCompanionWithImport.kt");
      }

      @Test
      @TestMetadata("qualifiedFunctionFromOwnCompanion.kt")
      public void testQualifiedFunctionFromOwnCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedFunctionFromOwnCompanion.kt");
      }

      @Test
      @TestMetadata("qualifiedFunctionFromSuperClassCompanion.kt")
      public void testQualifiedFunctionFromSuperClassCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedFunctionFromSuperClassCompanion.kt");
      }

      @Test
      @TestMetadata("qualifiedFunctionFromSuperClassCompanionInOtherFile.kt")
      public void testQualifiedFunctionFromSuperClassCompanionInOtherFile() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedFunctionFromSuperClassCompanionInOtherFile.kt");
      }

      @Test
      @TestMetadata("qualifiedFunctionOfClassNestedInCompanion.kt")
      public void testQualifiedFunctionOfClassNestedInCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/qualifiedFunctionOfClassNestedInCompanion.kt");
      }

      @Test
      @TestMetadata("unqualifiedFunctionFromOwnCompanion.kt")
      public void testUnqualifiedFunctionFromOwnCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/unqualifiedFunctionFromOwnCompanion.kt");
      }

      @Test
      @TestMetadata("unqualifiedFunctionFromSuperClassCompanion.kt")
      public void testUnqualifiedFunctionFromSuperClassCompanion() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/companionObject/unqualifiedFunctionFromSuperClassCompanion.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions")
    @TestDataPath("$PROJECT_ROOT")
    public class Extensions {
      @Test
      public void testAllFilesPresentInExtensions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("callablesWithSameName.kt")
      public void testCallablesWithSameName() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/callablesWithSameName.kt");
      }

      @Test
      @TestMetadata("fromBaseClass.kt")
      public void testFromBaseClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/fromBaseClass.kt");
      }

      @Test
      @TestMetadata("functionOverloads.kt")
      public void testFunctionOverloads() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/functionOverloads.kt");
      }

      @Test
      @TestMetadata("KT-69047.kt")
      public void testKT_69047() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/KT-69047.kt");
      }

      @Test
      @TestMetadata("nonExtensions.kt")
      public void testNonExtensions() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/nonExtensions.kt");
      }

      @Test
      @TestMetadata("qualifiers.kt")
      public void testQualifiers() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/qualifiers.kt");
      }

      @Test
      @TestMetadata("receiverTypesWithSameName_nestedScopes.kt")
      public void testReceiverTypesWithSameName_nestedScopes() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/receiverTypesWithSameName_nestedScopes.kt");
      }

      @Test
      @TestMetadata("receiverTypesWithSameName_starImports.kt")
      public void testReceiverTypesWithSameName_starImports() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/receiverTypesWithSameName_starImports.kt");
      }

      @Test
      @TestMetadata("topLevelFunction.kt")
      public void testTopLevelFunction() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/topLevelFunction.kt");
      }

      @Test
      @TestMetadata("topLevelProperty.kt")
      public void testTopLevelProperty() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/topLevelProperty.kt");
      }

      @Test
      @TestMetadata("topLevelTypeVsMemberFunctionAsReceiver.kt")
      public void testTopLevelTypeVsMemberFunctionAsReceiver() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/topLevelTypeVsMemberFunctionAsReceiver.kt");
      }

      @Test
      @TestMetadata("typeAliasReceiver.kt")
      public void testTypeAliasReceiver() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/typeAliasReceiver.kt");
      }

      @Test
      @TestMetadata("typeCompatibility.kt")
      public void testTypeCompatibility() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/typeCompatibility.kt");
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/generics")
      @TestDataPath("$PROJECT_ROOT")
      public class Generics {
        @Test
        public void testAllFilesPresentInGenerics() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/generics"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("genericParameterReceiver.kt")
        public void testGenericParameterReceiver() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/generics/genericParameterReceiver.kt");
        }

        @Test
        @TestMetadata("genericsCompatibility.kt")
        public void testGenericsCompatibility() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/generics/genericsCompatibility.kt");
        }

        @Test
        @TestMetadata("typeWithGenericsReceiver.kt")
        public void testTypeWithGenericsReceiver() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/extensions/generics/typeWithGenericsReceiver.kt");
        }
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/imports")
    @TestDataPath("$PROJECT_ROOT")
    public class Imports {
      @Test
      public void testAllFilesPresentInImports() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/imports"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("KT-64190.kt")
      public void testKT_64190() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/imports/KT-64190.kt");
      }

      @Test
      @TestMetadata("SameNameClassesFromStarImports.kt")
      public void testSameNameClassesFromStarImports() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/imports/SameNameClassesFromStarImports.kt");
      }

      @Test
      @TestMetadata("TypeAliasedImport.kt")
      public void testTypeAliasedImport() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/imports/TypeAliasedImport.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations")
    @TestDataPath("$PROJECT_ROOT")
    public class JavaDeclarations {
      @Test
      public void testAllFilesPresentInJavaDeclarations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("FunctionQualifiedWithJavaSubclass.kt")
      public void testFunctionQualifiedWithJavaSubclass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/FunctionQualifiedWithJavaSubclass.kt");
      }

      @Test
      @TestMetadata("FunctionQualifiedWithKotlinSubclass.kt")
      public void testFunctionQualifiedWithKotlinSubclass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/FunctionQualifiedWithKotlinSubclass.kt");
      }

      @Test
      @TestMetadata("KT-69128.kt")
      public void testKT_69128() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/KT-69128.kt");
      }

      @Test
      @TestMetadata("KT-69736.kt")
      public void testKT_69736() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/KT-69736.kt");
      }

      @Test
      @TestMetadata("NoSyntheticFieldInClass.kt")
      public void testNoSyntheticFieldInClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/NoSyntheticFieldInClass.kt");
      }

      @Test
      @TestMetadata("StaticFieldQualified.kt")
      public void testStaticFieldQualified() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/StaticFieldQualified.kt");
      }

      @Test
      @TestMetadata("StaticFunctionFromBaseClass.kt")
      public void testStaticFunctionFromBaseClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/StaticFunctionFromBaseClass.kt");
      }

      @Test
      @TestMetadata("StaticFunctionFullyQualified.kt")
      public void testStaticFunctionFullyQualified() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/StaticFunctionFullyQualified.kt");
      }

      @Test
      @TestMetadata("StaticFunctionQualified.kt")
      public void testStaticFunctionQualified() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/StaticFunctionQualified.kt");
      }

      @Test
      @TestMetadata("StaticFunctionQualifiedWithJavaSubclass.kt")
      public void testStaticFunctionQualifiedWithJavaSubclass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/StaticFunctionQualifiedWithJavaSubclass.kt");
      }

      @Test
      @TestMetadata("StaticFunctionQualifiedWithKotlinSubclass.kt")
      public void testStaticFunctionQualifiedWithKotlinSubclass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/StaticFunctionQualifiedWithKotlinSubclass.kt");
      }

      @Test
      @TestMetadata("SyntheticFieldInAnnotationInterface.kt")
      public void testSyntheticFieldInAnnotationInterface() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/SyntheticFieldInAnnotationInterface.kt");
      }

      @Test
      @TestMetadata("SyntheticFieldInClass.kt")
      public void testSyntheticFieldInClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/SyntheticFieldInClass.kt");
      }

      @Test
      @TestMetadata("SyntheticPropertyInKotlinSubclass.kt")
      public void testSyntheticPropertyInKotlinSubclass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/javaDeclarations/SyntheticPropertyInKotlinSubclass.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalContext {
      @Test
      public void testAllFilesPresentInLocalContext() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("LocalSemiFullQualifiedCallableName.kt")
      public void testLocalSemiFullQualifiedCallableName() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/LocalSemiFullQualifiedCallableName.kt");
      }

      @Test
      @TestMetadata("LocalSemiFullQualifiedClassName.kt")
      public void testLocalSemiFullQualifiedClassName() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/LocalSemiFullQualifiedClassName.kt");
      }

      @Test
      @TestMetadata("NonLocalSemiFullQualifiedCallableName.kt")
      public void testNonLocalSemiFullQualifiedCallableName() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/NonLocalSemiFullQualifiedCallableName.kt");
      }

      @Test
      @TestMetadata("NonLocalSemiFullQualifiedClassName.kt")
      public void testNonLocalSemiFullQualifiedClassName() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/NonLocalSemiFullQualifiedClassName.kt");
      }

      @Test
      @TestMetadata("SelfLocalMethod.kt")
      public void testSelfLocalMethod() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SelfLocalMethod.kt");
      }

      @Test
      @TestMetadata("SelfLocalProperty.kt")
      public void testSelfLocalProperty() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SelfLocalProperty.kt");
      }

      @Test
      @TestMetadata("SelfNonLocalEnumEntry.kt")
      public void testSelfNonLocalEnumEntry() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SelfNonLocalEnumEntry.kt");
      }

      @Test
      @TestMetadata("SelfNonLocalMethod.kt")
      public void testSelfNonLocalMethod() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SelfNonLocalMethod.kt");
      }

      @Test
      @TestMetadata("SelfNonLocalNestedClass.kt")
      public void testSelfNonLocalNestedClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SelfNonLocalNestedClass.kt");
      }

      @Test
      @TestMetadata("SelfNonLocalProperty.kt")
      public void testSelfNonLocalProperty() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SelfNonLocalProperty.kt");
      }

      @Test
      @TestMetadata("SiblingLocalMethod.kt")
      public void testSiblingLocalMethod() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SiblingLocalMethod.kt");
      }

      @Test
      @TestMetadata("SiblingLocalProperty.kt")
      public void testSiblingLocalProperty() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SiblingLocalProperty.kt");
      }

      @Test
      @TestMetadata("SiblingNonLocalProperty.kt")
      public void testSiblingNonLocalProperty() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/localContext/SiblingNonLocalProperty.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/packages")
    @TestDataPath("$PROJECT_ROOT")
    public class Packages {
      @Test
      public void testAllFilesPresentInPackages() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/packages"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("longPackage.kt")
      public void testLongPackage() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/packages/longPackage.kt");
      }

      @Test
      @TestMetadata("packageVsTopLevelDeclarations.kt")
      public void testPackageVsTopLevelDeclarations() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/packages/packageVsTopLevelDeclarations.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters")
    @TestDataPath("$PROJECT_ROOT")
    public class Parameters {
      @Test
      public void testAllFilesPresentInParameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("ClassPrimaryConstructorParameter.kt")
      public void testClassPrimaryConstructorParameter() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters/ClassPrimaryConstructorParameter.kt");
      }

      @Test
      @TestMetadata("ClassPrimaryConstructorValParameter.kt")
      public void testClassPrimaryConstructorValParameter() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters/ClassPrimaryConstructorValParameter.kt");
      }

      @Test
      @TestMetadata("ClassTypeParameter.kt")
      public void testClassTypeParameter() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters/ClassTypeParameter.kt");
      }

      @Test
      @TestMetadata("ConstructorValueParameter.kt")
      public void testConstructorValueParameter() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters/ConstructorValueParameter.kt");
      }

      @Test
      @TestMetadata("FunctionTypeParameter.kt")
      public void testFunctionTypeParameter() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters/FunctionTypeParameter.kt");
      }

      @Test
      @TestMetadata("FunctionValueParameter.kt")
      public void testFunctionValueParameter() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/parameters/FunctionValueParameter.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified")
    @TestDataPath("$PROJECT_ROOT")
    public class Qualified {
      @Test
      public void testAllFilesPresentInQualified() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables")
      @TestDataPath("$PROJECT_ROOT")
      public class Callables {
        @Test
        public void testAllFilesPresentInCallables() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("callableFromTypealias.kt")
        public void testCallableFromTypealias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/callableFromTypealias.kt");
        }

        @Test
        @TestMetadata("functionFromClass.kt")
        public void testFunctionFromClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromClass.kt");
        }

        @Test
        @TestMetadata("functionFromInnerClass.kt")
        public void testFunctionFromInnerClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromInnerClass.kt");
        }

        @Test
        @TestMetadata("functionFromInterface.kt")
        public void testFunctionFromInterface() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromInterface.kt");
        }

        @Test
        @TestMetadata("functionFromNestedClass.kt")
        public void testFunctionFromNestedClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromNestedClass.kt");
        }

        @Test
        @TestMetadata("functionFromPrivateNestedClass.kt")
        public void testFunctionFromPrivateNestedClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromPrivateNestedClass.kt");
        }

        @Test
        @TestMetadata("functionFromSuperClass.kt")
        public void testFunctionFromSuperClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromSuperClass.kt");
        }

        @Test
        @TestMetadata("functionFromSuperInterface.kt")
        public void testFunctionFromSuperInterface() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromSuperInterface.kt");
        }

        @Test
        @TestMetadata("functionFromSuperSuperInterface.kt")
        public void testFunctionFromSuperSuperInterface() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/functionFromSuperSuperInterface.kt");
        }

        @Test
        @TestMetadata("overloadedFunctionFromClass.kt")
        public void testOverloadedFunctionFromClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/overloadedFunctionFromClass.kt");
        }

        @Test
        @TestMetadata("overloadedFunctionFromClassWithPrivateOverload.kt")
        public void testOverloadedFunctionFromClassWithPrivateOverload() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/overloadedFunctionFromClassWithPrivateOverload.kt");
        }

        @Test
        @TestMetadata("privateFunctionFromClass.kt")
        public void testPrivateFunctionFromClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/privateFunctionFromClass.kt");
        }

        @Test
        @TestMetadata("privatePropertyFromClass.kt")
        public void testPrivatePropertyFromClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/privatePropertyFromClass.kt");
        }

        @Test
        @TestMetadata("propertyFromClass.kt")
        public void testPropertyFromClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromClass.kt");
        }

        @Test
        @TestMetadata("propertyFromInnerClass.kt")
        public void testPropertyFromInnerClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromInnerClass.kt");
        }

        @Test
        @TestMetadata("propertyFromInterface.kt")
        public void testPropertyFromInterface() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromInterface.kt");
        }

        @Test
        @TestMetadata("propertyFromNestedClass.kt")
        public void testPropertyFromNestedClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromNestedClass.kt");
        }

        @Test
        @TestMetadata("propertyFromPrivateNestedClass.kt")
        public void testPropertyFromPrivateNestedClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromPrivateNestedClass.kt");
        }

        @Test
        @TestMetadata("propertyFromSuperClass.kt")
        public void testPropertyFromSuperClass() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromSuperClass.kt");
        }

        @Test
        @TestMetadata("propertyFromSuperInterface.kt")
        public void testPropertyFromSuperInterface() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromSuperInterface.kt");
        }

        @Test
        @TestMetadata("propertyFromSuperSuperInterface.kt")
        public void testPropertyFromSuperSuperInterface() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/propertyFromSuperSuperInterface.kt");
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported")
        @TestDataPath("$PROJECT_ROOT")
        public class NotImported {
          @Test
          public void testAllFilesPresentInNotImported() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
          }

          @Test
          @TestMetadata("functionFromClass.kt")
          public void testFunctionFromClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromClass.kt");
          }

          @Test
          @TestMetadata("functionFromInnerClass.kt")
          public void testFunctionFromInnerClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromInnerClass.kt");
          }

          @Test
          @TestMetadata("functionFromInterface.kt")
          public void testFunctionFromInterface() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromInterface.kt");
          }

          @Test
          @TestMetadata("functionFromNestedClass.kt")
          public void testFunctionFromNestedClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromNestedClass.kt");
          }

          @Test
          @TestMetadata("functionFromPrivateNestedClass.kt")
          public void testFunctionFromPrivateNestedClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromPrivateNestedClass.kt");
          }

          @Test
          @TestMetadata("functionFromSuperClass.kt")
          public void testFunctionFromSuperClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromSuperClass.kt");
          }

          @Test
          @TestMetadata("functionFromSuperInterface.kt")
          public void testFunctionFromSuperInterface() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromSuperInterface.kt");
          }

          @Test
          @TestMetadata("functionFromSuperSuperInterface.kt")
          public void testFunctionFromSuperSuperInterface() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/functionFromSuperSuperInterface.kt");
          }

          @Test
          @TestMetadata("overloadedFunctionFromClass.kt")
          public void testOverloadedFunctionFromClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/overloadedFunctionFromClass.kt");
          }

          @Test
          @TestMetadata("overloadedFunctionFromClassWithPrivateOverload.kt")
          public void testOverloadedFunctionFromClassWithPrivateOverload() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/overloadedFunctionFromClassWithPrivateOverload.kt");
          }

          @Test
          @TestMetadata("privateFunctionFromClass.kt")
          public void testPrivateFunctionFromClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/privateFunctionFromClass.kt");
          }

          @Test
          @TestMetadata("privatePropertyFromClass.kt")
          public void testPrivatePropertyFromClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/privatePropertyFromClass.kt");
          }

          @Test
          @TestMetadata("propertyFromClass.kt")
          public void testPropertyFromClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromClass.kt");
          }

          @Test
          @TestMetadata("propertyFromInnerClass.kt")
          public void testPropertyFromInnerClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromInnerClass.kt");
          }

          @Test
          @TestMetadata("propertyFromInterface.kt")
          public void testPropertyFromInterface() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromInterface.kt");
          }

          @Test
          @TestMetadata("propertyFromNestedClass.kt")
          public void testPropertyFromNestedClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromNestedClass.kt");
          }

          @Test
          @TestMetadata("propertyFromPrivateNestedClass.kt")
          public void testPropertyFromPrivateNestedClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromPrivateNestedClass.kt");
          }

          @Test
          @TestMetadata("propertyFromSuperClass.kt")
          public void testPropertyFromSuperClass() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromSuperClass.kt");
          }

          @Test
          @TestMetadata("propertyFromSuperInterface.kt")
          public void testPropertyFromSuperInterface() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromSuperInterface.kt");
          }

          @Test
          @TestMetadata("propertyFromSuperSuperInterface.kt")
          public void testPropertyFromSuperSuperInterface() {
            runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/callables/notImported/propertyFromSuperSuperInterface.kt");
          }
        }
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/conflictResolution")
      @TestDataPath("$PROJECT_ROOT")
      public class ConflictResolution {
        @Test
        public void testAllFilesPresentInConflictResolution() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/conflictResolution"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("resolveToPackage.kt")
        public void testResolveToPackage() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/conflictResolution/resolveToPackage.kt");
        }
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile")
      @TestDataPath("$PROJECT_ROOT")
      public class FromOtherFile {
        @Test
        public void testAllFilesPresentInFromOtherFile() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("EnumEntryFromOtherByShortName.kt")
        public void testEnumEntryFromOtherByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/EnumEntryFromOtherByShortName.kt");
        }

        @Test
        @TestMetadata("EnumEntryFromOtherFileByFullName.kt")
        public void testEnumEntryFromOtherFileByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/EnumEntryFromOtherFileByFullName.kt");
        }

        @Test
        @TestMetadata("NestedClassFromOtherFileByFullName.kt")
        public void testNestedClassFromOtherFileByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/NestedClassFromOtherFileByFullName.kt");
        }

        @Test
        @TestMetadata("NestedClassFromOtherFileByShortName.kt")
        public void testNestedClassFromOtherFileByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/NestedClassFromOtherFileByShortName.kt");
        }

        @Test
        @TestMetadata("TopLevelClassFromOtherFileByFullName.kt")
        public void testTopLevelClassFromOtherFileByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/TopLevelClassFromOtherFileByFullName.kt");
        }

        @Test
        @TestMetadata("TopLevelClassFromOtherFileByShortName.kt")
        public void testTopLevelClassFromOtherFileByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/TopLevelClassFromOtherFileByShortName.kt");
        }

        @Test
        @TestMetadata("TopLevelFunctionFromOtherFileByFullName.kt")
        public void testTopLevelFunctionFromOtherFileByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/TopLevelFunctionFromOtherFileByFullName.kt");
        }

        @Test
        @TestMetadata("TopLevelFunctionFromStdlibByShortName.kt")
        public void testTopLevelFunctionFromStdlibByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/TopLevelFunctionFromStdlibByShortName.kt");
        }

        @Test
        @TestMetadata("TypealiasFromOtherFileByFullName.kt")
        public void testTypealiasFromOtherFileByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/TypealiasFromOtherFileByFullName.kt");
        }

        @Test
        @TestMetadata("TypealiasFromOtherFileByShortName.kt")
        public void testTypealiasFromOtherFileByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/fromOtherFile/TypealiasFromOtherFileByShortName.kt");
        }
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib")
      @TestDataPath("$PROJECT_ROOT")
      public class Stdlib {
        @Test
        public void testAllFilesPresentInStdlib() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("EnumEntryFromStdlibByFullName.kt")
        public void testEnumEntryFromStdlibByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/EnumEntryFromStdlibByFullName.kt");
        }

        @Test
        @TestMetadata("EnumEntryFromStdlibByShortName.kt")
        public void testEnumEntryFromStdlibByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/EnumEntryFromStdlibByShortName.kt");
        }

        @Test
        @TestMetadata("TopLevelClassFromStdlibByFullName.kt")
        public void testTopLevelClassFromStdlibByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/TopLevelClassFromStdlibByFullName.kt");
        }

        @Test
        @TestMetadata("TopLevelClassFromStdlibByShortName.kt")
        public void testTopLevelClassFromStdlibByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/TopLevelClassFromStdlibByShortName.kt");
        }

        @Test
        @TestMetadata("TopLevelFunctionFromStdlibByFullName.kt")
        public void testTopLevelFunctionFromStdlibByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/TopLevelFunctionFromStdlibByFullName.kt");
        }

        @Test
        @TestMetadata("TopLevelFunctionFromStdlibByShortName.kt")
        public void testTopLevelFunctionFromStdlibByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/TopLevelFunctionFromStdlibByShortName.kt");
        }

        @Test
        @TestMetadata("TypealiasFromStdlibByFullName.kt")
        public void testTypealiasFromStdlibByFullName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/TypealiasFromStdlibByFullName.kt");
        }

        @Test
        @TestMetadata("TypealiasFromStdlibByShortName.kt")
        public void testTypealiasFromStdlibByShortName() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/qualified/stdlib/TypealiasFromStdlibByShortName.kt");
        }
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/thisQualifier")
    @TestDataPath("$PROJECT_ROOT")
    public class ThisQualifier {
      @Test
      public void testAllFilesPresentInThisQualifier() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/thisQualifier"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("thisQualifierOnClass.kt")
      public void testThisQualifierOnClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/thisQualifier/thisQualifierOnClass.kt");
      }

      @Test
      @TestMetadata("thisQualifierOnFunction.kt")
      public void testThisQualifierOnFunction() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/thisQualifier/thisQualifierOnFunction.kt");
      }

      @Test
      @TestMetadata("thisQualifierOnFunctionNoExtensionReceiver.kt")
      public void testThisQualifierOnFunctionNoExtensionReceiver() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/thisQualifier/thisQualifierOnFunctionNoExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("thisQualifierOnProperty.kt")
      public void testThisQualifierOnProperty() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/thisQualifier/thisQualifierOnProperty.kt");
      }

      @Test
      @TestMetadata("thisQualifierOnPropertyNoExtensionReceiver.kt")
      public void testThisQualifierOnPropertyNoExtensionReceiver() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/thisQualifier/thisQualifierOnPropertyNoExtensionReceiver.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/withErrors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithErrors {
      @Test
      public void testAllFilesPresentInWithErrors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("errorInLatestQualifer.kt")
      public void testErrorInLatestQualifer() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/withErrors/errorInLatestQualifer.kt");
      }

      @Test
      @TestMetadata("invalidPropertyAccessOnFunction.kt")
      public void testInvalidPropertyAccessOnFunction() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/withErrors/invalidPropertyAccessOnFunction.kt");
      }

      @Test
      @TestMetadata("invalidPropertyAccessOnFunctionFromCompanionObject.kt")
      public void testInvalidPropertyAccessOnFunctionFromCompanionObject() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/withErrors/invalidPropertyAccessOnFunctionFromCompanionObject.kt");
      }

      @Test
      @TestMetadata("invalidPropertyAccessOnFunctionFromNonImportedCompanionObject.kt")
      public void testInvalidPropertyAccessOnFunctionFromNonImportedCompanionObject() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/withErrors/invalidPropertyAccessOnFunctionFromNonImportedCompanionObject.kt");
      }

      @Test
      @TestMetadata("invalidPropertyAccessOnFunctionFromSuperClass.kt")
      public void testInvalidPropertyAccessOnFunctionFromSuperClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kDoc/withErrors/invalidPropertyAccessOnFunctionFromSuperClass.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPackage")
  @TestDataPath("$PROJECT_ROOT")
  public class KotlinPackage {
    @Test
    public void testAllFilesPresentInKotlinPackage() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPackage"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("kotlinPackageAllowed.kt")
    public void testKotlinPackageAllowed() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPackage/kotlinPackageAllowed.kt");
    }

    @Test
    @TestMetadata("kotlinPackageNotAllowed.kt")
    public void testKotlinPackageNotAllowed() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPackage/kotlinPackageNotAllowed.kt");
    }

    @Test
    @TestMetadata("kotlinxPackage.kt")
    public void testKotlinxPackage() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/kotlinPackage/kotlinxPackage.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes")
  @TestDataPath("$PROJECT_ROOT")
  public class NestedTypes {
    @Test
    public void testAllFilesPresentInNestedTypes() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("ResolveCompanionInCompanionType.kt")
    public void testResolveCompanionInCompanionType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveCompanionInCompanionType.kt");
    }

    @Test
    @TestMetadata("ResolveEndOfPackageInType.kt")
    public void testResolveEndOfPackageInType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveEndOfPackageInType.kt");
    }

    @Test
    @TestMetadata("ResolveMiddleOfPackageInType.kt")
    public void testResolveMiddleOfPackageInType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveMiddleOfPackageInType.kt");
    }

    @Test
    @TestMetadata("ResolveNamedCompanionInCompanionType.kt")
    public void testResolveNamedCompanionInCompanionType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveNamedCompanionInCompanionType.kt");
    }

    @Test
    @TestMetadata("ResolveStartOfPackageInType.kt")
    public void testResolveStartOfPackageInType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveStartOfPackageInType.kt");
    }

    @Test
    @TestMetadata("ResolveTypeInTheEndOfType.kt")
    public void testResolveTypeInTheEndOfType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveTypeInTheEndOfType.kt");
    }

    @Test
    @TestMetadata("ResolveTypeInTheMiddleOfCompanionType.kt")
    public void testResolveTypeInTheMiddleOfCompanionType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveTypeInTheMiddleOfCompanionType.kt");
    }

    @Test
    @TestMetadata("ResolveTypeInTheMiddleOfFunctionalType.kt")
    public void testResolveTypeInTheMiddleOfFunctionalType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveTypeInTheMiddleOfFunctionalType.kt");
    }

    @Test
    @TestMetadata("ResolveTypeInTheMiddleOfNullableType.kt")
    public void testResolveTypeInTheMiddleOfNullableType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveTypeInTheMiddleOfNullableType.kt");
    }

    @Test
    @TestMetadata("ResolveTypeInTheMiddleOfType.kt")
    public void testResolveTypeInTheMiddleOfType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveTypeInTheMiddleOfType.kt");
    }

    @Test
    @TestMetadata("ResolveTypeInTheStartOfCompanionType.kt")
    public void testResolveTypeInTheStartOfCompanionType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveTypeInTheStartOfCompanionType.kt");
    }

    @Test
    @TestMetadata("ResolveTypeInTheStartOfType.kt")
    public void testResolveTypeInTheStartOfType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nestedTypes/ResolveTypeInTheStartOfType.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/nonCalls")
  @TestDataPath("$PROJECT_ROOT")
  public class NonCalls {
    @Test
    public void testAllFilesPresentInNonCalls() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/nonCalls"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("ifExpression.kt")
    public void testIfExpression() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nonCalls/ifExpression.kt");
    }

    @Test
    @TestMetadata("literalExpression.kt")
    public void testLiteralExpression() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nonCalls/literalExpression.kt");
    }

    @Test
    @TestMetadata("whenExpression.kt")
    public void testWhenExpression() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/nonCalls/whenExpression.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/operators")
  @TestDataPath("$PROJECT_ROOT")
  public class Operators {
    @Test
    public void testAllFilesPresentInOperators() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/operators"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment")
    @TestDataPath("$PROJECT_ROOT")
    public class Assignment {
      @Test
      public void testAllFilesPresentInAssignment() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("insidePlusAssignTarget.kt")
      public void testInsidePlusAssignTarget() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment/insidePlusAssignTarget.kt");
      }

      @Test
      @TestMetadata("listAssignPlus.kt")
      public void testListAssignPlus() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment/listAssignPlus.kt");
      }

      @Test
      @TestMetadata("listAssignPlusExplicit.kt")
      public void testListAssignPlusExplicit() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment/listAssignPlusExplicit.kt");
      }

      @Test
      @TestMetadata("listAssignValue.kt")
      public void testListAssignValue() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment/listAssignValue.kt");
      }

      @Test
      @TestMetadata("listSet.kt")
      public void testListSet() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment/listSet.kt");
      }

      @Test
      @TestMetadata("listSetExplicit.kt")
      public void testListSetExplicit() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/assignment/listSetExplicit.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo")
    @TestDataPath("$PROJECT_ROOT")
    public class CompareTo {
      @Test
      public void testAllFilesPresentInCompareTo() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("compareTo.kt")
      public void testCompareTo() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/compareTo.kt");
      }

      @Test
      @TestMetadata("compareToAndGeneric.kt")
      public void testCompareToAndGeneric() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/compareToAndGeneric.kt");
      }

      @Test
      @TestMetadata("gt.kt")
      public void testGt() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/gt.kt");
      }

      @Test
      @TestMetadata("gtAndGeneric.kt")
      public void testGtAndGeneric() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/gtAndGeneric.kt");
      }

      @Test
      @TestMetadata("gtAndGenericAmbiguity.kt")
      public void testGtAndGenericAmbiguity() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/gtAndGenericAmbiguity.kt");
      }

      @Test
      @TestMetadata("gtEq.kt")
      public void testGtEq() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/gtEq.kt");
      }

      @Test
      @TestMetadata("lt.kt")
      public void testLt() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/lt.kt");
      }

      @Test
      @TestMetadata("ltEq.kt")
      public void testLtEq() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/ltEq.kt");
      }

      @Test
      @TestMetadata("numberCompareTo.kt")
      public void testNumberCompareTo() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/numberCompareTo.kt");
      }

      @Test
      @TestMetadata("numberGt.kt")
      public void testNumberGt() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/numberGt.kt");
      }

      @Test
      @TestMetadata("numberGtEq.kt")
      public void testNumberGtEq() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/numberGtEq.kt");
      }

      @Test
      @TestMetadata("numberLt.kt")
      public void testNumberLt() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/numberLt.kt");
      }

      @Test
      @TestMetadata("numberLtEq.kt")
      public void testNumberLtEq() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/compareTo/numberLtEq.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/contains")
    @TestDataPath("$PROJECT_ROOT")
    public class Contains {
      @Test
      public void testAllFilesPresentInContains() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/contains"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("whenConditionInRange.kt")
      public void testWhenConditionInRange() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/contains/whenConditionInRange.kt");
      }

      @Test
      @TestMetadata("whenConditionInRangeInverted.kt")
      public void testWhenConditionInRangeInverted() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/contains/whenConditionInRangeInverted.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals")
    @TestDataPath("$PROJECT_ROOT")
    public class Equals {
      @Test
      public void testAllFilesPresentInEquals() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("equals.kt")
      public void testEquals() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/equals.kt");
      }

      @Test
      @TestMetadata("equalsExplicit.kt")
      public void testEqualsExplicit() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/equalsExplicit.kt");
      }

      @Test
      @TestMetadata("equalsExplicitWithExplicitImplementation.kt")
      public void testEqualsExplicitWithExplicitImplementation() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/equalsExplicitWithExplicitImplementation.kt");
      }

      @Test
      @TestMetadata("equalsNot.kt")
      public void testEqualsNot() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/equalsNot.kt");
      }

      @Test
      @TestMetadata("equalsNotWithExplicitImplementation.kt")
      public void testEqualsNotWithExplicitImplementation() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/equalsNotWithExplicitImplementation.kt");
      }

      @Test
      @TestMetadata("equalsWithExplicitImplementation.kt")
      public void testEqualsWithExplicitImplementation() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/equalsWithExplicitImplementation.kt");
      }

      @Test
      @TestMetadata("identityEquals.kt")
      public void testIdentityEquals() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/identityEquals.kt");
      }

      @Test
      @TestMetadata("identityEqualsWithExplicitImplementation.kt")
      public void testIdentityEqualsWithExplicitImplementation() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/identityEqualsWithExplicitImplementation.kt");
      }

      @Test
      @TestMetadata("identityNotEquals.kt")
      public void testIdentityNotEquals() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/identityNotEquals.kt");
      }

      @Test
      @TestMetadata("identityNotEqualsWithExplicitImplementation.kt")
      public void testIdentityNotEqualsWithExplicitImplementation() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/identityNotEqualsWithExplicitImplementation.kt");
      }

      @Test
      @TestMetadata("withSmartCast.kt")
      public void testWithSmartCast() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/operators/equals/withSmartCast.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/packageReference")
  @TestDataPath("$PROJECT_ROOT")
  public class PackageReference {
    @Test
    public void testAllFilesPresentInPackageReference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/packageReference"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("javaPackageFirstQualifier.kt")
    public void testJavaPackageFirstQualifier() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/packageReference/javaPackageFirstQualifier.kt");
    }

    @Test
    @TestMetadata("javaPackageSecondQualifier.kt")
    public void testJavaPackageSecondQualifier() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/packageReference/javaPackageSecondQualifier.kt");
    }

    @Test
    @TestMetadata("kotlinPackageFirstQualifier.kt")
    public void testKotlinPackageFirstQualifier() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/packageReference/kotlinPackageFirstQualifier.kt");
    }

    @Test
    @TestMetadata("kotlinPackageSecondQualifier.kt")
    public void testKotlinPackageSecondQualifier() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/packageReference/kotlinPackageSecondQualifier.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess")
  @TestDataPath("$PROJECT_ROOT")
  public class QualifiedAccess {
    @Test
    public void testAllFilesPresentInQualifiedAccess() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("callableReference1.kt")
    public void testCallableReference1() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/callableReference1.kt");
    }

    @Test
    @TestMetadata("callableReference2.kt")
    public void testCallableReference2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/callableReference2.kt");
    }

    @Test
    @TestMetadata("callableReference3.kt")
    public void testCallableReference3() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/callableReference3.kt");
    }

    @Test
    @TestMetadata("nullSafeCallExpression.kt")
    public void testNullSafeCallExpression() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/nullSafeCallExpression.kt");
    }

    @Test
    @TestMetadata("ResolveFirstPackageOfFullyQualifiedReference.kt")
    public void testResolveFirstPackageOfFullyQualifiedReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/ResolveFirstPackageOfFullyQualifiedReference.kt");
    }

    @Test
    @TestMetadata("ResolveFullyQualifiedCompanionObject.kt")
    public void testResolveFullyQualifiedCompanionObject() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/ResolveFullyQualifiedCompanionObject.kt");
    }

    @Test
    @TestMetadata("ResolveOuterClassOfFullyQualifiedReference.kt")
    public void testResolveOuterClassOfFullyQualifiedReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/ResolveOuterClassOfFullyQualifiedReference.kt");
    }

    @Test
    @TestMetadata("ResolvePackageOfFullyQualifiedReference.kt")
    public void testResolvePackageOfFullyQualifiedReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/qualifiedAccess/ResolvePackageOfFullyQualifiedReference.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeAlias {
    @Test
    public void testAllFilesPresentInTypeAlias() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("TypeAlias.kt")
    public void testTypeAlias() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAlias.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsCallableReference.kt")
    public void testTypeAliasAsCallableReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasAsCallableReference.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsCallableReference_withTypeParameters.kt")
    public void testTypeAliasAsCallableReference_withTypeParameters() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasAsCallableReference_withTypeParameters.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsConstructor.kt")
    public void testTypeAliasAsConstructor() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasAsConstructor.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsConstructorParameter.kt")
    public void testTypeAliasAsConstructorParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasAsConstructorParameter.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsConstructor_fixedTypeParameters.kt")
    public void testTypeAliasAsConstructor_fixedTypeParameters() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasAsConstructor_fixedTypeParameters.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsConstructor_withTypeParameters.kt")
    public void testTypeAliasAsConstructor_withTypeParameters() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasAsConstructor_withTypeParameters.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsSupertypeConstructor.kt")
    public void testTypeAliasAsSupertypeConstructor() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasAsSupertypeConstructor.kt");
    }

    @Test
    @TestMetadata("TypeAliasRHS.kt")
    public void testTypeAliasRHS() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/TypeAliasRHS.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency")
    @TestDataPath("$PROJECT_ROOT")
    public class MissingDependency {
      @Test
      public void testAllFilesPresentInMissingDependency() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries")
      @TestDataPath("$PROJECT_ROOT")
      public class Libraries {
        @Test
        public void testAllFilesPresentInLibraries() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("FunctionListAliasUnresolvedFunctionAlias.kt")
        public void testFunctionListAliasUnresolvedFunctionAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/FunctionListAliasUnresolvedFunctionAlias.kt");
        }

        @Test
        @TestMetadata("FunctionListAliasUnresolvedListAlias.kt")
        public void testFunctionListAliasUnresolvedListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/FunctionListAliasUnresolvedListAlias.kt");
        }

        @Test
        @TestMetadata("ListAliasUnresolvedListAlias.kt")
        public void testListAliasUnresolvedListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/ListAliasUnresolvedListAlias.kt");
        }

        @Test
        @TestMetadata("ListAliasUnresolvedStringAlias.kt")
        public void testListAliasUnresolvedStringAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/ListAliasUnresolvedStringAlias.kt");
        }

        @Test
        @TestMetadata("MyString.kt")
        public void testMyString() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/MyString.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasOnlyResolveAsymmetricAlias.kt")
        public void testNestedAsymmetricAliasOnlyResolveAsymmetricAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedAsymmetricAliasOnlyResolveAsymmetricAlias.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasOnlyResolveAsymmetricAlias2.kt")
        public void testNestedAsymmetricAliasOnlyResolveAsymmetricAlias2() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedAsymmetricAliasOnlyResolveAsymmetricAlias2.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasOnlyResolveBaseAliases.kt")
        public void testNestedAsymmetricAliasOnlyResolveBaseAliases() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedAsymmetricAliasOnlyResolveBaseAliases.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasUnresolvedAsymmetricAlias.kt")
        public void testNestedAsymmetricAliasUnresolvedAsymmetricAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedAsymmetricAliasUnresolvedAsymmetricAlias.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasUnresolvedAsymmetricAlias2.kt")
        public void testNestedAsymmetricAliasUnresolvedAsymmetricAlias2() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedAsymmetricAliasUnresolvedAsymmetricAlias2.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasUnresolvedBaseAliases.kt")
        public void testNestedAsymmetricAliasUnresolvedBaseAliases() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedAsymmetricAliasUnresolvedBaseAliases.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesOnlyResolveListAlias.kt")
        public void testNestedCollectionAliasesOnlyResolveListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedCollectionAliasesOnlyResolveListAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesOnlyResolveSetAlias.kt")
        public void testNestedCollectionAliasesOnlyResolveSetAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedCollectionAliasesOnlyResolveSetAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesOnlyResolveStringAlias.kt")
        public void testNestedCollectionAliasesOnlyResolveStringAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedCollectionAliasesOnlyResolveStringAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesUnresolvedListAlias.kt")
        public void testNestedCollectionAliasesUnresolvedListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedCollectionAliasesUnresolvedListAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesUnresolvedSetAlias.kt")
        public void testNestedCollectionAliasesUnresolvedSetAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedCollectionAliasesUnresolvedSetAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesUnresolvedStringAlias.kt")
        public void testNestedCollectionAliasesUnresolvedStringAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/libraries/NestedCollectionAliasesUnresolvedStringAlias.kt");
        }
      }

      @Nested
      @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources")
      @TestDataPath("$PROJECT_ROOT")
      public class Sources {
        @Test
        public void testAllFilesPresentInSources() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
        }

        @Test
        @TestMetadata("FunctionListAliasUnresolvedFunctionAlias.kt")
        public void testFunctionListAliasUnresolvedFunctionAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/FunctionListAliasUnresolvedFunctionAlias.kt");
        }

        @Test
        @TestMetadata("FunctionListAliasUnresolvedListAlias.kt")
        public void testFunctionListAliasUnresolvedListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/FunctionListAliasUnresolvedListAlias.kt");
        }

        @Test
        @TestMetadata("ListAliasUnresolvedListAlias.kt")
        public void testListAliasUnresolvedListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/ListAliasUnresolvedListAlias.kt");
        }

        @Test
        @TestMetadata("ListAliasUnresolvedStringAlias.kt")
        public void testListAliasUnresolvedStringAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/ListAliasUnresolvedStringAlias.kt");
        }

        @Test
        @TestMetadata("MyString.kt")
        public void testMyString() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/MyString.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasOnlyResolveAsymmetricAlias.kt")
        public void testNestedAsymmetricAliasOnlyResolveAsymmetricAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedAsymmetricAliasOnlyResolveAsymmetricAlias.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasOnlyResolveAsymmetricAlias2.kt")
        public void testNestedAsymmetricAliasOnlyResolveAsymmetricAlias2() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedAsymmetricAliasOnlyResolveAsymmetricAlias2.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasOnlyResolveBaseAliases.kt")
        public void testNestedAsymmetricAliasOnlyResolveBaseAliases() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedAsymmetricAliasOnlyResolveBaseAliases.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasUnresolvedAsymmetricAlias.kt")
        public void testNestedAsymmetricAliasUnresolvedAsymmetricAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedAsymmetricAliasUnresolvedAsymmetricAlias.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasUnresolvedAsymmetricAlias2.kt")
        public void testNestedAsymmetricAliasUnresolvedAsymmetricAlias2() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedAsymmetricAliasUnresolvedAsymmetricAlias2.kt");
        }

        @Test
        @TestMetadata("NestedAsymmetricAliasUnresolvedBaseAliases.kt")
        public void testNestedAsymmetricAliasUnresolvedBaseAliases() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedAsymmetricAliasUnresolvedBaseAliases.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesOnlyResolveListAlias.kt")
        public void testNestedCollectionAliasesOnlyResolveListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedCollectionAliasesOnlyResolveListAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesOnlyResolveSetAlias.kt")
        public void testNestedCollectionAliasesOnlyResolveSetAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedCollectionAliasesOnlyResolveSetAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesOnlyResolveStringAlias.kt")
        public void testNestedCollectionAliasesOnlyResolveStringAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedCollectionAliasesOnlyResolveStringAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesUnresolvedListAlias.kt")
        public void testNestedCollectionAliasesUnresolvedListAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedCollectionAliasesUnresolvedListAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesUnresolvedSetAlias.kt")
        public void testNestedCollectionAliasesUnresolvedSetAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedCollectionAliasesUnresolvedSetAlias.kt");
        }

        @Test
        @TestMetadata("NestedCollectionAliasesUnresolvedStringAlias.kt")
        public void testNestedCollectionAliasesUnresolvedStringAlias() {
          runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/missingDependency/sources/NestedCollectionAliasesUnresolvedStringAlias.kt");
        }
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/withErrors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithErrors {
      @Test
      public void testAllFilesPresentInWithErrors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("UnresolvedExpandedType.kt")
      public void testUnresolvedExpandedType() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeAlias/withErrors/UnresolvedExpandedType.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeArgument {
    @Test
    public void testAllFilesPresentInTypeArgument() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/constant")
    @TestDataPath("$PROJECT_ROOT")
    public class Constant {
      @Test
      public void testAllFilesPresentInConstant() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/constant"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("false.kt")
      public void testFalse() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/constant/false.kt");
      }

      @Test
      @TestMetadata("true.kt")
      public void testTrue() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/constant/true.kt");
      }

      @Test
      @TestMetadata("trueCall.kt")
      public void testTrueCall() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/constant/trueCall.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall")
    @TestDataPath("$PROJECT_ROOT")
    public class FunctionCall {
      @Test
      public void testAllFilesPresentInFunctionCall() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("tooFewTypeArguments1.kt")
      public void testTooFewTypeArguments1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/tooFewTypeArguments1.kt");
      }

      @Test
      @TestMetadata("tooFewTypeArguments1a.kt")
      public void testTooFewTypeArguments1a() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/tooFewTypeArguments1a.kt");
      }

      @Test
      @TestMetadata("tooFewTypeArguments2.kt")
      public void testTooFewTypeArguments2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/tooFewTypeArguments2.kt");
      }

      @Test
      @TestMetadata("tooManyTypeArguments1.kt")
      public void testTooManyTypeArguments1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/tooManyTypeArguments1.kt");
      }

      @Test
      @TestMetadata("tooManyTypeArguments1a.kt")
      public void testTooManyTypeArguments1a() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/tooManyTypeArguments1a.kt");
      }

      @Test
      @TestMetadata("tooManyTypeArguments2.kt")
      public void testTooManyTypeArguments2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/tooManyTypeArguments2.kt");
      }

      @Test
      @TestMetadata("tooManyTypeArguments2a.kt")
      public void testTooManyTypeArguments2a() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/tooManyTypeArguments2a.kt");
      }

      @Test
      @TestMetadata("unresolvedCallee1.kt")
      public void testUnresolvedCallee1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/unresolvedCallee1.kt");
      }

      @Test
      @TestMetadata("unresolvedCallee2.kt")
      public void testUnresolvedCallee2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/unresolvedCallee2.kt");
      }

      @Test
      @TestMetadata("unresolvedCalleeWithArguments1.kt")
      public void testUnresolvedCalleeWithArguments1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/unresolvedCalleeWithArguments1.kt");
      }

      @Test
      @TestMetadata("unresolvedCalleeWithArguments2.kt")
      public void testUnresolvedCalleeWithArguments2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/unresolvedCalleeWithArguments2.kt");
      }

      @Test
      @TestMetadata("upperBound1.kt")
      public void testUpperBound1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/upperBound1.kt");
      }

      @Test
      @TestMetadata("upperBound2.kt")
      public void testUpperBound2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/functionCall/upperBound2.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess")
    @TestDataPath("$PROJECT_ROOT")
    public class PropertyAccess {
      @Test
      public void testAllFilesPresentInPropertyAccess() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("localVariable1.kt")
      public void testLocalVariable1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/localVariable1.kt");
      }

      @Test
      @TestMetadata("localVariable2.kt")
      public void testLocalVariable2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/localVariable2.kt");
      }

      @Test
      @TestMetadata("parameter1.kt")
      public void testParameter1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/parameter1.kt");
      }

      @Test
      @TestMetadata("parameter2.kt")
      public void testParameter2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/parameter2.kt");
      }

      @Test
      @TestMetadata("property1.kt")
      public void testProperty1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/property1.kt");
      }

      @Test
      @TestMetadata("property2.kt")
      public void testProperty2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/property2.kt");
      }

      @Test
      @TestMetadata("propertyWithGetter1.kt")
      public void testPropertyWithGetter1() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/propertyWithGetter1.kt");
      }

      @Test
      @TestMetadata("propertyWithGetter2.kt")
      public void testPropertyWithGetter2() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/propertyWithGetter2.kt");
      }

      @Test
      @TestMetadata("unresolvedProperty.kt")
      public void testUnresolvedProperty() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/propertyAccess/unresolvedProperty.kt");
      }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/type")
    @TestDataPath("$PROJECT_ROOT")
    public class Type {
      @Test
      public void testAllFilesPresentInType() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/type"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("beforeDot.kt")
      public void testBeforeDot() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeArgument/type/beforeDot.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeParameter {
    @Test
    public void testAllFilesPresentInTypeParameter() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("multipleBounds.kt")
    public void testMultipleBounds() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/multipleBounds.kt");
    }

    @Test
    @TestMetadata("reifiedTypeParameterInBody.kt")
    public void testReifiedTypeParameterInBody() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/reifiedTypeParameterInBody.kt");
    }

    @Test
    @TestMetadata("reified_argumentInFunctionalType.kt")
    public void testReified_argumentInFunctionalType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/reified_argumentInFunctionalType.kt");
    }

    @Test
    @TestMetadata("reified_extensionReceiver.kt")
    public void testReified_extensionReceiver() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/reified_extensionReceiver.kt");
    }

    @Test
    @TestMetadata("reified_returnType.kt")
    public void testReified_returnType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/reified_returnType.kt");
    }

    @Test
    @TestMetadata("reified_valueParameter.kt")
    public void testReified_valueParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/reified_valueParameter.kt");
    }

    @Test
    @TestMetadata("reified_valueParameter_vararg.kt")
    public void testReified_valueParameter_vararg() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/reified_valueParameter_vararg.kt");
    }

    @Test
    @TestMetadata("TypeParameterInAnonymousObject.kt")
    public void testTypeParameterInAnonymousObject() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/TypeParameterInAnonymousObject.kt");
    }

    @Test
    @TestMetadata("TypeParameterInFunctionLiteral.kt")
    public void testTypeParameterInFunctionLiteral() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/TypeParameterInFunctionLiteral.kt");
    }

    @Test
    @TestMetadata("whereClause1.kt")
    public void testWhereClause1() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/whereClause1.kt");
    }

    @Test
    @TestMetadata("whereClause2.kt")
    public void testWhereClause2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/typeParameter/whereClause2.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors")
  @TestDataPath("$PROJECT_ROOT")
  public class WithErrors {
    @Test
    public void testAllFilesPresentInWithErrors() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
    }

    @Test
    @TestMetadata("ambiguous.kt")
    public void testAmbiguous() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ambiguous.kt");
    }

    @Test
    @TestMetadata("ambiguousImplicitInvoke.kt")
    public void testAmbiguousImplicitInvoke() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ambiguousImplicitInvoke.kt");
    }

    @Test
    @TestMetadata("ambiguousWithExplicitTypeParameters.kt")
    public void testAmbiguousWithExplicitTypeParameters() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ambiguousWithExplicitTypeParameters.kt");
    }

    @Test
    @TestMetadata("ambiguousWithInferredTypeParameters.kt")
    public void testAmbiguousWithInferredTypeParameters() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ambiguousWithInferredTypeParameters.kt");
    }

    @Test
    @TestMetadata("annotationOnExpression_asT.kt")
    public void testAnnotationOnExpression_asT() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/annotationOnExpression_asT.kt");
    }

    @Test
    @TestMetadata("annotationOnExpression_destructuring.kt")
    public void testAnnotationOnExpression_destructuring() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/annotationOnExpression_destructuring.kt");
    }

    @Test
    @TestMetadata("annotationOnReceiver.kt")
    public void testAnnotationOnReceiver() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/annotationOnReceiver.kt");
    }

    @Test
    @TestMetadata("AnnotationParameter.kt")
    public void testAnnotationParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/AnnotationParameter.kt");
    }

    @Test
    @TestMetadata("arrayOfInAnnotation.kt")
    public void testArrayOfInAnnotation() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/arrayOfInAnnotation.kt");
    }

    @Test
    @TestMetadata("assignementInExpression.kt")
    public void testAssignementInExpression() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/assignementInExpression.kt");
    }

    @Test
    @TestMetadata("builderInference.kt")
    public void testBuilderInference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/builderInference.kt");
    }

    @Test
    @TestMetadata("BuiltInImportsNoRuntime.kt")
    public void testBuiltInImportsNoRuntime() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/BuiltInImportsNoRuntime.kt");
    }

    @Test
    @TestMetadata("ByReturnExpression.kt")
    public void testByReturnExpression() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ByReturnExpression.kt");
    }

    @Test
    @TestMetadata("callWithUnresolvedReturnType.kt")
    public void testCallWithUnresolvedReturnType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/callWithUnresolvedReturnType.kt");
    }

    @Test
    @TestMetadata("callWithUnresolvedTypeBound.kt")
    public void testCallWithUnresolvedTypeBound() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/callWithUnresolvedTypeBound.kt");
    }

    @Test
    @TestMetadata("ClassNameBeforeDot.kt")
    public void testClassNameBeforeDot() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ClassNameBeforeDot.kt");
    }

    @Test
    @TestMetadata("ClassReferenceInIncorrectWhenClause.kt")
    public void testClassReferenceInIncorrectWhenClause() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ClassReferenceInIncorrectWhenClause.kt");
    }

    @Test
    @TestMetadata("ClassWithMultipleSuperTypeCalls.kt")
    public void testClassWithMultipleSuperTypeCalls() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ClassWithMultipleSuperTypeCalls.kt");
    }

    @Test
    @TestMetadata("CollectionLiteralLeft.kt")
    public void testCollectionLiteralLeft() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/CollectionLiteralLeft.kt");
    }

    @Test
    @TestMetadata("CollectionLiteralRight.kt")
    public void testCollectionLiteralRight() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/CollectionLiteralRight.kt");
    }

    @Test
    @TestMetadata("compoundAssignOnGenericVar.kt")
    public void testCompoundAssignOnGenericVar() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/compoundAssignOnGenericVar.kt");
    }

    @Test
    @TestMetadata("constructorCallWithSubstitution.kt")
    public void testConstructorCallWithSubstitution() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/constructorCallWithSubstitution.kt");
    }

    @Test
    @TestMetadata("constructorCallWithSubstitutionMissedType.kt")
    public void testConstructorCallWithSubstitutionMissedType() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/constructorCallWithSubstitutionMissedType.kt");
    }

    @Test
    @TestMetadata("constructorCallWithSubstitutionMissedTypeWithBound.kt")
    public void testConstructorCallWithSubstitutionMissedTypeWithBound() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/constructorCallWithSubstitutionMissedTypeWithBound.kt");
    }

    @Test
    @TestMetadata("constructorCallWithSubstitutionWrongBound.kt")
    public void testConstructorCallWithSubstitutionWrongBound() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/constructorCallWithSubstitutionWrongBound.kt");
    }

    @Test
    @TestMetadata("CoroutineSuspensionPoint.kt")
    public void testCoroutineSuspensionPoint() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/CoroutineSuspensionPoint.kt");
    }

    @Test
    @TestMetadata("DanglingAnnotations.kt")
    public void testDanglingAnnotations() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/DanglingAnnotations.kt");
    }

    @Test
    @TestMetadata("defaultValueThatCallsPreviousParameter.kt")
    public void testDefaultValueThatCallsPreviousParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/defaultValueThatCallsPreviousParameter.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorCallWithSubstitution.kt")
    public void testDelegatedConstructorCallWithSubstitution() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorCallWithSubstitution.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorCall_super.kt")
    public void testDelegatedConstructorCall_super() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorCall_super.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorCall_super_unresolved.kt")
    public void testDelegatedConstructorCall_super_unresolved() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorCall_super_unresolved.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorCall_this.kt")
    public void testDelegatedConstructorCall_this() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorCall_this.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorCall_this_unresolved.kt")
    public void testDelegatedConstructorCall_this_unresolved() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorCall_this_unresolved.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorInapplicable.kt")
    public void testDelegatedConstructorInapplicable() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorInapplicable.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorInapplicableDifferentParametersCount.kt")
    public void testDelegatedConstructorInapplicableDifferentParametersCount() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorInapplicableDifferentParametersCount.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorWithSubstitutionExtraTypeArgument.kt")
    public void testDelegatedConstructorWithSubstitutionExtraTypeArgument() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorWithSubstitutionExtraTypeArgument.kt");
    }

    @Test
    @TestMetadata("delegatedConstructorWithSubstitutionMissedTypeArgument.kt")
    public void testDelegatedConstructorWithSubstitutionMissedTypeArgument() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/delegatedConstructorWithSubstitutionMissedTypeArgument.kt");
    }

    @Test
    @TestMetadata("DeprecatedHidden.kt")
    public void testDeprecatedHidden() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/DeprecatedHidden.kt");
    }

    @Test
    @TestMetadata("enumSuperTypeInterface.kt")
    public void testEnumSuperTypeInterface() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/enumSuperTypeInterface.kt");
    }

    @Test
    @TestMetadata("ExpectSuperClassConstructorArgument.kt")
    public void testExpectSuperClassConstructorArgument() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ExpectSuperClassConstructorArgument.kt");
    }

    @Test
    @TestMetadata("ExpectSuperClassConstructorCall.kt")
    public void testExpectSuperClassConstructorCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ExpectSuperClassConstructorCall.kt");
    }

    @Test
    @TestMetadata("FakeJavaLang1.kt")
    public void testFakeJavaLang1() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/FakeJavaLang1.kt");
    }

    @Test
    @TestMetadata("FakeJavaLang2.kt")
    public void testFakeJavaLang2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/FakeJavaLang2.kt");
    }

    @Test
    @TestMetadata("FakeJavaLang3.kt")
    public void testFakeJavaLang3() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/FakeJavaLang3.kt");
    }

    @Test
    @TestMetadata("FakeJavaLang4.kt")
    public void testFakeJavaLang4() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/FakeJavaLang4.kt");
    }

    @Test
    @TestMetadata("functionCallWithNonTrailingLambdaArgument.kt")
    public void testFunctionCallWithNonTrailingLambdaArgument() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionCallWithNonTrailingLambdaArgument.kt");
    }

    @Test
    @TestMetadata("functionCallWithTooFewTypeArguments.kt")
    public void testFunctionCallWithTooFewTypeArguments() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionCallWithTooFewTypeArguments.kt");
    }

    @Test
    @TestMetadata("functionCallWithTooFewTypeArguments2.kt")
    public void testFunctionCallWithTooFewTypeArguments2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionCallWithTooFewTypeArguments2.kt");
    }

    @Test
    @TestMetadata("functionCallWithTooManyTypeArguments.kt")
    public void testFunctionCallWithTooManyTypeArguments() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionCallWithTooManyTypeArguments.kt");
    }

    @Test
    @TestMetadata("functionCallWithTooManyTypeArguments2.kt")
    public void testFunctionCallWithTooManyTypeArguments2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionCallWithTooManyTypeArguments2.kt");
    }

    @Test
    @TestMetadata("functionReceiverSubstitution.kt")
    public void testFunctionReceiverSubstitution() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionReceiverSubstitution.kt");
    }

    @Test
    @TestMetadata("functionReceiverSubstitutionWithConflict.kt")
    public void testFunctionReceiverSubstitutionWithConflict() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionReceiverSubstitutionWithConflict.kt");
    }

    @Test
    @TestMetadata("functionTypeVariableCall_extensionReceiver.kt")
    public void testFunctionTypeVariableCall_extensionReceiver() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/functionTypeVariableCall_extensionReceiver.kt");
    }

    @Test
    @TestMetadata("getterAssignment.kt")
    public void testGetterAssignment() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/getterAssignment.kt");
    }

    @Test
    @TestMetadata("hiddenConstructor.kt")
    public void testHiddenConstructor() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/hiddenConstructor.kt");
    }

    @Test
    @TestMetadata("hiddenDeprecated.kt")
    public void testHiddenDeprecated() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/hiddenDeprecated.kt");
    }

    @Test
    @TestMetadata("implicitTypeSubstituteOverrideFromOtherModule.kt")
    public void testImplicitTypeSubstituteOverrideFromOtherModule() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/implicitTypeSubstituteOverrideFromOtherModule.kt");
    }

    @Test
    @TestMetadata("InObjectClassObject.kt")
    public void testInObjectClassObject() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/InObjectClassObject.kt");
    }

    @Test
    @TestMetadata("InSecondClassObject.kt")
    public void testInSecondClassObject() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/InSecondClassObject.kt");
    }

    @Test
    @TestMetadata("incompleteCodeNoParenthesis.kt")
    public void testIncompleteCodeNoParenthesis() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/incompleteCodeNoParenthesis.kt");
    }

    @Test
    @TestMetadata("incompleteCodeNoParenthesisDotQualifier.kt")
    public void testIncompleteCodeNoParenthesisDotQualifier() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/incompleteCodeNoParenthesisDotQualifier.kt");
    }

    @Test
    @TestMetadata("incompleteCodeWithAmbiguity.kt")
    public void testIncompleteCodeWithAmbiguity() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/incompleteCodeWithAmbiguity.kt");
    }

    @Test
    @TestMetadata("incorrectCodeJavaDeclaration.kt")
    public void testIncorrectCodeJavaDeclaration() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/incorrectCodeJavaDeclaration.kt");
    }

    @Test
    @TestMetadata("indexedGetWithNotEnoughArgs.kt")
    public void testIndexedGetWithNotEnoughArgs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/indexedGetWithNotEnoughArgs.kt");
    }

    @Test
    @TestMetadata("indexedGetWithTooManyArgs.kt")
    public void testIndexedGetWithTooManyArgs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/indexedGetWithTooManyArgs.kt");
    }

    @Test
    @TestMetadata("indexedSetWithNotEnoughArgs.kt")
    public void testIndexedSetWithNotEnoughArgs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/indexedSetWithNotEnoughArgs.kt");
    }

    @Test
    @TestMetadata("indexedSetWithTooManyArgs.kt")
    public void testIndexedSetWithTooManyArgs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/indexedSetWithTooManyArgs.kt");
    }

    @Test
    @TestMetadata("invalidImplicitInvoke.kt")
    public void testInvalidImplicitInvoke() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/invalidImplicitInvoke.kt");
    }

    @Test
    @TestMetadata("InvisibleMember.kt")
    public void testInvisibleMember() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/InvisibleMember.kt");
    }

    @Test
    @TestMetadata("javaPropertyGetter_unqualified.kt")
    public void testJavaPropertyGetter_unqualified() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/javaPropertyGetter_unqualified.kt");
    }

    @Test
    @TestMetadata("javaPropertySetterIncomplete.kt")
    public void testJavaPropertySetterIncomplete() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/javaPropertySetterIncomplete.kt");
    }

    @Test
    @TestMetadata("javaPropertySetter_unqualified.kt")
    public void testJavaPropertySetter_unqualified() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/javaPropertySetter_unqualified.kt");
    }

    @Test
    @TestMetadata("kotlinPropertyGetter.kt")
    public void testKotlinPropertyGetter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/kotlinPropertyGetter.kt");
    }

    @Test
    @TestMetadata("kotlinPropertySetter.kt")
    public void testKotlinPropertySetter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/kotlinPropertySetter.kt");
    }

    @Test
    @TestMetadata("kotlinPropertySetterGeneric.kt")
    public void testKotlinPropertySetterGeneric() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/kotlinPropertySetterGeneric.kt");
    }

    @Test
    @TestMetadata("MissingTypeArgumentBeforeDot.kt")
    public void testMissingTypeArgumentBeforeDot() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/MissingTypeArgumentBeforeDot.kt");
    }

    @Test
    @TestMetadata("MissingTypeArgumentBeforeDotQualified.kt")
    public void testMissingTypeArgumentBeforeDotQualified() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/MissingTypeArgumentBeforeDotQualified.kt");
    }

    @Test
    @TestMetadata("NoSelectorInDotQualifiedCall.kt")
    public void testNoSelectorInDotQualifiedCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/NoSelectorInDotQualifiedCall.kt");
    }

    @Test
    @TestMetadata("NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt")
    public void testNoSelectorInDotQualifiedCall_ResolveInsideLambda() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt");
    }

    @Test
    @TestMetadata("NoSelectorInSafeQualifiedCall.kt")
    public void testNoSelectorInSafeQualifiedCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/NoSelectorInSafeQualifiedCall.kt");
    }

    @Test
    @TestMetadata("PackageFromAnnotationOnFileWithUnresolvedReference.kt")
    public void testPackageFromAnnotationOnFileWithUnresolvedReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/PackageFromAnnotationOnFileWithUnresolvedReference.kt");
    }

    @Test
    @TestMetadata("PackageFromAnnotationOnFunctionWithUnresolvedReference.kt")
    public void testPackageFromAnnotationOnFunctionWithUnresolvedReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/PackageFromAnnotationOnFunctionWithUnresolvedReference.kt");
    }

    @Test
    @TestMetadata("prefixUnaryOperatorOnGenericVar.kt")
    public void testPrefixUnaryOperatorOnGenericVar() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/prefixUnaryOperatorOnGenericVar.kt");
    }

    @Test
    @TestMetadata("privateMember.kt")
    public void testPrivateMember() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/privateMember.kt");
    }

    @Test
    @TestMetadata("PropertyPlaceInClassObjectInObject.kt")
    public void testPropertyPlaceInClassObjectInObject() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/PropertyPlaceInClassObjectInObject.kt");
    }

    @Test
    @TestMetadata("propertyReceiverSubstitution.kt")
    public void testPropertyReceiverSubstitution() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/propertyReceiverSubstitution.kt");
    }

    @Test
    @TestMetadata("propertyReceiverSubstitutionWithConflict.kt")
    public void testPropertyReceiverSubstitutionWithConflict() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/propertyReceiverSubstitutionWithConflict.kt");
    }

    @Test
    @TestMetadata("recursiveTypeParameter.kt")
    public void testRecursiveTypeParameter() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/recursiveTypeParameter.kt");
    }

    @Test
    @TestMetadata("resolveCallInSuperConstructorParam.kt")
    public void testResolveCallInSuperConstructorParam() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/resolveCallInSuperConstructorParam.kt");
    }

    @Test
    @TestMetadata("ResolveClassNameInCallExpression.kt")
    public void testResolveClassNameInCallExpression() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/ResolveClassNameInCallExpression.kt");
    }

    @Test
    @TestMetadata("samFromJava_lambda.kt")
    public void testSamFromJava_lambda() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/samFromJava_lambda.kt");
    }

    @Test
    @TestMetadata("samFromJava_methodReference.kt")
    public void testSamFromJava_methodReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/samFromJava_methodReference.kt");
    }

    @Test
    @TestMetadata("simpleCallWithNonMatchingArgs.kt")
    public void testSimpleCallWithNonMatchingArgs() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/simpleCallWithNonMatchingArgs.kt");
    }

    @Test
    @TestMetadata("substituteOverrideResolution.kt")
    public void testSubstituteOverrideResolution() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/substituteOverrideResolution.kt");
    }

    @Test
    @TestMetadata("superTypeCallEntryResolveToCallInfo.kt")
    public void testSuperTypeCallEntryResolveToCallInfo() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/superTypeCallEntryResolveToCallInfo.kt");
    }

    @Test
    @TestMetadata("TopLevelClassVsLocalClassQualifier.kt")
    public void testTopLevelClassVsLocalClassQualifier() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/TopLevelClassVsLocalClassQualifier.kt");
    }

    @Test
    @TestMetadata("TopLevelDestructingDeclaration.kt")
    public void testTopLevelDestructingDeclaration() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/TopLevelDestructingDeclaration.kt");
    }

    @Test
    @TestMetadata("TypeArgumentBeforeDot2.kt")
    public void testTypeArgumentBeforeDot2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/TypeArgumentBeforeDot2.kt");
    }

    @Test
    @TestMetadata("TypeArgumentUnresolvedClass.kt")
    public void testTypeArgumentUnresolvedClass() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/TypeArgumentUnresolvedClass.kt");
    }

    @Test
    @TestMetadata("TypeArgumentUnresolvedConstructor.kt")
    public void testTypeArgumentUnresolvedConstructor() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/TypeArgumentUnresolvedConstructor.kt");
    }

    @Test
    @TestMetadata("TypeArgumentWrongNumber.kt")
    public void testTypeArgumentWrongNumber() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/TypeArgumentWrongNumber.kt");
    }

    @Test
    @TestMetadata("typeParameterAsValue.kt")
    public void testTypeParameterAsValue() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/typeParameterAsValue.kt");
    }

    @Test
    @TestMetadata("typecheckerRecursiveError.kt")
    public void testTypecheckerRecursiveError() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/typecheckerRecursiveError.kt");
    }

    @Test
    @TestMetadata("unitTypeFromOtherModule.kt")
    public void testUnitTypeFromOtherModule() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/unitTypeFromOtherModule.kt");
    }

    @Test
    @TestMetadata("unresolvedReference.kt")
    public void testUnresolvedReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/unresolvedReference.kt");
    }

    @Test
    @TestMetadata("unresolvedSuperReference.kt")
    public void testUnresolvedSuperReference() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/unresolvedSuperReference.kt");
    }

    @Test
    @TestMetadata("variableAsFunctionLikeCall.kt")
    public void testVariableAsFunctionLikeCall() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/variableAsFunctionLikeCall.kt");
    }

    @Test
    @TestMetadata("variableAsFunctionWithParameterNameAnnotationConflict2.kt")
    public void testVariableAsFunctionWithParameterNameAnnotationConflict2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/variableAsFunctionWithParameterNameAnnotationConflict2.kt");
    }

    @Test
    @TestMetadata("variableWithInvokeFunctionCall_extensionReceiver.kt")
    public void testVariableWithInvokeFunctionCall_extensionReceiver() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/variableWithInvokeFunctionCall_extensionReceiver.kt");
    }

    @Test
    @TestMetadata("WrongNumberOfTypeArguments.kt")
    public void testWrongNumberOfTypeArguments() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/WrongNumberOfTypeArguments.kt");
    }

    @Test
    @TestMetadata("WrongNumberOfTypeArguments2.kt")
    public void testWrongNumberOfTypeArguments2() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/WrongNumberOfTypeArguments2.kt");
    }

    @Test
    @TestMetadata("WrongNumberOfTypeArguments3.kt")
    public void testWrongNumberOfTypeArguments3() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/WrongNumberOfTypeArguments3.kt");
    }

    @Test
    @TestMetadata("WrongNumberOfTypeArguments4.kt")
    public void testWrongNumberOfTypeArguments4() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/WrongNumberOfTypeArguments4.kt");
    }

    @Test
    @TestMetadata("WrongNumberOfTypeArgumentsInSupertype.kt")
    public void testWrongNumberOfTypeArgumentsInSupertype() {
      runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/WrongNumberOfTypeArgumentsInSupertype.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier")
    @TestDataPath("$PROJECT_ROOT")
    public class PartiallyUnresolvedTypeQualifier {
      @Test
      public void testAllFilesPresentInPartiallyUnresolvedTypeQualifier() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier"), Pattern.compile("^(.+)\\.kt$"), null, true, "withTestCompilerPluginEnabled");
      }

      @Test
      @TestMetadata("ClassNameBeforeOneUnsresolvedClass.kt")
      public void testClassNameBeforeOneUnsresolvedClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClass.kt");
      }

      @Test
      @TestMetadata("ClassNameBeforeOneUnsresolvedClassWithDot.kt")
      public void testClassNameBeforeOneUnsresolvedClassWithDot() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClassWithDot.kt");
      }

      @Test
      @TestMetadata("ClassNameBeforeOneUnsresolvedClassWithTwoResolved.kt")
      public void testClassNameBeforeOneUnsresolvedClassWithTwoResolved() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClassWithTwoResolved.kt");
      }

      @Test
      @TestMetadata("ClassNameBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt")
      public void testClassNameBeforeOneUnsresolvedClassWithTwoResolvedWithDot() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt");
      }

      @Test
      @TestMetadata("ClassNameBeforeTwoUnsresolvedClasses.kt")
      public void testClassNameBeforeTwoUnsresolvedClasses() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeTwoUnsresolvedClasses.kt");
      }

      @Test
      @TestMetadata("ClassNameBeforeTwoUnsresolvedClassesTwoResolved.kt")
      public void testClassNameBeforeTwoUnsresolvedClassesTwoResolved() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeTwoUnsresolvedClassesTwoResolved.kt");
      }

      @Test
      @TestMetadata("ClassNameBeforeTwoUnsresolvedClassesWithDot.kt")
      public void testClassNameBeforeTwoUnsresolvedClassesWithDot() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeTwoUnsresolvedClassesWithDot.kt");
      }

      @Test
      @TestMetadata("ClassNameSecondQualifierBeforeOneUnsresolvedClass.kt")
      public void testClassNameSecondQualifierBeforeOneUnsresolvedClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameSecondQualifierBeforeOneUnsresolvedClass.kt");
      }

      @Test
      @TestMetadata("ClassNameSecondQualifierBeforeOneUnsresolvedClassWithDot.kt")
      public void testClassNameSecondQualifierBeforeOneUnsresolvedClassWithDot() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameSecondQualifierBeforeOneUnsresolvedClassWithDot.kt");
      }

      @Test
      @TestMetadata("ClassNameSecondQualifierBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt")
      public void testClassNameSecondQualifierBeforeOneUnsresolvedClassWithTwoResolvedWithDot() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/ClassNameSecondQualifierBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt");
      }

      @Test
      @TestMetadata("GenericClassNameBeforeOneUnresolvedClass.kt")
      public void testGenericClassNameBeforeOneUnresolvedClass() {
        runTest("analysis/analysis-api/testData/components/resolver/singleByPsi/withErrors/partiallyUnresolvedTypeQualifier/GenericClassNameBeforeOneUnresolvedClass.kt");
      }
    }
  }
}
