/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.symbols;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.symbols.AbstractSingleSymbolByPsiTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/symbols/singleSymbolByPsi")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisScriptSourceModuleSingleSymbolByPsiTestGenerated extends AbstractSingleSymbolByPsiTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.ScriptSource,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInSingleSymbolByPsi() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/symbols/singleSymbolByPsi"), Pattern.compile("^(.+)\\.kts$"), null, true);
  }

  @Test
  @TestMetadata("functionFromScriptStatement.kts")
  public void testFunctionFromScriptStatement() {
    runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/functionFromScriptStatement.kts");
  }

  @Test
  @TestMetadata("topLevelScriptFunction.kts")
  public void testTopLevelScriptFunction() {
    runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/topLevelScriptFunction.kts");
  }

  @Test
  @TestMetadata("variableFromScriptStatement.kts")
  public void testVariableFromScriptStatement() {
    runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/variableFromScriptStatement.kts");
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/symbols/singleSymbolByPsi/contracts")
  @TestDataPath("$PROJECT_ROOT")
  public class Contracts {
    @Test
    public void testAllFilesPresentInContracts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/symbols/singleSymbolByPsi/contracts"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/symbols/singleSymbolByPsi/destructuring")
  @TestDataPath("$PROJECT_ROOT")
  public class Destructuring {
    @Test
    public void testAllFilesPresentInDestructuring() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/symbols/singleSymbolByPsi/destructuring"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }

    @Test
    @TestMetadata("entryInScriptDestructuringDeclaration.kts")
    public void testEntryInScriptDestructuringDeclaration() {
      runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/destructuring/entryInScriptDestructuringDeclaration.kts");
    }

    @Test
    @TestMetadata("entryInScriptDestructuringDeclarationMutable.kts")
    public void testEntryInScriptDestructuringDeclarationMutable() {
      runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/destructuring/entryInScriptDestructuringDeclarationMutable.kts");
    }

    @Test
    @TestMetadata("entryUnderscoreInScriptDestructuringDeclaration.kts")
    public void testEntryUnderscoreInScriptDestructuringDeclaration() {
      runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/destructuring/entryUnderscoreInScriptDestructuringDeclaration.kts");
    }

    @Test
    @TestMetadata("scriptDestructuringDeclaration.kts")
    public void testScriptDestructuringDeclaration() {
      runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/destructuring/scriptDestructuringDeclaration.kts");
    }

    @Test
    @TestMetadata("scriptDestructuringDeclarationMutable.kts")
    public void testScriptDestructuringDeclarationMutable() {
      runTest("analysis/analysis-api/testData/symbols/singleSymbolByPsi/destructuring/scriptDestructuringDeclarationMutable.kts");
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/symbols/singleSymbolByPsi/errors")
  @TestDataPath("$PROJECT_ROOT")
  public class Errors {
    @Test
    public void testAllFilesPresentInErrors() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/symbols/singleSymbolByPsi/errors"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/symbols/singleSymbolByPsi/withTestCompilerPluginEnabled")
  @TestDataPath("$PROJECT_ROOT")
  public class WithTestCompilerPluginEnabled {
    @Test
    public void testAllFilesPresentInWithTestCompilerPluginEnabled() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/symbols/singleSymbolByPsi/withTestCompilerPluginEnabled"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }
  }
}
