/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.typeProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeProvider.AbstractTypeReferenceTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/typeProvider/typeReference")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleTypeReferenceTestGenerated extends AbstractTypeReferenceTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInTypeReference() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/typeProvider/typeReference"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("annotationEntry.kt")
  public void testAnnotationEntry() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationEntry.kt");
  }

  @Test
  @TestMetadata("annotationEntryBackingField.kt")
  public void testAnnotationEntryBackingField() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationEntryBackingField.kt");
  }

  @Test
  @TestMetadata("annotationEntryGetter.kt")
  public void testAnnotationEntryGetter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationEntryGetter.kt");
  }

  @Test
  @TestMetadata("annotationEntryOnParameter.kt")
  public void testAnnotationEntryOnParameter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationEntryOnParameter.kt");
  }

  @Test
  @TestMetadata("annotationEntrySetter.kt")
  public void testAnnotationEntrySetter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationEntrySetter.kt");
  }

  @Test
  @TestMetadata("annotationOnFunction.kt")
  public void testAnnotationOnFunction() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationOnFunction.kt");
  }

  @Test
  @TestMetadata("annotationParameterValue.kt")
  public void testAnnotationParameterValue() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationParameterValue.kt");
  }

  @Test
  @TestMetadata("annotationParameterValueBackingField.kt")
  public void testAnnotationParameterValueBackingField() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/annotationParameterValueBackingField.kt");
  }

  @Test
  @TestMetadata("catchParameterType_error.kt")
  public void testCatchParameterType_error() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/catchParameterType_error.kt");
  }

  @Test
  @TestMetadata("catchParameterType_typealias.kt")
  public void testCatchParameterType_typealias() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/catchParameterType_typealias.kt");
  }

  @Test
  @TestMetadata("functionReceiver.kt")
  public void testFunctionReceiver() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/functionReceiver.kt");
  }

  @Test
  @TestMetadata("functionReturn.kt")
  public void testFunctionReturn() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/functionReturn.kt");
  }

  @Test
  @TestMetadata("propertyReceiver.kt")
  public void testPropertyReceiver() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/propertyReceiver.kt");
  }

  @Test
  @TestMetadata("propertyReturn.kt")
  public void testPropertyReturn() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/propertyReturn.kt");
  }

  @Test
  @TestMetadata("starProjection.kt")
  public void testStarProjection() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/starProjection.kt");
  }

  @Test
  @TestMetadata("superTypeEntry.kt")
  public void testSuperTypeEntry() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/superTypeEntry.kt");
  }

  @Test
  @TestMetadata("superTypeEntry_withTypeArgument.kt")
  public void testSuperTypeEntry_withTypeArgument() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/superTypeEntry_withTypeArgument.kt");
  }

  @Test
  @TestMetadata("typeArgument_functionCall.kt")
  public void testTypeArgument_functionCall() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/typeArgument_functionCall.kt");
  }

  @Test
  @TestMetadata("typeArgument_superTypeEntry.kt")
  public void testTypeArgument_superTypeEntry() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/typeArgument_superTypeEntry.kt");
  }

  @Test
  @TestMetadata("underscoreTypeArgument_inferred.kt")
  public void testUnderscoreTypeArgument_inferred() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/underscoreTypeArgument_inferred.kt");
  }

  @Test
  @TestMetadata("underscoreTypeArgument_reified.kt")
  public void testUnderscoreTypeArgument_reified() {
    runTest("analysis/analysis-api/testData/components/typeProvider/typeReference/underscoreTypeArgument_reified.kt");
  }
}
