/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.symbolInfoProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.symbolInfoProvider.AbstractCanBeOperatorTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/symbolInfoProvider/canBeOperator")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleCanBeOperatorTestGenerated extends AbstractCanBeOperatorTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInCanBeOperator() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/symbolInfoProvider/canBeOperator"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("alreadyOperator.kt")
  public void testAlreadyOperator() {
    runTest("analysis/analysis-api/testData/components/symbolInfoProvider/canBeOperator/alreadyOperator.kt");
  }

  @Test
  @TestMetadata("canBeOperator.kt")
  public void testCanBeOperator() {
    runTest("analysis/analysis-api/testData/components/symbolInfoProvider/canBeOperator/canBeOperator.kt");
  }

  @Test
  @TestMetadata("doesntMeetRequirements.kt")
  public void testDoesntMeetRequirements() {
    runTest("analysis/analysis-api/testData/components/symbolInfoProvider/canBeOperator/doesntMeetRequirements.kt");
  }

  @Test
  @TestMetadata("notOperatorName.kt")
  public void testNotOperatorName() {
    runTest("analysis/analysis-api/testData/components/symbolInfoProvider/canBeOperator/notOperatorName.kt");
  }

  @Test
  @TestMetadata("overrideOperator.kt")
  public void testOverrideOperator() {
    runTest("analysis/analysis-api/testData/components/symbolInfoProvider/canBeOperator/overrideOperator.kt");
  }
}
